/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira;

import com.atlassian.oauth.client.JiraOAuthClient;
import com.atlassian.oauth.client.PropertiesClient;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.http.GenericUrl;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;

public class JiraOauthUtil {
    private static PropertiesClient propertiesClient = new PropertiesClient();
    private static JiraOAuthClient jiraOAuthClient = new JiraOAuthClient(propertiesClient);

    public static Map<String, String> getTempTokenMap(String consumerKey, String privateKey, String authorizationUrl, String requestTokenUrl, String tokenAuthorizedUrl) throws Exception {
        Map tokens = jiraOAuthClient.getAndAuthorizeTemporaryTokenMap(consumerKey, privateKey, authorizationUrl, requestTokenUrl, tokenAuthorizedUrl);
        return tokens;
    }

    public static String getAccessToken(String oauthToken, String oauthVerfier, String consumerKey, String privateKey, String accessTokenUrl, String tokenAuthorizedUrl) {
        try {
            return jiraOAuthClient.getAccessToken(oauthToken, oauthVerfier, consumerKey, privateKey, accessTokenUrl, tokenAuthorizedUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAuthorizationHeader(String accessToken, String oauthToken, String oauthVerfier, String consumerKey, String privateKey, String jiraApiUrl, String reqType, String accessTokenUrl, String tokenAuthorizedUrl) {
        try {
            OAuthParameters parameters = jiraOAuthClient.getParameters(accessToken, oauthVerfier, consumerKey, privateKey, accessTokenUrl);
            parameters.computeNonce();
            parameters.computeTimestamp();
            try {
                parameters.computeSignature(reqType, new GenericUrl(jiraApiUrl), tokenAuthorizedUrl);
                return parameters.getAuthorizationHeader();
            }
            catch (GeneralSecurityException e) {
                IOException io = new IOException();
                io.initCause(e);
                throw io;
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

