/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe;

import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import com.viztrend.safe.persistence.repository.ConfigRepository;
import com.viztrend.safe.persistence.repository.TokenRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class UserContextMock {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private TokenRepository tokenRepository;
    @Autowired
    private ConfigRepository configRepository;
    @Autowired
    private Environment env;

    public void setUserContext(String userName) {
        SecureUser secureUser = this.getUserContext(userName);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)secureUser, (Object)AuthorityUtils.createAuthorityList((String[])new String[]{"ADMIN", "ACTUATOR"})));
    }

    public SecureUser getUserContext(String userName) {
        SecureUser secureUser = null;
        UserContextDTO userContext = new UserContextDTO();
        User user = this.userRepository.findByUserNameIgnoreCase(userName);
        if (user != null && user.getIsActive().booleanValue()) {
            if (user.getPassword() == null) {
                user.setPassword(UUID.randomUUID().toString());
            }
            secureUser = new SecureUser(user.getUserName(), user.getPassword());
            userContext.getContextMap().put("user", user);
            List userCompanyList = user.getUserCompanies();
            ArrayList<Company> companies = new ArrayList<Company>();
            if (PropertyValidator.isValid((Collection)userCompanyList)) {
                for (UserCompany uc : userCompanyList) {
                    if (uc.getCompany().isArchive()) continue;
                    companies.add(uc.getCompany());
                }
            }
            userContext.getContextMap().put("tenant", ((Company)companies.get(0)).getTenant());
            userContext.getContextMap().put("urlPrefix", ((Company)companies.get(0)).getUrlPrefix());
            userContext.getContextMap().put("companies", companies);
            userContext.getContextMap().put("urlScheme", this.env.getProperty("redirect.from.http.server.port") != null ? "https" : "http");
            userContext.getContextMap().put("serverDomain", this.env.getProperty("server.domain"));
            userContext.getContextMap().put("isLocalDeployment", this.env.getProperty("isLocalDeployment"));
            secureUser.setUserContextDTO(userContext);
        }
        return secureUser;
    }
}

