/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.exception;

import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.utils.PropertyValidator;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViztrendJiraException
extends RuntimeException {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViztrendJiraException.class);
    private static final long serialVersionUID = 4944554273626776268L;
    private Integer code;
    private String message;
    private AlmError almError;

    public ViztrendJiraException(Integer code) {
        this.code = code;
        LOGGER.error(this.message);
    }

    public ViztrendJiraException(Integer code, String message) {
        super(message);
        this.code = code;
        LOGGER.error(message);
        if (code != null && (code == 401 || code == 404)) {
            message = Jsoup.clean((String)message, (Whitelist)Whitelist.relaxed().addTags(new String[]{"<script>"}));
        }
        this.message = message;
    }

    public ViztrendJiraException(boolean skipPrint, Integer code, String message) {
        super(message);
        this.code = code;
        this.message = message;
    }

    public ViztrendJiraException(Integer code, String message, AlmError almError) {
        this.code = code;
        String print = "";
        print = almError != null && almError.getEndPoint() != null ? almError.getEndPoint() + " :: " + message : message;
        if (code != null && (code == 401 || code == 404)) {
            message = Jsoup.clean((String)message, (Whitelist)Whitelist.relaxed().addTags(new String[]{"<script>"}));
            if (almError != null && almError.getAlmErrorMessage() != null) {
                String error;
                print = error = almError.getAlmErrorMessage();
                almError.setAlmErrorMessage(Jsoup.clean((String)almError.getAlmErrorMessage(), (Whitelist)Whitelist.relaxed().addTags(new String[]{"<script>"})));
            }
        }
        if (PropertyValidator.isValid((Object)print) && print.length() > 1000) {
            print = print.substring(0, 1000);
        }
        LOGGER.error(print);
        this.message = message;
        this.almError = almError;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public AlmError getAlmError() {
        return this.almError;
    }

    public void setAlmError(AlmError almError) {
        this.almError = almError;
    }
}

