/*
 * Decompiled with CFR 0.152.
 */
package com.okta.saml.util;

import com.okta.saml.Application;
import com.okta.saml.Configuration;
import com.okta.saml.SAMLResponse;
import com.okta.saml.SAMLValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.opensaml.ws.security.SecurityPolicyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OktaAuthPeer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OktaAuthPeer.class);
    private String loggedInKey;
    private String loggedOutKey;
    private String configFilePath;
    private SAMLValidator validator;
    private Configuration configuration;
    private Application defaultApplication;
    private List<String> filteredHeaders;

    public OktaAuthPeer(String configFilePath, String loggedInKey, String loggedOutKey) throws SecurityPolicyException, IOException {
        this.init(configFilePath, loggedInKey, loggedOutKey);
    }

    public OktaAuthPeer() {
    }

    public void init(String configFilePath, String loggedInKey, String loggedOutKey) throws SecurityPolicyException, IOException {
        this.loggedInKey = loggedInKey;
        this.loggedOutKey = loggedOutKey;
        this.configFilePath = configFilePath;
        String file = this.readFile(configFilePath);
        this.validator = new SAMLValidator();
        this.configuration = this.validator.getConfiguration(file);
        for (Application application : this.configuration.getApplications().values()) {
            if (this.defaultApplication != null) continue;
            this.defaultApplication = application;
        }
    }

    public void putPrincipalInSessionContext(HttpServletRequest request, Principal principal) {
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute(this.loggedInKey, (Object)principal);
        httpSession.setAttribute(this.loggedOutKey, null);
    }

    public boolean isPrincipalAlreadyInSessionContext(HttpServletRequest request, Principal principal) {
        Principal currentPrincipal = (Principal)request.getSession().getAttribute(this.loggedInKey);
        return currentPrincipal != null && currentPrincipal.getName() != null && principal != null && currentPrincipal.getName().equals(principal.getName());
    }

    public void removePrincipalFromSessionContext(HttpServletRequest request) {
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute(this.loggedInKey, null);
        httpSession.setAttribute(this.loggedOutKey, (Object)Boolean.TRUE);
    }

    public Principal getUserPrincipal(SAMLResponse response) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(String path) throws IOException {
        try (FileInputStream stream = new FileInputStream(new File(path));){
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.forName("UTF-8").decode(bb).toString();
            return string;
        }
    }

    public String getAuthRedirectUrl(String redirectUrl, String relayState) {
        if (!redirectUrl.contains("RelayState") && relayState != null && !relayState.isEmpty()) {
            try {
                relayState = URLEncoder.encode(relayState, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.warn("Error while encoding relayState = " + relayState);
            }
            redirectUrl = redirectUrl.contains("?") ? redirectUrl + "&" : redirectUrl + "?";
            redirectUrl = redirectUrl + "RelayState=" + relayState;
        }
        return redirectUrl;
    }

    public SAMLResponse getSAMLResponse(String assertion) throws UnsupportedEncodingException, SecurityPolicyException {
        assertion = new String(Base64.decodeBase64((byte[])assertion.getBytes("UTF-8")), Charset.forName("UTF-8"));
        return this.getValidator().getSAMLResponse(assertion, this.getConfiguration());
    }

    public SAMLValidator getValidator() {
        return this.validator;
    }

    public void setValidator(SAMLValidator validator) {
        this.validator = validator;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Application getDefaultApplication() {
        return this.defaultApplication;
    }

    public void setDefaultApplication(Application defaultApplication) {
        this.defaultApplication = defaultApplication;
    }

    public Principal getPrincipalFromSession(HttpServletRequest request) {
        if (request.getSession().getAttribute(this.loggedOutKey) != null) {
            return null;
        }
        return (Principal)request.getSession().getAttribute(this.loggedInKey);
    }

    public List<String> getFilteredHeaders() {
        return this.filteredHeaders;
    }

    public void setFilteredHeaders(List<String> filteredHeaders) {
        this.filteredHeaders = filteredHeaders;
    }

    public boolean shouldHandleRequest(HttpServletRequest request) {
        if (this.filteredHeaders == null) {
            return true;
        }
        String reqUrl = request.getRequestURL().toString();
        if (reqUrl.contains("/ForgotLoginDetails/") || reqUrl.contains("/rest/")) {
            return false;
        }
        for (String headerName : this.filteredHeaders) {
            String header = request.getHeader(headerName);
            if (header == null || header.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isSPUser(HttpServletRequest request, String username, Collection<String> uGroups) {
        return !this.isIpAllowedForOkta(request) || !this.isUsernameAllowedForOkta(username) || this.isInSPGroups(uGroups);
    }

    public boolean isIpAllowedForOkta(String ip) {
        return this.getConfiguration().isIpAllowedForOkta(ip);
    }

    public boolean isIpAllowedForOkta(HttpServletRequest request) {
        return this.isIpAllowedForOkta(request.getRemoteAddr());
    }

    public boolean isSPUserOrGroupNamesUsed() {
        return this.getConfiguration().isSPUsernamesUsed() || this.getConfiguration().isSPGroupnamesUsed();
    }

    private boolean isUsernameAllowedForOkta(String username) {
        return this.getConfiguration().isUsernameAllowedForOkta(username);
    }

    private boolean isInSPGroups(Collection<String> userGroups) {
        return this.getConfiguration().isInSPGroups(userGroups);
    }

    public boolean isInSPUrls(String url) {
        if (StringUtils.isBlank((String)url)) {
            return false;
        }
        return this.getConfiguration().isInSPUrls(url);
    }
}

