/*
 * Decompiled with CFR 0.152.
 */
package com.okta.saml.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.util.IPAddressUtil;

public class IPRange {
    private String[] startAddress;
    private String[] endAddress;
    private static final Logger LOGGER = LoggerFactory.getLogger(IPRange.class);

    public IPRange(String startAddress, String endAddress) {
        this.validateIp(startAddress);
        this.startAddress = this.parseAddressString(startAddress);
        if (endAddress != null && !endAddress.trim().isEmpty()) {
            this.validateIp(endAddress);
            this.endAddress = this.parseAddressString(endAddress);
        }
    }

    public void validateIp(String ip) {
        boolean valid = true;
        String[] parts = this.parseAddressString(ip);
        if (parts == null) {
            throw new NumberFormatException(String.format("Failed to parse address %s", ip));
        }
        for (String item : parts) {
            if (StringUtils.isNumeric((CharSequence)item)) {
                int val = Integer.parseInt(item);
                if (val >= 0 && val <= 255) continue;
                valid = false;
                continue;
            }
            if (StringUtils.equals((CharSequence)item, (CharSequence)"*")) continue;
            valid = false;
        }
        if (!valid) {
            throw new NumberFormatException(String.format("All IP address segments should be from 0 to 255 or *, %s provided", ip));
        }
    }

    public String[] parseAddressString(String address) {
        String[] retVal = new String[4];
        if (IPAddressUtil.isIPv6LiteralAddress(address)) {
            LOGGER.error(String.format("IPv6 address provided: %s, IP range mechanism will not be available.", address));
            return null;
        }
        StrTokenizer tok = new StrTokenizer(address, ".");
        int i = 0;
        while (tok.hasNext()) {
            retVal[i++] = tok.next();
        }
        return retVal;
    }

    public boolean isAddressInRange(String address) {
        String[] startAddress = this.getStartAddress();
        String[] endAddress = this.getEndAddress();
        String[] testAddress = this.parseAddressString(address);
        this.validateIp(address);
        if (null == endAddress) {
            for (int iPos = 0; iPos < 4; ++iPos) {
                if (StringUtils.equals((CharSequence)startAddress[iPos], (CharSequence)"*") || StringUtils.equals((CharSequence)startAddress[iPos], (CharSequence)testAddress[iPos])) continue;
                return false;
            }
        } else {
            for (int iPos = 0; iPos < 4; ++iPos) {
                int startValue = StringUtils.equals((CharSequence)startAddress[iPos], (CharSequence)"*") ? 0 : Integer.parseInt(startAddress[iPos]);
                int endValue = StringUtils.equals((CharSequence)endAddress[iPos], (CharSequence)"*") ? 255 : Integer.parseInt(endAddress[iPos]);
                int testAddressValue = Integer.parseInt(testAddress[iPos]);
                if (testAddressValue >= startValue && testAddressValue <= endValue) continue;
                return false;
            }
        }
        return true;
    }

    public String[] getStartAddress() {
        return this.startAddress;
    }

    public void setStartAddress(String[] startAddress) {
        this.startAddress = startAddress;
    }

    public String[] getEndAddress() {
        return this.endAddress;
    }

    public void setEndAddress(String[] endAddress) {
        this.endAddress = endAddress;
    }
}

