/*
 * Decompiled with CFR 0.152.
 */
package com.okta.saml.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    private static final Pattern STATIC_URL_PATTERN = Pattern.compile("([^\\s]+(\\.(?i)(jpg|jpeg|png|gif|bmp|css|js)))");

    public static void forceRedirect(HttpServletRequest request, HttpServletResponse response, String redirUrl) {
        if (response == null) {
            return;
        }
        String reqUrl = request.getRequestURL().toString();
        String contentType = response.getContentType();
        if (contentType != null && !contentType.contains("html") || STATIC_URL_PATTERN.matcher(reqUrl).matches() || reqUrl.endsWith(redirUrl) || reqUrl.equals(redirUrl)) {
            return;
        }
        try {
            response.reset();
            response.setStatus(302);
            response.setHeader("Location", redirUrl);
            response.setHeader("Connection", "close");
            response.flushBuffer();
        }
        catch (IOException e) {
            LOGGER.error("IO Error: " + e.getMessage());
        }
    }

    public static String getCurrentUrl(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        StringBuffer url = request.getRequestURL();
        if (request.getQueryString() != null) {
            url.append('?');
            url.append(request.getQueryString());
        }
        return url.toString();
    }

    public static String createRedirectUrlWithRelay(HttpServletRequest request, String url, String relayStateParam) {
        String curUrl = HttpUtil.getCurrentUrl((HttpServletRequest)request);
        String redirectUrl = url;
        if (!curUrl.contains(relayStateParam) && !curUrl.endsWith(url)) {
            redirectUrl = String.format("%s" + (url.contains("?") ? "&" : "?") + "%s=%s", url, relayStateParam, curUrl);
        }
        return redirectUrl;
    }

    public static void forceRedirectWithRelayState(HttpServletRequest request, HttpServletResponse response, String redirectUrl, String relayStateParam) throws IOException {
        HttpUtil.forceRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)HttpUtil.createRedirectUrlWithRelay((HttpServletRequest)request, (String)redirectUrl, (String)relayStateParam));
    }

    public static void redirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(url);
        }
        catch (IOException ioException) {
            LOGGER.info("Redirection failed using sendRedirect() method, trying setting Location header");
            response.setStatus(302);
            response.setHeader("Location", url);
        }
    }

    public static String getRedirectParam(HttpServletRequest request) {
        String redirectUrl = request.getParameter("os_destination");
        if (StringUtils.isBlank((String)redirectUrl)) {
            return null;
        }
        redirectUrl = redirectUrl.trim().replaceAll("[\\\\/]+$", "");
        try {
            String baseUrl = HttpUtil.getBaseUrl((String)HttpUtil.getCurrentUrl((HttpServletRequest)request)).replaceAll("[\\\\/]+$", "");
            if (baseUrl.equalsIgnoreCase(redirectUrl)) {
                return null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return redirectUrl;
    }

    public static String getBaseUrl(String fullUrl) throws MalformedURLException {
        URL url = new URL(fullUrl);
        String baseUrl = String.format("%s://%s", url.getProtocol(), url.getHost());
        if (url.getPort() > 0) {
            baseUrl = baseUrl + ":" + url.getPort();
        }
        return baseUrl;
    }

    public static void commitResponse(HttpServletResponse response) {
        if (response != null && !response.isCommitted()) {
            try {
                if (response.getWriter() != null) {
                    response.getWriter().flush();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to commit response", (Throwable)e);
            }
        }
    }
}

