/*
 * Decompiled with CFR 0.152.
 */
package com.okta.saml;

import com.google.inject.Inject;
import com.okta.saml.Application;
import com.okta.saml.Configuration;
import com.okta.saml.util.Clock;
import com.okta.saml.util.SimpleClock;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.validator.ResponseSchemaValidator;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SAMLResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAMLResponse.class);
    private final Clock clock;
    private final Response response;
    private final Assertion assertion;
    private final Configuration configuration;
    private final Application app;
    private final Map<String, List<String>> attributes;

    public SAMLResponse(String responseString, Configuration configuration) throws SecurityPolicyException {
        this(responseString, configuration, (Clock)new SimpleClock());
    }

    @Inject
    private SAMLResponse(String responseString, Configuration configuration, Clock clock) throws SecurityPolicyException {
        this.clock = clock;
        this.configuration = configuration;
        this.response = this.validatedResponse(responseString);
        this.app = configuration.getDefaultApplication();
        this.assertion = this.validatedAssertion(this.response);
        this.attributes = this.loadedAttributes();
        this.validateSignature();
    }

    private HashMap<String, List<String>> loadedAttributes() {
        HashMap<String, List<String>> attributes = new HashMap<String, List<String>>();
        for (AttributeStatement attributeStatement : this.assertion.getAttributeStatements()) {
            for (Attribute attr : attributeStatement.getAttributes()) {
                if (attr.getAttributeValues().size() < 1) continue;
                ArrayList<String> values = new ArrayList<String>();
                for (XMLObject value : attr.getAttributeValues()) {
                    values.add(value.getDOM().getTextContent());
                }
                attributes.put(attr.getName(), values);
            }
        }
        return attributes;
    }

    private void validateSignature() throws SecurityPolicyException {
        SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
        SignatureValidator signatureValidator = new SignatureValidator(this.app.getCertificate().getCredential());
        Signature signature = ((Assertion)this.response.getAssertions().get(0)).getSignature();
        if (signature == null && (signature = this.response.getSignature()) == null) {
            throw new SecurityPolicyException("No signature present");
        }
        try {
            profileValidator.validate(signature);
            signatureValidator.validate(signature);
        }
        catch (ValidationException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new SecurityPolicyException("Invalid signature");
        }
    }

    private Response validatedResponse(String assertion) throws SecurityPolicyException {
        String statusCode;
        Response response;
        try {
            XMLObject parsedResponse = this.parseSAML(assertion);
            if (!Response.class.isInstance(parsedResponse)) {
                LOGGER.debug("Parsed response did not result in a Response node: " + parsedResponse.getElementQName());
                throw new SecurityPolicyException("Malformatted response");
            }
            response = (Response)parsedResponse;
            new ResponseSchemaValidator().validate(response);
        }
        catch (ValidationException e) {
            throw new SecurityPolicyException("Invalid response");
        }
        String issuer = response.getIssuer().getValue();
        if (this.configuration.getApplication(issuer) == null) {
            LOGGER.debug("Configuration does not contain issuer: " + issuer);
        }
        if (!StringUtils.equals((CharSequence)(statusCode = response.getStatus().getStatusCode().getValue()), (CharSequence)"urn:oasis:names:tc:SAML:2.0:status:Success")) {
            LOGGER.debug("StatusCode was not a success: " + statusCode);
            throw new SecurityPolicyException("StatusCode was not a success");
        }
        return response;
    }

    private Assertion validatedAssertion(Response response) throws SecurityPolicyException {
        List assertionList = response.getAssertions();
        if (assertionList.isEmpty()) {
            throw new SecurityPolicyException("No assertions found");
        }
        if (assertionList.size() > 1) {
            throw new SecurityPolicyException("More than one assertion was found");
        }
        Assertion assertion = (Assertion)assertionList.get(0);
        Conditions conditions = assertion.getConditions();
        long ONE_MINUTE_IN_MILLIS = 1000L;
        Calendar date = Calendar.getInstance();
        long t = date.getTimeInMillis();
        Date now = new Date(t + 3L * ONE_MINUTE_IN_MILLIS);
        Date conditionNotBefore = conditions.getNotBefore().toDate();
        Date conditionNotOnOrAfter = conditions.getNotOnOrAfter().toDate();
        if (now.before(conditionNotBefore)) {
            LOGGER.debug("Current time: [" + now + "] NotBefore: [" + conditionNotBefore + "]");
            throw new SecurityPolicyException("Conditions are not yet active");
        }
        if (now.after(conditionNotOnOrAfter) || now.equals(conditionNotOnOrAfter)) {
            LOGGER.debug("Current time: [" + now + "] NotOnOrAfter: [" + conditionNotOnOrAfter + "]");
            throw new SecurityPolicyException("Conditions have expired");
        }
        return assertion;
    }

    public String getUserID() {
        return this.assertion.getSubject().getNameID().getValue();
    }

    public String getIssuer() {
        return this.response.getIssuer().getValue();
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public String getDestination() {
        return this.response.getDestination();
    }

    public String getRecipient() {
        return ((SubjectConfirmation)this.assertion.getSubject().getSubjectConfirmations().get(0)).getSubjectConfirmationData().getRecipient();
    }

    public String getAudience() {
        return ((Audience)((AudienceRestriction)this.assertion.getConditions().getAudienceRestrictions().get(0)).getAudiences().get(0)).getAudienceURI();
    }

    public Date getIssueInstant() {
        return this.response.getIssueInstant().toDate();
    }

    private XMLObject parseSAML(String response) throws SecurityPolicyException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(response.getBytes("UTF-8"));
            Element root = new BasicParserPool().parse((InputStream)bais).getDocumentElement();
            return org.opensaml.Configuration.getUnmarshallerFactory().getUnmarshaller(root).unmarshall(root);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new SecurityPolicyException("Problem parsing the response.");
        }
    }
}

