/*
 * Decompiled with CFR 0.152.
 */
package com.okta.saml;

import com.google.inject.Inject;
import com.okta.saml.Application;
import com.okta.saml.util.Clock;
import com.okta.saml.util.Identifier;
import com.okta.saml.util.SimpleClock;
import com.okta.saml.util.UUIDIdentifer;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml2.core.impl.NameIDBuilder;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class SAMLLogoutRequest {
    private final LogoutRequest request;

    public SAMLLogoutRequest(Application application, boolean setConsumerServiceURL, String authnContextClassRef, String samlUserId) {
        this(application, (Identifier)new UUIDIdentifer(), (Clock)new SimpleClock(), setConsumerServiceURL, authnContextClassRef, samlUserId);
    }

    @Inject
    private SAMLLogoutRequest(Application application, Identifier identifier, Clock clock, boolean setConsumerServiceURL, String authnContextClassRefValue, String samlUserId) {
        this.request = SAMLLogoutRequest.buildLogoutRequest((String)application.getConfig().getIdentityProviderSingleSignOut(), (String)application.getIssuer(), (String)samlUserId, (Identifier)identifier);
    }

    public static LogoutRequest buildLogoutRequest(String logoutUrl, String spId, String nameIdString, Identifier identifier) {
        Issuer issuer = new IssuerBuilder().buildObject();
        issuer.setValue(spId);
        NameID nameID = new NameIDBuilder().buildObject();
        nameID.setValue(nameIdString);
        LogoutRequest logoutRequest = new LogoutRequestBuilder().buildObject();
        logoutRequest.setID(identifier.getId());
        logoutRequest.setDestination(logoutUrl);
        logoutRequest.setVersion(SAMLVersion.VERSION_20);
        logoutRequest.setIssueInstant(new DateTime());
        logoutRequest.setIssuer(issuer);
        logoutRequest.setNameID(nameID);
        return logoutRequest;
    }

    public static String generateSecureRandomId() {
        return new BigInteger(160, new SecureRandom()).toString(32);
    }

    private <T extends SAMLObject> T build(QName qName) {
        return (T)((SAMLObject)Configuration.getBuilderFactory().getBuilder(qName).buildObject(qName));
    }

    public String toString() {
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)this.request);
            Element dom = marshaller.marshall((XMLObject)this.request);
            StringWriter stringWriter = new StringWriter();
            XMLHelper.writeNode((Node)dom, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public LogoutRequest getLogoutRequest() {
        return this.request;
    }
}

