/*
 * Decompiled with CFR 0.152.
 */
package com.okta.saml;

import com.okta.saml.Certificate;
import com.viztrend.safe.persistence.entity.SAMLConfig;
import java.security.cert.CertificateException;
import org.opensaml.Configuration;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.keyinfo.KeyInfoHelper;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);
    private EntityDescriptor descriptor;
    private SingleSignOnService ssoPost;
    private SingleLogoutService singleLogoutService;
    private Certificate certificate;
    private SAMLConfig config;
    private String destination;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Application(Element application) throws SecurityPolicyException {
        try {
            EntityDescriptor descriptor;
            Element entity = (Element)application.getElementsByTagName("md:EntityDescriptor").item(0);
            XMLObject root = Configuration.getUnmarshallerFactory().getUnmarshaller(entity).unmarshall(entity);
            this.descriptor = descriptor = (EntityDescriptor)root;
            IDPSSODescriptor idpSSO = descriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
            for (SingleSignOnService sso : idpSSO.getSingleSignOnServices()) {
                if (!sso.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
                this.ssoPost = sso;
            }
            for (SingleSignOnService sso : idpSSO.getSingleLogoutServices()) {
                if (!sso.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) continue;
                this.singleLogoutService = sso;
            }
            for (KeyDescriptor keyDescriptor : idpSSO.getKeyDescriptors()) {
                if (!keyDescriptor.getUse().equals((Object)UsageType.SIGNING)) continue;
                try {
                    X509Certificate x509Cert = (X509Certificate)((X509Data)keyDescriptor.getKeyInfo().getX509Datas().get(0)).getX509Certificates().get(0);
                    this.certificate = new Certificate(KeyInfoHelper.getCertificate((X509Certificate)x509Cert));
                    return;
                }
                catch (NullPointerException e) {
                    throw new SecurityPolicyException("X509Certificate field is missing from the configuration file");
                    return;
                }
            }
        }
        catch (UnmarshallingException e) {
            LOGGER.debug(e.getMessage());
            throw new SecurityPolicyException("There was a problem while parsing EntityDescriptor from the configuration file");
        }
        catch (CertificateException e) {
            LOGGER.debug(e.getMessage());
            throw new SecurityPolicyException("There's a problem with the certificate");
        }
    }

    public String getIssuer() {
        return this.descriptor.getEntityID();
    }

    public String getAuthenticationURL() {
        return this.ssoPost.getLocation();
    }

    public String getLogoutURL() {
        return this.singleLogoutService.getLocation();
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public SAMLConfig getConfig() {
        return this.config;
    }

    public void setConfig(SAMLConfig config) {
        this.config = config;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }
}

