/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.client;

import com.google.api.client.auth.oauth.OAuthCredentialsResponse;
import com.google.api.client.auth.oauth.OAuthGetAccessToken;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.UrlEncodedParser;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.SystemUtil;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.SSLSocketFactory;

public class JiraOAuthGetAccessToken
extends OAuthGetAccessToken {
    private static KeyManagerFactory kmf;

    public JiraOAuthGetAccessToken(String authorizationServerUrl) {
        super(authorizationServerUrl);
        this.usePost = true;
    }

    public final OAuthCredentialsResponse executeNonSSL(String tokenAuthorizedUrl) throws Exception {
        HttpRequestFactory requestFactory = null;
        String keystore = System.getenv("keystore");
        SSLContext sslContext = null;
        if (keystore != null) {
            String keystorePass = System.getenv("keystore_password");
            if (!PropertyValidator.isValid((Object)keystorePass)) {
                throw new ViztrendJiraException(Integer.valueOf(500), "keystore_password is missing in environment variable");
            }
            sslContext = SSLContext.getInstance("SSL");
            if (kmf == null) {
                KeyStore ks = KeyStore.getInstance("PKCS12");
                try (FileInputStream fis = new FileInputStream(SystemUtil.kendisHomeFolderPath + "/" + keystore);){
                    ks.load(fis, keystorePass.toCharArray());
                }
                kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, keystorePass.toCharArray());
            }
            sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
            requestFactory = new ApacheHttpTransport.Builder().setSocketFactory(new SSLSocketFactory(sslContext)).build().createRequestFactory();
        } else {
            requestFactory = new ApacheHttpTransport.Builder().doNotValidateCertificate().build().createRequestFactory();
        }
        HttpRequest request = requestFactory.buildRequest(this.usePost ? "POST" : "GET", (GenericUrl)this, null);
        OAuthParameters oAuthParameters = this.createParameters();
        oAuthParameters.setTokenAuthorizedUrl(tokenAuthorizedUrl);
        oAuthParameters.nonce = "sdafds";
        oAuthParameters.intercept(request);
        HttpResponse response = request.execute();
        response.setContentLoggingLimit(0);
        OAuthCredentialsResponse oauthResponse = new OAuthCredentialsResponse();
        UrlEncodedParser.parse((String)response.parseAsString(), (Object)oauthResponse);
        return oauthResponse;
    }
}

