/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.client;

import com.atlassian.oauth.client.JiraOAuthGetAccessToken;
import com.atlassian.oauth.client.JiraOAuthGetTemporaryToken;
import com.atlassian.oauth.client.JiraOAuthTokenFactory;
import com.atlassian.oauth.client.PropertiesClient;
import com.google.api.client.auth.oauth.OAuthAuthorizeTemporaryTokenUrl;
import com.google.api.client.auth.oauth.OAuthCredentialsResponse;
import com.google.api.client.auth.oauth.OAuthParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;

public class JiraOAuthClient {
    public final String jiraBaseUrl;
    private final JiraOAuthTokenFactory oAuthGetAccessTokenFactory;
    private final String authorizationUrl;

    public JiraOAuthClient(PropertiesClient propertiesClient) {
        this.jiraBaseUrl = (String)propertiesClient.getPropertiesOrDefaults().get("jira_home");
        this.oAuthGetAccessTokenFactory = new JiraOAuthTokenFactory(this.jiraBaseUrl);
        this.authorizationUrl = this.jiraBaseUrl + "/plugins/servlet/oauth/authorize";
    }

    public String getAndAuthorizeTemporaryToken(String consumerKey, String privateKey) throws Exception {
        JiraOAuthGetTemporaryToken temporaryToken = this.oAuthGetAccessTokenFactory.getTemporaryToken(consumerKey, privateKey, null);
        OAuthCredentialsResponse response = temporaryToken.executeNonSSL(null);
        OAuthAuthorizeTemporaryTokenUrl authorizationURL = new OAuthAuthorizeTemporaryTokenUrl(this.authorizationUrl);
        authorizationURL.temporaryToken = response.token;
        return response.token;
    }

    public Map<String, String> getAndAuthorizeTemporaryTokenMap(String consumerKey, String privateKey, String authorizationUrl, String requestTokenUrl, String tokenAuthorizedUrl) throws Exception {
        JiraOAuthGetTemporaryToken temporaryToken = this.oAuthGetAccessTokenFactory.getTemporaryToken(consumerKey, privateKey, requestTokenUrl);
        HashMap<String, String> tokens = new HashMap<String, String>();
        OAuthCredentialsResponse response = temporaryToken.executeNonSSL(tokenAuthorizedUrl);
        tokens.put("token", response.token);
        tokens.put("token_secret", response.tokenSecret);
        OAuthAuthorizeTemporaryTokenUrl authorizationURL = new OAuthAuthorizeTemporaryTokenUrl(authorizationUrl);
        authorizationURL.temporaryToken = response.token;
        return tokens;
    }

    public String getAccessToken(String tmpToken, String secret, String consumerKey, String privateKey, String accessTokenUrl, String tokenAuthorizedUrl) throws Exception {
        JiraOAuthGetAccessToken oAuthAccessToken = this.oAuthGetAccessTokenFactory.getJiraOAuthGetAccessToken(tmpToken, secret, consumerKey, privateKey, accessTokenUrl);
        OAuthCredentialsResponse response = oAuthAccessToken.executeNonSSL(tokenAuthorizedUrl);
        return response.token;
    }

    public OAuthParameters getParameters(String tmpToken, String secret, String consumerKey, String privateKey, String accessTokenUrl) throws NoSuchAlgorithmException, InvalidKeySpecException {
        JiraOAuthGetAccessToken oAuthAccessToken = this.oAuthGetAccessTokenFactory.getJiraOAuthGetAccessToken(tmpToken, secret, consumerKey, privateKey, accessTokenUrl);
        oAuthAccessToken.verifier = secret;
        return oAuthAccessToken.createParameters();
    }
}

