var backlogItemIds = [
    "660cf8ae798f0f0e13069d56",
    "6603e6cf8526350b31c78ad8",
    "660f97637f09017192d73082",
    "660cf8ae798f0f0e13069d55",
    "660cf8ae798f0f0e13069d54"    
]

Highcharts.chart('container', {
    chart: {
        type: 'column'
    },
    title: {
        text: 'Lead Time Graph for Backlog Items',
        align: 'left'
    },
    subtitle: {
        text:
            'Source: <a target="_blank" ' +
            'href="https://www.indexmundi.com/agriculture/?commodity=corn">indexmundi</a>',
        align: 'left'
    },
    xAxis: {
        categories: backlogItemIds,
        crosshair: true,
        accessibility: {
            description: 'Backlog Items'
        }
    },
    yAxis: {
        min: 0,
        title: {
            text: 'Days'
        }
    },
    plotOptions: {
        column: {
            pointPadding: 0.2,
            borderWidth: 0
        }
    },
    series: [
        {
            "name" : "660cf8ae798f0f0e13069d55",
            "data" : [ 
                420.0
            ]
        },
        {
            "name" : "660cf8ae798f0f0e13069d54",
            "data" : [ 
                394.0
            ]
        },
        {
            "name" : "660cf8ae798f0f0e13069d56",
            "data" : [ 
                376.0
            ]
        },
        {
            "name" : "6603e6cf8526350b31c78ad8",
            "data" : [ 
                117.0
            ]
        },
        {
            "name" : "660f97637f09017192d73082",
            "data" : [ 
                99.0
            ]
        }
    ]
});
