Highcharts.chart('container', {
    chart: {
        type: 'area'
    },
    title: {
        text: 'Batches and sub batches CFD',
        align: 'left'
    },
    yAxis: {
        title: {
            useHTML: true,
            text: 'Number of batches'
        }
    },
    xAxis: {
        categories: [
            5, 10, 15,20, 25, 30, 35, 40, 45, 50, 55, 60
        ]
    },
    tooltip: {
        shared: true,
        headerFormat: '<span style="font-size:12px"><b>{point.key}</b></span>' +
            '<br>'
    },
    plotOptions: {
        area: {
            stacking: 'normal',
            lineColor: '#666666',
            lineWidth: 1,
            marker: {
                lineWidth: 1,
                lineColor: '#666666'
            }
        }
    },
    series: [

        {
            "name" : "Done",
            "data" : [
                0.0,
                0.0,
                0.0,
                0.0,
                0.0,
                0.0,
                4.0,
                4.0,
                1.0,
                1.0,
                1.0
            ]
        },
        {
            "name" : "InProgress",
            "data" : [
                0.0,
                0.0,
                4.0,
                5.0,
                1.0,
                1.0,
                1.0,
                1.0,
                1.0,
                1.0,
                1.0
            ]
        },
        {
            "name" : "ToDo",
            "data" : [
                12.0,
                12.0,
                12.0,
                12.0,
                12.0,
                12.0,
                12.0,
                12.0,
                12.0,
                12.0,
                12.0
            ]
        }
    ]
});
