



const groupByValues = {
	Section: "Section",
	Parent: "Parent",
	Session: "Session",
	Batches: "Batches",
	Teams: "Teams",
	Sprints: "Containers",
	SolutionBoards: "SolutionBoards",
	kendisStatus: "kendisStatus",
	NoGroup: "-1",
}

const metaDependantGroups = [
	groupByValues.Batches,
	groupByValues.Sprints,
	groupByValues.Session,
	groupByValues.SolutionBoards,
	groupByValues.Teams
]
/**
 * Re-parent a resource (and its descendants) under a new parent.
 * All events stay with their resources and will render under the new branch.
 *
 * @param {Scheduler|SchedulerPro} scheduler
 * @param {String|Number} childResourceId    The resource to move
 * @param {String|Number} newParentResourceId The new parent resource
 * @param {Number|null} [index=null]         Optional position under the new parent (0 = first)
 */
function moveResourceSubtree(scheduler, childResourceId, newParentResourceId, index = null) {
  const rs = scheduler.resourceStore;

  const child     = rs.getById(childResourceId);
  const newParent = rs.getById(newParentResourceId);

  if (!child)     throw new Error(`Resource not found: ${childResourceId}`);
  if (!newParent) throw new Error(`New parent not found: ${newParentResourceId}`);
  if (child === newParent) return;

  // Avoid creating a cycle (don't move a node into its own subtree)
  let p = newParent;
  while (p) {
    if (p === child) throw new Error('Invalid move: target parent is in child\'s subtree');
    p = p.parent;
  }

  // Remove events and assignments, then recreate using addItemsInPlannedScheduler
  const es = scheduler.eventStore;
  const as = scheduler.assignmentStore;
  
  // Get all assignments for this resource (and its descendants)
  const allResources = [child];
  const collectDescendants = (resource) => {
    if (resource.children) {
      resource.children.forEach(childRes => {
        allResources.push(childRes);
        collectDescendants(childRes);
      });
    }
  };
  collectDescendants(child);
  
  // Collect items to recreate after the move
  const itemsToRecreate = [];
  
  allResources.forEach(resource => {
    console.log(`Removing events from resource: ${resource.id}`);
    const assignments = as.getAssignmentsForResource(resource);
    
    assignments.forEach(assignment => {
      const event = assignment.event;
      if (event) {
        const itemId = event.get('orgId');
        if (itemId && roadmapVue.itemsByIdMap[itemId]) {
          console.log(`Collecting item ${itemId} for recreation from resource: ${resource.id}`);
          itemsToRecreate.push(_.cloneDeep(roadmapVue.itemsByIdMap[itemId]));
        }
        
        // Remove assignment
        as.remove(assignment);
        
        // Remove event
        es.remove(event);
      }
    });
  });
  
  console.log(`Removed events and assignments, will recreate ${itemsToRecreate.length} items after move`);

  // Unlink from parent using the removeChild method
  if (child.parent && child.parent.removeChild) {
    console.log(`Unlinking resource ${childResourceId} from parent ${child.parent.id}`);
    child.parent.removeChild(child);
  }
  
  // Remove the resource entirely to avoid duplicates
  rs.beginBatch();
  try {
    // Remove the child resource completely
    console.log(`Removing resource: ${childResourceId} to avoid duplicates`);
    rs.remove(child);
  } finally {
    rs.endBatch();
  }

  
  // Recreate items in the new section using addItemsInPlannedScheduler
  if (itemsToRecreate.length > 0) {
    console.log(`Recreating ${itemsToRecreate.length} items in new section: ${newParentResourceId}`);
    roadmapVue.addItemsInPlannedScheduler(itemsToRecreate, newParentResourceId);
  }

  // Optional: ensure the new parent is expanded so the moved node is visible
//   newParent.expand && newParent.expand();
}

function compareResourcesByName(resourceA, resourceB) {
	// Check if either resource is a milestone, which should always be first
	if (resourceA.id === milestoneResourceId) {
		// console.log("Resource A is a milestone, placing it first.");
		return -1; // Resource A comes before Resource B
	}
	if (resourceB.id === milestoneResourceId) {
		// console.log("Resource B is a milestone, placing it before A.");
		return 1; // Resource B comes before Resource A
	}

	// Check if either 'id' is the string "null" and handle sorting to place "null" always at the bottom
	if (resourceA.id === "null" && resourceB.id !== "null") {
		// console.log("Resource A has id 'null', placing it last.");
		return 1; // Resource A should be after Resource B
	}
	if (resourceB.id === "null" && resourceA.id !== "null") {
		// console.log("Resource B has id 'null', placing A before B.");
		return -1; // Resource A should be before Resource B
	}

	// If both ids are "null", they are equivalent in terms of sorting
	if (resourceA.id === "null" && resourceB.id === "null") {
		// console.log("Both A and B have id 'null', considering them equal.");
		return 0;
	}

	// Ensure we are comparing defined properties; prefer 'name' over 'title' if available
	let nameA = resourceA.name || resourceA.title;
	let nameB = resourceB.name || resourceB.title;

	// Ensure nameA and nameB are strings for localeCompare
	if (typeof nameA !== 'string') {
		nameA = String(nameA);
	}
	if (typeof nameB !== 'string') {
		nameB = String(nameB);
	}

	// Log comparison values to debug
	// console.log(`Comparing by name: ${nameA} vs ${nameB}`);

	// Use localeCompare for string comparison
	return nameA.localeCompare(nameB);
}
//A POPUP THAT EDITS THE NAME AND COLOR OF ROADMAPSECTION
const ROADMAP_SECTION_POPUP = Vue.component('roadmap-section-popup', {
	name: 'roadmap-section-popup',
	template: ` 
 		<div>
 		<div id="overlay" class="overlay" style="display: block;"></div>
		<div class="popup ui-dialog add-pop" style="display: block;">
			<div class="popup-header dialgtl">
				Edit Section
				<div class="popup-close rmv-ico ti-close" @click="$emit('close')" title="Close"></div>	
			</div>
				<div class="popup-body cntr mrow" style="min-height: 200px">
					<div class="popup-content">
						<div class="popup-row rec lblm half">
							<label>Name</label>
							<div class="popup-input">
								<input type="text" v-model="copySection.name" 
								maxlength="256" 
								:class="['popup-input-text',errorFields.name.showError?'required':'']" /> 
								 <div v-if="errorFields.name.showError" class="error-message">
									{{errorFields.name.errorMessage}}
								</div>
							</div>
						</div>	
						<div class="popup-row rec lblm half">
							<label>Color</label>
							 <div class="rc  colctypclr">
                                    <div class="clr FL wd addWorkSpce p-rel" >
                                        <color-picker-button v-model="copySection.color" > </color-picker-button>
                                    </div>
                                </div>
						</div>
					</div>
				</div>
				<div class="popup-footer rec btn">
					<div class="popup-button FR button" @click="onSave">Save</div>
					<a href="javascript:void(0);" @click="$emit('close')" class="FR cncl">Cancel</a>
				</div>	
		</div>
	</div>`,
	props:['section'],
	data: function() {
		return {
			copySection: _.cloneDeep(this.section),
			errorFields: {
				name: {
					showError:false,
					errorMessage:""
				},

				color:{
					showError:false,
					errorMessage:""
				},
			},
		}
	},

	methods:{
		checkNameExists(name){
			if(name===this.section.name){
				return false;
			}
			return this.$parent.$options.roadmapSectionsCrud.checkNameExists(name);
		},
		onSave(){
			if(!this.copySection.name || this.copySection.name.trim().length === 0){
				showTopMessage("Please enter a name for the section");
				this.errorFields.name.showError = true;
				this.errorFields.name.errorMessage = "Please enter a name for the section";
				return;
			}

			if(this.checkNameExists(this.copySection.name.trim())){
				showTopMessage("Section with this name already exists");
				this.errorFields.name.showError = true;
				this.errorFields.name.errorMessage = "Section with this name already exists";
				return;
			}
			this.$emit('save',this.copySection);
		}

	}
});
const ROADMAP_COLLECTION_ITEMS = Vue.component('roadmap-collection-items', {
	name: 'roadmap-collection-items',
	store: useKanbanStore,
	template: `
			<div class="roadmap itemsrdmp"  >
				<router-view v-if="unplannedFetched && plannedFetched" :key="itemsByIdMapVersion" :roadmap="roadmap" :filters="filters" :itemsByIdMap="itemsByIdMap" :roadmapId="roadmap.id" :releaseTrainId="releaseTrain.id" :hierachLevel="level" :almAccountType="almAccountType" :groupByValue="groupBy.value" :groupBy="groupBy"></router-view>
				<div class="DFCB roadmapTopBar collection" :class = "[displayMode.value == 'batches'?'JE-AA':'']">
						<div class="DFA">
							<!--back button-->
							<div class="headerBackBtn" @click="onBackClick">
								<span class="ti-angle-left backIcon">
								</span>
								<span class="backText">
									Back
								</span>
							</div>
							<div v-if = "displayMode.value == 'items'" class="DFA">      
<!--								<div class="p-rel srchTop">-->
<!--									<em class="ti-search srchfiltico p-abs" @click="onFiltersChangeSearchText"></em> -->
<!--									<input v-model="filters.searchText" type="text" placeholder="Search..." class="filtersearch h-auto" -->
<!--									@change="onFiltersChangeSearchText">-->
<!--								</div>-->
<!--								<a  v-if="filters.searchText.length > 0" class = "reset-tags ml-10 mr-10 c-point" @click= "onResetSearch()" title="Reset Tags">Reset</a>-->

								<div class="DFA">
									<div class="srchTop p-rel">
										<em class="ti-search srchfiltico p-abs planning-search-icon" @click="onEnterSearchText"></em> 
										<input v-model="filters.searchText" type="text" placeholder="Search..." 
										class="filtersearch h-auto kendis-batch-planning-search" @keyup.enter="onEnterSearchText">
									</div>
									<a  v-if="visibleTags.length > 0" class = "reset-tags ml-10 mr-10 c-point" @click= "onSearchTagAction('removeAll')" title="Reset Tags">Reset</a>
									
									<div class="search-tags" ref="dropdownContainer">
										<ul id="search-text_tags">
												<li v-for="(tag, tagIndex) in visibleTags" :key="tagIndex" :title="tag.details" class="tag-item">
												{{tag.title}}
												<i @click="onSearchTagAction('remove', tag, tagIndex)" class="ti-close"></i>
											</li>
											<li v-if="hiddenTags.length > 0" class="extraDropDown ml-5">
												<span @click="toggleDropdown" class="bxtagnw c-point rnd4"> + {{ hiddenTags.length }}</span>
												<ul v-if="isDropdownOpen" class="extraDropDownContent">
													<li v-for="(tag, tagIndex) in hiddenTags" :key="tagIndex" :title="tag.details" class="tag-item">
													{{tag.title}}
													<i @click="onSearchTagAction('remove', tag, tagIndex + 5)" class="ti-close"></i>
													</li>
												</ul>
											</li>
										</ul>
									</div>
								</div>		
<!--								<search_suggestions v-if="filters.searchText && filters.searchText.length>0" -->
<!--								:items = "getItemsMapExistingOnRoadmap()"-->
<!--								:searched-text = "filters.searchText"-->
<!--								:items-per-page="10"-->
<!--								@select-item="onSearchSuggestionItemSelected">-->
<!--								</search_suggestions>-->
								<div @click="showFilters = true;" class="fltico ml-10 button-w rnd6" 
								:class="filters.filtersCount > 0 ?'active':'' " title="Filters"> 
									<label class="ftsb mb-0">Filters: </label> 
									<span class="count DAJ">{{filters.filtersCount}}</span>
								</div>
								<div v-if = "displayMode.value != 'batches' " class="DFA">
									<div  class="selectcont ml-10 wdb rnd6 topbarSelects h-auto">
									<vz-select :multiple="false" 
											v-model="groupBy.value" 
											:options="groupBy.options" empty-selection-text="Select Group" label="title" 
											track-by="id" value-type="value" 
											:class="{ 'disabled-select': isDataLoading }"
									@select="onGroupBySelectValue" />
									</div>
									<div v-if="isDataLoading" class="loading-indicator ml-10">
										<em class="ti-reload ico rotating"></em>
									</div>
								</div>
							</div>
						</div>
					<!--<div class="button-w ml-10 h-auto FR txgrn brgrn" @click="onClickViewToggele">Timeline</div>-->
					<div  class="DF">
						<div class="datacrctnbtn" v-if = "dataCorrectionButton.show" >
							<em class="ti-alert ico"></em> {{dataCorrectionButton.text}}
							<a href="javascript:void(0)" @click="correctData" class="url ml-5">Click here</a>
						</div>
						
						<!-- Group by moved to unplanned grid toolbar -->
						<!-- <div  v-if = "displayMode.value != 'batches' && showUnplannedGroupBy && !isGridChildMode"  class="selectcont ml-10 wdb rnd6 topbarSelects h-auto">
				
							<vz-select :multiple="false" 
									v-model="groupByUnplanned.value" 
									:options="groupBy.options" empty-selection-text="Select Group Unplanned" label="title" 
									track-by="id" value-type="value" 
							@select="onGroupBySelectValueUnplanned" />
						</div> -->
						
						<div v-if="enableTimeRanges" class="enbldin DFA px-10">
						<div class="switch-button grn switch-button-sm">
							<input id = "toggle-time-ranges" type="checkbox" @click="onToggleTimeRanges($event)" v-bind:class="[timeRangesDisplaySettings.showTimeRanges === true ? 'checked': 'unchecked']" />
							<span><label for="toggle-time-ranges"></label></span>
						</div><div class="light wht-nwrp ml-5">Enable Time Ranges</div>	
						</div>
						
						<!-- Toggle button for resource mode -->
						<div class="enbldin DFA px-10">
							<div class="switch-button blu switch-button-sm">
								<input id="toggle-resource-mode" type="checkbox" @click="toggleResourceMode" :checked="showIndividualItemResources" />
								<span><label for="toggle-resource-mode"></label></span>
							</div>
							<div class="light wht-nwrp ml-5">Show Children</div>
						</div>
						
					
						<span class="p-rel">
							<div class="button-w nwabtn adbtn ml-10 mr-10 rnd6 a" @click="onClickAddButton;showAddPopup=true">
								<em class="ti-plus addf"></em>Add
							</div>
							<vuepopup v-if="showAddPopup" @close="showAddPopup=false">
								<div class="drop_box nwmu artp sml" style="display:block;top:26px;">
								<ul>
								<template>
									<li class="c-point" @click.stop="onClickCreateNew('null')">Create New</li>
									<li class="c-point" @click.stop="onClickAddExisting">Add Existing</li>
									<li class="c-point" @click.stop="onClickAddFromALM">Add from ALM</li>
								</template>
								</ul>
								</div>
							</vuepopup>
						</span>

							<div class="withicon  DF p-rel">
<!--							<div class="button-w  showUnplaned adbtn wht-nwrp rnd6" @click="onClickUnplannedButton">-->
<!--								<template v-if = "showUnplannedGrid">-->
<!--									<img src="/assets/icons/Union.svg" alt=".." class="mr-5">Hide Unplanned-->
<!--								</template>-->
<!--								<template v-else >-->
<!--									<img src="/assets/icons/Union.svg" alt=".." class="mr-5">Show Unplanned-->
<!--								</template>-->
<!--							</div>-->
							</div>
					</div>
				</div>
				<vuepopup v-if="showAddMilestoneMenu" @close="hideMilestoneMenu">
					<div class="drop_boxa nwmu arr-top add w-150 piAddmilestoneDrop b"
					     :style="{
					         position: 'fixed',
					         top: milestoneMenuPopupPosition.top !== 0 ? (milestoneMenuPopupPosition.top + 10) + 'px' : '90px',
					         left: milestoneMenuPopupPosition.left !== 0 ? (milestoneMenuPopupPosition.left - 55) + 'px' : '34px'
					       }">
						<ul>
							<li class="c-point" @click="onCreateMilestonePopup">Create Milestone</li>
							<li class="c-point" @click="onAddExistingMilestone">Add Existing</li>
						</ul>
					</div>
				</vuepopup>
				
				<add-milestone-board v-if="addMilestoneToBoardPopup.show" 
		    		:position="addMilestoneToBoardPopup.position"
		    		:board-items="addMilestoneToBoardPopup.boardItems"
		    		:board-id="addMilestoneToBoardPopup.boardId"
		    		:release-train="releaseTrain"
		    		:view-type="addMilestoneToBoardPopup.viewType"
		    		:show-item-edit-menu="false"
		    		@close="onAddMilestoneToBoardPopupClose"
				    @item-selected="onAddToBoardPopupItemSelectedMilestone"
				    @archived-milestones="onArchivedMilestonesError"
		    	/>
		    	<roadmap-section-popup v-if="sectionPopup.show" 
		    	:section="sectionPopup.section" @close="onSectionPopupClose" @save="onSectionPopupSave" 
		    	/>
		    	
		    	<milestone-popup
					v-if="milestoneData.milestonePopup.show"
					:board-id="milestoneData.milestonePopup.boardId"
					:is-update="milestoneData.milestonePopup.isUpdate"
					:item="milestoneData.milestonePopup.item"
					:item-type="milestoneData.milestonePopup.itemType"
					:key="milestoneData.milestonePopup.isUpdate"
					:read-only="milestoneData.milestonePopup.readOnly"
					:release-train="milestoneData.milestonePopup.releaseTrain"
					:hierarchy-level="milestoneData.milestonePopup.level"
					:statuses="milestoneData.milestonePopup.statuses"
					:selected-criteria="milestoneData.milestonePopup.selectedCalculationCriteria ? milestoneData.milestonePopup.selectedCalculationCriteria : 'c_st'"
					:edit-permission="editMilestonePermission()"
					:delete-permission="deleteMilestonePermission()"
		    	    :link-unlink-permission="linkUnlinkItemsPermission()"
		    	    :is-roadmap-milestone="true"
					:new-section-relation="milestoneData.milestonePopup.sectionRelations"
					@archive="onClickArchiveMilestone"
					@close="onCloseMilestonePopup"
					@save="onSaveMilestone"
					
		    	></milestone-popup>
		    	
		    	<confirmation-popup v-if="milestoneData.confirmationPopup.show" :title="milestoneData.confirmationPopup.title" :description="milestoneData.confirmationPopup.description" :do-not-ask="milestoneData.confirmationPopup.doNotAsk" 
					 :onClickConfirm="milestoneData.confirmationPopup.onClickConfirm" :onClickCancel="milestoneData.confirmationPopup.onClickCancel" :is-description-html="true" />
					
				<div class="timelineview roadmap itmclctn" :class="{isFullScreen: isFullScreen}">
					<template v-if="loader.show">
						 <div id="body-loader" class="loader"><div><div class="loaderinteg"></div><span class="LOADER-TITLE">{{loader.text}}</span></div></div> 
					</template>
					<roadmap-settings v-if="settings.show"
					:roadmap = "roadmap"
					:enable-time-ranges="enableTimeRanges"
					@save-edited-timecapsules = "onSaveEditedTimeCapsules"
					@remove-timecapsule = "onRemoveTimeCapsule"
					@close="settings.show = false"
					@save-roadmap-year-configs = "onSaveRoadMapYearConfig"
					></roadmap-settings>
				
					<timeline-item-edit v-if="itemEditPopup.show"
						:item="itemEditPopup.item"
						:changes="itemEditPopup.changes"
						:release-train="releaseTrain"
						@close="onItemEditClose"
						@saved="onItemEditSaved"
					/>
					<add-item-board v-if="addToBoardPopup.show"
						:item="addToBoardPopup.item"
						:alm="addToBoardPopup.alm"
						:position="addToBoardPopup.position"
						:board-items="addToBoardPopup.boardItems"
						:board-id="roadmap.id"
						:release-train="releaseTrain"
						:hierarchy-level="addToBoardPopup.level"
						:hideFromAlmBtn ="true"
						:hideCreateNewBtn="true"
						@close="onAddToBoardPopupClose"
						@create-new="onAddToBoardPopupCreateNew"
						@add-from-alm="onAddToBoardPopupAddFromAlm"
						@item-selected="onAddToBoardPopupItemSelected"
					/>
					<backlog-item-popup v-if="itemPopup.show"
						:item="itemPopup.item"
						:parent="itemPopup.parent"
						:alm="itemPopup.alm"
						:tfs-projects="itemPopup.tfsProjects"
						:release-train="releaseTrain"
						:board-id="roadmap.id"
						:hierarchy-level="itemPopup.level"
						:kendis-statuses="store.kendisStatuses"
						:batch-id="itemPopup.batchId "
						:meta-load-required="itemPopup.batchId?true:false"
						@project-linked=""
						@close="onItemPopupClose"
						@update="onItemPopupUpdateItem"
						@delete="onItemPopupDeleteItem"
						@create="onAddToBoardPopupCreate"
					/>
					
					<add-existing-tfs
						v-if="addFromAlmPopup.show"
						:tfs-projects="addFromAlmPopup.tfsProjects"
						:item="addFromAlmPopup.item"
						:parent="addFromAlmPopup.parent"
						:alm="addFromAlmPopup.alm"
						:board-id="roadmap.id"
						:release-train="releaseTrain"
						:backlog-hierarchy-levels="store.backlogHierarchyLevels"
						:hierarchy-level="addFromAlmPopup.level"
						@project-linked=""
						@close="onAddFromAlmClose"
						@items-added="onAddFromAlmAdded"
						@on-add-existing-jiraItems="onAddExistingJiraItems"
					/>
					
		    		<div v-if="anyMessage" class="expmsg" style="z-index: 10001;">
						<span :style="{color: store.message.color}" v-html="store.message.text"></span>
						<em class="ti-close" @click="store.message.text = '';"></em>
					</div>
					<link-item v-if="linkItemPopUp.showLinkItemPopup " 
                                    :fetch-user-stories="true"
                                    :fetch-features="true"
                                    title="Link Items"
                                    :base-item-links="getFocusedBatch().baseItemLinks"
                                    container="link-item-container"
                                    @cancel="linkItemPopUp.showLinkItemPopup=false;"
                                    @save="attachBackLogItemsToObject"
                                    :backLogItemsMode="true"
                                    :isMockingMode="true"
                                    :showBoardFilter="false"> 
                                    </link-item>
		    	
		    		
					<div v-if = "showZoomOptions" class="mnhd fst DAJ" style="gap: 10px;">
						<div class="c-point prgbtn mr-10" @click.stop="openRoadmapProgress" title="Progress"></div>
						<div class="fit wboxtp c-point DAJ rnd4" @click="fitSchedulerToEvents();">FIT</div>
						<div class="ti-fullscreen fulscrn wboxtp c-point DAJ rnd4" :title="isFullScreen ? 'Exit Full Screen' : 'Full Screen'" @click = "toggleFullScreen"></div>
						<div class="navigator-controls DFA rnd4">
							<a class="ftnv DFA zoom-btn out c-point ti-zoom-out" @click="zoomTimePeriod('out')"></a>
							<a class="ftnv DFA arrbtn lft c-point ti-angle-left" @click="navigateToAdjacentTimePeriod('prev')"></a>
							<div class="ftnv DFA navdown DFA p-rel c-point" @click.stop="timeNavigator.showNavigator = !timeNavigator.showNavigator">
								<div class="DAJ wht-nwrp">{{ getTimeNavigatorLabel() }}</div>
								<time-period-popup v-if="timeNavigator.showNavigator" :is-navigator="true" @navigateToTimePeriod="navigateToTimePeriod" />
							</div>
							<a class="ftnv DFA arrbtn rht c-point ti-angle-right" @click="navigateToAdjacentTimePeriod('next')"></a>	                            
							<a class="ftnv DFA zoom-btn in c-point ti-zoom-in" @click="zoomTimePeriod('in')"></a>
						</div>
						<div class="reset-btn DFA c-point ti-reload rnd4 tooltip" @click="resetTimeNavigatorToCurrentYear">
							<div class="hovtooltipB tprhtn sml">Reset to Current Year</div>
						</div>
						<div v-if = "almAccountType === 'tfs'" @click="settings.show = true;" class="set mr-10 c-point DFA p-rel"><div class="ftsb fs-14">Settings</div></div>
					</div>
					
					
					<backlog-filters v-if="showFilters"
					:alm-account-type ="almAccountType"
					:release-train="releaseTrain"
					:board-filter="roadmap.filterCriteria"
					:filter-criteria="filters.filter"
					:level="roadmap.level"
					:can-save-filter="false"
					:is-roadmap="true"
					@close="showFilters = false"
					@apply-filter="onFiltersApplied"
					@reload="onFiltersReload"
					>
				</backlog-filters>
					<div id="roadmap" ref="gantt" :class="[isFullScreen ? 'kendis-roadmap-fullscreen' : '', showIndividualItemResources ? 'planned-grid-item' : 'unplanned-grid-item']"></div>
				</div>		
				

				
				</div>	 
		`,
	props: ["releaseTrainId", "viewType", "roadmapId","enableTimeRanges"],
	mixins:[backlogItemMixin, timelineDataMixin, boardMixin, timelineZoomMixin],
	data() {
		return {
			unplannedFetched: false,
			plannedFetched: false,
			showUnplannedGroupBy:false,
			isDataLoading: false, // Track data loading state
			isInitializingGroupBy: false, // Prevent duplicate calls during group by initialization
			isFullScreen:false,
			zoomState:{
				isCustomZoom:false,
			},
			showZoomOptions: true,
			timeNavigator: {
				showNavigator: false,
				selectedTimePeriod: null,
				customSpanYears: 2,
			},
			sectionPopup:{
				show:false,
				section:{}
			},
			roadmap: {},
			viewPreset: {
				value: "q",
				options: [{id:"y",title:"YEARLY"},
					// {id:"h",title:"Semi-Yearly"},
					{id:"q",title:"Quarterly"},
					{id:"m",title:"Monthly"},
					{id:"w",title:"Weekly"},
					{id:"c",title:"Custom"}]
			},
			items: [],
			itemsByIdMap: {},
			itemsByIdMapExcludingSearch:new Map(),
			milestoneMapById : {},
			showAddPopup:false,
			rollupsByIdMap: {},
			loadingItemRollups: false,
			roadmapColumnTitles: [],
			level: "",
			loader: {
				show: false,
				text: "Loading Roadmap"
			},
			groupBy: {
				applied: false,
				options: [
					// { title: "No Group", id: "-1" },
					{title:"No Group" , id : groupByValues.Section},
					{ title: "Parent", id: groupByValues.Parent },
					{ title: "PI Boards", id: groupByValues.Session },
					{ title: "Batches", id: groupByValues.Batches },
					// {title: "Time Ranges", id: "timeCapsuleRelation"},
					{ title: "Teams", id: groupByValues.Teams },
					{ title: "Sprints", id: groupByValues.Sprints },
					{ title: "Solution Boards", id: groupByValues.SolutionBoards },
					{ title: "Status", id: groupByValues.kendisStatus },

				],
				value: "-1",
				defaultSelectedGroupId:groupByValues.Section,
			},
			groupByUnplanned:{
				value:"-1",
				applied: false,
			},

			displayMode: {

				options: [
					{ title: "Items", id: DisplayModes.RAW_ITEMS },
					//{ title: "Batches & items", id: DisplayModes.BATCHES },
					{ title :"Items in Time Periods",id : DisplayModes.BUCKETS},
				],
				value: "items",
				showText : "Select Display Mode"

			},
			percentage: {
				show : false,
				options: [
					{ id: "", title: "No Completion" },
					{ id: "r_st", title: "By Rollup (Status)" },
					{ id: "r_sp", title: "By Rollup (Estimate)" },
					{ id: "st"  , title: "By Done Children (Status)" }
				],
				value: ""
			},
			showFilters: false,
			filtersCount: 0,
			itemEditPopup: {
				show: false,
				item: undefined,
				changes: {}
			},
			addToBoardPopup: {
				show: false,
				position:{left:0,top:0}
			},
			itemPopup: {
				parent: undefined,
				item: undefined,
				alm: undefined,
				tfsProjects: undefined,
				show: false,
			},
			addFromAlmPopup: {
				show: false,
				backlogLevel: 0,
				alm: undefined,
				parent: undefined,
				item: []
			},
			sort: {
				fields: []
			},
			filters: {
				filter : undefined,
				filterCriteria : undefined,
				filtersCount  : 0,
				isApplied  : false,
				searchText:"",
				searchTags:[],
				searchSuggestions:{
					show:true,
					items:[],
					baseItems:[]
				},
			},
			unplannedFilter:{
				searchText:"",
			},
			isDropdownOpen: false,
			rollups: {
				pageStart: 0,
				pageSize: 50,
				allItems:[]
			},
			defaultDurationUnit: "d",
			defaultDuration: 14,
			isdragRemoveFromGrid: false, //it controlles if the item from grid is deleted or dragged
			isChangeGroupBy: false,
			settings: {
				show: false
			},
			showUnplannedGrid: true,
			globalBatches: [],
			selectedGlobalBatches: [],
			batchesLinkedItemsMap:{},
			batchesFieldList:[],
			selectedOptionsForYearWiseTimeCapsules:[],
			linkItemPopUp: {
				showLinkItemPopup: false,
			},
			selectedReleaseTrain: {},
			releaseTrains: [],
			gridPagination: {
				showBar: true,
				pageSize: 50,
				pageIndex: 0,
				pageSizeOptions: [25,50,100],
				totalItemSize: 1,
				pageIndexOptions:[]
			},
			gridFilters: {
				filter : undefined,
				filterCriteria : undefined,
				filtersCount  : 0,
				isApplied  : false,
				searchText:""
			},

			dataCorrectionButton:{
				show:false,
				text:'Action Required: Adjust Section Data'
			},
            batchesMap:{},
			selectedReleaseTrainMeta:{
				itemHierarchyLevels: [],
				selectedHierarchyLevel: undefined,
			},

			actionPopup: {
				showPopup: false,
				popupActions: [
				],
				context:{}
			},

			milestoneData: {
				milestones: [],
				milestoneGroup: {},
				loaded: false,
				milestonePopup: {
					show: false,
					readOnly: false,
					releaseTrain: {},
					level: {},
					statuses: [],
					isUpdate: false,
					item: {},
					itemType: "Milestone",
					selectedCalculationCriteria: undefined,
					boardId: undefined,
				},
				linkItemConfirmationPopup: false,
				confirmationPopup: {
					show: false,
					doNotAsk: {
						message: "Don't ask me again",
						isEnabled: true,
					},
					title: "",
					description: "",
					request: {},
					onClickConfirm: this.onClickConfirmLinking,
					onClickCancel: this.onClickCancelConfirmation,
				}
			},

			showAddMilestoneMenu: false,
        	milestoneMenuPopupPosition: { top: 0, left: 0 },
        	addMilestoneToBoardPopup: {
				show: false,
				boardItems: [],
				position:{left:0,top:0}
			},


			allCollectionItemsGrid: {
				addContent: {
					options: [
						{id: "new", title: "Create New", allowedALM: ['jira', 'tfs', 'kendis']},
						{id: "existing", title: "Add Existing", allowedALM: ['jira', 'tfs']},
						// { id: "filter", title: "Add Filter Content", allowedALM: ['jira', 'tfs'] },
					],
					show: false,
				},
				collectionBacklogItemPopup:{ //FOR CREATE NEW BACKLOG ITEM USE THIS POPUP
					show: false,
					item:undefined,
					releaseTrainId: undefined,
					metaLoadRequired: true,
					itemType: "",
					releaseTrain: {},
				},
				existingItemPopupLinking: {
					show: false,
					backlogLevel: 0,
					alm: undefined,
					parent: undefined,
					releaseTrain: undefined,
				},
			},

			// batchPermissionObj:
			// 	{
			// 		ADD_EDIT_BATCH:true,
			// 		DELETE_BATCH:false,
			// 		LINK_UNLINK_BATCH_ITEMS:true,
			// 		MANAGE_BATCH_GROUP:false,
			// 	},
			timeRangesDisplaySettings:{
				showTimeRanges: false,
			},
			itemsByIdMapVersion: 0,
			
			// Toggle between old and new resource display modes
			showIndividualItemResources: false, // Default to old mode (false)
			
			// Children action data for adding new/existing children to item resources
			selectedItemResourceId: null,
			
			// Cache for unplanned children per item
			unplannedChildrenCache: {}, // Format: { itemId: [unplannedChildren] }
			unplannedChildrenCountCache: {}, // Format: { itemId: count }
			
			// Cache for planned children count per item
			plannedChildrenCountCache: {}, // Format: { itemId: count }
			
			// Unplanned grid mode tracking
			unplannedGridMode: {
				mode: 'default', // 'default' or 'filtered'
				parentItemId: null,
				parentItem: null
			},
			
			// Flag to track if grid is in child mode (showing filtered children)
			isGridChildMode: false,
			
			// TFS Settings Notification
			showTfsSettingsNotification: true,
		}
	},
	computed: {
		store() {
			return this.$store;
		},
		visibleTags() {
			return this.filters.searchTags.slice(0, 5);
		},
		hiddenTags() {
			return this.filters.searchTags.slice(5);
		},
		anyMessage () {
			return this.store.message.text == '' ? false : true;
		},
		roadmapYearsConfigsMap() {
			let map = {};
			if (this.roadmap.roadmapYearsConfigs) {
				_.each(this.roadmap.roadmapYearsConfigs, config => {
					map[config.year] = config.partitionViewType;
				});
			}
			return map
		},
		releaseTrain() {
			return this.store.releaseTrain;
		},
		almAccountType() {
			if (this.store.almAccounts && this.store.almAccounts[0]) {
				return this.store.almAccounts[0].type;
			}
		},
		isTfsAlm() {
			return this.almAccountType && this.almAccountType.toLowerCase() === 'tfs';
		},
		batchesLoaded() {
			return this.$root.flags.batches;
		},
		boardsLoaded() {
			return this.$root.flags.boards;
		},
		teamsLoaded() {
			return this.$root.flags.teams;
		},
		containersLoaded() {
			return this.$root.flags.containers;
		},
		solutionsLoaded() {
			return this.$root.flags.solutionBoards;
		},
		schedulerModuleLoaded() {
			return true;
		},
		metaLoaded() {
			return this.schedulerModuleLoaded && this.releaseTrain && this.releaseTrain.id;
		},
		backlogHierarchyLevels() {
			return this.store.backlogHierarchyLevels;
		},
		currentHierarchyLevel() {
			if (this.backlogHierarchyLevels && this.roadmap && this.roadmap.id) {
				let index = this.roadmap.level;
				if ( typeof index == "string") {
					index = parseInt(index);
				}
				let level = _.find(this.backlogHierarchyLevels,{level: index});
				return level;
			}
			return undefined;
		},
		almMappingByLevel() {
			if (this.store.almMappingByLevel) {
				return this.store.almMappingByLevel;
			}
			else {
				return {};
			}
		},
		almFieldsMap (){
			let fieldMap = {};
			let fields = [];
			let currentHierarchyLevel;
			currentHierarchyLevel= this.currentHierarchyLevel.level;
			if(!currentHierarchyLevel){
				return {};
			}
			if(!_.isEmpty(this.almMappingByLevel[currentHierarchyLevel])){
				var mapping = this.almMappingByLevel[currentHierarchyLevel];
				if(mapping.jiraFields){
					fields = mapping.jiraFields;
				}else{
					fields = mapping.tfsFields;
				}
				_.each(fields, field =>{
					if(field.id) {
						fieldMap[field.id] = field;
					}else{
						fieldMap[field.referenceName.replace(".","_")] = field;
					}
				});
				return fieldMap;
			}
			return {};
		},
		yearWiseTimeCapsulesShowMap(){
			let yearWiseTimeCapsulesShowMap = {};
			let timeCapsules = this.store.gettimeCapsules
			for(let timeCapsule of timeCapsules) {
				let year = timeCapsule.startDate.getFullYear();
				if(!yearWiseTimeCapsulesShowMap[year]) {
					yearWiseTimeCapsulesShowMap[year] = {
						id: year,
						label: year,
					};
					yearWiseTimeCapsulesShowMap[year].children = [];
				}else{
					yearWiseTimeCapsulesShowMap[year].children.push({
						id: timeCapsule.id,
						label: timeCapsule.label,
					});
				}
			}
			yearWiseTimeCapsulesShowMap = Object.values(yearWiseTimeCapsulesShowMap);
			return yearWiseTimeCapsulesShowMap;
		},
		
		// Computed property to get total unplanned children count
		totalUnplannedChildrenCount() {
			return Object.values(this.unplannedChildrenCountCache).reduce((sum, count) => sum + count, 0);
		},
		
		// Computed property to check if any unplanned children exist
		hasUnplannedChildren() {
			return this.totalUnplannedChildrenCount > 0;
		}
	},
	created() {
		roadmapVue = this;
		let searchTags = kendisStore.getters.getRoadmapSearchTags();
		if(searchTags && searchTags.length > 0){
			this.filters.searchTags = searchTags;
		}
		console.log("-------------------------------------");
		console.log("Init ROADMAP");
		console.log("-------------------------------------");
		this.setOptions()
		this.loadSchedulerConfigs();
		this.$options.dateByBoard = {};
		
		// Initialize separate group items info maps for planned and unplanned items
		this.$options.plannedGroupItemsInfoMap = new Map();
		this.$options.unplannedGroupItemsInfoMap = new Map();
		
		// Initialize ID utils for this roadmap
		this.$options.idUtils = createRoadmapIdUtils('item', this);
		
		// Initialize session expiry handling
		this.initSessionExpiryHandling();
		
		// Initialize session keep-alive mechanism
		this.initSessionKeepAlive();
	},
	mounted() {
		console.log("-------------------------------------");
		console.log("ROADMAP mounted");
		console.log("-------------------------------------");
		if(this.enableTimeRanges){this.store.fetchTimeCapsules();}
		// this.loadReleaseTrains();
		//this.setBoardStartDate();
		this.loadLocalStorageData();
		this.initView();
		
		// Load time navigator state from localStorage
		this.loadTimeNavigatorFromStorage();

	},
	beforeRouteLeave(to, from, next) {
		next();
		this.store.setShowLeftMenuBar(true);
	},
	watch: {
		"globalBatches":{
			handler(newValue, oldValue) {
				this.createBatchesMap(newValue);
			}
		},
		"yearWiseTimeCapsulesShowMap":{
			handler(newValue, oldValue) {
				if(newValue){
					this.selectedOptionsForYearWiseTimeCapsules = newValue.map(year => year.children.map(child => child.id)).flat();
				}
			}
		},
		"releaseTrain":{
			handler(newValue, oldValue) {
				if (newValue !== null) {
					this.initView()
			        //this.loadData()
			      }
			}
		},
		"batchesLoaded": {
			handler(newValue, oldValue) {
				if (newValue) {
					this.updateItemsOnMetaLoaded(groupByValues.Batches);
				}
			}
		},
		"boardsLoaded": {
			handler(newValue, oldValue) {
				if (newValue) {
					this.updateItemsOnMetaLoaded(groupByValues.Session);
				}
			}
		},
		"teamsLoaded": {
			handler(newValue, oldValue) {
				if (newValue) {
					this.updateItemsOnMetaLoaded(groupByValues.Teams);
				}
			}
		},
		"containersLoaded": {
			handler(newValue, oldValue) {
				if (newValue) {
					this.updateItemsOnMetaLoaded(groupByValues.Sprints);
				}
			}
		},
		"solutionsLoaded": {
			handler(newValue, oldValue) {
				if (newValue) {
					this.updateItemsOnMetaLoaded(groupByValues.SolutionBoards);
				}
			}
		},
		"filter.searchText": {
			handler(newValue, oldValue) {
				if(this.itemsByIdMapExcludingSearch.size===0 &&  newValue && newValue.length>0 ){
					this.fetchUnsearchedData();
				}
			}
		},

	},
	beforeDestroy() {
		// Cleanup event listener if component is destroyed
		document.removeEventListener('click', this.handleClickOutside);
		
		// Cleanup session keep-alive mechanism
		this.cleanupSessionKeepAlive();
		
		// Save time navigator state before component is destroyed
		this.saveTimeNavigatorToStorage();
	},

	methods: {
		createGroupItemsInfoMap(groupsInfoList){
			let groupItemsInfoMap = new Map();
			for(let group of groupsInfoList){
				groupItemsInfoMap.set(_.isEmpty(group._id)?"null":group._id.id,
					{excludeGroupIds:(group.excludeGroupIds && group.excludeGroupIds.length>0)?group.excludeGroupIds:undefined,
						groupIds: (group.multiIds && group.multiIds.length > 0) ? [...group.multiIds, null] : undefined})

			}
			return groupItemsInfoMap;

		},
		
		/**
		 * Initialize session expiry handling for the roadmap
		 */
		initSessionExpiryHandling() {
			// Set up axios interceptor for session expiry handling
			this.setupAxiosInterceptor();
			
			// Set up fetch wrapper for session expiry handling
			this.setupFetchWrapper();
		},
		
		/**
		 * Set up axios interceptor to handle session expiry
		 */
		setupAxiosInterceptor() {
			// Add response interceptor to handle session expiry
			axios.interceptors.response.use(
				(response) => response,
				(error) => {
					if (this.isSessionExpired(error)) {
						this.handleSessionExpiry('roadmap-axios');
						return Promise.reject(error);
					}
					return Promise.reject(error);
				}
			);
		},
		
		/**
		 * Set up fetch wrapper for session expiry handling
		 */
		setupFetchWrapper() {
			// Store original fetch function
			if (!window.originalFetch) {
				window.originalFetch = window.fetch;
			}
			
			// Override fetch to handle session expiry
			const self = this;
			window.fetch = function(url, options = {}) {
				return window.originalFetch(url, options)
					.then(response => {
						if (self.isSessionExpiredFromResponse(response)) {
							self.handleSessionExpiry('roadmap-fetch');
							throw new Error('Session expired');
						}
						return response;
					})
					.catch(error => {
						if (self.isSessionExpired(error)) {
							self.handleSessionExpiry('roadmap-fetch');
						}
						throw error;
					});
			};
		},
		
		/**
		 * Check if an error indicates session expiry
		 * @param {Object} error - The error object
		 * @returns {boolean} - True if session has expired
		 */
		isSessionExpired(error) {
			if (!error) return false;
			
			// Check for axios error
			if (error.response) {
				const status = error.response.status;
				return status === 401 || status === 403;
			}
			
			// Check for fetch error
			if (error.status) {
				return error.status === 401 || error.status === 403;
			}
			
			return false;
		},
		
		/**
		 * Check if a response indicates session expiry
		 * @param {Response} response - The fetch response
		 * @returns {boolean} - True if session has expired
		 */
		isSessionExpiredFromResponse(response) {
			return response.status === 401 || response.status === 403;
		},
		
		/**
		 * Handle session expiry by showing user-friendly message and options
		 * @param {string} context - Context where session expired
		 */
		handleSessionExpiry(context = 'roadmap') {
			console.warn(`Session expired in ${context} context`);
			
			// Prevent multiple session expiry dialogs
			if (this.sessionExpiryHandled) {
				return;
			}
			this.sessionExpiryHandled = true;
			
			// Show user-friendly message with reload option
			const message = `
				<div style="text-align: center; padding: 20px;">
					<div style="margin-bottom: 20px;">
						<i class="ti-alert" style="font-size: 48px; color: #f39c12; margin-bottom: 15px;"></i>
					</div>
					<h3 style="margin-bottom: 15px; color: #2c3e50;">Session Expired</h3>
					<p style="margin-bottom: 20px; color: #7f8c8d; line-height: 1.5;">
						Your session has expired due to inactivity. Please reload the page to continue working.
					</p>
					<div style="margin-top: 25px;">
						<button onclick="window.location.reload()" 
								style="background: #3498db; color: white; border: none; padding: 12px 24px; 
									   border-radius: 6px; cursor: pointer; font-size: 14px; margin-right: 10px;">
							<i class="ti-reload" style="margin-right: 8px;"></i>Reload Page
						</button>
						<button onclick="window.location.href='/login'" 
								style="background: #95a5a6; color: white; border: none; padding: 12px 24px; 
									   border-radius: 6px; cursor: pointer; font-size: 14px;">
							<i class="ti-user" style="margin-right: 8px;"></i>Go to Login
						</button>
					</div>
				</div>
			`;
			
			// Use existing alert system if available, otherwise use browser alert
			if (typeof alertFromSweetAlertWrapper === 'function') {
				alertFromSweetAlertWrapper(message, () => {
					window.location.reload();
				});
			} else if (typeof showTopMessage === 'function') {
				showTopMessage("Session expired. Please reload the page.", 'error', 10000);
				setTimeout(() => {
					window.location.reload();
				}, 3000);
			} else {
				alert("Your session has expired. Please reload the page to continue.");
				window.location.reload();
			}
		},
		
		/**
		 * Check session validity by making a lightweight request
		 * @returns {Promise<boolean>} - True if session is valid, false otherwise
		 */
		async checkSessionValidity() {
			try {
				const response = await window.originalFetch('/ping', {
					method: 'GET',
					headers: getFetchAPIHeadersForKendis(),
					credentials: 'include'
				});
				return response.status === 200;
			} catch (error) {
				console.warn('Session validity check failed:', error);
				return false;
			}
		},
		
		/**
		 * Proactively check session validity and handle expiry
		 * @param {string} context - Context for error handling
		 * @returns {Promise<boolean>} - True if session is valid, false if expired
		 */
		async validateSession(context = 'roadmap') {
			const isValid = await this.checkSessionValidity();
			if (!isValid) {
				this.handleSessionExpiry(context);
			}
			return isValid;
		},
		
		/**
		 * Initialize session keep-alive mechanism to prevent inactivity-based session expiry
		 */
		initSessionKeepAlive() {
			// Configuration for keep-alive
			this.sessionKeepAliveConfig = {
				enabled: true,
				interval: 1 * 60 * 1000, // 1 minute in milliseconds
				intervalId: null
			};
			
			// Start the keep-alive mechanism (no activity tracking needed)
			this.startSessionKeepAlive();
			
			console.log('Session keep-alive mechanism initialized - always active');
		},
		
		
		/**
		 * Start the session keep-alive mechanism
		 */
		startSessionKeepAlive() {
			if (!this.sessionKeepAliveConfig.enabled) {
				return;
			}
			
			const self = this;
			
			// Clear any existing interval
			if (this.sessionKeepAliveConfig.intervalId) {
				clearInterval(this.sessionKeepAliveConfig.intervalId);
			}
			
			// Set up periodic keep-alive calls
			this.sessionKeepAliveConfig.intervalId = setInterval(async () => {
				await self.performSessionKeepAlive();
			}, this.sessionKeepAliveConfig.interval);
			
			console.log(`Session keep-alive started with ${this.sessionKeepAliveConfig.interval / 1000}s interval`);
		},
		
		/**
		 * Stop the session keep-alive mechanism
		 */
		stopSessionKeepAlive() {
			if (this.sessionKeepAliveConfig.intervalId) {
				clearInterval(this.sessionKeepAliveConfig.intervalId);
				this.sessionKeepAliveConfig.intervalId = null;
				console.log('Session keep-alive stopped');
			}
		},
		
		/**
		 * Perform a session keep-alive ping
		 */
		async performSessionKeepAlive() {
			try {
				console.log('Performing session keep-alive ping...');
				
				// Send keep-alive ping (always send, ignore activity)
				const response = await fetch('/ping', {
					method: 'GET',
					headers: getFetchAPIHeadersForKendis(),
					credentials: 'include'
				});
				
				if (response.ok) {
					console.log('Session keep-alive successful');
				} else {
					console.warn('Session keep-alive failed with status:', response.status);
					// If keep-alive fails, it might indicate session expiry
					if (response.status === 401 || response.status === 403) {
						this.handleSessionExpiry('roadmap-keepalive');
					}
				}
			} catch (error) {
				console.error('Session keep-alive error:', error);
				// Don't handle session expiry here as it might be a network error
			}
		},
		
		
		/**
		 * Update keep-alive configuration
		 * @param {Object} config - New configuration options
		 */
		updateKeepAliveConfig(config) {
			if (config.interval !== undefined) {
				this.sessionKeepAliveConfig.interval = config.interval;
			}
			if (config.enabled !== undefined) {
				this.sessionKeepAliveConfig.enabled = config.enabled;
				if (config.enabled) {
					this.startSessionKeepAlive();
				} else {
					this.stopSessionKeepAlive();
				}
			}
		},
		
		/**
		 * Cleanup session keep-alive mechanism
		 */
		cleanupSessionKeepAlive() {
			// Stop the keep-alive interval
			this.stopSessionKeepAlive();
			
			console.log('Session keep-alive mechanism cleaned up');
		},
		
		/**
		 * Manually trigger a session keep-alive ping
		 * Useful for testing or immediate session refresh
		 */
		async triggerKeepAlive() {
			console.log('Manually triggering session keep-alive...');
			await this.performSessionKeepAlive();
		},
		
		/**
		 * Get current keep-alive status and configuration
		 * @returns {Object} Current keep-alive configuration and status
		 */
		getKeepAliveStatus() {
			return {
				enabled: this.sessionKeepAliveConfig?.enabled || false,
				interval: this.sessionKeepAliveConfig?.interval || 0,
				isRunning: !!this.sessionKeepAliveConfig?.intervalId,
				mode: 'always-active' // Always sends pings regardless of activity
			};
		},

		/**
		 * Show smart message for roadmap item operations
		 * @param {string} message - The message to display
		 * @param {string} type - Message type: 'success', 'info', 'warning', 'error'
		 * @param {number} duration - Duration in milliseconds (default: 3000)
		 */
		showSmartMessage(message, type = 'success', duration = 3000) {
			// Use existing Bryntum toast message system
			showBryntumToastMessage(message, type);
			
			// Auto-hide after specified duration
			setTimeout(() => {
				// The Bryntum toast will auto-hide, but we can add additional logic here if needed
			}, duration);
		},

		/**
		 * Common method to open backlog item popup for editing
		 * Used by both event click and pencil button
		 * @param {Object} eventRecord - The event record from the roadmap
		 * @param {Object} resourceRecord - The resource record (optional)
		 * @param {string} itemId - The item ID to edit
		 */
		openItemEditPopup(eventRecord, resourceRecord = null, itemId = null) {
			// If itemId is not provided, extract it from eventRecord
			if (!itemId) {
				itemId = eventRecord.get('isChild') ? this.getChildItemId(eventRecord.id) : eventRecord.id.split('_')[0];
			}
			
			const item = this.itemsByIdMap[itemId];
			if (!item) {
				console.error('Item not found in itemsByIdMap:', itemId);
				showBryntumToastMessage('Item not found', 'error');
				return;
			}
			
			// Clone the item for editing
			const editingItem = _.cloneDeep(item);
			
			// Set up the backlog item popup data
			this.itemPopup.eventRecord = eventRecord;
			this.itemPopup.resourceRecord = resourceRecord;
			this.itemPopup.item = editingItem;
			this.itemPopup.parent = undefined;
			
			// Determine the correct hierarchy level for the item
			let itemLevel = getHierarchyLevelForItem(eventRecord, this.itemsByIdMap, this.releaseTrain, this.store.backlogHierarchyLevels, this.currentHierarchyLevel);
			this.itemPopup.level = itemLevel;
			
			// Set ALM and TFS projects
			this.itemPopup.alm = undefined;
			this.itemPopup.tfsProjects = undefined;
			if (!_.isEmpty(this.store.almAccounts)) {
				this.itemPopup.alm = this.store.almAccounts[0];
			}
			if (this.store.tfsProjects) {
				this.itemPopup.tfsProjects = this.store.tfsProjects;
			}
			
			this.itemPopup.show = true;
			
			console.log('Opening backlog item popup for item:', item.title, 'with event record:', eventRecord.id);
		},

		/**
		 * Opens the backlog item popup for an item resource (pencil button)
		 * @param {string} resourceId - The resource ID (format: groupId_item_itemId)
		 */
		editItemResource(resourceId) {
			// Extract the item ID from the resource ID
			// Resource ID format: groupId_item_itemId
			const parts = resourceId.split('_');
			if (parts.length < 3) {
				console.error('Invalid resource ID format:', resourceId);
				return;
			}
			
			const itemId = parts[parts.length - 1]; // Last part is the item ID
			
			// Find the corresponding event record in the roadmap
			const scheduler = this.$options.roadmap;
			let eventRecord = null;
			
			// Search through all events to find the one matching this item
			for (let event of scheduler.eventStore.allRecords) {
				if (event.get('orgId') === itemId || event.id === itemId) {
					eventRecord = event;
					break;
				}
			}
			
			if (!eventRecord) {
				console.error('Event record not found for item:', itemId);
				showBryntumToastMessage('Event not found in roadmap', 'error');
				return;
			}
			
			// Use the common method to open the popup
			this.openItemEditPopup(eventRecord, null, itemId);
		},

		/**
		 * Show loading mask on the unplanned grid
		 * @param {string} message - Loading message to display
		 */
		showGridLoader(message = 'Loading...') {
			if (this.$options.unplannedGrid) {
				this.$options.unplannedGrid.maskBody({
					text: `
						<div class="bryntum-grid-loader">
							<div class="bryntum-loader-spinner"></div>
							<div class="bryntum-loader-text">${message}</div>
						</div>
					`,
					mode: 'bright',
					cls: 'bryntum-grid-mask'
				});
			}
		},

		/**
		 * Hide loading mask from the unplanned grid
		 */
		hideGridLoader() {
			if (this.$options.unplannedGrid) {
				this.$options.unplannedGrid.unmaskBody();
			}
		},

		/**
		 * Show loading mask on the roadmap scheduler
		 * @param {string} message - Loading message to display
		 */
		showRoadmapLoader(message = 'Loading roadmap...') {
			if (this.$options.roadmap) {
				this.$options.roadmap.maskBody({
					text: `
						<div class="bryntum-roadmap-loader">
							<div class="bryntum-loader-spinner"></div>
							<div class="bryntum-loader-text">${message}</div>
						</div>
					`,
					mode: 'bright',
					cls: 'bryntum-roadmap-mask'
				});
			}
		},

		/**
		 * Hide loading mask from the roadmap scheduler
		 */
		hideRoadmapLoader() {
			if (this.$options.roadmap) {
				this.$options.roadmap.unmaskBody();
			}
		},

		/**
		 * Show loading indicator on a specific group item
		 * @param {string} groupId - The ID of the group to show loader on
		 * @param {string} message - Loading message to display
		 */
		showGroupLoader(groupId, message = 'Loading...') {
			if (this.$options.unplannedGrid) {
				const groupRecord = this.$options.unplannedGrid.store.getById(groupId);
				if (groupRecord) {
					// Add loading class to the group record
					groupRecord.loading = true;
					groupRecord.loadingMessage = message;
					groupRecord.cls = (groupRecord.cls || '') + ' loading-group';
					
					// Set the loading message as a data attribute
					groupRecord.dataLoadingMessage = message;
					
					// Refresh the row to show the loading indicator
					// this.$options.unplannedGrid.refreshRows(groupRecord);
				}
			}
		},

		/**
		 * Hide loading indicator from a specific group item
		 * @param {string} groupId - The ID of the group to hide loader from
		 */
		hideGroupLoader(groupId) {
			if (this.$options.unplannedGrid) {
				const groupRecord = this.$options.unplannedGrid.store.getById(groupId);
				if (groupRecord) {
					// Remove loading state from the group record
					groupRecord.loading = false;
					groupRecord.loadingMessage = null;
					groupRecord.dataLoadingMessage = null;
					
					// Remove loading class
					if (groupRecord.cls) {
						groupRecord.cls = ''
					}
					
					// Refresh the row to hide the loading indicator
				}
			}
		},

		/**
		 * Get group/resource display name for smart messages
		 * @param {string} groupId - The group ID
		 * @param {string} groupBy - The group by value
		 * @returns {string} Display name for the group
		 */
		getGroupDisplayName(groupId, groupBy) {
			if (!groupId || groupId === 'null' || groupId === 'all_items') {
				return 'All Items';
			}

			try {
				switch (groupBy) {
					case 'Batches':
						if (this.$root.$options.meta.batches && this.$root.$options.meta.batches[groupId]) {
							const batch = this.$root.$options.meta.batches[groupId];
							return `${batch.key}: ${batch.title}`;
						}
						return `Batch ${groupId}`;
						
					case 'Section':
						const section = this.$options.roadmapSectionsCrud.getSectionById(groupId);
						return section ? section.title : `Section ${groupId}`;
						
					case 'kendisStatus':
						if (this.$root.$options.meta.statuses && this.$root.$options.meta.statuses[groupId]) {
							return this.$root.$options.meta.statuses[groupId].title;
						}
						return `Status ${groupId}`;
						
					case 'timeCapsuleRelation':
						if (this.$root.$options.meta.timeCapsules && this.$root.$options.meta.timeCapsules[groupId]) {
							return this.$root.$options.meta.timeCapsules[groupId].title;
						}
						return `Time Capsule ${groupId}`;
						
					default:
						// Try to get resource name from scheduler
						const resource = this.$options.roadmap.resourceStore.getById(groupId);
						return resource ? resource.name : `Group ${groupId}`;
				}
			} catch (error) {
				console.warn('Error getting group display name:', error);
				return `Group ${groupId}`;
			}
		},

		async getGroupIdsForItemForTheGroup(itemId, fetchPlannedOnly, fetchUnplannedOnly) {
			const createRequestData = (itemId, fetchPlannedOnly, fetchUnplannedOnly) => {
				const data = {
					hierachLevel: `${this.level}`,
					requestId: getNewUUID(),
					// boardId: this.roadmap.id,
					filter: this.getFilterCriteria(
						this.roadmap,
						this.filters.filter ? this.filters.filter.criteria : {},
						this.filters.searchTags
					)
				};
				data.filter = {};
				data.filter.rules = [];
				data.filter.condition = "AND";
				data.filter.rules.push({ key: "itemIds", value: [itemId], type: "array", almType: "" });
				const groupBy = fetchUnplannedOnly ? this.groupByUnplanned : this.groupBy;
				if (groupBy.value !== "-1") {
					data.groupBy = groupBy.value;
					if (groupBy.type) {
						data.type = groupBy.type;
						data.itemType = groupBy.itemType;
					}
				}
				return data;
			};

			const response = await fetch(`/releasetrain/${this.store.releaseTrainId}/backlog`, {
				method: 'POST',
				headers: getFetchAPIHeadersForKendis(),
				body: JSON.stringify(createRequestData(itemId, fetchPlannedOnly, fetchUnplannedOnly)),
				credentials: 'include'
			});

			if (!response.ok) {
				throw new Error(`Network response was not ok: ${response.statusText}`);
			}

			const data = await response.json();
			// let groupIs = [];
			// for ( const item of data.result.items) {
			// 	if(item._id.id && Object.keys(item._id).length > 0){
			// 		groupIs.push(item._id.id);
			// 	}else {
			// 		groupIs.push("null");
			// 	}
			// }
			return data.result.items;
		},

		
		correctData(){
			let _this = this
			let roadmapSectionsResponse =  fetch(`/roadmap-section/add-default-roadmap-section?roadmapId=${_this.roadmap.id}`, {
				method: 'PUT',
				headers: getFetchAPIHeadersForKendis(),
				credentials: 'include', // Include cookies for CSRF-TOKEN
			});
			roadmapSectionsResponse.then(response => {
				if (response.ok) {
					showTopMessage("Data Correction Completed", "success");
					_this.dataCorrectionButton.show = false;
				} else {
					showTopMessage("Data Correction Failed", "error");
				}
				//relaod page
				window.location.reload();
			});
		},
		getNoGroupName(groupValue){
			switch (groupValue) {
				case "Batches":
					return "No Batch"
				case "SolutionBoards":
					return "No Solution Board"
				case "Teams":
					return "No Team"
				case "Containers":
					return "No Sprint"
				case "Session":
					return "No PI Board"
				case "Parent":
					return "No Parent"
				case "Section":
					return this.$options.roadmapSectionsCrud.getDefaultSection().name;
				case groupByValues.kendisStatus:
					return "No Status"
				default:
					return 'No Group'
			}
		},
		getGroupTitleFromMeta(groupId,selectedGroupValue){
			let _this= this;
			if(groupId === "null"){
				return this.getNoGroupName(selectedGroupValue);
			}
			if (selectedGroupValue === groupByValues.Batches && _this.$root.flags.batches && _this.$root.$options.meta.batches) {
				let batch = _this.$root.$options.meta.batches[groupId];
				return batch? batch.key +" : "+batch.title:'...';
			}
			else if(selectedGroupValue === groupByValues.Teams && _this.$root.flags.teams && _this.$root.$options.meta.teams){
				let team = _this.$root.$options.meta.teams[groupId];
				return team ? team.title :'...';
			}
			else if(selectedGroupValue === groupByValues.SolutionBoards && _this.$root.flags.solutionBoards && _this.$root.$options.meta.solutionBoards){
				let board = _this.$root.$options.meta.solutionBoards[groupId];
				return board ? board.title : '...';

			}
			else if(selectedGroupValue === groupByValues.Sprints && _this.$root.flags.containers && _this.$root.$options.meta.containers){
				let sprint = _this.$root.$options.meta.containers[groupId];
				if (sprint) {
					let board = this.$root.$options.meta.boards[sprint.sessionBoardId];
					if (board) {
						return board.title + " : " + sprint.title;
					} else {
						return sprint.title;
					}
				}
				return  '...'
			}
			else if (selectedGroupValue === groupByValues.Session && _this.$root.flags.boards && _this.$root.$options.meta.sessionById) {
				let board = _this.$root.$options.meta.sessionById[groupId];
				return board ? board.title : '...';
			}
			else if (selectedGroupValue === "Section") {
				let section = _this.$options.roadmapSectionsCrud.getSectionById(groupId);
				return section?section.name:'...';
			}
			return '...'
		},
		onSearchSuggestionItemSelected: function(item){
			this.addInFilterTags(item);
			this.filters.searchText = '';
			// RoadMapLocalStorageManager.setSearchTags(this.batchToBePlannedKey, this.filters.searchTags);
			this.fetchData();
			// filterOrClearEvents(roadmapVue.$options.roadmap,this.filters.searchTags,[EventTypes.BATCH_GROUP,EventTypes.BATCH],roadmapVue)
		},
		//search by tags
		addInFilterTags: function(item){
			//check if tag already exists
			if (item.type && (item.type === 'Batch'|| item.type === 'batch_group')) {
				if(this.filters.searchTags.find(tag => tag.title.toLowerCase() === item.key.toLowerCase())){
					showTopMessage("Tag already exists", "warning");
					return;
				}
				this.filters.searchTags.push({
					id: item.id,
					title: item.key,
					details: item.title
				});
			}else{
				if(this.filters.searchTags.find(tag => tag.title.toLowerCase() === generateKey(item).toLowerCase())){
					showTopMessage("Tag already exists", "warning");
					return;
				}
				this.filters.searchTags.push({
					id: item.id,
					title: generateKey(item),
					details: item.title
				});
			}
		},
		getItemsMapExistingOnRoadmap: function(){
			return this.itemsByIdMap;
		},
		onEnterSearchText: function(){
			if(this.filters.searchText.trim() !== ""){
				//check if tag already exists
				if(this.filters.searchTags.find(tag => tag.title.toLowerCase() === this.filters.searchText.toLowerCase())){
					showTopMessage("Tag already exists", "warning");
					return;
				}
				this.filters.searchTags.push({
					title: this.filters.searchText,
					details: this.filters.searchText
				});
			}
			this.filters.searchText = "";
			// RoadMapLocalStorageManager.setSearchTags(this.batchToBePlannedKey, this.filters.searchTags);
			this.fetchData();
			// filterOrClearEvents(roadmapVue.$options.roadmap,this.filters.searchTags,[EventTypes.BATCH_GROUP,EventTypes.BATCH],roadmapVue)
		},
		onSearchTagAction: function (action, item, index) {
			if(action ==='removeAll'){
				this.filters.searchTags = [];
				this.fetchData();
				// filterOrClearEvents(roadmapVue.$options.roadmap,this.filters.searchTags,[EventTypes.BATCH_GROUP,EventTypes.BATCH],roadmapVue)
			}
			if (action === 'remove') {
				this.filters.searchTags.splice(index, 1);
				this.fetchData();
				// filterOrClearEvents(roadmapVue.$options.roadmap,this.filters.searchTags,[EventTypes.BATCH_GROUP,EventTypes.BATCH],roadmapVue)
			}
			// RoadMapLocalStorageManager.setSearchTags(this.batchToBePlannedKey, this.filters.searchTags);
		},
		issueTypeIconUrl(level) {
				let iconUrl = "";
				let itemTypeName="";
				if (this.almAccountType === 'jira') {
					if (this.almAccountType[0] && this.store.almMappingByLevel) {
						let almMappingByLevel = this.store.almMappingByLevel[level];
						if (almMappingByLevel && almMappingByLevel.jiraIssueTypes && almMappingByLevel.jiraIssueTypes.length > 0) {
							let issueType = almMappingByLevel.jiraIssueTypes[0];
							iconUrl = issueType.iconUrl;
							itemTypeName = issueType.name;
						}
					}
				} else if (this.almAccountType === 'tfs') {
					if (this.almAccountType[0] && this.store.almMappingByLevel) {
						let almMappingByLevel = this.store.almMappingByLevel[level];
						if (almMappingByLevel && almMappingByLevel.tfsWorkItemTypes && almMappingByLevel.tfsWorkItemTypes.length > 0) {
							let issueType = almMappingByLevel.tfsWorkItemTypes[0];
							iconUrl = "https://tfsprodsin1.visualstudio.com/_apis/wit/workItemIcons/"+issueType.icon + "?color=" + issueType.color;
							itemTypeName =issueType.name
						}
					}
				} else if (this.almAccountType === NO_ALM) {
					iconUrl = "";
					itemTypeName = "Kendis Only"
					return {iconUrl,itemTypeName};
				}
				return {iconUrl,itemTypeName};

		},
		onFiltersReload: function () {
			this.showFilters = false;
			let _this = this;
			Vue.nextTick(()=>{
				_this.showFilters = true;
			});
		},
		getBackLogItemIconUrl(item) {
			let itemIconUrl = "";
			if(item && item.fields) {
				if(!_.isEmpty(item.fields.tfsProjectId)) {
					itemIconUrl = item.fields.itemTypeIcon;
				} else if (item.fields.issuetype || item.almFields && item.almFields.issuetype) {
					itemIconUrl = styleJiraIcon(this.$root, item);
				}
			}
			return itemIconUrl ? itemIconUrl : '';
		},
		loadLocalStorageData(){
			let showTimeRanges = localStorage.getItem(this.roadmapId+ "_show_time_ranges");
			if(showTimeRanges){
				this.timeRangesDisplaySettings.showTimeRanges = showTimeRanges === "true";
			}
			
			// Load toggle state from localStorage (default to false for old mode)
			const savedToggleState = localStorage.getItem(this.roadmapId + "_individual_resources");
			if (savedToggleState !== null) {
				this.showIndividualItemResources = savedToggleState === 'true';
			}
		},
		
		saveToggleState() {
			localStorage.setItem(this.roadmapId + "_individual_resources", this.showIndividualItemResources.toString());
		},
		
		async toggleResourceMode() {
			this.showIndividualItemResources = !this.showIndividualItemResources;
			this.saveToggleState();
			
			// Clear all caches when switching modes
			this.unplannedChildrenCache = {};
			this.unplannedChildrenCountCache = {};
			this.plannedChildrenCountCache = {};
			this.isGridChildMode = false;
			this.resetUnplannedGrid();
			
			// Reload all data to apply the new mode
			await this.loadData();
		},
		onSectionPopupClose(){
			this.sectionPopup.section= {};
			this.sectionPopup.show = false;

		},
		onSectionPopupSave(editedSection){
			this.$options.roadmapSectionsCrud.updateSection(editedSection);
			this.onSectionPopupClose();
		},
		onToggleTimeRanges (event){
			this.timeRangesDisplaySettings.showTimeRanges = event.target.checked;
			if(event.target.checked){
				roadmapVue.$options.roadmap.features.timeRanges.disabled = false
			}else{
				roadmapVue.$options.roadmap.features.timeRanges.disabled = true;
			}
			localStorage.setItem(this.roadmapId+ "_show_time_ranges", this.timeRangesDisplaySettings.showTimeRanges);
		},
		fitSchedulerToEvents(){
			console.log('Fit button clicked - clearing time navigator state');
			// Clear time navigator state when fitting to events to prevent conflicts
			this.timeNavigator.selectedTimePeriod = null;
			this.timeNavigator.showNavigator = false;
			
			// Clear stored time navigator state to prevent it from being reapplied
			this.clearTimeNavigatorFromStorage();
			
			fitSchedulerToEvents(this.$options.roadmap);
		},
		
		/**
		 * Toggle fullscreen mode (enter/exit)
		 */
		toggleFullScreen(){
			if (this.isFullScreen) {
				this.exitFullScreen();
			} else {
				this.enterFullScreen();
			}
		},

		/**
		 * Enter fullscreen mode
		 */
		enterFullScreen(){
			try{
				this.showZoomOptions=false;
				this.isFullScreen = true;
				
				let schedulerObj = {};
				if(!vueInstance){
					schedulerObj = ROADMAP_MODULE;
				}else{
					schedulerObj = vueInstance.$options.ROADMAP_MODULE;
				}
				
				// Use the same fullscreen implementation as OKR roadmap
				schedulerObj.Fullscreen.request(document.getElementsByClassName('itmclctn')[0]);
				schedulerObj.Fullscreen.onFullscreenChange((data)=>{
					try {
						if (!data.currentTarget.fullscreen) {
							roadmapVue.isFullScreen = false;
							roadmapVue.showZoomOptions = true;
						}
					}catch (e) {
						console.log(e);
					}
				});
			}catch (e) {
				console.error("Error entering fullscreen:", e);
				this.showSmartMessage("Error entering fullscreen", 'error', 4000);
			}
		},

		/**
		 * Exit fullscreen mode
		 */
		exitFullScreen(){
			try{
				this.isFullScreen = false;
				this.showZoomOptions = true;
				
				let schedulerObj = {};
				if(!vueInstance){
					schedulerObj = ROADMAP_MODULE;
				}else{
					schedulerObj = vueInstance.$options.ROADMAP_MODULE;
				}
				
				// Exit fullscreen
				schedulerObj.Fullscreen.exit();
			}catch (e) {
				console.error("Error exiting fullscreen:", e);
				this.showSmartMessage("Error exiting fullscreen", 'error', 4000);
			}
		},

		/**
		 * Reset time navigator to current year
		 */
		resetTimeNavigatorToCurrentYear(){
			const currentYear = new Date().getFullYear();
			const currentPeriod = {
				title: 'YEARLY',
				selectedYear: currentYear,
				monthly: false
			};

			// Update time navigator
			this.timeNavigator.selectedTimePeriod = currentPeriod;
			this.timeNavigator.showNavigator = false;

			// Calculate dates for current year
			const startDate = new Date(currentYear, 0, 1);
			const endDate = new Date(currentYear, 11, 31);
			this.navigateToTimePeriod({ startDate, endDate, timePeriod: currentPeriod });

			// Show success message
			this.showSmartMessage(
				`🔄 Time navigator reset to ${currentYear}`,
				'success',
				2000
			);
		},

		/**
		 * Clear stored time navigator state from localStorage
		 */
		clearTimeNavigatorFromStorage() {
			try {
				const storageKey = `${this.roadmapId}_timeNavigator`;
				localStorage.removeItem(storageKey);
				console.log('Time navigator state cleared from localStorage');
			} catch (error) {
				console.error('Error clearing time navigator from localStorage:', error);
			}
		},

		/**
		 * Navigate to a specific time period
		 * @param {Object} navigationData - Object containing startDate, endDate, and timePeriod
		 */
		navigateToTimePeriod(navigationData) {
			if (!this.$options.roadmap || !navigationData) {
				console.warn('Scheduler not available or navigation data missing');
				return;
			}

			const { startDate, endDate, timePeriod } = navigationData;

			if (!startDate || !endDate) {
				console.warn('Start date or end date missing for navigation');
				return;
			}

			try {
				// Update time navigator state
				this.timeNavigator.selectedTimePeriod = timePeriod;
				this.timeNavigator.showNavigator = false;

				// Save to localStorage
				this.saveTimeNavigatorToStorage();

				// Apply the navigation with smooth animation
				this.$options.roadmap.zoomToSpan({
					startDate: startDate,
					endDate: endDate,
					leftMargin: 30,
					rightMargin: 30,
					animate: true
				});

				// console.log('Navigation applied:', {
				// 	startDate: startDate,
				// 	endDate: endDate,
				// 	timePeriod: timePeriod
				// });

			} catch (error) {
				console.error('Error during navigation:', error);
				this.showSmartMessage('Navigation failed', 'error', 3000);
			}
		},

		/**
		 * Navigate to adjacent time period (previous/next)
		 * @param {'prev'|'next'} direction
		 */
		navigateToAdjacentTimePeriod(direction) {
			const current = this.timeNavigator.selectedTimePeriod;
			if (!current) return;
			const year = current.selectedYear;
			const currentTitle = current.title || '';
			let newTitle = currentTitle, newYear = year;

			// Define period groups for type consistency
			const periodGroups = {
				'HALF': ['H1', 'H2'],
				'QUARTER': ['Q1', 'Q2', 'Q3', 'Q4'],
				'MONTH': ['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC']
			};
			
			// Normalize current title for consistent comparison
			const normalizedCurrentTitle = this.normalizeMonthName(currentTitle);

			// Handle navigation logic
			if (direction === 'next') {
				if (currentTitle === 'YEARLY' || currentTitle === 'Yearly') {
					newYear = year + 1;
				} else if (currentTitle === 'CUSTOM') {
					newYear = year + this.timeNavigator.customSpanYears;
				} else {
					// Handle period-based navigation (H1, H2, Q1, Q2, etc.)
					const periodType = this.getPeriodType(normalizedCurrentTitle);
					const periods = periodGroups[periodType] || [];
					const currentIndex = periods.indexOf(normalizedCurrentTitle);
					
					if (currentIndex >= 0 && currentIndex < periods.length - 1) {
						// Move to next period in same year
						newTitle = periods[currentIndex + 1];
					} else {
						// Move to first period of next year
						newYear = year + 1;
						newTitle = periods[0] || normalizedCurrentTitle;
					}
				}
			} else { // prev
				if (currentTitle === 'YEARLY' || currentTitle === 'Yearly') {
					newYear = year - 1;
				} else if (currentTitle === 'CUSTOM') {
					newYear = year - this.timeNavigator.customSpanYears;
				} else {
					// Handle period-based navigation
					const periodType = this.getPeriodType(normalizedCurrentTitle);
					const periods = periodGroups[periodType] || [];
					const currentIndex = periods.indexOf(normalizedCurrentTitle);
					
					if (currentIndex > 0) {
						// Move to previous period in same year
						newTitle = periods[currentIndex - 1];
					} else {
						// Move to last period of previous year
						newYear = year - 1;
						newTitle = periods[periods.length - 1] || normalizedCurrentTitle;
					}
				}
			}

			// Calculate new dates based on title and year
			let startDate, endDate;
			const isMonthlyPeriod = this.getPeriodType(newTitle) === 'MONTH';
			const timePeriod = { 
				title: newTitle, 
				selectedYear: newYear,
				monthly: isMonthlyPeriod
			};

			if (newTitle === 'YEARLY') {
				startDate = new Date(newYear, 0, 1);
				endDate = new Date(newYear, 11, 31);
			} else if (newTitle === 'CUSTOM') {
				startDate = new Date(newYear, 0, 1);
				endDate = new Date(newYear + this.timeNavigator.customSpanYears - 1, 11, 31);
			} else {
				// Handle other period types (quarters, months, etc.)
				const periodConfig = this.getPeriodConfigByTitle(newTitle, newYear);
				startDate = periodConfig.startDate;
				endDate = periodConfig.endDate;
			}

			// Navigate to the time period with smooth animation
			this.navigateToTimePeriod({ startDate, endDate, timePeriod });

			// Show visual feedback for the navigation
			// this.showNavigationFeedback(timePeriod);

			console.log('Adjacent navigation with smooth animation:', {
				direction: direction,
				fromTitle: currentTitle,
				toTitle: newTitle,
				newYear: newYear,
				timePeriod: timePeriod
			});
		},

		/**
		 * Zoom time period in or out
		 * @param {'in'|'out'} direction
		 */
		zoomTimePeriod(direction) {
			const current = this.timeNavigator.selectedTimePeriod;
			if (!current) return;
			const year = current.selectedYear;
			const currentTitle = current.title || '';

			// Handle custom multi-year zoom levels when zooming out from YEARLY/Yearly
			// and when already in CUSTOM span (2y -> 5y), and reverse on zoom in
			if (direction === 'out') {
				if (currentTitle === 'YEARLY' || currentTitle === 'Yearly') {
					// Switch to 2-year custom view
					this.timeNavigator.customSpanYears = 2;
					const startDate = new Date(year, 0, 1);
					const endDate = new Date(year + 1, 11, 31);
					const timePeriod = { title: 'CUSTOM', selectedYear: year, monthly: false };
					this.navigateToTimePeriod({ startDate, endDate, timePeriod });
					return;
				} else if (currentTitle === 'CUSTOM') {
					// Expand custom span (2y -> 5y)
					if (this.timeNavigator.customSpanYears === 2) {
						this.timeNavigator.customSpanYears = 5;
						const startDate = new Date(year, 0, 1);
						const endDate = new Date(year + 4, 11, 31);
						const timePeriod = { title: 'CUSTOM', selectedYear: year, monthly: false };
						this.navigateToTimePeriod({ startDate, endDate, timePeriod });
						return;
					}
				} else if (['H1', 'H2'].includes(currentTitle)) {
					// Switch from half-year to yearly view
					const startDate = new Date(year, 0, 1);
					const endDate = new Date(year, 11, 31);
					const timePeriod = { title: 'YEARLY', selectedYear: year, monthly: false };
					this.navigateToTimePeriod({ startDate, endDate, timePeriod });
					return;
				} else if (['Q1', 'Q2', 'Q3', 'Q4'].includes(currentTitle)) {
					// Switch from quarter to half-yearly view
					const startDate = new Date(year, 0, 1);
					const endDate = new Date(year, 5, 30);
					const timePeriod = { title: 'H1', selectedYear: year, monthly: false };
					this.navigateToTimePeriod({ startDate, endDate, timePeriod });
					return;
				} else if (['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'].includes(this.normalizeMonthName(currentTitle))) {
					// Switch from month to quarterly view
					const startDate = new Date(year, 0, 1);
					const endDate = new Date(year, 2, 31);
					const timePeriod = { title: 'Q1', selectedYear: year, monthly: false };
					this.navigateToTimePeriod({ startDate, endDate, timePeriod });
					return;
				}
			} else { // zoom in
				if (currentTitle === 'CUSTOM') {
					// Switch to yearly view
					const startDate = new Date(year, 0, 1);
					const endDate = new Date(year, 11, 31);
					const timePeriod = { title: 'YEARLY', selectedYear: year, monthly: false };
					this.navigateToTimePeriod({ startDate, endDate, timePeriod });
					return;
				} else if (currentTitle === 'YEARLY' || currentTitle === 'Yearly') {
					// Switch to half-yearly view
					const startDate = new Date(year, 0, 1);
					const endDate = new Date(year, 5, 30);
					const timePeriod = { title: 'H1', selectedYear: year, monthly: false };
					this.navigateToTimePeriod({ startDate, endDate, timePeriod });
					return;
				} else if (['H1', 'H2'].includes(currentTitle)) {
					// Switch from half-year to quarterly view
					const startDate = new Date(year, 0, 1);
					const endDate = new Date(year, 2, 31);
					const timePeriod = { title: 'Q1', selectedYear: year, monthly: false };
					this.navigateToTimePeriod({ startDate, endDate, timePeriod });
					return;
				} else if (['Q1', 'Q2', 'Q3', 'Q4'].includes(currentTitle)) {
					// Switch from quarter to monthly view
					const startDate = new Date(year, 0, 1);
					const endDate = new Date(year, 0, 31);
					const timePeriod = { title: 'JAN', selectedYear: year, monthly: true };
					this.navigateToTimePeriod({ startDate, endDate, timePeriod });
					return;
				}
			}

			console.log('Zoom operation completed:', {
				direction: direction,
				fromTitle: currentTitle,
				year: year
			});
		},

		/**
		 * Get formatted time navigator label
		 */
		getTimeNavigatorLabel() {
			if (!this.timeNavigator.selectedTimePeriod) {
				return 'Navigate';
			}
			
			const period = this.timeNavigator.selectedTimePeriod;
			if (period.title === 'Custom') {
				return 'Custom';
			}
			
			return period.title + ' ' + period.selectedYear;
		},

		/**
		 * Show navigation feedback message
		 */
		showNavigationFeedback(timePeriod) {
			let message = '';
			if (timePeriod.title === 'Custom') {
				message = `📅 Viewing ${timePeriod.customSpan || this.timeNavigator.customSpanYears} years`;
			} else {
				message = `📅 Viewing ${timePeriod.title} ${timePeriod.selectedYear}`;
			}
			
			this.showSmartMessage(message, 'info', 2000);
		},

		/**
		 * Get period type from title (H1, H2 -> HALF, Q1, Q2, Q3, Q4 -> QUARTER, etc.)
		 */
		/**
		 * Normalize month name to uppercase format
		 */
		normalizeMonthName(month) {
			const monthMap = {
				'Jan': 'JAN', 'Feb': 'FEB', 'Mar': 'MAR', 'Apr': 'APR',
				'May': 'MAY', 'Jun': 'JUN', 'Jul': 'JUL', 'Aug': 'AUG',
				'Sep': 'SEP', 'Oct': 'OCT', 'Nov': 'NOV', 'Dec': 'DEC'
			};
			return monthMap[month] || month.toUpperCase();
		},

		getPeriodType(title) {
			if (title.startsWith('H')) return 'HALF';
			if (title.startsWith('Q')) return 'QUARTER';
			
			const normalizedTitle = this.normalizeMonthName(title);
			if (['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'].includes(normalizedTitle)) return 'MONTH';
			return null;
		},

		/**
		 * Get period configuration by title and year
		 */
		getPeriodConfigByTitle(title, year) {
			// Normalize the title to handle both formats (Jan -> JAN)
			const normalizedTitle = this.normalizeMonthName(title);
			
			const configs = {
				'H1': { startDate: new Date(year, 0, 1), endDate: new Date(year, 5, 30) },
				'H2': { startDate: new Date(year, 6, 1), endDate: new Date(year, 11, 31) },
				'Q1': { startDate: new Date(year, 0, 1), endDate: new Date(year, 2, 31) },
				'Q2': { startDate: new Date(year, 3, 1), endDate: new Date(year, 5, 30) },
				'Q3': { startDate: new Date(year, 6, 1), endDate: new Date(year, 8, 30) },
				'Q4': { startDate: new Date(year, 9, 1), endDate: new Date(year, 11, 31) },
				'JAN': { startDate: new Date(year, 0, 1), endDate: new Date(year, 0, 31) },
				'FEB': { startDate: new Date(year, 1, 1), endDate: new Date(year, 1, 28) },
				'MAR': { startDate: new Date(year, 2, 1), endDate: new Date(year, 2, 31) },
				'APR': { startDate: new Date(year, 3, 1), endDate: new Date(year, 3, 30) },
				'MAY': { startDate: new Date(year, 4, 1), endDate: new Date(year, 4, 31) },
				'JUN': { startDate: new Date(year, 5, 1), endDate: new Date(year, 5, 30) },
				'JUL': { startDate: new Date(year, 6, 1), endDate: new Date(year, 6, 31) },
				'AUG': { startDate: new Date(year, 7, 1), endDate: new Date(year, 7, 31) },
				'SEP': { startDate: new Date(year, 8, 1), endDate: new Date(year, 8, 30) },
				'OCT': { startDate: new Date(year, 9, 1), endDate: new Date(year, 9, 31) },
				'NOV': { startDate: new Date(year, 10, 1), endDate: new Date(year, 10, 30) },
				'DEC': { startDate: new Date(year, 11, 1), endDate: new Date(year, 11, 31) }
			};

			return configs[normalizedTitle] || configs[title] || { startDate: new Date(year, 0, 1), endDate: new Date(year, 11, 31) };
		},

		/**
		 * Get period configuration for navigation (legacy method)
		 */
		getPeriodConfig(type, year, currentPeriod) {
			// This is a simplified version - you may need to expand based on your needs
			const configs = {
				'HALF': {
					'H1': { startDate: new Date(year, 0, 1), endDate: new Date(year, 5, 30), period: 'H1' },
					'H2': { startDate: new Date(year, 6, 1), endDate: new Date(year, 11, 31), period: 'H2' }
				},
				'QUARTER': {
					'Q1': { startDate: new Date(year, 0, 1), endDate: new Date(year, 2, 31), period: 'Q1' },
					'Q2': { startDate: new Date(year, 3, 1), endDate: new Date(year, 5, 30), period: 'Q2' },
					'Q3': { startDate: new Date(year, 6, 1), endDate: new Date(year, 8, 30), period: 'Q3' },
					'Q4': { startDate: new Date(year, 9, 1), endDate: new Date(year, 11, 31), period: 'Q4' }
				}
			};

			return configs[type]?.[currentPeriod] || configs[type]?.[Object.keys(configs[type])[0]];
		},

		/**
		 * Save time navigator state to localStorage
		 */
		saveTimeNavigatorToStorage() {
			try {
				const storageKey = `${this.roadmapId}_timeNavigator`;
				const timeNavigatorData = {
					selectedTimePeriod: this.timeNavigator.selectedTimePeriod,
					customSpanYears: this.timeNavigator.customSpanYears,
					lastUpdated: new Date().toISOString()
				};
				
				localStorage.setItem(storageKey, JSON.stringify(timeNavigatorData));
				console.log('Time navigator state saved to localStorage:', timeNavigatorData);
			} catch (error) {
				console.error('Error saving time navigator to localStorage:', error);
			}
		},

		/**
		 * Load time navigator state from localStorage
		 */
		loadTimeNavigatorFromStorage() {
			try {
				const storageKey = `${this.roadmapId}_timeNavigator`;
				const storedData = localStorage.getItem(storageKey);
				
				if (storedData) {
					const timeNavigatorData = JSON.parse(storedData);
					
					// Validate the stored data
					if (timeNavigatorData.selectedTimePeriod && timeNavigatorData.selectedTimePeriod.selectedYear) {
						this.timeNavigator.selectedTimePeriod = timeNavigatorData.selectedTimePeriod;
						this.timeNavigator.customSpanYears = timeNavigatorData.customSpanYears || 2;
						
						console.log('Time navigator state loaded from localStorage:', timeNavigatorData);
						return true;
					}
				}
			} catch (error) {
				console.error('Error loading time navigator from localStorage:', error);
			}
			
			return false;
		},

		/**
		 * Apply stored time navigator state to the roadmap
		 */
		applyStoredTimeNavigatorState() {
			if (this.timeNavigator.selectedTimePeriod) {
				const { selectedTimePeriod } = this.timeNavigator;
				const year = selectedTimePeriod.selectedYear;
				const title = selectedTimePeriod.title;
				
				let startDate, endDate;
				
				if (title === 'YEARLY' || title === 'Yearly') {
					startDate = new Date(year, 0, 1);
					endDate = new Date(year, 11, 31);
				} else if (title === 'CUSTOM') {
					startDate = new Date(year, 0, 1);
					endDate = new Date(year + this.timeNavigator.customSpanYears - 1, 11, 31);
				} else {
					// Handle period-based titles (H1, H2, Q1, Q2, etc.)
					const periodConfig = this.getPeriodConfigByTitle(title, year);
					startDate = periodConfig.startDate;
					endDate = periodConfig.endDate;
				}
				
				// Apply the navigation without animation for initial load
				if (this.$options.roadmap) {
					this.$options.roadmap.zoomToSpan({
						startDate: startDate,
						endDate: endDate,
						leftMargin: 30,
						rightMargin: 30,
						animate: false // No animation on initial load
					});
					
					console.log('Applied stored time navigator state:', {
						title: title,
						year: year,
						startDate: startDate,
						endDate: endDate
					});
				}
			}
		},
		onZoomChangeLevelRoadmap(value) {
			let mod;

			// Select the appropriate module (gantt or roadmap)
			if (this.$options.gantt) {
				mod = this.$options.gantt;
			} else if (this.$options.roadmap) {
				mod = this.$options.roadmap;
			} else {
				console.warn('No valid module found for zoom operation.');
				return;
			}

			// If zoom-to-fit mode is triggered
			if (value === "f") {
				console.log('Zooming to fit events');
				fitSchedulerToEvents(mod);
				return;
			}

			// Get start and end dates from events
			const allEvents = mod.eventStore.query(record => !record.originalData?.isHeader);
			if (allEvents.length === 0) {
				console.warn('No events found to zoom.');
				return;
			}

			// Compute the minStartDate and maxEndDate
			let minStartDate = allEvents[0].startDate || mod.startDate;
			let maxEndDate = allEvents[0].endDate || mod.endDate;

			allEvents.forEach(event => {
				if (event.startDate < minStartDate) {
					minStartDate = event.startDate;
				}
				if (event.endDate > maxEndDate) {
					maxEndDate = event.endDate;
				}
			});

			// Modify start and end dates based on zoom level (value)
			const startDate = this.addDaysInDate(-2, new Date(minStartDate)); // Buffer of 2 days
			const endDate = new Date(startDate);
			endDate.setMonth(endDate.getMonth() + value);

			// Apply zoomToSpan and scroll
			console.log(`Zooming to span from ${startDate} to ${endDate}`);
			mod.zoomToSpan({
				startDate: startDate,
				endDate: endDate,
				leftMargin: 30,
				rightMargin: 40
			});

			mod.scrollToDate = startDate; // Set scroll position
		},

		updateItemsOnMetaLoaded(metaTag) {
			console.log(`updateItemsOnMetaLoaded called with metaTag: ${metaTag}, showIndividualItemResources: ${this.showIndividualItemResources}`);
			
			const { roadmap: scheduler, unplannedGrid: grid } = this.$options;
			const groupByValue = this.groupBy.value;
			const refresh = this.groupBy.applied && (
				(groupByValue === groupByValues.Batches && metaTag === groupByValues.Batches) ||
				(groupByValue === groupByValues.Teams && metaTag === groupByValues.Teams) ||
				(groupByValue === groupByValues.Sprints && metaTag === groupByValues.Sprints) ||
				(groupByValue === groupByValues.Session && metaTag === groupByValues.Session) ||
				(groupByValue === groupByValues.SolutionBoards && metaTag === groupByValues.SolutionBoards)
			);

			if (refresh) {
				console.log(`Meta refresh needed for ${metaTag}, groupBy: ${groupByValue}`);
				
				// Only update group title bars if NOT in individual item resources mode
				// In individual mode, item resources should keep their original names
				
				this.updateGroupTitleBars();
			

				scheduler.refresh();
				grid.refreshRows();
				// this.sortResources();
			} else {
				console.log(`No meta refresh needed for ${metaTag}`);
			}
		},
		updateGroupTitleBars(){
			let scheduler = this.$options.roadmap;
			let resourceIds = scheduler.resourceStore.map(resource => resource.id);
			
			for(let resourceId of resourceIds){
				// Skip item resources (they should keep their original names)
				if (resourceId.includes('_item_')) {
					console.log(`Skipping item resource ${resourceId} in updateGroupTitleBars`);
					continue;
				}
				
				// Skip milestone resource
				if (resourceId === '-1001') {
					console.log(`Skipping milestone resource ${resourceId} in updateGroupTitleBars`);
					continue;
				}
				
				// Only update group resources
				let fullSpanEvent = scheduler.eventStore.getById(`full-span-event-${resourceId}`);
				if (fullSpanEvent) {
					let newTitle = this.getGroupTitleFromMeta(resourceId, this.groupBy.value);
					fullSpanEvent.set({title: newTitle});
					console.log(`Updated full-span event title for ${resourceId}: ${newTitle}`);
				}
				
				let resource = scheduler.resourceStore.getById(resourceId);
				if (resource) {
					let newName = this.getGroupTitleFromMeta(resourceId, this.groupBy.value);
					resource.name = newName;
					console.log(`Updated resource name for ${resourceId}: ${newName}`);
				}
			}
		},

		groupName(group) {
			let _this = this;
			if(_this.groupBy.customType) {
				if(_this.groupBy.customType.endsWith(":datetime") || _this.groupBy.customType.endsWith("dateTime")) {
					var date = new Date(group._id.title);
					return date.format("dd mmmm yyyy");
				}else if(_this.groupBy.customType.endsWith(":gh-sprint")) {
					if(this.store.almAccounts && this.store.almAccounts[0]) {
						if(!this.store.almAccounts[0].url.includes("atlassian.net")) {
							var sprintObj = parseStrForJsprint(group._id.title);
							return sprintObj.name;
						}
					}
				}
			}
			return group._id.title;
		},
		setOptions(){
			this.isGridChildMode = false;
			this.$options.loadingStats={
				totalItems : 0 ,
				loadedItems : 0
			}
			this.$options.firstOpenUnplannedGrid = false;
			this.$options.itemsParentsMap = new Map();
			this.$options.paginator = new Paginator([], 10, this.updateGridData);
			this.$options.plannedGroupItemsInfoMap = new Map();
			this.$options.unplannedGroupItemsInfoMap = new Map();
		},
		toggleDropdown() {
			this.isDropdownOpen = !this.isDropdownOpen;

			// If the dropdown is opened, start listening for clicks outside
			if (this.isDropdownOpen) {
				document.addEventListener('click', this.handleClickOutside);
			} else {
				// If closed, stop listening for outside clicks
				document.removeEventListener('click', this.handleClickOutside);
			}
		},
		handleClickOutside(event) {
			// Check if the click was outside the dropdown container
			if (!this.$refs.dropdownContainer.contains(event.target)) {
				this.isDropdownOpen = false;
				document.removeEventListener('click', this.handleClickOutside); // Stop listening once it's closed
			}
		},
		onExistingItemPopupLinkingClose:function(){
			this.allCollectionItemsGrid.existingItemPopupLinking.show = false;
			this.allCollectionItemsGrid.existingItemPopupLinking.backlogLevel = 0;
			this.allCollectionItemsGrid.existingItemPopupLinking.alm = undefined;
			this.allCollectionItemsGrid.existingItemPopupLinking.parent = undefined;
			this.allCollectionItemsGrid.existingItemPopupLinking.releaseTrain = undefined;
		},
		onExistingItemPopupLinkingAdded:function(items){
			for(let item of items.items) {
				this.itemsByIdMap[item.id] = item;
				CollectionGridUtils.addGridItem(this.$options.unplannedGrid, item);
			}
		},
		onCollectionBacklogItemPopupClose: function() {
			this.allCollectionItemsGrid.collectionBacklogItemPopup.show = false;
		},
		onCollectionBacklogItemPopupCreateItem: function({item},createAnother) {
			try {
				if(!createAnother) { //if create another is not selected
					this.allCollectionItemsGrid.collectionBacklogItemPopup.show = false;
				}

				this.itemsByIdMap[item.id] = item;
				//add new item in grid
				let compositeKey = item.id;
				let event = createCollectionGridItem(copyItem(item));
				event.id = compositeKey;
				event.orgId = compositeKey;
				event.ttype = "item";
				event.duration = this.defaultDuration;
				event.durationUnit = this.defaultDurationUnit;
				event.title = item.title;
				event.name = item.title;
				event.cls = "kendis-new-collection-item"
				this.$options.unplannedGrid.store.insert(0, event); //insert at first

			}catch (e) {
				console.error("Issue occurred while creating collection item", e);
			}
		},
		onCollectionBacklogItemPopupUpdateItem: function({item}) {
			try {
				this.allCollectionItemsGrid.collectionBacklogItemPopup.show = false;
				//update the bryntum grid item
				let grid = this.$options.unplannedGrid;
				CollectionGridUtils.updateGridItem(grid,item)
				//edit the itemsByIdMap
				this.itemsByIdMap[item.id] = item;
				BatchViewUtils.modifyAllRelatedItems(this.$options.roadmap.eventStore, this.itemsByIdMap[item.id])

			}catch(e) {
				console.error("Issue occurred while updating collection item", e);
			}
		},
		onAddNewAction: function(action) {
			if (this.allCollectionItemsGrid.addContent.show){
				this.allCollectionItemsGrid.addContent.show = false;
			}
			let almAccountType;
			let almAccount;

			if(this.selectedReleaseTrain &&
				this.selectedReleaseTrain.linkedAlmAccounts[0]
				&& this.selectedReleaseTrain.linkedAlmAccounts[0].type) {
				almAccountType = this.selectedReleaseTrain.linkedAlmAccounts[0].type
				almAccount = this.selectedReleaseTrain.linkedAlmAccounts[0];
			}else if(action.id === "existing")
			{
				showTopMessage("Cannot add existing in Kendis only Collection", "warning");
				return;
			}
			if (action.id === "new") {
				this.allCollectionItemsGrid.collectionBacklogItemPopup.item = {};
				this.allCollectionItemsGrid.collectionBacklogItemPopup.parent = undefined;
				this.allCollectionItemsGrid.collectionBacklogItemPopup.releaseTrainId = this.selectedReleaseTrain.id;
				this.allCollectionItemsGrid.collectionBacklogItemPopup.show = true;
				this.allCollectionItemsGrid.collectionBacklogItemPopup.level = this.selectedReleaseTrainMeta.selectedHierarchyLevel;
				this.allCollectionItemsGrid.collectionBacklogItemPopup.enableCollectionAndHierarchyLevelSelection = false
			}
			else if (action.id === "existing") {
				if (almAccountType === ALM_ACCOUNT_TYPES.TFS) {
					this.allCollectionItemsGrid.existingItemPopupLinking.tfsProjects = this.allCollectionItemsGrid.tfsProjects;
				}
				if (!_.isEmpty(almAccount)) {
					this.allCollectionItemsGrid.existingItemPopupLinking.level =  this.selectedReleaseTrainMeta.selectedHierarchyLevel;
					this.allCollectionItemsGrid.existingItemPopupLinking.alm = almAccount
					this.allCollectionItemsGrid.existingItemPopupLinking.parent = undefined;
					this.allCollectionItemsGrid.existingItemPopupLinking.releaseTrain = this.selectedReleaseTrain
				}
				this.fetchHierarchies(this.selectedReleaseTrain.id)//allCollectionItemsGrid.existingItemPopupLinking.almMappingByLevel
			}
			// else if (action.id == "filter") {
			// 	if (this.almAccountType == "tfs") {
			// 		if (!_.isEmpty(this.store.almAccounts)) {
			// 			this.almContentPopup.tfsProjects = this.store.tfsProjects;
			// 			this.almContentPopup.alm = this.store.almAccounts[0];
			// 			this.almContentPopup.show = true;
			// 		}
			// 	}
			// 	else {
			// 		this.openJiraFilters(false, true);
			// 	}
			// }
		},
		fetchHierarchies: function(releaseTrainId) {
			let _this = this;
			let requestBody = {
				"releaseTrainId": releaseTrainId,
				"fetchHierarchies": true,
			}
			axios.post("/releasetrain/fetch-release-train-hierarchies-and-filters", requestBody)
				.then(response => {
					if (response.status == "200" && !_.isEmpty(response.data.hierarchyLevels)) {
						_this.allCollectionItemsGrid.existingItemPopupLinking.almMappingByLevel = _this.setAlmMappingByLevel(response.data.hierarchyLevels, _this.selectedReleaseTrain.linkedAlmAccounts[0].id);
						_this.$store.releaseTrainId = releaseTrainId; // this is required in add existing jira
						_this.allCollectionItemsGrid.existingItemPopupLinking.show = true;

					}
				})
				.catch(error => {
						console.error("Error occurred while fetching hierarchy levels: ", error);

					}
				);
		},
		setAlmMappingByLevel (backlogHierarchyLevels, almId) {
			let almMappingByLevel = {};
			_.each(backlogHierarchyLevels, hierarchyLevels=>{
				_.each(hierarchyLevels.almHierarchyLevelMappings, mapping =>{
					if(mapping.almAccountId == almId) {
						almMappingByLevel[hierarchyLevels.level] = mapping;
					}
				});
			});
			return almMappingByLevel;
		},
		moveItemBatchToBatch:function(context) {
			try{
				//check if link already exists
				this.$options.batchViewUtils.moveLinkedItemsToSelectedBatch(context.sourceBatchId, context.sourceBatchLinks,context.targetBatchId, context.itemId, context.eventContext);
			}catch (e) {
				console.log(e)
				showTopMessage("Failed to render!!", 'warning');
			}
		},
		copyItemBatchToBatch:function(context) {
			try{
				this.$options.batchViewUtils.copyLinkedItemsToSelectedBatch(context.sourceBatchId, context.sourceBatchLinks,context.targetBatchId, context.itemId,context.eventContext, context.targetEventRecord);
				// context.eventContext.finalize(true)
			}catch (e) {
				console.log(e)
				showTopMessage("Failed to render!!", 'warning');
			}
		},
		closeActionPopup:function(context) {
			try {
				this.actionPopup.showPopup = false;
				context.eventContext.finalize(false)
			}catch (e) {
				console.log(e)
			}
		},
		onBackClick: function(){
			try {
				this.$router.back();
			}catch(e) {
				console.error("Issue occurred while navigating back", e);
			}
		},
		fetchSelectedReleaseTrainMeta: function(releaseTrainId) {
			let _this = this;
			let requestBody = {
				"releaseTrainId"   : releaseTrainId,
				"fetchHierarchies" : true,
				"fetchFilters"     : true
			}
			axios.post("/releasetrain/fetch-release-train-hierarchies-and-filters", requestBody)
				.then(response => {
					if (response.status == "200" && response.data.hierarchyLevels) {

						_this.selectedReleaseTrainMeta.itemHierarchyLevels = response.data.hierarchyLevels;

						// _this.selectedReleaseTrainMeta.allFilters = response.data.filterCriterias;

						if (_.isEmpty(_this.selectedReleaseTrainMeta.selectedHierarchyLevel) ||
							_.find(_this.selectedReleaseTrainMeta.itemHierarchyLevels, {id: _this.selectedReleaseTrainMeta.selectedHierarchyLevel.id}) === undefined){
							_this.selectedReleaseTrainMeta.selectedHierarchyLevel = _this.selectedReleaseTrainMeta.itemHierarchyLevels[0];
							if(releaseTrainId) {
								_this.$options.batchViewUtils.loadUnplannedItems(releaseTrainId);
							}
						}
						//pass data to grid dropdowns
						if(_this.$options.unplannedGrid && _this.$options.unplannedGrid.widgetMap['hierarchy-level-dropdown']){
							_this.$options.unplannedGrid.widgetMap['hierarchy-level-dropdown'].items = response.data.hierarchyLevels;
							_this.$options.unplannedGrid.widgetMap['hierarchy-level-dropdown'].value = _this.selectedReleaseTrainMeta.selectedHierarchyLevel;
							_this.$options.unplannedGrid.widgetMap['add-item-menu'].disabled = false;
							_this.$options.unplannedGrid.widgetMap['add-item-menu'].show();

							_this.$options.unplannedGrid.widgetMap['searchField'].show();
							_this.$options.unplannedGrid.widgetMap['prevBtn'].show();
							_this.$options.unplannedGrid.widgetMap['kendis-page-size-dropdown-widget'].show();
							_this.$options.unplannedGrid.widgetMap['kendis-page-index-dropdown-widget'].show();
							_this.$options.unplannedGrid.widgetMap['nextBtn'].show();
						}
					}
				})
				.catch(error => {
					console.error("Error occurred while fetching hierarchy levels: ", error);
				});
		},
		fetchProjectsforCollection: function (releaseTrainKey,almAccountId,almAccountType){
			let _this = this;
			if(!releaseTrainKey || !almAccountId || !almAccountType){
				return;
			}
			axios.get("/releasetrain/fetch-projects-for-collection?collectionKey="+releaseTrainKey
				+"&almAccountId="+almAccountId
				+"&almAccountType="+almAccountType)
				.then(response => {
					if (response.status == "200" && response.data) {
						_this.allCollectionItemsGrid.tfsProjects = response.data.tfsProjects;
						_this.allCollectionItemsGrid.jiraProjects = response.data.jiraProjects;
					}
				})
				.catch(error => {
					console.error("Error occurred while fetching projects for collection: ", error);
				});
		},
		///***********///batch popup ////*********///
		createBatchesMap(newValue){
			if(newValue){
				let map = {};
				// Recursive function to process each batch/item and its children
				const addItemsToMap = (items) => {
					for (let item of items) {
						map[item.id] = item;
						if (item.baseItemList && item.baseItemList.length > 0) {
							addItemsToMap(item.baseItemList); // Recursion for nested items
						}
					}
				};
				// Start the recursion with the top-level batches
				addItemsToMap(newValue);
				this.batchesMap = map;
			}
		},

		setBaseItemStatus: function (requestBody) {
			if (_.isEmpty(requestBody.status)) {
				if(requestBody.type=="Batch"){
					if (_.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"}) !== -1) {
						requestBody.status = _.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"});
					}
				}else{
					if (_.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"}) !== -1) {
						requestBody.status = _.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"});
					}
				}
			}
		},

		showMainLoader(){
			this.loader.show = true;
		},
		hideMainLoader(){
			this.loader.show = false;
		},

		///***********///batch popup ////*********///
		/////page nav///////
		onChangePageSize(){
			this.resetPages();
			this.$options.batchViewUtils.loadUnplannedItems(this.selectedReleaseTrain.id);
		},
		onGridSearch: function (searchText) {
			this.resetPages();
			this.gridFilters.searchText = searchText;
			this.$options._resetPageIndex = true;
			this.$options.batchViewUtils.loadUnplannedItems(this.selectedReleaseTrain.id);
		},
		onPaginatoreChangePage(pageNumber, start, end){
			this.gridPagination.pageIndex = pageNumber;
			this.$options.batchViewUtils.loadUnplannedItems(this.selectedReleaseTrain.id);
		},
		resetPages: function () {
			this.gridPagination.pageIndex = 0;
			this.gridPagination.totalItemSize = 1;
		},
		/////page nav///////
		onSelectReleaseTrain(rt){
			// this.$options.batchViewUtils.loadUnplannedItems(rt.id);
			this.resetPages();
			this.fetchSelectedReleaseTrainMeta(rt.id);
			if(rt.linkedAlmAccounts && rt.linkedAlmAccounts.length>0) { //check if collection is kendis only or not
				this.fetchProjectsforCollection(rt.key, rt.linkedAlmAccounts[0].id, rt.linkedAlmAccounts[0].type);
			}
		},
		onSelectReleaseTrainHierarchy(){
			this.resetPages();
			this.$options.batchViewUtils.loadUnplannedItems(this.selectedReleaseTrain.id);
		},
		loadReleaseTrains: function () {
			let _this = this;
			let data = {};
			data.fetchTypes = false;
			axios.post("/releasetrain/release-trains", data)
				.then(response => {
					if (response.data) {
						_this.releaseTrains = _.filter(response.data.releaseTrains,rt=>{
							return rt.type && rt.type.id;
						});
						_this.selectedReleaseTrain= _this.releaseTrains.find(rt=>rt.key  == _this.releaseTrainId);

						//pass data to grid dropdowns
						if(_this.$options.unplannedGrid && _this.$options.unplannedGrid.widgetMap['collection-select-dropdown']){
							_this.$options.unplannedGrid.widgetMap['collection-select-dropdown'].items = _this.releaseTrains;
						}

					}
				}).catch(error => {
			});
		},
		async attachBackLogItemsToObject(items,releaseTrainId) {
			let _this = this;
			try{
				let focusedBatch = _this.batchesMap[ParentIdUtils.getBatchId(_this.$options.focusedObject.id)]
				if(!focusedBatch) {
					showTopMessage("Internal error please reload.",'warning');
					return;
				}
				let responseData = await _this.$options.batchViewUtils.linkItemsToBatch(focusedBatch, items,releaseTrainId);
				if(responseData && responseData.updatedBacklogItems && responseData.updatedBacklogItems.length > 0) {
					if(_this.selectedReleaseTrain) {
						_this.$options.batchViewUtils.loadUnplannedItems(_this.selectedReleaseTrain.id, true);
					}

					//add in itemsMap
					_.each(responseData.updatedBacklogItems, item => {
						_this.itemsByIdMap[item.id] = item;
					});
					addBatchBaseItemLinks(focusedBatch,items,releaseTrainId);
					_this.$options.batchViewUtils.scheduleItemInBatch(this.$options.focusedObject, responseData.updatedBacklogItems);

					showTopMessage("Items linked successfully.",'success');
				}else{
					showTopMessage("Item Already exists in the batch.",'warning');
				}
			}catch(e){
				console.error(e);
				showTopMessage("Error while linking items to the batch.",'warning')
			}finally {
				this.linkItemPopUp.showLinkItemPopup = false;
			}
		},
		onSelectYearWiseTimeCapsules(selectedOptions){
			// console.log("selectedOptions",selectedOptions);
			if(selectedOptions) {
				// localStorage.setItem(localStorageKeys.selectedYearWiseTimeCapsules,JSON.stringify(selectedOptions));
				//filter evetns based on selected iids
				this.$options.roadmap.eventStore.clearFilters();
				this.$options.roadmap.eventStore.filter({
					filterBy: (event) => {
						if (event.type == EventTypes.TIME_CAPSULE) {
							const eventTimeCapsuleId = event.id.split("_")[1];
							if (selectedOptions.includes(eventTimeCapsuleId)) {
								return true;
							}
							return false;e
						} else if (event.type == EventTypes.ITEM) {
							return true;
						}
						return true

					}
				});
			}

		},
		initViewUtils(){
			this.$options.batchViewUtils = new BatchViewUtils(this,this.$options.roadmap,this.$options.unplannedGrid);
			this.$options.bucketViewUtils = new BucketViewUtils(this);
			this.$options.rawItemsViewUtils = new RawItemsViewUtils(this,this.$options.roadmap,this.$options.unplannedGrid);
		},
		loadSchedulerConfigs() {
			let _this = this;
			_this.$options.roadmap = {};
			_this.$options.unplannedGrid = {};
			_this.initViewUtils();
			const project = new bryntum.schedulerpro.ProjectModel({
				resources: [],
				events: [],
			});
			this.$options.unplannedGridConfig=getUnplannedGridConfig(_this,project);
			this.$options.itemsSchedulerConfig = getItemsViewRoadmapConfig(_this,project);

		},
		onSearchFieldChange: function ({ value }) {

			this.$options.unplannedGrid.features.search.search(value);

		},
		onSearchFieldClear: function () {
			this.$options.unplannedGrid.features.search.clear();
		},
		onClickUnplannedButton() {
			const unplannedGrid = document.querySelector('[data-ref="unplanned"]');

			// Check if the element is currently visible
			if (unplannedGrid.style.display === 'none' || unplannedGrid.style.display === '') {
				// If it's hidden (or display is not set), show it
				unplannedGrid.style.display = 'flex';
				this.showUnplannedGrid = true;
			} else {
				// If it's currently shown, hide it
				unplannedGrid.style.display = 'none';
				this.showUnplannedGrid = false;

			}
		},
		onViewPresetSelectValue: function () {
			localStorage.setItem(this.releaseTrain.id + "_ROADMAP_PRESET_"+this.roadmap.id, this.viewPreset.value);

			// Retrieve the corresponding preset based on selected value or default to week if undefined
			this.$options.roadmap.viewPreset = getPresetFactory(this.$options.roadmap,this.viewPreset.value)
			zoomToCompleteTimeRange(this.$options.roadmap,this.viewPreset.value); // Zoom to the complete time range

		},
		fetchData: function () {
			//this.loadRoadmapItems();
			// if(this.$options.firstOpenUnplannedGrid) {
			// 	this.loadUnplannedOnClick();
			// }
			this.loadData();
		},
		onResetSearch(){
			this.filters.searchText = "";
			// if(this.$options.firstOpenUnplannedGrid) {
			// 	this.loadUnplannedOnClick();
			// }
			this.loadData();
		},
		onSaveRoadMapYearConfig: function(roadmapYearsConfigs){
			this.settings.show = false;
			this.roadmap.roadmapYearsConfigs = roadmapYearsConfigs;
			this.setTimeRanges(this.getTimeRanges())
		},
		modifyRoadmapYearsConfigs(yearConfigs) {
			let _this = this;
			yearConfigs.forEach(config => {
				_this.$set(config,'selectedPartitionView',{})
			});
			return yearConfigs;

		},
		getTimeCapsule(idToSearch) {
			return _.find(this.store.gettimeCapsules, {id: idToSearch});
		},
		setTimeRanges(runtimeTimeRanges){
			let _this = this;
			_this.$options.roadmap.features.timeRanges.store.removeAll();
			runtimeTimeRanges.forEach(timeRange => {
				_this.$options.roadmap.features.timeRanges.store.add(timeRange);
			});
			},
		isValidToShow(timeRangeStartDate, timeRangeEndDate) {
			let _this = this;
			if (timeRangeStartDate.getFullYear() != timeRangeEndDate.getFullYear()) {
				if(_this.roadmapYearsConfigsMap[timeRangeStartDate.getFullYear()] == "CUSTOM"
				&& _this.roadmapYearsConfigsMap[timeRangeEndDate.getFullYear()] == "CUSTOM") {
					return true;
				}
				return false;
			}
			if(_this.roadmapYearsConfigsMap[timeRangeStartDate.getFullYear()] == "QUARTERLY" && isQuarter(timeRangeStartDate, timeRangeEndDate)) {
					return true;
			}
			if(_this.roadmapYearsConfigsMap[timeRangeStartDate.getFullYear()] == "HALF_YEARLY" && isHalfYear(timeRangeStartDate, timeRangeEndDate)) {
				return true;
			}
			if(_this.roadmapYearsConfigsMap[timeRangeStartDate.getFullYear()] == "YEARLY" && isYear(timeRangeStartDate, timeRangeEndDate)) {
				return true;
			}
			return false;
		},
		loadRollups: function () {
			
			let _this = this;
			let allItemIds = [];
			_.each(this.$options.roadmap.eventStore.allRecords,record=>{
				allItemIds.push(record.id);
			});
			this.rollups.allItems = allItemIds;
			
			let firstLoad = [];
			
			if (allItemIds.length <= this.rollups.pageSize) {
				this.rollups.pageStart = 0;
				firstLoad = allItemIds;
			}
			else {
				this.rollups.pageStart = 0;
				firstLoad = allItemIds.slice(this.rollups.pageStart, (this.rollups.pageSize+this.rollups.pageStart));
			}
			this.loadRollupsChunk (firstLoad);
		},
		loadRollupsChunk: function (itemIds) {
			
			if (this.percentage.value == "") {
				return;
			}
			
			let options = {};
			options.rollupStoryPointsArray = true;
			
			let _this = this;
			this.loadingItemRollups = true;
			
			this.loadItemsRollups(itemIds,response=> {

				_this.loadingItemRollups = true;

				if (response.items) {
					let items = response.items;
					_this.handleRollupResponse(items);

					_this.rollups.pageStart = _this.rollups.pageStart + items.length;
					let remaining = _this.rollups.allItems.length - _this.rollups.pageStart;
					if (remaining > 0) {
						let nextLoadCount = this.rollups.pageSize;
						if (remaining < this.rollups.pageSize) {
							nextLoadCount = remaining;
						}
						let nextLoad = allItemIds.slice(this.rollups.pageStart, (nextLoadCount+this.rollups.pageStart));
						_this.loadRollupsChunk(nextLoad);
					}
				}
			},options);
		},
		handleRollupResponse: function (items) {
			let _this = this;
			_.each(items,item=>{
				_this.rollupsByIdMap[item.id] = item;
			});
			_.each(_this.$options.roadmap.eventStore.allRecords,record=>{
				let rollup = _this.rollupsByIdMap[record.id];
				if (rollup) {
					//......   set percentage
					if (_this.percentage.value != "") {
						_this.calculateItemPercentage(rollup);
						record.percentDone = rollup.percentDone;
					}else {
						record.percentDone = -1;
					}
				}
			});
		},
		sortItems(items) {
			let _this = this;

			// Multi-Field Sort
			let sortedItems =  items.sort(function(item1, item2) {
				if(_this.sort.fields.length > 0) {
					for(let i = 0; i < _this.sort.fields.length; i++) {
						let currentSortField = _this.sort.fields[i];
						if(currentSortField.order == 'ASC') {
							if(item1.hasOwnProperty(currentSortField.fieldName) &&
								item2.hasOwnProperty(currentSortField.fieldName)) {

								if(item1[currentSortField.fieldName] > item2[currentSortField.fieldName]) {
									return 1;
								} else if ( item1[currentSortField.fieldName] < item2[currentSortField.fieldName]) {
									return -1;
								} else {
									continue;
								}
							}
						} else if(currentSortField.order == 'DESC') {
							if(item1.hasOwnProperty(currentSortField.fieldName) &&
								item2.hasOwnProperty(currentSortField.fieldName)) {

								if (item1[currentSortField.fieldName] > item2[currentSortField.fieldName]) {
									return -1;
								} else if (item1[currentSortField.fieldName] < item2[currentSortField.fieldName]) {
									return 1;
								} else {
									continue;
								}

							}
						}
					}
				}

			});

			if(sortedItems.length > 0) {
				return sortedItems;
			}
			return items;
		},
		initView: function() {
			if (_.isEmpty(this.releaseTrain)) return;
			const { id: releaseTrainId } = this.releaseTrain;
			const roadmapGroupByKey = `${releaseTrainId}_${this.roadmapId}_Roadmap_GroupBy`;
			const roadmapGroupByUnplannedKey = `${releaseTrainId}_${this.roadmapId}_Roadmap_GroupBy_Unplanned`;
			this.groupBy.value = localStorage.getItem(roadmapGroupByKey) || this.groupBy.defaultSelectedGroupId;
			this.groupByUnplanned.value = localStorage.getItem(roadmapGroupByUnplannedKey) || groupByValues.Section;
			if (this.groupBy.value !== "-1") {
				this.groupBy.applied = true;
			}
			this.loadRoadmap();
		},
		initGroupByOptions(){
			if (this.almAccountType === "tfs") {
				this.groupBy.options.push({ title: "Project", id: "Project" });
				this.groupBy.options.push({ title: "Area Path", id: "AreaPath" });
				this.groupBy.options.push({ title: "Iteration Path", id: "Iteration" });
				if (!_.isEmpty(this.almMappingByLevel[this.roadmap.level])) {
					_.each(this.almMappingByLevel[this.roadmap.level].tfsFields, field => {
						if (field && field.referenceName && field.type != 'treePath') {
							this.groupBy.options.push({ title: field.name, id: field.referenceName.replace(".","_") });
							if (field.referenceName.replace(".","_") == this.groupBy.value) {
								this.groupBy.type = field.type;
							}
						}
					});
				}
			}else {
				if(!_.isEmpty(this.almMappingByLevel[this.roadmap.level])) {
					_.each(this.almMappingByLevel[this.roadmap.level].jiraFields, field=>{
						if(field && field.id) {
							this.groupBy.options.push({title: field.name, id: field.id});
							if(field.id == this.groupBy.value) {
								this.groupBy.type = field.schema.type;
								if(field.schema.items) {
									this.groupBy.itemType = field.schema.items;
								}
								if (field.custom) {
									this.groupBy.customType = field.schema.custom;
								}
							}
						}
					});
				}
			}
		},
		
		/**
		 * Initializes the group by combo box in the unplanned grid toolbar
		 */
		initUnplannedGridGroupBy() {
			if (this.$options.unplannedGrid && this.$options.unplannedGrid.widgetMap.groupByCombo) {
				const groupByCombo = this.$options.unplannedGrid.widgetMap.groupByCombo;
				
				// Populate the combo with group by options
				groupByCombo.store.data = this.groupBy.options;
				
				// Set a flag to prevent onChange from triggering loadUnplannedOnClick
				this.isInitializingGroupBy = true;
				
				// Set the current value
				groupByCombo.value = this.groupByUnplanned.value;
				
				// Clear the flag after a short delay to allow the value to be set
				this.$nextTick(() => {
					this.isInitializingGroupBy = false;
				});
				
				// Show/hide based on grid child mode
				if (this.isGridChildMode) {
					groupByCombo.hide();
				} else {
					groupByCombo.show();
				}
			}
		},
		mockRoadMap(){
			const mockedRoadMap = {
				name: "Roadmap",
			}
			this.roadmap =  mockedRoadMap;
		},

		updateRelatedEventDates: function (itemId, startDate, endDate) {
			let _this = this;

			// Start a batch operation if supported
			this.$options.roadmap.eventStore.beginBatch();

			this.$options.roadmap.eventStore.allRecords.forEach(record => {
				if (record.orgId == itemId) {
					// Use the set method to ensure changes are reactive and properly tracked
					record.setStartDate(startDate, true); // The second argument true skips layout update for each change
					record.setEndDate(endDate, true);
				}
			});

			// End the batch operation, triggering any necessary updates or re-renders
			this.$options.roadmap.eventStore.endBatch();
		},
		initRoadmap() {
			let _this = this;
			if (bryntum.schedulerpro.Scheduler) {
				const schedule = new bryntum.schedulerpro.SchedulerPro(_this.$options.itemsSchedulerConfig);
				schedule.on('beforeCellEditStart', function({ source, editorContext }) {
						if( _this.groupBy.value!==groupByValues.Section || editorContext.record.id===milestoneResourceId || editorContext.record.id==="null"){
							return false;
						}
				});
				schedule.eventStore.reapplyFilterOnAdd= true;
				schedule.eventStore.reapplyFilterOnUpdate= true;
				// schedule.features.timeRanges.disabled = !_this.timeRangesDisplaySettings.showTimeRanges;
				new  bryntum.schedulerpro.Splitter({
					appendTo : 'roadmap'
				});
				const unplannedGrid = new UnplannedGrid(_this.$options.unplannedGridConfig);
				this.$options.unplannedGrid = unplannedGrid;
				const drag = new DragHelperItemsRoadmap({
					grid         : unplannedGrid, schedule,
					constrain    : false,
					outerElement : unplannedGrid.element
				});
				schedule.features.drag = {
					// Enable dragging
					enabled: true
				};
				this.$options.roadmap = schedule;
				// this.updatePreset();
			}
		},
		createEventCopy: function (item, startDate, endDate, groupId,scheduler) {
			let _this = this;
			let itemId;
			if(groupId && groupId.length>0){
				itemId=item.id+"_"+groupId;
			}else{
				itemId=item.id;
			}

			let event = _this.createItemForRoadmap(item);
			if(groupId && groupId != ""){ //in case of groupby applied
				event.resourceId = groupId;
				event.batchRelationId=groupId;
				event.batchRelationName = (_this.$root.$options.meta.batches && _this.$root.$options.meta.batches[groupId])? (_this.$root.$options.meta.batches[groupId].key+" : "+_this.$root.$options.meta.batches[groupId].title):"...";
				event.sequence          = (_this.$root.$options.meta.batches && _this.$root.$options.meta.batches[groupId])? (_this.$root.$options.meta.batches[groupId].sequence):"";

			}else{
				event.resourceId = "all_items";
			}
			event.id =itemId;
			event.ttype = "item";
			event.title = item.title;
			
			// Mark as parent item when in individual item resources mode
			if (_this.showIndividualItemResources) {
				event.isParent = true;
				event.cls = 'kendis-parent-item';
			}
			
			event.startDate = new Date(startDate);
			event.endDate = new Date(endDate);
			//chech for duplicate
			_this.$options.roadmap.eventStore.add(event);
			// _this.onZoomChangeLevel('f');
		},
		moveEvent: function (eventRecord, resourceId,scheduler) {
			//get event using id
			let event = scheduler.eventStore.getById(eventRecord.id)
			//update event resource
			event.resourceId = resourceId;
			//refresh
			scheduler.refresh();
		},
		attachItemWithBatch: function(items, batchId,releaseTrainId, oldBatchId) {

			var _this = this;
			var itemContainers = [];
			var linkedItemMap = {};

			//create link map of already attached items
			let batch = _this.$root.$options.meta.batches[batchId];
			if(batch) {
				_.each(batch.baseItemLinks, link => {
					if (link.baseItemId && link.linkType == 'backLogItem' && link.releaseTrainId == releaseTrainId) {
						linkedItemMap[link.baseItemId] = link;
					}
				});
				_.each([items], item => {
					var itemContainer = {};
					if (linkedItemMap[item.id]) {
						itemContainer.id = linkedItemMap[item.id].id;
					}
					else{
						//modifying batches store for rendering
						batch.baseItemLinks.push({baseItemId: item.id, linkType: 'backLogItem', releaseTrainId: releaseTrainId});
					}
					// itemContainer.sessionId = item.sessionBoards[0].session.id;
					itemContainer.baseItemId = item.id;
					itemContainer.releaseTrainId = releaseTrainId;
					itemContainers.push(itemContainer);
				});

				var requestBody = {};
				requestBody.id = batchId
				requestBody.baseItemLinks = itemContainers;
				axios.post('/batch/link-backLogItems-with-batch/' + syncId, requestBody)
					.then(response => {
						if (response.status == "200" && response.data) {
							let destinationResource =  roadmapVue.$options.roadmap.resourceStore.getById(batchId);
							// destinationResource.groupItems.concat(items);
						}
					});
			}else if(oldBatchId) {
				var requestBody = {};
				requestBody.batchId = oldBatchId
				requestBody.backlogItemId = items.id;
				axios.post('/batch/unlink-backlog-item-batch/' + syncId, requestBody)
					.then(response => {
						if (response.status == "200" && response.data) {
							let sourceResource =  roadmapVue.$options.roadmap.resourceStore.getById(oldBatchId);
							//remove item from source
							// sourceResource.groupItems = sourceResource.groupItems.filter(item => item.id != items.id);
						}
					});
			}
		},
		unlinkBackLogItem(itemId,baseItemId){
			let data = {};
			data.backlogItemId = itemId;
			data.batchId = baseItemId;
			let url = '/batch/unlink-backlog-item-batch/' + syncId;
			axios.post( url, data)
				.then(res => {
					if (res.status=="200"  ) {
						// _this.loader.show = false;
						// showTopMessage("Backlog Item Unlinked Successfully.", "success");
						// _this.$emit('unlinkBackLogItem',itemId);
					}
				})
				.catch(err => {
					console.log(err);
				}).finally(() => {
			});
		},
		moveItemWithinBatches(sourceBatchId,destinationBatchId,itemId,releaseTrainId){
			console.log("move item from "+sourceBatchId+" to "+destinationBatchId +" item id "+itemId+" release train id "+releaseTrainId);
			try {
				this.attachItemWithBatch({id: itemId}, destinationBatchId, releaseTrainId);
				this.unlinkBackLogItem(itemId, sourceBatchId);
			}catch (e) {
				alertFromSweetAlertWrapper("Error while moving item", "error");
			}
		},
		attachItemWithTimeCapsule: function(item, timeCapsuleId) {
			try {
				let orgItem = this.itemsByIdMap[item.id];
				let newRelation = {
					"customId": timeCapsuleId,
				}
				item.timeCapsuleRelation = newRelation;
				this.saveItem(item);
			}catch (e) {
				alertFromSweetAlertWrapper("Error while linking with Time Range", "error");
			}
		},
		attachBackLogItems: function(items, releaseTrainId) {},
		getBoardDates: function (board) {
			let containers = Object.values(this.$root.$options.meta.containers);
			let sbContainers = _.filter(containers,{"sessionBoardId":board.activeSessionBoard});

			let startDate = undefined;
			let endDate = undefined;
			_.each(sbContainers, container => {
				if (container.startDate && (startDate == undefined || container.startDate < startDate)) {
					startDate = container.startDate;
				}
				if (container.endDate && (endDate == undefined || container.endDate > endDate)) {
					endDate = container.endDate;
				}
			});
			if (startDate != undefined) {
				startDate = new Date(startDate);
			}
			if (endDate != undefined) {
				endDate = new Date(endDate);
			}
			return [startDate,endDate];
		},
		getItemDates: function (item) {

			let containers = this.getUniqueContainers(item, true);
			let startDate = undefined;
			let endDate   = undefined;

			_.each(containers, container => {
				if (container.startDate && (startDate == undefined || container.startDate < startDate)) {
					startDate = container.startDate;
				}
				if (container.endDate && (endDate == undefined || container.endDate > endDate)) {
					endDate = container.endDate;
				}
			});
			if (startDate != undefined) {
				startDate = new Date(startDate);
			}
			if (endDate != undefined) {
				endDate = new Date(endDate);
			}
			return [startDate,endDate];
		},
		setRoadmapData: function(items, clear) {
			let _this = this;
			let resources = [];
			let events = [];
			let unplannedEvents = [];
			let assignments = []
			try {
				if(_this.$options.unplannedGrid.store.data && _this.$options.unplannedGrid.store.data.length > 0){
					unplannedEvents = _this.$options.unplannedGrid.store.data;
				}
				if (clear) {
					_this.$options.roadmap.eventStore.removeAll();
					_this.$options.roadmap.resourceStore.removeAll();
					_this.$options.unplannedGrid.store.data = [];
				}

				//......   add item placeholder resource
				if (!_this.groupBy.applied) {
					let noGroup = _this.createGroupItemForRoadmap({});
					noGroup.title = "All Items";
					noGroup.name = "All Items";
					noGroup.id = "all_items";
					noGroup.expanded = false;
					// noGroup.groupItems = [];
					_.each(items, item => {
						let compositeKey = item.id;
						let copy = {};

						copy.almAccountId = item.almAccountId;
						copy.almErrors = item.almErrors;
						copy.almItemId = item.almItemId;
						copy.almKey = item.almKey;
						copy.almType = item.almType;
						copy.artRelationMap = item.artRelationMap;
						copy.batchRelations = item.batchRelations;
						copy.boardRelations = item.boardRelations;
						copy.childBoards = item.childBoards;
						copy.childRelationMap = item.childRelationMap;
						copy.childSolutionBoards = item.childSolutionBoards;
						copy.childStoryPoints = item.childStoryPoints;
						copy.createdBy = item.createdBy;
						copy.createdOn = item.createdOn;
						copy.dirty = item.dirty;
						copy.fetchedBy = item.fetchedBy;
						copy.fields = item.fields;
						copy.filterIds = item.filterIds;
						copy.objectiveRelations = item.objectiveRelations;
						copy.parentRelationMap = item.parentRelationMap;
						copy.relations = item.relations;
						copy.solutionRelations = item.solutionRelations;
						copy.status = item.status;
						copy.title = item.title;
						copy.updatedBy = item.updatedBy;
						copy.updatedOn = item.updatedOn;
						copy.url = item.url;

						let event = _this.createFilterEventForRoadmap(copy);

						event.id = compositeKey;
						event.orgId = compositeKey;
						event.groupId = ["all_items"];
						// event.sessionBoardId = boardLink.sessionBoardId;
						event.ttype = "item";
						if(_this.displayMode.value===DisplayModes.RAW_ITEMS
							&& (item.fields.StartDate && item.fields.EndDate || item.timeCapsuleRelation)){
							event.cls = styledClasses.rawViewPlannedItems;
						}
						if (item.fields.StartDate && item.fields.EndDate) {
							let itemStartDate = new Date(item.fields.StartDate);
							let itemEndDate = new Date(item.fields.EndDate);
							itemStartDate.setHours(0, 0, 0, 0); // for complete time range cover
							itemEndDate.setHours(23, 59, 59, 999);
							event.startDate = itemStartDate;
							event.endDate = itemEndDate;
							events.push(event);
							assignments.push({id : 'a-'+compositeKey ,resourceId: "all_items", eventId: compositeKey});
							// noGroup.groupItems.push(item);

						}
						else
						if (item.timeCapsuleRelation){
							let timeCapsule = _this.getTimeCapsule(item.timeCapsuleRelation.customId);
							let timeCapsuleStartDate = new Date(timeCapsule.startDate);
							let timeCapsuleEndDate = new Date(timeCapsule.endDate);
							timeCapsuleStartDate.setHours(0, 0, 0, 0);
							timeCapsuleEndDate.setHours(23, 59, 59, 999);
							event.startDate = timeCapsuleStartDate
							event.endDate = timeCapsuleEndDate
							events.push(event);
							assignments.push({id : 'a-'+compositeKey ,resourceId: "all_items", eventId: compositeKey});
						}
						else {
							if(_this.displayMode.value===DisplayModes.RAW_ITEMS )
							{event.cls = styledClasses.rawViewUnplannedItems;}
							event.startDate = '';
							event.endDate = '';
							event.duration = _this.defaultDuration;
							event.durationUnit = _this.defaultDurationUnit;
							unplannedEvents.push(event);
						}
					});
					// noGroup.groupItems = _.sortBy(noGroup.groupItems, "sequence");
					_this.$options.unplannedGrid.store.data = (unplannedEvents);
					// _this.$options.roadmap.resources = resources;
					//if resource already exists then dont push
					if(!_this.$options.roadmap.resourceStore.getById("all_items")){
						resources.push(noGroup);
						_this.$options.roadmap.resources = resources;
					}
					_this.$options.roadmap.eventStore.add(events);
					_this.$options.roadmap.assignmentStore.add(assignments)
				}

			} catch (error) {
				console.log(error);
			} finally {
				this.$options.roadmap.refresh();
			}
		},
		addSectionAtEnd(){
			let _this = this;
			this.$options.roadmapSectionsCrud.addSectionAtEnd({
				name : _this.$options.roadmapSectionsCrud.getNewSectionName(),
				parentRoadmapId: this.roadmap.id,
			})
		},
		showMilestoneMenu: function (event){
            if (event) {
                // Capture the position of the button and round the values
                const buttonRect = event.target.getBoundingClientRect();

                this.milestoneMenuPopupPosition.top = Math.round(buttonRect.top + window.scrollY);
                this.milestoneMenuPopupPosition.left = Math.round(buttonRect.left + window.scrollX);
            }else{
                this.milestoneMenuPopupPosition.top = 0;
                this.milestoneMenuPopupPosition.left = 0;
            }
            this.showAddMilestoneMenu = true;
        },
        hideMilestoneMenu() {
            this.showAddMilestoneMenu = false;
        },
        onAddExistingMilestone(sectionId = null){
           if (!_.isEmpty(this.milestoneData.milestones)) {
			   let allMilestones = this.milestoneData.milestones;
                this.addMilestoneToBoardPopup.boardItems = _.map(allMilestones, milestone => milestone.id);
            }
            this.addMilestoneToBoardPopup.releaseTrain = this.store.releaseTrain;
            this.addMilestoneToBoardPopup.boardId = this.roadmap.id;
            // Store sectionId if adding existing milestone to a specific section
            this.addMilestoneToBoardPopup.sectionId = sectionId;
			this.addMilestoneToBoardPopup.viewType = this.roadmap.viewType;
			this.addMilestoneToBoardPopup.show = true;


            this.showAddMilestoneMenu = false;
        },
        onAddMilestoneToBoardPopupClose: function() {
			//this.addMilestoneToBoardPopup.boardItems = undefined;
			this.addMilestoneToBoardPopup.show = false;
			this.addMilestoneToBoardPopup.sectionId = null; // Clear sectionId
		},
		onAddToBoardPopupItemSelectedMilestone: function (itemData, shouldClose) {
			//.......   add item
			let item = itemData.item;
			if(item.fields.itemType === "Milestone" || item.fields.itemType === "Phase") {
				//item.rollup = true;
                showTopMessage(item.fields.itemType +" added successfully", 'success', 1000);
				this.milestoneMapById[item.id] = item;
				this.milestoneData.milestones.push(item);
                
				// If adding to a specific section, populate section relations
				if (this.addMilestoneToBoardPopup.sectionId) {
					this.populateMilestoneSectionRelations(item, this.addMilestoneToBoardPopup.sectionId);
					let groupId = this.addMilestoneToBoardPopup.sectionId;
					//link to section
					let RTItemsOperationsDTO = {
						itemId: item.id,
						operation: 'MOVE_FIELD',
						collectionId: this.store.releaseTrain.id,
						sourceFieldId: '',
						destinationFieldId: groupId==="null"? '':groupId,
						fieldName: 'sectionRelations'
					};
					fetch('/releasetrain/item/update-field',{
						method: 'PUT',
						headers: getFetchAPIHeadersForKendis(),
						body: JSON.stringify(RTItemsOperationsDTO)
					}).then(response => {
						console.log('Success:', response);
					}).catch(error => {
						console.error('Error:', error);
					})
				}
				
                this.addMileStoneInRoadMap(item);
			} else {
				//this.addNewItemsToTimeline([itemData.item]);
			}
			if(shouldClose) {
				this.onAddMilestoneToBoardPopupClose();
			}
		},
		onArchivedMilestonesError: function(archivedMilestones) {
            let _this = this;
            if (this.addMilestoneToBoardPopup.show) {
                this.onAddMilestoneToBoardPopupClose();
            }

            let errorMsgHtml = `<span>`;

            archivedMilestones.forEach((milestone, index) => {
                // Escape milestone.kendisKey and milestone.title to prevent XSS
                let kendisKey = milestone.kendisKey.replace(/</g, "&lt;").replace(/>/g, "&gt;");
                let title = milestone.title.replace(/</g, "&lt;").replace(/>/g, "&gt;");
                errorMsgHtml += `<span class="key FN fs-13">${kendisKey}</span>${title}`;
                if (index < archivedMilestones.length - 1) {
                    errorMsgHtml += ', ';
                }
            });

            if (archivedMilestones.length > 1) {
                errorMsgHtml += ` are archived and cannot be linked with this board.`;
            } else {
                errorMsgHtml += ` is archived and cannot be linked with this board.`;
            }
            errorMsgHtml += `</span>`;

            setTimeout(function() {
                _this.milestoneFieldUpdateMessage.text = errorMsgHtml;

                // Set text to empty string after 3000ms
                setTimeout(function() {
                    _this.milestoneFieldUpdateMessage.text = "";
                }, 3000);
            }, 2000);
        },
        onCreateMilestonePopup(event, item, sectionId = null){
			if(item) {
				this.milestoneData.milestonePopup.item = item;

                if(item.fields && item.fields.selectedCalculationCriteria) {
                    this.milestoneData.milestonePopup.selectedCalculationCriteria = item.fields.selectedCalculationCriteria;
                }
				this.milestoneData.milestonePopup.isUpdate = true;
			}
			
			// Store sectionId if creating milestone from a section milestone resource
			if (sectionId) {
				console.log('Creating milestone for section:', sectionId);
				this.milestoneData.milestonePopup.sectionId = sectionId;
				console.log('Section ID stored for milestone creation:', sectionId);
			}
			
			this.milestoneData.milestonePopup.releaseTrain = this.store.releaseTrain;
			this.milestoneData.milestonePopup.level 	   = this.currentHierarchyLevel;
			this.milestoneData.milestonePopup.statuses     = this.store.milestoneStatuses;
			this.milestoneData.milestonePopup.boardId      = this.roadmap.id;
			this.milestoneData.milestonePopup.show         = true;
			//this.addMilestonePopup.show                    = false;
		},
		onSaveMilestone(itemData){
			let item = itemData.item;
			if (item.status) { //bug fix
				item.status = this.store.getStatusMap[item.status.id];
			}
			
			// Handle section relations if milestone was created from a section milestone resource
			if (this.milestoneData.milestonePopup.sectionId) {
				this.populateMilestoneSectionRelations(item, this.milestoneData.milestonePopup.sectionId);
				let groupId = this.milestoneData.milestonePopup.sectionId;
				//link to section
				let RTItemsOperationsDTO = {
					itemId: item.id,
					operation: 'MOVE_FIELD',
					collectionId: this.store.releaseTrain.id,
					sourceFieldId: '',
					destinationFieldId: groupId==="null"? '':groupId,
					fieldName: 'sectionRelations'
				};
				fetch('/releasetrain/item/update-field',{
					method: 'PUT',
					headers: getFetchAPIHeadersForKendis(),
					body: JSON.stringify(RTItemsOperationsDTO)
				}).then(response => {
					console.log('Success:', response);
				}).catch(error => {
					console.error('Error:', error);
				})
			}
			
			this.createMilestoneGroupIfNotExist();
			
			// Check if this is a new milestone or an existing one
			const existingMilestone = this.milestoneMapById[item.id];
			if (existingMilestone) {
				// Update existing milestone
				console.log(`Updating existing milestone: ${item.title}`);
				this.addMilestones(item);
			} else {
				// Add new milestone
				console.log(`Adding new milestone: ${item.title}`);
				// Add to milestoneData.milestones array
				this.milestoneData.milestones.push(item);
				this.addMileStoneInRoadMap(item);
			}
			
			this.onCreateMilestonePopup(null, item);
		},
		
		/**
		 * Populates section relations for a milestone when created from a section milestone resource
		 * @param {Object} milestone - The milestone item
		 * @param {String} sectionId - The ID of the section
		 */
		populateMilestoneSectionRelations(milestone, sectionId) {
			console.log('Populating section relations for milestone:', milestone.title, 'with section:', sectionId);
			
			// Initialize sectionRelations if it doesn't exist
			if (!milestone.sectionRelations) {
				milestone.sectionRelations = [];
			}
			
			// Check if section relation already exists
			const existingRelation = milestone.sectionRelations.find(rel => rel.baseItemId === sectionId);
			if (existingRelation) {
				console.log('Section relation already exists for milestone');
				return;
			}
			
			// Create new section relation
			const sectionRelation = {
				linkType: "roadmap-section",
				baseItemId: sectionId,
				releaseTrainId: this.store.releaseTrainId,
				isSystemLink: true,
				weightage: 1,
				archive: false,
				tenant: this.store.tenant || "",
				rowStatus: 0
			};
			
			milestone.sectionRelations.push(sectionRelation);
			console.log('Added section relation to milestone:', sectionRelation);
		},
		
		/**
		 * Shows a popup menu for adding milestones to a section
		 * @param {String} sectionId - The ID of the section
		 * @param {Event} event - The click event
		 */
		showSectionMilestoneMenu(sectionId, event) {
			// Create a simple popup menu with two options
			const popup = document.createElement('div');
			popup.className = 'kendis-section-milestone-menu';
			popup.style.cssText = `
				position: absolute;
				background: white;
				border: 1px solid #ddd;
				border-radius: 4px;
				box-shadow: 0 2px 8px rgba(0,0,0,0.1);
				padding: 8px 0;
				z-index: 1000;
				min-width: 180px;
			`;
			
			// Position the popup near the clicked button
			const rect = event.target.getBoundingClientRect();
			popup.style.left = rect.left + 'px';
			popup.style.top = (rect.bottom + 5) + 'px';
			
			// Create menu items
			const createNewOption = document.createElement('div');
			createNewOption.className = 'kendis-menu-item';
			createNewOption.style.cssText = `
				padding: 8px 16px;
				cursor: pointer;
				display: flex;
				align-items: center;
				gap: 8px;
				font-size: 14px;
			`;
			createNewOption.innerHTML = '<i class="ti-plus"></i> Create New Milestone';
			createNewOption.onclick = () => {
				this.onCreateMilestonePopup(event, null, sectionId);
				document.body.removeChild(popup);
			};
			
			const addExistingOption = document.createElement('div');
			addExistingOption.className = 'kendis-menu-item';
			addExistingOption.style.cssText = `
				padding: 8px 16px;
				cursor: pointer;
				display: flex;
				align-items: center;
				gap: 8px;
				font-size: 14px;
				border-top: 1px solid #eee;
			`;
			addExistingOption.innerHTML = '<i class="ti-link"></i> Add Existing Milestone';
			addExistingOption.onclick = () => {
				this.onAddExistingMilestone(sectionId);
				document.body.removeChild(popup);
			};
			
			// Add hover effects
			[createNewOption, addExistingOption].forEach(item => {
				item.onmouseenter = () => {
					item.style.backgroundColor = '#f8f9fa';
				};
				item.onmouseleave = () => {
					item.style.backgroundColor = 'transparent';
				};
			});
			
			// Add items to popup
			popup.appendChild(createNewOption);
			popup.appendChild(addExistingOption);
			
			// Add to body
			document.body.appendChild(popup);
			
			// Close popup when clicking outside
			const closePopup = (e) => {
				if (!popup.contains(e.target) && e.target !== event.target) {
					document.body.removeChild(popup);
					document.removeEventListener('click', closePopup);
				}
			};
			
			// Delay adding the listener to avoid immediate closure
			setTimeout(() => {
				document.addEventListener('click', closePopup);
			}, 100);
		},
		
		/**
		 * Creates a milestone for a specific section
		 * @param {String} sectionId - The ID of the section
		 * @param {Event} event - The click event
		 */
		onCreateSectionMilestone(sectionId, event) {
			console.log('Creating milestone for section:', sectionId);
			
			// Get section info for context
			const section = this.$options.roadmapSectionsCrud.getSectionById(sectionId);
			if (!section) {
				showBryntumToastMessage('Section not found', 'error');
				return;
			}
			
			console.log('Section found:', section.name);
			
			// Open milestone popup with section context
			this.onCreateMilestonePopup(event, null, sectionId);
		},
		
		/**
		 * Gets the count of milestones for a specific section
		 * @param {String} sectionId - The ID of the section
		 * @returns {Number} - Count of milestones in the section
		 */
		getSectionMilestoneCount(sectionId) {
			if (!this.$options.roadmap || !this.$options.roadmap.eventStore) {
				return 0;
			}
			
			// Count events in the scheduler that are milestones/phases and belong to this section
			let count = 0;
			this.$options.roadmap.eventStore.allRecords.forEach(event => {
				// Check if event is a milestone or phase
				if (event.get('ttype') === 'milestone' || event.get('ttype') === 'phase') {
					// Check if event belongs to this section
					if (event.resource && event.resource.id === sectionId) {
						count++;
					}
				}
			});
			
			return count;
		},
		
		/**
		 * Gets the count of items for a specific section
		 * @param {String} sectionId - The ID of the section  
		 * @returns {Number} - Count of items in the section
		 */
		getSectionItemCount(sectionId) {
			if (!this.$options.roadmap || !this.$options.roadmap.eventStore) {
				return 0;
			}
			
			// In "show children" mode, count child resources (item resources) under this section
			if (this.showIndividualItemResources) {
				const sectionResource = this.$options.roadmap.resourceStore.getById(sectionId);
				if (sectionResource && sectionResource.children) {
					// Count child resources that are item resources (end with _item_)
					return sectionResource.children.filter(child => 
						child.id && child.id.includes('_item_')
					).length;
				}
				return 0;
			}
			
			// In normal mode, count events in the scheduler that are items and belong to this section
			let count = 0;
			this.$options.roadmap.eventStore.allRecords.forEach(event => {
				// Check if event is an item (not milestone or phase)
				if (event.get('ttype') === 'item') {
					// Check if event belongs to this section (either directly or through items resource)
					if (event.resource) {
						const resourceId = event.resource.id;
						// Direct assignment to section resource (shouldn't happen in new structure)
						if (resourceId === sectionId) {
							count++;
						}
						// Assignment to items resource of this section (format: sectionId_items)
						else if (resourceId === `${sectionId}_items`) {
							count++;
						}
					}
				}
			});
			
			return count;
		},
		onCloseMilestonePopup(){
			this.milestoneData.milestonePopup.show = false;
			this.milestoneData.milestonePopup.releaseTrain = {};
            this.milestoneData.milestonePopup.level = {};
			this.milestoneData.milestonePopup.statuses = [];
			this.milestoneData.milestonePopup.isUpdate = false;
			this.milestoneData.milestonePopup.item = {};
			this.milestoneData.milestonePopup.boardId = undefined;
            this.milestoneData.milestonePopup.selectedCalculationCriteria = "";
			this.milestoneData.milestonePopup.sectionId = null; // Reset section ID
		},
		editMilestonePermission() {
            return this.store.isActionAllowed("edit-milestone");
        },
		deleteMilestonePermission() {
            return this.store.isActionAllowed("delete-milestone");
        },
        linkUnlinkItemsPermission() {
            return this.store.isActionAllowed("link-unlink-items-in-milestone");
        },
		onClickArchiveMilestone(item){
			let _this = this;
            _this.archiveMilestones([item.id], true);
		},
		archiveMilestones: function (itemIds, archive) {

			let _this = this;
			let data = {};
			// data.releaseTrainId = this.releaseTrain.id;
			data.itemIds = itemIds;
			data.archieve = archive;

			let requestId = getNewUUID();
			data.syncId = syncId + "#" + requestId;


			_this.loader.show = true;
			this.$options.archiveItemIds = itemIds;
			startPoll(requestId, "onMilestoneArchiveCompleted", _this);

			axios.post('/releasetrain/milestone/bulkArchive', data)
				.then(res => {

				}).catch(error => {
				console.log(error);
				_this.loader.show = false;
			});
		},
		onMilestoneArchiveCompleted: function (response) {
			if (response.done) {
                let data = JSON.parse(response.requestParam);
                if (data.success) {
                    this.loader.show = false;
					// Remove archived logic for milestone on roadmap needs to be implemented along with top notification message
					this.removeMilestoneFromRoadmap(data.itemIds);
					showTopMessage("Archived Milestone/Phase successfully", "success", 3000);
					// this.removeItemsFromBacklog(this.$options.archiveItemIds);
                    // this.$options.archiveItemIds = undefined;
                } else {
                    if (data.message){
                        showTopMessage(data.message, "warning", 3000);
                    }
                    this.loader.show = false;
                }
            }
		},
		updateColumnText :function (count) {
		    const columnName = 'Planned'; // Replace 'Your Column Name' with the actual column name
		    const column = scheduler.columns.find(col => col.text === columnName); // Find the column by name

		    if (column) {
		        column.text = `${columnName} (${count})`; // Update the column text with the count
		    }
		},
		setBucketViewData: function(items, clear) {
			let resources = [];
			let events = [];
			let unplannedEvents = [];
			let assignments = [];

			if (clear) {
				clearData();
			}

			if (!this.groupBy.applied) {
				({resources, events, assignments, unplannedEvents} = this.$options.bucketViewUtils.handleUngroupedItems(items));
			} else {
				({resources, events, assignments, unplannedEvents} = this.$options.bucketViewUtils.handleGroupedItems(items));
			}

			this.$options.roadmap.resources = resources;
			this.$options.unplannedGrid.store.data = unplannedEvents;
			this.$options.roadmap.events = events;
			this.$options.roadmap.assignments = assignments;
			this.$options.roadmap.refresh();
		},
		getStarEndDates: function () {

			let startDate = undefined;
			let endDate   = undefined;

			_.each(this.$options.roadmap.eventStore.allRecords, task=>{
				//........... start date
				if (task.startDate && (startDate == undefined || startDate > task.startDate)) {
					startDate = task.startDate;
				}
				//..........  end date
				if (task.endDate && (endDate == undefined || endDate < task.endDate)) {
					endDate = task.endDate;
				}
			});
			return [startDate, endDate];
		},
		addNewItemToRoadmap: function(newItem,resourceRecord) {
			let _this = this;
			let response = {"item":newItem};
			_this.itemsByIdMap[newItem.id] = newItem;
			_this.onAddToBoardPopupCreate(response);
		},
		getGroupsOfItem: function (item) {

			let _this = this;
			let groups = [];
			let groupsValuesMap = this.getGroupsValuesOfItem(item);

			if (_.isEmpty(groupsValuesMap)) {
				groupsValuesMap["null"]="null";
			}
			_.find(_this.$options.roadmap.resources, rcd => {
				if (groupsValuesMap[rcd.id]) {
					delete groupsValuesMap[rcd.id];
					groups.push(rcd);
					return _.isEmpty(itemsMap) ? true : false;
				}
				return false;
			});
			return groups;
		},
		setSchedulerDatesByConfig(config) {
			let sortedRoadmapYearsConfigs = _.sortBy(config, 'year');
			let newStartDate = new Date();
			newStartDate.setFullYear(sortedRoadmapYearsConfigs[0].year, 0, 1);
			let newEndDate = new Date();
			newEndDate.setFullYear(sortedRoadmapYearsConfigs[sortedRoadmapYearsConfigs.length - 1].year, 11, 31);
			this.$options.roadmap.setTimeSpan(newStartDate, newEndDate);
		},
		getLinkToRoadmapSectionMenuItems: function() {
			let _this = this
			let presentSections = this.$options.roadmapSectionsCrud.getSections();
			let menuItems = [];
			for(let section of presentSections) {
				// Truncate section name to 25 characters
				const truncatedName = section.name.length > 25 ? section.name.substring(0, 25) + '...' : section.name;
				let html = `<span class="optseccrud" style="background-color:${section.color+30}" title="${section.name}">${truncatedName}</span>`;
				menuItems.push({
					sectionId: section.id,
					defaultSection : section.defaultSection,
					originalData: _.cloneDeep(section),
					html: html,
					icon: '',
					onItem: (event) => {
						let eventRecord = event.eventRecord;
						let isMilestoneOrPhase = eventRecord.get('ttype') === 'milestone' || eventRecord.get('ttype') === 'phase';
						let targetSectionId = section.defaultSection ? "null" : section.id;
						
						if (isMilestoneOrPhase) {
							// Handle milestone/phase movement
							let milestoneId = eventRecord.get('orgId') || eventRecord.id;
							_this.moveMilestoneToSection(targetSectionId, eventRecord, milestoneId);
						} else {
							// Handle item movement
							_this.moveToSection(targetSectionId, eventRecord);
						}
					}
				});
			}
			return menuItems
		},
		//...........................................
		//.......... api calls
		loadRoadmap() {

			let _this = this;

			this.store.setShowLeftMenuBar(false);
			let boardId = this.roadmapId;

			axios.get('/releasetrain/kanban/' + boardId).then(async response => {
				if (!_.isEmpty(response.data.board)) {

					_this.roadmap = response.data.board;
					if(_this.almAccountType && _this.almAccountType.type ==='tfs' && _this.roadmap.iterationPathDates===undefined){
						_this.roadmap.iterationPathDates = 0;
						_this.roadmap.datePreference = 0;
					}
					_this.initRoadmap();
					let viewPreset = localStorage.getItem(this.releaseTrain.id + "_ROADMAP_PRESET_"+this.roadmap.id);
					if (_.isEmpty(viewPreset)) {
						viewPreset = "q";
					}
					this.viewPreset.value = viewPreset;
					// _this.roadmap.roadmapYearsConfigs = _this.modifyRoadmapYearsConfigs(_this.roadmap.roadmapYearsConfigs);
					//set roadmap time span for only selected years
					// _this.setSchedulerDatesByConfig(_this.roadmap.roadmapYearsConfigs);
					_this.initGroupByOptions();
					_this.setTimeRanges(_this.getTimeRanges());
					_this.level = response.data.board.level;

					if (response.data.board.filterCriteria) {
						_this.filters.filter = response.data.board.filterCriteria;
						_this.filters.filterCriteria = _this.filters.filter.criteria;
						if (_this.filters.filterCriteria) {
							_this.filters.filtersCount = _this.filters.filterCriteria.rules.length;
							_this.filters.isApplied = _this.filters.filtersCount > 0;
						}
					}
					//_this.loadRoadmapItems();
					// const url = new URL('/api/v1/roadmap-sections');
					// url.searchParams.append('roadmapId', _this.roadmap.id);
					let defaultSectionName = _this.filters.filter?_this.filters.filter.name:"Planned Items";
					const url = `/roadmap-section/get-roadmap-sections?roadmapId=${_this.roadmap.id}`;

					let roadmapSectionsResponse = await fetch(url, {
						method: 'GET',
						headers: getFetchAPIHeadersForKendis(),
						credentials: 'include', // Include cookies for CSRF-TOKEN
					});
					if(roadmapSectionsResponse.ok) {
						let sections = await roadmapSectionsResponse.json();

						//check if sections contains the default section
						if(!_.find(sections, {defaultSection: true})){
							this.dataCorrectionButton.show = true;
						}

						_this.$options.roadmapSectionsCrud = new RoadmapSectionsCrud(sections);
						_this.$options.roadmap.features.eventMenu.items.linkToRoadmapSection.menu.items
							= _this.getLinkToRoadmapSectionMenuItems();
					}

					_this.loadData();

					//.........................

					let breadCrumbItems = [
						{name: viewTypeToListName(_this.releaseTrain), url: "/" + _this.viewType},
						{
							name: _this.store.releaseTrain.title,
							url: "/" + _this.viewType + "/" + _this.releaseTrainId + "/" + viewTypeModule(this.releaseTrain)
						},
						{name: 'Roadmap', url: "/" + this.viewType + "/" + _this.releaseTrainId + "/roadmap"},
						{
							name: _this.roadmap.name,
							url: "/" + this.viewType + "/" + _this.releaseTrainId + "/roadmap/" + _this.roadmap.id
						}
					];
					_this.store.setBreadCrumbItems(breadCrumbItems);

				}
			}).catch(error => {
				console.log(error);

			});
		},
		async loadRoadmapItems(fetchPlannedOnly,fetchUnplannedOnly,onClickLoadGroup) {
			if (!this.items) {
				this.items = [];
			}
			this.fetchBacklogItemsGroups(fetchPlannedOnly,fetchUnplannedOnly,onClickLoadGroup)
				.then(r => {
					console.log("-------------------------------------");
					console.log("------FETCHED BACKLOG ITEMS DONE-----")
					console.log("-------------------------------------");
				})
				.catch(error => {
					console.log(error);
				});
		},
		getFilterCriteria: function (board, filterCriteria, searchTags,fetchPlannedOnly,fetchUnplannedOnly) {
			let filters = {}
			if(fetchPlannedOnly){
				 filters = _.cloneDeep(filterCriteria);
				if (_.isEmpty(filters)) {
					filters = {condition:"AND"};
				}
				if (!_.isEmpty(searchTags)) {
					if (!filters.rules) {
						filters.rules = [];
					}
					//.......   search in title-id
					let titleFilter = _.find(filters.rules,{key:"title-id"});
					if (!titleFilter) {
						titleFilter = {key:"title-id",value:[],operator:"EQUALS",type:"text"};
						filters.rules.push(titleFilter);
					}
					for(let searchTag of searchTags) {
						titleFilter.value.push(searchTag.title);
					}
				}
				if (board.filterCriteria) {
					let selectedFilterRules = {};
					_.each(board.filterCriteria.criteria.rules, r=>{
						selectedFilterRules[r.key] = true;
					});
					filters.rules = _.filter(filters.rules,rule=>{
						return !selectedFilterRules[rule.key];
					});
				}
				if (!filters.rules) {
					filters.rules = [];
				}
				let plannedFilter
				if(this.almAccountType ==='tfs'
					&& this.roadmap.iterationPathDates===0
					&& [0,1].includes(this.roadmap.datePreference)) {
					plannedFilter = _.find(filters.rules, {key: "planned-iteration-path-or-item-dates"});
					if (!plannedFilter) {
						plannedFilter = {
							key: "planned-iteration-path-or-item-dates",
							value: this.store.tfsIterationMap,
							operator: "EQUALS",
							type: "boolean"
						};
						filters.rules.push(plannedFilter);
					}
				}

				else {
					plannedFilter = _.find(filters.rules,{key:"show-planned-items-only"});
					if (!plannedFilter) {
						plannedFilter = {key:"show-planned-items-only",value:true,operator:"EQUALS",type:"boolean"};
						filters.rules.push(plannedFilter);
					}

				}
			}
			if(fetchUnplannedOnly){
				if (_.isEmpty(filters)) {
					filters = {condition:"AND"};
				}
				if (!filters.rules) {
					filters.rules = [];
				}
				if(this.unplannedFilter.searchText.length>0){
					let titleFilter = {key:"title-id",value:[this.unplannedFilter.searchText],operator:"EQUALS",type:"text"};
					filters.rules.push(titleFilter);
				}
				let unPlannedFilter
				if( this.almAccountType ==='tfs' &&
					this.roadmap.iterationPathDates===0  && [0,1].includes(this.roadmap.datePreference)) {
					unPlannedFilter = _.find(filters.rules, {key: "unplanned-iteration-path-or-item-dates"});
					if (!unPlannedFilter) {
						unPlannedFilter = {
							key: "unplanned-iteration-path-or-item-dates",
							value: this.store.tfsIterationMap,
							operator: "EQUALS",
							type: "boolean"
						};
						filters.rules.push(unPlannedFilter);
					}
				}
				else {
					unPlannedFilter = _.find(filters.rules, {key: "show-unplanned-items-only"});
					if (!unPlannedFilter) {
						unPlannedFilter = {
							key: "show-unplanned-items-only",
							value: true,
							operator: "EQUALS",
							type: "boolean"
						};
						filters.rules.push(unPlannedFilter);
					}
				}
			}
			return filters;
		},
		createFetchGroupsRequestData(groupByValue, fetchPlannedOnly, fetchUnplannedOnly) {
			let data = {
				hierachLevel: "" + this.level,
				requestId: getNewUUID(),
				boardId: this.roadmap.id
			};

			let filters = this.getFilterCriteria(
				this.roadmap,
				this.filters.filter ? this.filters.filter.criteria : {},
				this.filters.searchTags,
				groupByValue === groupByValues.Section ? undefined:fetchPlannedOnly ,
				fetchUnplannedOnly
			);

			if (!_.isEmpty(filters.rules)) {
				data.filter = filters;
			}

			if(fetchUnplannedOnly) {
				if (this.groupByUnplanned.value !== "-1") {
					data.groupBy = this.groupByUnplanned.value;
					if (this.groupByUnplanned.type) {
						data.type = this.groupByUnplanned.type;
						data.itemType = this.groupByUnplanned.itemType;
					}
				}
			}else{
				if (this.groupBy.value !== "-1") {
					data.groupBy = this.groupBy.value;
					if (this.groupBy.type) {
						data.type = this.groupBy.type;
						data.itemType = this.groupBy.itemType;
					}
				}
			}
			return data;
		},
		async fetchBacklogItemsGroups(fetchPlannedOnly, fetchUnplannedOnly,onClickLoadGroup) {
			let resourceIds;

			if (fetchPlannedOnly) {
				this.showLoader();
				const jsonResponse = await this.fetchBacklogGroups(fetchPlannedOnly, fetchUnplannedOnly);
				this.$options.plannedGroupItemsInfoMap = this.createGroupItemsInfoMap(jsonResponse.result.items);

				this.updateItemsParentsMap(jsonResponse.parents);
				this.drawResourceGroups(jsonResponse.result.items,true);
				resourceIds = this.getResourceIds(jsonResponse.result.items);
				this.loadMilestones();
				this.streamGroupedItems({ groupIds: resourceIds }, fetchPlannedOnly, fetchUnplannedOnly);

			} else if (fetchUnplannedOnly) {

				if(onClickLoadGroup===undefined) {
					const jsonResponse = await this.fetchBacklogGroups(fetchPlannedOnly, fetchUnplannedOnly);
					this.$options.unplannedGroupItemsInfoMap = this.createGroupItemsInfoMap(jsonResponse.result.items);
					this.updateItemsParentsMap(jsonResponse.parents);
					this.$options.unplannedItemsGroups = jsonResponse.result.items;
					this.createGroupsOfUnplannedItems(jsonResponse.result.items);
				}else{
					resourceIds = [onClickLoadGroup]
					this.streamGroupedItems({groupIds: resourceIds}, fetchPlannedOnly, fetchUnplannedOnly);
				}
			}
		},

		createGroupsOfUnplannedItems(groups) {
			try{
			this.cleanGrid();
		
			let unplannedGrid = this.$options.unplannedGrid;
			if (this.groupByUnplanned.value === groupByValues.Section) {
				let groupsList = this.$options.roadmapSectionsCrud.getSections();
				for (let group of groupsList) {
					//if the count is 0, then don't show the section
					let count
					if(group.defaultSection){
						count = groups.find(g => _.isEmpty(g._id))?.count;
					}else{
						count = groups.find(g => g._id.id === group.id)?.count;
					}
					if(!count || count === 0) {
						continue;
					}
					let groupRecord = {
						id: group.defaultSection ? "null" : group.id,
						title: group.name,
						count: count,
						expanded: false,
						children: true,
						isGroup: true,
					};
					unplannedGrid.store.add(groupRecord);
				}
			}else {
				let result = [];
				for (let group of groups) {
					let groupRecord = {
						id: group._id.id===undefined ||  (group._id.id=== null)? "null":group._id.id,
						title: this.generateGroupName(group._id.id),
						count: group.count,
						expanded: false,
						children: true,
						isGroup: true,
					};
					result.push(groupRecord);
				}
				//sort results
				result.sort(compareResourcesByName);
				unplannedGrid.store.data = result;
			}
			}
			catch(e){
				console.log(e);
			}finally{
				this.hideGridLoader();
			}
		},
		generateGroupName(groupRowFor){
			const groupByValue = this.groupByUnplanned.value;
			let _this = this;
			// const getGroupTitle = (group) => group ? `${group.title} (${count})` : '...';

			if(groupRowFor===true){
				return "True"
			}
			if(groupRowFor===false){
				return "False"
			}

			if (!groupRowFor || groupRowFor === "null" || groupRowFor === "!!novalue!!") {
				return this.getNoGroupName(groupByValue);
			}

			if (metaDependantGroups.includes(groupByValue)){
				let groupTitle = _this.getGroupTitleFromMeta(groupRowFor,groupByValue);
				return groupTitle ? `${groupTitle}` : '...';
			}

			switch (groupByValue) {
				case "Parent":
					const parent = _this.$options.itemsParentsMap.get(groupRowFor);
					let generatedKey= generateKey(parent);
					if(generatedKey && generatedKey!==''){
						return parent ? `
							<span class="val prowaa">
								<span class="key fs-13">${generatedKey}</span>
								${parent.title}
							</span>` : '...';
					}else{
						return parent ? `${parent.title}` : '...';
					}

				case "Section":
					const section = _this.$options.roadmapSectionsCrud.getSectionById(groupRowFor);
					return section ? `${section.name}` : '...';
				case groupByValues.kendisStatus:
					return groupRowFor ? `${groupRowFor}` : '...';
				default:
					return groupRowFor ? `${groupRowFor}` : '...';
			}

		},

		showLoader() {
			this.$options.roadmap.maskBody({
				text: '<div id="body-loader" class="loader"><div><div class="loaderinteg"></div><span class="LOADER-TITLE"></span></div></div>',
				mode: 'bright',
			});
		},

		async fetchBacklogGroups(fetchPlannedOnly, fetchUnplannedOnly) {
			let groupByValue
			if(fetchUnplannedOnly){
				groupByValue = this.groupByUnplanned.value;
			}else{
				groupByValue = this.groupBy.value
			}


			const response = await fetch(`/releasetrain/${this.store.releaseTrainId}/backlog`, {
				method: 'POST',
				headers: getFetchAPIHeadersForKendis(),
				body: JSON.stringify(this.createFetchGroupsRequestData(groupByValue, fetchPlannedOnly, fetchUnplannedOnly)),
				credentials: 'include', // Include cookies for CSRF-TOKEN
			});
			if (!response.ok) {
				throw new Error(`Network response was not ok: ${response.statusText}`);
			}
			return await response.json();
		},

		updateItemsParentsMap(parents) {
			if (parents) {
				this.$options.itemsParentsMap = parents.reduce((map, item) => {
					if (map.has(item.id)) {
						// Update existing entry
						map.set(item.id, {
							...map.get(item.id),
							...item,
						});
					} else {
						// Add new entry
						map.set(item.id, item);
					}
					return map;
				}, this.$options.itemsParentsMap || new Map());
			}
		},

		getResourceIds(items) {
			const milestoneResourceId = "someMilestoneId"; // Replace with actual milestone ID
			let resourceIds = this.$options.roadmap.resourceStore.getRange().map(resource => resource.id);

			// Filter out milestone group ID
			return resourceIds.filter(resourceId => resourceId !== milestoneResourceId);
		},

		drawGroupHeaderEvents(allResources){
			let scheduler = this.$options.roadmap;
			for(let resourceRecord of allResources) {
				// Skip milestone resource
				if(resourceRecord.id === milestoneResourceId){
					continue;
				}
				
				// Skip non-group resources: individual items, section milestone child resources, section item child resources
				if (resourceRecord.get && (
					resourceRecord.get('isItem') || 
					resourceRecord.get('isMilestoneResource') || 
					resourceRecord.get('isItemResource')
				)) {
					continue;
				}
				
				let groupId = resourceRecord.id;

				const fullSpanEvent = scheduler.eventStore.getById(`full-span-event-${groupId}`);
				if (!fullSpanEvent) {
					// Add the full-length immovable event
					scheduler.eventStore.add({
						id: `full-span-event-${groupId}`,
						title: ` ${resourceRecord.name}`,
						startDate: new Date(1000, 0, 1),
						endDate: new Date(9999, 0, 1),
						cls: 'kendis-full-length-event',
						readOnly: true,// This event is marked as read-only
						isHeader: true,
						eventColor: resourceRecord.color?resourceRecord.color:defaultGroupColor,
					});
					scheduler.assignmentStore.add({
						id: `a-full-span-event-${groupId}`,
						resourceId: groupId,
						eventId: `full-span-event-${groupId}`
					})
				}
			}
		},
		streamGroupedItems: function({groupIds},fetchPlannedOnly,fetchUnplannedOnly) {
			//call to server to get groupId wise items also paginated
			// if(fetchUnplannedOnly){
				// this.$options.unplannedGrid.maskBody(
				// 	{
				// 		text   : '<div id="body-loader" class="loader"><div><div class="loaderinteg"></div><span class="LOADER-TITLE"><loading class="."></loading></span></div></div> ',
				// 		mode   : 'bright-blur'
				// 	});
			// }
			let _this = this;
			let requestDataJson = {};
			requestDataJson.groupIds = groupIds;
			requestDataJson.hierachLevel = ""+this.level;
			requestDataJson.releaseTrainId = ""+this.store.releaseTrainId;
			requestDataJson.requestId = getNewUUID();

			if (this.filters.filter) {
				let filters = this.getFilterCriteria(this.roadmap, this.filters.filter.criteria, this.filters.searchTags, fetchPlannedOnly,fetchUnplannedOnly);
				if (!_.isEmpty(filters.rules)) {
					requestDataJson.filter = filters;
				}
			}else {
				let filters = this.getFilterCriteria(this.roadmap, {}, this.filters.searchTags, fetchPlannedOnly,fetchUnplannedOnly);
				if (!_.isEmpty(filters.rules)) {
					requestDataJson.filter = filters;
				}
			}
			requestDataJson.boardId = this.roadmap.id;
			if(fetchUnplannedOnly){
				requestDataJson.groupBy = this.groupByUnplanned.value;
				requestDataJson.groupType = this.groupByUnplanned.value;
				requestDataJson.groupValueType = this.groupByUnplanned.type;
				if (requestDataJson.groupValueType && this.groupByUnplanned.itemType) {
					requestDataJson.optionType = this.groupByUnplanned.itemType;
				}
			}
			else{
				requestDataJson.groupBy = this.groupBy.value;
				requestDataJson.groupType = this.groupBy.value;
				requestDataJson.groupValueType = this.groupBy.type;
				if (requestDataJson.groupValueType && this.groupBy.itemType) {
					requestDataJson.optionType = this.groupBy.itemType;
				}
			}
			// Use the correct group items info map based on whether we're fetching planned or unplanned items
			if (fetchUnplannedOnly) {
				requestDataJson.backlogGroupItemsInfo = Object.fromEntries(this.$options.unplannedGroupItemsInfoMap || new Map());
			} else {
				requestDataJson.backlogGroupItemsInfo = Object.fromEntries(this.$options.plannedGroupItemsInfoMap || new Map());
			}


			// data.fetchGroupItems = true;
			let dataPassedToCallback = {
				fetchPlannedOnly: fetchPlannedOnly,
				fetchUnplannedOnly: fetchUnplannedOnly,
				groupIds: groupIds // Pass the group IDs being loaded
			}
			fetch("/releasetrain/backlog-groups-stream",{
				method: 'POST',
				headers: getFetchAPIHeadersForKendis(),
				body: JSON.stringify(requestDataJson),
				credentials: 'include', // Include cookies for CSRF-TOKEN
			}).then(response => {
				readServerStreamdata(response,_this.processGroupedItemsJsonData,_this.endGroupsStreamRead,dataPassedToCallback);
			}).catch(error => {
				console.log(error);
			});
			},
		drawResourceGroups(groups,clean) {
			if(clean){
			this.cleanScheduler(); // Clear existing scheduler data
			}
			let _this = this;

			// Prepare resources
			let resources = [];

			if (_this.groupBy.value === "Section") {
				let groupsList = _this.$options.roadmapSectionsCrud.getSections();

				// Map groups into resource data
				resources = groupsList.map(group => {
					let sectionResource = {
					name: group.name,
					id: group.defaultSection ? "null" : group.id,
					cls: group.defaultSection
						? ["kendis-ir-resource-group", "kendis-ir-undragable-group"]
						: "kendis-ir-resource-group",
					sequence: group.sequence,
					expanded: false,
					color: group.color || defaultGroupColor
					};

					// In old mode, don't create child resources - show items and milestones directly in section resource
					// Child resources are only used in new mode (showIndividualItemResources = true)

					return sectionResource;
				});

				// Sort resources by sequence
				resources.sort((a, b) => a.sequence - b.sequence);
			} else {
				// Handle non-section group resources
				const groupMap = new Map(); // To avoid duplicates

				groups.forEach(group => {
					let groupData = _this.setGroupItemProperties(group, _this.groupBy.value);
					groupData.name = groupData._id.title;
					groupData.id = groupData._id.id;
					groupData.cls = ["kendis-ir-resource-group", "kendis-ir-undragable-group"];
					groupData.expanded = false;

					// Avoid duplicates using Map
					if (!groupMap.has(groupData.id)) {
						groupMap.set(groupData.id, groupData);
					}
				});

				// Convert Map values to array and sort by ID
				resources = Array.from(groupMap.values())


				// Sort the resources array using the custom comparison function
				resources.sort(compareResourcesByName);
			}

			if(clean){
			// Assign resources to roadmap
			this.$options.roadmap.resources = resources;
			}else{
				this.$options.roadmap.resourceStore.add(resources);
			}
			// Batch process headers and filters for performance
			this.batchProcessResources(resources);
		},
		batchProcessResources(resources) {
			// Draw group headers once
			this.drawGroupHeaderEvents(resources);

			// Apply a single filter for all resources (combined)
			const filters = resources.map(resource => ({
				id: `filter-${resource.id}-${this.groupBy.value}`,
				filterBy: event =>
					event.id.includes("full-span-event") ||
					event.resource && event.resource.id !== resource.id ||
					event.get("groupId") !== resource.id
			}));

			// Apply filters in batch to eventStore
			this.$options.roadmap.eventStore.filter(filters);
		},
		cleanGrid(){
			this.$options.unplannedGrid.store.data = [];
		},
		cleanScheduler(){
			this.$options.roadmap.eventStore.removeAll();
			this.$options.roadmap.resourceStore.removeAll();
			this.$options.roadmap.assignmentStore.removeAll();
			this.$options.roadmap.assignments=[]
			// this.itemsByIdMap = {};
			// this.$options.roadmap.eventStore.destroy();
			console.log("-------------------------------------");
			console.log("-------CLEARED DATA IN SCHEDULER-----")
			console.log("-------------------------------------");
		},
		setGroupItemProperties: function(item, groupBy) {
			if (item._id.id == undefined) {
				item._id.id = "null";
				item._id.title = "No Group";
			}

			if (groupBy === "Project") {
				if (item._id.id == "null") {
					item._id.title = "No Project";
				}
			}
			if (groupBy === "AreaPath") {
				if (item._id.id == "null") {
					item._id.title = "No Area Path";
				}
			}
			if (groupBy === "Iteration") {
				if (item._id.id == "null") {
					item._id.title = "No Iteration Path";
				}
			}
			// if (groupBy === "Parent") {
			// 	if (item._id.id == "null") {
			// 		item._id.title = "No Parent";
			// 	}
			// }
			else if (groupBy === "Session") {
				if (item._id.id != "null") {
					item._id.title = "";
					if (this.$root.$options.meta.sessionById) {
						let board = this.$root.$options.meta.sessionById[item._id.id];
						if (board) {
							item._id.title = board.title;
						}
					}
				} else {
					item._id.title = "No PI Board";
				}
			}
			else if (groupBy === groupByValues.SolutionBoards) {
				if (item._id.id != "null") {
					item._id.title = "";
					if (this.$root.$options.meta.solutionBoards) {
						let board = this.$root.$options.meta.solutionBoards[item._id.id];
						if (board) {
							item._id.title = board.title;
						}
					}
				} else {
					item._id.title = "No Solution Board";
				}
			}
			else if (groupBy === groupByValues.Teams) {
				if (item._id.id != "null") {
					item._id.title = "";
					if (this.$root.$options.meta.teams) {
						let team = this.$root.$options.meta.teams[item._id.id];
						if(team) {
							item._id.title = team.title;
						}
					}
				} else {
					item._id.title = "No Team";
				}
			}
			else if (groupBy === groupByValues.Sprints) {
				if (item._id.id != "null") {
					if (this.$root.$options.meta.containers) {

						let sprint = this.$root.$options.meta.containers[item._id.id];
						if (sprint) {
							let board = this.$root.$options.meta.boards[sprint.sessionBoardId];
							if (board) {
								item._id.title = board.title +" : "+sprint.title;
							}
							else {
								item._id.title = sprint.title;
							}
						}else {
							item._id.title = "...";
						}
					}else {
						item._id.title = "...";
					}
				} else {
					item._id.title = "No Sprint";
				}
			}
			else if (groupBy === groupByValues.Batches) {
				if (item._id.id != "null") {
					item._id.title = "";
					if (this.$root.$options.meta.batches) {
						let batch = this.$root.$options.meta.batches[item._id.id];
						if (batch) {
							item._id.title = batch.key + " : " + batch.title;
						}
					}
				} else {
					item._id.title = "No Batches";
				}
			}
			else if (groupBy === groupByValues.Parent){
				if (item._id.id != "null") {
					item._id.title = "";
					if (this.$options.itemsParentsMap) {
						let parent = this.$options.itemsParentsMap.get(item._id.id);
						if (parent) {
							let generatedKey = generateKey(parent)
							if(generatedKey && generatedKey!==''){
								item._id.title = generateKey(parent)+" : "+parent.title;
							}else{
								item._id.title = parent.title;
							}
						}
					}
				} else {
					item._id.title = "No Parent";
				}
			}
			else {
				//custom fields
				if (item._id.id != "null") {
					item._id.title = this.groupName(item);
				} else {
					item._id.title = "No Group";
				}
			}
			item.items = [];
			item.loading = false;
			if (!item.count) {
				item.count = 0;
			}

			return item;
		},
		 updateGridData(data) {
			this.$options.unplannedGrid.store.data = data;
			},
		endSingleItemStreamRead: function (jsonData) {
			let _this = this;
			if(jsonData){
				_this.processJsonData(jsonData);
			}
			_this.store.message.text = '';
			this.$options.paginator.setData((this.$options.unplannedGrid.store.data))
			let pageNumbers = this.$options.paginator.getAllPageNumbers();
			this.$options.unplannedGrid.widgetMap['kendis-items-roadmap-page-index-dropdown-widget'].items = pageNumbers;
			if(pageNumbers && pageNumbers.length>0)
				this.$options.unplannedGrid.widgetMap['kendis-items-roadmap-page-index-dropdown-widget'].value = this.$options.paginator.currentPage;
			else
				this.$options.unplannedGrid.widgetMap['kendis-items-roadmap-page-index-dropdown-widget'].value = '-';
			_this.showBbarUnplannedItems();
			this.drawGroupHeaderEvents(this.$options.roadmap.resourceStore.allRecords)
			_this.loader.show = false;
			// this.loadMilestones();
			// this.zoomToCurrentDate(this.$options.roadmap);
		},
		zoomToCurrentDate(scheduler){
			try {// Initialize current date
				const currentDate = new Date();

				// Calculate start and end dates
				const startDate = new Date();
				// startDate.setDate(currentDate.getDate() - 90); // 5 days before today

				const endDate = new Date();
				endDate.setDate(currentDate.getDate() + 90); // 5 days after today

				// Call zoomToSpan with the calculated dates
				scheduler.zoomTo({
					startDate: startDate,
					endDate: endDate,
				});
			}catch (e) {
				console.log(e)
			}
		},
		async fetchBacklogItemsStream(requestDataJson){
			let _this = this;
			this.cleanScheduler()
			fetch("/releasetrain/" + this.store.releaseTrainId + "/backlog-stream", {
				method: 'POST',
				headers: getFetchAPIHeadersForKendis(),
				body: JSON.stringify(requestDataJson),
				credentials: 'include', // Include cookies for CSRF-TOKEN
			}).then(response => {
				readServerStreamdata(response,_this.processJsonData,_this.endSingleItemStreamRead);
			}).catch(error => console.error('Error with Fetch API:', error));
		},
		endGroupsStreamRead: function (jsonData,dataPassedToCallback) {
			let _this = this;
			this.isDataLoading = false;
			if(jsonData){
				_this.processGroupedItemsJsonData(jsonData);
			}
			_this.store.message.text = '';
			if(dataPassedToCallback.fetchPlannedOnly){
				this.loadMilestones();
				this.drawGroupHeaderEvents(this.$options.roadmap.resourceStore.allRecords)
				// fitSchedulerToEvents(this.$options.roadmap);
				// this.zoomToCurrentDate(this.$options.roadmap);
				// this.$options.roadmap.viewPreset =  getPresetFactory(this.$options.roadmap,this.viewPreset.value)
				// zoomToCompleteTimeRange(this.$options.roadmap,this.viewPreset.value, true); // Zoom to the complete time range
				
				// Only load children counts in new mode
				if (this.showIndividualItemResources) {
					this.loadAllItemsChildrenCounts();
				}
			}
			if(dataPassedToCallback.fetchUnplannedOnly){
					// Hide group-specific loaders if loading specific groups
					if (dataPassedToCallback.groupIds && dataPassedToCallback.groupIds.length > 0) {
						dataPassedToCallback.groupIds.forEach(groupId => {
							this.hideGroupLoader(groupId);
						});
					} else {
						// Hide global grid loader if loading all unplanned items
						this.hideGridLoader();
					}
					this.unplannedFetched = true;
			}
			if(dataPassedToCallback.fetchPlannedOnly){
				this.$nextTick(() => {
					this.plannedFetched = false;
					this.plannedFetched = true;
				});
			}
		},
		processGroupedItemsJsonData: function (jsonData,dataPassedToCallback) {
			let _this = this;
			let data = JSON.parse(jsonData);
			let groupId = data.groupId;
			let groupItems = data.result.items

			_this.addMultipleItemsOnRoadMap(this.createLoadedItemsMap(_.cloneDeep(groupItems)),groupId);
		},
		groupUnplannedItems(){
			// this.$options.unplannedGrid.store.group("groupId");
			// this.$options.unplannedGrid.features.group.collapseAll();
		},
		processJsonData: function (jsonData) {
			let data = JSON.parse(jsonData);
			let items = this.createLoadedItemsMap(_.cloneDeep(data.result.items));
			this.setRoadmapData(items, false);
			let totalItems = data.result.total;
			let fetchedItems = roadmapVue.$options.roadmap.eventStore._allRecords.length
				+ roadmapVue.$options.unplannedGrid.store.data.length;
			this.store.message.text = " " + fetchedItems + " of " + totalItems + " items loaded";

		},
		async loadData() {
			let _this = this;
			if(!_.isEmpty(this.store.releaseTrainId)){
				// Check session validity before loading data
				const sessionValid = await this.validateSession('roadmap-data-load');
				if (!sessionValid) {
					return; // Session expired, user will be redirected
				}
				
				// Set loading state to disable groupBy dropdown
				this.isDataLoading = true;
				
				// Show roadmap loader
				this.showRoadmapLoader('Loading roadmap data...');

				// this.loader.show = true;
				// this.waitForMeta(); // wait for meta
					await this.loadRoadmapItems(true,false);// wait for roadmap data
				if (this.$route.fullPath.includes('/progress') && !this.unplannedFetched) {
					console.log("Fetching unplanned items for progress widget");
					this.loadUnplannedOnClick("null");
				}
				// this.loadRoadmapItems(false,true);// wait for roadmap data

				// Hide roadmap loader
				this.hideRoadmapLoader();
				
				// Apply stored time navigator state after roadmap is loaded
				this.$nextTick(() => {
					this.applyStoredTimeNavigatorState();
				});

				// this.loadMilestones();
				// fitSchedulerToEvents(this.$options.roadmap);
				// this.loader.show = false;
				// if(_this.groupBy.applied){
				// 	this.groupUnplannedItems()
				// }else{
				// 	//ungroup
				// 	this.$options.unplannedGrid.store.clearGroupers()
				// }

			}
		},
		loadUnplannedOnClick(onClickLoadGroup){
			let _this = this;
			if(!_.isEmpty(this.store.releaseTrainId)){
				// Show group-specific loader if expanding a specific group
				if (onClickLoadGroup && onClickLoadGroup !== null) {
					this.showGroupLoader(onClickLoadGroup, 'Loading group items...');
				} else {
					// Show global grid loader only when loading all unplanned items
					this.showGridLoader('Loading unplanned items...');
				}
				this.loadRoadmapItems(false,true,onClickLoadGroup);
			}
		},
		loadMilestones() {
			console.log("!!!!!!!!!! Loading Milestones !!!!!!")
			let _this = this;
			let data = {}
			data.hierachLevel = milestoneResourceId;
			data.requestId = getNewUUID();
			data.boardId = this.roadmap.id;
			data.sortBy = "date";
			data.sortOrder = "1";
			axios.post("/releasetrain/" + this.store.releaseTrainId + "/backlog", data).then(res => {
				if (res.data.result.items) {
					//let items = res.data.result.items;
					_this.milestoneData.milestones     = res.data.result.items;
					_this.milestoneData.milestoneGroup = {};
					_this.createMilestoneGroupIfNotExist();
					_this.addMilestones();

					/*if(_this.groupBy.value === "Milestones") {
						_this.createMilestoneGroups();
					}*/
					_this.$options.roadmap.unmaskBody()
					
					// Toggle collapse the milestone resource after loading
					const milestoneResource = _this.$options.roadmap.resourceStore.getById("-1001");
					if (milestoneResource) {
						toggleResourceExpand(milestoneResource,_this.groupBy.value,_this.$options.roadmap);
						_this.$options.roadmap.toggleCollapse(milestoneResource);
						console.log('Milestone resource collapsed after loading');
					}

				}
			}).catch(error => {
				console.log(error);
			});
		},
		fillMilestoneInMenuList(){
			let subMenuTasksLinked =[];
			let subMenuTasks = [];
			let _this = this;
			this.$options.roadmap.features.eventMenu.items.linkToMilestone.menu = [];
			this.$options.roadmap.features.eventMenu.items.linkedMilestones.menu = [];

			for(let i = 0; i < this.milestoneData.milestones.length; i++) {
				let currentMilestone = this.milestoneData.milestones[i];

				// Truncate milestone title to 20 characters
				const truncatedTitle = currentMilestone.title.length > 20 ? currentMilestone.title.substring(0, 20) + '...' : currentMilestone.title;
				let html = `<div class="DFA">
								<a style="padding: 5px;">${currentMilestone.kendisKey}</a>
								<span style="padding: 5px;" title="${currentMilestone.title}">${truncatedTitle}</span>
								`;
			
				html += `</div>`;

				subMenuTasks.push({
					milestoneId: currentMilestone.id,
					currentMilestone: currentMilestone,
					html: html,
					icon: currentMilestone.fields.itemType == "Milestone"? 'b-icon-milestone': 'b-icon-square',
					onItem: (event) => {
						let taskRecord = event.eventRecord;
						let item = event.item;

						if(taskRecord && item) {
							if(taskRecord.get('orgId') && item.milestoneId) {
								let milestoneId = item.milestoneId;
								let taskRecordId = taskRecord.get('orgId');


								let request = {};
								request.itemType = "Milestone";
								request.releaseTrainId = _this.releaseTrain.id;
								request.backlogItemId = milestoneId;
								request.itemsToLink = [taskRecordId];

								/////////////////////////////////////////
								//     Confirmation Popup goes here
								if(this.milestoneData.linkItemConfirmationPopup) {
									// Call to Link Items
									_this.requestLinkItems(request);
								} else {
									let linkedItem = {};
									// if(taskRecord.almKey) {
									// 	linkedItem.key = taskRecord.almKey;
									// } else if(taskRecord.kendisKey) {
									// 	linkedItem.key = taskRecord.kendisKey;
									// }

									linkedItem.key = generateKey(_this.itemsByIdMap[taskRecordId])
									linkedItem.title = taskRecord.title;

									let milestone = item.currentMilestone;

									const descriptionHtml = `
                                        <span>
                                            <span class="">You want to link</span> <span class="key FN fs-13">${linkedItem.key}</span>${linkedItem.title}<br> <span class="">with milestone </span>
                                            <span class="key FN fs-13">${milestone.kendisKey}</span>${milestone.title}?
                                        </span>`;

									_this.onClickShowConfirmation("Are you sure?", descriptionHtml, request);
								}
							}
						}
					}
				});
				subMenuTasksLinked.push({
					milestoneId: currentMilestone.id,
					currentMilestone: currentMilestone,
					html: html,
					icon: currentMilestone.fields.itemType === "Milestone"? 'b-icon-milestone': 'b-icon-square',
				});
			}
			this.$options.roadmap.features.eventMenu.items.linkToMilestone.menu = subMenuTasks;
			this.$options.roadmap.features.eventMenu.items.linkedMilestones.menu = subMenuTasksLinked;
		},
		onClickConfirmLinking(doNotShow) {
			this.requestLinkItems(this.milestoneData.confirmationPopup.request);
			this.milestoneData.confirmationPopup.show = false;
			this.milestoneData.linkItemConfirmationPopup = doNotShow;
			// localStorage.setItem(this.timelineId+"_Milestone_Link_Item_Confirmation_Popup", doNotShow);
		},
		onClickCancelConfirmation() {
			this.milestoneData.confirmationPopup.show = false;
			this.milestoneData.confirmationPopup.title = "";
			this.milestoneData.confirmationPopup.description = "";
			this.milestoneData.confirmationPopup.request = {};
		},
		onClickShowConfirmation(title, description, request) {
			this.milestoneData.confirmationPopup.show = true;
			this.milestoneData.confirmationPopup.title = title;
			this.milestoneData.confirmationPopup.description = description;
			this.milestoneData.confirmationPopup.request = request;
		},
		requestLinkItems(request) {
			let _this = this;
			axios.post("/releasetrain/backlog-item/link-item", request)
				.then(response => {
					if(response.data.success) {
						let updatedItem = response.data.updatedItem;
						let backlogItems = response.data.backlogItems;
						// Updating Milestone Reference
						_this.addMilestones(updatedItem);

						for(let item of backlogItems){

							_this.itemsByIdMap[item.id] = item;
							let itemIndex = _.findIndex(_this.items, {id: item.id});

							if(itemIndex > -1) {
								_this.items.splice(itemIndex, 1, item);
							}else{
								_this.items.push(item);
							}
						}

						showTopMessage("Item is linked successfully", 'success', 3000);

					} else if(response.data.error){
						showTopMessage("Failed to link item", 'warning', 3000);
					}
				}).catch(error => {
				console.log(error);
			});

		},
		addMilestones(item){
			if(item){
				let _this = this;
				let itemIndex = _.findIndex(_this.milestoneData.milestones, {id: item.id});
					if(itemIndex > -1) {
						// Item Exist so Update its existence in list
						// Check if Milestone has relationship with timeline.
						let isMilestoneRelatedToTimeline = _.find(item.relations, {baseItemId: _this.roadmap.id});
						// If Relation Exist with current timeline
						if(isMilestoneRelatedToTimeline) {
							_this.milestoneMapById[item.id] = item;
							_this.milestoneData.milestones.splice(itemIndex, 1, item);
						} else {
							// Relationship doesn't exist
							_this.milestoneData.milestones.splice(itemIndex, 1);
						}
						
						// Find the correct resource for this milestone (global or section)
						let targetResource = this.findMilestoneResource(item);
						if (!targetResource) {
							console.warn(`Target resource not found for milestone ${item.title}`);
							return;
						}
						
			            if(targetResource.groupItems == undefined){
							targetResource.groupItems = [];
						}else {
							let itemIndexOld = _.findIndex(targetResource.groupItems, {id: item.id});
							if(itemIndexOld > -1){
								let isMilestoneRelatedToTimeline = _.find(item.relations, {baseItemId: _this.roadmap.id});
								if(isMilestoneRelatedToTimeline) {
									let oldTask = targetResource.getEventById(item.id);
									if (oldTask) {
									oldTask.title    = item.title;
									oldTask.barColor = (item.fields && item.fields.Color ) ?  item.fields.Color : '#7c50b1';
									oldTask.status   = item.status  ?  item.status : oldTask.status;
									oldTask.style    = "background-color:" + oldTask.barColor + ";";
						            if(item.fields && item.fields.itemType == "Milestone"){
						                oldTask.startDate  = (item.fields && item.fields.StartDate ) ?  new Date(item.fields.StartDate) : '';
							                oldTask.ttype = "milestone";
							                oldTask.cls = 'milstoneshape';
							                oldTask.milestoneWidth = 50;
										}else if(item.fields && item.fields.itemType == "Phase"){
											oldTask.startDate  = (item.fields && item.fields.StartDate ) ?  new Date(item.fields.StartDate) : '';
											oldTask.endDate    = (item.fields && item.fields.EndDate ) ?  new Date(item.fields.EndDate) : '';
											oldTask.ttype = "phase";
									}else {
										oldTask.startDate  = (item.fields && item.fields.StartDate ) ?  new Date(item.fields.StartDate) : '';
										oldTask.endDate    = (item.fields && item.fields.EndDate ) ?  new Date(item.fields.EndDate) : '';
									}

									//setting start and end time
									if(oldTask.startDate && oldTask.startDate != ''){
										oldTask.startDate.setHours(0, 0, 0, 0);
									}
									if(oldTask.endDate && oldTask.endDate != ''){
										oldTask.endDate.setHours(23, 59, 59, 999);
									}

										targetResource.groupItems.splice(itemIndexOld, 1, item);
									}
								} else {
									// Relationship doesn't exist
									this.$options.roadmap.eventStore.remove(item.id);
									targetResource.groupItems.splice(itemIndexOld, 1);
								}
							}
						}

					} else {
						_this.milestoneMapById[item.id] = item;
						_this.milestoneData.milestones.push(item);
						_this.addMileStoneInRoadMap(item)
					}

			}else{
				for(let item of this.milestoneData.milestones){
					this.milestoneMapById[item.id] = item;
					this.addMileStoneInRoadMap(item)
				}
			}

			this.fillMilestoneInMenuList();
			
			// Only collapse milestone resource when adding new milestones, not when editing existing ones
			if (!item) {
				// This is called without a specific item (initial load), so collapse the resource
				const milestoneResource = this.$options.roadmap.resourceStore.getById("-1001");
				if (milestoneResource) {
					toggleResourceExpand(milestoneResource,this.groupBy.value,this.$options.roadmap);
					this.$options.roadmap.toggleCollapse(milestoneResource);
					console.log('Milestone resource collapsed after initial loading');
				}
			}
		},
		removeMilestoneFromRoadmap(milestoneIds){
			let _this = this;
			for (let milestoneId of milestoneIds) {
				//remove assignment
				this.$options.roadmap.assignmentStore.remove('a-' + milestoneId);
				//remove from roadmap
				this.$options.roadmap.eventStore.remove(milestoneId);
				let itemIndex = _.findIndex(_this.milestoneData.milestones, {id: milestoneId});
				if (itemIndex > -1) {
					_this.milestoneData.milestones.splice(itemIndex, 1);
				}
				//remove from map
				delete _this.milestoneMapById[milestoneId];
			}
		},
		/**
		 * Adds a milestone to the roadmap scheduler
		 * @param {Object} item - The milestone item to add
		 */
		addMileStoneInRoadMap(item) {
			console.log(`Adding milestone to roadmap: ${item.title}`);
			
			// Add milestone to milestoneMapById if not already present
			if (!this.milestoneMapById[item.id]) {
				this.milestoneMapById[item.id] = item;
				console.log(`Added milestone ${item.title} to milestoneMapById`);
			}
			
			const targetResourceId = this.getMilestoneTargetResourceId(item);
			const resource = this.$options.roadmap.resourceStore.getById(targetResourceId);
			
			if (!resource) {
				console.warn(`Target resource ${targetResourceId} not found for milestone ${item.title}`);
				return;
			}
			
			const newTask = this.createMilestoneTask(item, targetResourceId);
			const assignment = this.createMilestoneAssignment(item, resource.id);
			
			this.addMilestoneToResource(resource, item);
			this.$options.roadmap.eventStore.add(newTask);
			this.$options.roadmap.assignmentStore.add(assignment);
			
			// Scroll to the newly created milestone/phase
			// const createdEvent = this.$options.roadmap.eventStore.getById(newTask.id);
			// if (createdEvent) {
			// 	this.scrollToNewEvent(createdEvent, 'created', item.title);
			// }
			
			// console.log(`Successfully added milestone ${item.title} to resource ${targetResourceId}`);
		},

		/**
		 * Determines the target resource ID for a milestone
		 * @param {Object} item - The milestone item
		 * @returns {string} - The target resource ID
		 */
		getMilestoneTargetResourceId(item) {
			const defaultResourceId = "-1001"; // Global milestone resource
			
			if (this.groupBy.value !== "Section") {
				console.log(`Not grouped by Section, using default resource: ${defaultResourceId}`);
				return defaultResourceId;
			}
			
			if (!this.hasValidSectionRelations(item)) {
				console.log(`Milestone ${item.title} has no section relations, using default resource: ${defaultResourceId}`);
				return defaultResourceId;
			}
			
			// Find the section relation that matches the current roadmap ID
			const roadmapSectionRelation = this.findRoadmapSectionRelation(item);
			if (!roadmapSectionRelation) {
				console.log(`Milestone ${item.title} has no section relation for current roadmap, using default resource: ${defaultResourceId}`);
				return defaultResourceId;
			}
			
			const sectionId = roadmapSectionRelation.baseItemId;
			console.log(`Milestone ${item.title} assigned to section: ${sectionId} for roadmap: ${this.roadmap.id}`);
			return sectionId;
		},

		/**
		 * Finds the section relation that matches the current roadmap ID
		 * @param {Object} item - The milestone item
		 * @returns {Object|null} - The matching section relation or null
		 */
		findRoadmapSectionRelation(item) {
			if (!item.sectionRelations || !Array.isArray(item.sectionRelations)) {
				console.log(`No section relations found for milestone ${item.title}`);
				return null;
			}
			
			console.log(`Checking ${item.sectionRelations.length} section relations for milestone ${item.title}`);
			
			// Iterate through each section relation to find the one matching current roadmap
			for (const relation of item.sectionRelations) {
				if (!this.isValidSectionRelation(relation)) {
					continue;
				}
				
				const sectionId = relation.baseItemId;
				const roadmapSection = this.getRoadmapSection(sectionId);
				
				if (this.isSectionForCurrentRoadmap(roadmapSection)) {
					console.log(`Found matching section relation for milestone ${item.title}:`, {
						sectionId,
						roadmapId: roadmapSection?.parentRoadmapId,
						currentRoadmapId: this.roadmap.id
					});
					return relation;
				}
			}
			
			console.log(`No matching section relation found for milestone ${item.title} in current roadmap ${this.roadmap.id}`);
			return null;
		},

		/**
		 * Validates if a section relation is valid for processing
		 * @param {Object} relation - The section relation object
		 * @returns {boolean} - True if relation is valid
		 */
		isValidSectionRelation(relation) {
			return relation && 
				   relation.linkType === "roadmap-section" && 
				   relation.baseItemId !== undefined && 
				   relation.baseItemId !== null;
		},

		/**
		 * Retrieves roadmap section by ID
		 * @param {string} sectionId - The section ID
		 * @returns {Object|null} - The roadmap section or null if not found
		 */
		getRoadmapSection(sectionId) {
			try {
				const roadmapSection = this.$options.roadmapSectionsCrud.getSectionById(sectionId);
				if (!roadmapSection) {
					console.warn(`Roadmap section not found for ID: ${sectionId}`);
				}
				return roadmapSection;
			} catch (error) {
				console.error(`Error retrieving roadmap section ${sectionId}:`, error);
				return null;
			}
		},

		/**
		 * Checks if a roadmap section belongs to the current roadmap
		 * @param {Object} roadmapSection - The roadmap section object
		 * @returns {boolean} - True if section belongs to current roadmap
		 */
		isSectionForCurrentRoadmap(roadmapSection) {
			if (!roadmapSection) {
				return false;
			}
			
			const isCurrentRoadmap = roadmapSection.parentRoadmapId === this.roadmap.id;
			
			if (isCurrentRoadmap) {
				console.log(`Section ${roadmapSection.name} (${roadmapSection.id}) belongs to current roadmap ${this.roadmap.id}`);
			} else {
				console.log(`Section ${roadmapSection.name} (${roadmapSection.id}) belongs to roadmap ${roadmapSection.parentRoadmapId}, not current roadmap ${this.roadmap.id}`);
			}
			
			return isCurrentRoadmap;
		},

		/**
		 * Checks if milestone has valid section relations
		 * @param {Object} item - The milestone item
		 * @returns {boolean} - True if has valid section relations
		 */
		hasValidSectionRelations(item) {
			return item.sectionRelations && 
				   Array.isArray(item.sectionRelations) && 
				   item.sectionRelations.length > 0 &&
				   this.findRoadmapSectionRelation(item) !== null;
		},

		/**
		 * Creates a milestone task for the scheduler
		 * @param {Object} item - The milestone item
		 * @param {string} targetResourceId - The target resource ID
		 * @returns {Object} - The created task
		 */
		createMilestoneTask(item, targetResourceId) {
			const newTask = this.createItemForRoadmap(item);
			newTask.rollup = true;
			newTask.groupId = targetResourceId;
			
			this.configureTaskByType(newTask, item);
			
			return newTask;
		},

		/**
		 * Configures task properties based on item type
		 * @param {Object} newTask - The task to configure
		 * @param {Object} item - The milestone item
		 */
		configureTaskByType(newTask, item) {
			const itemType = item.fields?.itemType;
			
			if (itemType === "Milestone") {
				this.configureMilestoneTask(newTask, item);
			} else if (itemType === "Phase") {
				this.configurePhaseTask(newTask, item);
			} else {
				this.configureDefaultTask(newTask);
			}
		},

		/**
		 * Configures a milestone task
		 * @param {Object} newTask - The task to configure
		 * @param {Object} item - The milestone item
		 */
		configureMilestoneTask(newTask, item) {
			newTask.startDate = item.fields?.StartDate ? new Date(item.fields.StartDate) : '';
			newTask.duration = 0;
                newTask.cls = 'milstoneshape';
				newTask.milestoneWidth = 50;
			newTask.ttype = "milestone";
			// console.log(`Configured milestone task: ${item.title}`);
		},

		/**
		 * Configures a phase task
		 * @param {Object} newTask - The task to configure
		 * @param {Object} item - The phase item
		 */
		configurePhaseTask(newTask, item) {
			newTask.startDate = item.fields?.StartDate ? new Date(item.fields.StartDate) : '';
			newTask.endDate = item.fields?.EndDate ? new Date(item.fields.EndDate) : '';
			newTask.ttype = "phase";
			console.log(`Configured phase task: ${item.title}`);
		},

		/**
		 * Configures a default task
		 * @param {Object} newTask - The task to configure
		 */
		configureDefaultTask(newTask) {
			if (newTask.startDate) {
				newTask.startDate.setHours(0, 0, 0, 0);
			}
			if (newTask.endDate) {
				newTask.endDate.setHours(23, 59, 59, 999);
			}
			console.log('Configured default task');
		},

		/**
		 * Creates a milestone assignment
		 * @param {Object} item - The milestone item
		 * @param {string} resourceId - The resource ID
		 * @returns {Object} - The created assignment
		 */
		createMilestoneAssignment(item, resourceId) {
			return {
				id: `a-${item.id}`,
				resourceId: resourceId,
				eventId: item.id
			};
		},

		/**
		 * Adds milestone to resource's group items
		 * @param {Object} resource - The target resource
		 * @param {Object} item - The milestone item
		 */
		addMilestoneToResource(resource, item) {
			if (!resource.groupItems) {
				resource.groupItems = [];
			}
			resource.groupItems.push(item);
		},
		createMilestoneGroupIfNotExist(){
			if(this.$options.roadmap && !this.$options.roadmap.resourceStore.getById("-1001")) {
				let mileStoneTask 		= this.createGroupItemForRoadmap({});
				mileStoneTask.name = "Milestones";
				mileStoneTask.title 	= "Milestones";
				mileStoneTask.id 		= "-1001";
				mileStoneTask.ttype		= "milestone";
				mileStoneTask.cls		= "kendis-ir-milestone-resource";
				mileStoneTask.expanded		= false;
				mileStoneTask.color = "#f0f0f0";
				mileStoneTask.children = false;
				this.$options.roadmap.resourceStore.insert(0,mileStoneTask);
				this.drawGroupHeaderEvents([this.$options.roadmap.resourceStore.getById("-1001")])
			}
		},
		async waitForMeta()  {
		    return new Promise((resolve) => {
		        const checkBatches = () => {
					if(this.groupBy.applied){
						if(this.groupBy.value === groupByValues.Batches){
							if (this.$root.$options.meta.batches) {
								resolve();
							}
						}else if(this.groupBy.value === groupByValues.Teams){
							if (this.$root.$options.meta.teams) {
								resolve();
							}
						}else if(this.groupBy.value === groupByValues.Sprints){
							if (this.$root.$options.meta.containers) {
								resolve();
							}
						}
						else if(this.groupBy.value === groupByValues.Session){
							if (this.$root.$options.meta.sessionById) {
								resolve();
							}
						}
						else if(this.groupBy.value === groupByValues.SolutionBoards){
							if (this.$root.$options.meta.solutionBoards) {
								resolve();
							}
						}else{
							setTimeout(checkBatches, 20); // Check again after 100ms
						}
					}else{
						//for group by is not applied
						resolve();
					}
		        };
		        checkBatches();
		    });
		},
		loadRoadmapItemsInTimeCapsules() {
			let _this = this;
			if (!this.items) {
				this.items = [];
			}
			let data = {}
			data.hierachLevel = ""+this.level;
			if (this.filters.filter) {
				let filters = this.getFilterCriteria(this.roadmap, this.filters.filter.criteria, this.filters.searchTags,fetchPlannedOnly,fetchUnplannedOnly);
				if (!_.isEmpty(filters.rules)) {
					data.filter = filters;
				}
			}else {
				let filters = this.getFilterCriteria(this.roadmap, {}, this.filters.searchTags,fetchPlannedOnly,fetchUnplannedOnly);
				if (!_.isEmpty(filters.rules)) {
					data.filter = filters;
				}
			}
			data.requestId = getNewUUID();
			if (this.groupBy.value != "-1") {
				data.groupBy = this.groupBy.value;
				data.fetchGroupItems = true;
			}
			//data.noRollup = true;
			data.boardId = this.roadmap.id;
			axios.post("/releasetrain/" + this.store.releaseTrainId + "/backlog", data).then(res => {
				_this.loader.show = false;
				if (res.data) {
					// _this.pagination.totalItemSize = res.data.result.total;
					_this.setBucketViewData(res.data.result.items, false);
					_this.createLoadedItemsMap(res.data.result.items);
					fitSchedulerToEvents(this.$options.roadmap);
					// _this.loadRollups();
				}
			}).catch(error => {
				console.log(error);
				_this.loader.show = false;
			});
		},
		createLoadedItemsMap: function(items) {
			let _this = this;
			_.each(items, item => {
				_this.itemsByIdMap[item.id] = _this.setItemForMap(item);
			});
			_this.itemsByIdMapVersion++;
			return items
		},
		setItemForMap(item){
			let _this = this;
			item._fields = item.fields
			if(item.status) {
				item.status = _this.store.getStatusMap[item.status.id];
			}else{
				item.status = {};
			}

			return item
		},
		getTimeRanges: function() {
			let _this = this;
			let timeRanges = [];
			try {

				for (let timeCapsule of _this.store.gettimeCapsules) {
					let timeRange = {};
					timeRange.id = timeCapsule.id;
					let endDate = new Date(timeCapsule.endDate);
					let startDate = new Date(timeCapsule.startDate);

					if(!_this.isValidToShow(startDate,endDate)){
						continue;
					}
					startDate.setHours(0, 0, 0, 0); // for complete time range cover
					endDate.setHours(23, 59, 59, 999);
					timeRange.startDate = startDate;
					timeRange.duration = daysBetweenDates(startDate, endDate);
					timeRange.name = timeCapsule.label;
					timeRange.durationUnit = 'day';
					timeRange.cls = "time-range-"+timeCapsule.id;
					timeRanges.push(timeRange);
				}
			}catch (e) {
				console.log(e);
			}
			return timeRanges;

		},
		handleUnassignPlannedEvent: async function(records, schedule, unplannedGrid, newStartDate, newEndDate) {
			let _this = this;
			for(let event of records) {
				// Check if this is a child event
				const isChildEvent = event.get('isChild') || event.get('ttype') === 'child_item';
				
				if (isChildEvent) {
					// Handle child event unplanning
					await _this.handleChildEventUnplanning(event, schedule, newStartDate, newEndDate);
				} else {
					// Handle parent item unplanning (existing logic)
				let targetItem = _this.itemsByIdMap[event.id.split("_")[0]];

				if (!_this.groupBy.applied) {
						// If in grid child mode (filtered mode), don't add parent items to the grid
						if (!_this.isGridChildMode) {
					unplannedGrid.store.add(event);
						}
					schedule.eventStore.remove(event);
				} else {
				
					_this.removeRelatedEvents(event, schedule);
					let groups = [];
					//if th unplanned is groupedby no group
					if(_this.groupByUnplanned.value === "Section"){
						//resolveGroupIdForItemTransition to get the group
						let groupId = await _this.resolveGroupIdForItemTransition(targetItem.id, 'unplanned', _this.groupByUnplanned.value);
						groups = [groupId];
						_this.addItemsInUnplannedGrid([_.cloneDeep(targetItem)], groupId);
					}else{
						groups = await roadmapVue.getGroupIdsForItemForTheGroup(targetItem.id, false, true);
						// Ensure unplanned group resources exist before adding items - following onItemEditSaved pattern
						for(let group of groups){
							let groupId = group._id?.id ? group._id.id : 'null';
							_this.addItemsInUnplannedGrid([_.cloneDeep(targetItem)], groupId);
						}
					}
					
				}
				targetItem.fields.StartDate = newStartDate?newStartDate:"";
				targetItem.fields.EndDate = newEndDate?newEndDate:"";
				_this.updateItemDates(targetItem);
				}
			}
		},
		
		/**
		 * Loads children counts for multiple items
		 * @param {Array} itemIds - Array of item IDs to fetch counts for
		 * @returns {Promise<Object>} Map of itemId to {plannedCount, unplannedCount}
		 */
		loadChildrenCounts: async function(itemIds) {
			const _this = this;
			
			if (!itemIds || itemIds.length === 0) {
				console.warn('No item IDs provided for children count loading');
				return {};
			}
			
			// Check session validity before making API call
			const sessionValid = await _this.validateSession('roadmap-children-counts');
			if (!sessionValid) {
				return {}; // Session expired, user will be redirected
			}
			
			try {
				// console.log('Loading children counts for items:', itemIds);
				
				// Prepare request data for bulk children count API with TFS settings
				const requestData = {
					releaseTrainId: _this.releaseTrain.id,
					itemIds: itemIds,
					countsOnly: true, // Flag to indicate we only need counts
					// Include TFS settings for proper planned/unplanned calculation
					iterationPathDates: parseInt(_this.roadmap.iterationPathDates, 10),
					datePreference: parseInt(_this.roadmap.datePreference, 10),
					boardId: _this.roadmap.id,
					almAccountType: _this.almAccountType, // Include ALM account type for TFS detection
					tfsIterationMap: _this.store.tfsIterationMap // Send TFS iteration map to avoid backend fetch
				};
				
				const response = await axios.post('/releasetrain/backlog/backlogItemChildrenCounts', requestData);
				
				if (response.data && response.data.counts) {
					const counts = response.data.counts;
					console.log('Received children counts:', counts);
					
					// Process the counts and update cache
					Object.keys(counts).forEach(itemId => {
						const itemCounts = counts[itemId];
						if (itemCounts) {
							// Update the unplanned children count cache
							_this.unplannedChildrenCountCache[itemId] = itemCounts.unplannedCount || 0;
							
							// Store planned count in a new cache
							if (!_this.plannedChildrenCountCache) {
								_this.plannedChildrenCountCache = {};
							}
							_this.plannedChildrenCountCache[itemId] = itemCounts.plannedCount || 0;
						}
					});
					
					// Trigger UI refresh to show the updated counts
					_this.$forceUpdate();
					
					return counts;
				} else {
					console.warn('No counts data received from API');
					return {};
				}
			} catch (error) {
				console.error('Error loading children counts:', error);
				showBryntumToastMessage('Failed to load children counts', 'error');
				return {};
			}
		},
		
		/**
		 * Loads children counts for all visible items in the scheduler
		 */
		loadAllItemsChildrenCounts: async function() {
			const _this = this;
			
			// Get all item IDs from the current scheduler resources
			const itemIds = [];
			const scheduler = _this.$options.roadmap;
			
			// if (scheduler && scheduler.resourceStore) {
			// 	scheduler.resourceStore.allRecords.forEach(resource => {
			// 		if (resource.get && resource.get('isItem') && resource.get('orgId')) {
			// 			itemIds.push(resource.get('orgId'));
			// 		}
			// 	});
			// }

			//get item ids from itemsByIdMap
			for(let itemId in _this.itemsByIdMap){
				itemIds.push(itemId);
			}
			
			if (itemIds.length > 0) {
				console.log(`Loading children counts for ${itemIds.length} items`);
				await _this.loadChildrenCounts(itemIds);
			} else {
				console.warn('No item resources found to load children counts');
			}
		},
		
		/**
		 * Handles unplanning of child events
		 * @param {Object} childEvent - The child event being unplanned
		 * @param {Object} schedule - The scheduler instance
		 * @param {Date} newStartDate - New start date (usually empty for unplanned)
		 * @param {Date} newEndDate - New end date (usually empty for unplanned)
		 */
		handleChildEventUnplanning: async function(childEvent, schedule, newStartDate, newEndDate) {
			console.log('Handling child event unplanning:', childEvent.id);
			
			const _this = this;
			
			// Extract child item ID using the new format: <child_id>_<parent_item_id>_<group_id>
			const childItemId = _this.getChildItemId(childEvent.id);
			const childItem = _this.itemsByIdMap[childItemId];
			
			if (!childItem) {
				console.error('Child item not found for ID:', childItemId);
				showBryntumToastMessage('Child item not found', 'error');
				return;
			}
			
			// Extract parent item ID from the event ID: <child_id>_<parent_item_id>_<group_id>
			const eventIdParts = childEvent.id.split('_');
			if (eventIdParts.length < 3) {
				console.error('Invalid child event ID format:', childEvent.id);
				showBryntumToastMessage('Invalid child event ID format', 'error');
				return;
			}
			
			const parentItemId = eventIdParts[1];
			const groupId = eventIdParts[2];
			const parentItem = _this.itemsByIdMap[parentItemId];
			
			if (!parentItem) {
				console.error('Parent item not found for ID:', parentItemId);
				showBryntumToastMessage('Parent item not found', 'error');
				return;
			}
			
			// Update child item dates to be empty (unplanned)
			childItem.fields.StartDate = newStartDate || "";
			childItem.fields.EndDate = newEndDate || "";
			
			// Remove the child event from scheduler
			schedule.eventStore.remove(childEvent);
			
			// Resolve the correct unplanned group for this child item
			let unplannedGroupId = 'null';
			try {
				unplannedGroupId = await _this.resolveGroupIdForItemTransition(
					childItem.id, 
					'unplanned', 
					_this.groupByUnplanned.value
				);
				console.log(`Resolved unplanned group ID for child ${childItem.id}: ${unplannedGroupId}`);
			} catch (error) {
				console.error('Error resolving unplanned group ID for child:', error);
				// Fallback to null group
				unplannedGroupId = 'null';
			}
			
			// Add child to unplanned cache (check for duplicates first)
			if (!_this.unplannedChildrenCache[parentItemId]) {
				_this.unplannedChildrenCache[parentItemId] = [];
			}
			
			// Add group information to the child item for proper unplanned grid display
			const childItemWithGroupInfo = {
				...childItem,
				unplannedGroupId: unplannedGroupId,
				unplannedGroupBy: _this.groupByUnplanned.value
			};
			
			// Check if child is already in cache to prevent duplicates
			const existingChildIndex = _this.unplannedChildrenCache[parentItemId].findIndex(
				cachedChild => cachedChild.id === childItem.id
			);
			
			if (existingChildIndex === -1) {
				// Child not in cache, add it
				_this.unplannedChildrenCache[parentItemId].push(childItemWithGroupInfo);
				_this.unplannedChildrenCountCache[parentItemId] = _this.unplannedChildrenCache[parentItemId].length;
				console.log(`Added child ${childItemId} to unplanned cache for parent ${parentItemId}`);
			} else {
				// Child already in cache, just update it
				_this.unplannedChildrenCache[parentItemId][existingChildIndex] = childItemWithGroupInfo;
				console.log(`Updated existing child ${childItemId} in unplanned cache for parent ${parentItemId} with group ${unplannedGroupId}`);
			}
			
			// Update the child item in database
			_this.updateItemDates(childItem);
			
			// Decrease planned children count since this child is now unplanned
			console.log(`Before decrement - plannedChildrenCountCache[${parentItemId}]: ${_this.plannedChildrenCountCache[parentItemId]}`);
			
			// Ensure the planned children count cache exists and is initialized
			if (!_this.plannedChildrenCountCache[parentItemId]) {
				_this.plannedChildrenCountCache[parentItemId] = 0;
				console.log(`Initialized plannedChildrenCountCache[${parentItemId}] to 0`);
			}
			
			// Decrease planned children count since this child is now unplanned
			if (_this.plannedChildrenCountCache[parentItemId] > 0) {
				_this.plannedChildrenCountCache[parentItemId]--;
				console.log(`Decreased planned children count for parent ${parentItemId}, new count: ${_this.plannedChildrenCountCache[parentItemId]}`);
			} else {
				console.log(`plannedChildrenCountCache[${parentItemId}] was already 0, no decrement needed`);
			}
			
			// Log the current state after decrement
			console.log(`After decrement - plannedChildrenCountCache[${parentItemId}]: ${_this.plannedChildrenCountCache[parentItemId]}`);
			
			// If grid is in child mode for this parent, add the item to the grid
			if (_this.isGridChildMode && 
				_this.isUnplannedGridFiltered() && 
				_this.unplannedGridMode.parentItemId === parentItemId) {
				
				console.log('Adding unplanned child to filtered grid:', childItem.title);
				
				// Check if item is already in grid to prevent duplicates
				const gridStore = _this.$options.unplannedGrid.store;
				const existingGridRecord = gridStore.find(record => record.get('orgId') === childItem.id);
				
				if (!existingGridRecord) {
					// Transform child item to grid format
					const gridItem = {
						id: `${childItem.id}_unplanned`,
						_id: `${childItem.id}_unplanned`, 
						title: childItem.title,
						status: childItem.status || { title: "unplanned" },
						statusClass: childItem.statusClass || 'unplanned',
						orgId: childItem.id,
						isGroup: false,
						searchableKey: _this.generateSearchableKey(childItem),
						isChild: true
					};
					
					// Add to the filtered grid
					gridStore.add(gridItem);
					console.log(`Added child ${childItemId} to filtered grid`);
				} else {
					console.log(`Child ${childItemId} already exists in filtered grid`);
				}
				
				_this.showSmartMessage(`Child "${childItem.title}" moved to unplanned and added to grid`, 'success');
			} else {
				_this.showSmartMessage(`Child "${childItem.title}" moved to unplanned`, 'success');
			}
			
			// Log final count state before refresh
			console.log(`Final count state before scheduler refresh:`);
			console.log(`- plannedChildrenCountCache[${parentItemId}]: ${_this.plannedChildrenCountCache[parentItemId]}`);
			console.log(`- unplannedChildrenCountCache[${parentItemId}]: ${_this.unplannedChildrenCountCache[parentItemId]}`);
			
			// Refresh scheduler to update both planned and unplanned count displays on parent resource
			schedule.refresh();
			
			console.log(`Child item ${childItemId} successfully moved to unplanned for parent ${parentItemId}`);
		},
		
		removeRelatedEvents:	function (removedEvent, scheduler) {
			const _this = this;
			const relatedEvents =  _this.$options.roadmap.eventStore.allRecords
				.filter(event => event.get('orgId') === removedEvent.get('orgId'));

			// Remove the related events from the event store
			// Note: Be cautious to avoid triggering the remove listener again and creating a loop
			scheduler.eventStore.beginBatch(); // Optimize to reduce event firing
			scheduler.eventStore.remove(relatedEvents);
			scheduler.eventStore.endBatch();
		},
		refreshUnplannedGrid: function() {
			// Helper function to refresh the unplanned grid display
			if (this.$options.unplannedGrid) {
				console.log('Refreshing unplanned grid...');
				
				// Update all grid records with latest data from itemsByIdMap
				const gridStore = this.$options.unplannedGrid.store;
				if (gridStore) {
					gridStore.allRecords.forEach(gridRecord => {
						// Skip group records
						if (gridRecord.get('isGroup')) {
							return;
						}
						
						// Get the item ID from the grid record
						const itemId = gridRecord.id.split('_')[0];
						const updatedItem = this.itemsByIdMap[itemId];
						
						if (updatedItem) {
							// Update status information
							if (updatedItem.status) {
								gridRecord.set('status', updatedItem.status);
								
								// Update status class based on status category
								let statusClass = updatedItem.status.category === "ToDo" ? "a" :
									updatedItem.status.category === "InProgress" ? "b" :
									updatedItem.status.category === "Done" ? "c" : "e";
								gridRecord.set('statusClass', statusClass);
								
								console.log(`Updated status for item ${itemId}: ${updatedItem.status.title} (class: ${statusClass})`);
							}
							
							// Update other relevant fields
							if (updatedItem.title) {
								gridRecord.set('title', updatedItem.title);
							}
							if (updatedItem.almKey) {
								gridRecord.set('almKey', updatedItem.almKey);
							}
							if (updatedItem.kendisKey) {
								gridRecord.set('kendisKey', updatedItem.kendisKey);
							}
							if (updatedItem.url) {
								gridRecord.set('url', updatedItem.url);
							}
						}
					});
				}
				
				// Force a complete refresh of the grid
				this.$options.unplannedGrid.refreshRows();
				
				// Also refresh the grid store to ensure data consistency
				// if (this.$options.unplannedGrid.store) {
				// 	this.$options.unplannedGrid.store.refresh();
				// }
				console.log('Unplanned grid refresh completed');
			}
		},
		updateItemDates: function(editItem) {

			let _this 	= this;
			let metaMap = {};
			let item 	= {};
			item.id 	= editItem.id;
			metaMap.syncId 	= syncId;
			metaMap.event 	= "Update";
			//...
			var data = {};

			if (!item.fields) {
				item.fields = {};
			}

			if(editItem.fields.StartDate===undefined || editItem.fields.StartDate===""){
				item.fields.StartDate="";
			}else {
				editItem.fields.StartDate = new Date(editItem.fields.StartDate)
				item.fields.StartDate = editItem.fields.StartDate.format("yyyy-mm-dd'T'HH:MM:ss'Z'");
			}
			if(editItem.fields.EndDate===undefined || editItem.fields.EndDate===""){
				item.fields.EndDate="";
			}else {
				editItem.fields.EndDate = new Date(editItem.fields.EndDate)
				item.fields.EndDate = editItem.fields.EndDate.format("yyyy-mm-dd'T'HH:MM:ss'Z'");
			}

			let alm = this.$store.almAccounts[0];
			if(editItem.almItemId && alm.type == 'jira'){
				let tmp = { fields : {}};
				tmp.fields.StartDate = editItem.fields.StartDate;
				tmp.fields.EndDate = editItem.fields.EndDate;
				
				let _copy = _.cloneDeep(convertBackLogItemToItem(editItem));
				delete _copy.jiraFieldByKey;
				delete _copy.title;
				delete _copy.jiraProjectKey;
				delete _copy.jiraIssueTypeId;
				metaMap.jiraJson = stringifyToJiraJson(_copy, tmp, undefined, alm);

				data.releaseTrain = {id : this.$store.releaseTrain.id, title : this.$store.releaseTrain.title};
				data.almAccountId = alm.id;
				// this.loader.text += ' '+appendAlmInLoader(null, true, {almAccount : alm});
			}else {
				data.releaseTrain = {id : this.$store.releaseTrain.id, title : this.$store.releaseTrain.title};
				if (alm) {
					data.almAccountId = alm.id;
				}
			}

			data.releaseTrain = {id:this.releaseTrain.id};

			data.item = item;
			data.metaMap = metaMap;

			// this.loader.show = true;

			axios.post('/releasetrain/item/save', data)
				.then(response => {
				 if (response.data.item && response.data.item.fields && response.data.item.fields.AlmSyncError) {
						handleJiraError(response.data.item.fields);
					}
					
					// Refresh the unplanned grid after successful update
					this.refreshUnplannedGrid();

				})
				.catch(error => {
					console.log(error)
				});
		},
		saveItem: function(editItem) {

            let item = _.cloneDeep(editItem);
            if (item.storyPoints == undefined || item.storyPoints == "") {
                item.storyPoints = "0";
            }
            //...
            var data = {}
            if (this.tfsProject != undefined) {
                data.almAccountId = this.selectedAlm.id;
                delete item.fields.externalKey;
                delete item.fields.externalLink;

                delete item.otherRequirements;
                delete item.description;

                if (item.fields) {
                    let fields = {};
                    for (let key in item.fields) {
                        if (!key.includes(".")) {
                            fields[key] = item.fields[key];
                        }
                    }
                    item.fields = fields;
                }
            } else if (this.jiraProject != undefined) {
                data.almAccountId = this.selectedAlm.id;
            }
            data.releaseTrain = {id: this.releaseTrain.id, title: this.releaseTrain.title};

            //.............   handle start date/ end date
            if (item.fields.StartDate) {
                item.fields.StartDate = new Date(item.fields.StartDate);
            }
            if (item.fields.EndDate) {
                item.fields.EndDate = new Date(item.fields.EndDate);
            }

            if (item.fields.StartDate && _.isDate(item.fields.StartDate)) {
                item.fields.StartDate = item.fields.StartDate.format("yyyy-mm-dd'T'HH:MM:ss'Z'");
            } else {
                item.fields.StartDate = "";
            }
            if (item.fields.EndDate && _.isDate(item.fields.EndDate)) {
                item.fields.EndDate = item.fields.EndDate.format("yyyy-mm-dd'T'HH:MM:ss'Z'");
            } else {
                item.fields.EndDate = "";
            }
            //..............................................
            if(item.status) {
				item.status = {id: item.status.id};
			}

			data.backlogLevel = "" + this.currentHierarchyLevel.level;
            data.item = item;

            data.syncId = syncId;

            // if (this.loadAlmId && this.tfsProject != undefined) {
            //     var requestId = getNewUUID();
            //     data.requestId = requestId;
            // }

            var metaMap = {};
            metaMap.syncId = syncId;
            metaMap.releaseTrainId = this.releaseTrain.id
            // metaMap.view = this.view;
			metaMap.view = "";
            if (editItem.id) {
                metaMap.event = "ItemUpdate";
            } else {
                metaMap.event = "ItemAdd";
            }

            // this.loader.show = true;
            // this.loader.text = "Saving ...";

            // if (this.$options.jiraJson) {
            //     metaMap.jiraJson = this.$options.jiraJson;
            //     this.loader.text += ' ' + appendAlmInLoader(null, true, {almAccount: this.alm});
            // }
            data.metaMap = metaMap;

            var _this = this;
            axios.post('/releasetrain/item/save', data)
                .then(response => {
                    // Refresh the unplanned grid after successful save
                    this.refreshUnplannedGrid();
                })
                .catch(error => {
					console.log(error);
                    // _this.loader.show = false;
                    onAlmError(error.response ? error.response.data : error);
                });
        },
		//..............................................
		//.........   events
		onClickViewToggele: function () {
			let path = this.$route.fullPath;
			path = path.replace(new RegExp("roadmap" + '$'), 'timeline');
			this.$router.replace(path);
		},
		onGroupBySelectValue: function() {
			// Prevent groupBy changes while data is loading
			if (this.isDataLoading) {
				console.log('GroupBy change blocked: Data is currently loading');
				// Show user-friendly message
				if (typeof showTopMessage === 'function') {
					showTopMessage('Please wait for data to finish loading before changing grouping', 'warning', 3000);
				}
				return;
			}
			
			// If in grid child mode, reset it before changing group by
			if (this.isGridChildMode) {
				console.log('Resetting grid child mode due to group by change');
				this.resetUnplannedGrid();
				this.isGridChildMode = false;
			}
			
			this.$options.roadmap.eventStore.clearFilters();
			// this.$options.unplannedGrid.collapsed = true;
			// this.$options.firstOpenUnplannedGrid = false;
			this.items = [];
			// this.setRoadmapData([], true);
			this.groupBy.type = "";
			this.groupBy.customType = "";
			if (this.groupBy.value === "-1") {
				this.groupBy.applied = false;
			} else {
				this.groupBy.applied = true;
				if (!_.isEmpty(this.almMappingByLevel[this.currentHierarchyLevel.level])) {
					_.each(this.almMappingByLevel[this.currentHierarchyLevel.level].jiraFields, field => { // for jira fields
						if (field && field.id && this.groupBy.value == field.id) {
							if(field.schema && field.schema.type) {
								this.groupBy.type = field.schema.type;
								if(field.schema.items) {
									this.groupBy.itemType = field.schema.items;
								}
								if(field.custom) {
									this.groupBy.customType = field.schema.custom;
								}
							}
						}
					});
					_.each(this.almMappingByLevel[this.currentHierarchyLevel.level].tfsFields, field => { // for tfs fields
						var key = field.referenceName.replace(".","_");
						if (field && this.groupBy.value == key) {
							this.groupBy.type  = field.type;
							this.groupBy.customType = field.type;
						}
					});
				}
			}
			if(this.displayMode.value == DisplayModes.RAW_ITEMS) {
				this.isChangeGroupBy = true;
				localStorage.setItem(this.releaseTrain.id +"_"+this.roadmapId+ "_Roadmap_GroupBy", this.groupBy.value);
				//this.loadRoadmapItems();}
				this.loadData();
			}
			if(this.groupBy.applied){
				//disable widgets
				this.hideBbarUnplannedItems();
			}else{
				this.showBbarUnplannedItems();
			}

		},
		onGroupBySelectValueUnplanned: function() {
			// Prevent duplicate calls during group by initialization
			if (this.isInitializingGroupBy) {
				return;
			}
			
			// this.$options.roadmap.eventStore.clearFilters();
			// this.$options.unplannedGrid.collapsed = true;
			// this.$options.firstOpenUnplannedGrid = false;
			// this.items = [];
			// this.setRoadmapData([], true);
			this.groupByUnplanned.type = "";
			this.groupByUnplanned.customType = "";
			if (this.groupByUnplanned.value === "-1") {
				this.groupByUnplanned.applied = false;
			} else {
				this.groupByUnplanned.applied = true;
				if (!_.isEmpty(this.almMappingByLevel[this.currentHierarchyLevel.level])) {
					_.each(this.almMappingByLevel[this.currentHierarchyLevel.level].jiraFields, field => { // for jira fields
						if (field && field.id && this.groupByUnplanned.value === field.id) {
							if(field.schema && field.schema.type) {
								this.groupByUnplanned.type = field.schema.type;
								if(field.schema.items) {
									this.groupByUnplanned.itemType = field.schema.items;
								}
								if(field.custom) {
									this.groupByUnplanned.customType = field.schema.custom;
								}
							}
						}
					});
					_.each(this.almMappingByLevel[this.currentHierarchyLevel.level].tfsFields, field => { // for tfs fields
						var key = field.referenceName.replace(".","_");
						if (field && this.groupByUnplanned.value === key) {
							this.groupByUnplanned.type  = field.type;
							this.groupByUnplanned.customType = field.type;
						}
					});
				}
			}
			// this.isChangeGroupBy = true;
			localStorage.setItem(this.releaseTrain.id +"_"+this.roadmapId+ "_Roadmap_GroupBy_Unplanned", this.groupByUnplanned.value);
			//this.loadRoadmapItems();}
			this.loadUnplannedOnClick();

			// if(this.groupBy.applied){
			// 	//disable widgets
			// 	this.hideBbarUnplannedItems();
			// }else{
			// 	this.showBbarUnplannedItems();
			// }

		},
		showBbarUnplannedItems: function() {
			this.$options.unplannedGrid.widgetMap['kendis-items-roadmap-page-index-dropdown-widget'].show();
			this.$options.unplannedGrid.widgetMap['kendis-items-roadmap-page-size-dropdown-widget'].show();
			this.$options.unplannedGrid.widgetMap['kendis-items-roadmap-page-size-dropdown-widget'].value=25;

			this.$options.unplannedGrid.widgetMap['prevBtn'].show();
			this.$options.unplannedGrid.widgetMap['nextBtn'].show();
		},
		hideBbarUnplannedItems: function() {
			this.$options.unplannedGrid.widgetMap['kendis-items-roadmap-page-index-dropdown-widget'].hide();
			this.$options.unplannedGrid.widgetMap['kendis-items-roadmap-page-size-dropdown-widget'].hide();
			this.$options.unplannedGrid.widgetMap['prevBtn'].hide();
			this.$options.unplannedGrid.widgetMap['nextBtn'].hide();
		},

		reloadUtilsMembers(){
			this.$options.batchViewUtils.reloadMembers();
			this.$options.rawItemsViewUtils.reloadMembers();
		},

		//..........
		onPercentageValueChange: function(option) {
			this.percentage.value = option;

			if (this.percentage.value == "") {
				_.each(this.$options.roadmap.eventStore.allRecords, record => {
					record.percentDone = -1;
				});
			}
			else {
				this.loadRollups();
			}

			localStorage.setItem(this.releaseTrain.id + "_Roadmap_Completion", this.percentage.value);
			this.percentage.show = false;
		},
		//..........    filters
		onFiltersApplied: function(filtersData, level, filterCount, filterId) {
			this.filters.filterCriteria = filtersData;
			this.filters.isApplied      = !_.isEmpty(this.filters.appliedFilters)
			this.filters.filtersCount   = filterCount;
			//this.loadRoadmapItems();
		},
		onFiltersApplied: function(filtersData, level, filterCount, filterId) {
			this.filters.filter = filtersData;
			this.filters.isApplied      = !_.isEmpty(this.filters.filter.criteria)
			this.filters.filtersCount   = filterCount;
			this.filters.filterCriteria = filtersData.criteria;

			if (_.isEmpty(filtersData)) {
				filtersData.id = "0";
			}

			if (filtersData.id && (this.roadmap.filterCriteria === undefined || this.roadmap.filterCriteria.id !== filtersData.id)) {
				this.roadmap.filterCriteria = filtersData;
				let roadmap = _.cloneDeep(this.roadmap);
				roadmap.filterCriteria = filtersData;
				if(roadmap.filterCriteria) {
					delete roadmap.filterCriteria.createdBy;
					delete roadmap.filterCriteria.createdOn;
					delete roadmap.filterCriteria.rowStatus;
					delete roadmap.filterCriteria.source;
					delete roadmap.filterCriteria.updatedBy;
					delete roadmap.filterCriteria.updatedOn;
				}

				let newTimeline = {name: roadmap.name, id: roadmap.id, filterCriteria: _.isEmpty(roadmap.filterCriteria) ? null : roadmap.filterCriteria};

				let request = {};
				request.board = JSON.stringify(newTimeline);
				this.requestSaveTimeline(request);
			} else {
				// if(this.$options.firstOpenUnplannedGrid) {
				// 	this.loadUnplannedOnClick();
				// }
				this.loadData();
			}
		},
		requestSaveTimeline(request) {
			let _this = this;
			axios
				.post("/releasetrain/kanban/board/save", request)
				.then((response) => {
					if(response.data.board) {
						_this.roadmap.filterCriteria = response.data.board.filterCriteria;
						// if(this.$options.firstOpenUnplannedGrid) {
						// 	this.loadUnplannedOnClick();
						// }
						_this.loadData();

					}
					showTopMessage('Roadmap Name changed', 'success', 1000);
				}).catch(error => {
				showTopMessage('Roadmap Name Changes Failed', 'warning', 1000);
			});
		},
		//...........................................
		onClickAddButton: function () {
			this.addToBoardPopup.level = this.currentHierarchyLevel;
			if (!_.isEmpty(this.store.almAccounts)) {
				this.addToBoardPopup.alm = this.store.almAccounts[0];
			}
			if (this.$options.gantt && this.$options.roadmap.eventStore.allRecords) {
				this.addToBoardPopup.boardItems = _.map(this.$options.roadmap.eventStore.allRecords,rcd=>rcd.id);
			}
			this.addToBoardPopup.item = {};
			this.addToBoardPopup.show = true;
		},
		onClickCreateNew(sectionId = 'null'){
			// Store the section ID for later use when saving the item
			if(this.groupBy.value==="Section"){
				this.addToBoardPopup.sectionId = sectionId;
			}
				
			this.onAddToBoardPopupCreateNew({title:""});
			
		},
		onClickAddExisting(){
			this.addToBoardPopup.level = this.currentHierarchyLevel;
			if (!_.isEmpty(this.store.almAccounts)) {
				this.addToBoardPopup.alm = this.store.almAccounts[0];
			}
			if (this.$options.gantt && this.$options.roadmap.eventStore.allRecords) {
				this.addToBoardPopup.boardItems = _.map(this.$options.roadmap.eventStore.allRecords,rcd=>rcd.id);
			}
			this.addToBoardPopup.item = {};
			this.addToBoardPopup.showCreateNew
			this.addToBoardPopup.show = true;

		},
		onClickAddFromALM(){
			this.onAddToBoardPopupAddFromAlm({title:""});
		},
		/**
		 * Calculates event dates based on TFS configuration and available data
		 * @param {Object} item - The backlog item
		 * @returns {Object|null} - Object with startDate, endDate, and dateSource, or null if no valid dates found
		 */
		calculateEventDates(item) {
			if (!item || !item.fields) {
				return null;
			}

			const isTfs = this.almAccountType === 'tfs';
			const useIterationDates = this.roadmap.iterationPathDates === 0;
			const preferIterationDates = this.roadmap.datePreference === 1;

			// Helper function to create properly formatted dates
			const createFormattedDates = (startDate, endDate, dateSource) => {
				if (!startDate || !endDate) return null;
				
				const start = new Date(startDate);
				const end = new Date(endDate);
				start.setHours(0, 0, 0, 0); // Complete time range cover
				end.setHours(23, 59, 59, 999);
				
				return { startDate: start, endDate: end, dateSource: dateSource };
			};

			// Helper function to get iteration path dates
			const getIterationDates = () => {
				if (!item.fields.tfsIterationPath || !this.store.tfsIterationMap) {
					return null;
				}

				const iterationPath = this.store.tfsIterationMap[item.fields.tfsIterationPath];
				if (!iterationPath?.attributes?.startDate || !iterationPath?.attributes?.finishDate) {
					return null;
				}

				return createFormattedDates(
					iterationPath.attributes.startDate,
					iterationPath.attributes.finishDate,
					'iteration'
				);
			};

			// Helper function to get direct field dates
			const getFieldDates = () => {
				return createFormattedDates(item.fields.StartDate, item.fields.EndDate, 'field');
			};

			// TFS-specific logic
			if (isTfs && useIterationDates) {
				if (preferIterationDates) {
					// Prefer iteration dates, fallback to field dates
					return getIterationDates() || getFieldDates();
				} else {
					// Prefer field dates, fallback to iteration dates
					return getFieldDates() || getIterationDates();
				}
			}

			// Non-TFS or when iteration dates are disabled
			return getFieldDates();
		},

		calculateStartAndEndDate(item, almAccountType, iterationPathDates, datePreference, tfsIterationMap) {
			let itemStartDate = null;
			let itemEndDate = null;

			function formatDate(date) {
				return new Date(date.setHours(0, 0, 0, 0));
			}

			function formatEndDate(date) {
				return new Date(date.setHours(23, 59, 59, 999));
			}

			function getIterationPathAttributes(path) {
				return tfsIterationMap[path] && tfsIterationMap[path].attributes;
			}

			if (almAccountType === 'tfs' && iterationPathDates === 0) {
				if (datePreference === 1) {
					let attributes = getIterationPathAttributes(item.fields.tfsIterationPath);
					if (attributes && attributes.startDate && attributes.finishDate) {
						itemStartDate = formatDate(new Date(attributes.startDate));
						itemEndDate = formatEndDate(new Date(attributes.finishDate));
					} else if (item.fields.StartDate && item.fields.EndDate) {
						itemStartDate = formatDate(new Date(item.fields.StartDate));
						itemEndDate = formatEndDate(new Date(item.fields.EndDate));
					}
				} else if (datePreference === 0) {
					if (item.fields.StartDate && item.fields.EndDate) {
						itemStartDate = formatDate(new Date(item.fields.StartDate));
						itemEndDate = formatEndDate(new Date(item.fields.EndDate));
					} else {
						let attributes = getIterationPathAttributes(item.fields.tfsIterationPath);
						if (attributes && attributes.startDate && attributes.finishDate) {
							itemStartDate = formatDate(new Date(attributes.startDate));
							itemEndDate = formatEndDate(new Date(attributes.finishDate));
						}
					}
				}
			} else {
				if (item.fields.StartDate && item.fields.EndDate) {
					itemStartDate = formatDate(new Date(item.fields.StartDate));
					itemEndDate = formatEndDate(new Date(item.fields.EndDate));
				}
			}

			return { startDate: itemStartDate, endDate: itemEndDate };
		},

		//............. edit item popup
		onItemEditClose: function(canceled) {
			if (canceled && this.itemEditPopup.eventRecord) {
				if (this.itemEditPopup.eventRecord.get('ttype') === "item" || this.itemEditPopup.eventRecord.get('ttype') === "child_item") {
					let orgId = this.itemEditPopup.eventRecord.get('orgId');
					let {startDate,endDate} = this.calculateStartAndEndDate(this.itemsByIdMap[orgId],
						this.almAccountType,this.roadmap.iterationPathDates,this.roadmap.datePreference, this.store.tfsIterationMap);
					// let oldStartDate = this.itemsByIdMap[orgId].fields?.StartDate;
					// let oldEndDate = this.itemsByIdMap[orgId].fields?.EndDate;
					this.itemEditPopup.eventRecord.startDate = new Date(startDate);
					this.itemEditPopup.eventRecord.endDate = new Date(endDate);
				} else {
					if (this.itemEditPopup.eventRecord.get('fields') && this.itemEditPopup.eventRecord.get('fields').StartDate) {
						this.itemEditPopup.eventRecord.startDate = new Date(this.itemEditPopup.eventRecord.get('fields').StartDate);
					}
					if (this.itemEditPopup.eventRecord.get('fields') && this.itemEditPopup.eventRecord.get('fields').EndDate) {
						this.itemEditPopup.eventRecord.endDate = new Date(this.itemEditPopup.eventRecord.get('fields').EndDate);
					}
				}
				if (this.itemEditPopup.oldResourceRecord && this.itemEditPopup.oldResourceRecord != undefined) {
					this.itemEditPopup.eventRecord.resourceId = this.itemEditPopup.oldResourceRecord.id;
				}
			}
			this.itemEditPopup.oldResourceRecord = undefined;
			this.itemEditPopup.eventRecord = undefined;
			this.itemEditPopup.gridTask = undefined;
			this.itemEditPopup.planningItemParams = undefined
			this.itemEditPopup.changes = {};
			this.itemEditPopup.item = undefined;
			this.itemEditPopup.groupChange = undefined;
			this.itemEditPopup.show = false;
		},
		onItemEditSaved: async function(newItem, parent) {

			//...........  update item in map
			let item = this.itemsByIdMap[newItem.id];
			if (item) {
				if (!item.fields) {
					item.fields = {};
				}
				item.fields.StartDate = newItem.fields.StartDate;
				item.fields.EndDate = newItem.fields.EndDate;
				if (parent) {
					item.parents = [parent];
				}
				//update other events in differenct resources
				RawItemsViewUtils.modifyAllRelatedItems(this.$options.roadmap.eventStore,
					this.itemsByIdMap[item.id]);
			}else {
				let item = this.milestoneMapById[newItem.id];

				if (!item.fields) {
					item.fields = {};
				}
				item.fields.StartDate = newItem.fields.StartDate;
				item.fields.EndDate   = newItem.fields.StartDate;
				if (parent) {
					item.parents = [parent];
				}
			}

			 if ( this.itemEditPopup.groupChange){
				this.itemEditPopup.eventRecord.groupId = this.itemEditPopup.newResourceRecord.id
				let RTItemsOperationsDTO = {
					itemId: this.itemEditPopup.eventRecord.get('orgId'),
					operation: 'MOVE_FIELD',
					collectionId: this.store.releaseTrain.id,
					sourceFieldId: this.itemEditPopup.oldResourceRecord.id==='null'?'':this.itemEditPopup.oldResourceRecord.id,
					destinationFieldId: this.itemEditPopup.newResourceRecord.id==='null'?'':this.itemEditPopup.newResourceRecord.id,
					fieldName: 'sectionRelations'
				};
				fetch('/releasetrain/item/update-field',{
					method: 'PUT',
					headers: getFetchAPIHeadersForKendis(),
					body: JSON.stringify(RTItemsOperationsDTO)
				}).then(response => {
					console.log('Success:', response);

				}).catch(error => {
					console.error('Error:', error);
				})
			} else if(this.itemEditPopup.planningItemParams){
				 let task = this.itemEditPopup.planningItemParams.task;
				 let resource = this.itemEditPopup.planningItemParams.resource;
				 let isFilteredMode = this.itemEditPopup.planningItemParams.isFilteredMode;
				 let parentItemId = this.itemEditPopup.planningItemParams.parentItemId;
				 let startDate = newItem.fields.StartDate;
				 let endDate = newItem.fields.EndDate;

				 // Remove from unplanned grid
				 roadmapVue.removeItemFromUnplanned(task);
				 task.startDate = startDate;
				 let targetItem = roadmapVue.itemsByIdMap[task.originalData.id.split('_')[0]];
				 targetItem.fields.StartDate = startDate;
				 targetItem.fields.EndDate = endDate;
				 
				 // Handle filtered mode (unplanned children of specific parent)
				 if (isFilteredMode && parentItemId) {
					 console.log('Planning item in filtered mode for parent:', parentItemId);
					 
					 // Move item from unplanned cache to planned
					 const movedItem = roadmapVue.moveItemFromUnplannedToPlanned(targetItem.id, parentItemId);
					 
					 if (movedItem) {
						 // Add the item as a planned child event to the parent resource
						 // Get the parent item to find its group ID
						 const parentItem = roadmapVue.itemsByIdMap[parentItemId];
						 if (!parentItem) {
							 console.error('Parent item not found:', parentItemId);
							 showBryntumToastMessage('Parent item not found', 'error');
							 return;
						 }
						 
						 console.log('Parent item found:', parentItem);
						 console.log('Parent item artRelationMap:', parentItem.artRelationMap);
						 console.log('Release train ID:', roadmapVue.releaseTrain.id);
						 
						 // Try to find the group ID from the parent item
						 let parentGroupId = null;
						 
						 // Method 1: Try to get from artRelationMap
						 if (parentItem.artRelationMap && parentItem.artRelationMap[roadmapVue.releaseTrain.id]) {
							 parentGroupId = parentItem.artRelationMap[roadmapVue.releaseTrain.id].groupId;
						 }
						 
						 // Method 2: If not found, try to find the resource by searching through all resources
						 if (!parentGroupId) {
							 console.log('Group ID not found in artRelationMap, searching through resources...');
							 const scheduler = roadmapVue.$options.roadmap;
							 const allResources = scheduler.resourceStore.allRecords;
							 
							 for (let resource of allResources) {
								 if (resource.get('isItem') && resource.get('orgId') === parentItemId) {
									 // Found the parent resource, extract group ID from resource ID
									 const resourceIdParts = resource.id.split('_');
									 if (resourceIdParts.length >= 3) {
										 parentGroupId = resourceIdParts[0];
										 console.log('Found parent resource, group ID:', parentGroupId);
										 break;
									 }
								 }
							 }
						 }
						 
						 if (!parentGroupId) {
							 console.error('Parent group ID not found for item:', parentItemId);
							 console.log('Available resources:', roadmapVue.$options.roadmap.resourceStore.allRecords.map(r => ({ id: r.id, name: r.name, isItem: r.get('isItem'), orgId: r.get('orgId') })));
							 showBryntumToastMessage('Parent group ID not found', 'error');
							 return;
						 }
						 
						 const parentResourceId = `${parentGroupId}_item_${parentItemId}`;
						 console.log('Constructed parent resource ID:', parentResourceId);
						 roadmapVue.addChildItemToItemResource(targetItem, parentResourceId);
						 
						 // Update item dates
						 roadmapVue.updateItemDates(targetItem);
						 
						 // Note: The grid is already updated in moveItemFromUnplannedToPlanned
						 // No need to refresh the filtered grid again as the item is already removed
						 
						 // Show smart message for planning item as child
						 const parentGroupName = roadmapVue.getGroupDisplayName(parentGroupId, roadmapVue.groupBy.value);
						 roadmapVue.showSmartMessage(`"${targetItem.title}" planned as child of "${parentItem.title}" in ${parentGroupName}`, 'success');
					 } else {
						 showBryntumToastMessage("Failed to move item from unplanned to planned.", "error");
					 }
				 }
				 // Handle regular planning (existing logic)
				 else if (roadmapVue.groupBy.value === "-1") {
					 roadmapVue.saveItem(targetItem);
				 }
				 else if (roadmapVue.groupBy.value === "Section" && !_.isPlainObject(resource)) {
					 roadmapVue.addItemsInPlannedScheduler([_.cloneDeep(targetItem)], resource.id);
					 expandResource(roadmapVue.$options.roadmap,resource,roadmapVue.groupBy.value)
					 const RTItemsOperationsDTO = {
						 itemId: targetItem.id,
						 operation: 'MOVE_FIELD',
						 collectionId: roadmapVue.store.releaseTrain.id,
						 sourceFieldId: task.groupId?.[0] === "null" ? '' : task.groupId?.[0] || '',
						 destinationFieldId: resource.id === 'null' ? '' : resource.id,
						 fieldName: 'sectionRelations'
					 };

					 if (RTItemsOperationsDTO.sourceFieldId === RTItemsOperationsDTO.destinationFieldId) {
						 roadmapVue.updateItemDates(targetItem);
						 // Show smart message for planning item
						 const groupName = roadmapVue.getGroupDisplayName(resource.id, roadmapVue.groupBy.value);
						 roadmapVue.showSmartMessage(`"${targetItem.title}" planned successfully in ${groupName}`, 'success');
					 } else {
						 fetch('/releasetrain/item/update-field', {
							 method: 'PUT',
							 headers: getFetchAPIHeadersForKendis(),
							 body: JSON.stringify(RTItemsOperationsDTO)
						 }).then(response => {
							 console.log('Success:', response);
							 roadmapVue.updateItemDates(targetItem);
							 // Show smart message for moving item to section
							 const groupName = roadmapVue.getGroupDisplayName(resource.id, roadmapVue.groupBy.value);
							 roadmapVue.showSmartMessage(`"${targetItem.title}" moved to section ${groupName} successfully`, 'success');
						 }).catch(error => {
							 console.error('Error:', error);
						 });
					 }
				 }
				 else {
					 //get the relations for the planned group for this item
					 let groups= await roadmapVue.getGroupIdsForItemForTheGroup(targetItem.id,
								 true,false);
					//  this.scrollToResource(groupIds[0]);
					 for(let group of groups){
						//check if the group resource exists

                         let groupId  = group._id?.id?group._id.id:'null';
						let groupResource = roadmapVue.$options.roadmap.resourceStore.getById(groupId);
						if(!groupResource){
							this.drawResourceGroups(group,false)
							// groupResource = roadmapVue.$options.roadmap.resourceStore.getById(group.id);
						}


						 roadmapVue.addItemsInPlannedScheduler([_.cloneDeep(targetItem)], groupId);
						 // expandResource(roadmapVue.$options.roadmap,
							//  roadmapVue.$options.roadmap.resourceStore.getById(groupId),roadmapVue.groupBy.value)
					 }
					 // roadmapVue.addItemsInPlannedScheduler([_.cloneDeep(targetItem)], resource.id);
					 roadmapVue.updateItemDates(targetItem);
					 // Show smart message for planning item (general case)
					 roadmapVue.showSmartMessage(`"${targetItem.title}" planned successfully`, 'success');
				 }
			 }
			// else if (this.itemEditPopup.eventRecord) {
			// 	if (!this.itemEditPopup.eventRecord._fields) {
			// 		this.itemEditPopup.eventRecord._fields = {};
			// 	}
			// 	this.itemEditPopup.eventRecord._fields.StartDate = newItem.fields.StartDate;
			// 	this.itemEditPopup.eventRecord._fields.EndDate = newItem.fields.EndDate;
			// 	this.itemEditPopup.eventRecord.parents = [parent];
			// }
			this.onItemEditClose(false);
		},
		scrollToResource(resourceId){
			try {
				roadmapVue.$options.roadmap.scrollRowIntoView(resourceId)
			}catch (e) {
				console.log(e)
			}
		},
		async moveMilestoneToSection(newSectionId, eventRecord, milestoneId) {
			let _this = this;
			let scheduler = this.$options.roadmap;
			let currentResourceId = eventRecord.resource.id;
			let sourceFieldId = currentResourceId === "-1001" ? "" : currentResourceId;
			
			// Get the milestone object
			let milestone = _this.milestoneMapById[milestoneId];
			if (!milestone) {
				console.error('Milestone not found:', milestoneId);
				showBryntumToastMessage("Milestone not found", "error");
				return;
			}
			
			console.log(`Moving milestone ${milestoneId} from ${sourceFieldId} to ${newSectionId}`);
			
			// Update milestone section relations
			let RTItemsOperationsDTO = {
				itemId: milestoneId,
				operation: 'MOVE_FIELD',
				collectionId: _this.store.releaseTrain.id,
				sourceFieldId: sourceFieldId === 'null' ? '' : sourceFieldId,
				destinationFieldId: newSectionId === 'null' ? '' : newSectionId,
				fieldName: 'sectionRelations'
			};
			
			fetch('/releasetrain/item/update-field', {
				method: 'PUT',
				headers: getFetchAPIHeadersForKendis(),
				body: JSON.stringify(RTItemsOperationsDTO)
			}).then(async response => {
				console.log('Milestone section update success:', response);
				//response returnes the updated milestone
				let updatedMilestone = await response.json();
				
				_this.milestoneMapById[milestoneId] = updatedMilestone;

				//move this event to the destiantion section
				let targetResourceId = newSectionId === 'null' ? '-1001' : newSectionId;
				//modify assingment
				let assignment = scheduler.assignmentStore.getAssignmentsForEvent(eventRecord);
				await assignment[0].setAsync({ resourceId: targetResourceId });

				scheduler.refresh();
				
				// Show smart message for milestone movement
				const targetResource = scheduler.resourceStore.getById(targetResourceId);
				const targetGroupName = targetResource ? targetResource.name : 'Unknown Section';
				_this.showSmartMessage(`Milestone moved to ${targetGroupName} successfully`, 'success');
			}).catch(error => {
				console.error('Error moving milestone:', error);
				showBryntumToastMessage("Error moving milestone", "error");
			});
		},
		
		moveToSection(newSectionId,event){
			let _this = this;
			let scheduler = this.$options.roadmap;
			let itemId = event.get('orgId');
			let currentResourceId = event.resource.id;
			
			// Use ID utils to extract the source field ID (current section ID)
			let sourceFieldId = _this.$options.idUtils.extractSectionId(currentResourceId, {
				eventRecord: event,
				mode: _this.showIndividualItemResources ? 'individual' : 'traditional'
			});
			
			let RTItemsOperationsDTO = {
				itemId: itemId,
				operation: 'MOVE_FIELD',
				collectionId: _this.store.releaseTrain.id,
				sourceFieldId: sourceFieldId==='null'?'':sourceFieldId,
				destinationFieldId: newSectionId==='null'?'':newSectionId,
				fieldName: 'sectionRelations'
			};
			
			fetch('/releasetrain/item/update-field',{
				method: 'PUT',
				headers: getFetchAPIHeadersForKendis(),
				body: JSON.stringify(RTItemsOperationsDTO)
			}).then(response => {
				console.log('Success:', response);
				
				if (_this.showIndividualItemResources) {
					// In individual item resources mode, move the entire resource subtree
					let currentItemResourceId = `${sourceFieldId}_item_${itemId}`;
					
					try {
						// let targetSectionResource = scheduler.resourceStore.getById(newSectionId);
						// if (targetSectionResource && !targetSectionResource.isExpanded()) {
						// 	toggleResourceExpand(targetSectionResource,_this.groupBy.value,_this.$options.roadmap);
						// 	scheduler.toggleCollapse(targetSectionResource);
						// }
						// Use the moveResourceSubtree function to move the resource and all its descendants
						moveResourceSubtree(scheduler, currentItemResourceId, newSectionId);
						
						// Ensure the new parent section is expanded to show the moved resource
						// let targetSectionResource = scheduler.resourceStore.getById(newSectionId);
						// if (targetSectionResource && targetSectionResource.expand) {
						// 	targetSectionResource.expand();
						// }
						
						// // Scroll to the moved event
						// const movedEvent = scheduler.eventStore.getById(event.id);
						// if (movedEvent) {
						// 	_this.scrollToNewEvent(movedEvent, 'moved', movedEvent.name || 'Item');
						// } else {
						// 	showBryntumToastMessage(`Item moved to section successfully`, "success");
						// }
					} catch (error) {
						console.error('Error moving resource subtree:', error);
						showBryntumToastMessage(`Failed to move item: ${error.message}`, "error");
					}
				} else {
					// Old mode - handle the new structure where items are in items resources
					// 1. Remove the event from the current resource
				_this.removeEventFromScheduler(event);

					// 2. Add the item to the new section (this will create appropriate resource structure)
					_this.addItemsInPlannedScheduler([_.cloneDeep(_this.itemsByIdMap[itemId])], newSectionId);
					
					// Scroll to the moved event (the addItemsInPlannedScheduler method will handle scrolling)
					// showBryntumToastMessage is already handled in addItemsInPlannedScheduler
				}
			}).catch(error => {
				console.error('Error:', error);
				showBryntumToastMessage(`Failed to move item to section`, "error");
			})

		},


		removeItemFromUnplanned(task) {
			try {
				let store = roadmapVue.$options.unplannedGrid.store;

				// Assuming 'task.id' has the structure 'itemId_<parentId>'
				// Extract the base item ID from 'task.id' for global search
				let baseItemId = task.id.split('_')[0];

				// Iterate over all records in the store to find and remove the child from any parent
				store.forEach(parent => {
					// Find children that match the baseItemId structure
					if(parent.children && parent.children!== true) {
						let childrenToRemove = parent.children.filter(child => child.id.startsWith(baseItemId + '_'));

						// Remove each found child from the current parent
						childrenToRemove.forEach(child => {
							parent.removeChild(child);
						});
					}
				});

			} catch (e) {
				console.log('Error removing item from unplanned:', e);
			}
		},

		removeEventFromScheduler(event){
			let scheduler = this.$options.roadmap;
			const resource = scheduler.resourceStore.getById(event.resource.id);

			// Check if this is a planned child event being removed
			if (event.get('ttype') === 'child_item' && event.get('isPlanned')) {
				const eventId = event.id;
				const parts = eventId.split('_');
				if (parts.length >= 3) {
					const parentItemId = parts[1]; // parent item ID is the second part
					
					// Decrease planned children count
					if (this.plannedChildrenCountCache[parentItemId] && this.plannedChildrenCountCache[parentItemId] > 0) {
						this.plannedChildrenCountCache[parentItemId]--;
						console.log(`Decreased planned children count for parent ${parentItemId}, new count: ${this.plannedChildrenCountCache[parentItemId]}`);
					}
				}
			}

			const assignments = scheduler.assignmentStore.getAssignmentsForEvent(event);
			scheduler.assignmentStore.remove(assignments);
			scheduler.eventStore.remove(event);
			
			// Refresh scheduler to update the planned count display
			scheduler.refresh();
			
			//remove from groupItems
		},
		//......................................
		//..........   item popup
		onItemPopupClose: function(canceled) {
			if(!this.itemPopup.show ){
				return
			}
			if (!this.itemPopup.item.id && canceled && this.itemPopup.eventRecord) {
				this.$options.roadmap.eventStore.remove(this.itemPopup.eventRecord);
			}
			this.itemPopup.eventRecord = undefined;
			this.itemPopup.resourceRecord  = undefined;
			this.itemPopup.item = undefined;
			this.itemPopup.parent = undefined;
			this.itemPopup.alm = undefined;
			this.itemPopup.tfsProjects = undefined;
			this.itemPopup.data = undefined;
			this.itemPopup.show = false;
		},

		/**
		 * Determines the update strategy based on ALM type, roadmap settings, and item state
		 * @param {Object} newItem - The updated item data
		 * @param {Object} record - The event record
		 * @param {Object} oldItem - The original item data
		 * @returns {string} The update strategy to use
		 */
		determineUpdateStrategy: function(newItem, record, oldItem) {
			// Strategy constants
			const UPDATE_STRATEGIES = {
				FULL_UPDATE: 'FULL_UPDATE',
				ITERATION_PREFERRED_WITH_WARNING: 'ITERATION_PREFERRED_WITH_WARNING',
				REPLAN_WITH_MANUAL_DATES: 'REPLAN_WITH_MANUAL_DATES',
				MANUAL_DATES_UPDATE: 'MANUAL_DATES_UPDATE',
				MINIMAL_UPDATE: 'MINIMAL_UPDATE'
			};

			// Jira items always get full update
			if (this.almAccountType === 'jira') {
				return UPDATE_STRATEGIES.FULL_UPDATE;
			}

			// TFS items with no iteration path dates available
			if (this.roadmap.iterationPathDates === 1) {
				return UPDATE_STRATEGIES.FULL_UPDATE;
			}

			// TFS items with iteration path dates available
			if (this.roadmap.iterationPathDates === 0) {
				const isCurrentlyUsingIteration = record.get('dateSource') === 'iteration';
				const hasDateChanges = this.hasDateFieldChanges(oldItem, newItem);
				
				if (this.roadmap.datePreference === 1) {
					// Iteration dates are preferred
					return UPDATE_STRATEGIES.ITERATION_PREFERRED_WITH_WARNING;
				} else {
					// Start/end dates are preferred (datePreference === 0)
					if (isCurrentlyUsingIteration && hasDateChanges) {
						return UPDATE_STRATEGIES.REPLAN_WITH_MANUAL_DATES;
					} else {
						return UPDATE_STRATEGIES.MANUAL_DATES_UPDATE;
					}
				}
			}

			// Default fallback
			return UPDATE_STRATEGIES.FULL_UPDATE;
		},

		/**
		 * Checks if there are changes to date fields between old and new item
		 * @param {Object} oldItem - The original item
		 * @param {Object} newItem - The updated item
		 * @returns {boolean} True if date fields have changed
		 */
		hasDateFieldChanges: function(oldItem, newItem) {
			if (!oldItem || !newItem || !oldItem.fields || !newItem.fields) {
				return false;
			}

			const oldStartDate = oldItem.fields.StartDate;
			const oldEndDate = oldItem.fields.EndDate;
			const newStartDate = newItem.fields.StartDate;
			const newEndDate = newItem.fields.EndDate;

			// Check if start date changed
			if (oldStartDate !== newStartDate) {
				return true;
			}

			// Check if end date changed
			if (oldEndDate !== newEndDate) {
				return true;
			}

			return false;
		},

		/**
		 * Shows a warning popup when iteration path preference is selected
		 * @param {Object} item - The item being updated
		 */
		showIterationPathPreferenceWarning: function(item) {
			const message = `ADO Iteration path preference is selected. Item dates have been updated, but the Roadmap will continue to use ADO Iteration Path Dates.`;
			
			// Use the existing smart message system
			showTopMessage(message, 'warning', 10000);
		},

		onItemPopupUpdateItem: function(itemData) {
			let grid = this.$options.unplannedGrid;
			let unplannedGrid = this.$options.unplannedGrid;
			let newItem = itemData.item;
			let schedule = this.$options.roadmap;
			
			if (!this.itemPopup.eventRecord) {
				this.onItemPopupClose(false);
				return;
			}

			let record = this.itemPopup.eventRecord;
			let cachedItem = this.itemsByIdMap[newItem.id];
			
			// Always update item resource title regardless of strategy
			if (this.showIndividualItemResources && !record.get('isChild')) {
				const itemResource = schedule.resourceStore.getById(record.resource.id);
				if (itemResource) {
					itemResource.name = newItem.title;
				}
			}

			// Determine the update strategy
			const strategy = this.determineUpdateStrategy(newItem, record, cachedItem);
			
			// Execute the appropriate strategy
			this.executeUpdateStrategy(strategy, newItem, record, cachedItem, schedule, grid, unplannedGrid);
			
			this.onItemPopupClose(false);
		},

		/**
		 * Executes the appropriate update strategy
		 * @param {string} strategy - The update strategy to execute
		 * @param {Object} newItem - The updated item data
		 * @param {Object} record - The event record
		 * @param {Object} cachedItem - The original item data
		 * @param {Object} schedule - The roadmap scheduler
		 * @param {Object} grid - The unplanned grid
		 * @param {Object} unplannedGrid - The unplanned grid reference
		 */
		executeUpdateStrategy: function(strategy, newItem, record, cachedItem, schedule, grid, unplannedGrid) {
			const UPDATE_STRATEGIES = {
				FULL_UPDATE: 'FULL_UPDATE',
				ITERATION_PREFERRED_WITH_WARNING: 'ITERATION_PREFERRED_WITH_WARNING',
				REPLAN_WITH_MANUAL_DATES: 'REPLAN_WITH_MANUAL_DATES',
				MANUAL_DATES_UPDATE: 'MANUAL_DATES_UPDATE',
				MINIMAL_UPDATE: 'MINIMAL_UPDATE'
			};

			switch (strategy) {
				case UPDATE_STRATEGIES.FULL_UPDATE:
					this.executeFullUpdate(newItem, record, cachedItem, schedule, grid, unplannedGrid);
					break;
					
				case UPDATE_STRATEGIES.ITERATION_PREFERRED_WITH_WARNING:
					this.executeIterationPreferredWithWarning(newItem, record, cachedItem, schedule);
					break;
					
				case UPDATE_STRATEGIES.REPLAN_WITH_MANUAL_DATES:
					this.executeReplanWithManualDates(newItem, record, cachedItem, schedule, grid, unplannedGrid);
					break;
					
				case UPDATE_STRATEGIES.MANUAL_DATES_UPDATE:
					this.executeManualDatesUpdate(newItem, record, cachedItem, schedule, grid, unplannedGrid);
					break;
					
				case UPDATE_STRATEGIES.MINIMAL_UPDATE:
					this.executeMinimalUpdate(newItem, record, cachedItem, schedule);
					break;
					
				default:
					console.warn(`Unknown update strategy: ${strategy}`);
					this.executeFullUpdate(newItem, record, cachedItem, schedule, grid, unplannedGrid);
			}
		},

		/**
		 * Executes full update (Jira items, TFS without iteration)
		 */
		executeFullUpdate: function(newItem, record, cachedItem, schedule, grid, unplannedGrid) {
			// Update item in map
			this.setFilteredEventForRoadmap(newItem, record);
			let oldItemFields = _.cloneDeep(cachedItem.fields);

			// Set hours only
			if (newItem.fields && newItem.fields.StartDate) {
				let startDate = new Date(newItem.fields.StartDate);
				startDate.setHours(0, 0, 0, 0);
				newItem.fields.StartDate = startDate;
			}
			if (newItem.fields && newItem.fields.EndDate) {
				let endDate = new Date(newItem.fields.EndDate);
				endDate.setHours(23, 59, 59, 999);
				newItem.fields.EndDate = endDate;
			}

			this.copyBacklogItemAttribute(cachedItem, newItem);
			cachedItem._fields = cachedItem.fields;

			// Handle planning/unplanning logic
			this.handlePlanningLogic(newItem, record, cachedItem, oldItemFields, schedule, grid, unplannedGrid);
			
			// Update event record
			RawItemsViewUtils.modifyAllRelatedItems(this.$options.roadmap.eventStore, newItem, true);
			
			// Update the item in the itemsByIdMap
			if (this.itemsByIdMap[newItem.id]) {
				this.itemsByIdMap[newItem.id] = newItem;
			}
			
			// Refresh the unplanned grid
			this.refreshUnplannedGrid();
		},

		/**
		 * Executes iteration preferred with warning (TFS with iteration preference)
		 */
		executeIterationPreferredWithWarning: function(newItem, record, cachedItem, schedule) {
			// Update item dates in database but keep iteration planning
			this.setFilteredEventForRoadmap(newItem, record, true); // dontModifyEventDate = true
			
			// Update itemsByIdMap
			if (this.itemsByIdMap[newItem.id]) {
				this.itemsByIdMap[newItem.id] = newItem;
			}
			
			// Update event record (non-date fields)
			RawItemsViewUtils.modifyAllRelatedItems(this.$options.roadmap.eventStore, newItem, true);
			
			// Show warning popup
			this.showIterationPathPreferenceWarning(newItem);
		},

		/**
		 * Executes replan with manual dates (TFS switching from iteration to manual dates)
		 */
		executeReplanWithManualDates: function(newItem, record, cachedItem, schedule, grid, unplannedGrid) {
			// Update item in map
			this.setFilteredEventForRoadmap(newItem, record);
			let oldItemFields = _.cloneDeep(cachedItem.fields);

			// Set hours only
			if (newItem.fields && newItem.fields.StartDate) {
				let startDate = new Date(newItem.fields.StartDate);
				startDate.setHours(0, 0, 0, 0);
				newItem.fields.StartDate = startDate;
			}
			if (newItem.fields && newItem.fields.EndDate) {
				let endDate = new Date(newItem.fields.EndDate);
				endDate.setHours(23, 59, 59, 999);
				newItem.fields.EndDate = endDate;
			}

			this.copyBacklogItemAttribute(cachedItem, newItem);
			cachedItem._fields = cachedItem.fields;

			// Handle planning logic (this will replan with manual dates)
			this.handlePlanningLogic(newItem, record, cachedItem, oldItemFields, schedule, grid, unplannedGrid);
			
			// Update event record
			RawItemsViewUtils.modifyAllRelatedItems(this.$options.roadmap.eventStore, newItem, true);
			
			// Update the item in the itemsByIdMap
			if (this.itemsByIdMap[newItem.id]) {
				this.itemsByIdMap[newItem.id] = newItem;
			}
			
			// Refresh the unplanned grid
			this.refreshUnplannedGrid();
		},

		/**
		 * Executes manual dates update (TFS with manual dates preference)
		 */
		executeManualDatesUpdate: function(newItem, record, cachedItem, schedule, grid, unplannedGrid) {
			// Same as full update for manual dates
			this.executeFullUpdate(newItem, record, cachedItem, schedule, grid, unplannedGrid);
		},

		/**
		 * Executes minimal update (non-date field changes only)
		 */
		executeMinimalUpdate: function(newItem, record, cachedItem, schedule) {
			// Update only non-date fields
			this.setFilteredEventForRoadmap(newItem, record, true); // dontModifyEventDate = true
			
			// Update itemsByIdMap
			if (this.itemsByIdMap[newItem.id]) {
				this.itemsByIdMap[newItem.id] = newItem;
			}
			
			// Update event record (non-date fields)
			RawItemsViewUtils.modifyAllRelatedItems(this.$options.roadmap.eventStore, newItem, true);
		},

		/**
		 * Handles the planning/unplanning logic for items
		 */
		handlePlanningLogic: function(newItem, record, cachedItem, oldItemFields, schedule, grid, unplannedGrid) {
			// Check if old fields are defined and any new date field is undefined
			if ((oldItemFields && oldItemFields.StartDate !== undefined && oldItemFields.EndDate !== undefined)
				&& (newItem.fields.StartDate === undefined || newItem.fields.EndDate === undefined)){
					// Remove assignments associated with the event
					schedule.assignmentStore.remove(
						schedule.assignmentStore.getAssignmentsForEvent(record)
					);
					// Handle the unassigning of a planned event, assuming new dates might not be correctly set
					this.handleUnassignPlannedEvent([record], schedule, unplannedGrid, newItem.fields.StartDate, newItem.fields.EndDate);

			}else{
				let planningItem = false
				// Check if old fields are undefined  and any new date field is defined
				if (oldItemFields && (oldItemFields.StartDate === undefined || oldItemFields.EndDate === undefined)) {
					if (newItem.fields.StartDate !== undefined && newItem.fields.EndDate !== undefined) {
						planningItem = true
					}
				}
				if(planningItem){
					let targetResourceIds = record.get('groupId')
					for(let targetResourceId of targetResourceIds) {
						//if targetResourceId does not exist then create a resource
						this.addItemsInPlannedScheduler([_.cloneDeep(newItem)],targetResourceId);
					}
					//remove from unplanned item
					grid.store.remove(record.id)
				}
			}
		},
		createResourceFromGroup(group) {
			const groupData = this.setGroupItemProperties(group, this.groupBy.value);
			 roadmapVue.$options.roadmap.resourceStore.add( {
				...group,
				name: group._id.title,
				id: group._id.id,
				cls: ["kendis-ir-resource-group", "kendis-ir-undragable-group"],
				expanded: false
			});
			this.batchProcessResources([roadmapVue.$options.roadmap.resourceStore.getById(group.id)]) ;
		},

		/**
		 * Creates an unplanned group resource following the same pattern as onItemEditSaved
		 * @param {Object} group - The group data from getGroupIdsForItemForTheGroup
		 */
		createUnplannedGroupResource(group) {
			const groupId = group._id?.id ? group._id.id : 'null';
			const groupTitle = group._id?.title || (groupId === 'null' ? 'No Group' : groupId);
			
			// Create the unplanned group resource in the unplanned grid
			const unplannedGroupResource = {
				_id: groupId,
				title: groupTitle,
				name: groupTitle,
				id: groupId,
				cls: ["kendis-ir-resource-group", "kendis-ir-undragable-group"],
				expanded: false,
				isGroup: true,
				items: []
			};
			
			// Add to unplanned grid store
			this.$options.unplannedGrid.store.add(unplannedGroupResource);
			
			console.log(`Created unplanned group resource: ${groupId} - ${groupTitle}`);
		},
		createResourceFromId(id) {
			const groupObj = this.$options.unplannedItemsGroups.find(group => group._id.id === id);
			if (!groupObj) return;

			const groupData = this.setGroupItemProperties(groupObj, this.groupBy.value);

			roadmapVue.$options.roadmap.resourceStore.add( {
				...groupData,
				name: groupData._id.title,
				id: groupData._id.id,
				cls: ["kendis-ir-resource-group", "kendis-ir-undragable-group"],
				expanded: false
			});
			this.batchProcessResources([roadmapVue.$options.roadmap.resourceStore.getById(id)]) ;
		},
		async onShowUnplannedChildrenClick(itemResourceId, itemId) {
			const scheduler = this.$options.roadmap;
			const itemResource = scheduler.resourceStore.getById(itemResourceId);
			if (itemResource && !itemResource.childrenLoaded) {
				await this.loadItemChildren(itemResourceId);
			}
			this.showUnplannedChildren(itemId);
			
			// Add focus animation to the unplanned grid
			if (this.$options.unplannedGrid) {
				const gridElement = this.$options.unplannedGrid.element;
				if (gridElement) {
					// Add the animation class
					gridElement.classList.add('kendis-grid-focus-animation');
					
					// Remove the animation class after animation completes
					setTimeout(() => {
						gridElement.classList.remove('kendis-grid-focus-animation');
					}, 1500); // Match the animation duration
				}
			}
		},

		/**
		 * Handles click on planned items count: loads children if not loaded, then shows planned children in scheduler
		 * @param {string} itemResourceId - The resource ID of the item
		 * @param {string} itemId - The orgId of the item
		 */
		async onShowPlannedChildrenClick(itemResourceId, itemId) {
			const scheduler = this.$options.roadmap;
			const itemResource = scheduler.resourceStore.getById(itemResourceId);
			if (itemResource && !itemResource.childrenLoaded) {
				await this.loadItemChildren(itemResourceId);
			}
			this.showPlannedChildren(itemId);
		},
		onItemPopupDeleteItem: function(item) {

		},
		//...............................................
		//..........    drag create item
		onAddToBoardPopupClose: function (canceled) {
			if (canceled && this.addToBoardPopup.eventRecord) {
				this.$options.roadmap.eventStore.remove(this.addToBoardPopup.eventRecord);
			}
			this.addToBoardPopup.boardItems = undefined;
			this.addToBoardPopup.item = undefined;
			this.addToBoardPopup.eventRecord = undefined;
			this.addToBoardPopup.resourceRecord  = undefined;
			this.addToBoardPopup.show = false;
		},
		createFilterEventForRoadmap: function(initialItem) {
			// Create an empty item object
			let item = {
				orgId: initialItem.id,
				startDate: null,
				endDate: null,
				// percentDone: -1,
				statusColor: "#7c50b1",
				statusClass: "e",
				barColor: "#7c50b1",
				// custFields: {}
			};

			// Assign status and modify colors based on status
			if (initialItem.status) {
				item.status = this.store.getStatusMap[initialItem.status.id];
				if (item.status) {
					item.statusClass = item.status.category === "ToDo" ? "a" :
						item.status.category === "InProgress" ? "b" :
							item.status.category === "Done" ? "c" : "e";
					item.statusColor = item.status.category === "ToDo" ? "#E79362" :
						item.status.category === "InProgress" ? "#3792C9" :
							item.status.category === "Done" ? "#3FCA93" : "#7c50b1";
					item.barColor = item.statusColor;
					item.eventColor = item.statusColor
				}
			}



			// Check for specific field overrides from initial item
			if (initialItem.fields && initialItem.fields.Color) {
				item.barColor = initialItem.fields.Color;
				item.eventColor = item.barColor
			}

			// Set dates
			if (initialItem.fields && initialItem.fields.StartDate) {
				item.startDate = new Date(initialItem.fields.StartDate);
			}
			if (initialItem.fields && initialItem.fields.EndDate) {
				item.endDate = new Date(initialItem.fields.EndDate);
			}

			item.url = initialItem.url;
			item.title=initialItem.title

			// item.url = initialItem.fields

			// Calculate percentage if applicable
			// if (this.percentage.value != "") {
			// 	let rollup = this.rollupsByIdMap[initialItem.id];
			// 	if (rollup) {
			// 		this.calculateItemPercentage(rollup);
			// 		item.percentDone = rollup.percentDone;
			// 	}
			// }

			// Add custom fields from ALM mappings
			// if(initialItem.almFields && this.almFieldsMap) {
			// 	for(let key in initialItem.almFields) {
			// 		if(this.almFieldsMap[key] && this.almFieldsMap[key].name) {
			// 			item.custFields["Custom_" + this.almFieldsMap[key].name.replaceAll(/ /g, '')] = initialItem.almFields[key];
			// 		}
			// 	}
			// }

			return item;
		},
		setFilteredEventForRoadmap: function(item, event,dontModifyEventDate) {
			// Assign status and modify colors based on status
			event.title=item.title
			event.url = item.url;

			if (item.status) {
				event.status = this.store.getStatusMap[item.status.id];
				if (event.status) {
					event.statusClass = event.status.category === "ToDo" ? "a" :
						event.status.category === "InProgress" ? "b" :
							event.status.category === "Done" ? "c" : "e";
					event.statusColor = event.status.category === "ToDo" ? "#E79362" :
						event.status.category === "InProgress" ? "#3792C9" :
							event.status.category === "Done" ? "#3FCA93" : "#7c50b1";
					event.barColor = event.statusColor;
					event.eventColor =  event.statusColor ;
				}
			}

			// Check for specific field overrides from initial item
			if (item.fields && item.fields.Color) {
				event.barColor = item.fields.Color;
				event.style = event.barColor
			}
			if(!dontModifyEventDate) {
				// Set dates
				if (item.fields && item.fields.StartDate) {
					let startDate = new Date(item.fields.StartDate);
					startDate.setHours(0, 0, 0, 0);
					event.startDate = startDate
				}
				if (item.fields && item.fields.EndDate) {
					let endDate = new Date(item.fields.EndDate)
					endDate.setHours(23, 59, 59, 999);
					event.endDate = endDate
				}
			}
		},

		addItemsInPlannedScheduler: function(items, groupId) {

			let _this = this;

			// Start the batch update
			let plannedEvents = []
			let assignemnts =[]
			let scheduler = _this.$options.roadmap; // Assuming this is your scheduler instance
			
			items.forEach(item => {
				let itemId = groupId && groupId.length > 0 ? item.id + "_" + groupId : item.id;

				if (scheduler.eventStore.getById(itemId)) {
					console.log("Item already exists"+ itemId);
					return; // Skip to the next item
				}

				// Store item in the map for reference
				_this.itemsByIdMap[item.id] = item;

				// Get or create group resource
				let groupResource = scheduler.resourceStore.getById(groupId);
				if (!groupResource) {
					console.log("Group resource not found:", groupId);
					return;
				}

				let itemResourceId;
				
				// Use toggle flag to determine resource assignment
				if (_this.showIndividualItemResources) {
					// NEW MODE: Create item resource as child of group resource
					itemResourceId = `${groupId}_item_${item.id}`;
					let itemResource = scheduler.resourceStore.getById(itemResourceId);
					
					if (!itemResource) {
						itemResource = {
							id: itemResourceId,
							name: item.title,
							orgId: item.id,
							isItem: true,
							parentId: groupId,
							// children: true, // Enable expansion to load children
							expanded: false,
							childrenLoaded: false,
							color : groupResource.color?groupResource.color:defaultGroupColor,
							cls: ["kendis-ir-resource-group", "kendis-ir-child-resource"]
						};

						// Add item resource as child of group resource
						groupResource.appendChild(itemResource);
						itemResource = scheduler.resourceStore.getById(itemResourceId);
					}
				} else {
					// OLD MODE: Modified structure - milestones in group, items in single child resource
					if (this.groupBy.value === "Section") {
						// Only create child resources when grouped by Section (where milestones are available)
						if (item.fields?.itemType === "Milestone" || item.fields?.itemType === "Phase") {
							// Milestones and phases go directly to group resource
							itemResourceId = groupId;
						} else {
							// Regular items go to a single "Items" child resource
							itemResourceId = `${groupId}_items`;
							let itemsResource = scheduler.resourceStore.getById(itemResourceId);
							
							if (!itemsResource) {
								itemsResource = {
									id: itemResourceId,
									name: "Items",
									parentId: groupId,
									expanded: false,
									color: groupResource.color ? groupResource.color : defaultGroupColor,
									cls: ["kendis-ir-resource-group"]
								};

								// Add items resource as child of group resource
								groupResource.appendChild(itemsResource);
								itemsResource = scheduler.resourceStore.getById(itemResourceId);
							}
						}
					} else {
						// For non-Section group by values, all items go directly to group resource
						itemResourceId = groupId;
					}
				}



			// Create event for the item
				let event = _this.createFilterEventForRoadmap(item);
				event.id = itemId;
				// event.resourceId = itemResourceId; // Assign to item resource, not group
				
				// Set ttype based on item type
				if (item.fields?.itemType === "Milestone") {
					event.ttype = "milestone";
				} else if (item.fields?.itemType === "Phase") {
					event.ttype = "phase";
				} else {
				event.ttype = "item";
				}
				
				event.title = item.title;
				event.cls = [styledClasses.rawViewPlannedItems];

				// Mark as parent item when in individual item resources mode
				if (_this.showIndividualItemResources) {
					event.isParent = true;
					event.cls = [styledClasses.rawViewPlannedItems,('kendis-parent-item')]
				}
				event.groupId = groupId || "all_items";
				// Set event dates based on TFS configuration and available data
				const eventDates = this.calculateEventDates(item);
				if (eventDates) {
					event.startDate = eventDates.startDate;
					event.endDate = eventDates.endDate;
					event.dateSource = eventDates.dateSource; // Track whether dates come from iteration or field
				}


				plannedEvents.push(event)
				assignemnts.push({
					id:"assign_"+event.id,
					eventId: event.id,
					resourceId :itemResourceId
				})
			});

			if (!scheduler.resourceStore.getById(groupId)) {
				this.createResourceFromId(groupId);
				// this.sortResources();
			}

			scheduler.eventStore.add(plannedEvents);
			scheduler.assignmentStore.add(assignemnts);
			
			// Scroll to the first newly planned event
			// if (plannedEvents.length > 0) {
			// 	const firstEvent = scheduler.eventStore.getById(plannedEvents[0].id);
			// 	if (firstEvent) {
			// 		this.scrollToNewEvent(firstEvent, 'planned', firstEvent.name || 'Item');
			// 	}
			// }
		},

		sortResources() {
			let _this = this;
			_this.$options.roadmap.resourceStore.sort(compareResourcesByName);
		},


		addItemInPlannedScheduler: function(item,groupId) {
			let _this = this;
			let itemId;
			if(groupId && groupId.length>0){
				itemId=item.id+"_"+groupId;
			}else{
				itemId=item.id;
			}
			if (_this.$options.roadmap.eventStore.getById(itemId)) {
				console.log("item already exist in roadmap");
				return
			}

			//remove from unplanned grid
			let gridData= _this.$options.unplannedGrid.store.data;
			gridData = gridData.filter(task => task.orgId !== item.id);
			_this.$options.unplannedGrid.store.data=gridData;
			//----

			let resource = "";
			if(groupId){
				resource = this.$options.roadmap.resourceStore.getById(groupId);
			}

			let event = _this.createFilterEventForRoadmap(item);
			if(groupId && groupId != ""   && _this.groupBy.value=="Batches"){ //in case of groupby applied

				if(groupId != "null"){
					event.resourceId = groupId;
					event.batchRelationId=groupId;
					event.batchRelationName = (_this.$root.$options.meta.batches && _this.$root.$options.meta.batches[groupId])? (_this.$root.$options.meta.batches[groupId].key+" : "+_this.$root.$options.meta.batches[groupId].title):"..."
					event.sequence 		    = (_this.$root.$options.meta.batches && _this.$root.$options.meta.batches[groupId])? (_this.$root.$options.meta.batches[groupId].sequence) : '';

				}else{
					event.resourceId 		= groupId;
					event.batchRelationId 	= '-1', // Default group
					event.batchRelationName = 'No Group' // Optional
					event.sequence 		    = '';
				}

			}else if (groupId && groupId != "" && _this.groupBy.value=="timeCapsuleRelation"){
				event.resourceId = groupId;

			}
			else{
				event.resourceId = "all_items";
			}
			event.id =itemId;
			event.ttype = "item";
			event.title = item.title;
			
			// Mark as parent item when in individual item resources mode
			if (_this.showIndividualItemResources) {
				event.isParent = true;
				event.cls = 'kendis-parent-item';
			}
			
			if(item.fields.StartDate && item.fields.EndDate) {
				event.startDate = new Date(item.fields.StartDate);
				event.endDate = new Date(item.fields.EndDate);
			}else{
				let timeCapsule = _this.getTimeCapsule(item.timeCapsuleRelation.customId);
				event.startDate = new Date(timeCapsule.startDate);
				event.endDate = new Date(timeCapsule.endDate);
			}
			if(_this.displayMode.value==DisplayModes.RAW_ITEMS ){
				event.cls = styledClasses.rawViewPlannedItems;
			}
			//chech for duplicate
			_this.$options.roadmap.eventStore.add(event);
			
			// Show smart message for item addition
			const groupName = _this.getGroupDisplayName(groupId, _this.groupBy.value);
			_this.showSmartMessage(`"${item.title}" added to Planned Items in ${groupName}`, 'success');
			
			// _this.onZoomChangeLevel('f');

		},
		addItemsInUnplannedGrid: async function(items, groupId,firstLoad) {
			let _this = this;
			
			// If in grid child mode (filtered mode), don't add parent items to the grid
			if (_this.isGridChildMode) {
				console.log('Skipping adding items to unplanned grid - in filtered mode');
				return;
			}
			
			let groupItemMap = new Map();

			// Prepare an array to hold new events
			let newEvents = [];

			// Process each item in the provided items list
			items.forEach(item => {
				// Check for duplicate in the unplanned grid store
				let unplannedItem = _this.$options.unplannedGrid.store.findRecord("id", item.id);

				if (unplannedItem) {
					// Update existing item with new groupId
					let existingGroups = unplannedItem.get('groupId') || [];
					if (!existingGroups.includes(groupId)) {
						existingGroups.push(groupId);
					}
					unplannedItem.set('groupId', existingGroups);  // Update the groupId
					return; // Skip to next item
				}

				// Remove from the roadmap if it exists there
				if (_this.$options.roadmap.eventStore.getById(item.id)) {
					_this.$options.roadmap.eventStore.remove(item);
				}

				// Prepare a copy of the item for the unplanned grid
				let copy = {
					almAccountId: item.almAccountId,
					almErrors: item.almErrors,
					almItemId: item.almItemId,
					almKey: item.almKey,
					almType: item.almType,
					almFields: item.almFields,
					artRelationMap: item.artRelationMap,
					batchRelations: item.batchRelations,
					boardRelations: item.boardRelations,
					childBoards: item.childBoards,
					childRelationMap: item.childRelationMap,
					childSolutionBoards: item.childSolutionBoards,
					childStoryPoints: item.childStoryPoints,
					createdBy: item.createdBy,
					createdOn: item.createdOn,
					dirty: item.dirty,
					fetchedBy: item.fetchedBy,
					fields: item.fields,
					filterIds: item.filterIds,
					objectiveRelations: item.objectiveRelations,
					parentRelationMap: item.parentRelationMap,
					relations: item.relations,
					solutionRelations: item.solutionRelations,
					status: item.status,
					title: item.title,
					updatedBy: item.updatedBy,
					updatedOn: item.updatedOn,
					url: item.url,
				};

				// Create a new event for the roadmap
				let event = _this.createFilterEventForRoadmap(copy);
				event.duration = _this.defaultDuration;
				event.durationUnit = _this.defaultDurationUnit;
				// event.resourceId = "all_items";
				event.ttype = "item";
				event.startDate = ''; // Set to actual start date if needed
				event.endDate = '';   // Set to actual end date if needed
				event.id = item.id+'_'+groupId; // Use item.id as the unique identifier
				event.groupId = [groupId];
				event.searchableKey = generateKey(item)


				// Set the CSS class based on display mode
				if (_this.displayMode.value === DisplayModes.RAW_ITEMS) {
					event.cls = styledClasses.rawViewUnplannedItems;
				}

				// Add the new event to the array
				newEvents.push(event);
				if(groupItemMap.has(groupId)) {
					groupItemMap.get(groupId).push(event)
				}else{
					groupItemMap.set(groupId,[event])
				}
			});
			// Assuming groupItemMap is an iterable (like Map)
			for (const [groupId, items] of groupItemMap) {
				// Add item to group children
				let groupItem = _this.$options.unplannedGrid.store.getById(groupId);

				if (groupItem) {
					if (!firstLoad && groupItem.children === true) {
						// If groupItem.children is a placeholder (true) then get the actual group IDs first.
						let groupIds = await roadmapVue.getGroupIdsForItemForTheGroup(items[0].id.split('_')[0], false, true);

						// Loop through each groupId and load unplanned items
						for (let groupId2 of groupIds) {
							// this.loadUnplannedOnClick(groupId2);
							let groupItem2 = _this.$options.unplannedGrid.store.getById(groupId2);
							groupItem2.count  = groupItem2.count + items.length;
						}
					} else {
						groupItem.insertChild(items);
					}
					// _this.$options.unplannedGrid.refreshRows()
				} else {
					// Create a new group item if it doesn't already exist
					let newGroupItem = {
						id: groupId ? groupId : "null",
						title: this.generateGroupName(groupId),
						count: 0,
						expanded: false,
						children: true,
						isGroup: true,
					};

					_this.$options.unplannedGrid.store.add(newGroupItem);
					let parent = _this.$options.unplannedGrid.store.getById(groupId);
					parent.appendChild(items);
					_this.$options.unplannedGrid.store.sort(compareResourcesByName);
				}
			}
			
			// Show smart message for items addition to unplanned (only for new items, not firstLoad)
			if (!firstLoad && newEvents.length > 0) {
				const groupName = _this.getGroupDisplayName(groupId, _this.groupByUnplanned.value);
				if (newEvents.length === 1) {
					_this.showSmartMessage(`"${newEvents[0].title}" added to Unplanned Items in ${groupName}`, 'info');
				} else {
					_this.showSmartMessage(`${newEvents.length} items added to Unplanned Items in ${groupName}`, 'info');
				}
			}

		},
		addItemInUnplannedGrid: function(item,groupId) {
			let _this = this;
			
			// If in grid child mode (filtered mode), don't add parent items to the grid
			if (_this.isGridChildMode) {
				console.log('Skipping adding item to unplanned grid - in filtered mode');
				return;
			}
			
			let groups  = []
			//check fore duplicate
			let unplannedItem =  _this.$options.unplannedGrid.store.findRecord("id",item.id);
			if(unplannedItem){
				let groups = unplannedItem.groupId;
				if(groups.length>0) {
					groups.push(groupId)
				}else{
					groups = [groupId]
				}
				unplannedItem.set('groupId', groups);  // Updates the "status" field to "In Progress"
				return;
			}
			if(_this.$options.roadmap.eventStore.getById(item.id)){
				_this.$options.roadmap.eventStore.remove(item);
			}

			let gridData=_this.$options.unplannedGrid.store.data
			let compositeKey = item.id;
			let copy = {};
			//.....................
			copy.almAccountId = item.almAccountId;
			copy.almErrors = item.almErrors;
			copy.almItemId = item.almItemId;
			copy.almKey = item.almKey;
			copy.almType = item.almType;
			copy.almFields = item.almFields
			copy.artRelationMap = item.artRelationMap;
			copy.batchRelations = item.batchRelations;
			copy.boardRelations = item.boardRelations;
			copy.childBoards = item.childBoards;
			copy.childRelationMap = item.childRelationMap;
			copy.childSolutionBoards = item.childSolutionBoards;
			copy.childStoryPoints = item.childStoryPoints;

			//copy.childrenStatuses = item.childrenStatuses;

			copy.createdBy = item.createdBy;
			copy.createdOn = item.createdOn;
			copy.dirty = item.dirty;
			copy.fetchedBy = item.fetchedBy;
			copy.fields = item.fields;
			copy.filterIds = item.filterIds;
			copy.objectiveRelations = item.objectiveRelations;
			copy.parentRelationMap = item.parentRelationMap;
			copy.relations = item.relations;
			copy.solutionRelations = item.solutionRelations;
			copy.status = item.status;
			copy.title = item.title;
			//copy.name = item.title;

			copy.updatedBy = item.updatedBy;
			copy.updatedOn = item.updatedOn;
			copy.url = item.url;

			//.....................
			let event = _this.createFilterEventForRoadmap(copy);

			event.duration = _this.defaultDuration;
			event.durationUnit = _this.defaultDurationUnit;
			event.resourceId = "all_items";
			event.ttype = "item";
			event.startDate = '';
			event.endDate = '';
			event.id = compositeKey;
			event.groupId = [groupId];
			if(_this.displayMode.value==DisplayModes.RAW_ITEMS ){
				event.cls = styledClasses.rawViewUnplannedItems;
			}
			gridData.push(event);
			//add list of group ids for multi groupsm

			_this.$options.unplannedGrid.store.data	 = gridData;
			
			// Show smart message for item addition to unplanned
			const groupName = _this.getGroupDisplayName(groupId, _this.groupByUnplanned.value);
			_this.showSmartMessage(`"${item.title}" added to Unplanned Items in ${groupName}`, 'info');
		},
		addItemOnRoadmap: function(item, groupId) {
			let _this = this;
			const addPlannedItem = () => {
				_this.addItemsInPlannedScheduler([item], groupId);
				// console.log("planned event added item id: " + item.id);
			};
			const addUnplannedItem = () => {
				// If in grid child mode (filtered mode), don't add parent items to the grid
				if (_this.isGridChildMode) {
					console.log('Skipping adding unplanned item to grid - in filtered mode');
					return;
				}
				_this.addItemsInUnplannedGrid([item], groupId);
				// console.log("event added to unplanned grid item id: " + item.id);
			};

			if (item?.fields?.StartDate && item?.fields?.EndDate) {
				addPlannedItem();
			}
			// else if (item?.timeCapsuleRelation?.customId) {
			// 	addPlannedItem();
			// }
			else {
				addUnplannedItem();
			}
		},
		addMultipleItemsOnRoadMap(items,groupdId){
			// If in grid child mode (filtered mode), don't add parent items to the grid
			if (this.isGridChildMode) {
				console.log('Skipping adding multiple items to unplanned grid - in filtered mode');
				return;
			}
			
			let unPlannedItems = [];
			let plannedItems = [];
			for(let item of items){
				if(this.almAccountType ==='tfs' &&
					this.roadmap.iterationPathDates===0  && [0,1].includes(this.roadmap.datePreference)) {
					if(item && item.fields.tfsIterationPath
						&& this.store.tfsIterationMap[item.fields.tfsIterationPath]
						&& this.store.tfsIterationMap[item.fields.tfsIterationPath].attributes
						&& this.store.tfsIterationMap[item.fields.tfsIterationPath].attributes.finishDate
						&& this.store.tfsIterationMap[item.fields.tfsIterationPath].attributes.startDate){
						plannedItems.push(item);
					}
					else if(item && item.fields && item.fields.StartDate && item.fields.EndDate) {
						plannedItems.push(item);
					}
					else{
						unPlannedItems.push(item);
					}
				}else{
					if(item && item.fields && item.fields.StartDate && item.fields.EndDate) {
						plannedItems.push(item);
					}
					else if (item.timeCapsuleRelation && item.timeCapsuleRelation.customId) {
						plannedItems.push(item);
					}
					else{
						unPlannedItems.push(item);
					}
				}


			}
			if(unPlannedItems.length > 0){
				this.addItemsInUnplannedGrid(unPlannedItems,groupdId,true);
				// console.log(`---------------------------------`)
				// console.log(`( ${unPlannedItems.length} ) UNPLANNED items added to roadmap`);
				// console.log(`---------------------------------`)
				this.unplannedFetched = true;
			}
			if(plannedItems.length > 0){
				this.addItemsInPlannedScheduler(plannedItems,groupdId);
				// console.log(`---------------------------------`)
				// console.log(`( ${plannedItems.length} ) PLANNED items added to roadmap`);
				// console.log(`---------------------------------`)
			}
		},
		onAddToBoardPopupCreate: function (response,createAnother) {
			//check if item hase start and end dates then add in even store,
			//else add in unplanned grid
			let _this = this;
			let groupId="null"
			try {
				if (response
					&& response.item){
					let item = response.item;
					let childish = _this.setItemForMap(_.cloneDeep(item));
					_this.itemsByIdMap[item.id] = childish

					// Check if this is a child item being created for an item resource
					if (_this.itemPopup.resourceId) {
						console.log('Creating child item for item resource:', _this.itemPopup.resourceId);
						
						// Add the child item directly to the item resource
						_this.addChildItemToItemResource(childish, _this.itemPopup.resourceId);
						
						console.log('Child item created successfully:', childish.title);
						_this.showSmartMessage(`Child "${childish.title}" added to item resource`, 'success');
						
						// Clear the resourceId after use
						_this.itemPopup.resourceId = null;
						
						return; // Skip normal item processing
					}
					
					// Handle section assignment from "Add New Item" button
					if (_this.addToBoardPopup.sectionId) {
						groupId = _this.addToBoardPopup.sectionId;
						console.log('Creating item for section:', groupId);
						
						// Make the section relation update call
						const RTItemsOperationsDTO = {
							collectionId: _this.releaseTrain.id,
							itemId: item.id,
							operation: "MOVE_FIELD",
							sourceFieldId: '',
							destinationFieldId: groupId === 'null' ? '' : groupId,
							fieldName: 'sectionRelations'
						};
						
						fetch('/releasetrain/item/update-field', {
							method: 'PUT',
							headers: getFetchAPIHeadersForKendis(),
							body: JSON.stringify(RTItemsOperationsDTO)
						}).then(response => {
							if (response.ok) {
								console.log('Section relation updated successfully for item:', item.id);
							} else {
								console.error('Failed to update section relation for item:', item.id);
							}
						}).catch(error => {
							console.error('Error updating section relation:', error);
						});
						
						// Clear the stored sectionId after use
						// _this.addToBoardPopup.sectionId = null;
					}
					// Original logic for regular items
					else if(_this.groupBy.value==="Section" && _this.itemPopup.resourceRecord){
						groupId = _this.itemPopup.resourceRecord.id;
						//link to section
						let RTItemsOperationsDTO = {
							itemId: item.id,
							operation: 'MOVE_FIELD',
							collectionId: this.store.releaseTrain.id,
							sourceFieldId: '',
							destinationFieldId: groupId==="null"? '':groupId,
							fieldName: 'sectionRelations'
						};
						fetch('/releasetrain/item/update-field',{
							method: 'PUT',
							headers: getFetchAPIHeadersForKendis(),
							body: JSON.stringify(RTItemsOperationsDTO)
						}).then(response => {
							console.log('Success:', response);
						}).catch(error => {
							console.error('Error:', error);
						})
					}
					else if(_this.groupBy.value==="kendisStatus"){
						//find the groupid that is actually the status title
						const statusTitle = this.store.getStatusMap[item.status.id]?.title;
						if(statusTitle){
							groupId = statusTitle;
						}
						
					}
					else{
						groupId = "null"
					}
					// _this.itemsByIdMap[item.id] = _this.setItemForMap(_.cloneDeep(item))
					_this.addItemOnRoadmap(item,groupId,true);
				}
			}catch (e) {
				console.log(e);
			}finally {
				_this.$options.roadmap.refresh();
				_this.onAddToBoardPopupClose(false);
				if(!createAnother) {
					_this.onItemPopupClose(false);
				}
			}
		},

		onAddToBoardPopupCreateNew: function(item,objectId) {
			let _item = { fields: {}, title: item.title };
			let parent = undefined;
			if(objectId == undefined){
				objectId = item.objectId;
			}
			_item.fields.StartDate = item.startDate;
			_item.fields.EndDate  = item.endDate;
			this.itemPopup.eventRecord = this.addToBoardPopup.eventRecord;
			this.itemPopup.resourceRecord = this.addToBoardPopup.resourceRecord;
			this.itemPopup.item = _item;
			this.itemPopup.parent = parent;
			let currentLevel ;
			currentLevel = this.currentHierarchyLevel;
			this.itemPopup.level = currentLevel;
			if (!_.isEmpty(this.store.almAccounts)) {
				this.itemPopup.alm = this.store.almAccounts[0];
			}
			if (this.almAccountType == "tfs") {
				this.itemPopup.tfsProjects = this.store.tfsProjects;
			}
			this.itemPopup.show = true;
			this.onAddToBoardPopupClose(false);
		},
		onAddToBoardPopupAddFromAlm: function (item) {

			let _item = { fields: {}};
			let parent = undefined;

			_item.fields.StartDate = item.startDate;
			_item.fields.EndDate  = item.endDate;
			// if (this.groupBy.value == "Parent") {
			// 	if (this.addToBoardPopup.resourceRecord.id != "null") {
			// 		parent = { id: this.addToBoardPopup.resourceRecord.id };
			// 	}
			// }
			this.addFromAlmPopup.eventRecord = this.addToBoardPopup.eventRecord;
			this.addFromAlmPopup.resourceRecord = this.addToBoardPopup.resourceRecord;
			//...............
			this.addFromAlmPopup.item = _item;
			this.addFromAlmPopup.level = this.currentHierarchyLevel;

			this.addFromAlmPopup.parent = parent;
			this.addFromAlmPopup.backlogLevel = parseInt(this.roadmap.level);
			if (!_.isEmpty(this.store.almAccounts)) {
				this.addFromAlmPopup.alm = this.store.almAccounts[0];
			}
			if (this.almAccountType == "tfs") {
				this.addFromAlmPopup.tfsProjects = this.store.tfsProjects;
			}
			this.addFromAlmPopup.show = true;

			this.onAddToBoardPopupClose(false);
		},
		onAddToBoardPopupItemSelected: function (itemData) {
			let _this = this;
			this.loadItemsRollups([itemData.item.id],(data)=>{
				if (data.items) {
					let item = data.items[0];
					
					// Check if this is a child item being added to an item resource
					if (_this.addFromAlmPopup.resourceId) {
						console.log('Adding existing child item to item resource:', {
							item: item.title,
							resourceId: _this.addFromAlmPopup.resourceId
						});
						let childish = _this.setItemForMap(_.cloneDeep(item));
						_this.itemsByIdMap[item.id] = childish
						
						// Add the existing child item directly to the item resource
						_this.addChildItemToItemResource(childish, _this.addFromAlmPopup.resourceId);
						
						console.log('Existing child item added successfully:', childish.title);
						_this.showSmartMessage(`Existing child "${childish.title}" added to item resource`, 'success');
						
						// Clear the resourceId after use
						_this.addFromAlmPopup.resourceId = null;
						
						return; // Skip normal item processing
					}
					
					// Original logic for regular items
					// _this.addNewItemToRoadmap(item, _this.addToBoardPopup.resourceRecord);
					// if (_this.addToBoardPopup.resourceRecord && _this.addToBoardPopup.eventRecord) {
					// 	_this.$options.roadmap.eventStore.remove(_this.addToBoardPopup.eventRecord);
					// }
					if( item
					&& item.fields
					&& item.fields.StartDate
					&& item.fields.EndDate) {
						_this.addItemsInPlannedScheduler([item],"null");
						_this.showSmartMessage(`"${item.title}" added to Roadmap Planned Items`, "success");
					}else{
						_this.addItemsInUnplannedGrid([item],"null");
						_this.showSmartMessage(`"${item.title}" added to Roadmap Unplanned Items`, "success");
					}

					//set status
					_this.itemsByIdMap[item.id] = _this.setItemForMap(item);
				}
				_this.onAddToBoardPopupClose(false);
			});
		},
		//.........   add from alm
		onAddFromAlmClose: function () {
			if (this.addFromAlmPopup.resourceRecord && this.addFromAlmPopup.eventRecord) {
				this.$options.roadmap.eventStore.remove(this.addFromAlmPopup.eventRecord);
			}
			this.addFromAlmPopup.item = undefined;
			this.addFromAlmPopup.parent = undefined;
			this.addFromAlmPopup.alm = undefined;
			this.addFromAlmPopup.eventRecord = undefined;
			this.addFromAlmPopup.resourceRecord = undefined;
			this.addFromAlmPopup.show = false;
		},
		onAddFromAlmAdded: function (itemsData) {

			let _this = this;
			let items = itemsData.items;
			let itemIds = _.map(items,item=>item.id);
			this.loadItemsRollups(itemIds,(data)=>{
				if (data.items) {
					_.each(data.items, item=> {
						_this.addNewItemToRoadmap(item, _this.addFromAlmPopup.resourceRecord);
					});
					if (_this.addFromAlmPopup.resourceRecord && _this.addFromAlmPopup.eventRecord) {
						_this.$options.roadmap.eventStore.remove(_this.addFromAlmPopup.eventRecord);
						_this.addFromAlmPopup.eventRecord = undefined;
						_this.addFromAlmPopup.resourceRecord = undefined;
					}
				}
				_this.onAddFromAlmClose(false);
			});
		},
		onAddExistingJiraItems: function (itemsData) {
			let response = {
				"item":{},
			};
			for(let i=0;i<itemsData.length;i++){
				let childish = this.setItemForMap(itemsData[i]);
				this.itemsByIdMap[itemsData[i].id] = childish
				response.item = childish
				this.onAddToBoardPopupCreate(response);
			}
		},
		////////////////////////////////////////////////////////////////
		/////////          ON RECEIVE PUSH
		findItemWithHeirarchy: function (itemToFind) {

			let result = {};
			if (this.groupBy.applied) {
				_.find(this.backlogItems, group=> {
					findInArray(itemToFind, group.items, result);
					if (result.item) {
						return true;
					}else {
						return false;
					}
				});

			}else {
				let itemsArray = this.backlogItems;
				findInArray(itemToFind , itemsArray, result);
			}

			function findInArray(item, array, res) {
				let loopBreakCheck = 1;
				_.find(array, it => {
					res[it.backlogLevel] = it;
					if (item.id == it.id) {
						res.item = it;
						loopBreakCheck = 0;
					}
					if (loopBreakCheck == 0) {
						return true;
					} else {
						if (it.baseItemList) {
							findInArray(item, it.baseItemList, res);
						}
						return false;
					}
				});
			}
			return result;
		},
		//....   item
		onPushItemUpdate: function (info) {

		},
		onPushItemAdd: function (info) {

		},
		//....   tfs item
		onPushTfsItemUpdate: function (info) {

		},
		onPushTfsItemCreate: function (info) {

		},
		onPushTfsItemSaveError: function (info) {

		},
		//....    web hook
		onPushWebhookItemUpdate: function (info) {

		},
		onSettingsUpdated: function () {
			this.settings.show = false;
		},
		onSettingsClose: function () {
			this.settings.show = false;
		},
		onSaveEditedTimeCapsules: function (timeCapsules) {
			this.settings.show = false;
			this.store.setTimeCapsules(timeCapsules);
		},
		onRemoveTimeCapsule: function (timeCapsule) {
			this.store.removeTimeCapsule(timeCapsule);
		},
		async loadItemChildren(itemResourceId) {
			let _this = this;
			let scheduler = _this.$options.roadmap;
			
			// Check session validity before making API call
			const sessionValid = await _this.validateSession('roadmap-item-children');
			if (!sessionValid) {
				return; // Session expired, user will be redirected
			}
			
			// Get the item resource
			const itemResource = scheduler.resourceStore.getById(itemResourceId);
			if (!itemResource) {
				console.error('Item resource not found:', itemResourceId);
				return;
			}
			
			// Check if children are already loaded
			if (itemResource.childrenLoaded) {
				console.log('Children already loaded for:', itemResourceId);
				return;
			}
			
			// Get the original item ID
			let itemId = itemResourceId.split("_")[2];
			
			let data = {};
			data.backlogItemId = itemId;
			data.releaseTrainId = _this.store.releaseTrainId;
			data.rollupTeams = true;
			data.rollupSprints = true;
			data.rollupBatches = true;
			data.rollupStoryPointsArray = true;
			data.rollupDates = true;
			data.rollupToGroups = true;

			try {
				itemResource.loading = true;
				const response = await axios.post('/releasetrain/backlog/backlogItemChildren', data);
				
				if (response.data && response.data.children) {
					let children = response.data.children;
					let childPlannedEvents = [];
					let childAssignments = [];
					
					// Get the item resource ID
					let itemResourceId = itemResource.id;
					
					// Categorize children
					let plannedChildren = [];
					let unplannedChildren = [];
					
					// First pass: categorize children
					children.forEach(childItem => {
						// Cache all children in itemsByIdMap with proper status mapping
						childItem = _this.setItemForMap(_.cloneDeep(childItem));
						_this.itemsByIdMap[childItem.id] = childItem
						
						// Determine if child should be planned based on TFS settings
						let isPlanned = false;
						const eventDates = _this.calculateEventDates(childItem);
						if (eventDates) {
							isPlanned = true;
							console.log(`Child item "${childItem.title}" will be planned with dates from ${eventDates.dateSource}`);
						} else {
							// Fallback: check for time capsule relation (non-TFS planning)
							if (childItem.timeCapsuleRelation && childItem.timeCapsuleRelation.customId) {
								isPlanned = true;
								console.log(`Child item "${childItem.title}" will be planned via time capsule relation`);
							} else {
								console.log(`Child item "${childItem.title}" has no valid dates or time capsule, will be unplanned`);
							}
						}
						
						if (isPlanned) {
							plannedChildren.push(childItem);
						} else {
							unplannedChildren.push(childItem);
						}
					});
					
					// Cache unplanned children for later use
					_this.unplannedChildrenCache[itemId] = unplannedChildren;
					_this.unplannedChildrenCountCache[itemId] = unplannedChildren.length;
					
					// Cache planned children count for later use
					_this.plannedChildrenCountCache[itemId] = plannedChildren.length;
					
					// Create events for planned children directly in item resource
					plannedChildren.forEach(childItem => {
						let childEvent = _this.createFilterEventForRoadmap(childItem);
						// New format: <child_id>_<parent_item_id>_<group_id>
						childEvent.id = `${childItem.id}_${itemId}_${itemResource.parentId || "all_items"}`;
						childEvent.ttype = "child_item";
						childEvent.title = childItem.title;
						childEvent.groupId = itemResource.parentId || "all_items";
						childEvent.orgId = childItem.id;
						childEvent.isChild = true;
						childEvent.isPlanned = true;
						childEvent.cls = ["kendis-roadmap-planned-event-dm-items","kendis-dashed-items"];
						
						// Set event dates and dateSource using centralized calculation
						const eventDates = _this.calculateEventDates(childItem);
						if (eventDates) {
							childEvent.startDate = eventDates.startDate;
							childEvent.endDate = eventDates.endDate;
							childEvent.dateSource = eventDates.dateSource; // Track whether dates come from iteration or field
						}
						
						childPlannedEvents.push(childEvent);
						childAssignments.push({
							id: "assign_child_" + childEvent.id,
							eventId: childEvent.id,
							resourceId: itemResourceId
						});
					});
					
					// Add events and assignments to scheduler
					if (childPlannedEvents.length > 0) {
						scheduler.eventStore.add(childPlannedEvents);
						scheduler.assignmentStore.add(childAssignments);
					}
					
					itemResource.childrenLoaded = true;
					itemResource.childrenVisible = false; // Set children as collapsed by default after loading
					
					// Hide the children events using filter (collapsed state)
					if (childPlannedEvents.length > 0) {
						_this.hidePlannedChildrenForResource(itemResourceId);
					}
					
					console.log(`Loaded children for item ${itemId}: ${plannedChildren.length} planned, ${unplannedChildren.length} unplanned (cached) - collapsed by default`);
					scheduler.refresh();
				}
			} catch (error) {
				console.error('Error loading children:', error);
				showBryntumToastMessage('Error loading children', 'error');
			} finally {
				itemResource.loading = false;
			}
		},
		getChildItemId: function(eventId) {
			// New format: <child_id>_<parent_item_id>_<group_id>
			// Extract the child ID (first part)
			return eventId.split("_")[0];
		},
		
		/**
		 * Toggles the visibility of children for an item resource
		 * @param {string} itemResourceId - The ID of the item resource
		 */
		toggleItemChildren(itemResourceId) {
			console.log('Toggling children visibility for item resource:', itemResourceId);
			
			const scheduler = this.$options.roadmap;
			const itemResource = scheduler.resourceStore.getById(itemResourceId);
			
			if (!itemResource) {
				console.error('Item resource not found:', itemResourceId);
				showBryntumToastMessage('Item resource not found', 'error');
				return;
			}
			
			// Check if children are loaded
			if (!itemResource.childrenLoaded) {
				console.log('Children not loaded yet, loading children first');
				this.loadItemChildren(itemResourceId).then(() => {
					// After loading, show the children
					itemResource.childrenVisible = true;
					this.showPlannedChildrenForResource(itemResourceId);
				});
				return;
			}
			
			// Toggle visibility
			const currentVisibility = itemResource.childrenVisible || false;
			itemResource.childrenVisible = !currentVisibility;
			
			if (itemResource.childrenVisible) {
				// Show children events using filter removal
				this.showPlannedChildrenForResource(itemResourceId);
				console.log('Children events shown for item resource:', itemResourceId);
			} else {
				// Hide children events using Bryntum filter
				this.hidePlannedChildrenForResource(itemResourceId);
				console.log('Children events hidden for item resource:', itemResourceId);
			}
			
			// Refresh the scheduler to update the UI
			scheduler.refresh();
		},

		/**
		 * Shows planned children for a specific item resource by removing the filter
		 * @param {string} itemResourceId - The ID of the item resource
		 */
		showPlannedChildrenForResource(itemResourceId) {
			const scheduler = this.$options.roadmap;
			const filterId = `hide-children-${itemResourceId}`;
			
			// Remove the filter to show children events
			scheduler.eventStore.removeFilter(filterId);
		},

		/**
		 * Hides planned children for a specific item resource using Bryntum filter
		 * @param {string} itemResourceId - The ID of the item resource
		 */
		hidePlannedChildrenForResource(itemResourceId) {
			const scheduler = this.$options.roadmap;
			const filterId = `hide-children-${itemResourceId}`;
			
			// Apply filter to hide children events (but keep parent events visible)
			scheduler.eventStore.filter({
				id: filterId,
				filterBy: (event) => {
					// Hide child events that belong to this item resource
					if (event.get('isChild') || event.get('ttype') === 'child_item') {
						// Check if this child event belongs to the item resource
						const eventId = event.id;
						const parts = eventId.split('_');
						if (parts.length >= 3) {
							const parentItemId = parts[1]; // Second part is parent item ID
							const groupId = parts[2]; // Third part is group ID
							const expectedResourceId = `${groupId}_item_${parentItemId}`;
							return expectedResourceId !== itemResourceId; // Hide if it matches
						}
					}
					return true; // Show all other events
				}
			});
		},

		/**
		 * Handles adding a new child item to the item resource
		 * @param {string} itemResourceId - The ID of the item resource
		 */
		onAddNewChild(itemResourceId) {
			// Only available in new mode
			if (!this.showIndividualItemResources) {
				console.warn('onAddNewChild is only available in Individual Items mode');
				showBryntumToastMessage('This feature is only available in Individual Items mode. Please toggle the view mode.', 'warning');
				return;
			}
			
			console.log('Adding new child to item resource:', itemResourceId);
			
			// Validate itemResourceId parameter
			if (!itemResourceId || typeof itemResourceId !== 'string') {
				console.error('Invalid itemResourceId provided:', itemResourceId);
				showBryntumToastMessage('Invalid item resource ID provided', 'error');
				return;
			}
			
			// Store the selected item resource ID
			this.selectedItemResourceId = itemResourceId;
			
			// Get the parent item from the resource ID
			// Resource ID format: {groupId}_item_{itemId}
			const resourceIdParts = itemResourceId.split('_');
			if (resourceIdParts.length < 3) {
				console.error('Invalid item resource ID format:', itemResourceId);
				showBryntumToastMessage('Invalid item resource ID format', 'error');
				return;
			}
			
			const parentItemId = resourceIdParts[2];
			const parentItem = this.itemsByIdMap[parentItemId];
			
			if (!parentItem) {
				console.error('Parent item not found for ID:', parentItemId);
				showBryntumToastMessage('Parent item not found', 'error');
				return;
			}
			
			console.log('Parent item found:', parentItem);
			
			// Find the current and child hierarchy levels (similar to rt-backlog.js)
			let currentIndex = _.findIndex(this.store.backlogHierarchyLevels, {level: parentItem.artRelationMap[this.releaseTrain.id].backlogLevel});
			let childLevel = this.store.backlogHierarchyLevels[currentIndex + 1];
			
			if (!childLevel) {
				console.warn('No child level found for parent level:', parentItem.artRelationMap[this.releaseTrain.id].backlogLevel);
				showBryntumToastMessage('Cannot create children at this level', 'warning');
				return;
			}
			
			// Setup the item popup for creating a new child
			this.itemPopup.item = {};
			this.itemPopup.parent = parentItem;
			this.itemPopup.level = childLevel;
			this.itemPopup.resourceId = this.selectedItemResourceId; // Store resource ID for later use
			
			// Setup ALM configuration
			if (!_.isEmpty(this.store.almAccounts)) {
				this.itemPopup.alm = this.store.almAccounts[0];
			}
			
			// Setup TFS projects if needed
			if (this.almAccountType === "tfs") {
				this.itemPopup.tfsProjects = this.store.tfsProjects;
			}
			
			console.log('Opening item popup for new child creation');
			this.itemPopup.show = true;
		},
		
		/**
		 * Handles adding an existing child item to the item resource
		 * @param {string} itemResourceId - The ID of the item resource
		 */
		onAddExistingChild(itemResourceId) {
			// Only available in new mode
			if (!this.showIndividualItemResources) {
				console.warn('onAddExistingChild is only available in Individual Items mode');
				showBryntumToastMessage('This feature is only available in Individual Items mode. Please toggle the view mode.', 'warning');
				return;
			}
			
			console.log('Adding existing child to item resource:', itemResourceId);
			
			// Validate itemResourceId parameter
			if (!itemResourceId || typeof itemResourceId !== 'string') {
				console.error('Invalid itemResourceId provided:', itemResourceId);
				showBryntumToastMessage('Invalid item resource ID provided', 'error');
				return;
			}
			
			// Store the selected item resource ID
			this.selectedItemResourceId = itemResourceId;
			
			// Get the parent item from the resource ID
			// Resource ID format: {groupId}_item_{itemId}
			const resourceIdParts = itemResourceId.split('_');
			if (resourceIdParts.length < 3) {
				console.error('Invalid item resource ID format:', itemResourceId);
				showBryntumToastMessage('Invalid item resource ID format', 'error');
				return;
			}
			
			const parentItemId = resourceIdParts[2];
			const parentItem = this.itemsByIdMap[parentItemId];
			
			if (!parentItem) {
				console.error('Parent item not found for ID:', parentItemId);
				showBryntumToastMessage('Parent item not found', 'error');
				return;
			}
			
			console.log('Parent item found for existing child:', parentItem);
			
			// Find the child hierarchy level
			let currentIndex = _.findIndex(this.store.backlogHierarchyLevels, {level: parentItem.artRelationMap[this.releaseTrain.id].backlogLevel});
			let childLevel = this.store.backlogHierarchyLevels[currentIndex + 1];
			
			if (!childLevel) {
				console.warn('No child level found for parent level:', parentItem.artRelationMap[this.releaseTrain.id].backlogLevel);
				showBryntumToastMessage('Cannot add children at this level', 'warning');
				return;
			}
			
			// Check if ALM accounts are available
			if (_.isEmpty(this.store.almAccounts)) {
				console.error('No ALM accounts available');
				showBryntumToastMessage('ALM configuration not available', 'error');
				return;
			}
			
			// Setup the add from ALM popup for adding existing children
			this.addFromAlmPopup.tfsProjects = this.store.tfsProjects;
			this.addFromAlmPopup.level = childLevel;
			this.addFromAlmPopup.alm = this.store.almAccounts[0];
			this.addFromAlmPopup.parent = parentItem;
			this.addFromAlmPopup.resourceId = this.selectedItemResourceId; // Store resource ID for later use
			
			console.log('Opening add from ALM popup for existing child');
			this.addFromAlmPopup.show = true;
		},
		
		/**
		 * Shows unplanned children of a specific item in the unplanned grid
		 * @param {string} itemId - The ID of the parent item
		 */
		showUnplannedChildren(itemId) {
			console.log('Showing unplanned children for item:', itemId);
			
			// Validate itemId
			if (!itemId) {
				showBryntumToastMessage('Invalid item ID provided', 'error');
				return;
			}
			
			// Get parent item info
			const parentItem = this.itemsByIdMap[itemId];
			if (!parentItem) {
				showBryntumToastMessage('Parent item not found', 'error');
				return;
			}
			
			// Get unplanned children from cache
			const unplannedChildren = this.unplannedChildrenCache[itemId];
			if (!unplannedChildren || unplannedChildren.length === 0) {
				showBryntumToastMessage(`No unplanned children found for "${parentItem.title}"`, 'info');
				return;
			}
			
			// Expand the unplanned grid if it's collapsed
			if (this.$options.unplannedGrid.collapsed) {
				this.$options.unplannedGrid.expand();
			}
			
			// Store the current filter state and set new filter mode
			this.unplannedGridMode = {
				mode: 'filtered', // vs 'default'
				parentItemId: itemId,
				parentItem: parentItem
			};
			
			// Update grid title to show filtered context
			this.$options.unplannedGrid.title = ` Unplanned : ${generateKey(parentItem)} ${parentItem.title}`;
			// this.$options.unplannedGrid.tooltip = ` Plan Children of ${generateKey(parentItem)} ${parentItem.title}`;

			// Show the reset button
			if (this.$options.unplannedGrid.widgetMap.resetButton) {
				this.$options.unplannedGrid.widgetMap.resetButton.show();
			}
			
			// Refresh the roadmap to update highlighted states
			this.refreshRoadmapResources();
			
			// Show grid loader for loading children
			this.showGridLoader('Loading unplanned children...');
			
			// Clear existing data and load filtered children
			this.$options.unplannedGrid.store.removeAll();
			
			// Transform unplanned children to grid format
			const gridData = unplannedChildren.map(child => {
				// Check if this child would use iteration path dates if planned
				const eventDates = this.calculateEventDates(child);
				const dateSource = eventDates ? eventDates.dateSource : null;
				
				return {
					id: `${child.id}_unplanned`,
					_id: `${child.id}_unplanned`, 
					title: child.title,
					status: child.status || { title: "unplanned" },
					statusClass: child.statusClass || 'unplanned',
					orgId: child.id,
					isGroup: false,
					searchableKey: this.generateSearchableKey(child),
					isChild: true,
					dateSource: dateSource, // Add dateSource for iteration indicator
					cls: styledClasses.rawViewUnplannedItems
				};
			});
			
			// Add the filtered children to grid
			this.$options.unplannedGrid.store.add(gridData);
			this.isGridChildMode = true;
			
			// Hide the group by combo when in filtered mode
			if (this.$options.unplannedGrid.widgetMap.groupByCombo) {
				this.$options.unplannedGrid.widgetMap.groupByCombo.hide();
			}
			
			// Hide grid loader after data is loaded
			this.hideGridLoader();
			
			console.log(`Loaded ${gridData.length} unplanned children for item "${parentItem.title}"`);
			showBryntumToastMessage(`Showing ${gridData.length} unplanned children of "${parentItem.title}"`, 'success');
			this.$options.unplannedGrid.collapsed = false;
		},
		
		/**
		 * Checks if the unplanned grid is currently in filtered mode
		 * @returns {boolean} - True if in filtered mode
		 */
		isUnplannedGridFiltered() {
			return this.unplannedGridMode.mode === 'filtered';
		},
		
		/**
		 * Gets the current parent item being filtered in the grid
		 * @returns {Object|null} - Parent item or null if not filtered
		 */
		getCurrentFilteredParent() {
			return this.isUnplannedGridFiltered() ? this.unplannedGridMode.parentItem : null;
		},
		
		/**
		 * Updates the unplanned count cache for a specific item
		 * @param {string} itemId - The item ID to update
		 */
		updateUnplannedCountCache(itemId) {
			const unplannedChildren = this.unplannedChildrenCache[itemId];
			this.unplannedChildrenCountCache[itemId] = unplannedChildren ? unplannedChildren.length : 0;
		},

		/**
		 * Shows planned children in the scheduler for a specific parent item
		 * @param {string} itemId - The parent item ID
		 */
		async showPlannedChildren(itemId) {
			console.log('Showing planned children for item:', itemId);
			
			// Validate itemId
			if (!itemId) {
				showBryntumToastMessage('Invalid item ID provided', 'error');
				return;
			}
			
			// Get parent item info
			const parentItem = this.itemsByIdMap[itemId];
			if (!parentItem) {
				showBryntumToastMessage('Parent item not found', 'error');
				return;
			}
			
			// Get planned children from cache (they should already be loaded as events in the scheduler)
			const plannedChildren = this.plannedChildrenCountCache[itemId] || 0;
			if (plannedChildren === 0) {
				showBryntumToastMessage(`No planned children found for "${parentItem.title}"`, 'info');
				return;
			}
			
			// Find the parent item resource and ensure children are visible
			const scheduler = this.$options.roadmap;
			let parentResourceId;
			let parentResource;
			
			// Try to find the parent item resource directly
			const allResources = scheduler.resourceStore.allRecords;
			const itemResource = allResources.find(resource => {
				// Look for the parent item resource pattern: {groupId}_item_{itemId}
				const resourceId = resource.id;
				return resourceId && resourceId.includes(`_item_${itemId}`) && !resourceId.includes('_child_');
			});
			
			if (itemResource) {
				// Found the parent item resource directly
				parentResourceId = itemResource.id;
				parentResource = itemResource;
				console.log(`Found parent item resource directly: ${parentResourceId}`);
			} else {
				// Try to find parent resource from child resource reference
				const childResource = allResources.find(resource => {
					const resourceId = resource.id;
					return resourceId && resourceId.includes(`_child_${itemId}_`);
				});
				
				if (childResource && childResource.parent && childResource.parent.id) {
					parentResourceId = childResource.parent.id;
					parentResource = scheduler.resourceStore.getById(parentResourceId);
					console.log(`Found parent resource from child reference: ${parentResourceId}`);
				} else {
					// Fallback: construct parent resource ID manually
					const groupId = parentItem.artRelationMap?.[this.releaseTrain.id]?.groupId;
					if (!groupId) {
						showBryntumToastMessage('Parent item group ID not found', 'error');
						return;
					}
					
					parentResourceId = `${groupId}_item_${itemId}`;
					parentResource = scheduler.resourceStore.getById(parentResourceId);
					console.log(`Constructed parent resource ID as fallback: ${parentResourceId}`);
				}
			}
			
			if (parentResource) {
				// Make sure children are visible
				if (!parentResource.childrenVisible) {
					this.toggleItemChildren(parentResourceId);
				}
				
				// Find the first child event to scroll to
				const firstChildEvent = this.findFirstChildEvent(itemId);
				
				if (firstChildEvent) {
					try {
						console.log(`Scrolling to first child event: ${firstChildEvent.id}`);
						
						// Use Bryntum's scrollEventIntoView to scroll to the first child event
						await scheduler.scrollEventIntoView(firstChildEvent, {
							animate: true,
							block: 'start',
							inline: 'start',
							y: false  // Only horizontal scroll
						});
						
						showBryntumToastMessage(`Showing ${plannedChildren} planned children of "${parentItem.title}" - scrolled to first child`, 'success');
					} catch (error) {
						console.error('Error scrolling to first child event:', error);
						
						// Fallback to scrolling to parent resource
						scheduler.scrollToResource(parentResourceId);
						showBryntumToastMessage(`Showing ${plannedChildren} planned children of "${parentItem.title}" in scheduler`, 'success');
					}
				} else {
					// No child events found, scroll to parent resource
					scheduler.scrollToResource(parentResourceId);
					showBryntumToastMessage(`Showing ${plannedChildren} planned children of "${parentItem.title}" in scheduler`, 'success');
				}
			} else {
				showBryntumToastMessage('Parent resource not found in scheduler', 'error');
			}
		},

		/**
		 * Finds the first child event (leftmost in timeline) for a given parent item
		 * @param {string} parentItemId - The parent item ID
		 * @returns {Object|null} - The first child event record or null if none found
		 */
		findFirstChildEvent(parentItemId) {
			try {
				const scheduler = this.$options.roadmap;
				let parentResourceId;
				let parentResource;
				
				// First, try to find the parent item resource directly
				const allResources = scheduler.resourceStore.allRecords;
				const itemResource = allResources.find(resource => {
					// Look for the parent item resource pattern: {groupId}_item_{parentItemId}
					const resourceId = resource.id;
					return resourceId && resourceId.includes(`_item_${parentItemId}`) && !resourceId.includes('_child_');
				});
				
				if (itemResource) {
					// Found the parent item resource directly
					parentResourceId = itemResource.id;
					parentResource = itemResource;
					console.log(`Found parent item resource directly: ${parentResourceId}`);
				} else {
					// Try to find parent resource from child resource reference
					const childResource = allResources.find(resource => {
						const resourceId = resource.id;
						return resourceId && resourceId.includes(`_child_${parentItemId}_`);
					});
					
					if (childResource && childResource.parent && childResource.parent.id) {
						parentResourceId = childResource.parent.id;
						parentResource = scheduler.resourceStore.getById(parentResourceId);
						console.log(`Found parent resource from child reference: ${parentResourceId}`);
					} else {
						// Fallback: construct parent resource ID manually
						const parentItem = this.itemsByIdMap[parentItemId];
						if (!parentItem) {
							console.log(`Parent item not found: ${parentItemId}`);
							return null;
						}
						
						const groupId = parentItem.artRelationMap?.[this.releaseTrain.id]?.groupId;
						if (!groupId) {
							console.log(`Group ID not found for parent item: ${parentItemId}`);
							return null;
						}
						
						parentResourceId = `${groupId}_item_${parentItemId}`;
						parentResource = scheduler.resourceStore.getById(parentResourceId);
						console.log(`Constructed parent resource ID as fallback: ${parentResourceId}`);
					}
				}
				
				if (!parentResource) {
					console.log(`Parent resource not found: ${parentResourceId}`);
					return null;
				}
				
				// Get all assignments for the parent resource to find child events
				const assignments = scheduler.assignmentStore.getAssignmentsForResource(parentResource);
				const childEvents = [];
				
				// Filter to get only child events
				assignments.forEach(assignment => {
					const event = scheduler.eventStore.getById(assignment.eventId);
					if (event && (event.get('isChild') || event.get('ttype') === 'child_item')) {
						childEvents.push(event);
					}
				});
				
				if (childEvents.length === 0) {
					console.log(`No child events found for parent item: ${parentItemId}`);
					return null;
				}
				
				// Sort child events by start date to find the leftmost (earliest) one
				childEvents.sort((a, b) => {
					const startDateA = a.startDate || new Date(9999, 0, 1);
					const startDateB = b.startDate || new Date(9999, 0, 1);
					return startDateA - startDateB;
				});
				
				const firstChildEvent = childEvents[0];
				console.log(`Found first child event: ${firstChildEvent.id} with start date: ${firstChildEvent.startDate}`);
				
				return firstChildEvent;
				
			} catch (error) {
				console.error('Error finding first child event:', error);
				return null;
			}
		},

		/**
		 * Scrolls to a newly created, planned, or moved event with animation
		 * @param {Object} eventRecord - The event record to scroll to
		 * @param {string} action - The action performed ('created', 'planned', 'moved')
		 * @param {string} itemTitle - The title of the item for toast message
		 */
		async scrollToNewEvent(eventRecord, action = 'created', itemTitle = 'Item') {
			try {
				const scheduler = this.$options.roadmap;
				
				if (!eventRecord || !scheduler) {
					console.warn('Cannot scroll to event: missing eventRecord or scheduler');
					return;
				}
				
				console.log(`Scrolling to ${action} event: ${eventRecord.id}`);
				
				// Use Bryntum's scrollEventIntoView with horizontal-only scrolling
				await scheduler.scrollEventIntoView(eventRecord, {
					animate: true,
					block: 'start',
					inline: 'start',
					y: action === 'planned'  // Only horizontal scroll
				});
				
				// Show success message
				const actionPastTense = action === 'created' ? 'created' : 
									   action === 'planned' ? 'planned' : 
									   action === 'moved' ? 'moved' : action;
				showBryntumToastMessage(`${itemTitle} ${actionPastTense} and scrolled into view`, 'success');
				
			} catch (error) {
				console.error(`Error scrolling to ${action} event:`, error);
				// Fallback to resource scrolling if event scrolling fails
				try {
					const scheduler = this.$options.roadmap;
					const resourceId = eventRecord.resourceId || (eventRecord.resource && eventRecord.resource.id);
					if (resourceId) {
						await scheduler.scrollToResource(resourceId);
						console.log(`Fallback: scrolled to resource ${resourceId}`);
					}
				} catch (fallbackError) {
					console.error('Fallback scrolling also failed:', fallbackError);
				}
			}
		},

		/**
		 * Checks if an event is a child event of a specific parent item
		 * @param {Object} event - The event record
		 * @param {string} parentItemId - The parent item ID
		 * @returns {boolean} - True if the event is a child of the parent
		 */
		isChildEventOfParent(event, parentItemId) {
			try {
				// Check if this is a child event by examining the event ID pattern
				// Child events typically have IDs like: childId_parentItemId_groupId
				const eventId = event.id;
				
				// Method 1: Check if event ID contains the parent item ID pattern
				if (eventId.includes(`_${parentItemId}_`)) {
					return true;
				}
				
				// Method 2: Check if event has isChild property and orgId matches a child of the parent
				if (event.get('isChild') || event.get('ttype') === 'child_item') {
					// For child events, the orgId should be the child item ID
					const childItemId = event.get('orgId');
					if (childItemId) {
						const childItem = this.itemsByIdMap[childItemId];
						if (childItem && childItem.parentId === parentItemId) {
							return true;
						}
					}
				}
				
				// Method 3: Check resource hierarchy - if event is on a child resource of the parent item resource
				const eventResourceId = event.resourceId || (event.resource && event.resource.id);
				if (eventResourceId) {
					const scheduler = this.$options.roadmap;
					const eventResource = scheduler.resourceStore.getById(eventResourceId);
					if (eventResource) {
						// Check if this resource is a child resource of the parent item resource
						const parentItem = this.itemsByIdMap[parentItemId];
						if (parentItem && parentItem.artRelationMap && parentItem.artRelationMap[this.releaseTrain.id]) {
							const parentItemGroupId = parentItem.artRelationMap[this.releaseTrain.id].groupId;
							if (parentItemGroupId) {
								const parentResourceId = `${parentItemGroupId}_item_${parentItemId}`;
								
								// Check if the event resource is a child of the parent resource
								if (eventResourceId.startsWith(`${parentResourceId}_child_`)) {
									return true;
								}
							}
						}
					}
				}
				
				return false;
				
			} catch (error) {
				console.error('Error checking if event is child of parent:', error);
				return false;
			}
		},

		/**
		 * Refreshes the roadmap resources to update visual states (like highlighting)
		 */
		refreshRoadmapResources() {
			try {
				// Force a refresh of the roadmap grid to update the resource renderers
				if (this.$options.roadmap && this.$options.roadmap.refresh) {
					this.$options.roadmap.refresh();
				}
			} catch (error) {
				console.error('Error refreshing roadmap resources:', error);
			}
		},

		/**
		 * Resets the unplanned grid to show all unplanned items (default mode)
		 */
		resetUnplannedGrid() {
			console.log('Resetting unplanned grid to default mode');
			
			// Reset the mode
			this.unplannedGridMode = {
				mode: 'default',
				parentItemId: null,
				parentItem: null
			};
			
			// Reset grid title to default
			this.$options.unplannedGrid.title = 'Unplanned Items';
			
			// Hide the reset button
			if (this.$options.unplannedGrid.widgetMap.resetButton) {
				this.$options.unplannedGrid.widgetMap.resetButton.hide();
			}
			
			// Clear search field if it exists
			if (this.$options.unplannedGrid.widgetMap.searchField) {
				this.$options.unplannedGrid.widgetMap.searchField.value = '';
			}
			
			// Refresh the roadmap to update highlighted states
			this.refreshRoadmapResources();
			
			// Reset unplanned filter
			this.unplannedFilter.searchText = '';
			
			// Reload the original unplanned data
			this.isGridChildMode = false;
			
			// Show the group by combo again
			if (this.$options.unplannedGrid.widgetMap.groupByCombo) {
				this.$options.unplannedGrid.widgetMap.groupByCombo.show();
			}
			
			this.loadUnplannedOnClick();

			
			showBryntumToastMessage('Unplanned grid reset to show all items', 'success');
				},
		
		/**
		 * Moves an item from unplanned cache to planned (when item gets dates)
		 * @param {string} itemId - The item ID to move
		 * @param {string} parentItemId - The parent item ID
		 */
		moveItemFromUnplannedToPlanned(itemId, parentItemId) {
			console.log('Moving item from unplanned to planned:', { itemId, parentItemId });
			
			// Find and remove from unplanned cache
			const unplannedChildren = this.unplannedChildrenCache[parentItemId];
			if (unplannedChildren) {
				const itemIndex = unplannedChildren.findIndex(child => child.id === itemId);
				if (itemIndex !== -1) {
					const item = unplannedChildren.splice(itemIndex, 1)[0];
					
					// Update count cache
					this.updateUnplannedCountCache(parentItemId);
					
					// Note: plannedChildrenCountCache will be incremented in addChildItemToItemResource()
					// when the item is actually added to the scheduler, not here
					console.log(`Moved item ${itemId} from unplanned cache for parent ${parentItemId}`);
					
					// Refresh scheduler to update the planned count display
					this.$options.roadmap.refresh();
					
					// Remove from grid if in filtered mode (isGridChildMode)
					if (this.isGridChildMode && this.isUnplannedGridFiltered() && this.unplannedGridMode.parentItemId === parentItemId) {
						// Find and remove the item from the grid store
						const gridStore = this.$options.unplannedGrid.store;
						const gridRecord = gridStore.find(record => record.get('orgId') === itemId);
						if (gridRecord) {
							gridStore.remove(gridRecord);
							console.log(`Removed item ${itemId} from filtered grid`);
						}
					}
					
					// If currently viewing this parent's unplanned children, refresh the grid
					if (this.isUnplannedGridFiltered() && this.unplannedGridMode.parentItemId === parentItemId) {
						this.showUnplannedChildren(parentItemId);
					}
					
					// Refresh scheduler to update count display
					this.$options.roadmap.refresh();
					
					console.log(`Item ${itemId} moved from unplanned to planned for parent ${parentItemId}`);
					return item;
				}
			}
			
			return null;
		},

		/**
		 * Generates a searchable key for an item (used in grid search)
		 * @param {Object} item - The item to generate key for
		 * @returns {string} - Searchable key string
		 */
		generateSearchableKey(item) {
			if (!item) return '';
			
			let key = '';
			if (item.almKey) {
				key = item.almKey;
			} else if (item.fields?.externalKey) {
				key = item.fields.externalKey;
			} else if (item.kendisKey) {
				key = item.kendisKey;
			}
			return key;
		},

		/**
		 * Adds a child item directly to the item resource
		 * @param {Object} childItem - The child item to add
		 * @param {string} itemResourceId - The ID of the item resource
		 */
		addChildItemToItemResource(childItem, itemResourceId) {
			console.log('Adding child item to item resource:', {
				childItem: childItem.title,
				resourceId: itemResourceId
			});
			
			const scheduler = this.$options.roadmap;
			
			// Get the item resource to check if it has children loaded
			const itemResource = scheduler.resourceStore.getById(itemResourceId);
			if (!itemResource) {
				console.error('Item resource not found:', itemResourceId);
				showBryntumToastMessage('Item resource not found', 'error');
				return;
			}
			
			// Get the parent item ID
			const parentItemId = itemResourceId.split('_')[2];
			
			// If children haven't been loaded yet, load them first
			if (!itemResource.childrenLoaded) {
				console.log('Children not loaded yet, loading children first');
				this.loadItemChildren(itemResourceId).then(() => {
					// After loading children, add the new child
					this.addChildItemToItemResource(childItem, itemResourceId);
				});
				return;
			}
			
			// Determine if the child should be planned or unplanned based on TFS settings
			let isPlanned = false;
			const eventDates = this.calculateEventDates(childItem);
			if (eventDates) {
				isPlanned = true;
				console.log(`Child item "${childItem.title}" will be planned with dates from ${eventDates.dateSource}:`, {
					startDate: eventDates.startDate,
					endDate: eventDates.endDate,
					dateSource: eventDates.dateSource
				});
			} else {
				console.log(`Child item "${childItem.title}" has no valid dates, will be unplanned`);
			}
			
			if (isPlanned) {
				// Add as planned child event directly to item resource
				let childEvent = this.createFilterEventForRoadmap(childItem);
				// New format: <child_id>_<parent_item_id>_<group_id>
				const parentItemId = itemResourceId.split('_')[2];
				const groupId = itemResourceId.split('_')[0];
				childEvent.id = `${childItem.id}_${parentItemId}_${groupId}`;
				// childEvent.resourceId = itemResourceId;
				childEvent.ttype = "child_item";
				childEvent.title = childItem.title;
				childEvent.orgId = childItem.id;
				childEvent.isChild = true;
				childEvent.isPlanned = true;
				childEvent.cls = ["kendis-roadmap-planned-event-dm-items","kendis-dashed-items"];
				
				// Set event dates and dateSource from calculated values
				if (eventDates) {
					childEvent.startDate = eventDates.startDate;
					childEvent.endDate = eventDates.endDate;
					childEvent.dateSource = eventDates.dateSource; // Track whether dates come from iteration or field
				}
				
				// Add the event to the scheduler
				scheduler.eventStore.add(childEvent);
				
				// Create assignment for the child event
				let childAssignment = {
					id: `assign_child_${childEvent.id}`,
					eventId: childEvent.id,
					resourceId: itemResourceId
				};
				
				// Add the assignment to the scheduler
				scheduler.assignmentStore.add(childAssignment);
				
				// Scroll to the newly created child event
				const createdChildEvent = scheduler.eventStore.getById(childEvent.id);
				if (createdChildEvent) {
					this.scrollToNewEvent(createdChildEvent, 'created', childItem.title);
				}
				
				// Update planned children count cache
				if (!this.plannedChildrenCountCache[parentItemId]) {
					this.plannedChildrenCountCache[parentItemId] = 0;
				}
				this.plannedChildrenCountCache[parentItemId]++;
				
				console.log('Planned child item successfully added to item resource');
				
				// Refresh scheduler to update the planned count display
				scheduler.refresh();
			} else {
				// Add to unplanned cache and update count
				if (!this.unplannedChildrenCache[parentItemId]) {
					this.unplannedChildrenCache[parentItemId] = [];
				}
				
				// Check for duplicates before adding to cache
				const existingChildIndex = this.unplannedChildrenCache[parentItemId].findIndex(
					cachedChild => cachedChild.id === childItem.id
				);
				
				if (existingChildIndex === -1) {
					// Add to cache only if not already present
					this.unplannedChildrenCache[parentItemId].push(childItem);
					this.unplannedChildrenCountCache[parentItemId] = this.unplannedChildrenCache[parentItemId].length;
					
					// Also add to unplanned grid if not in filtered mode
					if (!this.isGridChildMode) {
						// Get the group ID for the child item
						const groupId = itemResourceId.split('_')[0]; // Extract group from parent resource ID
						this.addItemsInUnplannedGrid([childItem], groupId);
						console.log('Added unplanned child to unplanned grid:', childItem.title);
					}
					
					console.log('Unplanned child item successfully added to cache');
					showBryntumToastMessage(`Unplanned child "${childItem.title}" added to cache`, 'success');
				} else {
					console.log('Child item already exists in cache, skipping duplicate addition');
				}
				
				// Refresh the scheduler to update the unplanned count display
				scheduler.refresh();
			}
		},
		
	
		
		async openRoadmapProgress() {
			kendisStore.commit('setRoadmapSearchTags', this.filters.searchTags);
			if(!this.unplannedFetched){
				await this.loadUnplannedOnClick("null");
			}
			this.$nextTick(() => {
				this.$router.push({
					path: `/${this.$route.params.viewType}/${this.$route.params.releaseTrainId}/roadmap/${this.$route.params.roadmapId || this.roadmap.id}/roadmap/progress`,
					query: {}
				});


			});
		},

		// Get child level of an item (copied from rt-timeline.js logic)
		getChildLevelOfItem: function(item, releaseTrainId) {
			if (item.artRelationMap && item.artRelationMap[releaseTrainId]) {
				return item.artRelationMap[releaseTrainId].backlogLevel + 1;
			}
			return this.currentHierarchyLevel.level + 1;
		},
		getGlobalMilestoneCount(){

			let scheduler = this.$options.roadmap;
			let count = 0;
			scheduler.eventStore.allRecords.forEach(event => {
				if (event.resource.id === '-1001') {
					count++;
				}
			});
			return count;



		},

		// ===== DRAG AND DROP HELPER METHODS =====

		/**
		 * Gets the target item (item or milestone) from the event record
		 * @param {Object} eventRecord - The event record
		 * @returns {Object|null} - The target item or null
		 */
		getTargetItem(eventRecord) {
			const itemId = eventRecord.get('orgId');
			const ttype = eventRecord.get('ttype');
			
			if (ttype === "item" || ttype === "child_item") {
				return this.itemsByIdMap[itemId];
			} else {
				return this.milestoneMapById[itemId];
			}
		},

		/**
		 * Determines the type of event (child, parent, milestone, etc.)
		 * @param {Object} eventRecord - The event record
		 * @returns {Object} - Object containing event type information
		 */
		getEventType(eventRecord) {
			const isChild = eventRecord.get('isChild') === true;
			const isMilestoneOrPhase = eventRecord.get('ttype') === 'milestone' || eventRecord.get('ttype') === 'phase';
			
			let isChildItem = isChild;
			if (!isChild && eventRecord.id) {
				const eventIdParts = eventRecord.id.split('_');
				isChildItem = eventIdParts.length >= 3; // Child events have 3 parts: childId_parentId_groupId
			}

			let isParentItemResource = false;
			if (this.showIndividualItemResources && !isChildItem && eventRecord.id) {
				const eventIdParts = eventRecord.id.split('_');
				isParentItemResource = eventIdParts.length === 2; // Parent item events: itemId_groupId
			}

			return {
				isChildItem,
				isParentItemResource,
				isMilestoneOrPhase
			};
		},

		/**
		 * Validates if the drag operation is allowed based on event type and resources
		 * @param {Object} event - The drag event
		 * @param {Object} eventRecord - The event record
		 * @param {Object} newResource - The target resource
		 * @param {Object} oldResource - The source resource
		 * @param {Object} eventType - The event type information
		 * @returns {boolean} - True if drag is valid, false otherwise
		 */
		validateDragOperation(event, eventRecord, newResource, oldResource, eventType) {
			const { isChildItem, isParentItemResource, isMilestoneOrPhase } = eventType;

			// Allow date changes within the same resource (resizing/repositioning)
			if (oldResource.id === newResource.id) {
				return true; // Always allow date changes within same resource
			}

			// Prevent child items from being moved to different resources
			if (isChildItem && newResource.id !== oldResource.id) {
				this.showDragError("Child items cannot be moved to different resources");
				return false;
			}

			// Validate parent item resource movement
			if (isParentItemResource && newResource.id !== oldResource.id) {
				if (!this.validateParentItemMovement(newResource, oldResource)) {
					return false;
				}
			}

			// Validate milestone/phase movement
			if (isMilestoneOrPhase) {
				return this.validateMilestoneMovement(event, eventRecord, newResource, oldResource);
			} else {
				return this.validateItemMovement(newResource, oldResource);
			}
		},

		/**
		 * Validates parent item movement between resources
		 * @param {Object} newResource - The target resource
		 * @param {Object} oldResource - The source resource
		 * @returns {boolean} - True if movement is valid
		 */
		validateParentItemMovement(newResource, oldResource) {
			console.log(`validateParentItemMovement called:`, {
				oldResourceId: oldResource.id,
				newResourceId: newResource.id,
				showIndividualItemResources: this.showIndividualItemResources,
				groupBy: this.groupBy.value
			});
			
			if (this.showIndividualItemResources) {
				// SHOW CHILDREN MODE: No drag & drop between resources, only within same resource
				if (oldResource.id === newResource.id) {
					console.log(`Show children mode: Allowing parent movement within same resource: ${oldResource.id}`);
					return true; // Allow resizing and repositioning within same resource
				} else {
					console.log(`Show children mode: Blocking parent movement between different resources`);
					this.showDragError("In 'Show Children' mode, parent items can only be moved within the same resource");
					return false;
				}
			} else {
				// DON'T SHOW CHILDREN MODE: Parent items can only be dropped in "items resources"
				if (this.groupBy.value === "Section") {
					const isNewResourceItemsResource = newResource.id.endsWith('_items');
					
					console.log(`No show children mode parent validation:`, {
						oldResourceId: oldResource.id,
						newResourceId: newResource.id,
						isNewItemsResource: isNewResourceItemsResource
					});
					
					// Only allow movement to items resources (e.g., sectionId_items)
					if (isNewResourceItemsResource) {
						console.log(`Allowing parent movement to items resource: ${newResource.id}`);
						return true; // Allow dropping in items resources
					} else {
						console.log(`Blocking parent movement to non-items resource: ${newResource.id}`);
						this.showDragError("Parent items can only be dropped in section item areas (not on section headers)");
						return false;
					}
				} else {
					this.showDragError("Parent item resources cannot be moved to different resources");
					return false;
				}
			}
		},

		/**
		 * Validates milestone/phase movement
		 * @param {Object} event - The drag event
		 * @param {Object} eventRecord - The event record
		 * @param {Object} newResource - The target resource
		 * @param {Object} newResource - The target resource
		 * @param {Object} oldResource - The source resource
		 * @returns {boolean} - True if movement is valid
		 */
		validateMilestoneMovement(event, eventRecord, newResource, oldResource) {
			console.log(`validateMilestoneMovement called:`, {
				oldResourceId: oldResource.id,
				newResourceId: newResource.id,
				showIndividualItemResources: this.showIndividualItemResources,
				groupBy: this.groupBy.value
			});
			
			// Allow milestones to be moved within the same resource (for date changes)
			if (oldResource.id === newResource.id) {
				console.log(`Allowing milestone movement within same resource: ${oldResource.id}`);
				return true; // Allow resizing and repositioning within same resource
			}
				return false;

			
			// // MILESTONES: Can be dropped in section resources AND global milestones (both modes)
			// if (this.groupBy.value === "Section") {
			// 	// Check if target is valid for milestones
			// 	if (this.isValidMilestoneDropTarget(newResource)) {
			// 		console.log(`Valid milestone drop target: ${newResource.id}`);
			//
			// 		// Handle movement to section resources
			// 		if (newResource.id !== "-1001" && oldResource.id !== "-1001") {
			// 			// Moving between section resources
			// 			const milestoneId = eventRecord.get('orgId') || eventRecord.id;
			// 			this.moveMilestoneToSection(newResource.id, eventRecord, milestoneId);
			// 			event.context.valid = true; // Prevent default handling
			// 			return false; // Stop further processing
			// 		} else if (newResource.id === "-1001" && oldResource.id !== "-1001") {
			// 			// Moving from section to global milestone resource
			// 			console.log(`Moving milestone from section to global milestone resource`);
			// 			return true; // Allow default handling
			// 		} else if (oldResource.id === "-1001" && newResource.id !== "-1001") {
			// 			// Moving from global milestone to section resource
			// 			console.log(`Moving milestone from global to section resource`);
			// 			return true; // Allow default handling
			// 		}
			// 	} else {
			// 		console.log(`Invalid milestone drop target: ${newResource.id}`);
			// 		this.showDragError("Milestones can only be dropped on section headers or the global milestone area");
			// 		return false;
			// 	}
			// } else {
			// 	this.showDragError("Milestones can only be moved between sections when grouped by Section");
			// 	return false;
			// }
			//
			// return true;
		},

		/**
		 * Validates item movement
		 * @param {Object} newResource - The target resource
		 * @param {Object} oldResource - The source resource
		 * @returns {boolean} - True if movement is valid
		 */
		validateItemMovement(newResource, oldResource) {
			console.log(`validateItemMovement called:`, {
				oldResourceId: oldResource.id,
				newResourceId: newResource.id,
				showIndividualItemResources: this.showIndividualItemResources,
				groupBy: this.groupBy.value
			});
			
			// Prevent items from being dropped in the global milestone resource
			if (newResource.id === "-1001") {
				this.showDragError("Items cannot be dropped in the global milestone area");
				return false;
			}
			
			// Prevent milestones from being moved to item resources
			if (oldResource.id === "-1001" && newResource.id !== "-1001") {
				this.showDragError("Milestones cannot be moved to any other resource");
				return false;
			}
			
			if (this.showIndividualItemResources) {
				// SHOW CHILDREN MODE: No drag & drop between resources, only within same resource
				if (oldResource.id === newResource.id) {
					console.log(`Show children mode: Allowing movement within same resource: ${oldResource.id}`);
					return true; // Allow resizing and repositioning within same resource
				} else {
					console.log(`Show children mode: Blocking movement between different resources`);
					this.showDragError("In 'Show Children' mode, items can only be moved within the same resource");
					return false;
				}
			} else {
				// DON'T SHOW CHILDREN MODE: Items can only be dropped in "items resources"
				if (this.groupBy.value === "Section") {
					const isOldResourceItemsResource = oldResource.id.endsWith('_items');
					const isNewResourceItemsResource = newResource.id.endsWith('_items');
					
					console.log(`No show children mode validation:`, {
						oldResourceId: oldResource.id,
						newResourceId: newResource.id,
						isOldItemsResource: isOldResourceItemsResource,
						isNewItemsResource: isNewResourceItemsResource
					});
					
					// Only allow movement to/from items resources (e.g., sectionId_items)
					if (isNewResourceItemsResource) {
						console.log(`Allowing movement to items resource: ${newResource.id}`);
						return true; // Allow dropping in items resources
					} else {
						console.log(`Blocking movement to non-items resource: ${newResource.id}`);
						this.showDragError("Items can only be dropped in section item areas (not on section headers)");
						return false;
					}
				} else {
					this.showDragError("Items can only be moved between sections when grouped by Section");
					return false;
				}
			}
		},

		/**
		 * Checks if a resource is a valid drop target for milestones
		 * @param {Object} resource - The resource to check
		 * @returns {boolean} - True if valid for milestone drops
		 */
		isValidMilestoneDropTarget(resource) {
			// Global milestone resource is always valid
			if (resource.id === "-1001") {
				return true;
			}
			
			// Section resources are valid (no underscores, not item resources)
			if (!resource.id.includes('_')) {
				return true;
			}
			
			// Item resources and items resources are NOT valid for milestones
			if (resource.id.includes('_item_') || resource.id.endsWith('_items')) {
				return false;
			}
			
			// Other group resources (status, batches, etc.) are valid
			return true;
		},
		
		/**
		 * Checks if a resource is a section resource (valid for item drops)
		 * @param {Object} resource - The resource to check
		 * @returns {boolean} - True if it's a section resource
		 */
		isSectionResource(resource) {
			// Global milestone resource is NOT a section resource
			if (resource.id === "-1001") {
				return false;
			}
			
			// Section resources typically don't have underscores (except for special cases like "null")
			// But we need to be more specific about what constitutes a section
			if (this.groupBy.value === "Section") {
				// In section grouping mode, section resources are the main group resources
				// They don't have underscores and are not item resources
				const isSection = !resource.id.includes('_') && !resource.id.includes('_item_') && !resource.id.endsWith('_items');
				
				// Debug logging
				console.log(`isSectionResource check for ${resource.id}:`, {
					groupBy: this.groupBy.value,
					hasUnderscore: resource.id.includes('_'),
					hasItem: resource.id.includes('_item_'),
					endsWithItems: resource.id.endsWith('_items'),
					result: isSection
				});
				
				return isSection;
			}
			
			return false;
		},
		
		/**
		 * Shows a drag error message
		 * @param {string} message - The error message
		 */
		showDragError(message) {
			showBryntumToastMessage(message, "warning");
		},

		/**
		 * Handles the actual event drop based on grouping and event type
		 * @param {Object} event - The drag event
		 * @param {Object} eventRecord - The event record
		 * @param {Object} newResource - The target resource
		 * @param {Object} oldResource - The source resource
		 * @param {Object} targetItem - The target item
		 * @param {Date} startDate - The start date
		 * @param {Date} endDate - The end date
		 */
		handleEventDrop(event, eventRecord, newResource, oldResource, targetItem, startDate, endDate) {
			if (this.groupBy.applied) {
				this.handleGroupedEventDrop(event, eventRecord, newResource, oldResource, targetItem, startDate, endDate);
			} else {
				this.handleUngroupedEventDrop(event, eventRecord, newResource, oldResource, targetItem, startDate, endDate);
			}
		},

		/**
		 * Handles event drop when grouping is applied
		 * @param {Object} event - The drag event
		 * @param {Object} eventRecord - The event record
		 * @param {Object} newResource - The target resource
		 * @param {Object} oldResource - The source resource
		 * @param {Object} targetItem - The target item
		 * @param {Date} startDate - The start date
		 * @param {Date} endDate - The end date
		 */
		handleGroupedEventDrop(event, eventRecord, newResource, oldResource, targetItem, startDate, endDate) {
			if (newResource.id === oldResource.id) {
				if (targetItem) {
					this.showItemEditPopup(targetItem, eventRecord, startDate, endDate);
				}
			} else if (this.groupBy.value === "Section" && targetItem) {
				this.handleSectionGroupedDrop(event, eventRecord, newResource, oldResource, targetItem, startDate, endDate);
			} else {
				this.showDragError("Drag and drop between swimlanes not allowed. Use 'Edit' to modify");
				event.context.valid = false;
			}
		},

		/**
		 * Handles event drop when grouped by Section
		 * @param {Object} event - The drag event
		 * @param {Object} eventRecord - The event record
		 * @param {Object} newResource - The target resource
		 * @param {Object} oldResource - The source resource
		 * @param {Object} targetItem - The target item
		 * @param {Date} startDate - The start date
		 * @param {Date} endDate - The end date
		 */
		handleSectionGroupedDrop(event, eventRecord, newResource, oldResource, targetItem, startDate, endDate) {
			console.log(`handleSectionGroupedDrop called:`, {
				oldResourceId: oldResource.id,
				newResourceId: newResource.id,
				showIndividualItemResources: this.showIndividualItemResources,
				eventType: this.getEventType(eventRecord)
			});
			
			expandResource(this.$options.roadmap, newResource, this.groupBy.value);
			
			const eventType = this.getEventType(eventRecord);
			
			if (this.showIndividualItemResources && eventType.isParentItemResource) {
				// SHOW CHILDREN MODE: For individual item resources, call moveToSection directly
				console.log(`Show children mode: Moving item to section ${newResource.id}`);
				this.moveToSection(newResource.id, eventRecord);
				event.context.valid = false; // Prevent default handling
			} else if (!this.showIndividualItemResources) {
				// DON'T SHOW CHILDREN MODE: Items and milestones are directly in section resources
				if (newResource.id === "-1001") {
					this.showDragError("Items cannot be moved to Milestones");
					event.context.valid = false;
				} else {
					// Extract section ID from the items resource (e.g., "sectionId_items" -> "sectionId")
					const sectionId = newResource.id.endsWith('_items') ? newResource.id.replace('_items', '') : newResource.id;
					console.log(`No show children mode: Moving item to section ${sectionId} via items resource ${newResource.id}`);
					
					// Update the item's section relations and move it
					this.moveToSection(sectionId, eventRecord);
					event.context.valid = true; // Prevent default handling
				}
			} else {
				this.showItemEditPopup(targetItem, eventRecord, startDate, endDate, oldResource, newResource);
			}
		},

		/**
		 * Handles event drop when no grouping is applied
		 * @param {Object} event - The drag event
		 * @param {Object} eventRecord - The event record
		 * @param {Object} newResource - The target resource
		 * @param {Object} oldResource - The source resource
		 * @param {Object} targetItem - The target item
		 * @param {Date} startDate - The start date
		 * @param {Date} endDate - The end date
		 */
		handleUngroupedEventDrop(event, eventRecord, newResource, oldResource, targetItem, startDate, endDate) {
			if (newResource.id === oldResource.id && targetItem) {
				this.showItemEditPopup(targetItem, eventRecord, startDate, endDate);
			} else {
				this.showDragError("Drag not allowed");
				event.context.valid = false;
			}
		},

		/**
		 * Finds the correct resource for a milestone based on its section relations
		 * @param {Object} item - The milestone item
		 * @returns {Object|null} - The target resource or null if not found
		 */
		findMilestoneResource(item) {
			// If grouping by sections
			if (this.groupBy.value === "Section") {
				// Find the section relation that matches the current roadmap ID
				const roadmapSectionRelation = this.findRoadmapSectionRelation(item);
				if (roadmapSectionRelation) {
					const sectionId = roadmapSectionRelation.baseItemId;
					
					// Find the section resource
					const sectionResource = this.$options.roadmap.resourceStore.getById(sectionId);
					if (sectionResource) {
						console.log(`Found section resource for milestone ${item.title}: ${sectionId}`);
						return sectionResource;
					} else {
						console.warn(`Section resource not found for milestone ${item.title}: ${sectionId}`);
					}
				}
			}
			
			// Default to global milestone resource
			console.log(`Using global milestone resource for milestone ${item.title}`);
			return this.$options.roadmap.resourceStore.getById("-1001");
		},

		/**
		 * Shows the item edit popup
		 * @param {Object} item - The item to edit
		 * @param {Object} eventRecord - The event record
		 * @param {Date} startDate - The start date
		 * @param {Date} endDate - The end date
		 * @param {Object} oldResource - The old resource (optional)
		 * @param {Object} newResource - The new resource (optional)
		 */
		showItemEditPopup(item, eventRecord, startDate, endDate, oldResource = null, newResource = null) {
			item = _.cloneDeep(item);
			item.fields = item.fields || {};
			item._fields = { StartDate: item.fields.StartDate, EndDate: item.fields.EndDate };
			
			const popupData = {
				eventRecord,
				changes: { date: { startDate, endDate } },
				item,
				show: true
			};

			if (oldResource && newResource) {
				popupData.oldResourceRecord = oldResource;
				popupData.newResourceRecord = newResource;
				popupData.groupChange = true;
			}

			Object.assign(this.itemEditPopup, popupData);
		},

		/**
		 * Handles unassigning items in individual item resources mode
		 * @param {Object} eventRecord - The event record being unassigned
		 * @param {Object} resourceRecord - The resource record containing the event
		 */
		handleUnassignInIndividualMode(eventRecord, resourceRecord) {
			console.log('Handling unassign in individual mode:', eventRecord.title);
			
			const itemId = eventRecord.get('orgId');
			const item = this.itemsByIdMap[itemId];
			
			if (!item) {
				console.error('Item not found for unassign:', itemId);
				showBryntumToastMessage('Item not found', 'error');
				return;
			}

			// Check if this is a child item or parent item
			const isChildItem = eventRecord.get('isChild') || eventRecord.id.includes('_child_');
			
			if (isChildItem) {
				// Handle child item unassign
				this.handleChildItemUnassign(eventRecord, resourceRecord, item);
			} else {
				// Handle parent item unassign
				this.handleParentItemUnassign(eventRecord, resourceRecord, item);
			}
		},

		/**
		 * Handles unassigning a child item
		 * @param {Object} eventRecord - The event record being unassigned
		 * @param {Object} resourceRecord - The resource record containing the event
		 * @param {Object} item - The item data
		 */
		async handleChildItemUnassign(eventRecord, resourceRecord, item) {
			console.log('Handling child item unassign:', item.title);
			
			// Extract parent item ID from the event ID (format: childId_parentItemId_groupId)
			const eventIdParts = eventRecord.id.split('_');
			if (eventIdParts.length < 3) {
				console.error('Invalid child event ID format:', eventRecord.id);
				showBryntumToastMessage('Invalid child event format', 'error');
				return;
			}
			
			const parentItemId = eventIdParts[1];
			const parentItem = this.itemsByIdMap[parentItemId];
			
			if (!parentItem) {
				console.error('Parent item not found:', parentItemId);
				showBryntumToastMessage('Parent item not found', 'error');
				return;
			}

			// Remove the child event from scheduler
			this.$options.roadmap.eventStore.remove(eventRecord);
			
			// Decrease planned children count since this child is being unassigned
			if (this.plannedChildrenCountCache[parentItemId] && this.plannedChildrenCountCache[parentItemId] > 0) {
				this.plannedChildrenCountCache[parentItemId]--;
				console.log(`Decreased planned children count for parent ${parentItemId} due to unassign, new count: ${this.plannedChildrenCountCache[parentItemId]}`);
			}
			
			// Refresh scheduler to update the planned count display
			this.$options.roadmap.refresh();
			
			// Resolve the correct unplanned group for this child item
			let unplannedGroupId = 'null';
			try {
				unplannedGroupId = await this.resolveGroupIdForItemTransition(
					item.id, 
					'unplanned', 
					this.groupByUnplanned.value
				);
				console.log(`Resolved unplanned group ID for child ${item.id}: ${unplannedGroupId}`);
			} catch (error) {
				console.error('Error resolving unplanned group ID for child:', error);
				// Fallback to null group
				unplannedGroupId = 'null';
			}
			
			// Add child to unplanned cache
			if (!this.unplannedChildrenCache[parentItemId]) {
				this.unplannedChildrenCache[parentItemId] = [];
			}
			
			// Check if child is already in cache to prevent duplicates
			const existingChildIndex = this.unplannedChildrenCache[parentItemId].findIndex(
				cachedChild => cachedChild.id === item.id
			);
			
			// Add group information to the item for proper unplanned grid display
			const itemWithGroupInfo = {
				...item,
				unplannedGroupId: unplannedGroupId,
				unplannedGroupBy: this.groupByUnplanned.value
			};
			
			if (existingChildIndex === -1) {
				// Child not in cache, add it
				this.unplannedChildrenCache[parentItemId].push(itemWithGroupInfo);
				this.unplannedChildrenCountCache[parentItemId] = this.unplannedChildrenCache[parentItemId].length;
				console.log(`Added child ${item.id} to unplanned cache for parent ${parentItemId} with group ${unplannedGroupId}`);
			} else {
				// Child already in cache, just update it
				this.unplannedChildrenCache[parentItemId][existingChildIndex] = itemWithGroupInfo;
				console.log(`Updated existing child ${item.id} in unplanned cache for parent ${parentItemId} with group ${unplannedGroupId}`);
			}
			
			// Update the child item in database
			this.updateItemDates(item);
			
			// Open unplanned grid in child mode for this parent
			this.showUnplannedChildren(parentItemId);
			
			// Add focus animation to the unplanned grid
			if (this.$options.unplannedGrid) {
				const gridElement = this.$options.unplannedGrid.element;
				if (gridElement) {
					gridElement.classList.add('kendis-grid-focus-animation');
					setTimeout(() => {
						gridElement.classList.remove('kendis-grid-focus-animation');
					}, 1500);
				}
			}
			
			this.showSmartMessage(`Child item "${item.title}" moved to unplanned`, 'success');
		},

		/**
		 * Handles unassigning a parent item
		 * @param {Object} eventRecord - The event record being unassigned
		 * @param {Object} resourceRecord - The resource record containing the event
		 * @param {Object} item - The item data
		 */
		handleParentItemUnassign(eventRecord, resourceRecord, item) {
			console.log('Handling parent item unassign:', item.title);
			
			const scheduler = this.$options.roadmap;
			const unplannedGrid = this.$options.unplannedGrid;
			
			// Use legacy unassign method for parent items
			const relatedEvents = scheduler.eventStore.allRecords
				.filter(event => event.get('orgId') === item.id);
			
			// Remove assignments
			for (let event of relatedEvents) {
				scheduler.assignmentStore.remove(
					scheduler.assignmentStore.getAssignmentsForEvent(event)
				);
			}
			
			// Handle unassign using legacy method
			this.handleUnassignPlannedEvent(relatedEvents, scheduler, unplannedGrid);
			
			// Remove the item resource and all its children
			const itemResourceId = resourceRecord.id;
			const childResourcesToRemove = this.$options.roadmapSectionsCrud.getAllChildResources(itemResourceId);
			
			// Remove all child resources first
			childResourcesToRemove.forEach(childResourceId => {
				scheduler.resourceStore.remove(childResourceId);
				console.log(`Removed child resource: ${childResourceId}`);
			});

			//if resource has parent then remove the child in the parent resource
			if(resourceRecord.parent){
				resourceRecord.parent.removeChild([resourceRecord]);
				console.log(`Removed child resource from parent: ${itemResourceId}`);
			}
			
			// Remove the parent item resource
			scheduler.resourceStore.remove(itemResourceId);
			console.log(`Removed parent item resource: ${itemResourceId}`);
			
			// Refresh the roadmap
			scheduler.refresh();
			
			this.showSmartMessage(`Parent item "${item.title}" and all children moved to unplanned`, 'success');
		},

		/**
		 * Plans an unplanned item from the grid
		 * @param {string} recordId - The record ID of the unplanned item
		 */
		async planUnplannedItem(recordId) {
			let record = this.$options.unplannedGrid.store.getById(recordId);
			let item = roadmapVue.itemsByIdMap[record.originalData.id.split('_')[0]];
			let startDate = new Date();
			startDate.setHours(0, 0, 0, 0);
			let resource = {}
			let endDate = vueInstance.$options.ROADMAP_MODULE.DateHelper.add(startDate, 30, 'd');
			
			// Check if grid is in filtered mode (showing unplanned children of a specific parent)
			if(roadmapVue.unplannedGridMode.mode === 'filtered') {
				// Get the parent item resource ID
				const parentItemId = roadmapVue.unplannedGridMode.parentItemId;
				const parentItem = roadmapVue.itemsByIdMap[parentItemId];
				
				if (parentItem) {
					// Find the parent item resource
					const scheduler = roadmapVue.$options.roadmap;
					const parentResourceId = `${parentItem.artRelationMap[roadmapVue.releaseTrain.id].groupId}_item_${parentItemId}`;
					const parentResource = scheduler.resourceStore.getById(parentResourceId);
					
					if (parentResource) {
						resource = parentResource;
					}
				}
			} else {
				// Use the new group ID resolution API to determine the correct resource
				try {
					const itemId = record.originalData.id.split('_')[0];
					const resolvedGroupId = await this.resolveGroupIdForItemTransition(
						itemId, 
						'planned', 
						this.groupBy.value
					);
					
					if (resolvedGroupId) {
						// Find the appropriate resource based on the resolved group ID
						resource = await this.findResourceForGroupId(resolvedGroupId, this.groupBy.value, true);
					} else {
						// Fallback to legacy logic if resolution fails
						if(roadmapVue.groupByUnplanned.value === "Section"){
							let resourceId = record.get("groupId")
							resource = roadmapVue.$options.roadmap.resourceStore.getById(resourceId);
						}
					}
				} catch (error) {
					console.error('Error resolving group ID for item transition:', error);
					// Fallback to legacy logic on error
					if(roadmapVue.groupByUnplanned.value === "Section"){
						let resourceId = record.get("groupId")
						resource = roadmapVue.$options.roadmap.resourceStore.getById(resourceId);
					}
				}
			}
			
			if (item) {
				item = _.cloneDeep(item);
				if (!item.fields) {
					item.fields = {};
				}
				item.fields.StartDate = startDate;
				item.fields.EndDate = endDate;
				item._fields ={
					StartDate: "",
					EndDate: ""
				}
				
				// Store additional context for filtered mode
				roadmapVue.itemEditPopup.changes = {
					date: {
						startDate: startDate,
						endDate: endDate,
					}
				};
				roadmapVue.itemEditPopup.planningItemParams = {
					task: record,
					resource: resource,
					isFilteredMode: roadmapVue.unplannedGridMode.mode === 'filtered',
					parentItemId: roadmapVue.unplannedGridMode.parentItemId
				}
				roadmapVue.itemEditPopup.item = item;
				roadmapVue.itemEditPopup.show = true;
			}
		},

		/**
		 * Resolves the appropriate group ID for an item when moving between planned and unplanned states
		 * @param {string} itemId - The item ID
		 * @param {string} targetState - The target state ('planned' or 'unplanned')
		 * @param {string} targetGroupBy - The group by configuration for the target state
		 * @returns {Promise<string>} - The resolved group ID
		 */
		async resolveGroupIdForItemTransition(itemId, targetState, targetGroupBy) {
			try {
				const requestData = {
					itemId: itemId,
					releaseTrainId: this.releaseTrain.id,
					targetState: targetState,
					targetGroupBy: targetGroupBy,
					boardId: this.roadmap.id // Using release train ID as board ID for now
				};

				const response = await fetch('/releasetrain/resolve-group-id-for-transition', {
					method: 'POST',
					headers: getFetchAPIHeadersForKendis(),
					body: JSON.stringify(requestData)
				});

				const result = await response.json();
				
				if (result.success) {
					return result.groupId;
				} else {
					console.warn('Group ID resolution failed:', result.message);
					return 'null';
				}
			} catch (error) {
				console.error('Error calling group ID resolution API:', error);
				return 'null';
			}
		},

		/**
		 * Finds the appropriate resource for a given group ID and group by configuration
		 * Creates the group dynamically if it doesn't exist
		 * @param {string} groupId - The group ID
		 * @param {string} groupBy - The group by configuration
		 * @param {boolean} isForPlanned - Whether this is for planned (roadmap) or unplanned (grid) resources
		 * @returns {Promise<Object>} - The resource object
		 */
		async findResourceForGroupId(groupId, groupBy, isForPlanned = true) {
			const scheduler = this.$options.roadmap;
			let targetResourceId;

			// Determine the target resource ID based on group by configuration
			switch (groupBy) {
				case 'Section':
					// For sections, always use the actual section ID for planning
					// The _items resource is only for display purposes, not for planning
					if (isForPlanned) {
						targetResourceId = groupId; // Always use actual section ID for planning
					} else {
						// For unplanned resources, use _items if not showing individual items
						targetResourceId = this.showIndividualItemResources ? groupId : `${groupId}_items`;
					}
					break;
					
				case 'kendisStatus':
				case 'Batches':
				case 'Teams':
				case 'Containers':
				case 'Session':
				case 'SolutionBoards':
				case 'Milestones':
				case 'kendisResponsible':
				case 'tfsResponsible':
				case 'jiraResponsible':
				case 'Project':
				case 'AreaPath':
				case 'Iteration':
					// For other group types, use the group ID directly
					targetResourceId = groupId;
					break;
					
				default:
					// For unknown group types, try to use the group ID directly
					targetResourceId = groupId;
					break;
			}
			

			// Try to find existing resource
			let resource = scheduler.resourceStore.getById(targetResourceId);
			
			if (resource) {
				console.warn(`Found existing resource: ${resource.id}`);
			} else if (groupId !== 'null') {
				// Resource doesn't exist, create it dynamically
				console.log(`Resource ${targetResourceId} not found for group ${groupId}, creating dynamically...`);
				
				if (isForPlanned) {
					resource = await this.createPlannedGroupResource(groupId, groupBy, targetResourceId);
				} else {
					resource = await this.createUnplannedGroupResource(groupId, groupBy, targetResourceId);
				}
			} else {
				console.log(`Group ID is null, returning null`);
			}
			
			return resource;
		},

		/**
		 * Creates a planned group resource dynamically
		 * @param {string} groupId - The group ID
		 * @param {string} groupBy - The group by configuration
		 * @param {string} targetResourceId - The target resource ID
		 * @returns {Promise<Object>} - The created resource
		 */
		async createPlannedGroupResource(groupId, groupBy, targetResourceId) {
			try {
				console.log(`Creating planned group resource: ${targetResourceId} for group ${groupId} (${groupBy})`);
				
				// Get group metadata
				const groupMetadata = await this.fetchGroupMetadata(groupId, groupBy);
				
				if (!groupMetadata) {
					console.error(`Failed to fetch metadata for group ${groupId}`);
					return null;
				}
				
				const scheduler = this.$options.roadmap;
				let newResource;
				
				// Create resource based on group by type
				switch (groupBy) {
					case 'Section':
						newResource = await this.createSectionResource(groupId, groupMetadata, targetResourceId);
						break;
						
					case 'kendisStatus':
						newResource = this.createStatusResource(groupId, groupMetadata, targetResourceId);
						break;
						
					case 'Batches':
						newResource = this.createBatchResource(groupId, groupMetadata, targetResourceId);
						break;
						
					case 'Teams':
						newResource = this.createTeamResource(groupId, groupMetadata, targetResourceId);
						break;
						
					case 'Containers':
						newResource = this.createContainerResource(groupId, groupMetadata, targetResourceId);
						break;
						
					case 'Session':
						newResource = this.createSessionResource(groupId, groupMetadata, targetResourceId);
						break;
						
					case 'SolutionBoards':
						newResource = this.createSolutionBoardResource(groupId, groupMetadata, targetResourceId);
						break;
						
					case 'Milestones':
						newResource = this.createMilestoneGroupResource(groupId, groupMetadata, targetResourceId);
						break;
						
					case 'kendisResponsible':
					case 'tfsResponsible':
					case 'jiraResponsible':
						newResource = this.createResponsibleResource(groupId, groupMetadata, targetResourceId, groupBy);
						break;
						
					case 'Project':
						newResource = this.createProjectResource(groupId, groupMetadata, targetResourceId);
						break;
						
					case 'AreaPath':
						newResource = this.createAreaPathResource(groupId, groupMetadata, targetResourceId);
						break;
						
					case 'Iteration':
						newResource = this.createIterationResource(groupId, groupMetadata, targetResourceId);
						break;
						
					default:
						newResource = this.createGenericResource(groupId, groupMetadata, targetResourceId, groupBy);
						break;
				}
				
				if (newResource) {
					// Add the resource to the scheduler
					scheduler.resourceStore.add(newResource);
					
					// If this is a section and we're not showing individual items, create the items sub-resource
					if (groupBy === 'Section' && !this.showIndividualItemResources) {
						const itemsResource = this.createSectionItemsResource(groupId, groupMetadata);
						scheduler.resourceStore.add(itemsResource);
					}
					
					// Create the group header event
					await this.createGroupHeaderEvent(newResource, groupBy, groupMetadata);
					
					console.log(`Successfully created planned resource: ${targetResourceId}`);
					return scheduler.resourceStore.getById(targetResourceId);
				}
				
				return null;
				
			} catch (error) {
				console.error(`Error creating planned group resource for ${groupId}:`, error);
				return null;
			}
		},

		/**
		 * Creates an unplanned group resource dynamically (for grid grouping)
		 * @param {string} groupId - The group ID
		 * @param {string} groupBy - The group by configuration
		 * @param {string} targetResourceId - The target resource ID
		 * @returns {Promise<Object>} - The created resource metadata
		 */
		async createUnplannedGroupResource(groupId, groupBy, targetResourceId) {
			try {
				console.log(`Creating unplanned group resource: ${targetResourceId} for group ${groupId} (${groupBy})`);
				
				// Get group metadata
				const groupMetadata = await this.fetchGroupMetadata(groupId, groupBy);
				
				if (!groupMetadata) {
					console.error(`Failed to fetch metadata for group ${groupId}`);
					return null;
				}
				
				// For unplanned resources, we mainly need the metadata for proper grid display
				// The actual grid grouping will be handled when the grid is refreshed
				const unplannedGroupResource = {
					id: targetResourceId,
					name: groupMetadata.name || groupId,
					groupId: groupId,
					groupBy: groupBy,
					isUnplannedGroup: true,
					metadata: groupMetadata
				};
				
				console.log(`Successfully created unplanned group metadata: ${targetResourceId}`);
				return unplannedGroupResource;
				
			} catch (error) {
				console.error(`Error creating unplanned group resource for ${groupId}:`, error);
				return null;
			}
		},

		/**
		 * Fetches metadata for a group
		 * @param {string} groupId - The group ID
		 * @param {string} groupBy - The group by configuration
		 * @returns {Promise<Object>} - The group metadata
		 */
		async fetchGroupMetadata(groupId, groupBy) {
			try {
				// For different group types, we may need to fetch from different sources
				switch (groupBy) {
					case 'Section':
						return await this.fetchSectionMetadata(groupId);
					case 'kendisStatus':
						return await this.fetchStatusMetadata(groupId);
					case 'Batches':
						return await this.fetchBatchMetadata(groupId);
					case 'Teams':
						return await this.fetchTeamMetadata(groupId);
					case 'Containers':
						return await this.fetchContainerMetadata(groupId);
					case 'Session':
						return await this.fetchSessionMetadata(groupId);
					case 'SolutionBoards':
						return await this.fetchSolutionBoardMetadata(groupId);
					case 'Milestones':
						return await this.fetchMilestoneMetadata(groupId);
					case 'kendisResponsible':
					case 'tfsResponsible':
					case 'jiraResponsible':
						return await this.fetchResponsibleMetadata(groupId, groupBy);
					case 'Project':
						return await this.fetchProjectMetadata(groupId);
					case 'AreaPath':
						return await this.fetchAreaPathMetadata(groupId);
					case 'Iteration':
						return await this.fetchIterationMetadata(groupId);
					default:
						return { id: groupId, name: groupId, type: groupBy };
				}
			} catch (error) {
				console.error(`Error fetching metadata for group ${groupId} (${groupBy}):`, error);
				// Return basic metadata as fallback
				return { id: groupId, name: groupId, type: groupBy };
			}
		},

		/**
		 * Fetches section metadata
		 */
		async fetchSectionMetadata(sectionId) {
			try {
				const response = await fetch('/roadmap-section/get', {
					method: 'POST',
					headers: getFetchAPIHeadersForKendis(),
					body: JSON.stringify({ id: sectionId })
				});
				
				if (response.ok) {
					const result = await response.json();
					if (result.success && result.roadmapSection) {
						return {
							id: sectionId,
							name: result.roadmapSection.title || `Section ${sectionId}`,
							color: result.roadmapSection.color || '#38baa1',
							type: 'Section'
						};
					}
				}
				
				// Fallback
				return { id: sectionId, name: `Section ${sectionId}`, color: '#3DC198', type: 'Section' };
			} catch (error) {
				console.error(`Error fetching section metadata for ${sectionId}:`, error);
				return { id: sectionId, name: `Section ${sectionId}`, color: '#3DC198', type: 'Section' };
			}
		},

		/**
		 * Fetches status metadata
		 */
		async fetchStatusMetadata(statusId) {
			// Check if we already have status information in the store
			if (this.store && this.store.statusList) {
				const status = this.store.statusList.find(s => s.title === statusId);
				if (status) {
					return {
						id: statusId,
						name: status.title,
						color: status.color || '#38baa1',
						type: 'Status'
					};
				}
			}
			
			// Fallback
			return { id: statusId, name: statusId, color: '#3DC198', type: 'Status' };
		},

		/**
		 * Creates resource creation methods for different group types
		 */
		createSectionResource(groupId, metadata, targetResourceId) {
			return {
				id: targetResourceId,
				name: metadata.name,
				color: metadata.color,
				expanded: true,
				children: !this.showIndividualItemResources,
				groupId: groupId,
				isSection: true,
				isDynamicallyCreated: true
			};
		},

		createSectionItemsResource(groupId, metadata) {
			return {
				id: `${groupId}_items`,
				name: 'Items',
				parentId: groupId,
				color: metadata.color,
				groupId: groupId,
				isItemsResource: true,
				isDynamicallyCreated: true
			};
		},

		createStatusResource(groupId, metadata, targetResourceId) {
			return {
				id: targetResourceId,
				name: metadata.name,
				color: metadata.color,
				expanded: true,
				groupId: groupId,
				isStatusGroup: true,
				isDynamicallyCreated: true
			};
		},

		createBatchResource(groupId, metadata, targetResourceId) {
			return {
				id: targetResourceId,
				name: metadata.name || `Batch ${groupId}`,
				color: metadata.color || '#3DC198',
				expanded: true,
				groupId: groupId,
				isBatchGroup: true,
				isDynamicallyCreated: true
			};
		},

		createTeamResource(groupId, metadata, targetResourceId) {
			return {
				id: targetResourceId,
				name: metadata.name || `Team ${groupId}`,
				color: metadata.color || '#3DC198',
				expanded: true,
				groupId: groupId,
				isTeamGroup: true,
				isDynamicallyCreated: true
			};
		},

		createContainerResource(groupId, metadata, targetResourceId) {
			return {
				id: targetResourceId,
				name: metadata.name || `Container ${groupId}`,
				color: metadata.color || '#3DC198',
				expanded: true,
				groupId: groupId,
				isContainerGroup: true,
				isDynamicallyCreated: true
			};
		},

		createSessionResource(groupId, metadata, targetResourceId) {
			return {
				id: targetResourceId,
				name: metadata.name || `Session ${groupId}`,
				color: metadata.color || '#3DC198',
				expanded: true,
				groupId: groupId,
				isSessionGroup: true,
				isDynamicallyCreated: true
			};
		},

		createSolutionBoardResource(groupId, metadata, targetResourceId) {
			return {
				id: targetResourceId,
				name: metadata.name || `Solution Board ${groupId}`,
				color: metadata.color || '#3DC198',
				expanded: true,
				groupId: groupId,
				isSolutionBoardGroup: true,
				isDynamicallyCreated: true
			};
		},

		createMilestoneGroupResource(groupId, metadata, targetResourceId) {
			return {
				id: targetResourceId,
				name: metadata.name || `Milestone ${groupId}`,
				color: metadata.color || '#3DC198',
				expanded: true,
				groupId: groupId,
				isMilestoneGroup: true,
				isDynamicallyCreated: true
			};
		},

		createResponsibleResource(groupId, metadata, targetResourceId, groupBy) {
			return {
				id: targetResourceId,
				name: metadata.name || groupId,
				color: metadata.color || '#3DC198',
				expanded: true,
				groupId: groupId,
				isResponsibleGroup: true,
				responsibleType: groupBy,
				isDynamicallyCreated: true
			};
		},

		createProjectResource(groupId, metadata, targetResourceId) {
			return {
				id: targetResourceId,
				name: metadata.name || `Project ${groupId}`,
				color: metadata.color || '#3DC198',
				expanded: true,
				groupId: groupId,
				isProjectGroup: true,
				isDynamicallyCreated: true
			};
		},

		createAreaPathResource(groupId, metadata, targetResourceId) {
			return {
				id: targetResourceId,
				name: metadata.name || `Area ${groupId}`,
				color: metadata.color || '#3DC198',
				expanded: true,
				groupId: groupId,
				isAreaPathGroup: true,
				isDynamicallyCreated: true
			};
		},

		createIterationResource(groupId, metadata, targetResourceId) {
			return {
				id: targetResourceId,
				name: metadata.name || `Iteration ${groupId}`,
				color: metadata.color || '#3DC198',
				expanded: true,
				groupId: groupId,
				isIterationGroup: true,
				isDynamicallyCreated: true
			};
		},

		createGenericResource(groupId, metadata, targetResourceId, groupBy) {
			return {
				id: targetResourceId,
				name: metadata.name || `${groupBy} ${groupId}`,
				color: metadata.color || '#3DC198',
				expanded: true,
				groupId: groupId,
				isGenericGroup: true,
				groupType: groupBy,
				isDynamicallyCreated: true
			};
		},

		// Placeholder methods for fetching metadata (can be enhanced later)
		async fetchBatchMetadata(batchId) {
			return { id: batchId, name: `Batch ${batchId}`, color: '#3DC198', type: 'Batch' };
		},

		async fetchTeamMetadata(teamId) {
			return { id: teamId, name: `Team ${teamId}`, color: '#3DC198', type: 'Team' };
		},

		async fetchContainerMetadata(containerId) {
			return { id: containerId, name: `Container ${containerId}`, color: '#3DC198', type: 'Container' };
		},

		async fetchSessionMetadata(sessionId) {
			return { id: sessionId, name: `Session ${sessionId}`, color: '#3DC198', type: 'Session' };
		},

		async fetchSolutionBoardMetadata(solutionBoardId) {
			return { id: solutionBoardId, name: `Solution Board ${solutionBoardId}`, color: '#3DC198', type: 'SolutionBoard' };
		},

		async fetchMilestoneMetadata(milestoneId) {
			return { id: milestoneId, name: `Milestone ${milestoneId}`, color: '#3DC198', type: 'Milestone' };
		},

		async fetchResponsibleMetadata(responsibleId, groupBy) {
			return { id: responsibleId, name: responsibleId, color: '#3DC198', type: groupBy };
		},

		async fetchProjectMetadata(projectId) {
			return { id: projectId, name: `Project ${projectId}`, color: '#3DC198', type: 'Project' };
		},

		async fetchAreaPathMetadata(areaPathId) {
			return { id: areaPathId, name: `Area ${areaPathId}`, color: '#3DC198', type: 'AreaPath' };
		},

		async fetchIterationMetadata(iterationId) {
			return { id: iterationId, name: `Iteration ${iterationId}`, color: '#3DC198', type: 'Iteration' };
		},

		/**
		 * Creates a group header event for a dynamically created resource
		 * @param {Object} resource - The resource object
		 * @param {string} groupBy - The group by configuration
		 * @param {Object} metadata - The group metadata
		 */
		async createGroupHeaderEvent(resource, groupBy, metadata) {
			try {
				const scheduler = this.$options.roadmap;
				const groupId = resource.id;
				
				// Check if header event already exists
				const existingEvent = scheduler.eventStore.getById(`full-span-event-${groupId}`);
				if (existingEvent) {
					console.log(`Group header event already exists for resource ${resource.id}`);
					return;
				}
				
				// Create the group header event using the same pattern as drawGroupHeaderEvents
				const headerEvent = {
					id: `full-span-event-${groupId}`,
					title: ` ${metadata.name}`,
					startDate: new Date(1000, 0, 1),
					endDate: new Date(9999, 0, 1),
					cls: 'kendis-full-length-event',
					readOnly: true, // This event is marked as read-only
					isHeader: true,
					eventColor: metadata.color || '#3DC198',
					isDynamicallyCreated: true,
					groupBy: groupBy,
					groupId: resource.groupId || resource.id
				};
				
				// Add specific properties based on group type
				switch (groupBy) {
					case 'Section':
						headerEvent.isSection = true;
						headerEvent.sectionId = resource.groupId;
						break;
					case 'kendisStatus':
						headerEvent.isStatus = true;
						headerEvent.statusId = resource.groupId;
						break;
					case 'Batches':
						headerEvent.isBatch = true;
						headerEvent.batchId = resource.groupId;
						break;
					case 'Teams':
						headerEvent.isTeam = true;
						headerEvent.teamId = resource.groupId;
						break;
					case 'Containers':
						headerEvent.isContainer = true;
						headerEvent.containerId = resource.groupId;
						break;
					case 'Session':
						headerEvent.isSession = true;
						headerEvent.sessionId = resource.groupId;
						break;
					case 'SolutionBoards':
						headerEvent.isSolutionBoard = true;
						headerEvent.solutionBoardId = resource.groupId;
						break;
					case 'Milestones':
						headerEvent.isMilestone = true;
						headerEvent.milestoneId = resource.groupId;
						break;
					case 'kendisResponsible':
					case 'tfsResponsible':
					case 'jiraResponsible':
						headerEvent.isResponsible = true;
						headerEvent.responsibleId = resource.groupId;
						headerEvent.responsibleType = groupBy;
						break;
					case 'Project':
						headerEvent.isProject = true;
						headerEvent.projectId = resource.groupId;
						break;
					case 'AreaPath':
						headerEvent.isAreaPath = true;
						headerEvent.areaPathId = resource.groupId;
						break;
					case 'Iteration':
						headerEvent.isIteration = true;
						headerEvent.iterationId = resource.groupId;
						break;
				}
				
				// Add the header event to the scheduler
				scheduler.eventStore.add(headerEvent);
				
				// Create assignment between the event and resource
				scheduler.assignmentStore.add({
					id: `a-full-span-event-${groupId}`,
					resourceId: groupId,
					eventId: `full-span-event-${groupId}`,
					isDynamicallyCreated: true
				});
				
				console.log(`Created group header event: full-span-event-${groupId} for resource ${resource.id}`);
				
			} catch (error) {
				console.error(`Error creating group header event for resource ${resource.id}:`, error);
			}
		},

		/**
		 * Edits an unplanned item from the grid
		 * @param {string} recordId - The record ID of the unplanned item
		 */
		editUnplannedItem(recordId) {
			console.log(`Editing unplanned item: ${recordId}`);
			
			const itemId = recordId.split('_')[0];
			const item = this.itemsByIdMap[itemId];
			
			if (!item) {
				console.error('Item not found:', itemId);
				showBryntumToastMessage('Item not found', 'error');
				return;
			}

			// Get the full record from the unplanned grid store
			const fullRecord = this.$options.unplannedGrid.store.getById(recordId);
			
			if (!fullRecord) {
				console.error('Record not found in unplanned grid:', recordId);
				showBryntumToastMessage('Record not found', 'error');
				return;
			}

			// Prepare the item for editing
			const editingItem = _.cloneDeep(item);
			
			// Open the item popup for editing
			this.itemPopup.eventRecord = fullRecord;
			this.itemPopup.origin = itemPopupOrigins.UNPLANNED;
			this.itemPopup.item = editingItem;
			this.itemPopup.parent = undefined;
			
			// Determine the correct hierarchy level for the item
			let itemLevel = getHierarchyLevelForItem(fullRecord, this.itemsByIdMap, this.releaseTrain, this.store.backlogHierarchyLevels, this.currentHierarchyLevel);
			this.itemPopup.level = itemLevel;
			
			this.itemPopup.alm = undefined;
			this.itemPopup.tfsProjects = undefined;
			if (!_.isEmpty(this.store.almAccounts)) {
				this.itemPopup.alm = this.store.almAccounts[0];
			}
			if (this.store.tfsProjects) {
				this.itemPopup.tfsProjects = this.store.tfsProjects;
			}
			
			this.itemPopup.show = true;
		}
	},
	components: {
		'roadmap-settings':ROADMAP_SETTINGS,
		'treeselect' : VueTreeselect.Treeselect,
		VueAdsPagination: window["vue-ads-pagination"].default,
		VueAdsPageButton: window["vue-ads-pagination"].VueAdsPageButton,
		'action_popup': ACTION_POPUP,
		'add-milestone-board' : ADD_MILESTONE_TO_BOARD,
		'search_suggestions': SEARCH_SUGGESTIONS,
		'roadmap-progress': ROADMAP_PROGRESS,
		'time-period-popup': TIME_PERIOD_POPUP,
	}
});