
const iterationTreeStore = Pinia.defineStore('iterationTreeStore', {
	state() {
		return {
			selectedIterationId: "-1"
        }
	},
	getters: {
		getSelectedIterationId: function () {
			return this.selectedIterationId;
		}
	},
	actions: {
		setSelectedIterationId: function (iterationId) {
			this.selectedIterationId = iterationId;
		}
	},
});

const iterationTreeRow = Vue.component('vz-iteration-tree-row', {
		store: iterationTreeStore,
		template : `
		<div class="">
        	<div class="rec brd " :class="{'active':expand,'act-tick':($store.selectedIterationId == item.id)}">
        		<em v-if="item.children && item.children.length > 0" @click="onClickExpandSubItems" class="ti-angle-right arrd mr-10 c-point"></em> 
        		<div @click="onClickSelectItem" class="prow c-point">{{item.label}} <em class=" ml-10" :class="{'tick-grn':($store.selectedIterationId == item.id)}"></em></div>
        	</div>			
            <div v-if="expand" class="insd">
           		<vz-iteration-tree-row v-for="subItem in item.children" :item="subItem" @select="onSelectSubItem"></vz-iteration-tree-row>
            </div>			
		</div>
		`,
		
		props:  ["item"],
		
		computed: {
			
		},
		
		data() {
			return {
				expand: false,	
			}
		},
		watch: {
			
			
		},
		
		created () {
			
		},

		mounted: function () {
			
		},
		methods: {
			//////////////////////////////////////////////////
			///////////////    LOGIC
			onClickSelectItem: function (event) {
				event.stopPropagation();
				
				if (!this.item.project) {
					this.$store.setSelectedIterationId(this.item.id);
					this.$emit("select",this.item);
				}
			},
			onClickExpandSubItems: function (event) {
				event.stopPropagation();
				this.expand = !this.expand;
			},
			onSelectSubItem: function (item) {
				this.$emit("select",item);
			}
		}
	});
const iterationTree = Vue.component('vz-iteration-tree', {
		store: iterationTreeStore,
		template : `
		<div>
			<div class="overlay" style="display: block;"></div>
            <vuepopup @close="onClickOutside">
	            <div class="ui-dialog add-pop iteration-tree" style="display:block;">
	            	<div class="dialgtl">Search Iteration <em class="rmv-ico ti-close" @click="onClickCloseButton" style="color:#000"></em></div>
	            	<div class="cntr table">
		            	<div v-if="loader.show" class="loader"><div class="aa"><div class="loaderinteg"></div><div v-html="loader.text"></div></div></div>	            	
						<div class="wbox prow"><vz-iteration-tree-row v-for="sp in allSprints" :key="sp.id" :item="sp" @select="onSelectSprint" /></div>
					</div>
				</div>
			</vuepopup>
		</div>
		`,
		
		props:  ["almAccount","tfsProject","sprints"],
		
		computed: {
			/*buttonTitle: function () {
				
			},*/
		},
		
		data() {
			return {
				loader: {
					show:false,
					text:""
				},
				allSprints:[]
			}
		},
		watch: {
			/*'users':  {
				handler (val, oldVal) {
					this.copyUsers = JSON.parse(JSON.stringify(val));
					this.onSetUsers();
		        },
		        deep: true,
	            immediate: true
			},*/
		},
		
		created () {
			if (_.isEmpty(this.sprints)) {
				this.loadAllSprints();
			}
			else {
				this.allSprints = this.sprints;
			}
		},

		mounted: function () {
			
		},
		methods: {

			//////////////////////////////////////////////////
			///////////////    LOGIC
			convertTFSSprintDate: function(dateStr) {
				var parts = dateStr.split(/[- : T]/);
				//2023-05-20
				if (parts.length >= 3) {
					return parts[2] + "/" + parts[1] + "/" + parts[0];
				}
				else {
					let sDate = new Date(dateStr);
					return dateFormat(sDate, "d/mm/yy");
				}
			},
			convertTreeEntries: function(enteries) {
				_.each(enteries, entry => {
					if (entry.identifier) {
						entry.id = entry.identifier;
					}
					if (entry.attributes) {
						let label = entry.name;
						let startDate = entry.attributes.startDate;
						let endDate = entry.attributes.finishDate;
						if (!_.isEmpty(startDate) && !_.isEmpty(endDate)) {
							let sDateStr = this.convertTFSSprintDate(startDate);
							let eDateStr = this.convertTFSSprintDate(endDate);
							label += " (" + sDateStr + " - " + eDateStr + ")";
						}
						entry.label = label;
					}
					else {
						entry.label = entry.name;
					}

					entry.isDisabled = false;
					if (entry.children) {
						this.convertTreeEntries(entry.children);
					}
				});
			},
			loadAllSprints: function() {
				this.loader.text = 'Loading Sprints...' + getAlmUserInfoBoard(true);
				this.loader.show = true;

				var _this = this;

				axios.get('/pi/tfssprints/' + this.almAccount.id + '/' + this.tfsProject.tfsId)
					.then(response => {
						_this.loader.show = false;

						if (response.data) {
							if (response.data.success) {
								if (response.data.sprints) {
									var root = JSON.parse(response.data.sprints);
									root.project = true;
									let sprints = [];
									sprints.push(root);
									
									_this.convertTreeEntries(sprints);
									_this.allSprints = sprints;
									_this.$emit("spints-loaded",sprints);
								}
							}
							else {
								if (response.data.almError) {
									showTfsAlmRequestError(response.data.almError, "", "", false); // errorResponse , text, heading, isProfile, callback
								}
							}
						}
					})
					.catch(error => {
						_this.loader.show = false;
					});
			},
			//////////////////////////////////////////////////
			///////////////    EVENTS
			onClickOutside: function () {
				this.$emit("close");
			},
			onClickCloseButton: function () {
				this.$emit("close");
			},
			onSelectSprint: function (sprint) {
				if (sprint.project) {
					
				}
				else {
					this.$emit("select",sprint);
				}
			}
			
		}
	});






