const COLOR_PICKER = Vue.component('color-picker',{

	template : `
	<div class="evo-pop p-abs aa">
		    <span>
			<table class="evo-palette">
			<tbody>
				<template v-if="!groupsEnabled">
					<tr class="ht">
						<th colspan="10" class="ui-widget-content a">Theme Colors</th>
					</tr>
					<tr>
						<td v-for="color in $options._colors" v-bind:style="{ backgroundColor: color}" @click="onSelectColor(color)"><span></span></td>
					</tr>
				</template>
				<template v-else>
					<template v-for="group in $options._colors">
						<tr class="ht">
							<th colspan="10" class="ui-widget-content b" style="display:block;">{{group[groupLabel]}}</th>
						</tr>
						<tr>
							<td v-for="color in group[groupValues]" v-bind:style="{ backgroundColor: color}" @click="onSelectColor(color)"><span></span></td>
						</tr>
					</template>
				</template>
			</tbody>
			</table>
			</span>
		</div>
	</div>
	`,
	props:  {
		value: {
			type: String,
			default: () => { return undefined }
		},
		colors: {
			type: Array,
			default: () => { return [] }
		},
		groupBy: {
			type: String,
			default: () => { return 'title' }
		},
		groupValues: {
			type: String,
			default: () => { return 'items' }
		},
		groupLabel: {
			type: String,
			default: () => { return 'title' }
		},
		groupsEnabled: {
			type: Boolean,
			default: () => { return false }
		},
	},
	data() {
		return {
			
		}
	},
	model: {
	    event: `select`
	},
	_colors : [],
	created() {
		
		if (_.isEmpty(this.colors)) {
			var colors;
			if (this.groupsEnabled) {
				colors = [{
					title: "Dark",
					items: ["#1b1721", "#db6139", "#72c4bc", "#725292", "#d6923d", "#0f2b4e", "#b13f66", "#44947d", "#3389ca", "#4e5248", "#e0d16a", "#221763"]
				}, {
					title: "Light",
					items: ["#ffffff", "#eddfff", "#e7e6b2", "#eed5b3", "#bed1e1", "#c8e3d9", "#e1dfc3", "#f3c0d1", "#beecff", "#eae4d8", "#d5fbfb", "#f1f0f1"]
				}];
			} else {
				colors = [
					"#1991eb", "#f85359", "#6b47db", "#f9bf3b",
					"#0747a6", "#34495e", "#2ecc71", "#db0a5b", "#674172",
					"#4ecdc4", "#f39c12", "#1c2227", "#446cb3", "#d2527f",
					"#e87e04", "#019875", "#6c7a89", "#9a12b3", "#3a539b",
					"#1e824c", "#c6a21a", "#336e7b", "#c0392b", "#013243"
				];
			}
			this.$options._colors = colors;
		} else {
			this.$options._colors = this.colors;
		}
	},
	methods: {

		onSelectColor : function (color) {
			this.$emit('select',color);
		}

	}

});

const COLOR_PICKER_BUTTON = Vue.component('color-picker-button',{
	template : `
	<div>
		<div class="evo-cp-wrap" @click="onShowPopup">
			<div class="evo-pointer evo-colorind" @click="onShowPopup" :style="{'backgroundColor':value ? value : emptyColor}"></div>
		</div>
		<vuepopup v-if="show" @close="show=false;" :style="colorContainerStyles" class="evo-out">
		<div class="evo-pop p-fix bb">
			<div class="hd">
				<strong>Choose Colors</strong> 
				<div v-if="showResetOption">
					<div title="Reset" class="resetBtn c-point" @click="$emit('reset');show=false;"></div>
				</div>
				<a v-if="!showMoreColors" @click="onShowMore" href="javascript:void(0);" class=" button-w mrbtn a1">More Colors</a> </div>
			<div class="evo-cont">
				<div v-show="showMoreColors">
					<div class='custom-colors'></div>
					<div class="btmcl prow">
					    <div :style="{backgroundColor:colorCode}" class="clr bx FL mr-10"> </div>
						<input v-model="colorCode" class='custom-selected-clr inp FL mr-10' type='text' value='' @input="onChangeColorCodeText"/>
						<a href="javascript:void(0);" @click="onSaveColor" class="button FL">Save</a>
					</div>
				</div>
			
				<table class="evo-palette">
					<tbody>
						<template v-if="!groupsEnabled">
							<tr>
								<td v-for="color in $options._colors" v-bind:style="{ backgroundColor: color}" @click="onSelectColor(color)"><span></span></td>
							</tr>
						</template>
						<template v-else>
							<template v-for="group in $options._colors">
								<tr class="ht">
									<th colspan="10" class="ui-widget-content bb" style="display:block;">{{group[groupLabel]}}</th>
								</tr>
								<tr>
									<td v-for="color in group[groupValues]" v-bind:style="{ backgroundColor: color}" @click="onSelectColor(color)"><span></span></td>
								</tr>
							</template>
						</template>
					</tbody>
				</table>
			</div>
							
		</div>
		</vuepopup>
	</div>
	`,
	props: {
		value: {
			type: String,
			default: () => { return undefined }
		},
		emptyColor: {
			type: String,
			default: () => { return "#ffffff" }
		},
		showResetOption: {
			type: Boolean,
			default: () => { return false }
		},
		colors: {
			type: Array,
			default: () => { return [] }
		},
		groupBy: {
			type: String,
			default: () => { return 'title' }
		},
		groupValues: {
			type: String,
			default: () => { return 'items' }
		},
		groupLabel: {
			type: String,
			default: () => { return 'title' }
		},
		groupsEnabled: {
			type: Boolean,
			default: () => { return true }
		},
		colorContainerStyles: {
			type: Object,
		},
        editPermission: {
            type: Boolean,
            default() {
                return true;
            }
        }
	},
	data() {
		return {
			show: false,
			colorCode: "",
			showMoreColors: false,
			_value : "",
		}
	},
	model: {
		prop: "value",
		event: "select"
	},
	watch: {
		"value": {
			handler(newValue, oldValue) {
				this._value = newValue;
			},
			immidiate: true
		}
	},
	_colors : [],
	mounted () {
		
	},
	created() {
		this._value = this.value;
		if (_.isEmpty(this.colors)) {
			var colors;
			if (this.groupsEnabled) {
				colors = [{
					title: "Dark",
					items: ["#1b1721", "#db6139", "#72c4bc", "#725292", "#d6923d", "#0f2b4e", "#b13f66", "#44947d", "#3389ca", "#4e5248", "#e0d16a", "#221763"]
				}, {
					title: "Light",
					items: ["#ffffff", "#eddfff", "#e7e6b2", "#eed5b3", "#bed1e1", "#c8e3d9", "#e1dfc3", "#f3c0d1", "#beecff", "#eae4d8", "#d5fbfb", "#f1f0f1"]
				}];
			} else {
				colors = [
					"#1991eb", "#f85359", "#6b47db", "#f9bf3b",
					"#0747a6", "#34495e", "#2ecc71", "#db0a5b", "#674172",
					"#4ecdc4", "#f39c12", "#1c2227", "#446cb3", "#d2527f",
					"#e87e04", "#019875", "#6c7a89", "#9a12b3", "#3a539b",
					"#1e824c", "#c6a21a", "#336e7b", "#c0392b", "#013243"
				];
			}
			this.$options._colors = colors;
		} else {
			this.$options._colors = this.colors;
		}
	},
	methods: {
		onSelectColor : function (color) {
			this._value = color;
			this.$emit('select',color);
			this.show = false;
			this.showMoreColors = false;
		},
		onShowPopup: function () {
            if (this.editPermission) {
                this.show = true;
            }else{
                showTopMessage("You don't have permission to edit this item.", 'warning');
            }
		},
		onChangeColorCodeText: function () {
			$(_this.$el).find(".custom-colors").colorpicker("val", this.colorCode);
		},
		onSaveColor: function () {
			if (/^#[0-9a-f]{3}([0-9a-f]{3})?$/i.test(this.colorCode)) {
				this._value = this.colorCode;
				this.$emit('select',this.colorCode);
				this.show = false;
				this.showMoreColors = false;
			}
		},
		onShowMore: function () {
			this.showMoreColors = true;
			var _this = this;
			Vue.nextTick(function() {
				$(_this.$el).find(".custom-colors").colorpicker({
					color: _this._value,
					inline: true,
					defaultPalette: 'web'
				}).on("change.color", function(event, color){
    				_this.colorCode = color;
				});
			});
		}
	}

});

(function ( $ ) {
    $.fn.vzcolorpicker = function( options ) {
        // Default options
	
        var settings = $.extend({
			color:"#ffffff",
			colors: [],
			groupValues: "items",
			groupLabel : "title",
			groupsEnabled: true,
		}, options );
		if (options == "val") {
			return this.find(".picker-button").attr("val");
		}
		if (settings.colors.length == 0) {
			if (settings.groupsEnabled) {
				settings.colors = [{
					title: "Dark",
					items: ["#1b1721", "#db6139", "#72c4bc", "#725292", "#d6923d", "#0f2b4e", "#b13f66", "#44947d", "#3389ca", "#4e5248", "#e0d16a", "#221763"]
				}, {
					title: "Light",
					items: ["#ffffff", "#eddfff", "#e7e6b2", "#eed5b3", "#bed1e1", "#c8e3d9", "#e1dfc3", "#f3c0d1", "#beecff", "#eae4d8", "#d5fbfb", "#f1f0f1"]
				}];
			}else {
				settings.colors = [
					"#1991eb", "#f85359", "#6b47db", "#f9bf3b",
					"#0747a6", "#34495e", "#2ecc71", "#db0a5b", "#674172",
					"#4ecdc4", "#f39c12", "#1c2227", "#446cb3", "#d2527f",
					"#e87e04", "#019875", "#6c7a89", "#9a12b3", "#3a539b",
					"#1e824c", "#c6a21a", "#336e7b", "#c0392b", "#013243"
				];
			}
		}

		//.....  remove button if already added
		var existingButtonInRoot    = this.find(".picker-button");
		var existingContainerInRoot = this.find(".picker-container");
		if (existingButtonInRoot) {
			existingButtonInRoot.remove();
		}
		if (existingContainerInRoot) {
			existingContainerInRoot.remove();
		}

		var mainComponent = "<div class='picker-button evo-pointer evo-colorind' style='background-color: "+settings.color+";' val='"+settings.color+"'> </div><div class='picker-container'></div>";
		this.append(mainComponent);

		$(this).find(".picker-button").click(function () {
			var html = "";

			var containerDiv = $(this.parentNode).find(".picker-container");

			if (containerDiv.is(':empty')) {

				html += '<div class="evo-pop p-fix cc">';
				html += "<div class='hd'><strong>Choose Colors</strong></div> <a href='javascript:void(0);' class='more-button button-w mrbtn a2'>More Colors</a>";
				html += '<div class="evo-cont">';
					html += '<div class="more-colors-section"></div>';
					html += '<table class="evo-palette">';
					if (!settings.groupsEnabled) {
						html += '<tr>';
					}
					for (var i = 0; i < settings.colors.length; i++) {
						if (settings.groupsEnabled) {
							var group = settings.colors[i];
		
							html += '<tr class="ht">';
								html += '<th colspan="10" class="ui-widget-content" style="display:block;">' + group[settings.groupLabel] + '</th>';
							html += '</tr>';
		
							html += '<tr>';
							for (var j = 0; j < group[settings.groupValues].length; j++) {
								var color = group[settings.groupValues][j];
								html += '<td class="color-option" style="background-color: '+color+';" val="'+color+'" ></td>'
							}
							html += '</tr>';
		
						} else {
							var color = settings.colors[i];
							html += '<td class="color-option" style="background-color: '+color+';" val="'+color+'" ></td>'
						}
					}
					if (!settings.groupsEnabled) {
						html += '</tr>';
					}
					html += "</table>";				
				html += "</div></div>";
				containerDiv.append(html);
			}

			var mainComponent = this;
			$(mainComponent.parentNode).on("click", function (event) {
				if (event.target && event.target.className == 'color-option') {
					var color = event.target.getAttribute("val");
					settings.color = color;
					$(mainComponent.parentNode).find(".picker-button").attr("style",("background-color:"+settings.color+";"));
					$(mainComponent.parentNode).find(".picker-button").attr("val",settings.color);
					$(mainComponent.parentNode).find(".picker-container").empty();

					$( mainComponent.parentNode ).trigger( "change.vzcolor", color );
				}
				if (event.target && event.target.className == 'more-button button-w mrbtn a2') {

					var container = event.target.parentNode;
			        var subContainer = $(event.target.parentNode).find(".more-colors-section");
					
					var color = $(mainComponent).attr("val");
					var _html = "<div class='custom-colors'></div>";
					_html += '<div class="btmcl prow">'
						_html += "<div class='custom-selected-clr-ind clr bx FL mr-10' style='background-color:"+color+";'> </div>"
						_html += "<input class='custom-selected-clr inp FL mr-10' type='text' value='"+color+"'/>"
						_html += "<a href='javascript:void(0);' class='save-color-btn button FL'>Save</a>"
					_html += "</div>"
					subContainer.html(_html);

					subContainer.find(".custom-colors").colorpicker({
						inline: true,
						defaultPalette: 'web'
					}).on("change.color", function(event, color){
						$(subContainer).find('.custom-selected-clr').val(color);
						$(subContainer).find('.custom-selected-clr-ind').attr("style",("background-color:"+color+";"));
					});

					$(subContainer).find('.save-color-btn').on("click", function (event) {
						var val = $(subContainer).find('.custom-selected-clr').val();
						if (/^#[0-9a-f]{3}([0-9a-f]{3})?$/i.test(val)) {
							$(mainComponent).attr("val", val);
							$(mainComponent).attr("style",("background-color:"+val+";"));
							$(mainComponent.parentNode).find(".picker-container").empty();
							$( mainComponent.parentNode ).trigger( "change.vzcolor", color );
						}
					});
					event.target.style.display = "none";					
				}
			});
			mainComponent.parentNode.clickOutsideEvent = function (event) {
				var condition1 = mainComponent == event.target;
				var condition2 = mainComponent.parentNode.contains(event.target);
				if (!(condition1 || condition2)) {
					$(mainComponent.parentNode).find(".picker-container").empty();
				}
			};
			document.body.addEventListener('click', mainComponent.parentNode.clickOutsideEvent);
			
			var $dialog = containerDiv.closest('.ui-dialog');
			if($dialog.length > 0){
				adjustDivOffset(containerDiv.find('.evo-pop'), containerDiv, $dialog);
			}
			
		});

        // Apply options
        return this;
    };
}( jQuery ));



