
let TIME_CAPSULE_SELECTOR_COMPONENT = Vue.component('time-capsule-selector', {
    template: `
      <div class="time-capsule-selector">
    <div class="tabs">
      <a class="tab fstb" :class="{ active: activeTab === 'quarterly' }" @click="activeTab = 'quarterly'">Quarterly</a>
      <a class="tab fstb" :class="{ active: activeTab === 'halfYear' }" @click="activeTab = 'halfYear'">Half-Year</a>
      <a class="tab fstb" :class="{ active: activeTab === 'year' }" @click="activeTab = 'year'">Year</a>
      <a class="tab fstb" :class="{ active: activeTab === 'custom' }" @click="activeTab = 'custom'">Custom</a>
        
    </div>
    <div class="time-capsules">
      <div v-for="(capsule, index) in filteredTimeCapsules[activeTab]" :key="index" class="time-capsule mb-10" :style="{ backgroundColor: capsule.bgColor}">
        <div @click = "onTimeCapsuleSelection(capsule)" class="capsuleItem">{{ capsule.label }}</div>
      </div>
    </div>
  </div>`,
    props: {
        configuredTimeCapsules: {
            type: Array,
            default: undefined
        },
        selectedTimeCapsuleId:{
            type: String,
            default: undefined
        }
    },
    data() {
        return {
            activeTab: 'quarterly',
            timeCapsules: []
        }
    },
    methods: {
        fetchTimeCapsules() {
            return axios.get("/time-capsule/get-time-capsules").then(response => {
                let timeCapsules = response.data.timeCapsules;
                //convert the dates to date objects
                for(let timeCapsule of timeCapsules) {
                    timeCapsule.startDate = new Date(timeCapsule.startDate);
                    timeCapsule.endDate = new Date(timeCapsule.endDate);
                }
                this.timeCapsules = timeCapsules;
                if(this.selectedTimeCapsuleId!=undefined){
                    let selectedCapsule = this.timeCapsules.find(capsule => capsule.id == this.selectedTimeCapsuleId);
                    this.onSelectedTimeCapsuleLoaded(selectedCapsule);
                }else {
                    this.onSelectedTimeCapsuleLoaded({});
                }
            });
        },
        onTimeCapsuleSelection(capsule) {
            this.$emit('time-capsule-selected', capsule);
        },
        onSelectedTimeCapsuleLoaded(capsule) {
            this.$emit('selected-time-capsule-loaded', capsule);
        }
    },
    mounted() {
        if(this.configuredTimeCapsules==undefined ) {
            this.fetchTimeCapsules();
        }else{
            this.timeCapsules = this.configuredTimeCapsules;
        }

    },
    created() {
    },
    computed: {
        filteredTimeCapsules() {
            let filteredTimeCapsules = {
                quarterly: [],
                halfYear: [],
                year: [],
                custom: []
            };
            for(let timeCapsule of  this.timeCapsules) {
                let startDate = new Date(timeCapsule.startDate);
                let endDate = new Date(timeCapsule.endDate);
                if(isQuarter(startDate, endDate)) {
                    filteredTimeCapsules.quarterly.push(timeCapsule);
                }
                else if(isHalfYear(startDate, endDate)) {
                    filteredTimeCapsules.halfYear.push(timeCapsule);
                }
                else if(isYear(startDate, endDate)) {
                    filteredTimeCapsules.year.push(timeCapsule);
                }else{
                    filteredTimeCapsules.custom.push(timeCapsule);
                }
            }
            return filteredTimeCapsules;
        }
    },
    watch: {},
});