const SUB_BATCH_COMPONENT = Vue.component('sub-batch-component', {
    mixins: [MILESTONE_MIXIN, OBJECTIVE_MIXIN],
    props: {
        objective: {
            type: Object, 
			default: () => {
                return {};
            }
        }, 
        okrList: {
            type: Array,
            default: () => {
                return [];
            }
        },
        groupId: {
            type: String,
            default: () => {
                return "";
            }
        },
        parentColor:{
            type: String,
            default: () => {
                return "";
            }
        },
        parentBatch:{
            type: Object,
            default: () => {
                return {};
            }
        },
    },

    template: `
		<span class="prow" >
				<div :style="style" class="rec child" :class="[objective.showChildren?'active':'']">
					<div class="rc c2" :title="objective.title">
						<div class="move sortable-handle value-sortable-handle"></div>
						<em v-if="objective.baseItemList && !_.isEmpty(objective.baseItemList)" class="ti-angle-right arrdn c-point"  @click="objective.showChildren=!objective.showChildren ; changeShowChildrenOnRoot(objective.showChildren)"></em>
						<div class="tlout"><router-link :to="pathToBatch" class="mr-5" v-html ="getKey"> </router-link>
						<span class="ttl"  v-html="getTitle"> </span>
<!--						<span class="ttl">{{objective.title}}  </span>-->
						</div>
					</div>
					<div  class="rc c3">
                        <span v-if="$root.flags.isBatchCompletionMapLoaded">
                            <div v-if="!$root.batches.batchCompletionMap[objective.id]" class="progrs-bar DFA  pt-5 batchProgrsBar batchListProgressBar">
                                <div class="bar batchBar mr-10 ">
                                    <div class="bn" style="width:0%"></div>
                                </div> 
                                <div class="">
                                    0%
                                </div> 
                            </div>
                            <div v-else class="progrs-bar DFA pt-5 batchProgrsBar batchListProgressBar">
                                <div class="bar batchBar mr-10">
                                    <div class="bn" :style="{width:(batchCalculation(objective.id, objective.fields.selectedCriteria)+'%')}"></div>
                                </div> 
                                <div class="">{{batchCalculation(objective.id, objective.fields.selectedCriteria)+'%'}}</div>
                            </div>
                        </span>
                        <span v-else>
                            <div class="minldr">
                                <div class="loaderinteg"></div>
                            </div>
                        </span>
		    	    </div>
					<div class="rc c3">		    	  
					  <multiple-users-display-component :batch-responsibles-objects="batchResponsiblesObjects" ></multiple-users-display-component>
                    </div>
                    <div class="rc c3"><div class="pt-5">{{startDate}}</div></div>
                    <div class="rc c3"><div class="pt-5">{{endDate}}</div></div>
					<div class="rc c4 status"><span class="sts pt-5 btchsts" v-bind:class="{ a: objective.status.category=='ToDo',b: objective.status.category=='InProgress',c: objective.status.category=='Done' }">{{objective.status.title}}</span></div>
					 <div v-if="$options.permissions.MANAGE_BATCH_GROUP || $options.permissions.ADD_EDIT_BATCH" class="rc c3 DF"
                         @mouseover="createSubBatchOption = true"
                         @mouseleave="createSubBatchOption = false">
				    <a v-if = "createSubBatchOption" class="ti-plus addf pt-5 c-point wht-nwrp" @click.stop="onAddSubBatchClick">
                        Create Sub-Batch
				    </a>
				 </div>
					<!-- <div class="r-icons DFA"><a href="javascript:void(0);" @click="onAddSubBatchClick" class="ti-plus addf ml-20">Add</a></div> -->
					  <em v-if="$options.permissions.MANAGE_BATCH_GROUP || $options.permissions.ADD_EDIT_BATCH" class="ti-more-alt menu icoa DAJ" @click.stop="onClickShowMenuPopup"></em>
                      <vuepopup v-if="showMenuOverlay" @close="showMenuOverlay=false">
                         <div class="drop_box nwmu artp sml" style="display:block">
                              <ul>
                                <template>
                                     <li class="c-point" @click.stop="onAddSubBatchClick">Add Sub-Batch</li>
                                </template>                      
                              </ul>
                         </div>
                      </vuepopup>
				</div>
				
				<div v-show="isSubBatchComponentValidToShowChildren()">
				<div class="aa child">
				<draggable :value="sortedChildren"
							    animation=150 easing="cubic-bezier(1, 0, 0, 1)"
								@start="onItemDragStart"
								@end="onItemDragEnd" >
                    <sub-batch-component v-for="okrItem in sortedChildren"
                        @onSaveEditBatch="onSaveSubBatch"
                        :key="okrItem.id"
                        :objective="okrItem"
                        :okr-list="objective.baseItemList" 		
                        :group-id="objective.id"
                        :parent-color="parentColor"	
                        :parent-batch="objective"									
                    />
				</draggable>
				</div>
				</div>
			<dynamic-popup-container 
				v-if="itemTemplate.showEditPopUp"
				@close = "onCLoseEditPopUp"
				@save = "onSaveEditObjectiveData"
				@saved-batch-criteria="onSaveBatchCompletionCriteria"
				:template-to-render="itemTemplate.templateToRenderer"
				:template-statuses = "itemTemplate.statuses"
				:item-type="itemTemplate.itemType"
				:fields-value="itemTemplate.model"
				:template = "itemTemplate"
				:show-notify-watchers="false"
				:show-attachments="false"
				:show-watchers="true"
				:show-history="true"
				:show-conversations="true"
				:entity-type="'BaseItem'"
				:entity-id="itemTemplate.id"
				:showBoardLinking="true"
				:displayMode ="'Batches'"
				:showObjectiveLinking="true"
				:edit-permission="true"
				:showNotifyWatchers="false"
				/>
		</span>
	`,


    data() {
        return {
            newOkr: {
                title				: ""
            },
            itemTemplate: {
                showEditPopUp: false,
                showMileStonePopup: false,
                templateToRenderer: {},
                statuses: [],
                itemType: {}
            },
            objectiveData					: '',
            editObjectiveData				: '',
            showMenuOverlay					: false,
            showEditView					: false,
			showObjectiveLinkingPopup		: false,
            isEditCustomObjectiveInputValid	: true,
			objectiveGroups					: [],
            dynamicOkrItemKey               : 0,
            showMenuOverlay: false,
            createSubBatchOption: false,
        }
    },
components:{
    'multiple-users-display-component':MultipleUsersDisplayComponent,

},
    watch: {
        showEditView: function (_new, _old) {
            if (_new) {
                this.$nextTick(() => {
                    const element = this.$refs.editObjectiveTitle;
                    element.focus();
                });
            }
        },
        '$root.batches.expandAll': {
            handler: function(expandAll) {
                this.objective.showChildren = true;
                this.changeShowChildrenOnRoot(true);
            },
        },
        '$root.batches.minimizeAll': {
            handler: function(minimizeAll) {
                this.objective.showChildren = false;
                this.changeShowChildrenOnRoot(false);
            },
        }
    },

    computed: {
        batchResponsiblesObjects: function () {
            if(!_.isEmpty(this.$root.batches.fieldsData) && this.objective.id && this.objective.fields && !_.isEmpty(this.objective.fields)){
                for(let fieldId in this.objective.fields){
                    if(this.$root.batches.fieldsData[fieldId] && this.$root.batches.fieldsData[fieldId].title == 'Responsibles'){
                        //get full name of users
                        let responsibles = this.objective.fields[fieldId];
                        return responsibles;
                    }
                }
            }
        },
        pathToBatch() {
            let baseRoute=this.$route.path;
            if(baseRoute[baseRoute.length-1] != '/'){
                baseRoute = baseRoute+ '/';
            }
            return baseRoute+this.objective.key
        },
        style() {
            let style = {
                backgroundColor: this.parentColor ? this.parentColor + '10' : '',
            };
            if (this.parentColor && this.parentColor != '') {
                style.borderLeft = '5px solid ' + this.parentColor;
            }
            return style;
        },
        sortedChildren: function () {
            let _this = this;
            try {
                let unsortedBatchChildren = this.objective.baseItemList;
                //we change the sequence of the batches according to the links sequence so that the batches are sorted according to the sequence of the links
                //for the parent batch sort the main sequence of batch will be used
                if (unsortedBatchChildren) {
                    unsortedBatchChildren.forEach(batch => {
                        if (_this.batchChildrenSequenceMap) { //sequence map that reflects the sequence from baseItemLinks
                            batch.sequence = _this.batchChildrenSequenceMap[batch.id];
                        }
                    });
                    unsortedBatchChildren.sort(function (a, b) {
                        return a.sequence - b.sequence;
                    });
                    return unsortedBatchChildren;
                }
            }
            catch (e) {
                console.log("Error in sorting batch children");
            }
            return [];
        },
        batchChildrenSequenceMap: function() {
            let baseItemSequenceMap = {};
            let baseItem = this.objective;
            if (baseItem.baseItemLinks) {
                baseItem.baseItemLinks.forEach(function (link) {
                    if (link.linkType == "Child-Batch"
                        && link.baseItemId != ""
                        && link.baseItemId != null) {
                        baseItemSequenceMap[link.baseItemId] = link.sequence;
                    }
                });
            }
            return baseItemSequenceMap;
        },

        getTitle(){
            if(this.objective.highlightedText && !_.isEmpty(this.objective.highlightedText)){
                return this.objective.highlightedText;
            }else{
                return this.objective.title
            }
        },
        getKey(){
            if(this.objective.highlightedKey && !_.isEmpty(this.objective.highlightedKey)){
                return this.objective.highlightedKey;
            }else{
                return this.objective.key
            }
        },
        startDate: function () {
            if(!_.isEmpty(this.$root.batches.fieldsData) && this.objective.id && this.objective.fields && !_.isEmpty(this.objective.fields)){
                for(let fieldId in this.objective.fields){
                    if(this.$root.batches.fieldsData[fieldId] && this.$root.batches.fieldsData[fieldId].title == 'Start Date'){
                        return this.trimDate(this.objective.fields[fieldId]);
                    }
                }
            }
        },
        endDate: function () {
            if(!_.isEmpty(this.$root.batches.fieldsData) && this.objective.id && this.objective.fields && !_.isEmpty(this.objective.fields)){
                for(let fieldId in this.objective.fields){
                    if(this.$root.batches.fieldsData[fieldId] && this.$root.batches.fieldsData[fieldId].title == 'End Date'){
                        return this.trimDate(this.objective.fields[fieldId]);
                    }
                }
            }
        },
        batchResponsibles: function () {
            if(!_.isEmpty(this.$root.batches.fieldsData) && this.objective.id && this.objective.fields && !_.isEmpty(this.objective.fields)){
                for(let fieldId in this.objective.fields){
                    if(this.$root.batches.fieldsData[fieldId] && this.$root.batches.fieldsData[fieldId].title == 'Responsibles'){
                        //get full name of users
                        let responsibles = this.objective.fields[fieldId];
                        let responsiblesFullName = [];
                        if(responsibles && responsibles.length > 0){
                            responsibles.forEach(responsible => {

                                if(responsible){
                                    responsiblesFullName.push(responsible.fullName);
                                }
                            });
                        }

                        return responsiblesFullName;
                    }
                }
            }
        },
        batchCalculation() {
            return function (id, criteria) {
                if (!_.isEmpty(this.$root.batches.batchCompletionMap[id])) {
                    let value = 0;

                    if (criteria) {
                        if (criteria === 'r_st') {
                            value = this.$root.batches.batchCompletionMap[id].calculationByRollupStatus;
                        } else if (criteria === 'r_sp') {
                            value = this.$root.batches.batchCompletionMap[id].calculationByRollupEstimate;
                        } else if (criteria === 'c_st') {
                            value = this.$root.batches.batchCompletionMap[id].calculationByDoneChildren;
                        } else if (criteria === 'c_lis') {
                            value = this.$root.batches.batchCompletionMap[id].calculationByLinkedItems;
                        }
                        return value > 0 ? value.toFixed(2) : 0;
                    } else {
                        value = this.$root.batches.batchCompletionMap[id].calculationByLinkedItems ? this.$root.batches.batchCompletionMap[id].calculationByLinkedItems : 0;
                        return value;
                    }
                }
                return 0;
            }
        },
    },

    created() {
		this.$options.permissions = kendisStore.getters.getBatchesPermissions();
    },

    mounted() {
        this.objectiveData = this.objective;
        let baseRoute=this.$route.path;
        if(baseRoute[baseRoute.length-1] != '/'){
            baseRoute = baseRoute+ '/';
        }
		if(this.objectiveData.type == "Batch") {
	        this.objectURL = {path : baseRoute+this.objective.key, query : {groupId : this.groupId}}; 			
		}else{
			this.objectURL = baseRoute+this.objective.key
		}

    },

    methods: {
        changeShowChildrenOnRoot(showChildren){
            try {
                if (this.$root.batches.keyMap[this.objective.id]) {
                    this.$root.batches.keyMap[this.objective.id].showChildren = showChildren;
                }
            }catch (e) {
                console.log("Error in changing show children on root")
            }
        },
        onItemDragEnd: function(evt) {
            this.sortLinkedBatch(evt.newIndex, evt.oldIndex);
        },
        onItemDragStart: function(evt) {

        },
        calculateNewSequenceOfItem: function(newIndex, oldIndex, list, key) {
            var sequence;
            if (_.isEmpty(list)) {
                sequence = 0;
            } else {
                if (newIndex == 0) {
                    var nextItem = list[0]
                    sequence = nextItem[key] - 1000;

                } else if (newIndex >= list.length - 1) {
                    var preItem = list[list.length - 1];
                    sequence = preItem[key] + 1000;

                } else {

                    var preItem;
                    var nextItem;

                    if (oldIndex == -1 || oldIndex > newIndex) {
                        preItem = list[newIndex - 1];
                        nextItem = list[newIndex];
                    }
                    else {
                        preItem = list[newIndex];
                        nextItem = list[newIndex + 1];
                    }

                    sequence = (parseFloat(preItem[key]) + parseFloat(nextItem[key])) / 2.0;
                }
            }
            return { value: sequence, key: key };
        },
        sortLinkedBatch: function(newIndex, oldIndex) {

            var _this = this;
            var linkedBatch =  this.objective;

            var item = this.sortedChildren[oldIndex];
            var sequenceObject = this.calculateNewSequenceOfItem(newIndex, oldIndex, this.sortedChildren, "sequence");
            // value, key

            var data = {};
            data.linkedBatchId = item.id;
            data.sequence = "" + sequenceObject.value;
            data.batchId= linkedBatch.id;
            // this.loading=true;
            axios.post('/batch/update-linked-child-batches-sequence/'+syncId, data)
                .then(res => {

                    if (res.status=="200") {

                        item.sequence = data.sequence;
                        linkedBatch.baseItemLinks.forEach(function (link) {
                            if (link.linkType == "Child-Batch" && link.baseItemId == item.id) {
                                Vue.set(link, "sequence", data.sequence);
                            }
                        });

                    }else{
                        onAlmError(res.data.error);
                    }
                    // _this.loading=false;

                }).catch(error => {
                // _this.loading=false;
                console.log(error)
            });
        },
        onClickShowMenuPopup: function () {
            this.showMenuOverlay = !this.showMenuOverlay;
        },
        trimDate(dataTime){
            if(dataTime instanceof Date){
                return dataTime.toISOString().substring(0,10);
            }
            return dataTime.substring(0,10);
        },
        isSubBatchComponentValidToShowChildren : function () {
            return  this.objective.baseItemList!=undefined  && this.objective.showChildren;
        },
        fetchlinkedItemsCount: function (){
            let itemCount =0;
            this.objective.baseItemLinks.forEach(link=>{
                if(link.itemId && link.itemId!=""){
                    itemCount = itemCount + 1;
                }
            });
            if(itemCount==0){
                itemCount="-";
            }
            return itemCount;
        },
        onCLoseEditPopUp: function () {
            let _this = this;
            _this.itemTemplate.showEditPopUp = false;
            _this.$forceUpdate();
        },
        onCloseEditObjective: function () {
            this.itemTemplate.showEditPopUp = false;
            this.$forceUpdate();
        },
        moveNext: function (option) {
            let _this = this;
            _this.$nextTick(() => {
                const element = _this.$refs[option];
                element.focus();
            });
        },
        saveLinkedItems: function (items) {
            let _this = this;
            let itemContainers = [];
            let linkedItemMap = {};
            _.each(_this.objectiveData.baseItemLinks, link => {
                if (link.itemId) {
                    linkedItemMap[link.itemId] = link;
                }
            });
            _.each(items, item => {
                let itemContainer = {};
                if (linkedItemMap[item.id]) {
                    itemContainer.id = linkedItemMap[item.id].id;
                }
                itemContainer.sessionId = item.sessionBoards[0].session.id;
                itemContainer.itemId = item.id;
                itemContainers.push(itemContainer);
            });
            _this.updateLinkedBaseItems(itemContainers, undefined, _this.board.session.id, items);
        },
        updateLinkedBaseItems: function (itemContainers, impdtId, sessionId, items) {
            let _this = this;
            let requestBody = {};
            if (_.isEmpty(impdtId)) {
                requestBody.id = _this.objectiveData.id;
            } else {
                requestBody.id = impdtId;
            }
            requestBody.baseItemLinks = itemContainers;
            let url = '';
            if (sessionId) {
                url = '/sos/update-base-item-   links/' + syncId + '/' + sessionId;
            }
            axios.post(url, requestBody)
                .then(response => {
                    if (response.data.savedImpediment) {
                        showTopMessage("Items Linked Successfully.", "success");
                        _this.updateItemListing();
                    }
                })
                .catch(error => {
                    console.error("Item linking error", error);
                    handleSoSErrorMsg(error);
                });

        },
        onClickShowMenuPopup: function () {
            this.showMenuOverlay = true;
        },
        deleteObjective: function () {
            this.$emit("deleteObjective", this.objective, this.groupId);
        },
        onSaveEditObjectiveData: function (objective) {
            this.showEditView = false;
            let data = this.editObjectiveData;
            if(this.itemTemplate.showEditPopUp) {
                data = objective;
                if(this.isInlineEditingEnabled) {
                    this.itemTemplate.showEditPopUp = false;
                }
            }
            if(data.itemType.title == "Batch") {
                this.onSaveSubBatch(objective);
            }
        },
        openModalForEditing: function (objective) {
            let _this = this;
			axios.get('batch/get-batch-by-id/'+objective.id)
			.then(response=>{
				if(response.status == "200" && response.data && response.data.objective) {
		            let baseItem = response.data.objective;
		            _this.itemTemplate = {};
		            _this.itemTemplate.model = {};
		            _this.itemTemplate.model.fields = {};
					_this.itemTemplate.statuses = [];
					
				    _this.itemTemplate.templateToRenderer = kendisStore.getters.getBatchTemplate().scheme.fieldsTemplate;

                    if(baseItem.type=="Batch"){
                        _this.itemTemplate.statuses = kendisStore.getters.getBatchTemplate().statuses;
                    }else{
                        _this.itemTemplate.statuses = kendisStore.getters.getBatchGroupTemplate().statuses;
                    }
		            _this.itemTemplate.id = baseItem.id;
		            _this.itemTemplate.model = {};
		            _this.itemTemplate.model.id = baseItem.id;
		            _this.itemTemplate.model.title = baseItem.title;
		            _this.itemTemplate.model.bvPlan = baseItem.bvPlan;
		            _this.itemTemplate.model.bvActual = baseItem.bvActual;
		            _this.itemTemplate.model.key = baseItem.key;
                    if (baseItem.status) {
                        _this.itemTemplate.model.status = baseItem.status;
                    }
		            if (baseItem.fields) {
		                _this.itemTemplate.model.fields = baseItem.fields;
		            }
					if(baseItem.baseItemList) {
						_this.itemTemplate.model.baseItemList = baseItem.baseItemList;
					}
		            if (baseItem.fieldsTemplate) {
		                _this.itemTemplate.templateToRenderer = baseItem.fieldsTemplate;
		            }
		            if (baseItem.baseItemLinks) {
		                _this.itemTemplate.model.baseItemLinks = baseItem.baseItemLinks;
		            }
		            if (baseItem.itemTypeList) {
		                _this.itemTemplate.itemTypeList = baseItem.itemTypeList;
		            }
		            _this.itemTemplate.model.linkedItemObject = {};
		            if (baseItem.id) {
		                _this.itemTemplate.model.linkedItemObject.id = baseItem.id;
		            }
		            if (baseItem.linkedItemsIds) {
		                _this.itemTemplate.model.linkedItemObject.linkedItemsIds = baseItem.linkedItemsIds;
		            }
		            if (baseItem.linkedItems) {
		                _this.itemTemplate.model.linkedItemObject.linkedItems = baseItem.linkedItems;
		            }
		            if (baseItem.linkedItemsById) {
		                _this.itemTemplate.model.linkedItemObject.linkedItemsById = baseItem.linkedItemsById;
		            }
		            _this.itemTemplate.itemType = baseItem.itemType;
		            _this.itemTemplate.showEditPopUp = true;
		            this.$forceUpdate();
				}
			})
			.catch(error=>{
				console.error(error);
			});

        },
        onAddSubBatchClick: function() {
            let _this = this;
            _this.itemTemplate = {};
            _this.itemTemplate.model = {};
            _this.itemTemplate.model.fields = {};
            _this.itemTemplate.model.status = {};
            if (_.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"}) !== -1) {
                _this.itemTemplate.model.status = _.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"});
            }
            _this.itemTemplate.statuses = [];
            _this.itemTemplate.templateToRenderer = kendisStore.getters.getBatchTemplate().scheme.fieldsTemplate;
            _this.itemTemplate.statuses = kendisStore.getters.getBatchTemplate().statuses;
            _this.itemTemplate.itemType = kendisStore.getters.getBatchTemplate().scheme.itemType;
            _this.itemTemplate.showEditPopUp = true;
            _this.$forceUpdate();
        },
        setBaseItemStatus : function (requestBody) {
            if (_.isEmpty(requestBody.status)) {
                if(requestBody.type=="Batch"){
                    if (_.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"}) !== -1) {
                        requestBody.status = _.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"});
                    }
                }else{
                    if (_.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"}) !== -1) {
                        requestBody.status = _.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"});
                    }
                }
            }
        },
        onSaveSubBatch: function(requestBody) {
            console.log("Data", requestBody)
            let _this = this;
            delete requestBody.bvPlan;
            delete requestBody.bvActual;
            let baseItemLinkPrimary = {type: "Batch"};
            let baseItemLinkParent = {linkType: "Parent-Batch", baseItemId:_this.objective.id};
            requestBody.baseItemLinks = [];
            requestBody.baseItemLinks.push(baseItemLinkPrimary);
            requestBody.baseItemLinks.push(baseItemLinkParent);
            requestBody.starred = false;
            this.setBaseItemStatus(requestBody);
            axios.post('external-entitites/save-base-item/popup-save', requestBody)
                .then(response => {
                    if (response && response.status == "200" && response.data) {
                        let baseItem = _.clone(_this.objective);
                        let savedBatch = response.data.impediment;
                        let baseItemLink = {};
                        baseItemLink.baseItemId = savedBatch.id;
                        baseItemLink.linkType="Child-Batch";
                        baseItem.baseItemLinks.push(baseItemLink);
                        baseItem.metaMap = "{}";
                        baseItem.baseItemLists=[];
                        baseItem.linkedItems=[];

                        if (!_this.objective.baseItemList) {
                            _this.objective.baseItemList=[];
                        }
                            let newBatch = _.clone(requestBody);
                            newBatch.title = response.data.impediment.title;
                            newBatch.key = response.data.impediment.key;
                            newBatch.id = response.data.impediment.id;
                            newBatch.showChildren = false;


                        _this.objective.baseItemList.push(newBatch);
                        _this.objective.showChildren = true;
                        _this.changeShowChildrenOnRoot(true);
                             // _this.okrList.push(newBatch);
                        _this.$forceUpdate();

						if(requestBody.id == undefined) {
                        axios.post('external-entitites/save-base-item/popup-save', baseItem)
                            .then(response => {
                                if (response.status == "200") {
                                    console.log("Batch Created Successfully");
                                    _this.$root.flags.refetchData = true;
                                }
                            })
                            .catch(error => {
                                console.error("Item save error", error);

                            });
						}
                    }
                })
                .catch(error => {
                    console.error("Item save error", error);
                });
            _this.onCLoseEditPopUp();
        },
        onSaveBatchCompletionCriteria(batchId, criteria) {
            if (this.objectiveData.id === batchId) {
                this.objectiveData.fields.selectedCriteria = criteria;
            }
        },
    }
});
