 SMART_REPORTS_OBJECTIVES = Vue.component('smart-report-objectives', {
    name: 'smart-report-objectives',
     mixins: [CALCULATION_SETTINGS_MIXIN, OBJECTIVE_MIXIN],
    components: {
        'list-objectives': LIST_OBJECTIVES,
    },

    template: `
             <div>
                  <div class="prow objectives-charts">
                    <div class="prow wd66 crcl" style="width: 66.3%;">
                        <div class="smr lft wd50 a">
                            <div class="prow wbox sumtbout" data-canvas="obj_bv_stats">
                                <h2>Business Value Achievement</h2>
                                
                                <div :class="['c100 p' + bvAchievementAvg]" >
                                    <div class="slice">
                                        <div class="bar"></div>
                                        <div class="fill"></div>
                                    </div>
                                </div>
                                <div class="prcvl" onmouseover="showRealValue(this);" :data-real-value="bvAchievementAvg">{{Math.floor(bvAchievementAvg)}}%</div>
                            </div>  
                        </div>
                    
                        <div class="smr lft wd50 b">
                            <div class="prow wbox sumtbout" data-canvas="obj_spavg_stats">
                                <h2>By <span class="childClass"></span> Points</h2>
                                
                                <div :class="['c100 p' + storyPointsAvg]">
                                    <div class="slice">
                                        <div class="bar"></div>
                                        <div class="fill"></div>
                                    </div>
                                </div>
                                <div class="prcvl" onmouseover="showRealValue(this);" :data-real-value="storyPointsAvg">{{Math.floor(storyPointsAvg)}}%</div>
                            </div>  
		        		</div>
                        
                        <div class="smr lft wd50 c">
                            <div class="prow wbox sumtbout" data-canvas="obj_usavg_stats">
                                <h2>By <span class="childrenClass"></span> Status</h2>
                                
                                <div :class="['c100 p' + storyStatusAvg]">
                                    <div class="slice">
                                        <div class="bar"></div>
                                        <div class="fill"></div>
                                    </div>
                                </div>
                                <div class="prcvl" onmouseover="showRealValue(this);" :data-real-value="storyStatusAvg" >{{Math.floor(storyStatusAvg)}}%</div>
                            </div>  
                        </div>
                    
                        <div class="smr lft wd50 d">
                            <div class="prow wbox sumtbout" data-canvas="obj_feaavg_stats">
                                <h2>By Parent Status</h2>
                                
                                <div :class="['c100 p' + parentStatusAvg]">									        
                                    <div class="slice">
                                        <div class="bar"></div>
                                        <div class="fill"></div>
                                    </div>
                                </div>
                                <div class="prcvl" onmouseover="showRealValue(this);" :data-real-value="parentStatusAvg">{{Math.floor(parentStatusAvg)}}%</div>
                            </div>  
                        </div>
                    </div>
                    
                    <div class="smr lft wd33 pr-0">
                        <div class="prow wbox sumtbout" data-canvas="BValue">
                            <h2>Business Value Achievement</h2>
                            <chart :options="BValue" ref="BValue"> </chart>
                            <div id="bv_chart" > </div>
                        </div>  
                    </div>
                </div>
                <div class="prow objectives-charts">
                    <div class="smr lft" style="width: 33%">
                        <div class="prow wbox sumtbout" data-canvas="obj_us_stats">
                            <h2>Progress by <span class="childrenClass"></span> Status</h2>
                            <div id="gt-cards" class="pg prow table gt-cards">
                                <div v-html="getBarCharts('storyStatus', '#1991eb')"></div>
                            </div>
                        </div>  
                    </div>
                    <div class="smr lft wd33">
                        <div class="prow wbox sumtbout" data-canvas="obj_sp_stats">
                            <h2>Progress by <span class="childClass"></span> Points</h2>
                            <div id="gt-cards" class="pg prow table gt-cards">
                                <div v-html="getBarCharts('storyPoints', '#1991eb')"></div>
                            </div>
                        </div>  
                    </div>
                    <div class="smr lft wd33 pr-0">
                        <div class="prow wbox sumtbout" data-canvas="obj_fea_stats">
                            <h2>Progress by Parent (<span class="parentClass"></span>) Status</h2>
                            <div id="gt-cards" class="pg prow table gt-cards">
                                <div v-html="getBarCharts('parntStatus', '')"></div>
                            </div>
                        </div>  
                    </div> 
                </div>
                <list-objectives :show-creation-menu="true" :should-load-objectives="true" :board="activeBoard" :readOnlyView="true"></list-objectives>
             </div>
	`,

    data() {
        return {
            pi: '',
            activeBoard   : {},
            BValue        : {},
            objectiveGroupList: [],
            objectivesList: [],
            excludedItemsData: {},
            bvAchievementAvg: 0,
            storyPointsAvg : 0,
            storyStatusAvg : 0,
            parentStatusAvg : 0,
        }
    },
    created() {
        if (vueInstance.boardLoaded){
            this.activeBoard = vueInstance.activeBoard;
        }
    },

    mounted() {
        this.BValue = {"_action":"onBValue","credits":{"enabled":false},"chart":{"height":"70%","type":"pie","plotBackgroundColor":null,"plotBorderWidth":null,"plotShadow":false},"title":{"text":""},"tooltip":{},"plotOptions":{"pie":{ "borderWidth":0,"size": "80%", "allowPointSelect":true,"cursor":"pointer","showInLegend": false,"dataLabels":{"enabled":true, "distance": 10,"format":" {point.percentage:.0f} %","style":{"color":"black"}}}},"lang": { "noData": "" },"series":[{"name":"Business Value Achievement","colorByPoint":true,"data":[]}]};
        this.fetchExcludedItems();
        this.loadObjectiveGroupsListBySessionBoardId();
    },

    methods: {
        getBarCharts : function(property, color){
            var _this = this;
            var html = '';
            if(_this.pi.teamSequence){
                for (var i = 0; i < _this.pi.objectiveIds.length; i++) {
                    var oid = _this.pi.objectiveIds[i];
                    if(_this.pi.objectivesMap[oid]){
                        html += '<div class="rec"><div class="name FL"><span class="nm">'+_this.pi.objectivesMap[oid].title+'</span></div>';
                        html +='<div class="prline FL">';
                        html +='<div class="ln"><span class="in FL" style="width: '+_this.pi.objectivesMap[oid][property]+'%;'+(color ? 'background-color: '+color : '')+'" ></span></div>';
                        html +='</div>';
                        if(_this.pi.objectivesMap[oid][property] != undefined){
                            html +='<div class="prc" onmouseover="showRealValue(this);" data-real-value="'+_this.pi.objectivesMap[oid][property+'Real']+'">'+_this.pi.objectivesMap[oid][property]+'%</div>';
                        }
                        html += '</div>';
                    }
                }
            }
            return html;
        },
        loadObjectiveGroupsListBySessionBoardId: function () {
            let _this = this;
            axios.get('objective/get-objective-groups-list-by-session-id/' + _this.activeBoard.session.id)
                .then(response => {
                    if (response.status == "200") {
                         _this.objectiveGroupList = response.data.objectiveGroups;
                        _.each(_this.objectiveGroupList, objGrp => {
                            _.each(objGrp.baseItemList, obj => {
                                _this.objectivesList.push(obj);
                            });
                        });
                        _this.statsCalculation();
                    }
                })
                .catch(error => {
                    console.error("Error occurred while getting objective groups list: ", error);

                })
        },
        statsCalculation: function (){
            let _this = this;
            let storyPointsAvgCount = 0;
            let storyStatusAvgCount = 0;
            let parentStatusAvgCount = 0;

            _.each(_this.objectivesList, obj => {
                _this.storyPointsAvg += _this.calculateCompletion(obj, _this.excludedItemsData, "CHILDREN_LINKED_ITEM_ESTIMATE");
                _this.storyStatusAvg += _this.calculateCompletion(obj, _this.excludedItemsData, "CHILDREN_LINKED_ITEM_STATUS");
                _this.parentStatusAvg += _this.calculateCompletion(obj, _this.excludedItemsData, "LINKED_ITEM_STATUS");

            });

            if (_this.storyPointsAvg > 0){
                _this.storyPointsAvg = _this.storyPointsAvg/_this.objectiveGroupList.length;
            }
            if (_this.storyStatusAvg > 0){
                _this.storyStatusAvg = _this.storyStatusAvg/_this.objectiveGroupList.length;
            }
            if (_this.parentStatusAvg > 0){
                _this.parentStatusAvg = _this.parentStatusAvg/_this.objectiveGroupList.length;
            }

            _this.bvAchievementAvg = _this.bvAchievementCalculation();
        },
        fetchExcludedItems: function () {
            let _this = this;

            let requestBody = {};
            requestBody["sessionId"] = _this.activeBoard.session.id;
            requestBody["viewType"] = "Objectives";

            axios.post('/plan/fetch-excluded-items', requestBody)
                .then(response => {
                    if (response.status === 200 && response && response.data && !response.data.error) {
                        _this.excludedItemsData = response.data.statsExclusion.excludedItems;
                    }
                })
                .catch(error => {
                    console.error("Error while fetching excluded items from DB: ", error);

                });
        },

        bvAchievementCalculation: function() {
            let _this = this;
            let bvAchievementAvg = 0;
            let sumOfBvAchievement= 0;

            _.each(_this.objectiveGroupList, objGrp=>{
                let bvPlanSum = 0;
                let bvActualSum = 0;
                _.each(objGrp.baseItemList, obj => {
                    bvPlanSum += parseFloat(obj.bvPlan);
                    bvActualSum += parseFloat(obj.bvActual);
                });
                if(bvPlanSum > 0) {
                    bvAchievementAvg = (bvActualSum / bvPlanSum) * 100;
                    bvAchievementAvg = Math.round((bvAchievementAvg + Number.EPSILON) * 100) / 100;
                }
                sumOfBvAchievement += bvAchievementAvg;
            });
            if(sumOfBvAchievement > 0) {
                sumOfBvAchievement = (sumOfBvAchievement)/(_this.objectiveGroupList.length);
            }

            return sumOfBvAchievement;
        }

    }
});