const link_item = Vue.component('link-item', {
		template : `
			
			<div>
			<div id="link-item-popup-container">
			<div class="aa" style="display: block;">
			<div id="overlay" class="overlay" style="display: block;"></div>
			<div class="ui-dialog item-link add-pop" style="display: block;">				
				<div v-if="loader.show" class="loader"><div><div class="loaderinteg"></div>{{loader.text}}</div></div>
				
				<div class="dialgtl"> {{title}} <i class="rmv-ico ti-close" @click="onClickCancelLinkItem" title="Close"></i></div>
				
					<div id="link-items" class="cntr mrow aa" style="display: block;">
						<div class=" select-o-items">

							<div class="ui-multiselect-menu ui-widget ui-widget-content ui-corner-all" style="display: block;">
								<div  :class="[(boards && boards.length > 0) ? 'a-half' : 'a-full']">
									<div class="ui-multiselect-filter lblm a">
										<label>Search Items to Link</label> <input placeholder="Enter keywords" type="search" v-model="query" @input="onEnterSearchText" />
									</div>
									<div class="ui-multiselect-filter lblm b">
										<label>Select Board</label>
										<div v-if="boards && boards.length > 0" class="selectcont">
									     	<vz-select :options="boards" v-model="slctdBoards" label="name" track-by="id" :multiple="true" @select="onChangeBoardSelection"></vz-select>
										</div>
									</div>
									<ul class="ui-helper-reset srchmb mb-10 ml-10 FL">
										<li><a class="ui-multiselect-all" href="javascript:void(0);" @click="onSelectAllLinkItem(true)"><span class="ui-icon ui-icon-check"></span><span>Check all</span></a></li>
										<li><a class="ui-multiselect-none" href="javascript:void(0);" @click="onSelectAllLinkItem(false)"><span class="ui-icon ui-icon-closethick"></span><span>Uncheck all</span></a></li>
									</ul>
									
								</div>
								<ul class="ui-multiselect-checkboxes ui-helper-reset">

									<li v-if="dataCopy.features.length > 0" class="ui-multiselect-optgroup-label "><a href="javascript:void(0);">Features</a></li>

									<template v-for="(option,index) in dataCopy.features">
										<li class=" groupedLi">
											<label class="ui-corner-all ui-state-hover"> 
												<input @click.stop="onSelectLinkItem('fe',index)" type="checkbox" :title="option.title" :checked="option.selected" /> 
												<span class="lbl"> <span class="key"><a v-if="option.tfsId || option.jiraId" :href="option.tfsId ? option.tfsURL : option.externalReferenceURL" target="_blank">{{option.tfsId ? option.tfsId : option.jiraKey}}</a></span> <span>{{option.title}}</span></span>
											</label>
										</li>
									</template>

									<li v-if="dataCopy.stories.length > 0" class="ui-multiselect-optgroup-label "><a href="javascript:void(0);">US</a></li>

									<template v-for="(option,index) in dataCopy.stories">
										<li class="  groupedLi">
											<label class="ui-corner-all ui-state-hover" > 
												<input @click="onSelectLinkItem('us',index)" type="checkbox" :title="option.title" :checked="option.selected"> 
												<span class="lbl">
													<span class="key"><a v-if="option.tfsId || option.jiraId" :href="option.tfsId ? option.tfsURL : option.externalReferenceURL" target="_blank">{{option.tfsId ? option.tfsId : option.jiraKey}}</a></span> <span>{{option.title}}</span>
												</span>
											</label>
										</li>
									</template>
								</ul>
							</div>
						</div>
						<div class="rec btn">
							<input id="save-o-items" type="button" class="button FR action" :class="[!saveButtonEnabled ? 'disabled' : '']"	value="Save" :disabled="!saveButtonEnabled"	@click="onSelectSaveLinkItems" /> 
							<a href="javascript:void(0);" class="FR cncl action" @click="onClickCancelLinkItem">Cancel</a>
						</div>
					</div>
				</div>
			</div>
			</div>
			</div>
		`,
		props:  {
			title: {
				type: String,
			    default: () => { return "" }
			},
			data: {
				type: Object,
			    default: () => { return {features:[],stories:[]} }
			},
			boards: {
				type: Array,
			    default: () => { return []}
			},
			sessionBoards: {
				type: Array,
			    default: () => { return []}
			},
			selectedItems: {
				type: Array,
		    	default: () => { return []}
			},
			fitContainer: {
				type: Boolean,
		    	default: () => { return false}
			},
			container: {
				type: String,
			    default: () => { return "" }
			}
		},
		
		computed: {
			
		},
		
		data() {
			return {
				dataCopy: {features:[{selected:false}],stories:[{selected:false}]},
				saveButtonEnabled:false,
				query : "",
				loader: {
					show: false,
					text: ""
				},
				showBoard : false,
				slctdBoards:[],
			}
		},
		watch: {
			
		},
		
		created () {
						
			if (!_.isEmpty(this.data) && !_.isEmpty(this.data.features)) {
				
				if (!_.isEmpty(this.boards)) {
					this.slctdBoards = this.boards;
				}
				var _this = this;
				_this.$options.sessionBoardsMapBySessionId = {};
				if (!_.isEmpty(this.sessionBoards)) {
					_.each(this.sessionBoards,sb=>{
						_this.$options.sessionBoardsMapBySessionId[sb.session.id] = sb;
					});	
				}
				
				this.$options.unfilteredData = JSON.parse(JSON.stringify(this.data));
				this.applyFilter();
				this.setSelectedItems(this.selectedItems);
				
			}else if (this.data && this.data != undefined) {
				
				this.slctdBoards = this.boards;
				this.loadBoardData(this.boards);
			}
		},

		mounted: function () {
			
			if (this.fitContainer) {
				var container = document.getElementById(this.container);
				var element = document.getElementById("link-item-popup-container");
				element.parentElement.removeChild(element);
				container.appendChild(element);
			}
		},
		methods: {
			
			//////////////////////////////////////////////////
			///////////////    LOGIC
			checkForEnablesSaveButton : function () {
				
				var _this = this;
				
				var selectedMap = {};
				_.each(_this.selectedItems,id=>selectedMap[id]=true);

				var data = this.$options.unfilteredData;
				
				var enable = false;
				for (var i=0;i<data.features.length;i++) {
					var previousFearue = selectedMap[data.features[i].id] ? true : false;
					if (previousFearue != data.features[i].selected) {
						enable = true;
						break;
					}
				}
				if (!enable) {
					for (var i = 0; i < data.stories.length; i++) {
						var previousStory = selectedMap[data.stories[i].id] ? true : false;
						if (previousStory != data.stories[i].selected) {
							enable = true;
							break;
						}
					}
				}
				_this.saveButtonEnabled = enable;
			},
			
			getSelectedItemsFromLinkPopupFromLinkPopup : function () {
				
				var _this = this;
				
				var data = _this.$options.unfilteredData;
				
				var items = [];
				
				for (var i=0;i<data.features.length;i++) {
					if (data.features[i].selected) {
						items.push(data.features[i]);
					}
				}
				for (var i=0;i<data.stories.length;i++) {
					if (data.stories[i].selected) {
						items.push(data.stories[i]);
					}
				}
				return items;
			},
			setSelectedItems: function (setSelectedItemIds) {
				
				var _this = this;
				
//				if (!_.isEmpty(setSelectedItemIds)) {
					var selectedMap = {};
					
					_.each(setSelectedItemIds,id=>selectedMap[id]=true);
					
					_.each(_this.$options.unfilteredData.features,item=>{
						var find = selectedMap[item.id];
						item.selected = find ? true : false;
					});
					_.each(_this.$options.unfilteredData.stories,item=>{
						var find = selectedMap[item.id];
						item.selected = find ? true : false;
					});
					
					this.checkForEnablesSaveButton();
//				}
			},
			applyFilter: function () {
			
				var _this = this;
				
				var slctdSessionBoardMap = {};
				var checkBoard = false;
				
				if (!_.isEmpty(this.boards)) {
					checkBoard = true;
					if (!_.isEmpty(this.slctdBoards)) {
						_.each(this.slctdBoards,board=>{
							var sessionBoard = _this.$options.sessionBoardsMapBySessionId[board.id];
							slctdSessionBoardMap[sessionBoard.id] = sessionBoard;
						});
					}
				}
				
				var newCopy = {};
				
				var features = [];
				var stories  = [];
				
				var query;
				if (!_.isEmpty(_this.query)) {
					query = _this.query.toLowerCase();
				}
				
				_.each(_this.$options.unfilteredData.features,item=>{
					
					var queryMatch = true;
					var boardMatch = true;
					if (query) {
						if ((item.tfsId && item.tfsId.includes(query)) || (item.jiraKey && item.jiraKey.includes(query)) || item.title.toLowerCase().includes(query)) {
							
						}else {
							queryMatch = false;
						}
					}
					if (checkBoard) {
						var sb = slctdSessionBoardMap[item.sessionBoards[0].id];
						boardMatch = sb ? true : false;
					}
					
					if (queryMatch && boardMatch) {
						features.push(item);
					}
					
				});
				_.each(_this.$options.unfilteredData.stories,item=>{
					
					var queryMatch = true;
					var boardMatch = true;
					if (query) {
						if ((item.tfsId && item.tfsId.includes(query)) || (item.jiraKey && item.jiraKey.includes(query)) || item.title.toLowerCase().includes(query)) {
							
						}else {
							queryMatch = false;
						}
					}
					if (checkBoard) {
						var sb = slctdSessionBoardMap[item.sessionBoards[0].id];
						boardMatch = sb ? true : false;
					}
					
					if (queryMatch && boardMatch) {
						stories.push(item);
					}
					
				});
				
				newCopy.features = features;
				newCopy.stories  = stories;
				
				this.dataCopy = newCopy;
			},
			
			//////////////////////////////////////////////////
			///////////////   API CALLS
			
			loadBoardData: function (boards) {
				
				var _this = this;
				
				var data = {};
				var ids = "";
				_.each(boards,b=>{
					if (_.isEmpty(ids)) {
						ids = b.id;
					}else {
						ids += (","+b.id);
					}
				});
				data.boardIds = ids;
				
				_this.loader.show = true;
				
				axios.post('/riskregister/geitems', data)
				.then(response => { 
					
					_this.loader.show = false;
					
					if (response.data) {
						
						var features = response.data.features;
						var stories  = response.data.stories;
						
						_this.$options.sessionBoardsMapBySessionId = {};
						
						var sessionBoards = response.data.sessionBoards;
						_.each(sessionBoards,sb=>{
							_this.$options.sessionBoardsMapBySessionId[sb.session.id] = sb;
						});	
						
						_this.$options.unfilteredData = {};
						_this.$options.unfilteredData.features = features;
						_this.$options.unfilteredData.stories  = stories;
						
						_this.$emit("data-loaded",response.data);
						
						this.applyFilter ();
						
						_this.setSelectedItems(_this.selectedItems);				
					}
				})
				.catch(error => {
					_this.loader.show = false;
				});
			},
			
			//////////////////////////////////////////////////
			//////////////     UI ACTIONS
			onSelectLinkItem: function(itemType,index) {
				if (itemType === 'fe') {
					var item = this.dataCopy.features[index];
					Vue.set(item,"selected",!item.selected);					
				}else {
					var item = this.dataCopy.stories[index];
					Vue.set(item,"selected",!item.selected);
				}
				this.checkForEnablesSaveButton ();
			},
			onClickCancelLinkItem: function () {
				if (this.fitContainer) {
					var element = document.getElementById("link-item-popup-container");
					element.parentElement.removeChild(element);
				}
				this.$emit('cancel');
			},
			onSelectSaveLinkItems: function () {
				var linkItems = this.getSelectedItemsFromLinkPopupFromLinkPopup();
				this.$emit('save',linkItems);
				this.onClickCancelLinkItem();
			},
			onSelectAllLinkItem: function (check) {
				_.each (this.dataCopy.features,item=>{
					item.selected = check;
				});
				_.each (this.dataCopy.stories,item=>{
					item.selected = check;
				});
				this.saveButtonEnabled = check;
			},
			onChangeBoardSelection: function  () {
				this.applyFilter();
			},
			onEnterSearchText: function () {
				this.applyFilter();
			}
		}
	});