const progressBar = Vue.component("ProgressBar", {
    name: "progress-bar",
    props: {
        title: {
            type: String,
            default: 'Processing...'
        },
        progressValue: {
            type: Number,
            default: 0,
            validator: function (value) {
                return value >= 0 && value <= 100;
            }
        },
        showPercentage: {
            type: Boolean,
            default: true
        },
        allowCancel: {
            type: Boolean,
            default: false
        },
        message: {
            type: String,
            default: 'Please wait while we generate your PDF...'
        },
        downloadSuccessful: false,
        exportError: false,
    },
    template: `
            <div class="progress-popup">
                <div v-if="!downloadSuccessful">
                    <h3 class="progress-title">{{ title }}</h3>                
                    <div class="progress-message">{{ message }}</div>                    
                    <!-- Progress Bar Container -->
                    <div class="progress-bar-container">
                        <div class="progress-bar-background">
                            <div class="progress-bar-fill" :style="progressBarStyle"></div>
                        </div>
                        
                        <!-- Progress Text -->
                        <div class="progress-text">
                            <span v-if="showPercentage" class="progress-percentage">{{ Math.round(progressValue) }}%</span>
                            <span class="progress-status">{{ getStatusText() }}</span>
                        </div>
                    </div>
                       
                    <div class="cancel-request">
                        <a href="javascript:void(0);" @click="cancelExport" class="url und">Cancel Export</a>
                    </div>    
                </div>
                
                <div v-else-if="exportError" class="error-container">
                    <div class="completion-content">
                        <i class="error-icon ti-alert"></i> <!-- Alert triangle -->
                        <h3 class="completion-message">Something went wrong. Please try again.</h3>
                    </div>
                    <em @click="closeProgress" title="Close" class="close-icon ti-close"></em>
                </div>
    
                <div v-else class="completion-container">
                    <div class="completion-content">
                        <i class="completion-icon ti-check"></i>
                        <h3 class="completion-message">{{ completeMsg }}</h3>
                    </div>
                    <em @click="closeProgress" title="Close" class="close-icon ti-close"></em>
                </div>
                
            </div> 
    `,
    data() {
        return {
            completeMsg: "",
        }
    },

    mounted(){
    },

    computed:{
        progressBarStyle: function() {
            const value = Math.max(0, Math.min(100, Number(this.progressValue) || 0));
            return {
                width: value + '%'
            };
        }
    },

    watch:{
        progressValue(newVal, oldVal) {
        },

        downloadSuccessful(newValue, oldValue){
            if(newValue){
                this.completeMsg = "Export completed successfully. Check your downloads folder.";
            }
        },
        exportError(newVal, oldVal){

        }
    },

    methods: {
        getStatusText() {
            return 'completed';
        },

        cancelProgress() {
            this.$emit('cancel');
        },

        closeProgress() {
            this.$emit('close');
        },

        cancelExport(){
            this.$emit('cancel');
        }
    }
});
