const OBJECTIVES_WIDGETS = Vue.component('objectives-widgets', {
	template: `
		<div class="wbox p-rel" :class="[graphData.type == 'groups' ? 'full' : 'half']">
			<template v-if="!_.isEmpty(graphData.options.series[0].data)">
				<chart1 v-if="graphData.show" :options="graphData.options" />
				<a v-if="graphData.type == 'groups' && isMockingMode" href="javascript:void(0)" @click="$emit('load-more', graphData.type)" class="p-abs ldmor">Load More</a>
			</template>
			<template v-else>
				<span class="nofound DB fs-14">No data found</span>
			</template>
		</div>
	`,
	props:{
		graphData: {
			type: Object,
			default: () => {
				return {};
			}
		},		
        isMockingMode: {
            type: Boolean,
            default: () => { 
				return false 
			}
        },		
	},
	data() {
		return {
		}
	},
	created() {
	},
	mounted() {},
	methods: {
		
	}
});