var URL_PARAMETER_MIXIN = {
    data() {
        return {

        }
    },
    methods: {
        getUrlParams: function () {

            let fullPath = window.location.href;
            let pathParts = fullPath.split("?");

            let params = {};

            if (pathParts.length == 2) {
                let paramStr = pathParts[1];
                let paramPairs = paramStr.split("&");
                for (let i = 0 ; i < paramPairs.length; i++) {
                    let keyValue = paramPairs[i].split("=");
                    params[keyValue[0]] = keyValue[1];
                }
            }
            return params;
        },
        setUrlParams: function (params) {

            let fullPath = this.$route.fullPath;
            let pathParts = fullPath.split("?");

            let paramsStr = getParamsStr(params);
            let finalPath = pathParts[0] + "?" + paramsStr;

            this.$router.push({ path: finalPath});

            function getParamsStr(params) {
                let str = "";
                for (key in params) {
                    if (str.length == 0) {
                        str += (key+"="+params[key]);
                    }else {
                        str += ("&"+key+"="+params[key]);
                    }
                }
                return str;
            }

            return params;
        },
        getUrlParam: function (key) {
            let params = this.getUrlParams();
            return params[key];
        },
        setUrlParam: function (key, value) {
            let params = this.getUrlParams();
            params[key] = value;

            this.setUrlParams(params);
        },
        deleteUrlParam: function (key) {

            let params = this.getUrlParams();
            delete params[key];

            this.setUrlParams(params);
        },

    }
}

const OBJECTIVE_LIST_LINKED_ITEMS = Vue.component('objective-list-linked-items', {
    mixins: [CALCULATION_SETTINGS_MIXIN],
    props: {
        linkedItems: {
            type: Array,
            default: () => {
                return [];
            }
        },
		linkedItemsById : {
			type: Object,
			default: () => {
				return {};
			}			
		},
		objectiveTeam: {
			type: Object,
			default: () => {
				return {};
			}
		},
		board: {
			type: Object,
			default: () => {
				return {};
			}
		},
        readOnlyView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        completionCriteria: {
            type: String,
            default: () => {
                return "";
            }
        },
        removeItemPermission: {
            type: Boolean,
            default: () => {
                return true;
            }
        },
		showUnLinkedItems: {
            type: Boolean,
            default: () => {
                return false;
            }			
		},
		showBoardLinkedItem: {
            type: Boolean,
            default: () => {
                return false
            }				
		},
        objective: {
            type: Object,
            default: () => {
                return {};
            }
        },
        isMockingMode: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
    },

    template: /*html*/`
		<div>
			<ul class="o-items table prow">
				<template v-if="!showUnLinkedItems">
                    <draggable :value="objectiveLinkedItemsList" :fallbackTolerance="1" :group="{ name: 'items', pull: false, put: false }" @end="onDragEnd" animation=150 easing="cubic-bezier(1, 0, 0, 1)" :forceFallback="true" ghost-class="ghost-item" delay=100>
					<template v-for="(linkData,linkIndex) in objectiveLinkedItemsList">
						<li class="inobj" v-if="showLinkedItem(linkData)" :key="linkData.randomId" :class="[linkedItems[linkIndex].expandChild ? 'active' : '' ]">
                            <div class="move sortable-handle value-sortable-handle"></div>
                            <em v-if="linkData.subItems && linkData.subItems.length > 0" class="ti-angle-right acrd-arrin" @click="onClickLinkAccordian(linkIndex)"></em>
							<div class="rec aa mb-0" @click="onClickLinkAccordian(linkIndex)">
								<div style="border: 0" class="rc c2 rpttl">
									<template v-if="!linkData.highlightedKey">
										<template v-if="linkData.tfsId">
											<a :href="linkData.tfsURL" target="_blank">{{linkData.tfsId}}</a>
											<img v-if="!_.isEmpty(linkData.tfsItemTypeIcon)" :src="linkData.tfsItemTypeIcon" alt="Azure" class="azurico">										
										</template>
										<a v-else-if="linkData.kendisKey"  class="ky mr-5" href="javascript:void(0);">{{linkData.kendisKey}}</a>
										<a v-else-if="linkData.jiraKey"  class="ky mr-5" :href="resolveJiraAndKendisOnlyUrl(linkData)" :class="itemIcon(linkData)" target="_blank" @click="handleLinkClick($event, linkData)">{{linkData.jiraKey}}</a>
									</template>
									<template v-else>
										<template v-if="linkData.tfsId">
											<a :href="linkData.tfsURL" target="_blank"><span v-html="linkData.highlightedKey"></span></a>
											<img v-if="!_.isEmpty(linkData.tfsItemTypeIcon)" :src="linkData.tfsItemTypeIcon" alt="Azure" class="azurico">										
										</template>
										<a v-else-if="linkData.kendisKey"  class="ky mr-5" href="javascript:void(0);"><span v-html="linkData.highlightedKey"></span></a>
										<a v-else-if="linkData.jiraKey"  class="ky mr-5" :href="resolveJiraAndKendisOnlyUrl(linkData)" :class="itemIcon(linkData)" @click="handleLinkClick($event, linkData)"><span v-html="linkData.highlightedKey"></span></a>
									</template>
									<span v-if="linkData.highlightedTitle" :title="linkData.title" v-html="linkData.highlightedTitle"></span>
									<span v-else :title="linkData.title" v-html="linkData.title"></span>
								</div>
								<div style="border: 0" class="rc c4 status" title="Status">
									<span v-if="linkData.status" class="sts FL" :class="statusCategoryClass(linkData)">{{linkData.status.title}}</span>
								</div>
								<div style="border: 0" class="rc c4 statuses" title="Child counts">
									<div class="statuses_cat">
										<span v-if="linkData.childContByStatus && linkData.childContByStatus['ToDo']" title="ToDo"
											class="sts a fs-10">{{linkData.childContByStatus['ToDo']}}</span>
										<span v-if="linkData.childContByStatus && linkData.childContByStatus['InProgress']" title="In Progress"
											class="sts b fs-10">{{linkData.childContByStatus['InProgress']}}</span>
										<span v-if="linkData.childContByStatus && linkData.childContByStatus['Done']" title="Done"
											class="sts c fs-10">{{linkData.childContByStatus['Done']}}</span>
                                        <span v-if="linkData.childContByStatus && linkData.childContByStatus['Misc']" title="Misc"
                                        class="sts d fs-10">{{linkData.childContByStatus['Misc']}}</span>
									</div>
								</div>
								<div style="border: 0" class="rc c4 w2">
									<div class="prct_cat">
										<span class="prct FR font-sbold"></span>
										<template>{{itemCompletion(linkData)+'%'}}</template>
									</div>
								</div>
								<div style="border: 0" class="rc c4 w2 points" title="Estimates">
									<span>{{getFormatedDecimal(linkData.storyPoints)}}</span>
								</div>
								<div style="overflow: visible; border: 0" class="rc c4 tmtg wd-m">
									<template v-for="team in linkData.teams">
										<div v-if="team" class="tm lbl-bg tooltip" :style="{color:team.color}">
											<div v-if="!_.isEmpty(team) && team.label" class="line" :style="{backgroundColor:team.color}"></div>
											<template v-if="!_.isEmpty(team) && team.label">{{team.label}}</template>
											<div class="hovtooltipB">{{team.title}}</div>
										</div>
									</template>
								</div>
								<div style="overflow: visible; border: 0" class="rc c4 spctg wd-m">
									<template v-for="container in linkData.containers">
										<span v-if="!_.isEmpty(container) && container.label" class="tooltip">
											<template v-if="!_.isEmpty(container) && container.label">{{container.label}}</template>
											<div class="hovtooltipB">{{container.title}}</div>
										</span>
									</template>
								</div>
								<em v-if="removeItemPermission && !readOnlyView && ((!showBoardLinkedItem && isMockingMode) || !isMockingMode)" class="rmv-ico ti-close e rnd sml DAJ" @click.stop="onClickRemoveLink(linkIndex)" title="Remove"></em>
							</div>
							<ul v-if="linkedItems[linkIndex].expandChild" class="sub-items c">
								<div v-for="child in linkData.subItems" class="rec aa" v-if="showLinkedItem(child)">
									<div style="border: 0" class="rc c2 rpttl">
										<template v-if="child.tfsId">
											<a :href="child.tfsURL" target="_blank">{{child.tfsId}}</a>
											<img v-if="!_.isEmpty(child.tfsItemTypeIcon)" :src="child.tfsItemTypeIcon" alt="Azure" class="azurico">										
										</template>
										<a v-else-if="child.kendisKey" href="javascript:void(0);">{{child.kendisKey}}</a>
										<a v-else-if="child.jiraKey" :href="resolveJiraAndKendisOnlyUrl(child)" :class="itemIcon(child)" target="_blank" @click="handleLinkClick($event, child)">{{child.jiraKey}}</a>
										{{child.title}}
									</div>
									<div style="border: 0" class="rc c4 status" title="Status">
										<span v-if="child.status" class="sts FL"
											:class="statusCategoryClass(child)">{{child.status.title}}</span>
									</div>
									<div style="border: 0" class="rc c4 statuses" title="Child counts">
										<div class="statuses_cat"></div>
									</div>
									<div style="border: 0" class="rc c4 w2 ">
										<div class="prct_cat">
											<span class="prct FR font-sbold"></span>
										</div>
									</div>
									<div style="border: 0" class="rc c4 w2 points" title="Estimates">
										<span>{{getFormatedDecimal(child.storyPoints)}}</span>
									</div>
									<div style="overflow: visible; border: 0" class="rc c4 tmtg wd-m">
										<template v-for="team in child.teams">
											<div v-if="team" class="tm lbl-bg tooltip"
												:style="{color:team.color}">
												<div v-if="!_.isEmpty(team) && team.label" class="line" :style="{backgroundColor:team.color}">
												</div>
												<template v-if="!_.isEmpty(team) && team.label">{{team.label}}</template>
												<div class="hovtooltipB">{{team.title}}</div>
											</div>
										</template>
									</div>
									<div style="overflow: visible; border: 0" class="rc c4 spctg wd-m">
										<template v-for="container in child.containers">
											<span v-if="!_.isEmpty(container) && container.label" class="tooltip">
												<template v-if="!_.isEmpty(container) && container.label">{{container.label}}</template>
												<div class="hovtooltipB">{{container.title}}</div>
											</span>
										</template>
									</div>
								</div>
							</ul>
						</li>
					</template>
                    </draggable>
				</template>
				<template v-if="!_.isEmpty(linkedItemsById)">
					<template v-for="(item,val) in linkedItemsById">
						<li class="rec" :class="[(isCurrentSessionItem(item) ? '' : 'disabled')]" :data-sb="item.session_id ? item.session_id : ''"	:data-stitle="item.session_title ? item.session_title : ''">
							<div style="border:0;font-style: italic;width:100% !important;" class="rc c2">
								<span class=" delwgt"><a target="_blank" :href="item.externalReferenceURL">{{item.key }}</a></span>
								Item does't exist on the board 3
							</div>
							<a @click="removeLinkedExternalItemId(val, item)" title="Unlink Item" v-if="removeItemPermission && !readOnlyView" href="javascript:void(0);" class="rmv-ico ti-close e rnd sml DAJ"></a>
						</li>
					</template>
				</template>			
			</ul>
		</div>
    `,

    components: {
		'draggable': vuedraggable,
	},

    data() {
        return {
			boardMap: {},	
            baseItemLinks: [],
            objectiveLinkedItemsList: [],
		}
    },

    watch: {
        linkedItems: {
            handler: function (newList, oldList) {
                let baseItemLinks = _.sortBy(this.objective.baseItemLinks, 'sequence');
                const baseItemLinkOrder = _.fromPairs(
                    baseItemLinks.map((link, index) => [link.itemId, index])
                );

                newList = _.sortBy(newList, item => baseItemLinkOrder[item.id] ?? Number.MAX_SAFE_INTEGER);

                this.objectiveLinkedItemsList = [...newList];
                this.populateItemsData(this.objectiveLinkedItemsList);
            },
            immediate: true
        },
        // baseItemLinks: {
        //     handler(newLinks) {
        //         this.populateItemsData(this.linkedItems);
        //     },
        //     deep: true,
        // }
    },
	computed: {
		showLinkedItem: function() {
			let _this = this;
			return function(item) {
				let show = false;
                if(_this.verifyItemsToExclude(item, _this.excludeItemsData)){
                    if (_this.completionCriteria === "TEAM_STORY_STATUS" || _this.completionCriteria === "TEAM_STORY_ESTIMATE"){
                        if(_.isEmpty(_this.objectiveTeam)) {
                            show = true;
                        }
                        if(!_.isEmpty(item.teamContainers)) {
                            if (item.type === "UserStory"){
                                let containers = item.teamContainers;
                                for(let i = 0; i < containers.length;  i++) {
                                    if(containers[i].team && containers[i].team.id == _this.objectiveTeam.id) {
                                        show = true;
                                        break;
                                    }
                                }
                            }else{
                                show = true;
                            }
                        }else if (item.type === "Feature" && _.isEmpty(item.subItems) && _.isEmpty(item.teamContainers)){
                            show = true;
                        }
                    }else{
                        show = true;
                    }
                }
				return show
			}
		},
		itemIcon: function() {
			return function(item) {
				return getItemIcon(item);
			}
		},
		isCurrentSessionItem: function () {
			return function (item) {
				if (item.sessionBoard_id != undefined && item.sessionBoards == undefined) {
					item.sessionBoards = [{ id: item.sessionBoard_id, session: { id: item.session_id } }];
				}

				if (item.session_id != undefined && item.sessionBoards[0].session == undefined) {
					item.sessionBoards[0].session = { id: item.session_id };
				}

				if (this.boardId) {
					var ret = item.sessionBoards[0].id === this.boardId;
					if (ret) {
						if (item.sessionBoard_id && this.risk.activeBoardIds && !this.risk.activeBoardIds[this.boardId]) {
							return false;
						}
						return true;
					} else if (item.sessionBoard_id != undefined && this.sessionId && item.sessionBoards[0].session.id === this.sessionId) {
						if (this.risk.activeBoardIds && !this.risk.activeBoardIds[this.boardId]) {
							return false;
						} else {
							return true;
						}
					} else {
						return false;
					}
				} else {
					return true;
				}
			};
		},
		
        itemCompletion: function (){
            return function (item){
                let itemCompletion = 0;
                if (item.type === "Feature" && item.subItems && item.subItems.length > 0) {
                    if (this.completionCriteria === "LINKED_ITEM_STATUS" && item.status && item.status.category === "Done") {
                        itemCompletion = 100;
                    }else if(this.completionCriteria === "CHILDREN_LINKED_ITEM_STATUS"){
                        let doneChildItems = 0;
                        let totalChildItems = 0;

                        _.each(item.subItems, subItem => {
                            if (this.verifyItemsToExclude(subItem, this.excludeItemsData)){
                                if (subItem.status && subItem.status.category === "Done") {
                                    doneChildItems 	+= 1;
                                }
                                totalChildItems += 1;
                            }
                        });

                        if (totalChildItems > 0){
                            itemCompletion = (doneChildItems/totalChildItems)*100;
                            itemCompletion = Math.round((itemCompletion + Number.EPSILON) * 100) / 100;
                        }

                    }else if (this.completionCriteria === "CHILDREN_LINKED_ITEM_ESTIMATE"){
                        let doneStoryPoints = 0;
                        let totalStoryPoints = 0;

                        _.each(item.subItems, subItem => {
                            if (this.verifyItemsToExclude(subItem, this.excludeItemsData)){
                            	if(!isNaN(Number(subItem.storyPoints))){//DEV-9320
                                if (subItem.status && subItem.status.category === "Done") {
                                    doneStoryPoints += subItem.storyPoints;
                                }
                                totalStoryPoints 	+= subItem.storyPoints;
                            	}
                            }
                        });
						if(totalStoryPoints > 0) {
	                        itemCompletion = (doneStoryPoints/totalStoryPoints)*100;
	                        itemCompletion = Math.round((itemCompletion + Number.EPSILON) * 100) / 100;
						}

                    }else if (this.completionCriteria === "TEAM_STORY_STATUS"){
                        let doneTeamItems = 0;
                        let totalTeamItems = 0;
                        _.each(item.subItems, subItem => {
                            if (this.verifyItemsToExclude(subItem, this.excludeItemsData)){
                                 if (!_.isEmpty(this.objectiveTeam)) {
                                    if (!_.isEmpty(subItem.teamContainers)){
                                        let isTeamStory = false;
                                        for (let i = 0; i < subItem.teamContainers.length; i++) {
                                            isTeamStory = subItem.teamContainers[i].team.id === this.objectiveTeam.id;
                                            if (isTeamStory) {
                                                break;
                                            }
                                        }
                                        if (isTeamStory) {
                                            totalTeamItems 		+= 1;
                                            if (subItem.status && subItem.status.category === "Done") {
                                                doneTeamItems 	+= 1;
                                            }
                                        }
                                    }
                                }else{
                                    totalTeamItems 		+= 1;
                                    if (subItem.status && subItem.status.category === "Done") {
                                        doneTeamItems 	+= 1;
                                    }
                                }
                            }
                        });

                        if (totalTeamItems > 0){
                           itemCompletion = (doneTeamItems/totalTeamItems)*100;
                           itemCompletion = Math.round((itemCompletion + Number.EPSILON) * 100) / 100;
                        }

                    }else if (this.completionCriteria === "TEAM_STORY_ESTIMATE"){
                        let doneTeamItemsStoryPoints = 0;
                        let totalTeamItemsStoryPoints = 0;
                        _.each(item.subItems, subItem => {
                            if (this.verifyItemsToExclude(subItem, this.excludeItemsData)){
                                if (!_.isEmpty(this.objectiveTeam)) {
                                    if (!_.isEmpty(subItem.teamContainers)){
                                        let isTeamStory = false;
                                        for (let i = 0; i < subItem.teamContainers.length; i++) {
                                            isTeamStory = subItem.teamContainers[i].team.id === this.objectiveTeam.id;
                                            if (isTeamStory) {
                                                break;
                                            }
                                        }
                                        if (isTeamStory) {
                                        	if(!isNaN(Number(subItem.storyPoints))){//DEV-9320
                                            totalTeamItemsStoryPoints 		+= subItem.storyPoints;
                                            if (subItem.status && subItem.status.category === "Done") {
                                                doneTeamItemsStoryPoints 	+= subItem.storyPoints;
                                            }
                                        	}
                                        }
                                    }
                                }else{
                                	if(!isNaN(Number(subItem.storyPoints))){//DEV-9320
                                    totalTeamItemsStoryPoints 		+= subItem.storyPoints;
                                    if (subItem.status && subItem.status.category === "Done") {
                                        doneTeamItemsStoryPoints 	+= subItem.storyPoints;
                                    }
                                	}
                                }
                            }
                        });
						if(totalTeamItemsStoryPoints > 0) {
	                        itemCompletion = (doneTeamItemsStoryPoints/totalTeamItemsStoryPoints)*100;
	                        itemCompletion = Math.round((itemCompletion + Number.EPSILON) * 100) / 100;
						}
                    }
                }else if(_.isEmpty(item.subItems) && this.completionCriteria === "LINKED_ITEM_STATUS" && item.status && item.status.category === "Done"){
                    itemCompletion = 100;
                }

                return itemCompletion;
            }
        },
        excludeItemsData: function() {
            return kendisStore.getters.getExcludeItemsData();
        },
        sortedLinkedItems() {
            return this.linkedItems;
        },
	},
	
    created() {
    },

    mounted() {
        let baseItemLinks = _.sortBy(this.objective.baseItemLinks, 'sequence');
        const baseItemLinkOrder = _.fromPairs(
            baseItemLinks.map((link, index) => [link.itemId, index])
        );

        this.objectiveLinkedItemsList = _.sortBy(this.linkedItems, item => baseItemLinkOrder[item.id] ?? Number.MAX_SAFE_INTEGER);;
        this.populateItemsData(this.objectiveLinkedItemsList);
        if (!_.isEmpty(this.objective)) {
            this.baseItemLinks = this.objective.baseItemLinks.filter(baseItemLink => !_.isEmpty(baseItemLink.itemId));
        }
    },

    methods: {

        onClickLinkAccordian: function (itemIndex) {
            this.linkedItems[itemIndex].expandChild = !this.linkedItems[itemIndex].expandChild;
            this.$forceUpdate();
        },

        populateItemsData: function (items) {
            let _this = this;
            if (items && items.length > 0) {
                _.each(items, function (item) {
                    let containers = [];
                    let teams = [];
                    //.......................
                    let teamContainers = _this.getTeamAndContainers(item);
                    containers = teamContainers["containers"]
                    teams = teamContainers["teams"]
                    //.......................
                    item.containers = _.isEmpty(containers) ? [{}] : containers;
                    item.teams = _.isEmpty(teams) ? [{}] : teams;
                    if (item.subItems && item.subItems.length > 0) {
                        let storyPoints = 0;
                        let childCount = {"ToDo": 0, "InProgress": 0, "Done": 0, "Misc": 0};
                        _.each(item.subItems, child => {
                            let teamContainers = _this.getTeamAndContainers(child);
                            child.containers = teamContainers["containers"];
                            child.teams = teamContainers["teams"];
                            if (child.status) {
                                storyPoints += (child.storyPoints ? child.storyPoints : 0);
                                if (_this.verifyItemsToExclude(child, _this.excludeItemsData)){
                                    childCount[child.status.category] += 1;
                                }
                            }
                        });
                        item.childContByStatus = childCount;
                        item.storyPoints = storyPoints;
                    }
                    item.expandChild = false;
                })
            }
        },

        getTeamAndContainers: function (item) {
            let _this = this;
            let teams = [];
            let containers = [];
            if (!_.isEmpty(item.teamContainers)) {
                _.each(item.teamContainers, tc => {

                    //.........................
                    let teamExist = false;
                    _.each(teams, et => {
                        if (et && et.id === tc.team.id) {
                            teamExist = true;
                            return;
                        }
                    });
                    if (!teamExist) {
						team = {};
						if(_this.showBoardLinkedItem) {
							team = _.find(_this.board.teams, {id: tc.team.id})
						} else {
	                        team = _.find(_this.$parent.board.teams, {id: tc.team.id});
						}
						if(!_.isEmpty(team)) {							
	                        teams.push(team);
						}
                    }
                    //........................
                    let containerExist = false;
                    _.each(containers, et => {
                        if (et && et.id === tc.container.id) {
                            containerExist = true;
                            return;
                        }
                    });
                    if (!containerExist) {
                        let container = {}
						if(_this.showBoardLinkedItem) {
							container = _.find(_this.board.containers, {id: tc.container.id});							
						} else {
							container = _.find(_this.$parent.board.containers, {id: tc.container.id});
						}
                     containers.push(container);
                    }
                });
            }
            return {"teams": teams, "containers": containers};
        },

        getFormatedDecimal: function (value) {
            if (!value) {
                return 0;
            }
            return getFormated(value);
        },

		removeLinkedExternalItemId: function (itemId) {
			var _this = this;
			var item = {};
			item.id = itemId;
			item.isDeletedItem = true;
            askFromSweetAlertWrapper("Do you want to remove this link?",
                [_this.unlinkItem, item],[takeNoAction]);			
		},
        onClickRemoveLink: function (index) {
            let _this = this;
            let item = _this.objectiveLinkedItemsList[index];
            let message = "Do you want to remove this link?"
            askFromSweetAlertWrapper(message,
                [function () {
                    _this.unlinkItem(item);
                }],
                [takeNoAction]);
        },

        onDragEnd(event) {
            const draggedItem = this.objectiveLinkedItemsList[event.oldIndex];

            const itemIdToIndexMap = new Map();
            this.objectiveLinkedItemsList.forEach((item, index) => {
                itemIdToIndexMap.set(item.id, index);
            });

            this.baseItemLinks = this.baseItemLinks.sort((a, b) => {
                const aIndex = itemIdToIndexMap.get(a.itemId);
                const bIndex = itemIdToIndexMap.get(b.itemId);
                return aIndex - bIndex; // Sort by the order of linkedItems
            });

            const newSequence = this.calculateNewSequenceOfItem(
                event.newIndex,
                event.oldIndex,
                this.baseItemLinks,
                'sequence'
            );
        
            const baseItemLink = this.baseItemLinks.find(link => link.itemId === draggedItem.id);

            if (event.oldIndex > event.newIndex) {
				this.objectiveLinkedItemsList.splice(event.oldIndex, 1);
				this.objectiveLinkedItemsList.splice(event.newIndex, 0, draggedItem);
			} else {
				this.objectiveLinkedItemsList.splice(event.newIndex + 1, 0, draggedItem);
				this.objectiveLinkedItemsList.splice(event.oldIndex, 1);
			}
        
            if (baseItemLink) {
                baseItemLink.sequence = newSequence.value;
        
                let _this = this;
                // Update the backend
                axios.post('/objective/update-base-item-link-sequence', {
                    baseItemLinkId: baseItemLink.id,
                    sequence: newSequence.value,
                })
                .then(response => {
                    if (response && response.status == "200") {
                       _this.$emit("update-link-sequence", response.data.baseItemLink);
                    }
                })
                .catch(error => {
                    console.error("Error updating sequence:", error);
                });
            }
        
            // Reorder `baseItemLinks` locally
            const movedLink = this.baseItemLinks.splice(event.oldIndex, 1)[0];
            this.baseItemLinks.splice(event.newIndex, 0, movedLink);
        },

        calculateNewSequenceOfItem: function (newIndex, oldIndex, list, key) {
			var sequence;
			if (_.isEmpty(list)) {
				sequence = 0;
			} else {
				if (newIndex == 0) {
					var nextItem = list[0].item ? list[0].item : list[0];
					sequence = nextItem[key] - 1000;
				} else if (newIndex >= list.length - 1) {
					var preItem = list[list.length - 1].item ? list[list.length - 1].item : list[list.length - 1];
					sequence = preItem[key] + 1000;
				} else {
					var preItem;
					var nextItem;

					if (oldIndex == -1 || oldIndex > newIndex) {
						preItem = list[newIndex - 1].item ? list[newIndex - 1].item : list[newIndex - 1];
						nextItem = list[newIndex].item ? list[newIndex].item : list[newIndex];
					} else {
						preItem = list[newIndex].item ? list[newIndex].item : list[newIndex];
						nextItem = list[newIndex + 1].item ? list[newIndex + 1].item : list[newIndex + 1];
					}
					sequence = (preItem[key] + nextItem[key]) / 2.0;
				}
			}
			return {value: sequence, key: key};
		},

        unlinkItem: function (item) {
            let _this = this;
            let requestBody = {};
            if (_this.$parent.objectiveData) {
                requestBody.id = _this.$parent.objectiveData.id;
            }else if (_this.$parent.fieldsValue.id){
                requestBody.id = _this.$parent.fieldsValue.id;
            }
            requestBody.itemId = item.id;
            if (_this.$parent.objectiveData && _this.$parent.objectiveData.type === "KR"){
                requestBody.metaMap = {
                    "syncId" : syncId,
                    "sessionId" : vueInstance.activeBoard.session.id,
                    "objectiveId" : _this.$parent.$parent.objectiveData.id
                }
            }else{
                requestBody.metaMap = {
                    "syncId" : syncId,
                    "sessionId" : vueInstance.activeBoard.session.id,
                }
            }
            axios.post('sos/remove-base-item-link', requestBody)
                .then(response => {
                    if (response && response.status == "200") {
                        _.remove(_this.objectiveLinkedItemsList, {id: item.id});
						if(_this.linkedItemsById[item.id]) {
							delete _this.linkedItemsById[item.id]
						}

                        _.remove(_this.baseItemLinks, {itemId: item.id});
                        // _this.$forceUpdate();
                        _this.$emit("remove-link", item.id);
                    }
                })
                .catch(error => {
                    console.error("Item Link remove error", error);
                    handleSoSErrorMsg(error);
                })
        },
		statusCategoryClass: function(item) {
			if(item.status.category == "ToDo") {
				return 'a';
			} else if(item.status.category == "InProgress") {
				return 'b';
			} else if(item.status.category == "Done") {
				return 'c';
			} else if(item.status.category == "Misc") {
				return 'd';
			}				
		},
		resolveJiraAndKendisOnlyUrl: function(linkData) {
			if(!_.isEmpty(linkData.jiraURL)) {
				return linkData.jiraURL;
			} else if(!_.isEmpty(linkData.externalReferenceURL) && linkData.externalReferenceURL !== "javascript:void(0);") {
				return linkData.externalReferenceURL;
			} else if(!_.isEmpty(linkData.jiraId) && !_.isEmpty(this.board)){
                let baseURL = getBoardBaseUrl(this.board);
                return baseURL + "/" + linkData.jiraKey;
			} else {
				return '';
			}
		},
		handleLinkClick(event, item) {
            let link = this.resolveJiraAndKendisOnlyUrl(item);
            if (link === '') {
              event.preventDefault();
            }
        }
    }
});

const OBJECTIVE_ROW_COMPONENT = Vue.component('objective-row-component', {
    mixins: [MILESTONE_MIXIN, CALCULATION_SETTINGS_MIXIN, BACKLOG_ITEM_MIXIN, OBJECTIVE_MIXIN,URL_PARAMETER_MIXIN],
    props: {
        objective: {
            type: Object, 
			default: () => {
                return {};
            }
        },
        objectiveTeam: {
            type: Object,
            default: () => {
                return {};
            }
        },
		board: {
            type: Object, 
			default: () => {
                return {};
            }
        }, 
		departmentsMap: {
            type: Object, 
			default: () => {
                return {};
            }
        },
		sessionsMap: {
            type: Object, 
			default: () => {
                return {};
            }
        },
		batchesMap: {
            type: Object, 
			default: () => {
                return {};
            }
        },
        okrList: {
            type: Array,
            default: () => {
                return [];
            }
        },
        isUserSearching: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        isSolutionBoard: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        solutionBoard: {
            type: Object,
            default: () => {
                return {};
            }
        },
        groupId: {
            type: String,
            default: () => {
                return "";
            }
        },
        parentId: {
            type: String,
            default: () => {
                return "";
            }
        },
        readOnlyView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
		showUnLinkedItems: {
            type: Boolean,
            default: () => {
                return false;
            }			
		},
		hideOkr: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
        isMockingMode: {
            type: Boolean,
            default: () =>{ return false }
        },
		isFeatureDetailView: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
        isArt: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        releaseTrainId: {
            type: String,
            default: () => {
                return "";
            }
        },
        isGlobalObjectiveView: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
		isPrioritizedObjListingView: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
		isItemsLoaded: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
        krProgressCriteriaFieldId: {
            type: String,
            default: () => {
                return '';
            }
		},
	    useOldApiForOldStateData: {
		    type: Boolean,
		    default: () => {
			    return false;
		    }
	    },
        parentObjectiveKey: {
            type: String,
            default: () => {
                return '';
            }
        },
        objectiveColumnSettings: {
            type: Array,
            default: () => {
                return [];
            }
        },
        timePeriodFilter: {
            type: Object,
            default: () => {
                return {};
            }
        },
        krParentTimePeriodFieldId: {
			type: String,
			default: () => {
				return ''
			}
		},
        krParentStartDateFieldId: {
            type: String,
            default: () => {
                return ''
            }
        },
        krParentEndDateFieldId: {
            type: String,
            default: () => {
                return ''
            }
        },
        krParent: {
            type: Object,
            default: () => {
                return {};
            }
        },
        setDetailsActive: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        openDynamicPopup :{
            type: String,
            default: () => {
                return ''
            }
        },
        isObjectiveMainView:{
            type: Boolean,
            default: () => {
                return false;
            }
        },
        isSOSPage:{
            type: Boolean,
            default: () => {
                return false;
            }
        },
        disableObjProgressPopup:{
            type: Boolean,
            default: () => {
                return false;
            }
        },
        customView:{
            type: Object,
            default: () => { }
        },
        isBatchView: {
            type: Boolean,
            default: () => {
                return false;
            }
        }
    },

    template: /*html*/`
		<div v-observe-visibility="onVisiblityChange" class="obj-value prow">
			<span :class="[showLinkedItems ? 'obj-li ovs active' : 'obj-li ovs' , getClassForRowDiv()]" v-if="openDynamicPopup === ''">
				<div class="rec add" v-if="showEditView" v-click-outside="closeEditView">
					<div class="rc c2" v-if="isNotOkr()">
						<textarea v-model="editObjectiveData.title" :class="[!isEditCustomObjectiveInputValid ? 'required': '']" placeholder="Describe Objective..." maxlength="750" ref="editObjectiveTitle" @keydown.enter.prevent="handleObjectiveEditEnter" style="resize: vertical;" />
						<!--<input type="text" v-model="editObjectiveData.title" :class="[!isEditCustomObjectiveInputValid ? 'required': '']" placeholder="Describe Objective..." maxlength="750" ref="editObjectiveTitle" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" @keyup.enter="objectiveMenuOptions['isBVAchievementEnabled'] ? moveNext('editObjectiveBvPlan'):onSaveEditObjectiveData(editObjectiveData)">-->
						<small class="mstxt red-msg" v-show="!isEditCustomObjectiveInputValid">Title is required</small>
					</div>
					<div class="rc c2" v-else>
						<textarea v-model="editObjectiveData.title" :class="[!isEditCustomObjectiveInputValid ? 'required': '']" placeholder="Describe Objective..." maxlength="750" ref="editObjectiveTitle" @keydown.enter.prevent="handleOkrEditEnter" style="resize: vertical;" />
						<!--<input type="text" v-model="editObjectiveData.title" :class="[!isEditCustomObjectiveInputValid ? 'required': '']" placeholder="Describe Objective..." maxlength="255" ref="editObjectiveTitle" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" @keyup.enter="objectiveMenuOptions['isOkrBVAchievementEnabled'] ? moveNext('editObjectiveBvPlan') : onSaveEditObjectiveData(editObjectiveData)">-->
						<small class="mstxt red-msg" v-show="!isEditCustomObjectiveInputValid">Title is required</small>
					</div>
					<template v-if="isNotOkr() && objectiveMenuOptions['isBVAchievementEnabled'] && !isMockingMode">
						<div class="rc c1 a"><input type="number" v-model="editObjectiveData.bvPlan" maxlength="999" @change="formatBVPlanValue" ref="editObjectiveBvPlan" @keydown.enter="moveNext('editObjectiveBvActual')"></div>
						<div class="rc c1 b"><input type="number" v-model="editObjectiveData.bvActual" maxlength="999" @change="formatBVActualValue" ref="editObjectiveBvActual" @keydown.enter="onSaveEditObjectiveData(editObjectiveData)"></div>
					</template>
					<template v-if="!isNotOkr() && objectiveMenuOptions['isOkrBVAchievementEnabled'] && !isMockingMode">
						<div class="rc c1 a"><input type="number" v-model="editObjectiveData.bvPlan" maxlength="999" @change="formatBVPlanValue" ref="editObjectiveBvPlan" @keydown.enter="moveNext('editObjectiveBvActual')"></div>
						<div class="rc c1 b"><input type="number" v-model="editObjectiveData.bvActual" maxlength="999" @change="formatBVActualValue" ref="editObjectiveBvActual" @keydown.enter="onSaveEditObjectiveData(editObjectiveData)"></div>
					</template>
					<div class="r-icons edt DAJ">
						<a href="javascript:void(0);" class="ti-check ico DAJ" @click.stop="onSaveEditObjectiveData(editObjectiveData)"></a>
						<a href="javascript:void(0);" class="ti-close ico DAJ" @click.stop="closeEditView"></a> 
					</div>
				</div>
				<div v-else class="rec oValue" :class="(useOldApiForOldStateData && isItemOfAnotherState)? 'brd-itm' : ''" :style="[(useOldApiForOldStateData && isItemOfAnotherState) ? {'border': '1px solid #ff0000'} : {}]">
					<template v-if="(isNotOkr() || !hideOkr)  && !isMockingMode">
						<div @click.stop="toggleShowLinkedItemsComponent()" class="rc c2 o-item DFCB" >
							<div class="lft DFA-a b">
								<div v-if="!readOnlyView" class="move sortable-handle value-sortable-handle"></div>
								<em class="ti-angle-right acrd-arr"></em>
								<span v-if="objective.type === 'KR'" class="tooltip">
									<em class="ico DIB mr-0 kricona" :class="getKrIconClass(objective)"></em>
									<div class="hovtooltip krtltp">{{objective.fields[okrProgressCriteriaField.id]}}</div>
								</span>								
								<a href="javascript:void(0);" @click.stop="openModalForEditing(objective)" class="ky mr-5"><span v-html="getKey()"></span></a>
								<span class="val" v-html="getTitle"></span>
                                
                                <span class="rnd4 hovbtns trnsn a">
                                	<div class="obedit c-point tooltip" @click="onEditObjective" v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE">
                                		<div class="hovtooltipB">Edit</div>
                                	</div>                               	
	                                <div class="obtarg c-point tooltip" @click.stop="showOkrInput" v-if="$options.permissions && $options.permissions.EDIT_OKR && objectiveMenuOptions['isOkrEnabled'] && objective.type !== 'KR'">
	                                	<div class="hovtooltipB">Create Key Result</div>
	                                </div>
	                                <div class="oblnk1 c-point tooltip" @click.stop="onClickRowAction('link_item')" v-if="$options.permissions && $options.permissions.LINK_UNLINK_OBJECTIVE_ITEMS && !isMockingMode && (objective.itemType?.title === 'Objective' || (objective.type === 'KR' && objective.fields[krProgressCriteriaFieldId] && objective.fields[krProgressCriteriaFieldId] === 'By Items'))">
	                                	<div class="hovtooltipB">Link Item</div>
	                                </div>
                               </span>
								
								<span class="objectoltp DIB tooltip" title="" v-if="!_.isEmpty(objective.description)">
									<span class="infotxt c-point"> </span>
									<span class="hovtooltip desc-area" v-html="objective.description"></span>
								</span>
								
								<span class="objectoltp DIB tooltip" title="" v-if="useOldApiForOldStateData && isItemOfAnotherState">
									<span class="infotxt c-point"> </span>
									<span class="hovtooltip desc-area">Not created in this state</span>
								</span>
							</div>
							<div class="rht DFA">
								<!--<span class="light wht-nwrp mr-10" v-if="!showLinkedItems && !_.isEmpty(baseItemList)" title="Key Results"> KR: {{baseItemList.length}}</span>-->
								<span v-if="okr.parent && okr.child" v-for="(okr, okrIndex) in linkedOkrs" class="mr-10 wht-nwrp txtgr">
								<span class="tooltip">
									<a  href="javascript:void(0);" @click.stop="redirectToGlobalViewUrl">{{okr.parent.key}} </a> 
									<div class="hovtooltipB linkedOkrtips" :class="getClassForTooltipWidth(okr.parent)">{{okr.parent.title}}</div>
								</span>/
								<span class="tooltip">
									<a  href="javascript:void(0);" @click.stop="redirectToGlobalViewUrl">{{okr.child.key}}</a>
									<div class="hovtooltipB linkedOkrtips" :class="getClassForTooltipWidth(okr.child)">{{okr.child.title}}</div>
								</span>								
									<template v-if="okrIndex != linkedOkrs.length-1">, </template>
								</span>
								<div class="rc c1 DAJ fx prg" v-if="!isFeatureDetailView && objectiveMenuOptions['isProgressEnabled']">
									<div class="progrs-bar fx DFA">
									
										<div v-if="!isItemsLoaded" class="singleBarAnimation">
								            <p class="loading-text">Calculating<span class="loading-dots">...</span></p>
									        <div class="loading-line"></div>
								        </div>
									
										<template v-else>
											<template v-if="getCompletionError">
												<div class="bar"><span class="bn" :style="{width: '0%'}"></span></div>
												<div class="alert ti-alert c-point p-abs orgtxt" @click.stop="toggleWeightSummaryView" onmouseover="showRealValue(this);" :data-real-value="completion"> {{getOkrCompletionMap["error"+objectiveData.id]}}</div>
											</template>
											<template v-else>
												<template v-if="showBarAndPercentage(completion)">
													<div class="bar"><span class="bn" :style="{width: (completion > 0)? completion +'%' : 0+'%'}"></span></div>
													<div class="val ml-5 c-point" @click.stop="toggleWeightSummaryView" onmouseover="showRealValue(this);" :data-real-value="completion">{{completion}}%</div>
												</template>
											</template>
										</template>
									</div>
								</div>
								<div class="rc c1 DAJ fx sts" v-if="isStatusEnabled">
									<div v-if="!editOkrStatus.show" class="status">
										<span v-if="objective && objective.status" class="sts" :class="[objective.status.category === 'ToDo' ? 'a' : (objective.status.category === 'InProgress' ? 'b' : (objective.status.category === 'Done' ? 'c' : 'd'))]">{{objective.status.title}}</span>
									</div>
                                    <span class="obj-inline-edt ml-5" v-if="!editOkrStatus.show && ((objective.type === 'KR' && $options.permissions?.EDIT_OKR) || (objective.type.includes('Objective') && $options.permissions?.EDIT_OBJECTIVE))">
                                        <em class="obj-inline-edt-ico ico DIB mr-5 ti-pencil c-point" @click="onEditOKRStatus"></em>
                                    </span>
                                    <div v-if="editOkrStatus.show" v-click-outside="closeAllInlineEdits">
                                        <div class="w-130 rnd6 c-point selectcont wht mr-10">
                                            <vz-select v-model="editOkrStatus.status" :multiple="false" track-by="id" value-type="id" label="title" :options="getOkrStatuses" @select="onSelectOkrStatus"></vz-select>
                                        </div>
                                    </div>
								</div>
							</div>
						</div>
						<vuepopup v-if="showWeightageSummaryView" @close="showWeightageSummaryView=false;">
							<div class="overlay" style="display: block;"></div>
							<div class="add-pop ui-dialog calcltn" style="display: block;">
								<div class="head">Weights For Calculation <a @click.stop="toggleWeightSummaryView" href="javascript:void(0);" title="Close" class="rmv-ico ti-close"></a></div>
								<div class="cntr prow">
								    <template v-if="!_.isEmpty(objectiveData.linkedItems)">
                                        <div class="rec">
                                            <span class="FL mr-10 ftsb wht-nwrp">{{okrWeightPercentage()}}%</span>
                                            <!--                                               <a href="javascript:void(0);" class="ky FL mr-5 wht-nwrp">Link}</a>-->
                                            <span class="val">Linked Cards</span>
                                            <div class="achivt prog_2 prg">
                                                <div><span :style="{width: objLinkedItemsCompletion+'%'}"></span></div>
                                                <strong data-real-value="0">{{objLinkedItemsCompletion}}%</strong>
                                            </div>
                                        </div>
                                        <div class="rec" v-for="okr in objectiveData.baseItemList">
											<span class="FL mr-10 ftsb wht-nwrp">{{okrWeightPercentage(okr)}}%</span>
											<a href="javascript:void(0);" class="ky FL mr-5 wht-nwrp">{{okr.key}}</a>
											<span class="val" v-html="okr.title"></span>
											<div class="achivt prog_2 prg">
												<div><span :style="{width: calculateOkrCompletion(okr)+'%'}"></span></div>
												<strong data-real-value="0">{{calculateOkrCompletion(okr)}}%</strong>
											</div>
										</div>
                                    </template>
									<template v-else-if="!_.isEmpty(objectiveData.baseItemList)">
										<div class="rec" v-for="okr in objectiveData.baseItemList">
											<span class="FL mr-10 ftsb wht-nwrp">{{okrWeightPercentage(okr)}}%</span>
											<a href="javascript:void(0);" class="ky FL mr-5 wht-nwrp">{{okr.key}}</a>
											<span class="val" v-html="okr.title"></span>
											<div class="achivt prog_2 prg">
												<div><span :style="{width: calculateOkrCompletion(okr)+'%'}"></span></div>
												<strong data-real-value="0">{{calculateOkrCompletion(okr)}}%</strong>
											</div>
										</div>
									</template>
									<template v-else>
										<div class="nofound">Current objective doesn't have any key results or linked items.</div>
									</template>
								</div>
							</div>
						</vuepopup>
						<template v-if="isNotOkr()">
							<div v-if="objectiveMenuOptions['isBVAchievementEnabled']"    class="val rc c1 DFA a" title="Business Value Planned">
                                {{objective.bvPlan}}
                                <span class="obj-inline-edt ml-auto" v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE">
                                    <em class="obj-inline-edt-ico ico DIB mr-5 ti-pencil c-point" @click="onEditObjective"></em>
                                </span>
                            </div>
						</template>
						<template v-else>
							<div v-if="objectiveMenuOptions['isOkrBVAchievementEnabled']" class="val rc c1 DFA a" title="Business Value Planned">
                                {{objective.bvPlan}}
                                <span class="obj-inline-edt ml-auto" v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE">
                                    <em class="obj-inline-edt-ico ico DIB mr-5 ti-pencil c-point" @click="onEditObjective"></em>
                                </span>
                            </div>
						</template>
						<template v-if="isNotOkr()">
							<div v-if="objectiveMenuOptions['isBVAchievementEnabled']"    class="val rc c1 DFA b" title="Business Value Actual">
                                {{objective.bvActual}}
                                <span class="obj-inline-edt ml-auto" v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE">
                                    <em class="obj-inline-edt-ico ico DIB mr-5 ti-pencil c-point" @click="onEditObjective"></em>
                                </span>
                            </div>
						</template>
						<template v-else>
							<div v-if="objectiveMenuOptions['isOkrBVAchievementEnabled']" class="val rc c1 DFA b" title="Business Value Actual">
                                {{objective.bvActual}}
                                <span class="obj-inline-edt ml-auto" v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE">
                                    <em class="obj-inline-edt-ico ico DIB mr-5 ti-pencil c-point" @click="onEditObjective"></em>
                                </span>
                            </div>
						</template>
						<div v-if="!readOnlyView && showEditOptions" class="prevent r-icons DAJ a">
							<em class="ti-more-alt menu icoa DAJ" @click="onClickShowMenuPopup"></em>
							<vuepopup v-if="showMenuOverlay" @close="showMenuOverlay=false">
								<div class="drop_box nwmu artp sml" style="display:block">
									<ul>
										<template v-if="objective.type === 'KR'">
											<li><a href="javascript:void(0);" @click.stop="openModalForEditing(objective)">View Details</a></li>										
											<li v-if="$options.permissions && $options.permissions.EDIT_OKR"><a href="javascript:void(0);" @click.stop="onEditObjective">Edit Key Result</a></li>
											<li v-if="$options.permissions && $options.permissions.DELETE_OKR"><a href="javascript:void(0);" @click.stop="onClickRowAction('delete')">Delete Key Result</a></li>
										</template>
										<template v-else>
											<li><a href="javascript:void(0);" @click.stop="openModalForEditing(objective)">View Details</a></li>										
											<li v-if="$options.permissions && $options.permissions.LINK_UNLINK_OBJECTIVE_ITEMS && !isMockingMode"><a href="javascript:void(0);" @click.stop="onClickRowAction('link_item')">Link Item</a></li>
											<li v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE"><a href="javascript:void(0);" @click.stop="onEditObjective">Edit Objective</a></li>
											<li v-if="$options.permissions && $options.permissions.EDIT_OKR && objectiveMenuOptions['isOkrEnabled']"><a href="javascript:void(0);" @click.stop="showOkrInput">Add Key Result</a></li>
                                        <!--<li v-if="$options.permissions && $options.permissions.EDIT_OKR && objectiveMenuOptions['isOkrEnabled']"><a href="javascript:void(0);" >Link to OKR</a></li>-->
											<li v-if="$options.permissions && $options.permissions.DELETE_OBJECTIVE"><a href="javascript:void(0);" @click.stop="onClickRowAction('delete')">Delete Objective</a></li>
										</template>
									</ul>
								</div>
							</vuepopup>
						</div>
					</template>
					<template v-else-if="isMockingMode">
						<div @click.stop="toggleShowLinkedItemsComponent()" class="rc c2 o-item DFCB" >
							<div class="lft DAB a">
							<div>
								<div v-if="!readOnlyView && !isInlineEditEnabled" class="move sortable-handle value-sortable-handle cc"></div>
								<em class="ti-angle-right acrd-arr"></em>
								<span v-if="objective.type === 'KR'" class="tooltip">
									<em class="ico DIB mr-0 kricona" :class="getKrIconClass(objective)"></em>
									<div class="hovtooltip krtltp">{{objective.fields[okrProgressCriteriaField.id]}}</div>									
								</span>
								<a href="javascript:void(0);" @click.stop="openModalForEditing(objective)" class="ky mr-5"><span v-html="getKey()"></span></a>
								<span class="val" v-html="getTitle"></span>
								<span class="objectoltp DIB tooltip" title="" v-if="!_.isEmpty(objective.description)">
									<span class="infotxt c-point"> </span>
									<span class="hovtooltip desc-area" v-html="objective.description"></span>
								</span>
								<span v-if="objective.itemType?.title === 'Objective'" class="rnd4 hovbtns trnsn b">
									<div class="obedit c-point tooltip" @click="onEditObjective"                     v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE">
										<div class="hovtooltipB">Edit</div>
									</div>									
									<div class="obtarg c-point tooltip" @click.stop="showOkrInput"                          v-if="!readOnlyView && $options.permissions && $options.permissions.EDIT_OKR">
										<div class="hovtooltipB">Create Key Result</div>
									</div>
	                                <div class="oblnk1 c-point tooltip" @click.stop="onClickRowAction('link_backlog_item')" v-if="!readOnlyView && $options.permissions && $options.permissions.LINK_UNLINK_OBJECTIVE_ITEMS">
	                                	<div class="hovtooltipB">Link Item</div>
	                                </div>
	                                <div class="oblnk2 c-point tooltip" @click.stop="onClickRowAction('link_objective')"    v-if="!readOnlyView && $options.permissions && $options.permissions.LINK_UNLINK_OBJECTIVE_ITEMS">
	                                	<div class="hovtooltipB">Link Objective</div>
	                                </div>
	                                <div class="obmadd c-point tooltip" @click.stop="showChildObjectivePopup"               v-if="!readOnlyView && $options.permissions && $options.permissions.EDIT_OBJECTIVE">
	                                	<div class="hovtooltipB">Create Objective</div>
	                                </div>
                                </span>
                                <span v-else class="rnd4 hovbtns trnsn b">
									<div class="obedit c-point tooltip" @click="onEditObjective"                     v-if="$options.permissions && $options.permissions.EDIT_OKR">
										<div class="hovtooltipB">Edit</div>
									</div>
	                                <div class="oblnk1 c-point tooltip" @click.stop="onClickRowAction('link_backlog_item')" v-if="!readOnlyView && $options.permissions && $options.permissions.LINK_UNLINK_OKR_ITEMS && objective.fields[krProgressCriteriaFieldId] && objective.fields[krProgressCriteriaFieldId] === 'By Items'">
	                                	<div class="hovtooltipB">Link Item</div>
	                                </div>
	                                <div class="oblnk2 c-point tooltip" @click.stop="onClickRowAction('link_objective')"    v-if="!readOnlyView && $options.permissions && $options.permissions.LINK_UNLINK_OKR_ITEMS && objective.type === 'KR' && objective.fields[krProgressCriteriaFieldId] && objective.fields[krProgressCriteriaFieldId] === 'By Objectives'">
	                                	<div class="hovtooltipB">Link Objective</div>
	                                </div>
                                </span>
								<div class="DFA" v-if="objective.itemType?.title === 'Objective'">
									<div v-for="(pi, piIndex) in parentSessions" class="tm lbl-bg tooltip c-point"  :style="{'color': pi.prefixColor ? pi.prefixColor : ''}" @click="redirectToSession(pi)">
										<div class="line" :style="{'background-color': pi.prefixColor ? pi.prefixColor : ''}"></div>
										{{pi.prefix? pi.prefix: pi.title}}
										<div class="hovtooltipB linkokrwithkrtip">{{pi.title}}</div>
									</div>									
								</div>
							</div>
							<div class="p-rel" style="top:1px;">
								<div class="light wht-nwrp mr-10 tooltip" v-if="!showLinkedItems && !_.isEmpty(baseItemList) && baseItemList.some(item => item.type === 'KR') && objective.itemType?.title === 'Objective'"> 
									KR: {{baseItemList.filter(item => item.type === 'KR').length}}
									<div class="hovtooltipB sml">Key Results</div>
								</div>
	                            <div class="light wht-nwrp mr-10 tooltip" v-if="!showLinkedItems && !_.isEmpty(baseItemList) && baseItemList.some(item => item.type.includes('Objective')) && objective.itemType?.title === 'Objective'"> 
	                            	OBJ: {{baseItemList.filter(item => item.type.includes('Objective')).length}}
	                            	<div class="hovtooltipB sml">Objectives</div>
	                            </div>
                            </div>                                
							</div>
							<div class="rht DFA brd-rt-a">

                                <div v-for="(column, index) in objectiveColumnSettings" class="octe b">
                                    <div v-if="column === 'timePeriod'" class="rc c1 DAJ dp" :class="'ob-' + (index + 1)">
                                        <div  class="infotxt mht tooltip">
                                            <div class="hovtooltip tprht rnd4 wht-nwrp" style="top: 20px;">Time Period is not restricted to Parent Objective Time Period</div>
                                        </div>
                                        <div @click="onEditOKRTimePeriod" v-if="objective.itemType.title === 'Objective' && !editOkrTimePeriod.show">
                                            <div class="tooltip" v-if="!_.isEmpty(timePeriodFieldId) && !_.isEmpty(objective.fields) && objective.fields[timePeriodFieldId]">
                                                {{(objective.fields[timePeriodFieldId].title === 'Yearly' ? 'Year' : objective.fields[timePeriodFieldId].title) + " - " + objective.fields[timePeriodFieldId].selectedYear}}
                                                <div class="hovtooltipB sml">{{getTimePeriodTooltip}}</div>
                                            </div>
                                        </div>
                                        <div @click="onEditOKRTimePeriod" v-else-if="!editOkrTimePeriod.show">
                                            <div class="tooltip" v-if="!_.isEmpty(timePeriodKRFieldId) && !_.isEmpty(objective.fields) && objective.fields[timePeriodKRFieldId]">
                                                {{objective.fields[timePeriodKRFieldId].title + " - " + objective.fields[timePeriodKRFieldId].selectedYear}}
                                                <div class="hovtooltipB">{{getTimePeriodTooltip}}</div>
                                            </div>
                                        </div>
                                        <span class="obj-inline-edt ml-5" v-if="!editOkrTimePeriod.show && ((objective.type === 'KR' && $options.permissions?.EDIT_OKR) || (objective.type.includes('Objective') && $options.permissions?.EDIT_OBJECTIVE))">
                                            <em class="obj-inline-edt-ico ico DIB mr-5 ti-pencil c-point" @click="onEditOKRTimePeriod"></em>
                                        </span>

                                        <div v-if="editOkrTimePeriod.show" v-click-outside="closeAllInlineEdits">
                                            <div class="slctdn DFA p-rel c-point rnd4" @click.stop="editOkrTimePeriod.showPopup=!editOkrTimePeriod.showPopup">
                                                {{!_.isEmpty(editOkrTimePeriod.timePeriod)? (editOkrTimePeriod.timePeriod.title === 'Yearly' ? 'Year' : editOkrTimePeriod.timePeriod.title) + " - " + editOkrTimePeriod.timePeriod.selectedYear : "Select Time Period"}}
                                                <time-period-popup
                                                    v-if="editOkrTimePeriod.showPopup"
                                                    :item-time-period="editOkrTimePeriod.timePeriod"
                                                    :item-type="objective.type.includes('Objective') ? 'Objective' : 'KR'"
                                                    :parent-time-period="!_.isEmpty(krParent) && objective.type === 'KR' ? krParent.fields[krParentTimePeriodFieldId] : null"
                                                    @timePeriodSelected="onOkrTimePeriodSelect"
                                                />
                                            </div>
                                        </div>
                                    </div>
                                    <div v-if="column === 'responsible'" @click.stop="!_.isEmpty(responsibleFieldId) && onEditOKRResponsible()" class="rc c1 dp rsp pic DAJ" :class="'ob-' + (index + 1)">
                                        <div v-if="!_.isEmpty(responsibleFieldId) && !_.isEmpty(objective.fields) && objective.fields[responsibleFieldId] && !editOkrResponsible.show" v-html="userImageOrInitialHtml(objective.fields[responsibleFieldId], true)"></div>
                                        <span class="obj-inline-edt ml-5" v-if="!editOkrResponsible.show && ((objective.type === 'KR' && $options.permissions?.EDIT_OKR) || (objective.type.includes('Objective') && $options.permissions?.EDIT_OBJECTIVE))">
                                            <em class="obj-inline-edt-ico ico DIB mr-5 ti-pencil c-point" @click="onEditOKRResponsible"></em>
                                        </span>
                                        <div v-if="editOkrResponsible.show" class="rnd4 w-full" v-click-outside="closeAllInlineEdits">
                                            <pi-user-picker class="rnd4" v-model="editOkrResponsible.responsible" :multiple="false" :allow-unassigned="true" placeholder="Select User" @select="onOkrResponsibleSelect"/>
                                        </div>
                                    </div>
                                    <div v-if="column === 'progress' && !isPrioritizedObjListingView" class="rc c1 DAJ fx" :class="'ob-' + (index + 1)">
                                        <div class="progrs-bar DFA" v-if="!isFeatureDetailView">
                                            <div v-if="!isGlobalCalculationDone" class="singleBarAnimation">
                                                <p class="loading-text">Calculating<span class="loading-dots">...</span></p>
                                                <div class="loading-line"></div>
                                            </div>
                                        
                                            <template v-else>
                                                <template v-if="getCompletionError">
                                                    <div class="bar"><span class="bn" :style="{width: '0%'}"></span></div>
                                                    <div v-if="getOkrCompletionMap['error'+objectiveData.id] == 2" class="alert ti-alert c-point p-abs redtxt tooltip" @click.stop="toggleWeightSummaryView">
                                                        <span class="hovtooltipB sml">Linking between this Objective and Key Result should be removed to resolve the circular loop problem</span>
                                                    </div>
                                                </template>
                                                <template v-else>
                                                    <div class="bar"><span class="bn" :style="{width:(completion > 0)? completion +'%' : 0+'%'}"></span></div>
                                                    <div class="val ml-5 c-point" @click.stop="toggleWeightSummaryView" onmouseover="showRealValue(this);" :data-real-value="completion">{{completion}}%</div>
                                                </template>
                                            </template>
                                            
                                        </div>
                                    </div>
                                    <div v-if="column === 'status'" class="rc c1 DAJ fx" :class="'ob-' + (index + 1)">
                                        <div @click.stop="onEditOKRStatus" class="status" v-if="isStatusEnabled && !editOkrStatus.show">
                                            <span v-if="objective && objective.status" class="sts" :class="[objective.status.category === 'ToDo' ? 'a' : (objective.status.category === 'InProgress' ? 'b' : (objective.status.category === 'Done' ? 'c' : 'd'))]">{{objective.status.title}}</span>
                                        </div>
                                        <span class="obj-inline-edt ml-5" v-if="!editOkrStatus.show && ((objective.type === 'KR' && $options.permissions?.EDIT_OKR) || (objective.type.includes('Objective') && $options.permissions?.EDIT_OBJECTIVE))">
                                            <em class="obj-inline-edt-ico ico DIB mr-5 ti-pencil c-point" @click="onEditOKRStatus"></em>
                                        </span>
                                        <div v-if="editOkrStatus.show" v-click-outside="closeAllInlineEdits">
                                            <div class="selectcont wht w-90pc rnd4">
                                                <vz-select v-model="editOkrStatus.status" :multiple="false" track-by="id" value-type="id" label="title" :options="getOkrStatuses" @select="onSelectOkrStatus"></vz-select>
                                            </div>
                                        </div>
                                    </div>
                                    <div v-if="column === 'association' && !isPrioritizedObjListingView" class="rc c1 DAJ dp" :class="'ob-' + (index + 1)">
                                        <div v-if="isMockingMode" class="">
                                            <div v-for="(dpt, dptIndex) in getDepartments()" class="tm lbl-bg" :title="dpt.title" :style="{'color': dpt.color ? dpt.color : ''}">
                                                <div class="line" :style="{'background-color': dpt.color ? dpt.color : ''}"></div>
                                                {{dpt.shortName}}
                                            </div>
                                            <div v-for="(pi, piIndex) in getSessions" class="tm lbl-bg" :title="pi.title" :style="{'color': pi.prefixColor ? pi.prefixColor : ''}" @click="redirectToSession(pi)">
                                                <div class="line" :style="{'background-color': pi.prefixColor ? pi.prefixColor : ''}"></div>
                                                {{pi.prefix? pi.prefix: pi.title}}
                                            </div>			
                                            <div v-for="(batch, batchIndex) in getBatches" class="tm lbl-bg" :title="batch.title" :style="{'color': batch.headerColor ? batch.headerColor : ''}" @click= "redirectToBatch(batch.key)" >
                                                <div class="line" :style="{'background-color': batch.headerColor ? batch.headerColor : ''}" ></div>
                                                {{batch.key}}
                                            </div>							
                                        </div>
                                    </div>
                                </div>
							</div>
						</div>
						<vuepopup v-if="showWeightageSummaryView" @close="showWeightageSummaryView=false;">
							<div class="overlay" style="display: block;"></div>
							<div class="add-pop ui-dialog calcltn" style="display: block;">
								<div class="head">Weights For Calculation <a @click.stop="toggleWeightSummaryView" href="javascript:void(0);" title="Close" class="rmv-ico ti-close"></a></div>
								<div class="cntr prow">
								    <template v-if="isBackLogItemsLinked">
                                        <div class="rec">
                                            <span class="FL mr-10 ftsb wht-nwrp">{{okrWeightPercentage()}}%</span>
                                            <!--                                               <a href="javascript:void(0);" class="ky FL mr-5 wht-nwrp">Link}</a>-->
                                            <span class="val">Linked Cards</span>
                                            <div class="achivt prog_2 prg">
                                                <div><span :style="{width: objLinkedItemsCompletion+'%'}"></span></div>
                                                <strong data-real-value="0">{{objLinkedItemsCompletion}}%</strong>
                                            </div>
                                        </div>
                                        <div class="rec" v-for="okr in objectiveData.baseItemList">
											<span class="FL mr-10 ftsb wht-nwrp">{{okrWeightPercentage(okr)}}%</span>
											<a href="javascript:void(0);" class="ky FL mr-5 wht-nwrp">{{okr.key}}</a>
											<span class="val" v-html="okr.title"></span>
											<div class="achivt prog_2 prg">
												<div><span :style="{width: getOkrCompletionMap[okr.id]+'%'}"></span></div>
												<strong data-real-value="0">{{getOkrCompletionMap[okr.id]}}%</strong>
											</div>
										</div>
                                    </template>
									<template v-else-if="!_.isEmpty(objectiveData.baseItemList)">
										<div class="rec" v-for="okr in objectiveData.baseItemList">
											<span class="FL mr-10 ftsb wht-nwrp">{{okrWeightPercentage(okr)}}%</span>
											<a href="javascript:void(0);" class="ky FL mr-5 wht-nwrp">{{okr.key}}</a>
											<span class="val" v-html="okr.title"></span>
											<div class="achivt prog_2 prg">
												<div><span :style="{width: getOkrCompletionMap[okr.id]+'%'}"></span></div>
												<strong data-real-value="0">{{getOkrCompletionMap[okr.id]}}%</strong>
											</div>
										</div>
									</template>
									<template v-else>
										<div class="nofound">Current objective doesn't have any key results or linked items.</div>
									</template>
								</div>
							</div>
						</vuepopup>						
						<div v-if="!readOnlyView && showEditOptions" class="prevent r-icons DAJ">
							<em class="ti-more-alt menu icoa DAJ" @click="onClickShowMenuPopup"></em>
							<vuepopup v-if="showMenuOverlay" @close="showMenuOverlay=false">
								<div class="drop_box nwmu artp sml" style="display:block">
									<ul>
										<template v-if="objective.type === 'KR'">
											<li><a href="javascript:void(0);" @click.stop="openModalForEditing(objective)">View Details</a></li>																				
											<li v-if="$options.permissions && $options.permissions.EDIT_OKR"><a href="javascript:void(0);" @click.stop="onEditObjective">Edit Key Result</a></li>
											<li v-if="$options.permissions && $options.permissions.LINK_UNLINK_OKR_ITEMS && objective.fields[krProgressCriteriaFieldId] && objective.fields[krProgressCriteriaFieldId] === 'By Items'"><a href="javascript:void(0);" @click.stop="onClickRowAction('link_backlog_item')">Link Item</a></li>
											<li v-if="$options.permissions && $options.permissions.DELETE_OKR"><a href="javascript:void(0);" @click.stop="onClickRowAction('delete')">Delete Key Result</a></li>
										</template>
										<template v-else>
											<li><a href="javascript:void(0);" @click.stop="openModalForEditing(objective)">View Details</a></li>																				
											<li v-if="$options.permissions && $options.permissions.LINK_UNLINK_OBJECTIVE_ITEMS && !showBoardLinkedItem"><a href="javascript:void(0);" @click.stop="onClickRowAction('link_backlog_item')">Link Item</a></li>
											<li v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE"><a href="javascript:void(0);" @click.stop="onEditObjective">Edit Objective</a></li>
											<li v-if="$options.permissions && $options.permissions.EDIT_OKR"><a href="javascript:void(0);" @click.stop="showOkrInput">Add Key Result</a></li>
											<li v-if="$options.permissions && $options.permissions.DELETE_OBJECTIVE"><a href="javascript:void(0);" @click.stop="onClickRowAction('delete')">Delete Objective</a></li>
										</template>
									</ul>
								</div>
							</vuepopup>
						</div>						
					</template>
				</div>
				
                <!-- Custom linked items list component is created to introduce drag and drop functionlaity for PI objective linked items -->
				<!--<list-linked-items
					v-if="showLinkedItems && showBoardLinkedItem && (objective.itemType.title === 'Objective' || objective.fields[krProgressCriteriaFieldId] && objective.fields[krProgressCriteriaFieldId] === 'By Items')"
					:linked-items="objectiveData.linkedItems"
					:show-un-linked-items="showUnLinkedItems"
					:linkedItemsById="objectiveData.linkedItemsById"									
					:completionCriteria="completionBy"
					:objective-team="(completionBy && (completionBy == 'TEAM_STORY_STATUS' || completionBy == 'TEAM_STORY_ESTIMATE')) ? objectiveTeam : {}"
					:read-only-view="readOnlyView"
					:board="(showBoardLinkedItem && isMockingMode) ? sessionBoard : board"
					:remove-item-permission="$options.permissions.LINK_UNLINK_OBJECTIVE_ITEMS"
					:show-board-linked-item="showBoardLinkedItem"
                    :objective="objective"
					@remove-link="removeLinkedItem" />-->

                <objective-list-linked-items
                    v-if="showLinkedItems && showBoardLinkedItem && (objective.itemType?.title === 'Objective' || objective.fields[krProgressCriteriaFieldId] && objective.fields[krProgressCriteriaFieldId] === 'By Items')"
                    :linked-items="objectiveData.linkedItems"
                    :show-un-linked-items="showUnLinkedItems"
                    :linkedItemsById="objectiveData.linkedItemsById"									
                    :completionCriteria="completionBy"
                    :objective-team="(completionBy && (completionBy == 'TEAM_STORY_STATUS' || completionBy == 'TEAM_STORY_ESTIMATE')) ? objectiveTeam : {}"
                    :read-only-view="readOnlyView"
                    :board="(showBoardLinkedItem && isMockingMode) ? sessionBoard : board"
                    :remove-item-permission="$options.permissions.LINK_UNLINK_OBJECTIVE_ITEMS"
                    :show-board-linked-item="showBoardLinkedItem"
                    :objective="objective"
                    @remove-link="removeLinkedItem"
                    @update-link-sequence="updateOkrLinkedItemSequence"
                ></objective-list-linked-items>
					
				<div v-if="isMockingMode && !showBoardLinkedItem" class="lnkitm-o prow rlstrn mnpg">
                    <div class="table prow back-item" >
                        <backlog-items-renderer v-if="isBackLogItemsLinked && showLinkedItems && isMockingMode && (objective.itemType?.title === 'Objective' || objective.fields[krProgressCriteriaFieldId] && objective.fields[krProgressCriteriaFieldId] === 'By Items')" 
	                        :key="backLogComponentKey"
	                        :link-unlink-permission="(objective.type === 'KR' ? $options.permissions.LINK_UNLINK_OKR_ITEMS:  $options.permissions.LINK_UNLINK_OBJECTIVE_ITEMS)"
						    :back-log-items-grouped = "backLogItemsGrouped"  
						    :back-log-items = "backLogItems" 
						    :base-item="objectiveData" 
						    :base-item-links="objectiveData.baseItemLinks" 
						    :back-log-item-session-board-map="backlogItemsMetaDetails.backLogItemSessionBoardMap" 
	                        :backlog-items-statuses-map="backlogItemsMetaDetails.backlogItemsStatusesMap" 
	                        :backlog-items-solution-board-map="backlogItemsMetaDetails.backlogItemsSolutionBoardMap" 
	                        :backlog-items-teams-map="backlogItemsMetaDetails.backlogItemsTeamsMap" 
	                        :backlog-items-sprints-map="backlogItemsMetaDetails.backlogItemsSprintsMap"  
						    :itemsGroupedByReleaseTrain="itemsGroupedByReleaseTrain" 
						    :isListingView="true" 
						    :read-only = "readOnlyView"
                            :completion-criteria="objectiveData.completionCriteria"
						    @remove-backLog-item="removeBackLogItem" 
						    @showItemsForReleaseTrain="showItemsForReleaseTrain" />
    
                        <link-item v-if="showBackLogItemsPopup && isMockingMode" 
                            :fetch-user-stories="true"
                            :fetch-features="true"
                            title="Link Items"
                            :isMockingMode="isMockingMode"
                            :release-train-id="releaseTrainId ? releaseTrainId : parentObjectiveGroupArtId"
                            :backLogItemsMode="true"
                            :selected-items="backLogItems"
                            :showBoardFilter="false"
                            :base-item-links="objective.baseItemLinks"
                            container="link-item-container"
                            @cancel="onCancelBacklogItemLinking"
                            @save="saveBackLogItems"
                            ></link-item>
                    </div>
                </div>

                <div v-if="krProgressCriteriaEdit.show" class="target DFA" v-click-outside="onCloseKrProgressCriteriaEdit" @keydown.enter="handleKrTargetCrietriaUpdate" tabindex="0" ref="krProgressCriteriaEdit">
                    <label class="mr-10">Start</label>
                    <input v-model.number="krProgressCriteriaEdit.startValue" type="number" maxlength="255" class="w-100" />

                    <label class="mr-lr-10">Target</label>
                    <input v-model.number="krProgressCriteriaEdit.targetValue" type="number" maxlength="255" class="w-100" />

                    <label class="mr-lr-10">Unit</label>
                    <input v-model="krProgressCriteriaEdit.unitValue" type="text" maxlength="255" class="w-100" />

                    <label class="mr-lr-10">Progress</label>
                    <input v-model.number="krProgressCriteriaEdit.progressValue" type="number" maxlength="255" class="w-100" />

                    
					<div class="ml-20 r-icons edt DAJ brd-lt pl-20">
						<img src="/assets/icons/check-green-filled.svg" alt=".." class="mr-10 c-point" @click="handleKrTargetCrietriaUpdate">
						<img src="/assets/icons/cross-red-filled.svg" alt=".." class="c-point" @click.stop="onCloseKrProgressCriteriaEdit">
					</div>
				</div>
                
                <div v-if="showLinkedItems && (objective.itemType.title === 'KR' && objective.fields[krProgressCriteriaFieldId] && objective.fields[krProgressCriteriaFieldId] === 'Target') && !krProgressCriteriaEdit.show" class="target DFA">
					<div class="rc1 DFA spttg nsw" style="cursor: text;" @click.stop="!readOnlyView && onClickEditKrProgressCriteria()">Start <span>{{getTargetCriteriaValues('start')}}</span><em class="ti-pencil c-point edt trnsn"></em></div>
					<div class="rc1 DFA spttg nsw" style="cursor: text;" @click.stop="!readOnlyView && onClickEditKrProgressCriteria()">Target <span>{{getTargetCriteriaValues('target')}}</span><em class="ti-pencil c-point edt trnsn"></em></div>
					<div class="rc1 DFA spttg nsw" style="cursor: text;" @click.stop="!readOnlyView && onClickEditKrProgressCriteria()">Unit <span>{{getTargetCriteriaValues('unit')}}</span><em class="ti-pencil c-point edt trnsn"></em></div>
					<div class="rc1 DFA spttg nsw" style="cursor: text;" @click.stop="!readOnlyView && onClickEditKrProgressCriteria()">Progress <span>{{getTargetCriteriaValues('progress')}}</span><em class="ti-pencil c-point edt trnsn"></em></div>
				</div>
					
			</span>
			<div v-show="showLinkedItems && (objective.itemType?.title === 'Objective' || objective.fields[krProgressCriteriaFieldId] && objective.fields[krProgressCriteriaFieldId] === 'By Objectives')  && !isSOSPage" class="okr ui-sortable obj-dragg prow">
				<template v-if="baseItemList && baseItemList.length > 0">
					<div v-sortable="$options._valueSortableOptionsOkr" :data-type="'okr'" :data-id="objective.id" class="sm-objective oboutst okrw prow">
						<objective-row-component v-for="okrItem in baseItemList"
							:parent-id="objective.id"
							:group-id="groupId"
							:key="okrItem.id+'_'+dynamicOkrItemKey"
							:ref="'KR_' + okrItem.id"
							:board="board"
							:objective="okrItem"
							:readOnlyView="readOnlyView"
							:hide-okr="hideOkr"
							:departments-map="departmentsMap"
							:is-mocking-mode="isMockingMode"
							:is-feature-detail-view="isFeatureDetailView"
							:is-prioritized-obj-listing-view= "isPrioritizedObjListingView"
							:kr-progress-criteria-field-id = "krProgressCriteriaFieldId"
							:okr-list="childList"
							:sessions-map="childSessionsMap"
							:is-items-loaded="isItemsLoaded"
							:release-train-id="releaseTrainId"
							:use-old-api-for-old-state-data="useOldApiForOldStateData"
                            :objective-column-settings="objectiveColumnSettings"
                            :kr-parent-time-period-field-id="_.isEmpty(krParentTimePeriodFieldId) ? timePeriodFieldId : krParentTimePeriodFieldId"
                            :kr-parent-start-date-field-id="krParentStartDateFieldId"
                            :kr-parent-end-date-field-id="krParentEndDateFieldId"
                            :kr-parent="objective"
                            :isObjectiveMainView="isObjectiveMainView"
                            :setDetailsActive="setDetailsActive"
                            :customView="customView"
                            :is-batch-view="isBatchView"
							@completionCriteria="objectiveCompletionCriteriaChild"
							@onSaveEditOkr="onSaveEditOkr"
							@deleteObjective="deleteOkr"
							@updateOkrList="updateOkrList"
							@updateKeyResultCriteria="updateKeyResultCriteria"
							@open-objective-container="openObjectiveContainer"
							@open-linked-obj="openLinkedObjective"
							@close-parent-container="closeParentContainer" />
					</div>
				</template>
                <div class="rec add" v-if="showAddCommittedObjectiveInput">
					<div class="rc c2">
						<textarea v-model="newObjectiveDataCommitted.title" :class="[!isAddCommittedObjectiveInputValid ? 'required': '']" placeholder="Describe Objective..." maxlength="750" ref="newObjectiveTitleRef" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" style="resize: vertical;" />
						<!--<input type="text" v-model="newObjectiveDataCommitted.title" :class="[!isAddCommittedObjectiveInputValid ? 'required': '']" placeholder="Describe Objective..." maxlength="255" ref="newObjectiveTitleRef" @keyup.enter="objectiveMenuOptions['isBVAchievementEnabled'] && !isMockingMode ? moveNext('newObjectiveBvPlan') : saveCommittedObjective()" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)">-->
						<small class="mstxt red-msg" v-show="!isAddCommittedObjectiveInputValid">Title is required</small>
					</div>
					<div class="tmperid" v-if="isMockingMode">
                        <div v-if="isMockingMode" class="slctdn DFA p-rel c-point rnd4 w-230" @click.stop="newObjectiveDataCommittedTimePeriod.showPopup=!newObjectiveDataCommittedTimePeriod.showPopup" :class="[!isAddCommittedChildObjectiveTimePeriodValid ? 'required': '']">
                            <div class="DAJ">{{!_.isEmpty(newObjectiveDataCommittedTimePeriod.period )? (newObjectiveDataCommittedTimePeriod.period.title === 'Yearly' ? 'Year' : newObjectiveDataCommittedTimePeriod.period.title) + " - " + newObjectiveDataCommittedTimePeriod.period.selectedYear : "Select Time Period"}}</div>
                            <time-period-popup
                                v-if="newObjectiveDataCommittedTimePeriod.showPopup"
                                :item-time-period="newObjectiveDataCommittedTimePeriod.period"
                                @timePeriodSelected="onSelectNewObjTimePeriod"
                            ></time-period-popup>
                        </div>
                    </div>
					<div class="r-icons edt DAJ">
						<a href="javascript:void(0);" class="ti-check ico DAJ" @click="saveCommittedObjective"></a>
						<a href="javascript:void(0);" class="ti-close ico DAJ" @click="closeCommittedObjectiveForm"></a> 
					</div>
				</div>
				<div class="rec add" v-if="showOkrInputForm">
					<div class="rc c2"><textarea :class="[!isAddCommittedObjectiveTitleValid ? 'required': '']" type="text" v-model="newOkr.title" placeholder="Describe Key Result" maxlength="750" ref="newOkrTitleRef" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" @keyup.enter="objectiveMenuOptions['isOkrBVAchievementEnabled'] && !isMockingMode ? moveNext('newOkrBvPlan') : saveOkr()" style="resize: vertical;" /></div>
					<div class="tmperid DF">
					<div class="selectcont wht rnd4 w-200 mr-10" :class="[!isAddCommittedObjectiveProgressCriteriaValid ? 'required': '']">
						<select v-model="newOkr.fields[okrProgressCriteriaField.id]">
							<option disabled value="">Select Criteria</option>
							<option>Target</option>
							<option>By Items</option>
							<option v-if="isMockingMode">By Objectives</option>						
						</select>
					</div>
                    <div v-if="isMockingMode" class="slctdn DFA p-rel c-point rnd4 w-200" @click.stop="(objective.fields?.[krParentTimePeriodFieldId]) ? (timePeriod.showPopup = !timePeriod.showPopup) : null" :class="[!isAddCommittedObjectiveTimePeriodValid ? 'required': '', objective.fields && objective.fields[krParentTimePeriodFieldId] ? '' : 'disabled']">
                        <div class="DAJ">{{!_.isEmpty(timePeriod.period )? (timePeriod.period.title === 'Yearly' ? 'Year' : timePeriod.period.title) + " - " + timePeriod.period.selectedYear : "Select Time Period"}}</div>
                        <time-period-popup
                            v-if="timePeriod.showPopup"
                            :item-time-period="timePeriod.period"
                            :item-type="'KR'"
                            :parent-time-period="objective.fields && objective.fields[krParentTimePeriodFieldId]"
                            @timePeriodSelected="onSelectTimePeriod"
                        ></time-period-popup>
                    </div>
					</div>
					<!--<div class="rc c2"><input type="text" v-model="newOkr.title" placeholder="Describe Key Result" maxlength="255" ref="newOkrTitleRef" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" @keyup.enter="objectiveMenuOptions['isOkrBVAchievementEnabled'] && !isMockingMode ? moveNext('newOkrBvPlan') : saveOkr()"></div>-->
					<template v-if="objectiveMenuOptions['isOkrBVAchievementEnabled'] && !isMockingMode">
						<div class="rc c1 a"><input type="number" v-model="newOkr.bvPlan" maxlength="999" @change="formatBVPlanValue" ref="newOkrBvPlan" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" @keyup.enter="moveNext('newOkrBvActual')"></div>
						<div class="rc c1 b"><input type="number" v-model="newOkr.bvActual" maxlength="999" @change="formatBVActualValue" ref="newOkrBvActual" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" @keyup.enter.stop.prevent="saveOkr"></div>
					</template>
					<div class="r-icons edt DAJ">
						<a href="javascript:void(0);" class="ti-check ico DAJ" @click.stop="saveOkr"></a>
						<a href="javascript:void(0);" class="ti-close ico DAJ" @click.stop="closeOkrInput"></a> 
					</div>
				</div>
			</div>
			<link-item v-if="showLinkItemsPopup && !isMockingMode" 
				:boards="getBoardsForLinking()"
				:board="board"
				:show-board-filter="isSolutionBoard"
				title="Link Items"
				:selected-items="objectiveData.linkedItemsIds"
				container="link-item-container"
				@cancel="closeLinkItemsPopup"
				@save="saveLinkedItems"
				:item-key="objectiveData.key"
				:link-item-for="'objective'"/>
								
        
			<objective-link v-if="showObjectiveLinkingPopup" 
				:boards="getBoardsForLinking()" 
				:board="board"
				:show-board-filter="isSolutionBoard"
				title="Link Objectives"
				:selected-items="objectiveData.linkedItemsIds"
				container="link-item-container"
				@cancel="showObjectiveLinkingPopup=false;"
				@save="saveLinkedObjectives"/>

            <div class="prow accrdcontr">
                <objective-link v-if="showObjectiveChildLinkingPopup && isMockingMode" 
                    :board="board"
                    :item-key="objectiveData.key"
                    :okr-id="objectiveData.id"
                    :is-mocking-mode="isMockingMode"
                    :linked-objectives="objectiveData.itemType?.title === 'KR' ? objectiveData.baseItemList : linkedChildObjectives"
                    :associate-with="{
					id					: 'collection',
					title				: 'Collection OKRs',
					tabNum				: 1
				    }"
                    :okr="objectiveData"
                    title="Link Objectives"
                    :okr-group="parentObjectiveGroup"
                    container="link-item-container"
                    @cancel="showObjectiveChildLinkingPopup=false;"
                    @save="saveLinkedObjectives">
                </objective-link>
            </div>
			<div v-if="showPopupLoader" class="loader">
				<div>
					<div class="loaderinteg"></div>
				</div>
			</div>
			<dynamic-popup-container 
				v-if="itemTemplate.showEditPopUp"
				ref="active-objective"
				:display-mode="displayMode"
				:is-mocking-mode = "isMockingMode"
				:is-global-objective-view="isGlobalObjectiveView"
				:is-art = "isArt"
				:release-train-id="releaseTrainId"
				:setDetailsActive="setDetailsActive"
				:isObjectiveMainView="isObjectiveMainView"
                :objective-group-id="groupId"
				@close = "onCLoseEditPopUp"
				@save = "onSaveEditObjectiveData"
				@delete = "onDeleteObjective"
				@saveOkrWeights="saveOkrWeights"
				@objectiveCompletionCriteria="objectiveCompletionCriteria"
				@keyResultCompletionCriteria="keyResultCompletionCriteria"
				@updateObjectiveGroupList="handleChildCall"
				@delete-objective-okr="onDeleteFromPopup"
				@remove-okr="removeOkr"
				@unlink-obj="unlinkObj"
				@remove-linked-item="removeLinkedItemFromContainer"
                @update-okr-linked-item-sequence="updateOkrLinkedItemSequence"
				@open-parent-container="openParentContainer"
				@open-key-result-container="openKeyResultContainer"
				@open-linked-obj="openLinkedObjContainer"
				@update-backlog-items-columns="updateBacklogItemsColumns"
				:board = "getBoard()"
				:boards = "itemTemplate.boardSession"
				:template-to-render="itemTemplate.templateToRenderer"
				:template-statuses = "itemTemplate.statuses"
				:item-type="itemTemplate.itemType"
				:fields-value="itemTemplate.model"
				:creation-and-update-data="itemTemplate.creationAndUpdateData"
				:template = "itemTemplate"
				:show-attachments="false"
				:show-objective-linking="true"
				:show-watchers="true"
				:show-history="true"
				:show-conversations="true"
				:show-external-entities="true"
				:show-sub-phase-linking="true"
				:add-okr-permission="$options.permissions.EDIT_OKR && board.session.activeSessionBoard == board.id"
				:teams-linking-title="'Link Team'"
				:show-sprint-linking="false"
				:entity-type="'BaseItem'"
				:entity-id="itemTemplate.id"
				:is-inline-editing-enabled="IsInlineEditingEnabled"
                :parent-key="objective.type == 'KR' && $parent.objective ? $parent.objective.key : parentObjectiveKey"
				:parent-id="objective.type == 'KR' || (objective.type.includes('Objective') && !_.isEmpty(parentId)) ? parentId : groupId"
				:edit-permission="(!readOnlyView && (displayMode === 'Objective' ? $options.permissions.EDIT_OBJECTIVE : $options.permissions.EDIT_OKR))"
				:delete-permission="(!readOnlyView && (displayMode === 'Objective' ? $options.permissions.DELETE_OBJECTIVE : $options.permissions.DELETE_OKR))"
				:delete-okr-permission="!readOnlyView && $options.permissions.DELETE_OKR"
				:link-unlink-permission="(!readOnlyView && (displayMode === 'Objective' ? $options.permissions.LINK_UNLINK_OBJECTIVE_ITEMS : $options.permissions.LINK_UNLINK_OKR_ITEMS))"
				:teams-and-groups-options="displayMode === 'Objective' || displayMode === 'Global-Objectives' ? objectiveGroupsCopy : []"
				:objective-team="objectiveTeam"
				:data-loaded="modalDataLoaded"
				:items-loaded="itemsLoaded"
				:sessions-map="itemTemplate.sessionsMap"
				:disable-teams-and-groups="disableGroups"
				:show-board-linked-item="showBoardLinkedItem"
                :kr-parent="$parent.objective"
                :kr-parent-time-period-field-id="krParentTimePeriodFieldId"
                :kr-parent-start-date-field-id="krParentStartDateFieldId"
                :kr-parent-end-date-field-id="krParentEndDateFieldId"
                :isSOSPage="isSOSPage"
                :isPrioritizedObjListingView="isPrioritizedObjListingView"
                :disableObjProgressPopup="disableObjProgressPopup"
                :customView="customView"
                :releaseTrainTitle="getCollectionTitle"
			/>
		</div>
	`,
    data() {
        return {
            newOkr: {
                title				: "",
                bvPlan              : 0,
                bvActual            : 0,
				fields				: {}
            },
            itemTemplate: {
                showEditPopUp			: false,
                showMileStonePopup		: false,
                statuses				: [],
                templateToRenderer		: {},
                itemType				: {},
                creationAndUpdateData 	: {},
            },
            _valueSortableOptionsOkr        : {},
			okrProgressCriteriaField		: {},
            objectiveData					: {},
            editObjectiveData				: {},
			childSessionsMap				: {},
			isScrolling						: {},
			sessionBoardMap					: {},
			sessionBoard					: {},
			displayMode						: '',
			responsibleFieldId              : '',
			krStartFieldId   				: '',
			krTargetFieldId   				: '',
			krProgressFieldId   			: '',
			krUnitFieldId   				: '',	
            timePeriodFieldId               : '',	
            timePeriodKRFieldId             : '',	
            showMenuOverlay					: false,
            showEditView					: false,
            showLinkItemsPopup				: false,
            showBackLogItemsPopup			: false,
            showLinkedItems					: false,
            showOkrInputForm				: false,
            showWeightageSummaryView        : false,
            isEditCustomObjectiveInputValid	: true,
            IsInlineEditingEnabled          : true,
            showPopupLoader                 : false,
			savingKeyResult					: false,
			showEditOptions                 : false,
			isItemOfAnotherState			: false,
			modalDataLoaded					: false,
			itemsLoaded						: false,
			childItemsLoaded				: false,
			linkedOkrsLoaded				: false,
            isBackLogItemsLinked            : false,
			isGlobalCalculationDone			: false,
            showObjectiveLinkingPopup		: false,
			disableGroups					: false,
			isVisible						: false,
			showBoardLinkedItem				: false,
            completion						: 0,
            objLinkedItemsCompletion        : 0,
            dynamicOkrItemKey               : 0,
            backLogComponentKey             : 0,
            objectiveGroupsCopy             : [],
			okrListWithWeights              : [],
			childList						: [],
			linkedOkrs						: [],
			attachedReleaseTrains           : [],
			baseItemList					: [],
			parentSessions					: [],
            // boardsList:[],
            originalBaseItemList			: [],
            startDateFieldId				: '',
            endDateFieldId					: '',
            timePeriod: {
                showPopup: false,
                period: {},
                startDate: "",
                endDate: "",
            },
            isAddCommittedObjectiveTimePeriodValid : true,
            isAddCommittedObjectiveTitleValid : true,
            isAddCommittedObjectiveProgressCriteriaValid : true,
            startDateKRFieldId				: '',
            endDateKRFieldId				: '',
            krProgressCriteriaEdit	        : {
                show: false,
                startValue: '',
                targetValue: '',
                unitValue: '',
                progressValue: ''
            },
            showObjectiveChildLinkingPopup : false,
            showAddCommittedObjectiveInput : false,
            newObjectiveDataCommitted : {
                title		: "",
            },
            newObjectiveDataCommittedTimePeriod : {
                showPopup: false,
                period: {},
                startDate: "",
                endDate: "",
            },
            isAddCommittedObjectiveInputValid : true,
            isAddCommittedChildObjectiveTimePeriodValid : true,
            editOkrStatus                   : {
                show: false,
                status: {},
            },
            editOkrResponsible             : {
                show: false,
                responsible: {},
            },
            editOkrTimePeriod               : {
                show: false,
                showPopup: false,
                timePeriod: {},
                startDate: "",
                endDate: "",
            },
        }
    },

    watch: {
        objective: function (_new, _old) {
            if (_new && _new.linkedItems) {
                _.each(_new.linkedItems, function (item) {
                    item.randomId = getNewUUID();
                });
            }
            this.objectiveData = _new;
        },

        showEditView: function (_new, _old) {
            if (_new) {
                this.$nextTick(() => {
                    const element = this.$refs.editObjectiveTitle;
                    element.focus();
                });
            }
        },
        calculationCriteria: function (newVal, oldVal) {
            this.calculateObjCompletion();
        },
        isUserSearching: function (_new, _old) {
            if (_new) {
                this.showLinkedItems = true;
            } else {
                this.showLinkedItems = false;
            }
        },
        excludeItemsData: function() {
            this.calculateObjCompletion();
        },
        objectiveGroups: {
            handler : function (_new, _old){
                let teamOptions = {
                    id: "Teams",
                    items: [],
                    title: "Teams"
                };
                let customGroupOptions = {
                    id: "CustomObjective",
                    items: [],
                    title: "Custom Objective"
                };
                const customViews = kendisStore.getters.getCustomViews();
                _.forEach(_new, group => {
                    if(group.baseItemLinks[0].teamId == 0){
                        // custom group
                        if (group.linkedCustomView && !_.isEmpty(customViews)) {
                            const view = customViews.find(view => view.id === group.linkedCustomView);
                            if (view) {
                                group.viewTitle = view.title;
                            }
                        }
                        group.label = !this.isGlobalObjectiveView ? (group.viewTitle ? group.viewTitle : group.title) : group.title;

                        customGroupOptions.items.push(group);
                    } else {
                        // team group
                        group.label = group.title;
                        teamOptions.items.push(group);
                    }
                });
                let tempArrayForTeamsAndGroupsOptions = [];
                tempArrayForTeamsAndGroupsOptions.push(teamOptions);
                tempArrayForTeamsAndGroupsOptions.push(customGroupOptions);
                this.objectiveGroupsCopy = tempArrayForTeamsAndGroupsOptions;
            },
            immediate : true
        },
        "objectiveMenuOptions.isOkrEnabled": function(_new, _old){
            this.calculateObjCompletion();
        },
        "objectiveMenuOptions.isUnCommittedEnabled": function(_new, _old){
            this.calculateObjCompletion();
        },
		getOkrCompletionMap: {
			handler: function(_new, _old) {
				if(this.getOkrCompletionMap && this.isMockingMode) {
					if(this.getOkrCompletionMap[this.objective.id] != undefined) {
						this.completion = this.getOkrCompletionMap[this.objective.id];
						this.isGlobalCalculationDone = true;
					}
	                if (this.getOkrCompletionMap['linkedItemsCompletion_'+this.objective.id] != undefined){
	                    this.objLinkedItemsCompletion = this.getOkrCompletionMap['linkedItemsCompletion_'+this.objective.id];
	                }
				}
			},
			deep: true,
			immediate: true
		},
		getSessions: {
			handler: function() {
				this.$forceUpdate();
			},
			deep: true,
			immediate: true			
		},
		isVisible: {
			handler: function() {
				if(this.isVisible) {
					this.fetchLinkedOkrs();
				}
			}
		},		
		sessionsMap: {
			handler: function() {
				this.getParentSessions();
			},
			deep: true,
			immediate: true			
		},
        timePeriodFilter: {
            handler: function() {
                this.filterOKRs();
            },
            deep: true,
            immediate: true
        },
        'krProgressCriteriaEdit.show'(val) {
            if (val) {
                this.$nextTick(() => {
                    this.$refs.krProgressCriteriaEdit && this.$refs.krProgressCriteriaEdit.focus();
                });
            }
        },
        "editOkrStatus.status": {
            handler: function (newVal, oldVal) {
                if (newVal && newVal.id && newVal.id !== this.objectiveData.status.id) {
                    this.onSelectOkrStatus();
                }
            },
            deep: true,
        }
    },

    computed: {
		showBarAndPercentage () {
			return function (value){
				if(this.objective && value == 0 && _.isEmpty(this.objective.linkedItems)) {
					return false;
				}
				return true;
			}
		},
        completionBy: function () {
            let completionCriteria = kendisStore.state.objectiveCompletionCriteria.code;
            if (this.objectiveMenuOptions['isOkrEnabled'] && completionCriteria === "OBJ_KR_WEIGHTS_FORMULA") {
                return this.objectiveData.completionCriteria;
            }else{
                return completionCriteria;
            }
        },
        calculationCriteria: function(){
            return kendisStore.state.objectiveCompletionCriteria.code;
        },
        objectiveMenuOptions: function (){
            return kendisStore.getters.getObjectiveMenuOptions();
        },
        isStatusEnabled: function () {
			if (this.objectiveMenuOptions) {
				if (this.objective.type == "KR") {
					return this.objectiveMenuOptions.isOkrStatusEnabled;
				}else {
					return this.objectiveMenuOptions.isStatusEnabled;
				}
			}
			return true;
		},
        excludeItemsData: function() {
            return kendisStore.getters.getExcludeItemsData();
        },
        expandCollapseObjectiveMap: function (){
            return kendisStore.getters.getExpandCollapseObjectivesMap();
        },
        objOkrPopupContainerMap: function (){
            return kendisStore.getters.getObjOkrPopupContainerMap();
        },
        objectiveGroups: function (){
            return kendisStore.getters.getOjectiveGroups()
        },
        getTitle: function () {
            if(this.objective.highlightedTitle){
                return this.objective.highlightedTitle;
            } else {
                return this.objective.title;
            }
        },
		getOkrCompletionMap: function() {
			return kendisStore.state.okrCompletionMap;
		},
		getCompletionError: function() {
			if(this.isMockingMode && this.getOkrCompletionMap && this.getOkrCompletionMap["error"+this.objectiveData.id]) {
				return true;
			}
			return false;
		},		
		getKrIconClass: function() {
			let  _this = this
			return  function(objective) {
				if(_this.okrProgressCriteriaField && _this.okrProgressCriteriaField.id && objective && objective.fields &&  objective.fields[_this.okrProgressCriteriaField.id]) {
					if(objective.fields[_this.okrProgressCriteriaField.id] === "By Items") {
						return "kricon3";
					} else if(objective.fields[_this.okrProgressCriteriaField.id] === "By Objectives") {
						return "kricon2";
					} else if(objective.fields[_this.okrProgressCriteriaField.id] === "Target") {
						return "kricon1";
					}
				}
				return "";
				
			}
		},
		getSessions: function() {
			let _this = this;
			let sessions = [];
			let sessionIdsMap = {};			
			_.each(_this.objective.baseItemLinks, link=>{
    			if(link.linkType && link.linkType ==  "linked_session") {
					sessionIdsMap[link.sessionId] = 1;
    			}
			});
			_.each(Object.keys(sessionIdsMap), sessionId =>{
                if (_this.sessionsMap[sessionId]){
				    sessions.push(_this.sessionsMap[sessionId]);
                }
			})			
			return sessions;
		},		
		getBatches: function() {
			let _this = this;
			let batches = [];
			let batchIdsMap = {};
			_.each(_this.objective.baseItemLinks, link=>{
    			if(link.linkType && link.linkType ==  "art_link_objective") {
					batchIdsMap[link.sessionId] = 1;
    			}
			});
			_.each(Object.keys(batchIdsMap), dptId =>{
                if (_this.batchesMap[dptId]){
				    batches.push(_this.batchesMap[dptId]);
                }
			})
			return batches;
		},
		getTargetCriteriaValues: function() {
			return function(field) {
				if(field == "start") {
					return (this.objective.fields && this.objective.fields[this.krStartFieldId]) ? this.objective.fields[this.krStartFieldId] : "";
				} else if(field == "target") {
					return (this.objective.fields && this.objective.fields[this.krTargetFieldId]) ? this.objective.fields[this.krTargetFieldId] : "";
				} else if(field == "unit") {
					return (this.objective.fields && this.objective.fields[this.krUnitFieldId]) ? this.objective.fields[this.krUnitFieldId] : "";					
				} else if(field == "progress") {
					return (this.objective.fields && this.objective.fields[this.krProgressFieldId]) ? this.objective.fields[this.krProgressFieldId] : "";					
				}
				return "";
			}
		},
        getTimePeriodTooltip: function() {
            let tooltip = "";
            if(this.objective.fields && (this.objective.fields[this.timePeriodFieldId] || this.objective.fields[this.timePeriodKRFieldId])) {
                let startDate = new Date(this.objective.fields[this.startDateFieldId]);
                let endDate = new Date(this.objective.fields[this.endDateFieldId]);
        
                const options = { year: 'numeric', month: 'long', day: 'numeric' };
                tooltip += `${startDate.toLocaleDateString(undefined, options)} - ${endDate.toLocaleDateString(undefined, options)}`;
            }
            return tooltip;
        },
        parentObjectiveGroup() {
            return this.objectiveGroups.find(group => group.id === this.groupId);
        },
        parentObjectiveGroupArtId() {
            const group = this.parentObjectiveGroup;
            let artId;
            if (group) {
                for (link in group.baseItemLinks) {
                    if (group.baseItemLinks[link].linkType === 'art_link_objective' && group.baseItemLinks[link].sessionId !== "-1") {
                        artId = group.baseItemLinks[link].sessionId;
                        break;
                    }
                }
            }
            return artId;
        },
        linkedChildObjectives() {
			let items = this.objectiveData && this.objectiveData.baseItemList ? this.objectiveData.baseItemList : [];
			let objectives = items.filter(item => item.itemType?.title === 'Objective');
			return objectives;
		},
        getOkrStatuses() {
            const statsues = kendisStore.getters.getObjectiveTemplate().statuses;
            if (_.isEmpty(statsues)) {
                return [];
            }
            return statsues;
        },
        isInlineEditEnabled() {
            return this.editOkrStatus.show || this.editOkrResponsible.show || this.editOkrTimePeriod.show;
        },
        getCollectionTitle(){
            if(this.isArt && this.parentObjectiveGroup){
                return this.parentObjectiveGroup.title;
            }
        }
    },

    created() {
		let _this = this;
        this.$options._valueSortableOptionsOkr = {
			disabled: this.readOnlyView? true: false,
            draggable: '.obj-value',
            handle: ".value-sortable-handle",
            ghostClass: 'ui-sortable-placeholder1',
            chosenClass: "sortable-chosen",
            dragClass: "sortable-drag",
            group: {name: 'okr_group', pull: false, put: false},
            forceFallback: false,
            onEnd: this.onChangeSortableOkr
        };
        this.$options.permissions = kendisStore.getters.getObjectiveAndOkrPermissions();
		let okrProgressCriteriaGroupFields = kendisStore.getters.getOkrProgressCriteriaGroupFields();
		this.okrProgressCriteriaField = _.find(okrProgressCriteriaGroupFields, {title: "Progress Criteria"});

        this.viewEditOptions();
        
        //---------------------------------------------------//

        if (this.expandCollapseObjectiveMap[this.objective.id]){
            this.showLinkedItems = this.expandCollapseObjectiveMap[this.objective.id];
        }
		
        let groupId = this.groupId;
        /*if (this.objective.type === "KR"){
            groupId = this.$parent.$parent.objectiveGroup.id;
        }else{
            groupId = this.$parent.objectiveGroup.id;
        }*/

        if (this.objOkrPopupContainerMap[groupId] && this.objOkrPopupContainerMap[groupId].isPopupOpen && this.objOkrPopupContainerMap[groupId].itemTemplate.model.id === this.objective.id){
            this.displayMode = this.objOkrPopupContainerMap[groupId].displayMode;
            this.itemTemplate = this.objOkrPopupContainerMap[groupId].itemTemplate;
            this.itemTemplate.showEditPopUp = this.objOkrPopupContainerMap[groupId].isPopupOpen;
            this.itemsLoaded = true;
			this.modalDataLoaded = true;
        }
		if(this.isMockingMode) {
            this.itemsLoaded = true;
		}

        //If itemType is equal to Objective then fetch the okrs list from kendisStore instead of prop okrList
        //This was added due to deletion rendering issues of KR.
        if (this.objective.itemType?.title === "Objective") {
          let group = this.objectiveGroups.find((group) => {
            return group.baseItemList && group.baseItemList.some((obj) => obj.id === this.objective.id);
          });

          if (group) {
            const objIndex = group.baseItemList.findIndex((obj) => obj.id === this.objective.id);
            if (objIndex > -1 && !_.isEmpty(group.baseItemList[objIndex].baseItemList)) {
              this.baseItemList = group.baseItemList[objIndex].baseItemList;
            }
          }
		  if(this.isPrioritizedObjListingView || this.showLinkedItems) {
              this.baseItemList = this.objective.baseItemList;			
		  }
        }
        if (this.showLinkedItems) {
            this.loadObjectiveBaseItemList();
        }
        //------------------------------------------------------//
		let progressCriteriaGroupFields = kendisStore.getters.getOkrProgressCriteriaGroupFields();
		if(!_.isEmpty(progressCriteriaGroupFields)) {
			_.each(progressCriteriaGroupFields, field=>{
				if(field.title == "Start") {
					_this.krStartFieldId   	= field.id;				
				}
				else if(field.title == "Target Value") {
					_this.krTargetFieldId   = field.id;				
				}
				else if(field.title == "Progress") {
					_this.krProgressFieldId = field.id;				
				}
				else if(field.title == "Unit") {
					_this.krUnitFieldId		= field.id;				
				}
			});
		}
        EventBus.$on('fetchKrPopupData',(objectiveId,keyResultId) =>{
            if(objectiveId === this.objective.id){
                if(this.objective.baseItemList){
                    for(kr of this.objective.baseItemList){
                        if(kr.id === keyResultId){
                            let rowData = {};
                            rowData.krId = kr.id;
                            rowData.parentId = this.objective.id;
                            rowData.groupId = this.groupId;
                            rowData.key = `${kr.id}_${this.dynamicOkrItemKey}`;
                            rowData.ref = `KR_${kr.id}`;
                            rowData.board = this.board;
                            rowData.objective = kr;
                            rowData.readOnlyView = this.readOnlyView;
                            rowData.hideOkr = this.hideOkr;
                            rowData.departmentsMap = this.departmentsMap;
                            rowData.isMockingMode = this.isMockingMode;
                            rowData.departmentsMap = this.departmentsMap;
                            rowData.isFeatureDetailView = this.isFeatureDetailView;
                            rowData.isPrioritizedObjListingView = this.isPrioritizedObjListingView;
                            rowData.krProgressCriteriaFieldId = this.krProgressCriteriaFieldId;
                            rowData.childList = this.childList;
                            rowData.childSessionsMap = this.childSessionsMap;
                            rowData.isItemsLoaded = this.isItemsLoaded;
                            rowData.releaseTrainId = this.releaseTrainId;
                            rowData.useOldApiForOldStateData = this.useOldApiForOldStateData;
                            rowData.objectiveColumnSettings = this.objectiveColumnSettings;
                            rowData.krParentTimePeriodFieldId = _.isEmpty(this.krParentTimePeriodFieldId) ? this.timePeriodFieldId : this.krParentTimePeriodFieldId;
                            rowData.krParentStartDateFieldId = this.krParentStartDateFieldId;
                            rowData.krParentEndDateFieldId = this.krParentEndDateFieldId;
                            rowData.krParent = this.objectiveColumnSettings;
                            EventBus.$emit('rowDataObject',rowData,objectiveId);
                        }
                    }
                }
            }
        })
        EventBus.$on('fetchLinkedObjectivePopupData', (objectiveId) =>{
            if(objectiveId === this.objective.id){
                let rowData = {};
                rowData.showUnLinkedItems = this.showUnLinkedItems;
                rowData.objective = this.objective;
                rowData.ref =  'row_' + objectiveId;
                rowData.groupId = this.groupId;
                rowData.key = objectiveId;
                rowData.board = this.board;
                rowData.okrList = this.objective.baseItemList;
                rowData.isUserSearching = this.isUserSearching;
                rowData.readOnlyView = this.readOnlyView;
                rowData.hideOkr = this.hideOkr;
                rowData.isFeatureDetailView = this.isFeatureDetailView;
                rowData.isGlobalObjectiveView = this.isGlobalObjectiveView;
                rowData.objectiveTeam = this.objectiveTeam;
                rowData.isMockingMode = this.isMockingMode;
                rowData.isPrioritizedObjListingView = this.isPrioritizedObjListingView;
                rowData.krProgressCriteriaFieldId = this.krProgressCriteriaFieldId;
                rowData.isMockingMode = this.isMockingMode;
                rowData.isArt = this.isArt;
                rowData.releaseTrainId = this.releaseTrainId;
                rowData.departmentsMap = this.departmentsMap;
                rowData.sessionsMap = this.sessionsMap;
                rowData.batchesMap = this.batchesMap;
                rowData.isItemsLoaded = this.isItemsLoaded;
                rowData.useOldApiForOldStateData = this.useOldApiForOldStateData;

                EventBus.$emit('rowDataObject',rowData,objectiveId);
            }
        });
    },

    mounted() {
        let _this = this;
		if(_this.$refs['active-objective']) {
			_this.$nextTick(() => {
					_this.$refs['active-objective'].expandCollapseLinkedItems = true;
			});
		}
        if (this.objective && this.objective.linkedItems) {
            _.each(_this.linkedItems, function (item) {
                item.randomId = getNewUUID();
            });
        }
        this.objectiveData = this.objective;

        if (_this.objectiveData.type.includes("Objective") || _this.objectiveData.type.includes("normal") || _this.objectiveData.type.includes("stretch")) {
            _this.populateOkrListWithWeights();
        }

        if (_this.isMockingMode){
			let isbackLogItemsLinkedWithObjMap = kendisStore.getters.getIsbackLogItemsLinkedWithObjMap();
			if(isbackLogItemsLinkedWithObjMap) {
				if(isbackLogItemsLinkedWithObjMap[_this.objectiveData.id] != undefined) {
					_this.isBackLogItemsLinked = isbackLogItemsLinkedWithObjMap[_this.objectiveData.id];
				} else {					
		            _this.isBackLogItemsLinkedWithObj(_this.objectiveData.id);
				}				
			}
        }

        _this.selectedStatusEstimateFilter = _.find(_this.statusAndEstimateFilters, status => {
            return status.code === _this.objectiveData.completionCriteria;
        });
		let rowType = "KR"
		if(_this.objectiveData.type.includes("Objective")) {
			rowType = "Objective";
		}
		if(this.board.session.activeSessionBoard != this.board.id) {
			let objectiveBaseItemLink = _.find(_this.objectiveData.baseItemLinks, {"type": rowType});
			if(!_.isEmpty(objectiveBaseItemLink)) {
				_this.isItemOfAnotherState = objectiveBaseItemLink.sessionBoardId? objectiveBaseItemLink.sessionBoardId != this.board.id : false; 
			}
		}
		if(!this.isMockingMode) {
        	this.calculateObjCompletion();
            this.showBoardLinkedItem = true;
		} else {
			if(this.getOkrCompletionMap && this.getOkrCompletionMap[this.objectiveData.id]) {
				this.completion = this.getOkrCompletionMap[this.objectiveData.id];
			}
		}
        // if(this.isMockingMode){
        //     this.fetchBoards();
        // }

        let templateFields;
        if(this.objective.type.includes("Objective")) {
            templateFields = kendisStore.getters.getObjectiveTemplate();
        }else{
            templateFields = kendisStore.getters.getOkrTemplate();
        }

        let overviewGroupTemplate = _.find(templateFields.scheme.fieldsTemplate.configuredFields, field => field.title === "Overview");
        if (!_.isEmpty(overviewGroupTemplate)){
            let responsibleField = _.find(overviewGroupTemplate.groupFields, field => field.title === "Responsible");
            if (!_.isEmpty(responsibleField)){
                this.responsibleFieldId = responsibleField.id;
            }
            let timePeriodField = _.find(overviewGroupTemplate.groupFields, field => field.title === "Time Period");
            if (!_.isEmpty(timePeriodField) && this.objective.itemType && this.objective.itemType.title === 'Objective'){
                this.timePeriodFieldId = timePeriodField.id;
            }
            let startDateField = _.find(overviewGroupTemplate.groupFields, field => field.title === "Start Date");
            if (!_.isEmpty(startDateField)){
                this.startDateFieldId = startDateField.id;
            }
            let endDateField = _.find(overviewGroupTemplate.groupFields, field => field.title === "End Date");
            if (!_.isEmpty(endDateField)){
                this.endDateFieldId = endDateField.id;
            }
        }

        if (_.isEmpty(this.timePeriodKRFieldId)) {
            let krTemplate = kendisStore.getters.getOkrTemplate();
            let overviewGroupTemplate = _.find(krTemplate.scheme.fieldsTemplate.configuredFields, field => field.title === "Overview");
            if (!_.isEmpty(overviewGroupTemplate)){
                let timePeriodField = _.find(overviewGroupTemplate.groupFields, field => field.title === "Time Period");
                if (!_.isEmpty(timePeriodField)){
                    this.timePeriodKRFieldId = timePeriodField.id;
                }
                let startDateField = _.find(overviewGroupTemplate.groupFields, field => field.title === "Start Date");
                if (!_.isEmpty(startDateField)){
                    this.startDateKRFieldId = startDateField.id;
                }
                let endDateField = _.find(overviewGroupTemplate.groupFields, field => field.title === "End Date");
                if (!_.isEmpty(endDateField)){
                    this.endDateKRFieldId = endDateField.id;
                }
            }
        }

        this.originalBaseItemList = _.cloneDeep(this.okrList);

		//this.fetchLinkedOkrs();
        if(this.getUrlParam("objectiveId") !== undefined && this.getUrlParam("objectiveId") === this.objective.id){
            this.openModalForEditing(this.objective);
        }
        if(this.openDynamicPopup === 'objective' || this.openDynamicPopup === 'KR'){
            this.openModalForEditing(this.objective);
        }

        if (this.objectiveData.type === "KR" && this.objectiveData.fields && this.objectiveData.fields[this.krProgressCriteriaFieldId] && this.objectiveData.fields[this.krProgressCriteriaFieldId] === "Target"){
            this.krProgressCriteriaEdit.startValue = this.getTargetCriteriaValues("start");
            this.krProgressCriteriaEdit.targetValue = this.getTargetCriteriaValues("target");
            this.krProgressCriteriaEdit.unitValue = this.getTargetCriteriaValues("unit");
            this.krProgressCriteriaEdit.progressValue = this.getTargetCriteriaValues("progress");
        }

        document.addEventListener('keydown', this.handleKeyDown);
    },

    beforeDestroy() {
        document.removeEventListener('keydown', this.handleKeyDown);
    },

    methods: {
        onDeleteObjective: function (objective) {

        },

        handleObjectiveEditEnter() {
            if (this.objectiveMenuOptions['isBVAchievementEnabled']) {
                this.moveNext('editObjectiveBvPlan');
            } else {
                this.onSaveEditObjectiveData(this.editObjectiveData);
            }
        },

        handleOkrEditEnter() {
            if (this.objectiveMenuOptions['isOkrBVAchievementEnabled']) {
                this.moveNext('editObjectiveBvPlan')
            } else { 
                this.onSaveEditObjectiveData(this.editObjectiveData)
            }
        },

        handleKeyDown(event) {
            if (event.key === 'Escape') {
                if (this.krProgressCriteriaEdit.show) {
                    this.onCloseKrProgressCriteriaEdit();
                }
                if (this.showEditView) {
                    this.closeEditView();
                }
                this.closeAllInlineEdits();
            }
        },

        closeAllInlineEdits() {
            if (!this.isBatchView) {
                this.editOkrTimePeriod.show = false;
                this.editOkrTimePeriod.showPopup = false;
            
                this.editOkrResponsible.show = false;
                this.editOkrStatus.show = false;
            }
        },

        onCLoseEditPopUp: function () {
            let _this = this;
            _this.itemTemplate.showEditPopUp = false;
			_this.itemsLoaded = false;
			_this.modalDataLoaded = false;
            if (_this.objOkrPopupContainerMap){
                _.forOwn(_this.objOkrPopupContainerMap, function (value, key){
                    if (value.isPushReceived){
                        kendisStore.commit("incrementObjGrpKeyMap", key);
                    }
                    _this.objOkrPopupContainerMap[key] = {};
                });
                kendisStore.commit("setObjOkrPopupContainerMap", _this.objOkrPopupContainerMap);
            }

			toggleDraggable(false);
            _this.$forceUpdate();
            this.$emit("close");
        },

		afterLoadObjective: function(response) {
			let _this = this;
			let objAndKrLinkedItemsMap = response.objAndKrLinkedItemsMap;
			if(!_.isEmpty(objAndKrLinkedItemsMap)) {
				if(objAndKrLinkedItemsMap[_this.objective.id]) {
					let testObj = {};
					testObj.id = _this.objective.id;
	                testObj.linkedItemsIds = objAndKrLinkedItemsMap[_this.objective.id].linkedItemsIds;
	                testObj.linkedItems = objAndKrLinkedItemsMap[_this.objective.id].linkedItems;
	                testObj.linkedItemsById = objAndKrLinkedItemsMap[_this.objective.id].linkedItemsById;
					Vue.set(_this.itemTemplate.model, 'linkedItemObject', testObj);
				}
				if(_this.itemTemplate.model.baseItemList) {
					_.each(_this.itemTemplate.model.baseItemList, baseItem=>{
						if(objAndKrLinkedItemsMap[baseItem.id]) {
			                baseItem.linkedItemsIds = objAndKrLinkedItemsMap[baseItem.id].linkedItemsIds;
			                baseItem.linkedItems = objAndKrLinkedItemsMap[baseItem.id].linkedItems;
			                baseItem.linkedItemsById = objAndKrLinkedItemsMap[baseItem.id].linkedItemsById;
						}						
					});
				}
				
                let groupId = _this.groupId;
                /*if (_this.objectiveData.type === "KR"){
                    groupId = _this.$parent.$parent.objectiveGroup.id;
                }else{
                    groupId = _this.$parent.objectiveGroup.id;
                }*/

                if (_this.objOkrPopupContainerMap[groupId] === undefined){
                     _this.objOkrPopupContainerMap[groupId] = {};
                }
                _this.objOkrPopupContainerMap[groupId].itemTemplate = _this.itemTemplate;
                kendisStore.commit("setObjOkrPopupContainerMap", _this.objOkrPopupContainerMap);
				
			}
            _this.itemsLoaded = false;
			_this.$nextTick(() => {
				if (_this.$refs['active-objective']) {
					_this.$refs['active-objective'].expandCollapseLinkedItems = true;
				}
				_this.itemsLoaded = true;
			});
			
		},
		afterCalculationFetched: function(response) {
			let _this = this;
			let completionsMap = response.completionById;
			let savedCompletionMap = kendisStore.getters.getOkrCompletionMap();
			Object.assign(completionsMap, savedCompletionMap);
			if(_this.$refs['active-objective']) {
				_this.$nextTick(() => {
						_this.$refs['active-objective'].expandCollapseLinkedItems = true;
				});
			}			
			kendisStore.commit("setOkrCompletionMap", completionsMap);
		},
        openModalForEditing: function (objective, closeParent) {
            let _this = this;
            let requestBody = {};
			if(this.isMockingMode && (this.$parent.objectiveData && this.$parent.objectiveData.type == "KR")) {
                this.disableGroups = true;
			}
			if(this.isMockingMode && this.$parent.showBoardLinkedItem) {
                this.showBoardLinkedItem = true;
			}
			
            _this.modalDataLoaded = false;
            _this.itemTemplate = {};
            _this.itemTemplate.model = {};
            _this.itemTemplate.model.fields = {};
			_this.itemTemplate.statuses = [];
            _this.itemTemplate.id = objective.id;
            _this.itemTemplate.model.id = objective.id;
            _this.itemTemplate.model.title = objective.title;
            _this.itemTemplate.model.key = objective.key;
            _this.itemTemplate.showEditPopUp = true;
           /* if(!_this.isMockingMode) {
                toggleDraggable(true);
            }
			_this.$forceUpdate();*/
	        if(!_this.useOldApiForOldStateData && _this.board.session.activeSessionBoard != _this.board.id) {
		        _this.fetchOkrCallback(objective, objective)
	        }
	        else {
	            requestBody.objectiveId = objective.id;
				if(!_this.isMockingMode) {
					let requestId 	= getNewUUID();
		            requestBody.requestId = requestId;

					startPoll(requestId, function(response){
						_this.afterLoadObjective(response);
					});
				}else{
					if(!_this.showBoardLinkedItem) {
		                requestBody.isMockingMode = true;
						requestBody.fetchPIs = true;
					}
					let requestId 	= getNewUUID();
		            requestBody.requestId = requestId;

					startPoll(requestId, function(response){
						if(_this.showBoardLinkedItem) {
							_this.afterLoadObjective(response);
						} else {
							_this.afterCalculationFetched(response);
						}
					});
	            }
                _this.itemsLoaded = true;
				axios.post('objective/get-objective-by-id', requestBody)
				.then(response => {
					if (response && response.data && response.data.objective) {
						_this.fetchOkrCallback(objective, response.data.objective, response.data.sessionMapById, closeParent)
					}
				})
				.catch(error => {
					console.error(error);
				});
			}
        },

        isNotOkr: function () {
            if (this.objective.type.toLowerCase().includes("kr")) {
                return false
            }
            return true;
        },

        onSelectTimePeriod(selectedPeriod) {
            this.timePeriod.period = selectedPeriod.timePeriod;
            this.timePeriod.startDate = selectedPeriod.startDate;
            this.timePeriod.endDate = selectedPeriod.endDate;
        },

        onSelectNewObjTimePeriod(selectedPeriod) {
            this.newObjectiveDataCommittedTimePeriod.period = selectedPeriod.timePeriod;
            this.newObjectiveDataCommittedTimePeriod.startDate = selectedPeriod.startDate;
            this.newObjectiveDataCommittedTimePeriod.endDate = selectedPeriod.endDate;
        },

        saveCommittedObjective: function () {
            if (!this.isTitleValid(this.newObjectiveDataCommitted.title)) {
                this.isAddCommittedObjectiveInputValid = false;
                showTopMessage("Please enter a valid title.", "warning", 3000);
                return;
            } else if (_.isEmpty(this.newObjectiveDataCommittedTimePeriod.period) && this.isMockingMode) {
                this.isAddCommittedObjectiveTimePeriodValid = false;
                showTopMessage("Please select a time period for objective.", "warning", 3000);
                return;
            } else {
                this.isAddCommittedObjectiveInputValid = true;
                this.isAddCommittedObjectiveTimePeriodValid = true;
            }

            let newObjective = {};
            let completionCriteria = _.find(this.statusAndEstimateFilters, status => {
                return status.code === "CHILDREN_LINKED_ITEM_STATUS";
            });

            newObjective.title = this.newObjectiveDataCommitted.title;

            newObjective.metaMap = {};
            if(this.isMockingMode){
                newObjective.metaMap.sessionId = this.board.session.id;
                newObjective.metaMap.boardId = this.board.session.id;
            }else{
                newObjective.metaMap.sessionId = vueInstance.activeBoard.session.id;
                newObjective.metaMap.boardId = this.board.id;
            }

            newObjective.metaMap.syncId = syncId;
            newObjective.metaMap.groupId = this.parentObjectiveGroup.id;
            newObjective.metaMap = JSON.stringify(newObjective.metaMap);
            newObjective.type = "Objective-Committed";
            newObjective.itemType = kendisStore.getters.getObjectiveTemplate().scheme.itemType;
            newObjective.completionCriteria = completionCriteria.code;

            if(_.find(kendisStore.getters.getObjectiveTemplate().statuses, {"category":"ToDo"}) != -1) {
                newObjective.status = _.find(kendisStore.getters.getObjectiveTemplate().statuses, {"category": "ToDo"});
            }
            if (!_.isEmpty(this.newObjectiveDataCommittedTimePeriod.period)) {
                newObjective.fields = {};
                newObjective.fields[this.timePeriodFieldId] = this.newObjectiveDataCommittedTimePeriod.period;
                newObjective.fields[this.startDateFieldId] = this.newObjectiveDataCommittedTimePeriod.startDate;
                newObjective.fields[this.endDateFieldId] = this.newObjectiveDataCommittedTimePeriod.endDate;
            }

            this.onSaveObjective(newObjective);
            this.toggleGroupDragging(false);
        },

        saveOkr: function () {
            let _this = this;
			if(!_this.savingKeyResult) {
				_this.savingKeyResult = true;
	            if(!_this.isTitleValid(_this.newOkr.title)){
	                showTopMessage("Please enter a valid title.","warning",3000);
                    this.isAddCommittedObjectiveTitleValid = false;
                    _this.savingKeyResult = false;
	                return;
	            } else if (_.isEmpty(_this.timePeriod.period) && this.isMockingMode) {
                    showTopMessage("Please select a time period.","warning",3000);
                    this.isAddCommittedObjectiveTimePeriodValid = false;
                    _this.savingKeyResult = false;
                    return;
                } else if (_.isEmpty(_this.newOkr.fields[_this.okrProgressCriteriaField.id])) {
                    showTopMessage("Please select a progress criteria for KR.","warning",3000);
                    this.isAddCommittedObjectiveProgressCriteriaValid = false;
                    _this.savingKeyResult = false;
                    return;
                } else {
                    this.isAddCommittedObjectiveTimePeriodValid = true;
                    this.isAddCommittedObjectiveTitleValid = true;
                    this.isAddCommittedObjectiveProgressCriteriaValid = true;
                }
	            let newOkr = {};
	            let completionCriteria = _.find(this.statusAndEstimateFilters, status => {
	                return status.code === "CHILDREN_LINKED_ITEM_STATUS";
	            });
				if(!_.isEmpty(_this.okrProgressCriteriaField)) {
					if(_.isEmpty(_this.newOkr.fields)) {
						newOkr.fields = {};
						newOkr.fields[_this.okrProgressCriteriaField.id] = "By Items";
					} else {
						newOkr.fields = _this.newOkr.fields;
					}
				}
	            newOkr.title = this.newOkr.title;
	            newOkr.bvPlan = Math.max(0, Math.floor(Number(this.newOkr.bvPlan)));
	            newOkr.bvActual = Math.max(0, Math.floor(Number(this.newOkr.bvActual)));
	            newOkr.metaMap = {};
	            newOkr.metaMap.syncId = syncId;
	            if(this.isMockingMode){
	                newOkr.metaMap.sessionId = this.board.session.id;
	                newOkr.metaMap.boardId = this.board.session.id;
	            }else{
	                newOkr.metaMap.sessionId = vueInstance.activeBoard.session.id;
	                newOkr.metaMap.boardId = this.board.id;
	            }
				
	            /*newOkr.metaMap.sessionId = vueInstance.activeBoard.session.id;
	            newOkr.metaMap.boardId = this.board.id;*/
	            newOkr.metaMap.objectiveId = this.objectiveData.id;
	            newOkr.metaMap = JSON.stringify(newOkr.metaMap);
	            newOkr.type = "KR";
				newOkr.itemType = kendisStore.getters.getOkrTemplate().scheme.itemType
	            newOkr.completionCriteria = completionCriteria.code;

                if (!_.isEmpty(this.timePeriod.period)) {
                    if (!newOkr.fields) {
                        newOkr.fields = {};
                    }
                    newOkr.fields[this.timePeriodKRFieldId] = this.timePeriod.period;
                    newOkr.fields[this.startDateKRFieldId] = this.timePeriod.startDate;
                    newOkr.fields[this.endDateKRFieldId] = this.timePeriod.endDate;
                }

	            _this.onSaveObjective(newOkr);
                _this.toggleGroupDragging(false);
			}
        },

        saveLinkedObjectives: function(selectedObjectivesMap) {
			let _this = this;
			let requestBody = {};
			requestBody.objectiveIds = Object.keys(selectedObjectivesMap);
			requestBody.okrId = _this.objectiveData.id;
			requestBody.sessionId = this.board.session.id;
			axios.post('objective/check-okr-parent-links', requestBody)
			.then(response=>{
				if(response.data && response.data.existingObjectives) {
					let message = '';
					for(let i = 0; i < response.data.existingObjectives.length; i++) {
						let objId = response.data.existingObjectives[i];
						message = message + selectedObjectivesMap[objId].key;
						if(i != response.data.existingObjectives.length-1) {
							 message = message + ', ';
						}
						delete selectedObjectivesMap[objId];						
					}
					message = message + " not linked because of looping.";
					if(response.data.existingObjectives.length > 0) {
						alertFromSweetAlertWrapper(message, [takeNoAction]);
					}
					this.linkObjectives(selectedObjectivesMap);					
				}
			})
			.catch(error=>{
				console.error(error);
			})
		},

        linkObjectives: function(selectedObjectivesMap) {
			let _this = this;
            let itemContainers 	= [];
            let linkedItemMap 	= {};
            _.each(_this.objectiveData.baseItemLinks, link => {
                if (link.baseItemId) {
                    linkedItemMap[link.baseItemId] = link;
                }
            });
            _.each(Object.values(selectedObjectivesMap), item => {
                let itemContainer 			= {};
                if (linkedItemMap[item.id]) {
                    itemContainer.id 		= linkedItemMap[item.id].id;
                }
                itemContainer.sessionId 	= _this.board.session.id;
                itemContainer.sessionBoardId= _this.board.id;
                itemContainer.baseItemId 	= item.id;
                itemContainer.linkType 		= "parent_okr";
                itemContainers.push(itemContainer);
            });

            _this.updateChildBaseItems(itemContainers, null, null, null);
			
		},

        updateChildBaseItems: function(itemContainers, type) {
			var _this = this;
			var requestBody = {};
			requestBody.id = _this.objectiveData.id;
			requestBody.baseItemLinks = itemContainers;

			let metaMap = {};
            if(_this.isMockingMode){
                metaMap.sessionId  = _this.board.session.id
            }else {
                metaMap.sessionId = vueInstance.activeBoard.session.id;
            }
			if(_this.displayMode === "KR") {
				metaMap.objectiveId = _this.$parent.objectiveData.id;
			}
			requestBody.metaMap = JSON.stringify(metaMap);

			axios.post('/sos/update-base-item-links/' + syncId + '/' + null, requestBody)
				.then(response => {
					if (response.data) {
                        showTopMessage("Items Linked Successfully.", 'success');
                        _this.showObjectiveChildLinkingPopup = false;
						_this.linkItemKey = _this.linkItemKey + 1;
						if(_this.itemLinkingLoader) {
							_this.itemLinkingLoader = false;
							_this.enableSaveButton = true;
						}
						_this.updateBaseItemLinksForLinkTypes(itemContainers);

                        if(itemContainers.length > 0) {
                            let updatedMapValues = kendisStore.getters.getLinkedObjectiveMap();
                            _.each(itemContainers, function (item) {
                                if(!updatedMapValues.includes(item.itemId)){
                                    updatedMapValues.push(item.itemId);
                                }
                            });
                            kendisStore.commit("setLinkedObjectiveMap", updatedMapValues);
                        }
	                    // _this.updateItemListing();
						if(_this.isMockingMode) {
							_this.calculateGroupCompletion([_this.groupId]);
						}
						_this.$forceUpdate();
					}
				})
				.catch(error => {
					console.error("Item linking error", error);
					if(_this.itemLinkingLoader) {
						_this.itemLinkingLoader = false;
						_this.enableSaveButton = true;
					}					
				});

		},

        updateBaseItemLinksForLinkTypes: function(linkedObjectivesBaseItemIds) {
			let _this = this;
			let requestBody = {};
			let baseItemIdToLinksMap = {};
			
			requestBody.baseItemIdToLinksMap = {};
			requestBody.id = _this.objectiveData.id;
			_.each(linkedObjectivesBaseItemIds, baseItemLink=>{
				if(!_.isEmpty(baseItemLink.baseItemId)) {
					baseItemIdToLinksMap[baseItemLink.baseItemId] = JSON.stringify({sessionId: this.board.session.id, baseItemId : _this.objectiveData.id, linkType: "child_okr"});
				}
			});
			requestBody.baseItemIdToLinksMap = baseItemIdToLinksMap;
			axios.post('objective/update-base-item-links-of-base-items', requestBody)
			.then(response=>{
                if (response.status == "200") {
                    let baseItem = response.data;
                    _this.baseItemList = baseItem.baseItemList;
					_this.updateStoreForLinkedItems(baseItem, true);
                }				
			})
			.catch(error=>{
                console.error("Error occurred while fetching linked items", error);
                handleSoSErrorMsg(error);				
			});
		},

        updateStoreForLinkedItems: function(baseItem, isObjectiveLinking) {
			let _this = this;
			let storePayload = {};
            if (_this.objectiveData.type === "KR"){
                storePayload.objectiveId = _this.parentId;
                storePayload.okr = {};
                storePayload.okr.id = baseItem.id;
				if (isObjectiveLinking) {
	                storePayload.okr.baseItemList = baseItem.baseItemList;
	                storePayload.fields = ["baseItemList"];					
				}
				else {
	                storePayload.okr.linkedItems = baseItem.linkedItems;
	                storePayload.okr.linkedItemsIds = baseItem.linkedItemsIds;
	                storePayload.okr.linkedItemsById = baseItem.linkedItemsById;
	                storePayload.fields = ["linkedItems", "linkedItemsIds", "linkedItemsById"];
				}
                storePayload.okr.baseItemLinks = baseItem.baseItemLinks;
				storePayload.fields.push("baseItemLinks")
            } else {
                storePayload.objective = {};
                storePayload.objective.id = _this.objectiveData.id;
                storePayload.objective.linkedItems = baseItem.linkedItems;
                storePayload.objective.linkedItemsIds = baseItem.linkedItemsIds;
                storePayload.objective.linkedItemsById = baseItem.linkedItemsById;
                storePayload.objective.baseItemLinks = baseItem.baseItemLinks;
                storePayload.objective.baseItemList = baseItem.baseItemList;
                storePayload.fields = ["linkedItems", "linkedItemsIds", "linkedItemsById", "baseItemLinks", "baseItemList"];
            }
			kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
			
		},

        onClickEditKrProgressCriteria() {
            if (this.$options.permissions.EDIT_OKR) {
                this.krProgressCriteriaEdit.show = true;
                this.toggleGroupDragging(true);
            }
        },

        onCloseKrProgressCriteriaEdit() {
            this.krProgressCriteriaEdit.show = false;
            this.krProgressCriteriaEdit.startValue = this.getTargetCriteriaValues("start");
            this.krProgressCriteriaEdit.targetValue = this.getTargetCriteriaValues("target");
            this.krProgressCriteriaEdit.unitValue = this.getTargetCriteriaValues("unit");
            this.krProgressCriteriaEdit.progressValue = this.getTargetCriteriaValues("progress");
            this.toggleGroupDragging(false);
        },

        handleKrTargetCrietriaUpdate() {
            let objective = _.cloneDeep(this.objectiveData);

            if (objective.fields && objective.fields[this.krProgressCriteriaFieldId] && objective.fields[this.krProgressCriteriaFieldId] === "Target") {
                objective.fields[this.krStartFieldId] = this.krProgressCriteriaEdit.startValue;
                objective.fields[this.krTargetFieldId] = this.krProgressCriteriaEdit.targetValue;
                objective.fields[this.krUnitFieldId] = this.krProgressCriteriaEdit.unitValue;
                objective.fields[this.krProgressFieldId] = this.krProgressCriteriaEdit.progressValue;
                this.onSaveEditObjectiveData(objective);
            }

            this.krProgressCriteriaEdit.show = false;
            this.toggleGroupDragging(false);
        },

        onSaveObjective: function (requestBody) {
            let _this = this;
            let baseItemLinks = [];
			if(this.isMockingMode){
                let sessionId = !_.isEmpty(this.parentObjectiveGroupArtId) ? this.parentObjectiveGroupArtId : this.board.session.id;
                if (requestBody.type.includes("Objective")) {
                    baseItemLinks.push(
                        {sessionId: sessionId, sessionBoardId: this.board.id, type: "Objective", linkType : "art_link_objective"},
                        {sessionId: sessionId, sessionBoardId: this.board.id, baseItemId : _this.objectiveData.id, linkType: "child_okr"}
                    );
                } else {
                    baseItemLinks.push(
                        {sessionId: sessionId, sessionBoardId: this.board.id, type: "KR", linkType : "art_link_objective"},
                        {sessionId: sessionId, sessionBoardId: this.board.id, baseItemId : _this.objectiveData.id, linkType: "parent_objective"}
                    );
                }
			} else {
				baseItemLinks.push(
					{sessionId: this.board.session.id, sessionBoardId: this.board.id, type: "KR"},
					{sessionId: this.board.session.id, sessionBoardId: this.board.id, baseItemId : this.objectiveData.id, linkType: "parent_objective"}
				);
			}
            requestBody.baseItemLinks = baseItemLinks;
            requestBody.starred = false;
            requestBody.mentionUsers = [];
            // requestBody.status = status;
            if(requestBody.type === 'KR' && _.find(kendisStore.getters.getOkrTemplate().statuses, {"category":"ToDo"}) !== -1) {
                requestBody.status = _.find(kendisStore.getters.getOkrTemplate().statuses, {"category": "ToDo"});
            }
            axios.post('external-entitites/save-base-item/popup-save', requestBody)
                .then(response => {
                    if (response.status == "200" && response && response.data) {
                        let baseItem = _.clone(_this.objectiveData);
                        delete baseItem.board;
                        delete baseItem.linkedItems;
                        delete baseItem.linkedItemsById;
                        delete baseItem.linkedItemsIds;
                        delete baseItem.editView;
                        delete baseItem.baseItemList;
                        let okr = response.data.impediment;
						if(_this.isMockingMode) {
							let okrId = okr.id;
							let completionsMap = {};
							completionsMap[okrId] = 0.0;
							let savedCompletionMap = kendisStore.getters.getOkrCompletionMap();
							Object.assign(savedCompletionMap, completionsMap);
							kendisStore.commit("setOkrCompletionMap", savedCompletionMap);						
						}

                        if (_this.objectiveData.type.includes("Objective") && _this.baseItemList) {
                            let index = _.findIndex(_this.baseItemList, {id: okr.id});
                            if (index === -1) {
                                _this.baseItemList.push(okr);
                            }
                        } else {
                            _this.baseItemList = [];
                            _this.baseItemList.push(okr);
                        }

                        let baseItemLink = {};
                        if (requestBody.type.includes("Objective")) {
                            baseItemLink.baseItemId = okr.id;
                            baseItemLink.sessionId = _this.board.session.id;
                            baseItemLink.linkType = "parent_okr";
                            baseItemLink.sessionBoardId = _this.board.id;	
                        } else {
                            baseItemLink.baseItemId = okr.id;
                            baseItemLink.sessionId = _this.board.session.id;
                            baseItemLink.linkType = "child_objective";
                            baseItemLink.sessionBoardId = _this.board.id;
                        }
                        baseItem.baseItemLinks.push(baseItemLink);
                        let metaMap = {};
                        metaMap.syncId = syncId;
                        metaMap = JSON.stringify(metaMap);
                        baseItem.metaMap = {};
                        baseItem.metaMap = metaMap;
						_.each(baseItem.baseItemLinks, link=>{
							if(!_.isEmpty(link.linkedItemById)) {
								delete link.linkedItemById;
							}
						});
                        if (baseItem.highlightedKey){
                            delete baseItem.highlightedKey;
                        }
                        if (baseItem.highlightedTitle){
                            delete baseItem.highlightedTitle;
                        }
                        
                        axios.post('external-entitites/save-base-item/popup-save', baseItem)
                            .then(response => {
                                if (response.status == "200") {
                                    _this.newOkr.title = "";
                                    _this.showOkrInputForm = false;
                                    if(_this.objectiveData.baseItemList == undefined) {
                                        _this.objectiveData.baseItemList = [];
                                    }
                                    let index = _.findIndex(_this.objectiveData.baseItemList, {id: okr.id});
                                    if (index === -1) {
                                        _this.objectiveData.baseItemList.push(okr);
                                    }
                                    baseItem.baseItemList = _this.objectiveData.baseItemList;
                                    baseItem.baseItemLinks = response.data.impediment.baseItemLinks;
                                    baseItem.linkedItems = _this.objectiveData.linkedItems;
                                    baseItem.linkedItemsIds = _this.objectiveData.linkedItemsIds;
                                    baseItem.linkedItemsById = _this.objectiveData.linkedItemsById;
                                    _this.objectiveData = baseItem;
                                    let storePayload = {};
                                    storePayload.objective = _this.objectiveData;
                                    kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);

                                    if (requestBody.type.includes("Objective")) {
                                        showTopMessage("Objective Created", 'success');
                                    } else {
                                        showTopMessage("Key Result Created", 'success');
                                    }
									if(_this.isMockingMode) {
										// _this.recalculateCompletion(_this.objectiveData, _this.board);
                                        _this.calculateGroupCompletion([_this.groupId]);
									}
									_this.savingKeyResult = false;
                                }
                            })
                            .catch(error => {
                                console.error("Item save error", error);
								_this.savingKeyResult = false;

                            });
                    }
                    _this.closeCommittedObjectiveForm();
                })
                .catch(error => {
                    console.error("Item save error", error);
					_this.savingKeyResult = false;
                    _this.closeCommittedObjectiveForm();
                })
        },

        deleteOkr: function (obj, groupId) {
            let _this = this;
            let requestBody = {};
            let metaMap = {};
            metaMap.syncId = syncId;
            if(_this.isMockingMode){
                metaMap.sessionId = _this.board.session.id;
            }else{
                metaMap.sessionId = vueInstance.activeBoard.session.id;
            }

            requestBody.groupId = groupId;
            requestBody.objId = obj.id;
            requestBody.metaMap = JSON.stringify(metaMap);

            axios.post('/objective/delete-objective', requestBody).then(response => {
                if (response && response.status == "200") {
                    _.remove(_this.baseItemList, {id: obj.id});
                    showTopMessage("Key Result Deleted.", 'success');
                    let storePayload = {};
                    storePayload.objective = _this.objectiveData;
                    kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                    _this.$forceUpdate();
					if(_this.isMockingMode) {
						_this.recalculateCompletion(_this.objectiveData, _this.board);
					}
                }
            }).catch(error => {
                console.error("Objective delete error", error);
            });
        },

        removeOkr: function (okr){
            let _this = this;
            _.remove(_this.baseItemList, {id: okr.id});
            _.remove(_this.objectiveData.baseItemList, {id: okr.id});
            let storePayload = {};
            storePayload.objective = _this.objectiveData;
            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
			if(_this.isMockingMode) {
				_this.recalculateCompletion(_this.objectiveData, _this.board);
			}

        },

        unlinkObj: function (obj){
            let _this = this;
            _.remove(_this.itemTemplate.model.baseItemList, {id: obj.id});
            _.remove(_this.objectiveData.baseItemLinks, {baseItemId: obj.id});
            let storePayload = {
                okr         : {},
                objectiveId : ""
            };
            storePayload.okr.id = _this.objectiveData.id;
            storePayload.objectiveId = _this.parentId;
            storePayload.okr.baseItemList = _this.itemTemplate.model.baseItemList;
            storePayload.okr.baseItemLinks = _this.objectiveData.baseItemLinks;
            storePayload.fields = ["baseItemList", "baseItemLinks"];
            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
			if(_this.isMockingMode) {
				_this.recalculateCompletion(_this.$parent.objectiveData, _this.board);
			}
        },

        moveNext: function (option) {
            let _this = this;
            _this.$nextTick(() => {
				if(_this.$refs && _this.$refs[option]) {
	                const element = _this.$refs[option];
	                element.focus();
				}
            });
        },

        onSaveEditOkr: function (updatedOkr) {
            let _this = this;
            let updatedIndex;
            let baseItem = _.clone(_.filter(_this.baseItemList, {id: updatedOkr.id})[0]);
            if(baseItem !== undefined) {
                if (baseItem.board && baseItem?.board !== undefined) {
                    delete baseItem.board;
                }
                if (baseItem.linkedItems !== undefined) {
                    delete baseItem.linkedItems;
                }
                if (baseItem.linkedItemsById !== undefined) {
                    delete baseItem.linkedItemsById;
                }
                if (baseItem.linkedItemsIds !== undefined) {
                    delete baseItem.linkedItemsIds;
                }
                if (baseItem.editView !== undefined) {
                    delete baseItem.editView;
                }
            } else  {
                return;
            }
            baseItem.title = updatedOkr.title;
            if (updatedOkr.bvPlan){
                baseItem.bvPlan = updatedOkr.bvPlan;
            }
            if (updatedOkr.bvActual){
                baseItem.bvActual = updatedOkr.bvActual;
            }
            if (updatedOkr.completionCriteria){
                baseItem.completionCriteria = updatedOkr.completionCriteria;
            }
            baseItem.notifyWatchers = updatedOkr.notifyWatchers;
            baseItem.starred = updatedOkr.starred;
            baseItem.metaMap = updatedOkr.metaMap;
            baseItem.fields = updatedOkr.fields;
            baseItem.description = updatedOkr.description;
            baseItem.baseItemLinks = _.compact(updatedOkr.baseItemLinks);
            baseItem.status = updatedOkr.status;
            if (updatedOkr.newIndex !== undefined){
                updatedIndex = updatedOkr.newIndex
                delete updatedOkr.newIndex;
            }
            if (!baseItem.metaMap || baseItem.metaMap == "undefined") {
                let metaMap = {};
                metaMap.sosId = "0";
                metaMap.syncId = syncId;
                metaMap.sessionId = this.board.session.id;
                metaMap.boardId = this.board.id;
                metaMap.objectiveId= _this.objectiveData.id;
                baseItem.metaMap = JSON.stringify(metaMap);
            }else{
                baseItem.metaMap = JSON.parse(baseItem.metaMap);
                if (!baseItem.metaMap.objectiveId && !baseItem.metaMap.groupId){
                    baseItem.metaMap.objectiveId = _this.objectiveData.id;
					if(baseItem.itemType.title === "Objective") {
	                    baseItem.metaMap.groupId = _this.objectiveData.id;						
					} else {
	                    baseItem.metaMap.groupId = _this.$parent.objectiveGroup ? _this.$parent.objectiveGroup.id : _this.groupId;
					}
                }
                baseItem.metaMap = JSON.stringify(baseItem.metaMap);
            }

            if (baseItem.highlightedKey){
                delete baseItem.highlightedKey;
            }
            if (baseItem.highlightedTitle){
                delete baseItem.highlightedTitle;
            }
            
            _.each(baseItem.baseItemLinks, link=>{
				if(!_.isEmpty(link.linkedItemById)) {
					delete link.linkedItemById;
				}
			});
            delete baseItem.parent;
            axios.post('external-entitites/save-base-item/popup-save', baseItem)
                .then(response => {
                    if (response.status == "200" && response && response.data) {
                        let _updatedOkr = response.data.impediment;
                        if (_this.$refs['KR_' + _updatedOkr.id]) {
                            let krRef = _this.$refs['KR_' + _updatedOkr.id][0];

                            if (krRef.itemTemplate && krRef.itemTemplate.model && !_.isEmpty(krRef.itemTemplate.model.baseItemList)) {
                                _updatedOkr.baseItemList = krRef.itemTemplate.model.baseItemList;
                            }
                            if (krRef.objectiveData.linkedItems) {
                                _updatedOkr.linkedItems = krRef.objectiveData.linkedItems;
                            }
                            if (krRef.objectiveData.linkedItemsById) {
                                _updatedOkr.linkedItemsById = krRef.objectiveData.linkedItemsById;
                            }
                            if (krRef.objectiveData.linkedItemsIds) {
                                _updatedOkr.linkedItemsIds = krRef.objectiveData.linkedItemsIds;
                            }
							if(_this.isMockingMode) {
                                _updatedOkr.backLogItems = krRef.backLogItems;
                                _updatedOkr.backLogItemsGrouped = krRef.backLogItemsGrouped;
                                _updatedOkr.backlogItemsMetaDetails = krRef.backlogItemsMetaDetails;
                                _updatedOkr.itemsGroupedByReleaseTrain = krRef.itemsGroupedByReleaseTrain;
								_this.calculateGroupCompletion([_this.groupId]);
							}
                        }
                        let containerMap = _.find(_this.objOkrPopupContainerMap, {"isPopupOpen" : true});
                        if (containerMap){
                            containerMap.itemTemplate.creationAndUpdateData.updatedOn = _updatedOkr.updatedOn;
                            containerMap.itemTemplate.creationAndUpdateData.updatedBy = _updatedOkr.updatedBy;
                            kendisStore.commit("setObjOkrPopupContainerMap", _this.objOkrPopupContainerMap);
                        }
						if(baseItem.itemType.title === "Objective") {
							let updateObjIndex = _.findIndex(_this.baseItemList, {id: _updatedOkr.id});
							_this.baseItemList.splice(updateObjIndex, 1, _updatedOkr);
						} else {
	                        let storePayload = {};
	                        storePayload.objectiveId = _this.objectiveData.id;
	                        storePayload.okr = _updatedOkr;
	                        if (updatedIndex !== undefined){
	                            storePayload.newOkrIndex = updatedIndex;
	                        }
	                        kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
							let originalBaseItem = _.filter(_this.baseItemList, {id: updatedOkr.id})[0];
							if(originalBaseItem && originalBaseItem.fields){
								originalBaseItem.fields = _updatedOkr.fields;
							}
							
						}

                        showTopMessage("Key Result Updated", 'success');
                    }
                })
                .catch(error => {
                    console.error("Item save error", error);
                })
        },

        showOkrInput: function () {
            if (this.objectiveData.type.includes("Objective") && this.isMockingMode) {
                if (_.isEmpty(this.objectiveData.fields) || _.isEmpty(this.objectiveData.fields[this.timePeriodFieldId])){
                    showTopMessage("Add a time period to this objective to start using Key Results.", "warning", 3000);
                    return;
                }
            }

            if (!this.showLinkedItems){
                this.showLinkedItems = true;
                this.expandCollapseObjectiveMap[this.objectiveData.id] = this.showLinkedItems;
                kendisStore.commit("setExpandCollapseObjectivesMap", this.expandCollapseObjectiveMap);
            }
			this.newOkr.fields[this.okrProgressCriteriaField.id] = "";
            this.showOkrInputForm = true;
            this.showMenuOverlay = false;
            this.$nextTick(() => {
                const element = this.$refs.newOkrTitleRef;
                element.focus();
            });
        },

        closeOkrInput: function (){
            this.showOkrInputForm = false;
            this.newOkr.title = '';
            this.timePeriod.period = {};
            this.isAddCommittedObjectiveTimePeriodValid = true;
            this.isAddCommittedObjectiveTitleValid = true;
            this.toggleGroupDragging(false);
        },

        removeLinkedItem: function (itemId) {
            let _this = this;
            _.remove(_this.objectiveData.baseItemLinks, {itemId: itemId});
            _.remove(_this.objectiveData.linkedItems, {id: itemId});

            let index = _.findIndex(_this.objectiveData.linkedItemsIds, linkedItemId => linkedItemId === itemId);
            if (index > -1){
                _this.objectiveData.linkedItemsIds.splice(index, 1);
            }
            if (!_.isEmpty(_this.objectiveData.linkedItemsById)) {
                delete _this.objectiveData.linkedItemsById[itemId];
            }

            _this.objectiveData.baseItemLinks = _.sortBy(_this.objectiveData.baseItemLinks, 'sequence');

            const baseItemLinkOrder = _.fromPairs(
                _this.objectiveData.baseItemLinks.map((link, index) => [link.itemId, index])
            );

            _this.objectiveData.linkedItems = _.sortBy(_this.objectiveData.linkedItems, item => baseItemLinkOrder[item.id] ?? Number.MAX_SAFE_INTEGER);

			showTopMessage("Linked Item Removed Successfully.", "success");
            let storePayload = {};
            if (_this.objectiveData.type === "KR"){
                storePayload.objectiveId = _this.parentId;
                storePayload.okr = _this.objectiveData;
            }else{
                storePayload.objective = _this.objectiveData;
            }
            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
            let updatedMapValues = kendisStore.getters.getLinkedObjectiveMap();
            if(updatedMapValues.includes(itemId)){
                updatedMapValues = updatedMapValues.filter(id => id !== itemId);
            }
            kendisStore.commit("setLinkedObjectiveMap", updatedMapValues);
        },

        updateLinkedItemSequence(baseItemLink) {
            let ogBaseItemLink = this.objectiveData.baseItemLinks.find(link => link.id === baseItemLink.id);
            ogBaseItemLink.sequence = baseItemLink.sequence;

            this.objectiveData.baseItemLinks = _.sortBy(this.objectiveData.baseItemLinks, 'sequence');

            const baseItemLinkOrder = _.fromPairs(
                this.objectiveData.baseItemLinks.map((link, index) => [link.itemId, index])
            );

            this.objectiveData.linkedItems = _.sortBy(this.objectiveData.linkedItems, item => baseItemLinkOrder[item.id] ?? Number.MAX_SAFE_INTEGER);

            let storePayload = {};
            if (this.objectiveData.type === "KR"){
                storePayload.objectiveId = this.parentId;
                storePayload.okr = this.objectiveData;
            }else{
                storePayload.objective = this.objectiveData;
            }
            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
            let updatedMapValues = kendisStore.getters.getLinkedObjectiveMap();
            if(updatedMapValues.includes(baseItemLink.itemId)){
                updatedMapValues = updatedMapValues.filter(id => id !== baseItemLink.itemId);
            }
            kendisStore.commit("setLinkedObjectiveMap", updatedMapValues);
        },

        removeLinkedItemFromContainer: function (itemId){
            this.removeLinkedItem(itemId);
        },

        updateOkrLinkedItemSequence(baseItemLink) {
            this.updateLinkedItemSequence(baseItemLink);
        },

        loadObjectiveBaseItemList() {
            if (this.objective.type.includes("Objective") || (this.objective.type === "KR" && this.objective.fields && this.objective.fields[this.krProgressCriteriaFieldId] === "By Objectives")) {
                let request = {};
                request.objectiveId = this.objective.id;
                request.fetchPIs = true;
                axios.post('objective/get-objective-by-id', request)
                    .then(response => {
                        if (response.data && response.data.objective && response.data.objective.baseItemList) {
                            this.baseItemList = [];
                            this.baseItemList = response.data.objective.baseItemList;
                            if(response.data.sessionMapById) {
                                this.childSessionsMap = response.data.sessionMapById;
                            }
                            this.childItemsLoaded = true;
                        }
                    })
                    .catch(error => {
                        console.error(error);
                    });
                this.calculateGroupCompletion([this.groupId]);	
            }
        },

        toggleShowLinkedItemsComponent: function (showLinkedItems, isForceShow=false) {
			let _this = this;
            //if (_this.objectiveData.type === "KR" && _this.objectiveData.fields && _this.objectiveData.fields[_this.krProgressCriteriaFieldId]){
			let parentData = _this.$parent.objectiveData ? _this.$parent.objectiveData : _this.objectiveData;
            if ((_this.objectiveData.type === "KR" || (parentData && parentData.type == "KR")) || (_this.objectiveData.type.includes("Objective") && parentData && parentData.type.includes("Objective"))) {			
                if (((_this.objectiveData.type === "KR" && _this.objectiveData.fields[_this.krProgressCriteriaFieldId] === "By Objectives") || parentData.type == "KR") || (_this.objectiveData.type.includes("Objective") && parentData && parentData.type.includes("Objective"))){	
                    if (!_this.childItemsLoaded) {
                        let requestBody = {};
                        requestBody.objectiveId = _this.objectiveData.id;
                        requestBody.fetchPIs = true;
                        axios.post('objective/get-objective-by-id', requestBody)
                            .then(response => {
                                _this.showLinkedItems = true;
                                _this.expandCollapseObjectiveMap[_this.objectiveData.id] = _this.showLinkedItems;
                                kendisStore.commit("setExpandCollapseObjectivesMap", _this.expandCollapseObjectiveMap);
                                if (response.data && response.data.objective && response.data.objective.baseItemList) {
                                    _this.baseItemList = [];
                                    _this.baseItemList = response.data.objective.baseItemList
									if(response.data.sessionMapById) {
										_this.childSessionsMap = response.data.sessionMapById;
									}
                                }
                                _this.childItemsLoaded = true;
                            })
                            .catch(error => {
                                console.error(error);
                            });
                    } else {
						if(showLinkedItems != undefined) {
			                this.showLinkedItems = showLinkedItems;					
						} else {
		                	this.showLinkedItems = !this.showLinkedItems;
						}
                        _this.expandCollapseObjectiveMap[_this.objectiveData.id] = _this.showLinkedItems;
                        kendisStore.commit("setExpandCollapseObjectivesMap", _this.expandCollapseObjectiveMap);
                    }
                } else {
					if(showLinkedItems != undefined) {
		                this.showLinkedItems = showLinkedItems;					
					} else {
	                	this.showLinkedItems = !this.showLinkedItems;
					}
                    _this.expandCollapseObjectiveMap[_this.objectiveData.id] = _this.showLinkedItems;
                    kendisStore.commit("setExpandCollapseObjectivesMap", _this.expandCollapseObjectiveMap);
                }
            } else {
                if (!isForceShow) {
					if(showLinkedItems != undefined) {
	                    this.showLinkedItems = showLinkedItems;					
					} else {
                    	this.showLinkedItems = !this.showLinkedItems;
					}
                    this.expandCollapseObjectiveMap[this.objectiveData.id] = this.showLinkedItems;
                    kendisStore.commit("setExpandCollapseObjectivesMap", this.expandCollapseObjectiveMap);
                } else {
                    this.expandCollapseObjectiveMap[this.objectiveData.id] = true;
                    kendisStore.commit("setExpandCollapseObjectivesMap", this.expandCollapseObjectiveMap);
                }
            }

            if (this.objectiveData.type.includes('Objective')) {
                this.calculateGroupCompletion([this.groupId]);	
            } else {
                this.calculateOkrCompletion(this.objectiveData);
            }
        },

        saveLinkedItems: function (items) {
            let _this = this;
            let itemContainers = [];
            let linkedItemMap = {};
            _.each(_this.objectiveData.baseItemLinks, link => {
                if (link.itemId) {
                    linkedItemMap[link.itemId] = link;
                }
            });
            _.each(items, item => {
                let itemContainer = {};
                if (linkedItemMap[item.id]) {
                    itemContainer.id = linkedItemMap[item.id].id;
                }
                itemContainer.sessionId = item.sessionBoards[0].session.id;
				itemContainer.sessionBoardId = _this.board.id;

                itemContainer.itemId = item.id;
	 			if(this.isMockingMode){
	                itemContainer.linkType = "art_link_objective";	
				} else {
					itemContainer.linkType = "session_link_objective";
				}
                itemContainers.push(itemContainer);
            });
			if(_this.objectiveData.linkedItemsById) {
				_.each(_this.objectiveData.linkedItemsById, (value, key)=>{
					if(linkedItemMap[key]) {
		                itemContainers.push(linkedItemMap[key]);					
					}
				})
			}
			
            _this.updateLinkedBaseItems(itemContainers, undefined, _this.board.session.id, items);
        },

        saveBackLogItems: function(items, releaseTrainId) {
            let _this = this;
            let itemContainers = [];
            let linkedItemMap = {};

            //create link map of already attached items
            _.each(_this.objectiveData.baseItemLinks, link => {
                if (link.baseItemId && link.linkType === 'backLogItem' && link.releaseTrainId === releaseTrainId) {
                    linkedItemMap[link.baseItemId] = link;
                }
            });
            _.each(items, item => {
                var itemContainer = {};
                if (linkedItemMap[item.id]) {
                    itemContainer.id = linkedItemMap[item.id].id;
                }
                // itemContainer.sessionId = item.sessionBoards[0].session.id;
                itemContainer.baseItemId = item.id;
                itemContainer.releaseTrainId = releaseTrainId;
                itemContainers.push(itemContainer);
            });

            _this.updateBackLogItems(itemContainers, items, releaseTrainId);
        },

        updateBackLogItems: function(itemContainers, items, releaseTrainId) {
            let _this = this;
            let requestBody = {};
            requestBody.id = _this.objectiveData.id;
            requestBody.baseItemLinks = itemContainers;
            axios.post('/batch/link-backLogItems-with-batch/' + syncId , requestBody )
                .then(response => {
                    if (response.status == "200" && response.data ) {
                        if (_this.itemsGroupedByReleaseTrain[releaseTrainId]){
                            _this.itemsGroupedByReleaseTrain[releaseTrainId] = _this.itemsGroupedByReleaseTrain[releaseTrainId].concat(items);
                        }else{
                            Vue.set(_this.itemsGroupedByReleaseTrain, releaseTrainId, items);
                        }

                        // Check if the '_this.backLogItems' array is not empty.
                        if (!_.isEmpty(_this.backLogItems)) {
                            // If it's not empty, filter the 'items' array to find new items  with unique 'id' not present in 'this.backLogItems').
                            let newItems = items.filter((newItem) => {
                                return !_this.backLogItems.some((savedItem) => savedItem.id === newItem.id);
                            });
                            // Concatenate the newItems with '_this.backLogItems' to add the new items to the backlog.
                            _this.backLogItems = _this.backLogItems.concat(newItems);
                        }else{
                            // If '_this.backLogItems' is empty, simply assign the 'items' array to it as the backlog.
                            _this.backLogItems = items;
                        }

                        if (_this.objectiveData.type.includes("Objective") || _this.objectiveData.type === "KR"){
                            _this.turnMetaFlagOff();

                            _this.populateStatusMap(items,  _this.objectiveData);
                            _this.fetchSolutionBoardData(items, _this.objectiveData);
                            _this.fetchBoardMeta(items,  _this.objectiveData);
                        }

                        _this.objectiveData.baseItemLinks = response.data.savedBatch.baseItemLinks;

                        if (_this.objectiveData.type.includes("Objective")) {
                            if (_this.parentId !== _this.groupId && !_.isEmpty(_this.parentId)) {
                                let storePayload = {};
                                storePayload.okr = {
                                    "id" :  _this.objectiveData.id,
                                    "baseItemLinks" : response.data.savedBatch.baseItemLinks,
                                    "baseItemList" : _this.baseItemList,
                                    "itemsGroupedByReleaseTrain" : _this.itemsGroupedByReleaseTrain
                                };
                                storePayload.fields = ["baseItemLinks", "itemsGroupedByReleaseTrain", "baseItemList"];
                                let parent = _this.$parent.objectiveData.type === 'KR' ? _this.$parent.$parent.objectiveData : _this.$parent.objectiveData;
                                storePayload.objectiveId = parent ? parent.id : _this.parentId;
                                storePayload.stopReload = true;
                                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);

                                storePayload = {};
                                storePayload.updateBacklogItems = true;
                                storePayload.okr = {
                                    "id": _this.objectiveData.id,
                                    "backLogItems": _this.backLogItems,
                                };
                                storePayload.objectiveId = _this.parentId;
                                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                            } else {
                                let storePayload = {};
                                storePayload.objective = {
                                    "id": _this.objectiveData.id,
                                    "baseItemLinks": response.data.savedBatch.baseItemLinks,
                                    "baseItemList" : _this.baseItemList,
                                    "itemsGroupedByReleaseTrain" : _this.itemsGroupedByReleaseTrain
                                };
                                storePayload.fields = ["baseItemLinks", "itemsGroupedByReleaseTrain", "baseItemList"];
                                storePayload.stopReload = true;
                                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);

                                storePayload = {};
                                storePayload.updateBacklogItems = true;
                                storePayload.objective = {
                                    "id": _this.objectiveData.id,
                                    "backLogItems": _this.backLogItems,
                                };
                                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                            }
                        }else if (_this.objectiveData.type === "KR"){
                            let storePayload = {};
                            storePayload.okr = {
                                "id" :  _this.objectiveData.id,
                                "baseItemLinks" : response.data.savedBatch.baseItemLinks,
                                "itemsGroupedByReleaseTrain" : _this.itemsGroupedByReleaseTrain
                            };
                            storePayload.fields = ["baseItemLinks", "itemsGroupedByReleaseTrain"];
                            storePayload.objectiveId = _this.parentId;
                            storePayload.stopReload = true;
                            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);

                            storePayload = {};
                            storePayload.updateBacklogItems = true;
                            storePayload.okr = {
                                "id": _this.objectiveData.id,
                                "backLogItems": _this.backLogItems,
                            };
                            storePayload.objectiveId = _this.parentId;
                            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                        }

                        showTopMessage("Backlog Item Linked Successfully.", "success");
						if(_this.isMockingMode) {
							if (_this.objectiveData.type === "KR" || (_this.parentId !== _this.groupId)) {
								_this.calculateGroupCompletion([_this.groupId]);								
							} else {
								_this.recalculateCompletion(_this.objectiveData, _this.board);
							}
						}
	                    toggleDraggable(false);
						_this.isBackLogItemsLinked = true;
						let storePayload = {};
						storePayload[_this.objectiveData.id] = _this.isBackLogItemsLinked;
					   	kendisStore.commit("setIsbackLogItemsLinkedWithObjMap", storePayload);		
                        /*if (response.data.updatedBacklogItems) {
                            _this.fieldsValue.baseItemLinks = response.data.savedBatch.baseItemLinks;
                            if(!_.isEmpty(_this.selectedART)) {
                                _this.loadBacklogItemsForBatch(_this.selectedART);
                            }else{
                                if(itemContainers && itemContainers.length>0) {
                                    _this.loadBacklogItemsForBatch(itemContainers[0].releaseTrainId);
                                }
                            }
                            _this.backLogItemKey += 1;
                        }*/
                    }
                })
                .catch(error => {
                    _this.enableSaveButton= true;

                    console.error("Item linking error", error);
                    if(_this.itemLinkingLoader) {
                        _this.itemLinkingLoader = false;
                        _this.enableSaveButton = true;
	                    toggleDraggable(false);
                    }
                });
        },

        closeLinkItemsPopup: function(){
            let _this = this;
            _this.showLinkItemsPopup = false;
            toggleDraggable(false);
        },

        updateLinkedBaseItems: function (itemContainers, impdtId, sessionId, items) {
            let _this = this;
            let requestBody = {};
            if (_.isEmpty(impdtId)) {
                requestBody.id = _this.objectiveData.id;
            } else {
                requestBody.id = impdtId;
            }
            requestBody.baseItemLinks = itemContainers;
            let metaMap = {};
            metaMap.sessionId  = vueInstance.activeBoard.session.id;
            if (_this.objectiveData.type === "KR"){
                metaMap.objectiveId = _this.$parent.objectiveData.id;
            }
            requestBody.metaMap = JSON.stringify(metaMap);
            let url = '';
            if (sessionId) {
                url = '/sos/update-base-item-links/' + syncId + '/' + sessionId;
            }
            axios.post(url, requestBody)
                .then(response => {
                    if (response.data.savedImpediment) {
                        showTopMessage("Items Linked Successfully.", "success");
                        if(items.length > 0 && response.data.savedImpediment.type.includes("Objective")) {
                            let updatedMapValues = kendisStore.getters.getLinkedObjectiveMap();
                            _.each(items, function (item) {
                                if(!updatedMapValues.includes(item.id)){
                                    updatedMapValues.push(item.id);
                                }
                            });
                            kendisStore.commit("setLinkedObjectiveMap", updatedMapValues);
                        }
                        toggleDraggable(false);
                        _this.updateItemListing();
                    }
                })
                .catch(error => {
                    console.error("Item linking error", error);
                    handleSoSErrorMsg(error);
                });

        },

        updateItemListing: function () {
            let _this = this;
            axios.get("/objective/fetch-linked-items/" + _this.objectiveData.id)
                .then(response => {
                    if (response.status == "200") {
                        let tempBaseItemList = _this.objectiveData.baseItemList;
                        _this.objectiveData = response.data;
                        _this.objectiveData.baseItemList = tempBaseItemList;
						let storePayload = {};
                        storePayload.objectiveId = _this.parentId;
                        storePayload.okr = _this.objectiveData;
						kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                        _this.$emit("updateItems", _this.objectiveData);
                    }
                })
                .catch(error => {
                    console.error("Item linking error", error);
                    handleSoSErrorMsg(error);
                });
        },

        getBoardsForLinking: function () {
            let _this = this;
            let boards = [];
            if (this.isSolutionBoard) {
                _.forEach(_this.solutionBoard.piSessionBoards, function (board) {
                    let session = board.session;
                    boards.push({
                        id: session.id, title: session.title, name: session.title
                    });
                })
            } else {
                let session = this.board.session;
                boards.push({
                    id: session.id, title: session.title, name: session.title
                });
            }
            return boards;
        },

        onClickShowMenuPopup: function () {
            let _this = this;
            _this.showMenuOverlay = !_this.showMenuOverlay;
        },

		onDeleteFromPopup: function(parentKey) {
			let _this = this;
			let message = "";
			if(!_.isEmpty(parentKey)) {
				message = "This action will delete " + _this.objective.key + " from "+ parentKey
			} else {
				message = "This action will delete " + _this.objective.key + " from all of the groups."
			}
			
            askFromSweetAlertWrapper(message, [function(){
				_this.onCLoseEditPopUp();
				_this.deleteObjective();
			}], [takeNoAction]);			
		},
        onClickRowAction: function (option) {
            let _this = this;
            if (option == "delete") {
				let message = "";
				if(_this.objective.type == "KR") {
					message = "This action will delete " + _this.objective.key + " from "+ _this.$parent.objective.key;
				} else {
					message = "This action will delete " + _this.objective.key + " from all of the groups."
				}
				
                askFromSweetAlertWrapper(message, [_this.deleteObjective, ""], [takeNoAction]);
            } else if (option == "link_item") {
                axios.get('objective/fetch-linked-items/' + _this.objectiveData.id)
                    .then(response => {
                        let linkedItems = response.data.linkedItems;
                        let linkedItemsIds = response.data.linkedItemsIds;
                        let linkedItemsById = response.data.linkedItemsById;

                        if (linkedItems) {
                            _this.objectiveData.linkedItems = linkedItems;
                        }
                        if (linkedItemsIds) {
                            _this.objectiveData.linkedItemsIds = linkedItemsIds;
                        }
                        if (linkedItemsById) {
                            _this.objectiveData.linkedItemsById = linkedItemsById;
                        }
                        _this.showLinkItemsPopup = true;
                        _this.showMenuOverlay = false;
                        toggleDraggable(true);
                    })
                    .catch(error => {
                        console.error("Board List fetch error", error);
                    })
            } else if (option === "link_backlog_item"){
                _this.showBackLogItemsPopup = true;
                _this.showMenuOverlay = false;
                toggleDraggable(true);
            } else if (option === 'link_objective') {
                _this.showObjectiveChildLinkingPopup = true;
                _this.showMenuOverlay = false;
                toggleDraggable(true);
            }
        },

        showChildObjectivePopup() {
            if (!this.showLinkedItems){
                this.showLinkedItems = true;
                this.expandCollapseObjectiveMap[this.objectiveData.id] = this.showLinkedItems;
                kendisStore.commit("setExpandCollapseObjectivesMap", this.expandCollapseObjectiveMap);
            }
			this.showAddCommittedObjectiveInput = true;
            this.showMenuOverlay = false;
            this.$nextTick(() => {
                const element = this.$refs.newObjectiveTitleRef;
                element.focus();
            });
            this.toggleGroupDragging(true);
        },

        closeCommittedObjectiveForm: function (){
            this.showAddCommittedObjectiveInput = false;
            this.newObjectiveDataCommitted.title = '';
            this.newObjectiveDataCommittedTimePeriod.period = {};
            this.isAddCommittedChildObjectiveTimePeriodValid = true;
            this.isAddCommittedObjectiveInputValid = true;
            this.toggleGroupDragging(false);
        },

        deleteObjective: function () {
            this.$emit("deleteObjective", this.objective, this.parentId);
        },

        onEditOKRTimePeriod() {
            const type = this.objectiveData.type;
            const permissions = this.$options.permissions;

            if ((type === 'KR' && permissions?.EDIT_OKR) || (type.includes('Objective') && permissions?.EDIT_OBJECTIVE)) {
                this.editOkrTimePeriod.show = true;
                this.editOkrResponsible.show = false;
                this.editOkrStatus.show = false;
                if (this.objectiveData.fields && this.objectiveData.fields[this.timePeriodFieldId]) {
                    this.editOkrTimePeriod.timePeriod = type === 'KR' ? this.objectiveData.fields[this.timePeriodKRFieldId] : this.objectiveData.fields[this.timePeriodFieldId];
                } else {
                    this.editOkrTimePeriod.timePeriod = {};
                }
                this.toggleGroupDragging(true);
            }
        },

        onOkrTimePeriodSelect(selectedPeriod) {
            this.editOkrTimePeriod.show = false;
            this.toggleGroupDragging(false);

            if (!this.objectiveData.fields) {
                this.objectiveData.fields = {};
            }
            if (this.objectiveData.type === 'KR') {
                this.objectiveData.fields[this.timePeriodKRFieldId] = selectedPeriod.timePeriod;
                this.objectiveData.fields[this.startDateKRFieldId] = selectedPeriod.startDate;
                this.objectiveData.fields[this.endDateKRFieldId] = selectedPeriod.endDate;
            } else {
                this.objectiveData.fields[this.timePeriodFieldId] = selectedPeriod.timePeriod;
                this.objectiveData.fields[this.startDateFieldId] = selectedPeriod.startDate;
                this.objectiveData.fields[this.endDateFieldId] = selectedPeriod.endDate;
            }

            if(this.objectiveData.itemType.title == "KR" || !_.isEmpty(this.parentId)) {
                this.$emit("onSaveEditOkr", this.objectiveData);
            } else {
				if(this.isMockingMode && (this.$parent.objectiveData && this.$parent.objectiveData.type == "KR")) {
	                this.$emit("onSaveEditOkr", this.objectiveData);
				} else {
                	this.$emit("editObjective", this.objectiveData);
				}
            }
        },

        onEditOKRResponsible() {
            const type = this.objectiveData.type;
            const permissions = this.$options.permissions;

            if ((type === 'KR' && permissions?.EDIT_OKR) || (type.includes('Objective') && permissions?.EDIT_OBJECTIVE)) {
                this.editOkrResponsible.show = true;
                this.editOkrTimePeriod.show = false;
                this.editOkrStatus.show = false;
                this.editOkrResponsible.responsible = this.objectiveData.fields[this.responsibleFieldId] || {};
                this.toggleGroupDragging(true);
            }
        },

        onOkrResponsibleSelect(user) {
            this.editOkrResponsible.show = false;
            this.toggleGroupDragging(false);
            this.objectiveData.fields[this.responsibleFieldId] = user;
            if(this.objectiveData.itemType.title == "KR" || !_.isEmpty(this.parentId)) {
                this.$emit("onSaveEditOkr", this.objectiveData);
            } else {
				if(this.isMockingMode && (this.$parent.objectiveData && this.$parent.objectiveData.type == "KR")) {
	                this.$emit("onSaveEditOkr", this.objectiveData);
				} else {
                	this.$emit("editObjective", this.objectiveData);
				}
            }
        },

        onEditOKRStatus() {
            const { type, status } = this.objectiveData;
            const permissions = this.$options.permissions;
        
            if ((type === 'KR' && permissions?.EDIT_OKR) || (type.includes('Objective') && permissions?.EDIT_OBJECTIVE)) {
                Object.assign(this.editOkrStatus, { show: true, status });
                this.editOkrTimePeriod.show = false;
                this.editOkrResponsible.show = false;
                this.toggleGroupDragging(true);
            }
        },
        
        onSelectOkrStatus() {
            this.editOkrStatus.show = false;
            this.toggleGroupDragging(false);
            this.objectiveData.status = this.editOkrStatus.status;
            if(this.objectiveData.itemType.title == "KR" || !_.isEmpty(this.parentId)) {
                this.$emit("onSaveEditOkr", this.objectiveData);
            } else {
				if(this.isMockingMode && (this.$parent.objectiveData && this.$parent.objectiveData.type == "KR")) {
	                this.$emit("onSaveEditOkr", this.objectiveData);
				} else {
                	this.$emit("editObjective", this.objectiveData);
				}
            }
        },

        onEditObjective: function () {
            let _this = this;
            this.editObjectiveData = _.clone(_this.objectiveData);
            this.showMenuOverlay = false;
            this.showEditView = true;
            this.toggleGroupDragging(true)
        },

        closeEditView: function (){
            this.showEditView = false;
            this.toggleGroupDragging(false);
        },

        onSaveEditObjectiveData: function (objective, updateObjFromContainer) {
            if(!this.isTitleValid(objective.title)){
                this.isEditCustomObjectiveInputValid = false;
                showTopMessage("Please enter a valid title.","warning",3000);
                return;
            } else {
                this.isEditCustomObjectiveInputValid = true;
            }
            this.showEditView = false;
            if (!updateObjFromContainer){
                this.toggleGroupDragging(false);
            }
            let data = this.editObjectiveData;
            if(this.itemTemplate.showEditPopUp || this.krProgressCriteriaEdit.show) {
                data = objective;
            }
            if(data.itemType.title == "KR" || !_.isEmpty(this.parentId)) {
                this.$emit("onSaveEditOkr", objective);
            } else {
				if(this.isMockingMode && (this.$parent.objectiveData && this.$parent.objectiveData.type == "KR")) {
	                this.$emit("onSaveEditOkr", objective);
				} else {
                	this.$emit("editObjective", data);
				}
            }
        },

        formatBVPlanValue: function () {
            this.editObjectiveData.bvPlan = Math.min(99999, Math.max(0, Math.floor(Number(this.editObjectiveData.bvPlan))));
        },

        formatBVActualValue: function () {
            this.editObjectiveData.bvActual = Math.min(99999,Math.max(0, Math.floor(Number(this.editObjectiveData.bvActual))));
        },
        
        calculateObjCompletion: function () {
            let _this = this;

            // New Completion Calculation Formula
            //% completion = % completion of KR-1 (weight of KR-1) + % completion of KR-2 (weight of KR-2) +.......... + % completion of KR-n (weight of KR-n)
            let obj = _this.objectiveData;

            if (_this.objectiveMenuOptions['isUnCommittedEnabled'] || obj.type !== "Objective-Uncommitted") {
                if (_this.objectiveMenuOptions['isOkrEnabled'] && (_this.objectiveData.type.includes("Objective") || _this.objectiveData.type.includes("normal") || _this.objectiveData.type.includes("stretch")) && _this.calculationCriteria === "OBJ_KR_WEIGHTS_FORMULA") {
                    let objCompletion = 0;
                    let valueOfX = _this.calculateValueOfSingleX();
                    _this.objLinkedItemsCompletion = _this.calculateCompletion(obj, _this.excludeItemsData, undefined, _this.objectiveTeam);
                    let linkedCardWeight = _.find(_this.okrListWithWeights, okr => okr.id === "-1");
                    if (linkedCardWeight && linkedCardWeight.assignedWeight){
                        objCompletion = _this.objLinkedItemsCompletion * ((linkedCardWeight.assignedWeight * valueOfX) / 100);
                    }
                    let objLinkedOkrCompletion = 0;
                    _.each(_this.objectiveData.baseItemList, okr => {
                        let okrCompletion = _this.calculateOkrCompletion(okr);
                        let temp = _.find(_this.okrListWithWeights, {id: okr.id});
                        if (temp && temp.assignedWeight > 0) {
                            objLinkedOkrCompletion += okrCompletion * ((temp.assignedWeight * valueOfX) / 100);
                        }
                    });
                    let totalCompletion = (objCompletion + objLinkedOkrCompletion).toFixed(2);
                    _this.completion = parseFloat(totalCompletion);
                    _this.$emit("objectiveCompletion", {
                        "id": obj.id,
                        "title": obj.title,
                        "type": obj.type,
                        "completion": _this.completion
                    });
                } else if ((_this.objectiveMenuOptions['isOkrEnabled'] && _this.objectiveData.type === "KR")) {
                    _this.completion = _this.calculateOkrCompletion(_this.objectiveData);
                } else {
                    _this.completion = _this.calculateCompletion(obj, _this.excludeItemsData, _this.calculationCriteria, _this.objectiveTeam);
                }
            }
        },
        calculateOkrCompletion: function(okr){
            let _this = this;
			if(_this.isMockingMode && this.getOkrCompletionMap && this.getOkrCompletionMap[this.objectiveData.id]) {
				return this.getOkrCompletionMap[okr.id]
			}
            let targetValue = 0;
            let progressValue = 0;
            let okrCompletion = 0;
			let startValue = 0;
            let okrProgressCriteriaGroupFields = kendisStore.getters.getOkrProgressCriteriaGroupFields();

            if (okr.fields) {
                _.each(okrProgressCriteriaGroupFields, groupField => {
                    if (groupField.title === "Progress Criteria") {
                        _this.progressCriteriaFieldToShow = okr.fields[groupField.id];
                    } else if (groupField.title === "Target Value") {
                        targetValue = parseFloat(okr.fields[groupField.id]);
                    } else if (groupField.title === "Progress") {
                        progressValue = parseFloat(okr.fields[groupField.id]);
                    } else if (groupField.title === "Start") {
                        startValue = parseFloat(okr.fields[groupField.id]);
                    }
                });

                if (_this.progressCriteriaFieldToShow === "By Objectives") {
                    let valueOfX = _this.calculateValueOfSingleX();
                    let completion = _this.calculateCompletion(okr, _this.excludeItemsData);
                    let temp = _.filter(_this.okrListWithWeights, {id: okr.id});

                    if (temp.length > 0) {
                        temp = temp[0];
                        okrCompletion += completion * ((temp.assignedWeight * valueOfX) / 100);
                    }

                } else if (_this.progressCriteriaFieldToShow === "By Items") {
                    okrCompletion = _this.calculateCompletion(okr, _this.excludeItemsData);
                } else if (_this.progressCriteriaFieldToShow === "Target") {
                    if (!isNaN(targetValue) && !isNaN(progressValue)) {
						if(isNaN(startValue) || startValue == targetValue) {
							if(targetValue != 0) {
                        		okrCompletion = (progressValue / targetValue) * 100;
							}
						} else if(!isNaN(startValue)) {
							if(startValue < targetValue) {
	                        	okrCompletion = ((progressValue - startValue) / (targetValue - startValue)) * 100;
							} else {
	                        	okrCompletion = ((startValue - progressValue) / (startValue - targetValue)) * 100;								
							}
						}
                    }
                }
            }
            return _.round(okrCompletion,2);
        },

        filterOKRs() {
            if (_.isEmpty(this.timePeriodFilter) || _.isEmpty(this.timePeriodFilter.selectedValue)) {
                this.baseItemList = _.cloneDeep(this.originalBaseItemList);
                return;
            }

            if (this.timePeriodFilter && this.timePeriodFilter.byKrs) {
                let filter = this.timePeriodFilter;
                this.baseItemList = _.cloneDeep(this.originalBaseItemList);
                this.baseItemList = _.filter(this.baseItemList, (kr) => {
                    // Assuming KRs have a similar structure for filtering based on fields
                    if (kr.fields && kr.fields[this.timePeriodKRFieldId]) {
                        return filter.selectedValues[filter.selectedYear].includes(kr.fields[this.timePeriodKRFieldId].title) &&
                            kr.fields[this.timePeriodKRFieldId].selectedYear === filter.selectedYear;
                    }
                    return false;
                });
            }
        },

        onChangeSortableOkr: function(evt){
            let objective = {};
            let okr = {};
            let objectiveListTemp = [];
            let fromId = evt.from.getAttribute('data-id');
            let toId = evt.to.getAttribute('data-id');
            objective = _.filter(this.$parent.objectiveGroup.baseItemList, {id: fromId})[0];
            okr = objective.baseItemList[evt.oldIndex];
            objectiveListTemp = objective.baseItemList;
            let result = this.calculateNewSequenceOfItem(evt.newIndex, evt.oldIndex, objectiveListTemp, 'sequence');
            if(result){
                okr.sequence = result.value;
                okr.newIndex = evt.newIndex;
                okr.metaMap = {};
                okr.metaMap.syncId = syncId;
                if (this.isMockingMode){
                    okr.metaMap.sessionId = this.board.session.id;
                }else{
                    okr.metaMap.sessionId = vueInstance.activeBoard.session.id;
                }
                okr.metaMap.boardId = this.board.id;
                okr.metaMap = JSON.stringify(okr.metaMap);
                okr.itemType = kendisStore.getters.getOkrTemplate().scheme.itemType;
                this.onSaveEditOkr(okr);

            }
        },
        updateOkrList: function (updatedList) {
            this.baseItemList = updatedList;
            this.dynamicOkrItemKey = this.dynamicOkrItemKey + 1;
        },
        saveOkrWeights: function ([okrListWithWeights, objCompletion]) {
            let _this = this;
            _this.okrListWithWeights = okrListWithWeights;
            _this.completion = objCompletion;
            if (_this.objectiveData.type.includes("Objective")){
                _this.$emit("objectiveCompletion", {
                    "id": _this.objectiveData.id,
                    "title": _this.objectiveData.title,
                    "type": _this.objectiveData.type,
                    "completion": _this.completion
                });
            }
        },
        handleChildCall: function(payload, event){
            this.$emit("updateObjectiveGroupList", payload, event);
        },
        toggleWeightSummaryView : function(){
            let _this = this;
            if (_this.objectiveMenuOptions['isOkrEnabled'] && _this.isNotOkr() && (_this.isMockingMode || _this.calculationCriteria === "OBJ_KR_WEIGHTS_FORMULA") ) {
                _this.showWeightageSummaryView = !_this.showWeightageSummaryView;
                if (_this.showWeightageSummaryView){
                    toggleDraggable(true);
                }else{
                    toggleDraggable(false);
                }
            }
        },
        okrWeightPercentage: function (okr){
            let _this = this;
            let completion = 0;
            let valueOfX = _this.calculateValueOfSingleX();

            if (valueOfX > 0){
               if (_this.okrListWithWeights && okr){
                    for (let i=0; i < _this.okrListWithWeights.length; i++){
                        if (_this.okrListWithWeights[i]["id"] === okr.id){
                            completion = _.round(_this.okrListWithWeights[i]["assignedWeight"] * valueOfX);
                            break;
                        }
                    }
               }else{
                    let linkedCardWeight = _.find(_this.okrListWithWeights, okr => okr.id === "-1");
                    if (linkedCardWeight) {
                        completion = _.round(linkedCardWeight.assignedWeight * valueOfX);
                    }
               }
            }

            return completion;
        },
        objectiveCompletionCriteria: function (criteria){
            let _this = this;
            _this.objectiveData.completionCriteria = criteria.code
            this.$emit("completionCriteria", _this.objectiveData)
        },
        objectiveCompletionCriteriaChild: function (objectiveData){
            this.$emit("completionCriteria", objectiveData);
        },
        keyResultCompletionCriteria: function(criteria) {
            let _this = this;
            _this.objectiveData.completionCriteria = criteria.code;
            _this.$emit("updateKeyResultCriteria", _this.objectiveData);
        },
        updateKeyResultCriteria: function(updateOkr) {
            let _this = this;
            _this.onSaveEditOkr(updateOkr);
        },
        isTitleValid(title) {
            /*This method checks the following things:
            1- Firstly it eliminates and leading and trailing space characters
            2- Secondly it checks that the title is not empty */
            if(title !== undefined) {
                title = title.trim();
                return title.length > 0;
            }
            return false;
        },
        populateOkrListWithWeights: function(){
            let _this = this;

            let index = _.findIndex(_this.okrListWithWeights, {"id" : "-1"});

            if (index === -1){
                let linkedCardObj = {
                    title: "Linked Cards",
                    id: "-1",
                    assignedWeight: _this.objectiveData.linkedCardWeights
                };
                _this.okrListWithWeights.push(linkedCardObj);
            }else{
                _this.okrListWithWeights[index].assignedWeight = _this.objectiveData.linkedCardWeights;
            }

            if (_this.objectiveData.baseItemList) {
                _.each(_this.objectiveData.baseItemList, obj => {
                    _.each(_this.objectiveData.baseItemLinks, link => {
                        if (link.baseItemId === obj.id && link.weightage !== undefined) {
                            index = _.findIndex(_this.okrListWithWeights, {"id" : obj.id});
                            if (index === -1) {
                                _this.okrListWithWeights.push({
                                    "id": obj.id,
                                    "assignedWeight": link.weightage,
                                    "key": obj.key,
                                    "title": obj.title,
                                });
                            }else{
                                _this.okrListWithWeights[index].assignedWeight = link.weightage;
                            }
                        }
                    });
                });
            }

            _.each(_this.okrListWithWeights, okr => {
                if (okr.assignedWeight > 0){
                    okr.selectedForWeights = true;
                }else{
                    okr.selectedForWeights = false;
                }
            });
        },
        calculateValueOfSingleX: function(){
            let _this = this;
            let sumOfAssignedWeights = 0;
            let valueOfX = 0;

            _.each(_this.okrListWithWeights, item => {
                if (_this.isMockingMode){
                    if (item["id"] === "-1" && !_this.isBackLogItemsLinked) {
                        // Skip linked card weight in the calculation if no backlog item is linked with objective.
                        return;
                    }
                }else {
                    if (item["id"] === "-1" && (!_this.objectiveData.linkedItems || _this.objectiveData.linkedItems.length === 0)) {
                        // Skip linked card weight in the calculation if no item is linked with objective.
                        return;
                    }
                }
                if (item["assignedWeight"] > 0){
                    sumOfAssignedWeights += item["assignedWeight"]
                }
            });

            if (sumOfAssignedWeights > 0) {
                valueOfX = 100 / sumOfAssignedWeights;
            }

            return valueOfX;
        },
        getKey: function () {
            if(this.objective.highlightedKey) {
                return this.objective.highlightedKey;
            } else {
                return this.objective.key;
            }
        },
        openParentContainer: function (){
            let _this = this;
            _this.onCLoseEditPopUp();
            _this.$emit("open-objective-container", _this.objectiveData.id);
        },
        openObjectiveContainer: function (keyResultId){
            let _this = this;
            _this.openModalForEditing(_this.objectiveData);
        },
        closeParentContainer: function (){
            this.onCLoseEditPopUp();
        },
        openKeyResultContainer: function (keyResult){
            let _this = this;
            if (_this.$refs['KR_' + keyResult.id][0]){
                if (!_this.showLinkedItems){
                    _this.showLinkedItems = true;
                    this.expandCollapseObjectiveMap[this.objectiveData.id] = this.showLinkedItems;
                    kendisStore.commit("setExpandCollapseObjectivesMap", this.expandCollapseObjectiveMap);
                }
                _this.$refs['KR_' + keyResult.id][0].openModalForEditing(keyResult, true);
            }
        },
        openLinkedObjContainer: function (linkedObj){
            let _this = this;
            _this.onCLoseEditPopUp();
			if(this.isMockingMode) {
				_this.toggleShowLinkedItemsComponent(true);
				_this.$nextTick(()=>{
					_this.$refs['KR_' + linkedObj.id][0].openModalForEditing(linkedObj)				
				})
			} else {
            	_this.$emit("open-linked-obj", linkedObj);
			}
        },
        openLinkedObjective: function (linkedObj){
            this.$emit("open-linked-obj", linkedObj);
        },
        viewEditOptions: function (){
            let _this = this;
            if (_this.objective.type === "KR" && _this.$options.permissions && (_this.$options.permissions.EDIT_OKR || _this.$options.permissions.DELETE_OKR)){
                _this.showEditOptions = true;
            }else if (_this.objective.type.includes("Objective") && _this.$options.permissions && (_this.$options.permissions.LINK_UNLINK_OBJECTIVE_ITEMS || _this.$options.permissions.EDIT_OBJECTIVE || _this.$options.permissions.EDIT_OKR || _this.$options.permissions.DELETE_OBJECTIVE)){
                _this.showEditOptions = true;
            }
        },
        toggleGroupDragging: function (option){
            toggleDraggable(option)
        },
        getClassForRowDiv: function() {
        	if(this.objective && this.objective.type.includes("Objective")) {
        		return 'objout';
        	}
        },
		getDepartments: function() {
			let _this = this;
			let departments = [];
			let departmentIdsMap = {};
			_.each(_this.objective.baseItemLinks, link=>{
    			if(link.linkType && link.linkType ==  "art_link_objective") {
					departmentIdsMap[link.sessionId] = 1;
    			}
			});
			_.each(Object.keys(departmentIdsMap), dptId =>{
                if (_this.departmentsMap[dptId]){
				    departments.push(_this.departmentsMap[dptId]);
                }
			})
			return departments;
		},
		userImageOrInitialHtml: function (user, short) {

            var html = "";
            if (user && user.picturePath && (typeof agendaPublicShare =="undefined" || !agendaPublicShare)) {
                var imgPath = s3_resource_url + user.picturePath;
                html = '<img src="' + imgPath +'" alt="' + user.fullName + '" title="' + user.fullName + '" />';
            } else {
                if (user.fullName) {
                    var initials = this.getInitials(user.fullName);
                    html = '<div class="initial" style="background-color:' + user.backgroundColor +'" title="'+ user.fullName +'">' + initials + '</div>';
                }
            }
            if (short) {
                return html;
            }else {
                return html +" "+ user.fullName;
            }
        },
        getInitials: function (name) {
            var nameArray = name.split(" ");
            var initials = nameArray[0].charAt(0);
            if (nameArray[1])
                initials = initials + "" + nameArray[1].charAt(0);
            return initials;
        },
        showItemsForReleaseTrain: function (releaseTrainId){
            let _this = this;
            let itemsGroupedByRT = {};
            let metaDetails = {};
            let backLogItems = [];

            if (_this.objectiveData.type.includes("Objective")){
                outerLoop: for (let i = 0; i < _this.objectiveGroups.length; i++) {
                    if (_this.objectiveGroups[i].baseItemList){
                      for (let j = 0; j < _this.objectiveGroups[i].baseItemList.length; j++) {
                        if (_this.objectiveGroups[i].baseItemList[j].id === _this.objectiveData.id && !_.isEmpty(_this.objectiveGroups[i].baseItemList[j].itemsGroupedByReleaseTrain) && !_.isEmpty(_this.objectiveGroups[i].baseItemList[j].backLogItems) && !_.isEmpty(_this.objectiveGroups[i].baseItemList[j].backlogItemsMetaDetails)) {
                          itemsGroupedByRT = _this.objectiveGroups[i].baseItemList[j].itemsGroupedByReleaseTrain;
                          metaDetails = _this.objectiveGroups[i].baseItemList[j].backlogItemsMetaDetails;
                          backLogItems = _this.objectiveGroups[i].baseItemList[j].backLogItems;
                          break outerLoop; // This breaks out of both the outer and inner loops
                        }
                      }
                    }
                }
            }else if(_this.objectiveData.type === "KR"){
                outerLoop: for (let i = 0; i < _this.objectiveGroups.length; i++) {
                        if (_this.objectiveGroups[i].baseItemList){
                          for (let j = 0; j < _this.objectiveGroups[i].baseItemList.length; j++) {
                              if ( _this.objectiveGroups[i].baseItemList[j].baseItemList){
                                  for (let k = 0; k < _this.objectiveGroups[i].baseItemList[j].baseItemList.length; k++) {
                                    if (_this.objectiveGroups[i].baseItemList[j].baseItemList[k].id === _this.objectiveData.id && !_.isEmpty(_this.objectiveGroups[i].baseItemList[j].baseItemList[k].itemsGroupedByReleaseTrain) && !_.isEmpty(_this.objectiveGroups[i].baseItemList[j].baseItemList[k].backLogItems) && !_.isEmpty(_this.objectiveGroups[i].baseItemList[j].baseItemList[k].backlogItemsMetaDetails)) {
                                      itemsGroupedByRT = _this.objectiveGroups[i].baseItemList[j].baseItemList[k].itemsGroupedByReleaseTrain;
                                      metaDetails = _this.objectiveGroups[i].baseItemList[j].baseItemList[k].backlogItemsMetaDetails;
                                      backLogItems = _this.objectiveGroups[i].baseItemList[j].baseItemList[k].backLogItems;
                                      break outerLoop; // This breaks out of both the outer and inner loops
                                    }

                                  }
                              }
                          }
                      }
                }
            }

            if (!itemsGroupedByRT.hasOwnProperty(releaseTrainId) || _.isEmpty(itemsGroupedByRT[releaseTrainId])){
                _this.loadBacklogItemsForBatch(releaseTrainId, _this.objectiveData);
            }else{
                _this.itemsGroupedByReleaseTrain = itemsGroupedByRT;
                 _this.backlogItemsMetaDetails = metaDetails;
                _this.backLogItems = backLogItems;
            }
        },
        removeBackLogItem: function(itemId) {
            //find index of fieldsValue baseitem links where baseItemId is itemId
            let _this = this;
            let index = _.findIndex(_this.objectiveData.baseItemLinks, function(link) {
                return link.baseItemId == itemId;

            });

            if (index > -1) {
                //remove this index
                _this.objectiveData.baseItemLinks.splice(index, 1);
            }

            for (let key in _this.itemsGroupedByReleaseTrain) {
              if (_this.itemsGroupedByReleaseTrain.hasOwnProperty(key)) {
                _this.itemsGroupedByReleaseTrain[key] = _this.itemsGroupedByReleaseTrain[key].filter(item => item.id !== itemId);
              }
            }

            if (_this.objectiveData.type.includes("Objective")) {
                if (_this.parentId !== _this.groupId && !_.isEmpty(_this.parentId)) {
                    let storePayload = {};
                    storePayload.okr = {
                        "id": _this.objectiveData,
                        "baseItemLinks" : _this.objectiveData.baseItemLinks,
                        "baseItemList" : _this.baseItemList,
                        "itemsGroupedByReleaseTrain" : _this.itemsGroupedByReleaseTrain
                    };
                    storePayload.fields = ["baseItemLinks", "itemsGroupedByReleaseTrain", "baseItemList"];
                    let parent = _this.$parent.objectiveData.type === 'KR' ? _this.$parent.$parent.objectiveData : _this.$parent.objectiveData;
                    storePayload.objectiveId = parent ? parent.id : _this.parentId;
                    kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                    if(_this.isMockingMode) {
                        _this.recalculateCompletion(parent, _this.board);
                    }
                } else {
                    let storeBackLogItems = [];

                    outerLoop: for (let i = 0; i < _this.objectiveGroups.length; i++) {
                        if (_this.objectiveGroups[i].baseItemList) {
                            for (let j = 0; j < _this.objectiveGroups[i].baseItemList.length; j++) {
                                if (_this.objectiveGroups[i].baseItemList[j].id === _this.objectiveData.id) {
                                storeBackLogItems = _this.objectiveGroups[i].baseItemList[j].backLogItems;
                                break outerLoop; // This breaks out of both the outer and inner loops
                                }
                            }
                        }
                    }
                    let storePayload = {};
                    storePayload.objective = {
                        "id": _this.objectiveData.id,
                        "baseItemLinks" : _this.objectiveData.baseItemLinks,
                        "baseItemList" : _this.baseItemList,
                        "itemsGroupedByReleaseTrain" : _this.itemsGroupedByReleaseTrain
                    };
                    storePayload.fields = ["baseItemLinks", "itemsGroupedByReleaseTrain", "baseItemList"];
                    kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                    if(_this.isMockingMode) {
                        _this.recalculateCompletion(_this.objectiveData, _this.board);
                    }
                }

            }else if (_this.objectiveData.type === "KR"){
                let storePayload = {};
                storePayload.okr = {
                    "id": _this.objectiveData,
                    "baseItemLinks" : _this.objectiveData.baseItemLinks,
                    "itemsGroupedByReleaseTrain" : _this.itemsGroupedByReleaseTrain
                };
                storePayload.fields = ["baseItemLinks", "itemsGroupedByReleaseTrain"];
                storePayload.objectiveId = _this.parentId;
                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
				if(_this.isMockingMode) {
					_this.recalculateCompletion(_this.$parent.objectiveData, _this.board);
				}
            }
            // _this.backLogItemKey += 1;

        },
		fetchLinkedOkrs: function() {
			let _this = this;
			axios.get('objective/get-linked-okrs/'+_this.objectiveData.id)
			.then(response=>{
				if (response.status == "200" && response.data.linkedOkrs) {
					_this.linkedOkrs = response.data.linkedOkrs;
				}
				_this.linkedOkrsLoaded = true;				
			})
			.catch(error=>{
				console.error(error);
			})
		},
        onVisiblityChange(isVisible, entry) {
			let _this = this;
			if(isVisible && !this.linkedOkrsLoaded && this.objective.type.includes("Objective") && !this.isMockingMode) {
				window.clearTimeout(_this.isScrolling);
				_this.isScrolling = setTimeout(() => {
			        _this.isVisible = true;
					window.clearTimeout(_this.isScrolling);
				}, 3000);
				//this.fetchLinkedOkrs();
			}
        },
		onCancelBacklogItemLinking: function() {
			this.showBackLogItemsPopup = false;
            toggleDraggable(false);
		},
        isBackLogItemsLinkedWithObj: function (objId){
            let _this = this;
              axios.get("/objective/is-backlog-item-linked/" + objId)
                .then(response => {
                    if (response.status == "200") {
                       	_this.isBackLogItemsLinked =  response.data;
					   	let storePayload = {};
						storePayload[objId] = _this.isBackLogItemsLinked;
					   	kendisStore.commit("setIsbackLogItemsLinkedWithObjMap", storePayload);
                    }
                })
                .catch(error => {
                    console.error("Error occurred while checking whether backlog items are linked or not: ", error);
                });
        },
        redirectToGlobalViewUrl: function () {
			return;
            /*let url = "/objectives";
            window.open(url, "_blank");*/
        },
		redirectToSession: function(pi) {
            let url = "/session?id="+pi.activeSessionBoard + "&moreOptionsIndex=3&moreOptionsSubIndex=-1";
            window.open(url, "_blank");			
		},
        redirectToBatch: function (key) {
            let url = ""
                url = "batches#/" + key;
            window.open(url, "_blank");
        },
		getParentSessions: function() {
			let _this = this;
			let sessions = [];
			let sessionIdsMap = {};			
			_.each(_this.objective.baseItemLinks, link=>{
    			if((link.linkType && link.linkType ==  "session_linked_objective" && link.type == "Objective") || (link.type == "Objective" && !_.isEmpty(link.sessionBoardId))) {
					sessionIdsMap[link.sessionId] = 1;
    			}
			});
			_.each(Object.keys(sessionIdsMap), sessionId =>{
                if (_this.sessionsMap[sessionId]){
				    sessions.push(_this.sessionsMap[sessionId]);
                }
			});
			_this.parentSessions = sessions;
			if(!_.isEmpty(_this.parentSessions)) {
				_this.showBoardLinkedItem = true;
				_this.sessionBoardMap = kendisStore.getters.getSessionBoardsMap();				
				_this.sessionBoard = _this.sessionBoardMap[_this.parentSessions[0].activeSessionBoard]
			}			
		},
		getClassForTooltipWidth: function(okr) {
			if(okr.title && okr.title.length > 120) {
				return "okr-width";
			}
		},
        updateBacklogItemsColumns: function () {
            this.backLogComponentKey += 1;
        },
		fetchOkrCallback: function(objective, baseItem, sessionMapById, closeParent) {
			let _this = this;
			if (objective && objective.itemType && objective.itemType.title == "Objective") {
				_this.itemTemplate.templateToRenderer = _.cloneDeep(kendisStore.getters.getObjectiveTemplate().scheme.fieldsTemplate);
				if (!_this.objectiveMenuOptions['isUnCommittedEnabled'] || _this.isMockingMode) {
					_.each(_this.itemTemplate.templateToRenderer.configuredFields, configField => {
						_.each(configField.subTemplate.configuredFields, field => {
							if (field.title === "Type") {
								field.options.splice(1, 1);
							}
						})
					})
				}
				_this.itemTemplate.statuses = kendisStore.getters.getObjectiveTemplate().statuses;

				_this.displayMode = "Objective";

				/*if (_this.isMockingMode && _this.objectiveData.type.includes("Objective")){
					_this.displayMode = "Global-Objectives";
					_this.IsInlineEditingEnabled = false;
				}else{
					_this.displayMode = "Objective";
				}*/
			} else if (objective && objective.itemType && objective.itemType.title == "KR") {
				_this.itemTemplate.templateToRenderer = _.cloneDeep(kendisStore.getters.getOkrTemplate().scheme.fieldsTemplate);
				let isKrOfPiObj = false;
				for (let i = 0; i < baseItem.baseItemLinks.length; i++) {
					if (baseItem.baseItemLinks[i].linkType === "session_link_objective") {
						isKrOfPiObj = true;
					}
				}
				if (isKrOfPiObj) {
					_.each(_this.itemTemplate.templateToRenderer.configuredFields, configField => {
						_.each(configField.subTemplate.configuredFields, field => {
							if (field.title === "Progress Criteria") {
								field.options.splice(2, 1);
							}
						})
					})
				}
				_this.itemTemplate.statuses = kendisStore.getters.getOkrTemplate().statuses;
				if (sessionMapById) {
					_this.itemTemplate.sessionsMap = sessionMapById;
				}
				_this.displayMode = "KR";
				if (_this.objectiveData.fields && _this.objectiveData.fields[_this.krProgressCriteriaFieldId] && _this.objectiveData.fields[_this.krProgressCriteriaFieldId] === "By Objectives") {
					if (baseItem && baseItem.baseItemList) {
						_this.baseItemList = [];
						_this.baseItemList = baseItem.baseItemList
						if (sessionMapById) {
							_this.childSessionsMap = sessionMapById;
						}
					}
					_this.childItemsLoaded = true;
				}
			}

			_this.itemTemplate.id = baseItem.id;
			_this.itemTemplate.model.id = baseItem.id;
			_this.itemTemplate.model.title = baseItem.title;
			_this.itemTemplate.model.description = baseItem.description;
			_this.itemTemplate.model.bvPlan = baseItem.bvPlan;
			_this.itemTemplate.model.bvActual = baseItem.bvActual;
			_this.itemTemplate.model.key = baseItem.key;
			_this.itemTemplate.board = (_this.showBoardLinkedItem && _this.isMockingMode) ? _this.sessionBoard : this.board;
			if (_this.displayMode == "Objective") {
				_this.itemTemplate.model.type = baseItem.type.split("-")[1];
			}
			let boardSession = [];
			boardSession.push({id: this.board.session.id, name: this.board.session.title})
			_this.itemTemplate.boardSession = boardSession;
			_this.itemTemplate.model.selectedSessions = []
			_this.itemTemplate.model.selectedSessions.push(this.board.session);
			if (baseItem.fields) {
				_this.itemTemplate.model.fields = baseItem.fields;
			}
			if (baseItem.status) {
				_this.itemTemplate.model.status = baseItem.status;
			}
			if (baseItem.baseItemList) {
				_this.itemTemplate.model.baseItemList = baseItem.baseItemList;
			}
			if (baseItem.fieldsTemplate) {
				_this.itemTemplate.templateToRenderer = baseItem.fieldsTemplate;
			}
			if (baseItem.baseItemLinks) {
				_this.itemTemplate.model.baseItemLinks = baseItem.baseItemLinks;
			}
			if (baseItem.itemTypeList) {
				_this.itemTemplate.itemTypeList = baseItem.itemTypeList;
			}
			_this.itemTemplate.model.linkedItemObject = {};
			if (baseItem.id) {
				_this.itemTemplate.model.linkedItemObject.id = baseItem.id;
			}
			if (baseItem.linkedItemsIds) {
				_this.itemTemplate.model.linkedItemObject.linkedItemsIds = baseItem.linkedItemsIds;
			}
			if (baseItem.linkedItems) {
				_this.itemTemplate.model.linkedItemObject.linkedItems = baseItem.linkedItems;
			}
			if (baseItem.linkedItemsById) {
				_this.itemTemplate.model.linkedItemObject.linkedItemsById = baseItem.linkedItemsById;
			}
			_this.itemTemplate.itemType = baseItem.itemType;

			//Added for Backlog Items Mixin code checks
			//Consult nasir for details
			_this.itemTemplate.model.itemType = baseItem.itemType;

			_this.itemTemplate.creationAndUpdateData = {
				"createdOn": baseItem.createdOn,
				"createdBy": baseItem.createdBy,
				"updatedOn": baseItem.updatedOn,
				"updatedBy": baseItem.updatedBy
			};
			_this.itemTemplate.model.linkedCardWeights = baseItem.linkedCardWeights;
			_this.itemTemplate.model.completionCriteria = baseItem.completionCriteria;
			if (baseItem.selectedLinkedGroups) {
				_this.itemTemplate.model.selectedLinkedGroups = baseItem.selectedLinkedGroups;
			} else {
				_this.itemTemplate.model.selectedLinkedGroups = [];
			}

			let groupId = _this.groupId;
			/*if (_this.objectiveData.type === "KR"){
				groupId = _this.$parent.$parent.objectiveGroup.id;
			}else{
				groupId = _this.$parent.objectiveGroup.id;
			}*/

			if (closeParent) {
				_this.$emit("close-parent-container");
			}

			if (_this.objOkrPopupContainerMap[groupId] === undefined) {
				_this.objOkrPopupContainerMap[groupId] = {};
			}
			_this.objOkrPopupContainerMap[groupId].isPopupOpen = true;
			_this.objOkrPopupContainerMap[groupId].displayMode = _this.displayMode;
			_this.objOkrPopupContainerMap[groupId].itemTemplate = _this.itemTemplate;
			kendisStore.commit("setObjOkrPopupContainerMap", _this.objOkrPopupContainerMap);

			_this.modalDataLoaded = true;
			toggleDraggable(true);
			this.$forceUpdate();
		},
		getBoard: function() {
			if(this.itemTemplate.board) {
				return this.itemTemplate.board;
			} else if(!_.isEmpty(this.parentSessions)){
				return {session: this.parentSessions[0]};
			}
		},
    }
});