const OBJECTIVE_LINK = Vue.component('objective-link', {
    template: /*html*/`			
		<div>
			<div v-if="!isMockingMode" id="link-objective-popup-container">
				<div class="aa" style="display: block;">
					<div id="overlay" class="overlay" style="display: block;"></div>
					<div class="ui-dialog item-link add-pop" style="display: block;">
						<div class="dialgtl"> 
							{{title}} <span class="ftsb" v-if="!_.isEmpty(itemKey)">{{itemKey}}</span>
							<em class="rmv-ico ti-close" @click="onClickCancelLinkItem" title="Close"></em>
						</div>
						<div id="link-items" class="cntr mrow aa" style="display: block;">
							<div class=" select-o-items">
								<div class="ui-multiselect-menu ui-widget ui-widget-content ui-corner-all" style="display: block;">
									<div>
										<div class="ui-multiselect-filter lblm a">
											<label>Search Objectives to Link</label> <input placeholder="Enter keywords" type="search" v-model="query" @input="onEnterSearchText" />
										</div>
									</div>
									<ul class="ui-multiselect-checkboxes ui-helper-reset">
										<template v-for="(objective, objIndex) in objectiveGroupListCopy">
											<li v-if="objective.showTitle" class="ui-multiselect-optgroup-label "><a href="javascript:void(0);">{{objective.title}}</a></li>
											<li v-if="objective.committedObjs.titleShow && objective.committedObjs.objs.length > 0" @click ="toggleCommittedObjs(objIndex)" :class="['ui-multiselect-optgroup-label', 'Objlist', objective.committedObjs.toggle ? 'active' : '']"><em class="arrdrpico arr DIB trnsn"></em><a href="javascript:void(0); " class="aa">Committed Objectives</a></li>
											<template v-if="objective.committedObjs.toggle" v-for="(comittedObj) in objective.committedObjs.objs">
												<li class=" groupedLi objchild" v-if="comittedObj.show">
													<label class="ui-corner-all ui-state-hover"> 
													<input @click.stop="onSelectLinkItem(comittedObj.id)" type="checkbox" :title="comittedObj.title" :checked="comittedObj.selected" /> 
													<span class="lbl"> <span class="key"><a v-if="comittedObj.key" target="_blank">{{comittedObj.key}}</a></span> <span>{{comittedObj.title}}</span></span>
													</label>
												</li>
											</template>
											<li v-if="objective.uncommittedObjs.titleShow && objective.uncommittedObjs.objs.length > 0" @click ="toggleUnCommittedObjs(objIndex)" :class="['ui-multiselect-optgroup-label', 'Objlist', objective.uncommittedObjs.toggle ? 'active' : '']"><em class="arrdrpico arr DIB trnsn"></em><a href="javascript:void(0);" class="aa">Uncomitted Objectives</a></li>
											<template v-if="objective.uncommittedObjs.toggle" v-for="(uncomittedObj) in objective.uncommittedObjs.objs">
												<li class=" groupedL objchild" v-if="uncomittedObj.show">
													<label class="ui-corner-all ui-state-hover"> 
													<input @click.stop="onSelectLinkItem(uncomittedObj.id)" type="checkbox" :title="uncomittedObj.title" :checked="uncomittedObj.selected" /> 
													<span class="lbl"> <span class="key"><a v-if="uncomittedObj.key" target="_blank">{{uncomittedObj.key}}</a></span> <span>{{uncomittedObj.title}}</span></span>
													</label>
												</li>
											</template>
										</template>
									</ul>
								</div>
							</div>
							<div class="rec btn">
								<input id="save-o-items" type="button" class="button FR action" :class="[!saveButtonEnabled ? 'disabled' : '']"	value="Save" :disabled="!saveButtonEnabled"	@click="onSelectSaveLinkItems" /> 
								<a href="javascript:void(0);" class="FR cncl action" @click="onClickCancelLinkItem">Cancel</a>
							</div>
						</div>
					</div>
				</div>
			</div>
			
			<div v-else>
				<div class="overlay" style="display: block;"></div>
				<div  class=" ui-dialog aa add-pop createrealtionpop p-fix" style="display: block;">
					<div class="">
						<div class="dialgtl"> 
							{{title}} <span class="ftsb txtgr " v-if="!_.isEmpty(itemKey)">{{itemKey}}</span>
							<em class="rmv-ico ti-close rnd DAJ" @click="onClickCancelLinkItem" title="Close"></em>
						</div>
					
						<div class="cntr mrow aa linkobjpop">
							<div class="mrec mb-20">
								<label class="lblin">Search</label>
								<div class="srch ico"><input id="kr_search" type="text" class="w-full search_input rnd6" v-model="searchQueryForDb" @input="onInputSearchQuery(false)" placeholder="Search by Title or Id"/></div>
							</div>
							<template v-if="_.isEmpty(searchQueryForDb)">
								<div class="maintabs itemmode">
									<span @click="onChangeTab(1)" class="tabgenrl ftsb" :class="currentTab == 1? 'active': ''">Collection OKRs</span>
									<span @click="onChangeTab(3)" class="tabgenrl ftsb" :class="currentTab == 3? 'active': ''">Program Board Objectives</span>
								</div>
								
								<div class="wbox maintbcont">

									<div v-if="currentTab == 3" class="mrec mb-20">
										<label class="lblin">Search Program Board</label>
										<div class="srch ico"><input id="kr_search" type="text" class="w-full search_input rnd6" v-model="searchPiBoard" @input="onInputSearchPiBoard" placeholder="Search by Title"/></div>
										<template v-if="piBoards.length > 0">
											<vuepopup @close="onClosePiSearch">
												<div id="search-list" class="search-list drop_box" style="display: block; top: 265px; left: 31px; width: 538px;">
													<ul>
														<li v-for="(board,index) in piBoards"
															:id="'srch-tag-'+index" class="resut"
															@click="onSelectBoard(board)">
															<span class="txt">
																{{board.title}}
															</span>
														</li>
													</ul>
												</div>
											</vuepopup>
										</template>
									</div>
							
									<label class="lblin">Select Collection</label>					
									<div class="selectcont mb-20">
										<vz-select 
											v-model="releaseTrain"
											:multiple="false" 
											:options="rtOptions" 
											:show-item-key="true"
											empty-selection-text="Select from the list" 
											label="title" 
											track-by="id" 
											value-type="object" 
											@select="onSelectCollection" />
									</div>
									<!--<div v-if="releaseTrain.id && releaseTrain.level != '-1'" class="mrec mb-20">
										<label>Link From</label>
										<div class="selectcont">
											<vz-select 
												v-model="linkObjectivesFrom"
												:multiple="false" 
												:options="selectionOptions" 
												empty-selection-text="Select from the list" 
												label="title" 
												track-by="id" 
												value-type="object" 
												@select="onSelectingLinkingOption"/>
										</div>
									</div>-->
									<div v-if="linkObjectivesFrom.id == 'pi'" class="mrec mb-20" :class="[sessionsLoaded ? '' : 'disabled']">
										<label>Select Program Board</label>
										<div class="selectcont">
											<vz-select 
												v-model="selectedSession"
												:multiple="false" 
												:options="workspaceSessions" 
												empty-selection-text="Select from the list" 
												label="title" 
												track-by="id" 
												value-type="object" 
												@select="fetchGroups(true)"/>
										</div>
									</div>
									<div v-if="groupsLoaded" class="mrec mb-10">
										<label>Select Group</label>
										<div class="selectcont">
											<vz-select 
												v-model="selectedObjectiveGroup"
												:multiple="false" 
												:options="objectiveGroupList" 
												empty-selection-text="Select from the list" 
												label="title" 
												track-by="id" 
												value-type="object" 
												@select="loadObjectivesOfGroup"/>
										</div>
									</div>
								
									<!--<div v-if="objectivesLoaded" class="mrec mb-20">
										<label>Select Objectives</label>
										<div class="selectcont">
											<vz-select 
												v-model="selectedObjectives"
												:multiple="true" 
												:options="allObjectives"
												:show-item-key="true"
												empty-selection-text="Select from the list" 
												label="title" 
												track-by="id" 
												value-type="object" />
										</div>
									</div>-->
								<template v-if="selectedObjectiveGroup.id">
									<template v-if="!_.isEmpty(allObjectives)">
									    <template>
									    	<div class="linkedObjOkr">
									    		<div class="linkedOkrObjTitl DFA"><em class="objectives2 ico DIB mr-10"></em>Objectives</div>
									    		<div class="ui-multiselect-filter lblm p-rel"><input v-model="searchQuery" placeholder="Enter keywords" type="search" @input="onEnterSearchQuery"></div>
									    	</div>
										    <template v-if="noObjFoundInSearch">
										        <div class="nofound">No Item Found.</div>
										    </template>
						
				                            <ul class="ui-multiselect-checkboxes ui-helper-reset brdokrlist">
				                                <template v-for="(objective, objIndex) in allObjectives">
				                                    <li class="DFA" v-if="objective.showTitle" :class="['ui-multiselect-optgroup-label', 'Objlist', 'active']">
				                                   	<div class="custom-checkbox linkOBJChk">
				                                   		<input :id="objective.id" @click.stop="onSelectObjective(objective)" type="checkbox" :title="objective.title" :checked="objective.selected" :disabled="objective.disabled" />
				                                   		<label :for="objective.id"></label>
				                                   	</div>
													
													<span class="key FN linkdItemsKrObjKey"><a class="linkdItemsKrObj" v-if="objective.key" target="_blank">{{objective.key}}</a></span>
													<span :title="objective.title" class="elips brdLinkOkr">{{objective.title}}</span></a>
				                                    </li>
				                                </template>
				                            </ul>
				                        </template>
									</template>
									<template v-else>
									    <div class="nofound">No Objectives Linked To This Collection.</div>
									</template>
								</template>
								</div> <!-- maintbcont ends -->
							</template>
							<template v-else>
								<template v-if="!_.isEmpty(searchedObjectives)">
								    <template>
								    	<div class="linkedObjOkr">
								    		<div class="linkedOkrObjTitl DFA"><em class="objectives2 ico DIB mr-10"></em>Objectives</div>
								    	</div>
					
			                            <ul @scroll="onScrollObjectivesList" class="ui-multiselect-checkboxes ui-helper-reset brdokrlist scroll-objs">
			                                <template v-for="(objective, objIndex) in searchedObjectives">
			                                    <li :class="['ui-multiselect-optgroup-label', 'Objlist', 'active']">
			                                    	<div class="DFA">
				                                   	<div class="custom-checkbox linkOBJChk">
				                                   		<input :id="objective.id" @click.stop="onSelectObjective(objective)" type="checkbox" :title="objective.title" :checked="objective.selected" :disabled="objective.disabled" />
				                                   		<label :for="objective.id"></label>
				                                   	</div>
													
													<span class="key FN linkdItemsKrObjKey"><a class="linkdItemsKrObj" target="_blank">{{objective.key}}</a></span>
													<span :title="objective.title" class="elips brdLinkOkr">{{objective.title}}</span></a>
													</div>
													<template v-if="objectiveGroupsByObjId[objective.id]">
														<div class="tmout DIB">
														<div v-for="(grp, grpIndex) in objectiveGroupsByObjId[objective.id]" class="spttg DFA mt-10 mr-10 tooltip c-point">
															<div class="tmin light">{{grp.title+ (grpIndex != objectiveGroupsByObjId[objective.id].length - 1 ? ", " : "")}}</div>															
															<div class="hovtooltipB linkokrwithkrtip">{{grp.title}}</div>
														</div>
														</div>
													</template>
			                                    </li>
			                                </template>
			                            </ul>
			                        </template>
								</template>
								<template v-else>
								    <div class="nofound">No Objectives Found.</div>
								</template>							
							</template>
							<div class="rec btn">
								<button :class="[!saveButtonEnabled ? 'disabled' : '']"	value="Save" :disabled="!saveButtonEnabled" @click="saveLinkedObjectives" class="FR">Save</button>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	`,
    props: {
        title: {
            type: String,
            default: () => {
                return ""
            }
        },
        data: {
            type: Object,
            default: () => {
                return {features: [], stories: []}
            }
        },
        showBoardFilter: {
            type: Boolean,
            default: () => {
                return true
            }
        },
        board: {
            type: Object,
            default: () => {
                return {};
            }
        },
        boards: {
            type: Array,
            default: () => {
                return []
            }
        },
        sessionBoards: {
            type: Array,
            default: () => {
                return []
            }
        },
        linkedObjectives: {
            type: Array,
            default: () => {
                return []
            }
        },
        fitContainer: {
            type: Boolean,
            default: () => {
                return false
            }
        },
        fetchFeatures: {
            type: Boolean,
            default: () => {
                return true
            }
        },
        fetchUserStories: {
            type: Boolean,
            default: () => {
                return true
            }
        },
        container: {
            type: String,
            default: () => {
                return ""
            }
        },
        itemKey: {
            type: String,
            default: () => {
                return ""
            }
        },
        okrId: {
            type: String,
            default: () => {
                return ""
            }
        },
        isMockingMode: {
            type: Boolean,
            default: () =>{ return false }
        },
		associateWith: {
            type: Object,
            default :() => {
                return {}
            }			
		},
		okr: {
			type: Object,
			default :() => {
				return {}
			}
		},
		okrGroup: {
			type: Object,
			default :() => {
				return {}
			}
		}
    },

    computed: {},

    data() {
        return {
            saveButtonEnabled		: false,
			sessionsLoaded			: false,
			objectivesLoaded		: false,
			groupsLoaded			: false,
			saveButtonEnabled		: false,
			noObjFoundInSearch		: false,			
            query					: "",
			searchQuery				: "",
			searchQueryForDb		: "",
			oldSearchQueryForDb		: "",
			currentTab				: 0,
			pageIndex				: 0,
			pageSize				: 10,
            objectiveGroupList		: [],
            objectiveGroupListCopy	: [],
			allReleaseTrains		: [],
			workspaceSessions		: [],
			allGroups				: [],
			allObjectives			: [],
			selectedObjectives		: [],
			rtOptions				: [],
			searchedObjectives		: [],
            selectedItemsMap		: {},
			releaseTrain			: {},
			selectedSession			: {},
			selectedObjectiveGroup	: {},			
			linkObjectivesFrom		: {},
			sessionsFetchedForWs	: {},
			objectiveGroupsByObjId	: {},
			selectionOptions: [
				{
					id		: "pi",
					title	: "Link From PI"
				},
				{
					id		: "collection",
					title	: "Link From Collection"
				},
			],
			piBoards: [],
			searchPiBoard: "",
        }
    },
    watch: {
		allReleaseTrains: {
			handler: function() {
				this.onChangeTab(this.associateWith.tabNum);
			},
		}
	},

    created() {
        if(this.batchMode){
            this.loadBatchListBySessionBoardId();
        }else if(this.isMockingMode){
			this.fetchReleaseTrains();
			//this.loadObjectiveGroupsListByObjectId();
        }
        else {
            this.loadObjectiveGroupsListBySessionBoardId(this.board);
        }
		if(!_.isEmpty(this.allReleaseTrains)) {
			this.onChangeTab(this.associateWith.tabNum);
		}
	},

    mounted: function () {

        if (this.fitContainer) {
            var container = document.getElementById(this.container);
            var element = document.getElementById("link-objective-popup-container");
            element.parentElement.removeChild(element);
            container.appendChild(element);
        }
		$('#kr_search').focus();

    },
    methods: {

        //////////////////////////////////////////////////
        ///////////////    LOGIC
        fetchReleaseTrains: function () {
            //fetch all release trains
            let _this = this;
            let data = {};
            data.fetchTypes = true;
            axios.post("/releasetrain/release-trains", data)
			.then(res => {
                _this.allReleaseTrains = _this.allReleaseTrains.concat(res.data.releaseTrains);
            })
			.catch(error => {
                console.log(error);
            });
		},

		fetchPiBoards(request) {
			let _this = this;

			axios.post('/plan/boards', request)
			.then(response=>{
				if(response.data && response.data) {
					let data = response.data.parentBoards;
					_this.piBoards = data.map(board => board.session);
				}
			})
			.catch(error=>{
				console.error(error);	
			})
		},
        checkForEnablesSaveButton: function () {
            var _this = this;

            var selectedMap = {};
            _.forOwn(_this.selectedItemsMap, item => selectedMap[item.id]=true);

            let stateChanged = false;
            let enable = false;
            for (let i=0; i<_this.objectiveGroupList.length && !stateChanged; i++){
                for(let j=0; j<_this.objectiveGroupList[i].baseItemList.length; j++){
                    let linkedobj = selectedMap[_this.objectiveGroupList[i].baseItemList[j].id] ? true : false;
                    if (linkedobj !== _this.objectiveGroupList[i].baseItemList[j].selected){
                        enable = true;
                        stateChanged = true;
                        break;
                    }
                }
                if (stateChanged){
                    break;
                }
            }

            _this.saveButtonEnabled = enable;
        },
		matchObjective: function(objective) {
            let query = this.query.toLowerCase();
			let found = objective.title.toLowerCase().includes(query) || objective.key.toLowerCase().includes(query)
			return found
		},
        applyFilter: function () {
            let _this = this;
            _.each(_this.objectiveGroupListCopy, objGrp => objGrp.showTitle = true);
            if (!_.isEmpty(_this.query)) {
                let objGrpTitleCounter = 0;

                if (_this.objectiveGroupListCopy.length > 0) {
                    _.each(_this.objectiveGroupListCopy, objGrp => {
                        let childObjCounter = 0;
                        _.each(objGrp.committedObjs.objs, comittedObj => {
							if(_this.matchObjective(comittedObj)) {
                                comittedObj.show = true;								
							}
                            else {
                                comittedObj.show = false;
                                objGrpTitleCounter += 1;
                                childObjCounter += 1;
                            } 
                        })

                        if (childObjCounter === objGrp.committedObjs.objs.length){
                            objGrp.committedObjs.titleShow = false;
                        }else{
                            objGrp.committedObjs.titleShow = true;
                        }

                        childObjCounter = 0;

                        _.each(objGrp.uncommittedObjs.objs, uncomittedObj => {
							if(_this.matchObjective(uncomittedObj)) {
                                uncomittedObj.show = true;
							}	
                            else {
                                uncomittedObj.show = false;
                                objGrpTitleCounter += 1;
                                childObjCounter += 1;
                            }
                        })

                        if (childObjCounter === objGrp.uncommittedObjs.objs.length){
                            objGrp.uncommittedObjs.titleShow = false;
                        }else{
                            objGrp.uncommittedObjs.titleShow = true;
                        }
                        if (objGrpTitleCounter === objGrp.baseItemList.length || objGrp.hasOneParentObj || (objGrp.isParentGroupOfOkr && objGrpTitleCounter === objGrp.baseItemList.length - 1)) {
                            objGrp.showTitle = false;
                        }
                        objGrpTitleCounter = 0;
                    })
                }
            } else if (_.isEmpty(_this.query)) {
                _this.objectiveGroupListCopy = _.cloneDeep(_this.objectiveGroupList);
            }
        },

        //////////////////////////////////////////////////
        ///////////////   API CALLS
        loadObjectiveGroupsListBySessionBoardId: function (board) {
            let _this = this;
            axios.get('objective/get-objective-groups-list-by-session-id/' + board.session.id + "/" + null+'/'+board.id)
                .then(response => {
                    if (response.status == "200") {
                        _this.objectiveGroupList = response.data.objectiveGroups;
						if(this.isMockingMode) {
                            let uniqueObjectivesMap = {};
							_.each(_this.objectiveGroupList, grp=>{
								_.each(grp.baseItemList, obj=>{
									uniqueObjectivesMap[obj.id] = obj;
								});
							});

                            _this.allObjectives = Object.values(uniqueObjectivesMap);
						}
                        _.each(_this.objectiveGroupList, objectGroup => {
                            objectGroup.committedObjs = {toggle: true, titleShow: true, objs: []};
                            objectGroup.uncommittedObjs = {toggle: true, titleShow: true, objs: []};
                            if (objectGroup.baseItemList){
                                _.each(objectGroup.baseItemList, item => {
                                    let okrIndex = _.findIndex(item.baseItemList, okr => okr.id === _this.okrId);
                                    if (okrIndex === -1) {
                                        objectGroup.showTitle = true;
                                        item.show = true;
                                        let index = _.findIndex(_this.linkedObjectives, {id : item.id});
                                        if (item.type === "Objective-Committed") {
                                            if (index > -1){
                                                item.selected = true;
                                                _this.selectedItemsMap[item.id] = item;
                                            }else{
                                                item.selected = false;
                                            }
                                            objectGroup.committedObjs.objs.push(item);
                                        } else if (item.type === "Objective-Uncommitted") {
                                            if (index > -1){
                                                item.selected = true;
                                                _this.selectedItemsMap[item.id] = item;
                                            }else{
                                                item.selected = false;
                                            }
                                            objectGroup.uncommittedObjs.objs.push(item);
                                        }
                                    }else{
                                        if (objectGroup.baseItemList.length === 1){
                                            objectGroup.showTitle = false;
                                            objectGroup.hasOneParentObj = true;
                                        }
                                        objectGroup.isParentGroupOfOkr = true;
                                        item.selected = false;
                                        item.show = false;
                                    }
                                });
                            }else{
                                objectGroup.baseItemList = [];
                                objectGroup.showTitle = false;
                            }

                        });
                        _this.objectiveGroupListCopy = _.cloneDeep(_this.objectiveGroupList);
						_this.objectivesLoaded 		 = true;
                    }
                })
                .catch(error => {
                    console.error("There was an error while loading objective groups data: ", error);
                })
        },
        loadObjectiveGroupsListByObjectId: function () {
            let _this = this;
			let requestBody = {};
			requestBody.sessionId = this.board.session.id;
			requestBody.isMockingMode = this.isMockingMode;

            axios.post('objective/get-objective-groups-list-by-object-id',requestBody)
                .then(response => {
                    if (response.status == "200") {
                        _this.objectiveGroupList = response.data.objectiveGroups;
                        _.each(_this.objectiveGroupList, objectGroup => {
                            objectGroup.committedObjs = {toggle: true, titleShow: true, objs: []};
                            objectGroup.uncommittedObjs = {toggle: true, titleShow: true, objs: []};
                            if (objectGroup.baseItemList){
                                _.each(objectGroup.baseItemList, item => {
                                    let okrIndex = _.findIndex(item.baseItemList, okr => okr.id === _this.okrId);
                                    if (okrIndex === -1) {
                                        objectGroup.showTitle = true;
                                        item.show = true;
                                        let index = _.findIndex(_this.linkedObjectives, {id : item.id});
                                        if (item.type === "Objective-Committed") {
                                            if (index > -1){
                                                item.selected = true;
                                                _this.selectedItemsMap[item.id] = item;
                                            }else{
                                                item.selected = false;
                                            }
                                            objectGroup.committedObjs.objs.push(item);
                                        } else if (item.type === "Objective-Uncommitted") {
                                            if (index > -1){
                                                item.selected = true;
                                                _this.selectedItemsMap[item.id] = item;
                                            }else{
                                                item.selected = false;
                                            }
                                            objectGroup.uncommittedObjs.objs.push(item);
                                        }
                                    }else{
                                        if (objectGroup.baseItemList.length === 1){
                                            objectGroup.showTitle = false;
                                            objectGroup.hasOneParentObj = true;
                                        }
                                        objectGroup.isParentGroupOfOkr = true;
                                        item.selected = false;
                                        item.show = false;
                                    }
                                });
                            }else{
                                objectGroup.baseItemList = [];
                                objectGroup.showTitle = false;
                            }

                        });
                        _this.objectiveGroupListCopy = _.cloneDeep(_this.objectiveGroupList);
                    }
	
                })
                .catch(error => {
                    _this.isLoading = false;
                    console.error("Item save error", error);

                })
        },
		
        loadBatchListBySessionBoardId: function () {
            let _this = this;
            axios.get('batch/get-batch-groups-list-by-session-id/' + null)
                .then(response => {
                    if (response.status == "200") {
                        _this.objectiveGroupList = response.data.objectiveGroups;
                        _.each(_this.objectiveGroupList, objectGroup => {
                            objectGroup.showTitle = true;
                            objectGroup.selected = false;
                            objectGroup.show = true;
                        })
                        _this.objectiveGroupListCopy = _.cloneDeep(_this.objectiveGroupList);
                    }
                })
                .catch(error => {
                    console.error("There was an error while loading objective groups data: ", error);
                })
        },


        //////////////////////////////////////////////////
        //////////////     UI ACTIONS
        onSelectLinkItem: function (baseItemId) {
            let _this = this;
            if (_this.objectiveGroupListCopy.length > 0) {
                _.each(_this.objectiveGroupListCopy, objGrp => {
                    _.each(objGrp.baseItemList, baseItem => {
                        if (baseItem.id === baseItemId) {
                            baseItem.selected = !baseItem.selected;
                            if (baseItem.selected === true) {
                                _this.selectedItemsMap[baseItem.id] = baseItem;
                            } else if (baseItem.selected === false && _this.selectedItemsMap.length !== 0) {
                                    if (!_.isEmpty(_this.selectedItemsMap[baseItem.id])) {
                                        delete _this.selectedItemsMap[baseItem.id];
                                    }
                            }
                        }
                    })
                })
            }
            this.checkForEnablesSaveButton();
        },
        onClickCancelLinkItem: function () {
            if (this.fitContainer) {
                var element = document.getElementById("link-objective-popup-container");
                element.parentElement.removeChild(element);
            }
            this.$emit('cancel');
        },
        onSelectSaveLinkItems: function () {
            var linkItems = this.selectedItemsMap;
            if(this.globalMode){
                var allSelectedItems = this.getAllSeletedObjectives();
                this.$emit('save', allSelectedItems);
            }else{
                this.$emit('save', linkItems);
            }
            this.onClickCancelLinkItem();
        },
        getAllSeletedObjectives: function () {
            var allSelectedItems=[];
            _.each(this.objectiveGroupListCopy, objGrp => {
                _.each(objGrp.baseItemList, item =>{
                    if(item.selected){
                        allSelectedItems.push(item);
                    }
                });
            });

            return allSelectedItems;
        },
        onEnterSearchText: function () {
            this.applyFilter();
        },
        toggleCommittedObjs: function (objIndex) {
            let _this = this;
            let data = _this.objectiveGroupListCopy[objIndex].committedObjs;
            data.toggle = !data.toggle;
        },
        toggleUnCommittedObjs: function (objIndex) {
            let _this = this;
            let data = _this.objectiveGroupListCopy[objIndex].uncommittedObjs;
            data.toggle = !data.toggle;
        },
		fetchBoardsOfWorkSpace: function() {
			let _this = this;
			_this.sessionsLoaded = false;
			axios.get('objective/fetch-workspace-boards/'+this.releaseTrain.id)
			.then(response=>{
				if(response.data && response.data.sessions) {
					_this.workspaceSessions = response.data.sessions;
					_this.sessionsFetchedForWs[_this.releaseTrain.id] = response.data.sessions;
				}
				_this.sessionsLoaded = true;				
			})
			.catch(error=>{
				console.error(error);	
			})
		},
		loadObjectivesOfPI: function() {
			let board = {};
			this.objectivesLoaded = false;
			board.id = this.selectedSession.activeSessionBoard;
			board.session = this.selectedSession;
			this.loadObjectiveGroupsListBySessionBoardId(board);
		},
		saveLinkedObjectives: function() {
			let _this = this;
			let objectiveMap = {};
			_.each(_this.selectedObjectives, obj=>{
				objectiveMap[obj.id] = obj;
			});
            this.$emit('save', objectiveMap);			
		},
		onSelectingLinkingOption: function() {
			let _this = this;
			if(_this.linkObjectivesFrom.id == "pi") {
				this.fetchBoardsOfWorkSpace();
			} else if(_this.linkObjectivesFrom.id == "collection") {
				_this.fetchGroups();
			}
		},
		loadObjectivesOfGroup: function() {
			let _this = this;
			let requestBody = {};
			requestBody.groupIds = [_this.selectedObjectiveGroup.id];
			if(_this.selectedSession.id) {
				requestBody.sessionId = _this.selectedSession.id;			
			} else {
				requestBody.sessionId = _this.releaseTrain.id;
			}
			axios.post('objective/get-objectives-of-group', requestBody)
			.then(response=>{
				if(response.status == "200" && response.data) {
					if(!_.isEmpty(response.data.objectiveGroups)) {
						let objectives = [];
						_.each(response.data.objectiveGroups, grp=>{
							_.each(grp.baseItemList, obj=>{
								obj.showTitle = true;
								objectives.push(obj);
							})							
						})
						_this.allObjectives = objectives;
					}
				}
			})
			.catch(error=>{
				
			})
		},
		fetchGroups: function(fetchPiGroups) {
			let _this = this;
			_this.allObjectives = [];			
			let requestBody = {};
			if(fetchPiGroups) {
				requestBody.sessionId = _this.selectedSession.id;				
			} else {
				requestBody.sessionId = _this.releaseTrain.id;			
			}
			requestBody.isMockingMode = _this.isMockingMode;
            axios.post('objective/load-objective-groups-data', requestBody)
            .then(response => {
                if (response.status == "200") {
					const customViews = kendisStore.getters.getCustomViews();

					_this.objectiveGroupList = response.data.objectiveGroupsList;

					_this.objectiveGroupList = _this.objectiveGroupList.filter(group => _.isEmpty(group.linkedCustomView) || group.linkedCustomView !== _this.okrGroup.linkedCustomView);

					_this.objectiveGroupList.forEach(group => {
						if (group.linkedCustomView) {
							const view = customViews.find(view => view.id === group.linkedCustomView);
							if (view) {
								group.title = view.title;
							}
						}
					})
					_this.groupsLoaded = true;
                }
            })
            .catch(error => {
                console.error("Error loading objective groups data.", error);
            });											
		},
        onSelectObjective: function (objective) {
            let _this = this;
            objective.selected = !objective.selected;
            if (objective.selected === true) {
               _this.selectedObjectives.push(objective)
               if (!_this.saveButtonEnabled){
                   _this.saveButtonEnabled = true;
               }
            } else{
                let objIndex = _.findIndex(_this.selectedObjectives, {id: objective.id});
                if (objIndex > -1){
                    _this.selectedObjectives.splice(objIndex, 1);
                }
            }
            // this.checkForEnablesSaveButton(originalState);
        },
		onSelectCollection: function() {
			if(this.currentTab == 1) {
				this.linkObjectivesFrom = this.selectionOptions[1];				
				this.onSelectingLinkingOption();
			} else if(this.currentTab == 3) {
				this.linkObjectivesFrom = this.selectionOptions[0];				
				if(this.sessionsFetchedForWs[this.releaseTrain.id]) {
					this.workspaceSessions 	= this.sessionsFetchedForWs[this.releaseTrain.id];
					this.sessionsLoaded		= true;
					return;
				}
				this.fetchBoardsOfWorkSpace();				
			}
			
			/*if(this.releaseTrain.level == "-1") {
				//this.linkObjectivesFrom = this.selectionOptions[0];
				if(_this.sessionsFetchedForWs[_this.releaseTrain.id]) {
					_this.workspaceSessions = _this.sessionsFetchedForWs[_this.releaseTrain.id];
					return;
				}
				this.fetchBoardsOfWorkSpace();
			} else {
				this.linkObjectivesFrom = {};
			}*/
		},
        matchObjective: function(objective) {
            let query = this.searchQuery.toLowerCase();
			let found = objective.title.toLowerCase().includes(query) || objective.key.toLowerCase().includes(query)
			return found
		},		
		onEnterSearchQuery: function() {
            let _this = this;
			_this.noObjFoundInSearch = true;
            _.each(_this.allObjectives, objective => {
                objective.showTitle = false;
            });
            if (!_.isEmpty(_this.searchQuery) && !_.isEmpty(_this.allObjectives)) {
                _.each(_this.allObjectives, objective => {
                    if(_this.matchObjective(objective)) {
                        objective.showTitle = true;
						_this.noObjFoundInSearch = false;
                    }
                });
			} else if(_.isEmpty(_this.searchQuery)) {
                _.each(_this.allObjectives, objective => {
                    objective.showTitle = true;
					_this.noObjFoundInSearch = false;
                });				
			}
		},
		onChangeTab: function(tabName) {
			this.currentTab				= tabName;
			this.allGroups				= [];
			this.selectedGroups			= [];
			this.selectedSessions		= [];
			this.selectedBatch			= [];
			this.selectedObjectiveGroup = {};
			this.groupsLoaded			= false;
			this.sessionsLoaded			= false;
			if(this.currentTab == 1) {
				this.linkObjectivesFrom = this.selectionOptions[1];				
				this.rtOptions			= _.filter(this.allReleaseTrains, rt=>{return rt.level != '-1'});
				if(this.releaseTrain.level === "-1") {
					this.releaseTrain 	= {};
				}
			} else if(this.currentTab == 3) {
				this.linkObjectivesFrom = this.selectionOptions[0];
				this.rtOptions			= this.allReleaseTrains;
			}
			if(!_.isEmpty(this.releaseTrain)) {
				this.onSelectCollection();
			}
			this.$forceUpdate();
		},
		onInputSearchPiBoard() {
			let _this = this;
			if(!_.isEmpty(_this.searchPiBoard) && _this.searchPiBoard.length >= 1) {
				let searchQuery = _this.searchPiBoard.toLowerCase();
				let workSpaceIds = _this.allReleaseTrains.map(rt => rt.id);

				let request = {};
				request.open = true;
				request.title = searchQuery;
				request.workSpacesIds = workSpaceIds;
				request.requestId = getNewUUID();

				_this.fetchPiBoards(request);
			}
		},
		onSelectBoard(board) {
			this.selectedSession = board;
			let releaseTrainId = board.workSpace.id; 
			if (releaseTrainId) {
				this.releaseTrain = this.allReleaseTrains.find(rt => rt.id === releaseTrainId);
				this.fetchBoardsOfWorkSpace();
			}
			this.sessionsLoaded = true;
			this.piBoards = [];
			this.fetchGroups(true);
		},
		onClosePiSearch() {
			this.piBoards = [];
			this.searchPiBoard = "";
			this.selectedSession = {};
			this.releaseTrain = {};
			this.sessionsLoaded = false;
		},
		onInputSearchQuery: function(isScrolling) {
			let _this = this;
			if(!isScrolling) {
				_this.pageIndex = 0;
			}
			if(!_.isEmpty(_this.searchQueryForDb) && _this.searchQueryForDb.length >= 1) {
				let searchQuery = _this.searchQueryForDb.toLowerCase();
				_this.oldSearchQueryForDb = searchQuery;
				let requestBody = {};
				requestBody.searchQuery = searchQuery;
				requestBody.itemTypeId = kendisStore.getters.getObjectiveTemplate().scheme.itemType.id;
				requestBody.pageIndex = _this.pageIndex;
				requestBody.pageSize = _this.pageSize;
				
				axios.post('objective/get-by-search-query', requestBody)
				.then(response=>{
					if(response.data && response.data.objectives) {
						if(isScrolling) {							
							_this.searchedObjectives = _this.searchedObjectives.concat(response.data.objectives);
						} else {
							_this.searchedObjectives = _.cloneDeep(response.data.objectives);							
						}
						Object.assign(_this.objectiveGroupsByObjId, response.data.objectiveGroupsByObjId)
						_this.searchedObjectives = _.filter(_this.searchedObjectives, obj => {
							const group = _this.objectiveGroupsByObjId[obj.id];

							if (!Array.isArray(group) || group.length === 0) {
								return true;
							}

							return !group[0]?.baseItemLinks?.some(link => link.type === 'custom-view' && link.baseItemId === _this.okrGroup.linkedCustomView);
						});
						_.forEach(_this.searchedObjectives, obj => {
							let index = _.findIndex(_this.linkedObjectives, {id : obj.id});
							if (index > -1){
								obj.selected = true;
								obj.disabled = true;
							}
						});
					}
				})
				.catch(error=>{
					console.error(error);
				});
			}
		},
		onScrollObjectivesList: function (event) {
			if ((event.target.offsetHeight + event.target.scrollTop) >= event.target.scrollHeight) {
				this.pageIndex += 1;
				this.onInputSearchQuery(true);
			}
		},
		
    }
});