
const objGroupEventBus = new Vue();

const OBJECTIVE_GROUP_COMPONENT = Vue.component('objective-group-component', {
    mixins: [CALCULATION_SETTINGS_MIXIN, OBJECTIVE_MIXIN, URL_PARAMETER_MIXIN],
    props: {
        objectiveGroup: {
            type: Object,
            default: () => {
                return {};
            }
        },
        board: {
            type: Object,
            default: () => {
                return {};
            }
        },
        departmentsMap: {
            type: Object,
			default: () => {
                return {};
            }
        },
		sessionsMap: {
            type: Object, 
			default: () => {
                return {};
            }
        },
        batchesMap: {
            type: Object,
			default: () => {
                return {};
            }
        },
        objectiveList: {
            type: Array,
            default: () => {
                return [];
            }
        },
        parentIndex: {
            type: Number,
            default: () => {
                return 0;
            }
        },
        isUserSearching: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        objectiveGroupList: {
            type: Array,
            default: () => {
                return [];
            }
        },
        readOnlyView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        hideOkr: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
        isMockingMode: {
            type: Boolean,
            default: () =>{ return false }
        },
		isFeatureDetailView: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
        isArt: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        releaseTrainId: {
            type: String,
            default: () => {
                return "";
            }
        },
        isGlobalObjectiveView: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
		isPrioritizedObjListingView: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
		isItemsLoaded: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
        krProgressCriteriaFieldId: {
            type: String,
            default: () => {
                return '';
            }
		},
	    useOldApiForOldStateData: {
		    type: Boolean,
		    default: () => {
			    return false;
		    }
	    },
        objectiveColumnSettings: {
            type: Array,
            default: () => {
                return [];
            }
        },
        timePeriodFilter: {
            type: Object,
            default: () => {
                return {};
            }
        },
        krParentTimePeriodFieldId: {
			type: String,
			default: () => {
				return ''
			}
		},
        krParentStartDateFieldId: {
            type: String,
            default: () => {
                return ''
            }
        },
        krParentEndDateFieldId: {
            type: String,
            default: () => {
                return ''
            }
        },
        isObjectiveMainView:{
            type: Boolean,
            default: () => {
                return false;
            }
        },
        krParentStartDateFieldId: {
            type: String,
            default: () => {
                return ''
            }
        },
        krParentEndDateFieldId: {
            type: String,
            default: () => {
                return ''
            }
        },
        isSOSPage: {
            type: Boolean,
            default: false,
        },
        customView:{
            type: Object,
            default: () => { }
        },
        isBatchView: {
            type: Boolean,
            default: () => {
                return false;
            }
        }
    },
    template: /*html*/`
		<div :style="[getGroupColor ? {'border-color': getGroupColor} : {}]" :class="[isPrioritizedObjListingView ? 'brdr-0' : '', 'table', 'content', 'oTable', 'nwobj', getObjectiveGroupExpandable ? 'active' : '', !objectiveMenuOptions['isBVAchievementEnabled'] ? 'rmv-obj-arch' : '', !objectiveMenuOptions['isOkrBVAchievementEnabled'] ? 'rmv-okr-arch' : '']" :ref="'objective_group_ref_of_'+objectiveGroup.id">
		    <objective-group-progress v-if="showObjectiveGroupProgress"  
                :objectiveGroupId="objectiveGroup.id" 
                :isArt="isArt" 
                :isGlobalObjectiveView="isGlobalObjectiveView" 
                :completionBy="completionBy.code" 
                :radioTypeSelection="'objectiveGroup'" 
                @closeGroupProgress="closeGroupProgress" 
                :isOkrEnabled="objectiveMenuOptions['isOkrEnabled']" 
                :objectiveList="objectiveList" 
                :board="board" 
                :objectiveGroup="objectiveGroup" 
                :objectiveGroupList="objectiveGroupList" 
                :isOKRView="true" 
                :customView="customView" 
                :releaseTrainTitle="getCollectionTitle"/>
		    </objective-group-progress>
			<div :class="[(useOldApiForOldStateData && isItemOfAnotherState)? 'brd-itm' : '', isPrioritizedObjListingView ? 'casOkr' : '']" class="rec hd oTitle list DFCB"  v-if="!isEditFormShow" @click="expandOrCollapseGroup" :data-id="objectiveGroup.id" :style="[getGroupColor ? {'background-color': getGroupColor+'30'} : {}]">
				<div class="lft DFA">
					<em v-if="!readOnlyView" class="ti-move hmove ui-sortable-handle" title="Move" @click.stop></em>
					<em class="ti-angle-right acrd-arr" :style="[getGroupColor ? {'color': getGroupColor} : {}]"></em>
                    <a class="DFA-a txtuln fs-18 key" :href="groupUrl" target="_blank" :style="[getGroupColor ? {'color': getGroupColor} : {}]">{{getGroupKey}}</a>
					<span v-if="!isTitleEdit" class="DFA-a" v-html="getObjectiveTitleHTML(objectiveGroup)" @click.stop="onEditHandle"></span>
					<span v-if="isTitleEdit" class="edtout DFA">
						<input type="text" class="activeText rnd4 h-auto" v-model="customObjectiveTitalModel" @click.stop/>
                        <div class="r-icons p-rel edt DFA ml-10">
                            <a href="javascript:void(0);" class="ti-check ico DAJ dsv" @click="saveField('title')"></a>
                            <a href="javascript:void(0);" class="ti-close ico DAJ dcl" click="cancelEdit"></a>
                        </div>
                    </span>		
                    <div v-if="getCollection && getCollection.type && !isArt" class="ml-10 group-coll-icon" @click.stop="onKeyClick"><i :style="{'color': getGroupColor}" class="material-symbols-outlined mr-10 icol">{{getCollection.type.icon}}</i></div>
					<span class="objectoltp DIB tooltip ml-10 tp" v-if="useOldApiForOldStateData && isItemOfAnotherState">
						<span class="infotxt nw c-point"> </span>
						<span class="hovtooltipB">Not created in this state</span>
					</span>
					<span v-if="!readOnlyView && teamBaseItemLink.teamId==0 && !objectiveGroup.isDefaultGroup && $options.permissions && $options.permissions.EDIT_OBJECTIVE_GROUP && !isCollectionGroup" title="Edit Title" class="ti-pencil edit-o-title ml-5 c-point" @click.stop="onEditTitle"  :style="{'color': getGroupColor}" ></span>
				</div>
				<div class="rht DFA">
					<a v-if="!isMockingMode && objectiveMenuOptions['isUnCommittedEnabled'] && !readOnlyView && $options.permissions && $options.permissions.EDIT_OBJECTIVE" href="javascript:void(0);" class="nwabtn button-w txgrn minw" @click.stop="showUncommittedObjectiveCreationInput">
					<em class="ti-plus addf"></em>
					Uncommitted Objective
					</a>
					<div v-if="!(!isGlobalObjectiveView && isPrioritizedObjListingView)" class="c-point prgbtn" @click.stop="openObjectiveGroupPopup" title="Progress"></div>
					<div class="rhtinsd DFA ml-10">
						<div v-if="!isFeatureDetailView && !isPrioritizedObjListingView && objectiveMenuOptions.isProgressEnabled" class="progrs-bar fx DFA">
							<template v-if="isItemsLoaded">
								<label>Completion</label>
							</template>							
							<div class="bar">
								<template v-if="getCompletionError">
									<span class="bn" :style="{width: '0%'}"></span>								
									<div class="alert ti-alert c-point p-abs orgtxt tooltip" @click.stop="toggleWeightSummaryView">
										<span class="hovtooltipB">One of the Key Results is wrongly linked to Objectives and causing a circular looping, to fix the problem, remove the linking of the Objective marked with the Red warning icon</span>
									</div>
								</template>
								<template  v-else>
									<span class="bn" :style="{width: objectiveGroupCompletion()+'%'}"></span>
									<div v-if="isItemsLoaded" class="val ml-5 ftsb c-point" @click.stop="toggleWeightSummaryView" onmouseover="showRealValue(this);" :data-real-value="objectiveGroupCompletion()">{{objectiveGroupCompletion()}}%</div>
									<div v-if="!isItemsLoaded || (isMockingMode && !isGlobalCalculationDone)" class="singleBarAnimation">
							            <p class="loading-text">Calculating<span class="loading-dots">...</span></p>
								        <div class="loading-line"></div>
							        </div>									
								</template>
							</div>
						</div>
						
						<div class="progrs-bar fx DFA" v-if="objectiveMenuOptions['isBVAchievementEnabled'] && !isMockingMode">
							<label>BV Achievement</label>
							<div class="bar"><span class="bn" :style="{width: bvAchievement+'%'}"></span></div>
							<div class="val ml-5 ftsb" onmouseover="showRealValue(this);" :data-real-value="bvAchievement">{{bvAchievement}}%</div>
						</div>
						<template v-if="isCustomObjectiveGroup && isStatusEnabled">
							<div v-if="objectiveGroup.status" class="spr-vrt ml-10"></div>
							<div v-if="objectiveGroup.status && !isStatusEdit" @click.stop="onEditStatus" class="status nw DAJ"><span class="sts" :class="[objectiveGroup.status.category === 'ToDo' ? 'a' : (objectiveGroup.status.category === 'InProgress' ? 'b' : (objectiveGroup.status.category === 'Done' ? 'c' : 'd'))]">{{objectiveGroup.status.title}}</span></div>
							<div v-if="objectiveGroup.status && isStatusEdit" class="selectcont sml rhtsd">
								<vz-select :multiple="false" label="title" track-by="id" value-type="object" :options="getObjectiveStatuses"
							     	v-model="selectedObjectiveStatusModel" @select="saveField('status')"></vz-select>
							</div>
						</template>
						<div class="prevent r-icons obj DAJ top" v-if="!readOnlyView && ($options.permissions.EDIT_OBJECTIVE_GROUP || $options.permissions.DELETE_OBJECTIVE_GROUP)">
							<em class="ti-more icoa DAJ" @click.stop="onClickShowMenuPopup"></em>
							<vuepopup v-if="showMenuOverlay" @close="showMenuOverlay=false">
								<div class="drop_box nwmu artp sml" style="display:block">
									<ul>
										<li v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE_GROUP && objectiveMenuOptions['isOkrEnabled']"><a href="javascript:void(0);" @click.stop="toggleWeightsTab">Assign Weights to Objectives</a></li>
										<li v-if="$options.permissions && $options.permissions.DELETE_OBJECTIVE_GROUP"><a href="javascript:void(0);" @click.stop="deleteObjectiveGroup(objectiveGroup.id)">Delete Objective Group</a></li>
									</ul>
								</div>
							</vuepopup>
						</div>
					</div>
				</div>
				<!-- rht end -->
			</div>
			<div class="rec hd oTitle list edit DFA" v-else="isEditFormShow">
				<input type="text" class="csin activeText" :class="[!isEditObjectiveInputValid ? 'required': '']" v-model="customObjectiveTitalModel" ref="editCustomObjectiveTitle" @keyup.enter="updateCustomGroupObjective">
				<small class="mstxt red-msg" v-show="!isEditObjectiveInputValid">Title is required</small>
				<div class="r-icons edt cs DAJ">
					<a href="javascript:void(0);" class="ti-check ico DAJ" @click="updateCustomGroupObjective"></a>
					<a href="javascript:void(0);" class="ti-close ico DAJ" @click="hideEditForm"></a>
				</div>
			</div>
			<div class="oDetail prow">
				<div v-if="!isMockingMode" class="rec hd inn normal objout">
					<div class="rc c2 DFA">
						<em class="objectives2 ico DIB mr-10"></em>Objectives<a v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE && !readOnlyView" href="javascript:void(0);" class="ti-plus addobj button-w txgrn brgrn DAJ ml-10" @click="showCommittedObjectiveForm"></a>
					</div>
					<div title="Business Value Planned" class="rc c1 a DFA" v-if="objectiveMenuOptions['isBVAchievementEnabled']">BV Plan</div>
					<div title="Business Value Actual"  class="rc c1 b DFA" v-if="objectiveMenuOptions['isBVAchievementEnabled']">BV Actual</div>
				</div>
				<div v-else-if="isMockingMode" class="rec hd inn normal objout DFCB">
					<div class="lft DFA">
						<div class="rc c2 DFA"><em class="objectives2 ico DIB mr-10"></em>Objectives <a v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE && !readOnlyView" href="javascript:void(0);" class="ti-plus addobj button-w txgrn brgrn DAJ ml-10" @click="showCommittedObjectiveForm"></a></div>
					</div>
					<div class="rht DFA">
                        <div v-for="(column, index) in objectiveColumnsList" class="octe a">
                            <div v-if="column === 'timePeriod'" class="rc c1 DAJ dp" :class="'ob-' + (index + 1)"><em class="ti-time mr-5 mt-2"></em> Time Period</div>
                            <div v-if="column === 'association' && !isPrioritizedObjListingView" class="rc c1 DAJ dp" :class="'ob-' + (index + 1)"><em class="ico mr-5 icdepm"></em> Associations</div>
                            <div v-if="column === 'responsible'" class="rc c1 dp rsp DAJ" :class="'ob-' + (index + 1)"><em class="ico mr-5 icownr"></em> Responsible</div>
                            <div v-if="column === 'progress' && !isPrioritizedObjListingView" class="rc c1 DAJ fx" :class="'ob-' + (index + 1)"><em class="ico mr-5 icprog"></em> Progress (%)</div>
                            <div v-if="column === 'status'" class="rc c1 DAJ fx" :class="'ob-' + (index + 1)"> Status</div>
                        </div>
					</div>
				</div>
				<div v-sortable="$options._valueSortableOptions" :data-type="'committed'" :data-id="objectiveGroup.id" class="sm-objective oboutst comm prow">
					<objective-row-component 
						v-for="objective in committedList"
						:show-un-linked-items="showUnLinkedItems"							
						:ref="'row_'+objective.id"
						:group-id="objectiveGroup.id"
						:key="objective.id"
						:board="board"
						:objective="objective"
						:okr-list="objective.baseItemList"
						:is-user-searching="isUserSearching"
						:readOnlyView="readOnlyView"
						:hide-okr="hideOkr"
						:is-feature-detail-view="isFeatureDetailView"
						:is-global-objective-view="isGlobalObjectiveView"
						:objective-team="objectiveTeam"
						:is-mocking-mode = "isMockingMode"
						:is-prioritized-obj-listing-view= "isPrioritizedObjListingView"
						:kr-progress-criteria-field-id = "krProgressCriteriaFieldId"
						:is-art="isArt"
						:release-train-id="releaseTrainId"
						:departments-map="departmentsMap"
						:sessions-map="sessionsMap"					
						:batches-map="batchesMap"
						:is-items-loaded="isItemsLoaded"
						:use-old-api-for-old-state-data="useOldApiForOldStateData"
                        :objective-column-settings="objectiveColumnsList"
                        :time-period-filter="timePeriodFilter"
                        :kr-parent-time-period-field-id="krParentTimePeriodFieldId"
                        :kr-parent-start-date-field-id="krParentStartDateFieldId"
                        :kr-parent-end-date-field-id="krParentEndDateFieldId"
                        :isObjectiveMainView="isObjectiveMainView"
                        :isGlobalObjectiveView="isGlobalObjectiveView"
                        :isSOSPage="isSOSPage"
                        :customView="customView"
                        :is-batch-view="isBatchView"
						@updateSilently="updateSilently"
						@editObjective="saveEditObjectiveValue"
						@deleteObjective="deleteObjective"
						@updateObjectiveGroupList="handleChildRowCall"
						@completionCriteria="objectiveCompletionCriteria"
						@objectiveCompletion="calculateObjCompletion"
						@open-linked-obj="openLinkedObjContainer" />
				</div>
				<div class="rec add" v-if="showAddCommittedObjectiveInput">
					<div class="rc c2">
						<textarea v-model="newObjectiveDataCommitted.title" :class="[!isAddCommittedObjectiveInputValid ? 'required': '']" placeholder="Describe Objective..." maxlength="750" ref="newObjectiveTitleRef" @keyup.enter="objectiveMenuOptions['isBVAchievementEnabled'] && !isMockingMode ? moveNext('newObjectiveBvPlan') : saveCommittedObjective()" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" style="resize: vertical;" />
						<!--<input type="text" v-model="newObjectiveDataCommitted.title" :class="[!isAddCommittedObjectiveInputValid ? 'required': '']" placeholder="Describe Objective..." maxlength="255" ref="newObjectiveTitleRef" @keyup.enter="objectiveMenuOptions['isBVAchievementEnabled'] && !isMockingMode ? moveNext('newObjectiveBvPlan') : saveCommittedObjective()" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)">-->
						<small class="mstxt red-msg" v-show="!isAddCommittedObjectiveInputValid">Title is required</small>
					</div>
					<template v-if="objectiveMenuOptions['isBVAchievementEnabled'] && !isMockingMode">
						<div class="rc c1 a"><input type="number" v-model="newObjectiveDataCommitted.bvPlan" maxlength="999" @change="formatBVPlanValue('committed')"  ref="newObjectiveBvPlan" @keyup.enter="moveNext('newObjectiveBvActual')" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)"></div>
						<div class="rc c1 b"><input type="number" v-model="newObjectiveDataCommitted.bvActual" maxlength="999" @change="formatBVActualValue('committed')" ref="newObjectiveBvActual" @keyup.enter="saveCommittedObjective" @blur="onBlurObjectiveInputBV" @focus="toggleGroupDragging(true)"></div>
					</template>
					<div class="tmperid" v-if="isMockingMode">
                        <div v-if="isMockingMode" class="slctdn DFA p-rel c-point rnd4 w-230" @click.stop="timePeriod.showPopup=!timePeriod.showPopup" :class="[!isAddCommittedObjectiveTimePeriodValid ? 'required': '']">
                            <div class="DAJ">{{!_.isEmpty(timePeriod.period )? (timePeriod.period.title === 'Yearly' ? 'Year' : timePeriod.period.title) + " - " + timePeriod.period.selectedYear : "Select Time Period"}}</div>
                            <time-period-popup
                                v-if="timePeriod.showPopup"
                                :item-time-period="timePeriod.period"
                                @timePeriodSelected="onSelectTimePeriod"
                            ></time-period-popup>
                        </div>
                    </div>
					<div class="r-icons edt DAJ">
						<a href="javascript:void(0);" class="ti-check ico DAJ" @click="saveCommittedObjective"></a>
						<a href="javascript:void(0);" class="ti-close ico DAJ" @click="closeCommittedObjectiveForm"></a> 
					</div>
				</div>
				<div class="rec hd inn stretch" v-if="unCommittedList.length == 0 && showAddUncommittedObjectiveInput">
					<div class="rc c2 DFA">
						<em class="objectives1 ico DIB mr-10"></em>
						<b class="tooltip">
							Uncommitted Objectives
							<div class="hovtooltipB fs-12">Uncommitted objectives formerly known as stretch objectives</div>
						</b>
					</div>
				</div>
				<div class="rec hd inn stretch" v-if="unCommittedList.length > 0 && objectiveMenuOptions['isUnCommittedEnabled']">
					<div class="rc c2 DFA">
						<em class="objectives1 ico DIB mr-10"></em>
						<b class="tooltip">
							Uncommitted Objectives
							<div class="hovtooltipB fs-12">Uncommitted objectives formerly known as stretch objectives</div>
						</b>
						<a v-if="!readOnlyView && $options.permissions && $options.permissions.EDIT_OBJECTIVE" href="javascript:void(0);" class="ti-plus addbtn button-w" @click="showAddUncommittedObjectiveInput=true"></a>
					</div>
				</div>
				<div v-sortable="$options._valueSortableOptions" :data-type="'uncommitted'" :data-id="objectiveGroup.id" class="st-objective oboutst prow ui-sortable obj-dragg" v-if="objectiveMenuOptions['isUnCommittedEnabled'] && unCommittedList.length>0">
					<objective-row-component
						v-for="objective in unCommittedList"
						:ref="'row_' + objective.id"    
						:show-un-linked-items="showUnLinkedItems"                      
						:group-id="objectiveGroup.id"
						:key="objective.id"
						:board="board"
						:objective="objective"
						:okr-list="objective.baseItemList"
						:is-user-searching="isUserSearching"
						:readOnlyView="readOnlyView"
						:hide-okr="hideOkr"
						:is-feature-detail-view="isFeatureDetailView"
						:is-global-objective-view="isGlobalObjectiveView"
						:objective-team="objectiveTeam"
						:is-mocking-mode = "isMockingMode"
						:is-prioritized-obj-listing-view= "isPrioritizedObjListingView"
						:kr-progress-criteria-field-id = "krProgressCriteriaFieldId"
						:is-art="isArt"
                        :kr-parent-time-period-field-id="krParentTimePeriodFieldId"
                        :kr-parent-start-date-field-id="krParentStartDateFieldId"
                        :kr-parent-end-date-field-id="krParentEndDateFieldId"
						:release-train-id="releaseTrainId"
						:departments-map="departmentsMap"
						:batches-map="batchesMap"
						:is-items-loaded="isItemsLoaded"
						:use-old-api-for-old-state-data="useOldApiForOldStateData"
                        :objective-column-settings="objectiveColumnsList"
                        :isObjectiveMainView="isObjectiveMainView"
                        :isGlobalObjectiveView="isGlobalObjectiveView"
                        :isSOSPage="isSOSPage"
                        :customView="customView"
                        :is-batch-view="isBatchView"
						@updateSilently="updateSilently"
						@editObjective="saveEditObjectiveValue"
						@deleteObjective="deleteObjective"
						@updateItems="updateLinkedItemsList"
						@updateObjectiveGroupList="handleChildRowCall"
						@completionCriteria="objectiveCompletionCriteria"
						@objectiveCompletion="calculateObjCompletion"
						@open-linked-obj="openLinkedObjContainer" />
				</div>
				<div class="rec add" v-if="showAddUncommittedObjectiveInput">
					<div class="rc c2">
						<textarea v-model="newObjectiveDataUncommitted.title" :class="[!isAddUnCommittedObjectiveInputValid ? 'required' : '']" placeholder="Describe Uncommitted Objective..." maxlength="750" ref="unCommittedObjectiveTitle" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" @keyup.enter="objectiveMenuOptions['isBVAchievementEnabled'] ? moveNext('unCommittedObjectiveBvPlan') : saveUncommittedObjective()"/>
						<!--<input type="text" v-model="newObjectiveDataUncommitted.title" :class="[!isAddUnCommittedObjectiveInputValid ? 'required' : '']" placeholder="Describe Uncommitted Objective..." maxlength="255" ref="unCommittedObjectiveTitle" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" @keyup.enter="objectiveMenuOptions['isBVAchievementEnabled'] ? moveNext('unCommittedObjectiveBvPlan') : saveUncommittedObjective()">-->
						<small class="mstxt red-msg" v-show="!isAddUnCommittedObjectiveInputValid">Title is required</small>
					</div>
					<template v-if="objectiveMenuOptions['isBVAchievementEnabled'] && !isMockingMode">
						<div class="rc c1 a"><input type="number" maxlength="999" v-model="newObjectiveDataUncommitted.bvPlan"  ref="unCommittedObjectiveBvPlan" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" @change="formatBVPlanValue('uncommitted')" @keyup.enter="moveNext('unCommittedObjectiveBvActual')"></div>
						<div class="rc c1 b"><input type="number" maxlength="999" v-model="newObjectiveDataUncommitted.bvActual" ref="unCommittedObjectiveBvActual" @focus="toggleGroupDragging(true)" @blur="toggleGroupDragging(false)" @change="formatBVActualValue('uncommitted')" @keyup.enter="saveUncommittedObjective"></div>
					</template>
					<div class="r-icons edt DAJ">
						<a href="javascript:void(0);" class="ti-check ico DAJ" @click="saveUncommittedObjective"></a>
						<a href="javascript:void(0);" class="ti-close ico DAJ" @click="closeUncommittedObjectiveForm"></a> 
					</div>
				</div>
				<div class="rec total" v-if="objectiveMenuOptions['isBVAchievementEnabled'] && !isPrioritizedObjListingView">
					<div class="rc c2"><b>Total</b></div>
					<div class="rc c1 a" title="Business Value Planned">{{bvPlanSum}}</div>
					<div class="rc c1 b" title="Business Value Actual">{{bvActualSum}}</div>
				</div>
			</div>
			<vuepopup v-if="showWeightageSummaryView" @close="showWeightageSummaryView=false;">
				<div class="overlay" style="display: block;"></div>
				<div class="add-pop ui-dialog calcltn" style="display: block;">
					<div class="head">Weights For Calculation <a @click.stop="toggleWeightSummaryView" href="javascript:void(0);" title="Close" class="rmv-ico ti-close"></a></div>
					<div class="cntr prow">
					    <template v-if="!_.isEmpty(objectiveListWithWeights)">
                            <div class="rec" v-for="obj in objectiveListWithWeights">
                                <span class="FL mr-10 ftsb wht-nwrp">{{objectiveWeightPercentage(obj)}}%</span>
                                <a href="javascript:void(0);" class="ky FL mr-5 wht-nwrp">{{obj.key}}</a>
                                <span class="val" v-html="obj.title"></span>
                                <div class="achivt prog_2 prg">
                                    <template v-if="isMockingMode">
                                    <div><span :style="{width: getOkrCompletionMap[obj.id]+'%'}"></span></div>
                                    <strong data-real-value="0">{{getOkrCompletionMap[obj.id]}}%</strong>            
                                    </template>
                                    <template v-else>
                                        <div><span :style="{width: obj.completion+'%'}"></span></div>
                                        <strong data-real-value="0">{{obj.completion}}%</strong>
                                    </template>
                                </div>
                            </div>
						</template>
						<template v-else>
                            <div class="nofound">Current group doesn't have any objectives.</div>
                        </template>
					</div>
				</div>
			</vuepopup>
			<vuepopup v-if="showWeightsTab" @close="closeObjWeightsPopup">
				<div class="overlay" style="display: block;"></div>
				<div class="add-pop ui-dialog weights" style="display: block;">
					<div class="head">Assign Weights To Objectives <a href="javascript:void(0);" @click.stop="closeObjWeightsPopup" class="rmv-ico ti-close" title="Close"></a></div>
					<div class="cntr prow">
						<div class="rec" v-for="(obj,index) in objectiveListWithWeights">
							<div class="lft DFA FG custom-checkbox">
								<input @change="handleCheckBoxAndWeightChange(obj, 'checkbox')" :id="'objWeights'+index" type="checkbox" v-model="obj.selectedForWeights" />
								<label :for="'objWeights'+index">
								<a href="javascript:void(0);" class="ky mr-5">{{obj.key}}</a>
								<span class="word-breakAll">{{obj.title}}</span>
								</label>
							</div>
							<div class="rht DFA">
								<span class="val mr-20 ftsb light DIB">{{obj.type.split("-")[1]}}</span>
								<span class="val mr-20 ftsb light DIB">{{objectiveWeightPercentage(obj)}}%</span>
								<div class="selectcont wht">
									<select :class="{'disabled':!obj.selectedForWeights}" :disabled="!obj.selectedForWeights" v-model="obj.assignedWeight" @change="handleCheckBoxAndWeightChange(obj)">
										<option v-for="weight in objectiveWeights" :value="weight.value"> {{ weight.title }} </option>
									</select>
								</div>
							</div>
						</div>
					</div>
					<div class="rec btn">
						<button :disabled="!enableObjWeightsButton" @click.stop="saveObjectiveWeights" class="FR" :class="{'disabled': (!enableObjWeightsButton)}">Save</button>
						<a href="javascript:void(0);" @click.stop="closeObjWeightsPopup" class="FR cncl url">Cancel</a>
					</div>
				</div>
			</vuepopup>
			<dynamic-popup-container
				v-if="itemTemplate.showEditPopUp"
				:is-mocking-mode = "isMockingMode"
				@close = "onCLoseEditPopUp"
				@save="updateCustomGroupObjective"
				@delete="deleteCustomGroup"
				:template-to-render="itemTemplate.templateToRenderer"
				:template-statuses = "itemTemplate.statuses"
				:item-type="itemTemplate.itemType"
				:fields-value="itemTemplate.model"
				:template = "itemTemplate"
				:show-attachments="false"
				:show-watchers="true"
				:show-history="false"
				:show-conversations="true"
				:show-notify-watchers="false"
				:show-external-entities="true"
				:show-sub-phase-linking="false"
				:teams-linking-title="'Link Team'"
				:show-sprint-linking="false"
				:entity-type="'BaseItem'"
				:entity-id="itemTemplate.id"
				:is-inline-editing-enabled="false"
				:show-linked-items="false"
				:show-tagging-info="false"
				:delete-permission="$options.permissions.DELETE_OBJECTIVE_GROUP"
				isSOSPage="isSOSPage"
				:is-art="isArt" />
		</div>
	`,

    data() {
        return {
            objectiveWeights: [
                { title	: "0.5x", 	value	: 0.5 },
                { title	: "1x", 	value	: 1 },
                { title	: "2x", 	value	: 2 },
                { title	: "3x", 	value	: 3 },
            ],
            objectiveListWithWeights				: [],
            objectives								: [],
            unCommittedList							: [],
            committedList							: [],

            showAddCommittedObjectiveInput			: false,
            showAddUncommittedObjectiveInput		: false,
            isEditFormShow							: false,
            isEditObjectiveInputValid				: true,
            isAddCommittedObjectiveInputValid		: true,
            isAddUnCommittedObjectiveInputValid		: true,
            showWeightsTab							: false,
            showMenuOverlay							: false,
            enableObjWeightsButton					: false,
            showWeightageSummaryView 				: false,
            isSaveCommittedObjectiveCalled			: false,
			isItemOfAnotherState					: false,
			isCustomObjectiveGroup                  : false,
			isGlobalCalculationDone					: false,			

            newObjectiveDataCommitted: {
                title		: "",
                bvPlan		: 0,
                bvActual	: 0
            },
            newObjectiveDataUncommitted: {
                title		: "",
                bvPlan		: 0,
                bvActual	: 0
            },
			itemTemplate: {
                showEditPopUp			: false,
                showMileStonePopup		: false,
                templateToRenderer		: {},
                statuses				: [],
                itemType				: {},
                creationAndUpdateData 	: {}
            },

            newObjective							: {},
            editObjectiveData						: {},
            _valueSortableOptions					: {},
			objectiveTeam							: {},
            objectiveCompletionMap					: {},
			teamBaseItemLink						: {},
            completion								: 0,
			bvAchievement							: 0,
			bvActualSum								: 0,
			bvPlanSum								: 0,
			
            customObjectiveTitalModel				: "",
            showObjectiveGroupProgress: false,
            okrSelection: 'objectiveGroup',
            objectiveColumnsList                    : [],
            linkedCustomView                        : {},
            timePeriod: {
                showPopup: false,
                period: {},
                startDate: "",
                endDate: "",
            },
            isAddCommittedObjectiveTimePeriodValid  : true,
			isTitleEdit : false,
			isStatusEdit : false,
			selectedObjectiveStatusModel : {},
		
        }
    },

    watch: {

        "objectiveGroup.baseItemList": function (_newList, _oldList) {
            this.populateObjectivesList(_newList);
            this.populateObjectiveListWithWeights();
			this.bvAchievementCalculation();
        },

        showAddUncommittedObjectiveInput: function (_new, _old) {
            if (_new) {
                this.moveNext('unCommittedObjectiveTitle');
            }
        },

		completionBy: function(newVal, oldVal){
            this.objectiveGroupCompletion();
		},

        "objectiveMenuOptions.isUnCommittedEnabled": function(_new, _old){
            this.bvAchievementCalculation();
            this.populateObjectiveListWithWeights();
        },
		getOkrCompletionMap: {
			handler: function(_new, _old) {
				if(this.getOkrCompletionMap && this.getOkrCompletionMap[this.objectiveGroup.id] != undefined) {
					this.isGlobalCalculationDone = true;
				}
				this.$forceUpdate();
			},
			deep: true,
			immediate: true,
		},
    },
	computed: {
		completionBy: function() {
			return kendisStore.state.objectiveCompletionCriteria;
		},
		showUnLinkedItems: function() {
			return kendisStore.state.showUnLinkedItems;
		},
        objectiveMenuOptions: function (){
            return kendisStore.getters.getObjectiveMenuOptions();
        },
        isStatusEnabled: function () {
			if (this.objectiveMenuOptions) {
				return this.objectiveMenuOptions.isStatusEnabled;
			}
			return true;
		},
        objOkrPopupContainerMap: function (){
            return kendisStore.getters.getObjOkrPopupContainerMap();
        },
        objectiveWeightPercentage: function (){
            return function (obj){
                if (obj.assignedWeight > 0){
                    let sumOfAssignedWeights = 0;
                    _.each(this.objectiveListWithWeights, obj => {
                        if (obj.selectedForWeights && obj.assignedWeight){
                            sumOfAssignedWeights += obj.assignedWeight;
                        }
                    });
                    if (sumOfAssignedWeights > 0){
                        let valueOfX = 100/sumOfAssignedWeights;
                        return _.round(obj.assignedWeight * valueOfX);
                    }
                }
                return 0;
            }
        },
        objectiveGroupCompletion: function (){
            return function (){
                let _this = this;
				if(!_this.isMockingMode) {
	                let groupCompletion = 0;
	                if (_this.objectiveMenuOptions['isOkrEnabled'] && _this.completionBy.code === "OBJ_KR_WEIGHTS_FORMULA") {
	                    let valueOfX = _this.calculateValueOfSingleX();
	                    _.each(_this.objectiveListWithWeights, obj => {
	                        // let temp = _.filter(_this.objectiveListWithWeights, {id: obj.id});
	                        if (obj.assignedWeight > 0) {
	                            // temp = temp[0];f
		                        let completionPercentage = obj.completion != undefined ? obj.completion : 0;
	                            groupCompletion += completionPercentage * ((obj.assignedWeight * valueOfX) / 100);
	                        }
	                    });
	                }else{
	                     let excludedItemsData = kendisStore.getters.getExcludeItemsData();
	                     groupCompletion = _this.calculateGroupCompletionWithoutWeights(excludedItemsData);
	                }
	                return groupCompletion > 0 ? groupCompletion.toFixed(2) : groupCompletion;
				} else {
					return (_this.getOkrCompletionMap && _this.getOkrCompletionMap[_this.objectiveGroup.id]) ? _this.getOkrCompletionMap[_this.objectiveGroup.id] : 0.0;
				}
            }
        },
        getObjectiveGroupExpandable: function () {
            let _this = this;
            return _this.objectiveGroup.expand;
        },
		getOkrCompletionMap: function() {
			return kendisStore.state.okrCompletionMap;
		},
		getCompletionError: function() {
			if(this.getOkrCompletionMap && this.getOkrCompletionMap["error"+this.objectiveGroup.id]) {
				return true;
			}
			return false;
		},
        isCollectionGroup() {
            if (this.objectiveGroup.baseItemLinks.some(link => link.type === "custom-view")) {
                return this.objectiveGroup.baseItemLinks.some(link => link.linkType === 'art_link_objective' && link.sessionId !== "-1");
            }
            return false;
        },
        getGroupCollection() {
            if (_.isEmpty(this.objectiveGroup.baseItemLinks)) {
                return {};
            }
            return this.objectiveGroup.baseItemLinks.find(link => link.linkType === 'art_link_objective' && link.sessionId !== "-1");
        },
        getCollection() {
            const collectionLink = this.getGroupCollection;
            if (collectionLink) {
                const collectionId = collectionLink.sessionId;

                return kendisStore.getters.getArtCollections().find(collection => collection.id === collectionId);
            }
            return {};
        },
        getGroupKey() {
            if (this.isArt) {
                return this.linkedCustomView ? this.linkedCustomView.key : '';
            }
            return this.getCollection ? this.getCollection.key : '';
        },
        getGroupColor() {
            if (this.isArt) {
                return this.linkedCustomView && !_.isEmpty(this.linkedCustomView) ? this.linkedCustomView.color : this.objectiveGroup.headerColor;
            }
            return this.objectiveGroup.headerColor;
        },
        groupUrl() {
            if (this.isArt) {
                return this.linkedCustomView ? `/objectives#/${this.linkedCustomView.key}` : '';
            }
            return !_.isEmpty(this.getCollection) ? `/org#/${this.getCollection.type.prefix}/${this.getCollection.key}/objectives` : '';
        },
        getCollectionTitle(){
            if(this.isArt){
                return this.getCollection ? this.getCollection.title : '';
            }
        },
		getObjectiveStatuses () {
			if(kendisStore && kendisStore.getters.getObjectiveGroupTemplate()){
				return kendisStore.getters.getObjectiveGroupTemplate().statuses;
			}
		}
	},
    created() {
		
        this.$options._valueSortableOptions = {
			disabled: this.readOnlyView? true: false,	
            draggable: '.obj-value',
            handle: ".value-sortable-handle",
            ghostClass: 'ui-sortable-placeholder1',
            chosenClass: "sortable-chosen",
            dragClass: "sortable-drag",
            group: {name: 'objective_group', pull: true, put: true, revertClone: true},
            forceFallback: false,
            onEnd: this.onChangeSortable
        };
        this.$options.permissions = kendisStore.getters.getObjectiveAndOkrPermissions();
        this.populateObjectiveListWithWeights();
        EventBus.$on('fetchObjectivePopupData', (objectiveId) =>{
            for(objective of this.committedList){
                if(objectiveId === objective.id){
                    let rowData = {};
                    rowData.showUnLinkedItems = this.showUnLinkedItems;
                    rowData.objective = objective;
                    rowData.ref =  'row_' + objectiveId;
                    rowData.groupId = this.objectiveGroup.id;
                    rowData.key = objectiveId;
                    rowData.board = this.board;
                    rowData.okrList = objective.baseItemList;
                    rowData.isUserSearching = this.isUserSearching;
                    rowData.readOnlyView = this.readOnlyView;
                    rowData.hideOkr = this.hideOkr;
                    rowData.isFeatureDetailView = this.isFeatureDetailView;
                    rowData.isGlobalObjectiveView = this.isGlobalObjectiveView;
                    rowData.objectiveTeam = this.objectiveTeam;
                    rowData.isMockingMode = this.isMockingMode;
                    rowData.isPrioritizedObjListingView = this.isPrioritizedObjListingView;
                    rowData.krProgressCriteriaFieldId = this.krProgressCriteriaFieldId;
                    rowData.isMockingMode = this.isMockingMode;
                    rowData.isArt = this.isArt;
                    rowData.releaseTrainId = this.releaseTrainId;
                    rowData.departmentsMap = this.departmentsMap;
                    rowData.sessionsMap = this.sessionsMap;
                    rowData.batchesMap = this.batchesMap;
                    rowData.isItemsLoaded = this.isItemsLoaded;
                    rowData.useOldApiForOldStateData = this.useOldApiForOldStateData;

                    EventBus.$emit('rowDataObject',rowData,objectiveId);
                }
            }

            for(objective of this.unCommittedList){
                if(objectiveId === objective.id){
                    let rowData = {};
                    rowData.showUnLinkedItems = this.showUnLinkedItems;
                    rowData.objective = objective;
                    rowData.ref =  'row_' + objectiveId;
                    rowData.groupId = this.objectiveGroup.id;
                    rowData.key = objectiveId;
                    rowData.board = this.board;
                    rowData.okrList = objective.baseItemList;
                    rowData.isUserSearching = this.isUserSearching;
                    rowData.readOnlyView = this.readOnlyView;
                    rowData.hideOkr = this.hideOkr;
                    rowData.isFeatureDetailView = this.isFeatureDetailView;
                    rowData.isGlobalObjectiveView = this.isGlobalObjectiveView;
                    rowData.objectiveTeam = this.objectiveTeam;
                    rowData.isMockingMode = this.isMockingMode;
                    rowData.isPrioritizedObjListingView = this.isPrioritizedObjListingView;
                    rowData.krProgressCriteriaFieldId = this.krProgressCriteriaFieldId;
                    rowData.isMockingMode = this.isMockingMode;
                    rowData.isArt = this.isArt;
                    rowData.releaseTrainId = this.releaseTrainId;
                    rowData.departmentsMap = this.departmentsMap;
                    rowData.sessionsMap = this.sessionsMap;
                    rowData.batchesMap = this.batchesMap;
                    rowData.isItemsLoaded = this.isItemsLoaded;
                    rowData.useOldApiForOldStateData = this.useOldApiForOldStateData;

                    EventBus.$emit('rowDataObject',rowData,objectiveId);
                }
            }

        });
    },

    mounted() {
		let _this = this;
        _this.populateObjectivesList(_this.objectiveGroup.baseItemList);
		_this.teamBaseItemLink = _.find(_this.objectiveGroup.baseItemLinks, link=>{return link.teamId != undefined});

        if (_this.teamBaseItemLink && _this.teamBaseItemLink.teamId !== '0') {
			_this.objectiveTeam = _.find(_this.board.teams, {id: _this.teamBaseItemLink.teamId});
        }
		_this.bvAchievementCalculation();
        if(_this.objectiveGroup){
            _this.customObjectiveTitalModel = _this.objectiveGroup.title;
        }
        _this.isSaveCommittedObjectiveCalled = false;
        if(_this.objectiveGroup.expand){
            _this.isExpandActive = 'active';
        }
		if(this.board.session.activeSessionBoard != this.board.id) {
		let groupBaseItemLink = _.find(_this.objectiveGroup.baseItemLinks, {"type": "Objective-Group"});
			if(!_.isEmpty(groupBaseItemLink)) {
				_this.isItemOfAnotherState = groupBaseItemLink.sessionBoardId? groupBaseItemLink.sessionBoardId != this.board.id : false; 
			}
		}

        if (this.objectiveGroup.baseItemLinks){
            for (let i=0; i < this.objectiveGroup.baseItemLinks.length; i++){
                if (this.objectiveGroup.baseItemLinks[i].teamId && this.objectiveGroup.baseItemLinks[i].teamId === "0"){
                    this.isCustomObjectiveGroup = true;
                    break;
                }
            }
        }

        if (_.isEmpty(this.objectiveColumnSettings)) {
            this.objectiveColumnsList = ["timePeriod", "association", "responsible", "progress", "status"];
        } else {
            this.objectiveColumnsList = _.cloneDeep(this.objectiveColumnSettings);
        }
        if(this.getUrlParam("objectiveGroup") !== undefined && this.getUrlParam("objectiveGroup") === this.objectiveGroup.id && this.getUrlParam("isArt") !== undefined) {
            this.showObjectiveGroupProgress = true;
        }

        if (kendisStore.getters.getCustomViews() && kendisStore.getters.getCustomViews().length > 0) {
            this.linkedCustomView = kendisStore.getters.getCustomViews().find(view => view.id === this.objectiveGroup.linkedCustomView);
        }

        if (this.objectiveGroup.linkedCustomView && _.isEmpty(this.linkedCustomView)) {
            this.fetchLinkedCustomView(this.objectiveGroup.linkedCustomView);
        }

    },

    components: {
        OBJECTIVE_GROUP_PROGRESS: 'objective-group-progress',
    },
    methods: {
        onKeyClick() {
            let url;

            if (this.isArt) {
                url = '/objectives#/' + this.linkedCustomView.key;
            } else {
                url = '/org#/' + this.getCollection.type.prefix + '/' + this.getCollection.key + '/objectives';
            }

            window.open(url, '_blank');
        },
		checkForObjectiveUpdate: function (objective) {
			let baseItem = _.clone(_.find(this.objectiveGroup.baseItemList, {id: objective.id}));
            if (baseItem) {
				this.updateObjective(baseItem, objective, false);
			}
		},
        updateSilently: function (objective) {
            let _this = this;
            let copyObjective = _.clone(objective);
            delete copyObjective.baseItemList;
            axios.post('objective/update-objective', copyObjective)
                .then(response => {
                    let index = _.findIndex(_this.objectiveGroup.baseItemList, {id: copyObjective.id});
                    copyObjective.baseItemList = _this.objectiveGroup.baseItemList[index].baseItemList;
                    _this.objectiveGroup.baseItemList[index] = copyObjective;
                    _.remove(_this.objectiveList[index].baseItemList, {id: objective.id});
                })
                .catch(error => {
                    console.error("Objective Update error", error);
                })
        },

        showUncommittedObjectiveCreationInput: function () {
            this.showAddUncommittedObjectiveInput = true;	
            const element = this.$refs['objective_group_ref_of_'+this.objectiveGroup.id];
            if(element && element.classList !== undefined) {
                if (!element.classList.contains('active')) {
                    element.classList.add('active');
                }
            }
        },
        closeUncommittedObjectiveForm: function (){
            this.showAddUncommittedObjectiveInput = false;
            this.toggleGroupDragging(false);
        },

        expandOrCollapseGroup: function () {
            let _this = this;
            const element = _this.$refs['objective_group_ref_of_'+_this.objectiveGroup.id];
            if(element && element.classList !== undefined) {
                if (!element.classList.contains('active')) {
                    element.classList.add('active');
                } else {
                    element.classList.remove('active');
                }
                this.$emit("expandCollapseGroupObjective", this.objectiveGroup);
            }
        },

        getObjectiveTitleHTML: function (objective) {
			var _this = this;
            let title = this.getObjectiveGroupTitle();
            if (!_.isEmpty(_this.objectiveTeam)) {
                let html = '<div class="tm lbl-bg" title="Team 1" style="color:' + _this.objectiveTeam.color + ';"><div class="line" style="background-color:' + _this.objectiveTeam.color + ';"></div>' + _this.objectiveTeam.label + '</div>';
                html += '<b>' + _this.objectiveTeam.title + '</b>';

                return html;

            } else {
                let html = "";
				if(_this.getGroupColor) {
	                html = '<b data-action="accord-o" style="color:' + _this.getGroupColor + ';">' + title + '</b>';
				} else {
	                html = '<b data-action="accord-o">' + title + '</b>';
				}
                return html;
            }

        },

        getObjectiveGroupTitle() {
            if (this.objectiveGroup.linkedCustomView && this.isArt) {
                return this.linkedCustomView ? this.linkedCustomView.title : this.objectiveGroup.title;
            }
            return this.objectiveGroup.title;
        },

        fetchLinkedCustomView(id) {
            axios.post("/objective/cv/" + id)
                .then(response => {
                    if (response.data.success) {
                        this.linkedCustomView = response.data.view;

                    }
                })
                .catch(error => {

                })
        },

        showCommittedObjectiveForm: function () {
            this.showAddCommittedObjectiveInput = true;
            this.moveNext('newObjectiveTitleRef');
        },

        moveNext: function (option) {
            let _this = this;
            _this.$nextTick(() => {
                const element = _this.$refs[option];
                if (element){
                    element.focus();
                }
            });
        },
        closeCommittedObjectiveForm: function (){
            this.showAddCommittedObjectiveInput = false;
            this.newObjectiveDataCommitted.title = '';
            this.timePeriod.period = {};
            this.isAddCommittedObjectiveTimePeriodValid = true;
            this.isAddCommittedObjectiveInputValid = true;
            this.toggleGroupDragging(false);
        },

        saveEditObjectiveValue: function (objective) {
            this.onSaveObjective(objective);
        },

        saveCommittedObjective: function () {
            if (!this.isSaveCommittedObjectiveCalled) {
                if (!this.isTitleValid(this.newObjectiveDataCommitted.title)) {
                    this.isAddCommittedObjectiveInputValid = false;
                    showTopMessage("Please enter a valid title.", "warning", 3000);
                    return;
                } else if (_.isEmpty(this.timePeriod.period) && this.isMockingMode) {
                    this.isAddCommittedObjectiveTimePeriodValid = false;
                    showTopMessage("Please select a time period for objective.", "warning", 3000);
                    return;
                } else {
                    this.isAddCommittedObjectiveInputValid = true;
                    this.isAddCommittedObjectiveTimePeriodValid = true;
                }
                this.isSaveCommittedObjectiveCalled = true;
                this.addNewObjective('Committed');
                this.toggleGroupDragging(false);
            }
        },

        onSelectTimePeriod(selectedPeriod) {
            this.timePeriod.period = selectedPeriod.timePeriod;
            this.timePeriod.startDate = selectedPeriod.startDate;
            this.timePeriod.endDate = selectedPeriod.endDate;
        },

        saveUncommittedObjective: function () {
			if(!this.isSaveCommittedObjectiveCalled) {
	            if(!this.isTitleValid(this.newObjectiveDataUncommitted.title)){
	                this.isAddUnCommittedObjectiveInputValid = false;
	                showTopMessage("Please enter a valid title.","warning",3000);
	                return;
	            } else {
	                this.isAddUnCommittedObjectiveInputValid = true;
	            }
		        this.isSaveCommittedObjectiveCalled = true;
	            this.addNewObjective('Uncommitted');
                this.toggleGroupDragging(false);
			}
        },

        isTitleValid(title) {
            /*This method checks the following things:
            1- Firstly it eliminates and leading and trailing space characters
            2- Secondly it checks that the title is not empty */
            title = title.trim();
            return title.length > 0;
        },

        populateObjectivesList: function (list) {
            let _this = this;
            this.unCommittedList = [];
            this.committedList = [];
            list = _.compact(list);
            _.forEach(list, function (objective) {
                if (objective.type.includes("Uncommitted") || objective.type == "stretch") {
                    _this.unCommittedList.push(objective);
                } else {
                    _this.committedList.push(objective);
                }
            });
            this.unCommittedList = _.orderBy(this.unCommittedList, ['sequence'], ['asc']);
            this.committedList = _.orderBy(this.committedList, ['sequence'], ['asc']);
        },

        addNewObjective: function (type) {
            let newObjective = {};
            let completionCriteria = _.find(this.statusAndEstimateFilters, status => {
                return status.code === "CHILDREN_LINKED_ITEM_STATUS";
            });

            if(type == "Committed") {
                newObjective.title = this.newObjectiveDataCommitted.title;
                newObjective.bvPlan = this.newObjectiveDataCommitted.bvPlan;
                newObjective.bvActual = this.newObjectiveDataCommitted.bvActual;
            } else if(type == "Uncommitted") {
                newObjective.title = this.newObjectiveDataUncommitted.title;
                newObjective.bvPlan = this.newObjectiveDataUncommitted.bvPlan;
                newObjective.bvActual = this.newObjectiveDataUncommitted.bvActual;
            }

            newObjective.bvPlan = Math.max(0, Math.floor(Number(newObjective.bvPlan)));
            newObjective.bvActual = Math.max(0, Math.floor(Number(newObjective.bvActual)));

            newObjective.metaMap = {};
            if(this.isMockingMode){
                newObjective.metaMap.sessionId = this.board.session.id;
                newObjective.metaMap.boardId = this.board.session.id;
            }else{
                newObjective.metaMap.sessionId = vueInstance.activeBoard.session.id;
                newObjective.metaMap.boardId = this.board.id;
            }
            newObjective.metaMap.syncId = syncId;
            newObjective.metaMap.groupId = this.objectiveGroup.id;
            newObjective.metaMap = JSON.stringify(newObjective.metaMap);
            newObjective.type = "Objective-" + type;
            newObjective.completionCriteria = completionCriteria.code;
            if(_.find(kendisStore.getters.getObjectiveTemplate().statuses, {"category":"ToDo"}) != -1) {
                newObjective.status = _.find(kendisStore.getters.getObjectiveTemplate().statuses, {"category": "ToDo"});
            }
            if (!_.isEmpty(this.timePeriod.period)) {
                newObjective.fields = {};
                newObjective.fields[this.krParentTimePeriodFieldId] = this.timePeriod.period;
                newObjective.fields[this.krParentStartDateFieldId] = this.timePeriod.startDate;
                newObjective.fields[this.krParentEndDateFieldId] = this.timePeriod.endDate;
            }
            this.onSaveObjective(newObjective);
        },

        formatBVPlanValue: function (type) {
            if (type === "committed"){
                this.newObjectiveDataCommitted.bvPlan = Math.min(99999, Math.max(0, Math.floor(Number(this.newObjectiveDataCommitted.bvPlan))));
            }else{
                this.newObjectiveDataUncommitted.bvPlan = Math.min(99999, Math.max(0, Math.floor(Number(this.newObjectiveDataUncommitted.bvPlan))));
            }
        },

        formatBVActualValue: function (type) {
            if (type === "committed"){
                this.newObjectiveDataCommitted.bvActual = Math.min(99999,Math.max(0, Math.floor(Number(this.newObjectiveDataCommitted.bvActual))));
            }else{
                this.newObjectiveDataUncommitted.bvActual = Math.min(99999,Math.max(0, Math.floor(Number(this.newObjectiveDataUncommitted.bvActual))));
            }
        },
		updateObjective: function (baseItem, objective, updateSilent=false) {
			
			let _this = this;
			
			delete baseItem.board;
            delete baseItem.linkedItems;
            delete baseItem.linkedItemsById;
            delete baseItem.linkedItemsIds;
            delete baseItem.baseItemList;
            
            baseItem.title = objective.title;
            
            if (objective.itemType.title == "Objective") {
                if(kendisStore.getters.getObjectiveMenuOptions()['isBVAchievementEnabled'] && (objective.bvPlan !== undefined && objective.bvPlan !== null) && (objective.bvActual !== undefined && objective.bvActual !== null)) {
                    baseItem.bvPlan = objective.bvPlan;
                    baseItem.bvActual = objective.bvActual;
                }
            } else if(objective.itemType.title == "KR"){
                if(kendisStore.getters.getObjectiveMenuOptions()['isOkrBVAchievementEnabled'] && (objective.bvPlan !== undefined && objective.bvPlan !== null) && (objective.bvActual !== undefined && objective.bvActual !== null)) {
                    baseItem.bvPlan = objective.bvPlan;
                    baseItem.bvActual = objective.bvActual;
                }
            }
            baseItem.notifyWatchers = objective.notifyWatchers;
            baseItem.starred = objective.starred;
            baseItem.metaMap = objective.metaMap;
            if (objective.fields){
                baseItem.fields = objective.fields;
            }
            if (objective.description || objective.description === ""){
                baseItem.description = objective.description;
            }
            if (objective.baseItemLinks){
                baseItem.baseItemLinks = _.compact(objective.baseItemLinks);
            }
            if (objective.completionCriteria){
                baseItem.completionCriteria = objective.completionCriteria;
            }
            if (objective.status){
                baseItem.status = objective.status;
            }
            if (objective.type){
			    baseItem.type = objective.type;
            }
            let objectiveLink = _.filter(baseItem.baseItemLinks, {type: "Objective"})[0];
            if (objectiveLink) {
                delete objectiveLink.deleted;
            }
            if (!baseItem.metaMap || baseItem.metaMap == "undefined") {
                let metaMap = {};
                metaMap.sosId = "0";
                metaMap.syncId = syncId;
                if(_this.isMockingMode){
                    metaMap.sessionId = this.board.session.id;
                    metaMap.boardId = this.board.session.id;
                }else {
                    metaMap.sessionId = vueInstance.activeBoard.session.id;
                    metaMap.boardId = this.board.id;
                }
                baseItem.metaMap = JSON.stringify(metaMap);
            }else{
                baseItem.metaMap = JSON.parse(baseItem.metaMap);
                if (!baseItem.metaMap.groupId){
                  baseItem.metaMap.groupId = _this.objectiveGroup.id;
                }
                baseItem.metaMap = JSON.stringify(baseItem.metaMap);
            }
            if (baseItem.eventType) {
                delete baseItem.eventType;
            }

            if (baseItem.highlightedKey){
                delete baseItem.highlightedKey;
            }
            if (baseItem.highlightedTitle){
                delete baseItem.highlightedTitle;
            }
			_.each(baseItem.baseItemLinks, link=>{
				if(!_.isEmpty(link.linkedItemById)) {
					delete link.linkedItemById;
				}
			});
            axios.post('external-entitites/save-base-item/popup-save', baseItem)
                .then(response => {
                    if (response && response.status == "200" && response.data) {
                        let updatedObjective = response.data.impediment;
                        var index = _.findIndex(_this.objectiveGroup.baseItemList, {id: updatedObjective.id});
                        if(index != -1) {
                            updatedObjective.baseItemList = _this.objectiveGroup.baseItemList[index].baseItemList;
                            updatedObjective.linkedItems = _this.objectiveGroup.baseItemList[index].linkedItems;
                            updatedObjective.linkedItemsById = _this.objectiveGroup.baseItemList[index].linkedItemsById;
                            updatedObjective.linkedItemsIds = _this.objectiveGroup.baseItemList[index].linkedItemsIds;
                            if (_this.isMockingMode){
                                updatedObjective.backLogItems = _this.objectiveGroup.baseItemList[index].backLogItems;
                                updatedObjective.backLogItemsGrouped = _this.objectiveGroup.baseItemList[index].backLogItemsGrouped;
                                updatedObjective.backlogItemsMetaDetails = _this.objectiveGroup.baseItemList[index].backlogItemsMetaDetails;
                                updatedObjective.itemsGroupedByReleaseTrain = _this.objectiveGroup.baseItemList[index].itemsGroupedByReleaseTrain;
                            }
                            let storePayload = {};
                            storePayload.objective = updatedObjective;
                            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                        }
                        let containerMap = _.find(_this.objOkrPopupContainerMap, {"isPopupOpen" : true});
                        if (containerMap){
                            containerMap.itemTemplate.creationAndUpdateData.updatedOn = updatedObjective.updatedOn;
                            containerMap.itemTemplate.creationAndUpdateData.updatedBy = updatedObjective.updatedBy;
                            kendisStore.commit("setObjOkrPopupContainerMap", _this.objOkrPopupContainerMap);
                        }
                        _this.populateObjectivesList(_this.objectiveGroup.baseItemList);
                        if(!updateSilent) {
                            if(this.isSOSPage){
                                showTopMessage("Objective Updated. Some updates require a browser reload to reflect the changes.", 'success');
                            } else{
                                showTopMessage("Objective Updated", 'success');
                            }
                        }
						_this.bvAchievementCalculation();
                        // _this.$forceUpdate();
                        if(this.isSOSPage){
                            showTopMessage("Objective Updated. Some updates require a browser reload to reflect the changes.", 'success');
                        } else {
                            showTopMessage("Objective Updated.", 'success');
                        }

						if(!_.isEmpty(objective) && !_.isEmpty(objective.baseItemLinks) && _this.isMockingMode) {
							_this.recalculateCompletion(objective, _this.board);
						}
                    }
                })
                .catch(error => {
                    console.error("Item save error", error);

                })
			
		},
        onEditObjective: function (objective, updateSilent=false) {
            let _this = this;
            let baseItem = _.clone(_.filter(_this.objectiveGroup.baseItemList, {id: objective.id})[0]);
            if (!baseItem) {
				this.$parent.onRecieveObjectiveUpdate(objective);
				return;
			}
			this.updateObjective(baseItem, objective, updateSilent);
        },

        onSaveObjective: function (requestBody) {
            if (requestBody.id) {
                this.onEditObjective(requestBody);
                return;
            }
            let _this = this;
            let baseItemLinks = [];
 			if(this.isMockingMode){
                 let boardId = "";
                 const collection = this.getGroupCollection;
                 if (!_.isEmpty(collection) && collection.sessionId) {
                     boardId = collection.sessionId;
                 } else {
                     boardId = this.board.session.id;
                 }
				baseItemLinks.push(
					{sessionId: boardId, sessionBoardId: this.board.id, type: "Objective", linkType : "art_link_objective"},
					{sessionId: boardId, sessionBoardId: this.board.id, baseItemId : _this.objectiveGroup.id, linkType: "parent_group_objective"}
				);
			} else {
				baseItemLinks.push(
					{sessionId: this.board.session.id, sessionBoardId: this.board.id, type: "Objective", linkType : "session_link_objective"},
					{sessionId: this.board.session.id, sessionBoardId: this.board.id, baseItemId : _this.objectiveGroup.id, linkType: "parent_group_objective"}
				);
			}
            requestBody.baseItemLinks = baseItemLinks;
            requestBody.starred = false;
            requestBody.mentionUsers = [];
            requestBody.itemType = kendisStore.getters.getObjectiveTemplate().scheme.itemType;
            axios.post('external-entitites/save-base-item/popup-save', requestBody).then(response => {
                if (response.status == "200" && response && response.data) {
                    let objective = response.data.impediment;
					if(_this.isMockingMode) {
						let objId = objective.id;
						let completionsMap = {};
						completionsMap[objId] = 0.0;								
						let savedCompletionMap = kendisStore.getters.getOkrCompletionMap();
						Object.assign(savedCompletionMap, completionsMap);
						kendisStore.commit("setOkrCompletionMap", savedCompletionMap);						
					}

					if(_this.objectiveGroup.baseItemList == undefined) {
						_this.objectiveGroup.baseItemList = [];
					}
                    _this.objectiveGroup.baseItemList.push(objective);
					if(objective.type == "Objective-Uncommitted") {
			            _this.unCommittedList.push(objective);
					}
					else if(objective.type == "Objective-Committed") {
			            _this.committedList.push(objective);						
					}
					_this.bvAchievementCalculation();
                    let baseItemLink = {};
                    let boardId = "";
                    const collection = _this.getGroupCollection;
                    if (!_.isEmpty(collection) && collection.sessionId) {
                        boardId = collection.sessionId;
                    } else {
                        boardId = _this.board.session.id;
                    }
                    baseItemLink.baseItemId = objective.id;
                    baseItemLink.sessionId = boardId;
                    //baseItemLink.weightage = objective.baseItemLinks[0].weightage;
					baseItemLink.linkType = "child_group_objective";
					baseItemLink.sessionBoardId = this.board.id;
                    _this.objectiveGroup.baseItemLinks.push(baseItemLink);
                    let metaMap = {};
                    metaMap.syncId = syncId;

                    metaMap.sessionId = boardId;
                    metaMap = JSON.stringify(metaMap);
                    _this.objectiveGroup.metaMap = {};
                    _this.objectiveGroup.metaMap = metaMap;
                    let copy= _.cloneDeep(_this.objectiveGroup);
					let baseItemListData = {};
					baseItemListData.id = _this.objectiveGroup.id;
					baseItemListData.baseItemList = copy.baseItemList
                    delete copy.baseItemList;
                    axios.post('external-entitites/save-base-item/popup-save', copy).then(response => {
                        if (response.status == "200") {
                            let parentGroup = response.data.impediment;
                            baseItemListData.baseItemLinks = parentGroup.baseItemLinks;
							kendisStore.commit("addToGroupBaseItems", baseItemListData);
                            if(requestBody.type == "Objective-Committed") {
                                _this.newObjectiveDataCommitted.title = "";
                                _this.newObjectiveDataCommitted.bvPlan = 0;
                                _this.newObjectiveDataCommitted.bvActual = 0;
                            } else if(requestBody.type == "Objective-Uncommitted") {
                                _this.newObjectiveDataUncommitted.title = "";
                                _this.newObjectiveDataUncommitted.bvPlan = 0;
                                _this.newObjectiveDataUncommitted.bvActual = 0;
                            }
                            _this.showAddCommittedObjectiveInput = false;
                            _this.showAddUncommittedObjectiveInput = false;
                            /*let payload = {};
                            payload.updatedObjective = objective;
                            payload.parentGroup = parentGroup;
                            _this.$emit("updateObjectiveGroupList", payload, "save-objective")*/
                            showTopMessage("Objective Created", 'success');
                            _this.isSaveCommittedObjectiveCalled = false;
							if(_this.isMockingMode) {
								_this.recalculateCompletion(objective, _this.board);
							}
                        }
                    }).catch(error => {
                        console.error("Item save error", error);
                        _this.isSaveCommittedObjectiveCalled = false;
                    });
                }
            }).catch(error => {
                console.error("Item save error", error);
                _this.isSaveCommittedObjectiveCalled = false;
            })
        },

        deleteObjectiveGroup: function (objectiveGroupId) {
			if(this.objectiveGroup.isDefaultGroup) {
				alertFromSweetAlertWrapper("You cannot delete the default group", [takeNoAction])				
			} else {
            	this.$emit("onObjectiveGroupDelete", objectiveGroupId);
			}
        },

        deleteCustomGroup: function (groupId){
            this.deleteObjectiveGroup(groupId);
        },

        onEditHandle: function () {
            //this.isEditFormShow = !this.isEditFormShow;
			if(!this.readOnlyView && this.teamBaseItemLink.teamId==0 && !this.objectiveGroup.isDefaultGroup && this.$options.permissions && this.$options.permissions.EDIT_OBJECTIVE_GROUP) {
	            let _this = this;
	            _this.itemTemplate = {};
	            _this.itemTemplate.model = {};
	            _this.itemTemplate.model.fields = {};
				_this.itemTemplate.statuses = [];
	            _this.itemTemplate.id = _this.objectiveGroup.id;
	            _this.itemTemplate.model.id = _this.objectiveGroup.id;
	            _this.itemTemplate.model.title = _this.objectiveGroup.title;
	            _this.itemTemplate.model.key = _this.objectiveGroup.title;
	            _this.itemTemplate.model.title = _this.objectiveGroup.title;
	            _this.itemTemplate.model.status = _this.objectiveGroup.status;
	            _this.itemTemplate.model.description = _this.objectiveGroup.description;
		        _this.itemTemplate.model.headerColor = _this.objectiveGroup.headerColor;
		        _this.itemTemplate.model.isDefaultGroup = _this.objectiveGroup.isDefaultGroup;
		        _this.itemTemplate.model.itemType = _this.objectiveGroup.itemType;
	
		        if (_this.objectiveGroup.fields) {
		            _this.itemTemplate.model.fields = _this.objectiveGroup.fields;
		        }
				
	            _this.itemTemplate.showEditPopUp = true;
				if(_this.objectiveGroup && kendisStore.getters.getObjectiveGroupTemplate()) {
					if(this.isCollectionGroup) {
				    	_this.itemTemplate.templateToRenderer = _.cloneDeep(kendisStore.getters.getObjectiveGroupTemplate().scheme.fieldsTemplate);
						if(_this.itemTemplate.templateToRenderer.configuredFields) {
							_this.itemTemplate.templateToRenderer.configuredFields = _this.itemTemplate.templateToRenderer.configuredFields.filter(field => field.code !== "1" && field.code !== "2");						
						}
					}else{
						_this.itemTemplate.templateToRenderer = kendisStore.getters.getObjectiveGroupTemplate().scheme.fieldsTemplate;
					}
					_this.itemTemplate.statuses = kendisStore.getters.getObjectiveGroupTemplate().statuses;
				}
	
	            toggleDraggable(true);
				_this.$forceUpdate();
			}

        },

        hideEditForm: function () {
            this.isEditFormShow = false;
        },

        updateCustomGroupObjective: function (objGrp) {
            let _this = this;
            /*let title = _this.customObjectiveTitalModel.trim();
            if(title === ""){
                _this.isEditObjectiveInputValid = false;
                return;
            } else {
                _this.isEditObjectiveInputValid = true;
            }
            _this.objectiveGroup.title = _this.customObjectiveTitalModel;*/

			_this.objectiveGroup.title = objGrp.title;
	        _this.objectiveGroup.fields = objGrp.fields;
	        _this.objectiveGroup.description = objGrp.description;
	        _this.objectiveGroup.headerColor = objGrp.headerColor;
	        _this.objectiveGroup.status = objGrp.status;

            _this.$emit("updateGroupObjective", _this.objectiveGroup);
			_this.onCLoseEditPopUp();
            // _this.isEditFormShow = false;
        },

        deleteObjective: function (obj) {
            let _this = this;
            let requestBody = {};
            let metaMap = {};
            if(this.isMockingMode){
                metaMap = {
                    "syncId" : syncId,
                    "sessionId" :  _this.board.session.id,
                }
            }else{
                metaMap = {
                    "syncId" : syncId,
                    "sessionId" : vueInstance.activeBoard.session.id,
                }
            }

            requestBody.objId = obj.id;
            requestBody.metaMap = JSON.stringify(metaMap);

            axios.post('/objective/delete-objective', requestBody).then(response => {
                if (response && response.status == "200") {
                     let storePayload = {};
                     storePayload.isDeleteObjectiveCase = true;
                     storePayload.objective = obj;
                     kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);

                    _this.populateObjectivesList(_this.objectiveGroup.baseItemList);
                    showTopMessage("Objective deleted.", 'success');
                    let payload = {};
                    payload.deletedObjective = obj;
                    _this.$emit("updateObjectiveGroupList", payload, "delete-objective");
					if(_this.isMockingMode) {
						_this.recalculateCompletion(obj, _this.board);
					}
                }
            }).catch(error => {
                console.error("Objective delete error", error);
            });
		},

        onChangeSortable: function (evt) {
            let _this = this;
            let fromId = evt.from.getAttribute('data-id');
            let toId = evt.to.getAttribute('data-id');
            let result = null;
            let fromType = evt.from.getAttribute('data-type');
            let toType = evt.to.getAttribute('data-type');
            let objective = {};
            let objectiveListTemp = [];

            if (fromId === toId) {
                // reordering within group
                if (fromType !== toType){
                    askFromSweetAlertWrapper("The objective will be moved to " + toType + " group for all the linked teams. Are you sure you want to move?", [function (){
                        if (fromType == 'committed' && toType == 'uncommitted') {
                            objective = _this.committedList[evt.oldIndex];
                            objective.type = 'Objective-Uncommitted';
                            let temp = _.cloneDeep(_this.unCommittedList);
                            temp.push(objective);
                            objectiveListTemp = temp;
                        } else if (fromType == 'uncommitted' && toType == 'committed') {
                            objective = _this.unCommittedList[evt.oldIndex];
                            objective.type = 'Objective-Committed';
                            let temp = _.cloneDeep(_this.committedList);
                            temp.push(objective);
                            objectiveListTemp = temp;
                        }
                        result = _this.calculateNewSequenceOfItem(evt.newIndex, evt.oldIndex, objectiveListTemp, 'sequence');
                        if (result){
                            objective.sequence = result.value;
                            _this.updateSequence(objective);
                        }
                    }], [_this.revertFrontEndChanges]);
                }else{
                    if (fromType == 'committed' && toType == 'committed') {
                        objective = _this.committedList[evt.oldIndex];
                        objectiveListTemp = _this.committedList;
                    } else if (fromType == 'uncommitted' && toType == 'uncommitted') {
                        objective = _this.unCommittedList[evt.oldIndex];
                        objectiveListTemp = _this.unCommittedList;
                    }
                    result = _this.calculateNewSequenceOfItem(evt.newIndex, evt.oldIndex, objectiveListTemp, 'sequence');
                    if (result){
                        objective.sequence = result.value;
                        _this.updateSequence(objective);
                    }
                }
            } else {
                let fromObjectiveGroup = {};
                let toObjectiveGroup = {};
                fromObjectiveGroup = _.filter(_this.objectiveGroupList, {id: fromId})[0];
                toObjectiveGroup = _.filter(_this.objectiveGroupList, {id: toId})[0];
                let tempFromCommittedList = [];
                let tempFromUncommittedList = [];
                let tempToCommittedList = [];
                let tempToUncommittedList = [];

                if(fromObjectiveGroup && fromObjectiveGroup !== undefined && fromObjectiveGroup.baseItemList.length > 0) {
                    tempFromCommittedList = _.filter(fromObjectiveGroup.baseItemList, {"type": "Objective-Committed"});
                    tempFromCommittedList = _.orderBy(tempFromCommittedList, ['sequence'], ['asc']);
                }

                if(fromObjectiveGroup && fromObjectiveGroup !== undefined && fromObjectiveGroup.baseItemList.length > 0) {
                    tempFromUncommittedList = _.filter(fromObjectiveGroup.baseItemList, {"type": "Objective-Uncommitted"});
                    tempFromUncommittedList = _.orderBy(tempFromUncommittedList, ['sequence'], ['asc']);
                }

                if(toObjectiveGroup &&  toObjectiveGroup !== undefined && toObjectiveGroup.baseItemList && toObjectiveGroup.baseItemList.length > 0) {
                    tempToCommittedList = _.filter(toObjectiveGroup.baseItemList, {"type": "Objective-Committed"});
                    tempToCommittedList = _.orderBy(tempToCommittedList, ['sequence'], ['asc']);
                }

                if(toObjectiveGroup &&  toObjectiveGroup !== undefined && toObjectiveGroup.baseItemList && toObjectiveGroup.baseItemList.length > 0) {
                    tempToUncommittedList = _.filter(toObjectiveGroup.baseItemList, {"type": "Objective-Uncommitted"});
                    tempToUncommittedList = _.orderBy(tempToUncommittedList, ['sequence'], ['asc']);
                }

                // reordering outside group
                let isDuplicate = false;
                if (fromType == 'committed' && toType == 'committed') {
                    objective = tempFromCommittedList[evt.oldIndex];
                    if(fromObjectiveGroup.baseItemList){
                        _.each(toObjectiveGroup.baseItemList, item=>{
                            if(item.id == objective.id){
                                isDuplicate = true;
                            }
                        });
                    }
                    tempToCommittedList.push(objective);
                    objectiveListTemp = tempToCommittedList;
                } else if (fromType == 'uncommitted' && toType == 'uncommitted') {
                    objective = tempFromUncommittedList[evt.oldIndex];
                    if(toObjectiveGroup.baseItemList){
                        _.each(toObjectiveGroup.baseItemList, item=>{
                            if(item.id == objective.id){
                                isDuplicate = true;
                            }
                        });
                    }
                    tempToUncommittedList.push(objective);
                    objectiveListTemp = tempToUncommittedList;
                } else if (fromType == 'committed' && toType == 'uncommitted') {
                    objective = tempFromCommittedList[evt.oldIndex];
                    if(fromObjectiveGroup.baseItemList){
                        _.each(toObjectiveGroup.baseItemList, item=>{
                            if(item.id == objective.id){
                                isDuplicate = true;
                            }
                        });
                    }
                    if(!isDuplicate) {
                        objective.type = "Objective-Uncommitted";
                        tempToUncommittedList.push(objective);
                        objectiveListTemp = tempToUncommittedList;
                    }
                } else if (fromType == 'uncommitted' && toType == 'committed') {
                    objective = tempFromUncommittedList[evt.oldIndex];
                    if (toObjectiveGroup.baseItemList) {
                        _.each(toObjectiveGroup.baseItemList, item => {
                            if (item.id == objective.id) {
                                isDuplicate = true;
                            }
                        });
                    }
                    if (!isDuplicate) {
                        objective.type = "Objective-Committed";
                        tempToCommittedList.push(objective);
                        objectiveListTemp = tempToCommittedList;
                    }
                }

                if(isDuplicate){
                    showTopMessage("Duplicate objective can't move.", "warning", 4000);
                    _this.$emit("updateReRenderKey", _this.generateRandomKey());
                    return false;
                } else {
                    let obj = {
                        evt: evt,
                        list: objectiveListTemp,
                        objective: objective,
                        fromGroup: fromObjectiveGroup,
                        toGroup: toObjectiveGroup
                    };
                    askFromSweetAlertWrapper("Are you sure you want to move the objective from " + fromObjectiveGroup.title + " to " + toObjectiveGroup.title + "?", [_this.doUpdateSequenceInDB, obj], [_this.revertFrontEndChanges]);
                }
            }
        },

        revertFrontEndChanges: function (){
            let _this = this;
            _this.$emit("updateGroupList", 'revertFrontEndChanges');
        },

        doUpdateSequenceInDB: function (obj) {
            let _this = this;
            let result = _this.calculateNewSequenceOfItem(obj.evt.newIndex, obj.evt.oldIndex, obj.list, 'sequence');
            if (result) {
                obj.objective.sequence = result.value;
                _this.onEditObjective(obj.objective, true);
                let requestBody = {
                    objectiveId: obj.objective.id,
                    fromId: obj.fromGroup.id,
                    toId: obj.toGroup.id
                };
                let metaMap = {};
                if (_this.isMockingMode) {
                    metaMap = {
                        "syncId": syncId,
                        "sessionId": _this.board.session.id
                    };
                } else {
                    metaMap = {
                        "syncId": syncId,
                        "sessionId": vueInstance.activeBoard.session.id
                    };
                }

                requestBody.metaMap = JSON.stringify(metaMap);

                axios.post("objective/update-objective-groups", requestBody).then(response=> {
                    if(response.status == "200") {
                        _.forEach(response.data, function(item) {
                            if(item.id === obj.fromGroup.id){
                                obj.fromGroup.baseItemLinks = item.baseItemLinks;
                                _.remove(obj.fromGroup.baseItemList, {id: obj.objective.id});
                            } else if(item.id === obj.toGroup.id) {
                                if(obj.toGroup.baseItemList && !obj.toGroup.baseItemList.includes(obj.objective)) {
                                    obj.toGroup.baseItemList.push(obj.objective);
                                }
                                obj.toGroup.baseItemLinks = item.baseItemLinks;
                            }
                        });
                        let storePayload = {};
                        storePayload.group = obj.fromGroup;
                        kendisStore.commit("updateSingleGroup", storePayload);
                        storePayload.group = obj.toGroup;
                        kendisStore.commit("updateSingleGroup", storePayload);
						if(_this.isMockingMode && requestBody.fromId != requestBody.toId) {
							let groupsToRecalculate = [requestBody.fromId, requestBody.toId];
							_this.calculateGroupCompletion(groupsToRecalculate);
						}
                        _this.$emit("updateGroupList");
                    }
                }).catch(error => {
                    console.error("Error in doUpdateSequenceInDB() function ", error);
                });
            }
        },

        updateSequence: function (objective, from, to) {
            if (from == to) {
                // within Group
                let baseItem = objective;
                let metaMap = {};
                metaMap.syncId = syncId;
                metaMap.sessionId = this.board.session.id;
                baseItem.metaMap = JSON.stringify(metaMap);
                this.onEditObjective(baseItem, true);
            } else {
                // outside Group
                let group = objective;
                axios.post('objective/create-objective-group', group).then(response => {
                    if (response.status == "200" && response && response.data) {
                        console.log("create objective group success");
                    }
                }).catch(error => {
                    console.error("Item save error", error);
                });
            }
        },

		bvAchievementCalculation: function() {
			let _this = this;
			_this.bvPlanSum = 0;
			_this.bvActualSum = 0;
			_.each(_this.objectiveGroup.baseItemList, obj=>{
				if(obj.type !== "Objective-Uncommitted" && obj.type !== "stretch") {
					_this.bvPlanSum += parseFloat(obj.bvPlan);
				}
                if (_this.objectiveMenuOptions['isUnCommittedEnabled'] || (obj.type !== "Objective-Uncommitted") && (obj.type !== "stretch")) {
                    _this.bvActualSum += parseFloat(obj.bvActual);
                }
			})
			if(_this.bvPlanSum > 0) {
				_this.bvAchievement = (_this.bvActualSum/_this.bvPlanSum)*100;
				_this.bvAchievement = Math.round((_this.bvAchievement + Number.EPSILON) * 100) / 100;								
			}
		},

		updateLinkedItemsList: function(objective) {
			
		},

        onClickShowMenuPopup: function () {
            let _this = this;
            _this.showMenuOverlay = !_this.showMenuOverlay;

        },

        toggleWeightsTab: function(){
            let _this = this;
            if (!_.isEmpty(_this.objectiveListWithWeights)){
                _this.showWeightsTab = true;
                toggleDraggable(true);
            }else{
                showTopMessage("Please create objectives to assign weights.","warning",3000)
            }
            _this.showMenuOverlay = false;
        },

        populateObjectiveListWithWeights: function() {
            let _this = this;
            _this.objectiveListWithWeights = _.cloneDeep(_this.objectiveGroup.baseItemList);

            _.each(_this.objectiveListWithWeights, obj => {
                let groupLinkIndex = _.findIndex(_this.objectiveGroup.baseItemLinks, {"baseItemId" : obj.id});
                if (groupLinkIndex > -1 && _this.objectiveGroup.baseItemLinks[groupLinkIndex].baseItemId === obj.id &&  _this.objectiveGroup.baseItemLinks[groupLinkIndex].weightage !== undefined){
                    obj.assignedWeight =  _this.objectiveGroup.baseItemLinks[groupLinkIndex].weightage;
                    if (_this.objectiveCompletionMap[obj.id]){
                        obj.completion = _this.objectiveCompletionMap[obj.id];
                    }
                }

                if (obj.assignedWeight > 0){
                    obj.selectedForWeights = true;
                }else{
                    obj.selectedForWeights = false;
                }
            });
            if (!_this.objectiveMenuOptions['isUnCommittedEnabled']){
                let newArray = _this.objectiveListWithWeights.filter(item => item.type !== "Objective-Uncommitted" && item.type !== "stretch");
                _this.objectiveListWithWeights = newArray;
            }

        },

        closeObjWeightsPopup: function(){
            let _this = this;
            _this.showWeightsTab = false;
            _this.enableObjWeightsButton = false;
            toggleDraggable(false);
            _this.populateObjectiveListWithWeights();
        },

        handleCheckBoxAndWeightChange : function (obj, type) {
            let _this = this;
            if (type === "checkbox"){
                if (!obj.selectedForWeights){
                    obj.assignedWeight = 0;
                }else{
                    obj.assignedWeight = 1;
                }
            }

            if (!_this.enableObjWeightsButton){
                _this.enableObjWeightsButton = true;
            }
            _this.$forceUpdate();
        },

        saveObjectiveWeights: function (obj, type) {
            let _this = this;
            let listOfObjWeights = [];

            _.each(_this.objectiveListWithWeights, obj => {
                listOfObjWeights.push({
                    "baseItemId"		: obj.id,
                    "baseItemWeight"	: obj.assignedWeight
                });
            });

            let data = {
                "parentItemId" 	: _this.objectiveGroup.id,
                "listOfWeights"		: listOfObjWeights
            }
            axios.post('/objective/save-obj-okr-weights', data)
                .then(res => {
                    let response = res.data.parentItem;
                    _this.objectiveGroup.baseItemLinks = response.baseItemLinks;
                    _this.showWeightsTab = false;
                    showTopMessage("Objective weights have been updated.","success");
					if(_this.isMockingMode) {
						let groupsToRecalculate = [_this.objectiveGroup.id];
						_this.calculateGroupCompletion(groupsToRecalculate);
					}
                    _this.$forceUpdate();
                })
                .catch(error => {
                    console.error("Error while saving the weights of objective: ", error);
                })
        },

        handleChildRowCall: function(payload, event) {
            this.$emit("updateObjectiveGroupList", payload, event);
        },

        toggleWeightSummaryView : function(){
            let _this = this;
            if (_this.objectiveMenuOptions['isOkrEnabled'] && (_this.isMockingMode ||_this.completionBy.code === "OBJ_KR_WEIGHTS_FORMULA")) {
                _this.showWeightageSummaryView = !_this.showWeightageSummaryView;
                if (_this.showWeightageSummaryView){
                    toggleDraggable(true);
                }else{
                    toggleDraggable(false);
                }
            }
        },

        calculateValueOfSingleX: function(){
            let _this = this;
            let sumOfAssignedWeights = 0;
            let valueOfX = 0;

            _.each(_this.objectiveListWithWeights, obj => {
                if (obj.selectedForWeights && obj.assignedWeight > 0) {
                    sumOfAssignedWeights += obj.assignedWeight;
                }
            });

            if (sumOfAssignedWeights > 0) {
                valueOfX = 100 / sumOfAssignedWeights;
            }

            return valueOfX;
        },

        objectiveCompletionCriteria : function (updatedObj){
            let _this = this;
            _this.onEditObjective(updatedObj);
        },

        calculateObjCompletion: function (emittedObject){
            let _this = this;
            let index = _.findIndex(_this.objectiveListWithWeights, {id: emittedObject.id});
            if (index > -1){
                _this.objectiveListWithWeights[index]["completion"] = emittedObject.completion
                _this.objectiveCompletionMap[_this.objectiveListWithWeights[index]["id"]] = emittedObject.completion;
            }
            _this.$forceUpdate();
        },

        onBlurObjectiveInputBV() {
            this.isSaveCommittedObjectiveCalled = false;
            this.toggleGroupDragging(false);
        },

        calculateGroupCompletionWithoutWeights: function(excludeItemsData) {
            let _this =  this;
            let completion = 0;

            let doneItems = 0;
            let totalDoneItems = 0;

            let doneChildItems = 0
            let totalChildItems = 0;

            let doneStoryPoints = 0
            let totalStoryPoints = 0;

            let doneTeamItems = 0
            let totalTeamItems = 0;

            let doneTeamItemsStoryPoints = 0
            let totalTeamItemsStoryPoints = 0;

            _.each(_this.objectiveGroup.baseItemList, obj=>{
                if (_this.objectiveMenuOptions['isUnCommittedEnabled'] || obj.type !== "Objective-Uncommitted") {
                    let iteratedStoriesMap = {};
                    if(_this.completionBy.code == "LINKED_ITEM_STATUS") {
                        if(obj && obj.linkedItems) {
                            _.each(obj.linkedItems, item=>{
                                if (_this.verifyItemsToExclude(item, excludeItemsData)) {
                                    if (item.status && item.status.category === "Done") {
                                        doneItems += 1;
                                    }

                                    totalDoneItems += 1;
                                }
                            });
                        }
                    }
                    else if(_this.completionBy.code == "CHILDREN_LINKED_ITEM_STATUS") {
                        if(obj && obj.linkedItems) {
                            _.each(obj.linkedItems, item=>{
                                if (_this.verifyItemsToExclude(item, excludeItemsData)) {
                                    if (item.type == "UserStory") {
                                        if (!iteratedStoriesMap[item.id]) {
                                            totalChildItems += 1;
                                            if (item.status && item.status.category === "Done") {
                                                doneChildItems += 1;
                                            }
                                            iteratedStoriesMap[item.id] = true;
                                        }
                                    }
                                    if (item.subItems && item.subItems.length > 0) {
                                        _.each(item.subItems, subItem => {
                                            if (!iteratedStoriesMap[subItem.id] && _this.verifyItemsToExclude(subItem, excludeItemsData)) {
                                                if (subItem.status && subItem.status.category === "Done") {
                                                    doneChildItems += 1;
                                                }
                                                totalChildItems += 1;
                                                iteratedStoriesMap[subItem.id] = true;
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                    else if(_this.completionBy.code == "CHILDREN_LINKED_ITEM_ESTIMATE") {
                        if(obj && obj.linkedItems) {
                            _.each(obj.linkedItems, item=>{
                                if (_this.verifyItemsToExclude(item, excludeItemsData)) {
                                    if (item.type == "UserStory") {
                                        if (!iteratedStoriesMap[item.id]) {
                                        	if(!isNaN(Number(item.storyPoints))){//DEV-9320
                                            totalStoryPoints += item.storyPoints;
                                            if (item.status && item.status.category === "Done") {
                                                doneStoryPoints += item.storyPoints;
                                            }
                                        	}
                                            iteratedStoriesMap[item.id] = true;
                                        }
                                    }
                                    if (item.subItems && item.subItems.length > 0) {
                                        _.each(item.subItems, subItem => {
                                            if (!iteratedStoriesMap[subItem.id] && _this.verifyItemsToExclude(subItem, excludeItemsData)) {
                                            	if(!isNaN(Number(subItem.storyPoints))){//DEV-9320
                                                if (subItem.status && subItem.status.category === "Done") {
                                                    doneStoryPoints += subItem.storyPoints;
                                                }
                                                totalStoryPoints += subItem.storyPoints;
                                            	}
                                                iteratedStoriesMap[subItem.id] = true;
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                    else if(_this.completionBy.code == "TEAM_STORY_STATUS") {
                        if(obj && obj.linkedItems) {
                            _.each(obj.linkedItems, item=>{
                                if (_this.verifyItemsToExclude(item, excludeItemsData)) {
                                    if (item.type == "UserStory") {
                                        if (!_.isEmpty(_this.objectiveTeam)) {
                                            if (!_.isEmpty(item.teamContainers)){
                                                var isTeamStory = false;
                                                for (let i = 0; i < item.teamContainers.length; i++) {
                                                    isTeamStory = item.teamContainers[i].team.id == _this.objectiveTeam.id;
                                                    if (isTeamStory) {
                                                        break;
                                                    }
                                                }
                                                if (isTeamStory) {
                                                    if (!iteratedStoriesMap[item.id]) {
                                                        totalTeamItems += 1;
                                                        if (item.status && item.status.category === "Done") {
                                                            doneTeamItems += 1;
                                                        }
                                                        iteratedStoriesMap[item.id] = true;
                                                    }

                                                }
                                            }
                                        } else {
                                            if (!iteratedStoriesMap[item.id]) {
                                                totalTeamItems += 1;
                                                if (item.status && item.status.category === "Done") {
                                                    doneTeamItems += 1;
                                                }
                                                iteratedStoriesMap[item.id] = true;
                                            }
                                        }
                                    }
                                    if (item.subItems && item.subItems.length > 0) {
                                        _.each(item.subItems, subItem => {
                                            if (_this.verifyItemsToExclude(subItem, excludeItemsData)) {
                                                if (!_.isEmpty(_this.objectiveTeam)) {
                                                    if (!_.isEmpty(subItem.teamContainers)){
                                                        var isTeamStory = false;
                                                        for (let i = 0; i < subItem.teamContainers.length; i++) {
                                                            isTeamStory = subItem.teamContainers[i].team.id == _this.objectiveTeam.id;
                                                            if (isTeamStory) {
                                                                break;
                                                            }
                                                        }
                                                        if (isTeamStory) {
                                                            if (!iteratedStoriesMap[subItem.id]) {
                                                                totalTeamItems += 1;
                                                                if (subItem.status && subItem.status.category === "Done") {
                                                                    doneTeamItems += 1;
                                                                }
                                                                iteratedStoriesMap[subItem.id] = true;
                                                            }
                                                        }
                                                    }
                                                } else {
                                                    if (!iteratedStoriesMap[subItem.id]) {
                                                        totalTeamItems += 1;
                                                        if (subItem.status && subItem.status.category === "Done") {
                                                            doneTeamItems += 1;
                                                        }
                                                        iteratedStoriesMap[subItem.id] = true;
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                    else if(_this.completionBy.code == "TEAM_STORY_ESTIMATE") {
                        if(obj && obj.linkedItems) {
                            _.each(obj.linkedItems, item=>{
                                if (_this.verifyItemsToExclude(item, excludeItemsData)) {
                                    if (item.type == "UserStory") {
                                        if (!_.isEmpty(_this.objectiveTeam)) {
                                            if (!_.isEmpty(item.teamContainers)){
                                                var isTeamStory = false;
                                                for (let i = 0; i < item.teamContainers.length; i++) {
                                                    isTeamStory = item.teamContainers[i].team.id == _this.objectiveTeam.id;
                                                    if (isTeamStory) {
                                                        break;
                                                    }
                                                }
                                                if (isTeamStory) {
                                                    if (!iteratedStoriesMap[item.id]) {
                                                    	if(!isNaN(Number(item.storyPoints))){//DEV-9320
                                                        totalTeamItemsStoryPoints += item.storyPoints;
                                                        if (item.status && item.status.category === "Done") {
                                                            doneTeamItemsStoryPoints += item.storyPoints;
                                                        }
                                                    	}
                                                        iteratedStoriesMap[item.id] = true;
                                                    }
                                                }
                                            }
                                        } else {
                                            if (!iteratedStoriesMap[item.id]) {
                                            	if(!isNaN(Number(item.storyPoints))){//DEV-9320
                                                totalTeamItemsStoryPoints += item.storyPoints;
                                                if (item.status && item.status.category === "Done") {
                                                    doneTeamItemsStoryPoints += item.storyPoints;
                                                }
                                            	}
                                                iteratedStoriesMap[item.id] = true;
                                            }
                                        }
                                    }
                                    if (item.subItems && item.subItems.length > 0) {
                                        _.each(item.subItems, subItem => {
                                            if (_this.verifyItemsToExclude(subItem, excludeItemsData)) {
                                                if (!_.isEmpty(_this.objectiveTeam)) {
                                                    if (!_.isEmpty(subItem.teamContainers)){
                                                        var isTeamStory = false;
                                                        for (let i = 0; i < subItem.teamContainers.length; i++) {
                                                            isTeamStory = subItem.teamContainers[i].team.id == _this.objectiveTeam.id;
                                                            if (isTeamStory) {
                                                                break;
                                                            }
                                                        }
                                                        if (isTeamStory) {
                                                            if (!iteratedStoriesMap[subItem.id]) {
                                                            	if(!isNaN(Number(subItem.storyPoints))){//DEV-9320
                                                                totalTeamItemsStoryPoints += subItem.storyPoints;
                                                                if (subItem.status && subItem.status.category === "Done") {
                                                                    doneTeamItemsStoryPoints += subItem.storyPoints;
                                                                }
                                                            	}
                                                                iteratedStoriesMap[subItem.id] = true;
                                                            }
                                                        }
                                                    }
                                                } else {
                                                    if (!iteratedStoriesMap[subItem.id]) {
                                                    	if(!isNaN(Number(subItem.storyPoints))){//DEV-9320
                                                        totalTeamItemsStoryPoints += subItem.storyPoints;
                                                        if (subItem.status && subItem.status.category === "Done") {
                                                            doneTeamItemsStoryPoints += subItem.storyPoints;
                                                        }
                                                    	}
                                                        iteratedStoriesMap[subItem.id] = true;
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    }
                }
            });

            if(_this.completionBy.code == "LINKED_ITEM_STATUS") {
                if(totalDoneItems > 0) {
                    completion = (doneItems/totalDoneItems)*100;
                    completion = Math.round((completion + Number.EPSILON) * 100) / 100;
                }
            }
            else if(_this.completionBy.code == "CHILDREN_LINKED_ITEM_STATUS") {
                if(totalChildItems > 0) {
                    completion = (doneChildItems/totalChildItems)*100;
                    completion = Math.round((completion + Number.EPSILON) * 100) / 100;
                }
            }
            else if(_this.completionBy.code == "CHILDREN_LINKED_ITEM_ESTIMATE") {
                if(totalStoryPoints > 0) {
                    completion = (doneStoryPoints/totalStoryPoints)*100;
                    completion = Math.round((completion + Number.EPSILON) * 100) / 100;
                }
            }
            else if(_this.completionBy.code == "TEAM_STORY_STATUS") {
                if(totalTeamItems > 0) {
                    completion = (doneTeamItems/totalTeamItems)*100;
                    completion = Math.round((completion + Number.EPSILON) * 100) / 100;
                }
            }
            else if(_this.completionBy.code == "TEAM_STORY_ESTIMATE") {
                if(totalTeamItemsStoryPoints > 0) {
                    completion = (doneTeamItemsStoryPoints/totalTeamItemsStoryPoints)*100;
                    completion = Math.round((completion + Number.EPSILON) * 100) / 100;
                }
            }

            return completion
        },
        openLinkedObjContainer: function (linkedObj){
            let _this = this;
            let linkWithGroupId = _.find(linkedObj.baseItemLinks, function (itemLink) {
                if (itemLink.linkType && itemLink.linkType === "parent_group_objective"){
                    return itemLink.baseItemId;
                }
            });
            if (linkWithGroupId){
               if (linkWithGroupId.baseItemId === _this.objectiveGroup.id && _this.$refs['row_' + linkedObj.id]){
                _this.$refs["row_" + linkedObj.id][0].openModalForEditing(linkedObj);
                }else{
                    _this.$emit("open-obj-from-other-group", linkedObj, linkWithGroupId.baseItemId);
                }
            }
        },
        toggleGroupDragging: function (option){
            toggleDraggable(option)
        },
		onCLoseEditPopUp: function () {
            let _this = this;
            _this.itemTemplate.showEditPopUp = false;
            toggleDraggable(false);
            _this.$forceUpdate();
        },
        openObjectiveGroupPopup(){
            this.showObjectiveGroupProgress = true;
        },
        closeGroupProgress(){
            this.showObjectiveGroupProgress = false;
        },
		onEditTitle : function () {
			Vue.set(this, "isTitleEdit", true);
			if (this.objectiveGroup.linkedCustomView && this.isArt) {
                this.customObjectiveTitalModel =  this.linkedCustomView ? this.linkedCustomView.title : this.objectiveGroup.title;
            }else{
	            this.customObjectiveTitalModel =  this.objectiveGroup.title;	
			}
		},
		saveField : function(field) {
			const updated = { ...this.objectiveGroup };

			if (field === 'title') {
				const title = (this.customObjectiveTitalModel || '').trim();
				if (!title) { showTopMessage('Title is required', 'warning', 3000); return; }
				updated.title = title;
				this.isTitleEdit = false;
			}

			if (field === 'status') {
				const status = this.selectedObjectiveStatusModel;
				if (!status) { showTopMessage('Please select a status', 'warning', 3000); return; }
				updated.status = status;
				this.isStatusEdit = false;
			}

			this.$emit('updateGroupObjective', updated);
		},
		onEditStatus : function () {
			if(!this.readOnlyView && this.teamBaseItemLink.teamId==0 && !this.objectiveGroup.isDefaultGroup && this.$options.permissions && this.$options.permissions.EDIT_OBJECTIVE_GROUP) {
				this.isStatusEdit = true;
			}	
		},
    },
});