const LIST_RISKS = Vue.component('list-risks', {

    name: 'list-risks',

    props: ["risksList", "riskRegisterList", "riskRegisterIdsListMap", "watcherList", "sessionBoards", "workFlows", "isLoading"],

    template: `
      <div class="container prow rskvw">
      	<div class="fltout DF">
            <div class="btns DF">
	            <a class="ftsb" :class="{active:filter.active}" href="javascript:void(0);" v-for="filter in searchFilters" :key="filter.id" @click="onFilterBtnClick(filter.text)">{{filter.text}}<span>({{filter.count}})</span></a>
	        </div>
	        <div class="FG"></div>
	        <div class="aa DF">
		        <div class="selectcont wht">
		            <select v-model="selectedBoard"  @change="filterByBoard">
		                <option value="All">All Boards</option>
		                <option v-for="board in sessionBoards" :value="board">{{getBoardTitle(board)}}</option>
		            </select>
		        </div>		      
		         <div class="selectcont wht">
		            <select v-model="selectedStatus"  @change="changeStatusFilter">
		                <option value="All" >Status</option>
		                <option v-bind:value="status.title" v-for="status in statuses">{{status.title }}</option>
		            </select>
		        </div>
		        <div class="selectcont wht">
		           <vz-select v-model="multiselectValues" :options="multiselectOptions" :multiple="true" label="name" track-by="name" @select="onColumnListUpdation()" />
		        </div>
		         <div class="srbtn p-rel ti-search">
		            <input type="text" v-model="findText" placeholder="Search Risk..." @input="onSelectFilter" />
		        </div>		        
	        </div>
        </div>
        <ul v-if="!_.isEmpty(risksGroupByRiskRegisterListMap)">
            <div class="container prow"> <a href="javascript:void(0);" class="p-abs opnal"  @click="expandAll" :class="{active:defaultCollapseFlag}"><div class="arric a FL"></div>Open All</a>
                <li v-for="riskRegister in riskRegisterList" :class="{register_title_active:collapseRegisterTitleMap[riskRegister.id]}" class="prow"  >
                      <div v-if="risksGroupByRiskRegisterListMap[riskRegister.id] && risksGroupByRiskRegisterListMap[riskRegister.id].length>0 && riskRegisterIdsListMap[riskRegister.id] && riskRegisterIdsListMap[riskRegister.id].sessionBoard" class="prow">
                          <h1 class="register-title" @click="toggleRegisterTitleCollapse(riskRegister.id)" ><div class="arric b FL"></div>{{riskRegister.registerName}},<a class="" :href="'/session?id='+riskRegister.sessionBoard.id" @click.stop="" target="_blank">{{getSessionBoardTitle(riskRegister)}}</a><span class="cnt ml-5">({{getBoardRisksCount(riskRegister.sessionBoard)}} Risks)</span></h1>
                           <risk-row-component
                               :riskRegister="riskRegister"
                               :riskids="riskIdsMap[riskRegister.id]"
                               :key="riskRegister.id"
                               :multiselectValues="multiselectValues"
                               :riskList="risksGroupByRiskRegisterListMap[riskRegister.id]"
                               @riskUpdated="updateRisk"
                               @onRiskDelete="deleteRisk"
                           />
                      </div>
                </li>
            </div>
        </ul>
         <div class="nofound prow" v-else>No Result Found</div>
         <div v-if="isLoading" class="loader"><div><div class="loaderinteg"></div>Loading...</div></div>
    </div>
   
	`,

    data() {
        return {
            risksGroupByRiskRegisterListMap: '',
            risksGroupByBoard: '',
            riskIdsMap: {},
            findText: '',
            activeSearchFilter: '',
            collapseRegisterTitleMap: {},
            searchFilters: {
                "All Risks": {id: 1, active: true, text: 'All Risks', count: 0},
                "Responsible": {id: 2, active: false, text: 'Responsible', count: 0},
                "Watcher": {id: 3, active: false, text: 'Watcher', count: 0}
            },
            collapseRegisterTitle: true,
            selectedStatus: "All",
            defaultCollapseFlag: true,
            selectedBoard: "All",
            _filteredRisksList: [],	
            filteredStatusAndSearchRisksList: [],
            multiselectOptions: [{"name": "Risk#", "value": "risk"}, {
                "name": "Risk Title",
                "value": "riskTitle"
            }, {"name": "Linked Items", "value": "linkedItems"}, {
                "name": "Risk Level",
                "value": "riskLevel"
            }, {"name": "Status", "value": "status"}, {
                "name": "Raised Date",
                "value": "raisedDate"
            }, {"name": "Resolution Date", "value": "resolutionDate"}, {
                "name": "Responsible",
                "value": "responsible"
            }, {"name": "Conversation", "value": "convCount"}, {"name": "Teams", "value": "team"}, {
                "name": "Sprints",
                "value": "sprint"
            }],
            multiselectValues: [{"name": "Risk#", "value": "risk"}, {
                "name": "Risk Title",
                "value": "riskTitle"
            }, {"name": "Linked Items", "value": "linkedItems"}, {
                "name": "Risk Level",
                "value": "riskLevel"
            }, {"name": "Status", "value": "status"}, {
                "name": "Raised Date",
                "value": "raisedDate"
            }, {"name": "Responsible", "value": "responsible"}, {
                "name": "Conversation",
                "value": "convCount"
            }, {"name": "Teams", "value": "team"}, {"name": "Sprints", "value": "sprint"}],
        }
    },

    computed: {
        getBoardRisksCount: function () {
            return function (board) {
                let _this = this;
                let count = 0;
                if(board){
                if (typeof _this.risksGroupByBoard[board.id] != "undefined") {
                    count = _this.risksGroupByBoard[board.id].length;
                }
                }
                return count;
            }
        },

        getSessionBoardTitle: function () {
            return function (riskRegister) {
                if (riskRegister.sessionBoard && riskRegister.sessionBoard.session) {
                    return riskRegister.sessionBoard.session.title;
                }
            }
        },

        getBoardTitle: function () {
            return function (board) {
                if (board.session) {
                    return board.session.title
                }
            }
        },


        statuses: function () {
            var _this = this;
            let workFlowStatuses = [];
            let workFlowStatusIdMap = {};
            _.forEach(_this.riskRegisterList, function (riskRegister) {
                if (riskRegister.workflow && riskRegister.workflow.id) {
                    _.forEach(_this.workFlows, function (workFLow) {
                        if (workFLow.id === riskRegister.workflow.id) {
                            _.forEach(workFLow.statuses, function (status) {
                                if (_.isEmpty(workFlowStatusIdMap[status.id])) {
                                    workFlowStatusIdMap[status.id] = status;
                                    workFlowStatuses.push(status)
                                }
                            })
                        }
                    })

                }
            })
            return workFlowStatuses;
        },
    },

    watch: {
        risksList: function (_newList, _oldList) {
            let _this = this;
            if (_newList && !(_newList.length > 0)) {
                return;
            }
            _.forEach(_newList, function (risk) {
                risk.showLinkedItems = false;
            })
            this.onSelectFilter();
        },

        riskRegisterList: function (_newList, _oldList) {
            let _this = this;
            if (typeof _newList != "undefined") {
                _.forEach(_newList, function (register) {
                    _this.collapseRegisterTitleMap[register.id] = _this.defaultCollapseFlag;
                });
            }
        },

        activeSearchFilter: function (_newFilter, _oldFilter) {
            this.onSelectFilter();
        },
    },

    mounted() {
        let _this = this;
        let columnList = localStorage.getItem("risksColumnList");
        if (columnList != undefined) {
            this.multiselectValues = JSON.parse(columnList);
        }
        this.onSelectFilter();

    },

    methods: {

        expandAll: function () {
            this.defaultCollapseFlag = !this.defaultCollapseFlag;
            let _this = this;
            if (typeof _this.riskRegisterList != "undefined") {
                _.forEach(_this.riskRegisterList, function (register) {
                    _this.collapseRegisterTitleMap[register.id] = _this.defaultCollapseFlag;
                });
            }
            this.$forceUpdate();
        },

        updateRisk: function (risk) {
            let _this = this;
            this.deleteRiskIfRequired(risk)
            _.remove(_this.risksList, {id: risk.id});
            _this.checkAndUpdateWatcherList(risk.watcherList);
            this.risksList.push(risk);
        },

        deleteRisk: function (id) {
            let _this = this;
            _.remove(_this.risksList, {id: id});
            this.onSelectFilter();
        },

        checkAndUpdateWatcherList: function (newWatcherList) {
            let _this = this;
            if (typeof newWatcherList != 'undefined' && newWatcherList.length > 0) {
                let userFilteredWatchers = _.filter(newWatcherList, function (watcher) {
                    return watcher.user.id === loggedInUser.id;
                });
                _.forEach(userFilteredWatchers, function (watcher) {
                    if (_.filter(_this.watcherList, {id: watcher.id}).length === 0) {
                        _this.watcherList.push(watcher)
                    }
                })
            }
        },

        deleteRiskIfRequired: function (risk) {
            let isResponsible = false, isWatcher = false;
            if (typeof risk.responsible != "undefined") {
                if (risk.responsible.id === loggedInUser.id) {
                    isResponsible = true;
                }
            }
            if (typeof risk.watcherList != "undefined") {
                if (risk.watcherList.length > 0) {
                    isWatcher = this.isStillWatcher(risk);
                }
            }
            if (!isResponsible && !isWatcher) {
                _.remove(this.risksList, {id: risk.id})
                this.onSelectFilter();
                return;
            }
        },

        onSelectFilter: function () {
            let risks = this.risksList;
            this.filterRisks();
            this.resetRolesCount();
            if (this.findText !== "" || this.selectedStatus !== "All" || this.selectedBoard !== "All") {
                risks = this.filteredStatusAndSearchRisksList;
            }
            this.populateCountOfRoles(risks)
            this.$forceUpdate();
        },

        filterRisks: function () {
            let _this = this;
            let risks = this.risksList;
            _this.filteredStatusAndSearchRisksList = [];
            this._filteredRisksList = [];
            if (_this.selectedStatus !== "All" && _this.selectedBoard !== "All" && _this.findText !== "") {
                let filteredByStatusRisks = _.filter(risks, function (risk) {
                    return risk.status.title === _this.selectedStatus;
                })
                risks = filteredByStatusRisks;
                _this.filteredStatusAndSearchRisksList = _.clone(risks);
                _this.filteredStatusAndSearchRisksList = [];

                let filteredByBoardRisks = _.filter(risks, function (risk) {
                    if (_this.riskRegisterIdsListMap[risk.riskRegister.id] && _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard)
                        return _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard.id === _this.selectedBoard.id;
                })
                risks = filteredByBoardRisks;
                _this.filteredStatusAndSearchRisksList = _.clone(risks);
                _this.filteredStatusAndSearchRisksList = [];

                _.forEach(risks, function (risk) {
                    if (
                        (risk.riskTitle.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        ((risk.riskRegister.registerKey.toLowerCase() + '-' + risk.riskNumber).indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.status.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.impact && risk.impact.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.probability && risk.probability.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.probability && risk.impact && _this.riskLevel(risk.probability, risk.impact, risk.riskRegister.riskMatrix).title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (getFormattedDate(risk.raisedDate).indexOf(_this.findText) !== -1) ||
                        (risk.resolutionDate && getFormattedDate(risk.resolutionDate).indexOf(_this.findText) !== -1)
                    ) {
                        _this._filteredRisksList.push(risk);
                        _this.filteredStatusAndSearchRisksList.push(risk);
                    }
                });
                if (risks.length == 0) {
                    _this.filteredStatusAndSearchRisksList = [];
                }
                risks = _this._filteredRisksList;
            } else if (_this.selectedStatus !== "All" && _this.selectedBoard !== "All") {
                let filteredByStatusRisks = _.filter(risks, function (risk) {
                    return risk.status.title === _this.selectedStatus;
                })
                risks = filteredByStatusRisks;
                _this.filteredStatusAndSearchRisksList = _.clone(risks);
                _this.filteredStatusAndSearchRisksList = [];

                let filteredByBoardRisks = _.filter(risks, function (risk) {
                    if (_this.riskRegisterIdsListMap[risk.riskRegister.id] && _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard)
                        return _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard.id === _this.selectedBoard.id;
                })
                risks = filteredByBoardRisks;
                _this.filteredStatusAndSearchRisksList = _.clone(risks);
            } else if (_this.selectedBoard !== "All" && _this.findText !== "") {
                let filteredByBoardRisks = _.filter(risks, function (risk) {
                    if (_this.riskRegisterIdsListMap[risk.riskRegister.id] && _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard)
                        return _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard.id === _this.selectedBoard.id;
                })
                risks = filteredByBoardRisks;
                _this.filteredStatusAndSearchRisksList = _.clone(risks);
                _this.filteredStatusAndSearchRisksList = [];
                _.forEach(risks, function (risk) {
                    if (
                        (risk.riskTitle.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        ((risk.riskRegister.registerKey.toLowerCase() + '-' + risk.riskNumber).indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.status.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.impact && risk.impact.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.probability && risk.probability.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.probability && risk.impact && _this.riskLevel(risk.probability, risk.impact, risk.riskRegister.riskMatrix).title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (getFormattedDate(risk.raisedDate).indexOf(_this.findText) !== -1) ||
                        (risk.resolutionDate && getFormattedDate(risk.resolutionDate).indexOf(_this.findText) !== -1)
                    ) {
                        _this._filteredRisksList.push(risk);
                        _this.filteredStatusAndSearchRisksList.push(risk);
                    }
                });
                if (risks.length == 0) {
                    _this.filteredStatusAndSearchRisksList = [];
                }
                risks = _this._filteredRisksList;
            } else if (_this.selectedStatus !== "All" && _this.findText !== "") {
                let filteredByStatusRisks = _.filter(risks, function (risk) {
                    return risk.status.title === _this.selectedStatus;
                })
                risks = filteredByStatusRisks;
                _this.filteredStatusAndSearchRisksList = _.clone(risks);
                _this.filteredStatusAndSearchRisksList = [];
                _.forEach(risks, function (risk) {
                    if (
                        (risk.riskTitle.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        ((risk.riskRegister.registerKey.toLowerCase() + '-' + risk.riskNumber).indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.status.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.impact && risk.impact.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.probability && risk.probability.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.probability && risk.impact && _this.riskLevel(risk.probability, risk.impact, risk.riskRegister.riskMatrix).title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (getFormattedDate(risk.raisedDate).indexOf(_this.findText) !== -1) ||
                        (risk.resolutionDate && getFormattedDate(risk.resolutionDate).indexOf(_this.findText) !== -1)
                    ) {
                        _this._filteredRisksList.push(risk);
                        _this.filteredStatusAndSearchRisksList.push(risk);
                    }
                });
                if (risks.length == 0) {
                    _this.filteredStatusAndSearchRisksList = [];
                }
                risks = _this._filteredRisksList;
            } else if (_this.selectedStatus !== "All") {
                let filteredByStatusRisks = _.filter(risks, function (risk) {
                    return risk.status.title === _this.selectedStatus;
                })
                risks = filteredByStatusRisks;
                _this.filteredStatusAndSearchRisksList = _.clone(risks);
            } else if (_this.selectedBoard !== "All") {
                let filteredByBoardRisks = _.filter(risks, function (risk) {
                    if (_this.riskRegisterIdsListMap[risk.riskRegister.id] && _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard)
                        return _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard.id === _this.selectedBoard.id;
                })
                risks = filteredByBoardRisks;
                _this.filteredStatusAndSearchRisksList = _.clone(risks);
            } else if (_this.findText !== "") {
                _.forEach(risks, function (risk) {
                    if (
                        (risk.riskTitle.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        ((risk.riskRegister.registerKey.toLowerCase() + '-' + risk.riskNumber).indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.status.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.impact && risk.impact.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.probability && risk.probability.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (risk.probability && risk.impact && _this.riskLevel(risk.probability, risk.impact, risk.riskRegister.riskMatrix).title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                        (getFormattedDate(risk.raisedDate).indexOf(_this.findText) !== -1) ||
                        (risk.resolutionDate && getFormattedDate(risk.resolutionDate).indexOf(_this.findText) !== -1)
                    ) {
                        _this._filteredRisksList.push(risk);
                        _this.filteredStatusAndSearchRisksList.push(risk);
                    }
                });
                risks = _this._filteredRisksList;
            }


            if (this.activeSearchFilter === "Responsible") {
                risks = _this.filterResultsByResponsible(risks);
            } else if (this.activeSearchFilter === "Watcher") {
                risks = _this.filterResultsByWatcher(risks)
            }
            _this._filteredRisksList = risks;
            _this.groupRisksByRiskRegister(risks);
        },


        filterResultsIfRequired: function () {
            let _this = this;
            let risks = [];
            if (_this.findText !== "") {
                _this.findRisks()
                risks = _this._filteredRisksList;
            } else {
                risks = _this.risksList;
            }
            if (_this.selectedStatus === "All") {
                _this._filteredRisksList = risks;
            } else {
                _this._filteredRisksList = _.filter(risks, function (risk) {
                    return risk.status.title === _this.selectedStatus;
                })
            }
            if (_this.selectedBoard !== "All") {
                _this._filteredRisksList = _.filter(risks, function (risk) {
                    if (_this.riskRegisterIdsListMap[risk.riskRegister.id] && _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard)
                        return _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard.id === _this.selectedBoard.id;
                })
            }
            if (_this.activeSearchFilter === "Responsible") {
                _this._filteredRisksList = _this.filterResultsByResponsible(_this._filteredRisksList);
            } else if (_this.activeSearchFilter === "Watcher") {
                _this._filteredRisksList = _this.filterResultsByWatcher(_this._filteredRisksList);
            }
        },

        filterResultsByResponsible: function (risks) {
            return _.filter(risks, function (risk) {
                if (typeof risk.responsible != "undefined") {
                    return risk.responsible.id === loggedInUser.id
                }
            })
        },

        filterResultsByWatcher: function (risks) {
            let _this = this;
            return _.filter(risks, function (risk) {
                let isMatched = false;
                if (risk.watcherList.length > 0) {
                    _.forEach(risk.watcherList, function (riskWatcher) {
                        if (_.filter(_this.watcherList, function (watcher) {
                            return watcher.id === riskWatcher.id
                        }).length > 0) {
                            isMatched = true;
                        }
                    })
                }
                return isMatched;
            })
        },

        filterResultsByCriteria: function () {
            let _this = this;
            let risks = [];
            if (_this.findText !== "") {
                risks = _this._filteredRisksList;
            } else {
                risks = _this.riskList;
            }
            if (_this.selectedStatus !== "All") {
                risks = _.filter(risks, function (risk) {
                    return risk.status.title === _this.selectedStatus;
                })
            }
            if (_this.selectedBoard !== "All") {
                risks = _.filter(risks, function (risk) {
                    if (_this.riskRegisterIdsListMap[risk.riskRegister.id] && _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard)
                        return _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard.id === _this.selectedBoard.id;
                })
            }
            let filteredRisksList = [];
            if (this.activeSearchFilter === "Responsible") {
                filteredRisksList = _this.filterResultsByResponsible(risks);
            } else if (this.activeSearchFilter === "Watcher") {
                filteredRisksList = _this.filterResultsByWatcher(risks)
            } else {
                filteredRisksList = risks
            }
            _this.groupRisksByRiskRegister(filteredRisksList);
        },
        onFilterBtnClick: function (filter) {
            let _this = this;
            _.forEach(_this.searchFilters, function (filter) {
                filter.active = false;
            })
            this.searchFilters[filter].active = true;
            this.activeSearchFilter = filter;
        },

        groupRisksByRiskRegister: function (list) {
            let _this = this;
            this.risksGroupByRiskRegisterListMap = "";
            this.risksGroupByBoard = "";
            this.riskIdsMap = {};
            this.risksGroupByRiskRegisterListMap = _.groupBy(list, function (risk) {
                if (risk.riskRegister && risk.riskRegister.id) {
                    return risk.riskRegister.id;
                }
            });
            _.forEach(_this.risksGroupByRiskRegisterListMap, function (value, key) {
                _this.risksGroupByRiskRegisterListMap[key] = _.orderBy(value, ['id'], ['asc']);
                _this.riskIdsMap[key] = [];
                _.forEach(value, function (val) {
                    _this.riskIdsMap[key].push(val.id);
                })
            });

            this.risksGroupByBoard = _.groupBy(list, function (risk) {
                if (risk && risk.riskRegister && _this.riskRegisterIdsListMap[risk.riskRegister.id] && _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard) {
                    return _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard.id;
                }
            });

        },

        changeStatusFilter: function () {
            let _this = this;
            this.onSelectFilter();
        },

        filterByBoard: function () {
            let _this = this;
            this.onSelectFilter();
        },

        toggleRegisterTitleCollapse: function (id) {
            let _this = this;
            this.collapseRegisterTitleMap[id] = !this.collapseRegisterTitleMap[id];
            this.$forceUpdate();
        },

        onColumnListUpdation: function () {
            localStorage.setItem('risksColumnList', JSON.stringify(this.multiselectValues));
        },

        riskLevel: function (probability, impact, riskMatrix) {
            riskMatrix.riskLevelList.sort((a, b) => (a.lowerLimit < b.lowerLimit) ? 1 : -1);
            let matrixList = (riskMatrix ? riskMatrix.riskLevelList : []);
            return this.calculateRiskLevel(probability, impact, matrixList);
        },

        calculateRiskLevel: function (probability, impact, matrixList) {
            return calculateRiskLevel(probability, impact, matrixList);
        },

        isStillWatcher: function (risk) {
            let _this = this;
            let isWatcher = false;
            _.forEach(risk.watcherList, function (itemWatcher) {
                if (_.filter(_this.watcherList, function (watcher) {
                    return watcher.id === itemWatcher.id
                }).length > 0) {
                    isWatcher = true;
                }
            });
            return isWatcher;
        },


        findRisks: function () {
            let _this = this;
            let risks = _this.risksList;
            _this._filteredRisksList = [];
            if (_this.selectedStatus !== "All") {
                risks = _.filter(risks, function (risk) {
                    return risk.status.title === _this.selectedStatus;
                })
            }
            if (_this.selectedBoard !== "All") {
                risks = _.filter(risks, function (risk) {
                    if (_this.riskRegisterIdsListMap[risk.riskRegister.id] && _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard)
                        return _this.riskRegisterIdsListMap[risk.riskRegister.id].sessionBoard.id === _this.selectedBoard.id;
                })
            }

            _.forEach(risks, function (risk) {
                if (
                    (risk.riskTitle.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                    ((risk.riskRegister.registerKey.toLowerCase() + '-' + risk.riskNumber).indexOf(_this.findText.toLowerCase()) !== -1) ||
                    (risk.status.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                    (risk.impact && risk.impact.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                    (risk.probability && risk.probability.title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                    (risk.probability && risk.impact && _this.riskLevel(risk.probability, risk.impact, risk.riskRegister.riskMatrix).title.toLowerCase().indexOf(_this.findText.toLowerCase()) !== -1) ||
                    (getFormattedDate(risk.raisedDate).indexOf(_this.findText) !== -1) ||
                    (risk.resolutionDate && getFormattedDate(risk.resolutionDate).indexOf(_this.findText) !== -1)
                ) {
                    _this._filteredRisksList.push(risk);
                }
            })
            if (this.activeSearchFilter === "Responsible") {
                _this._filteredRisksList = _this.filterResultsByResponsible(_this._filteredRisksList)
            } else if (this.activeSearchFilter === "Watcher") {
                _this._filteredRisksList = _this.filterResultsByWatcher(_this._filteredRisksList)
            }
            this.onSelectFilter();
        },

        resetRolesCount: function () {
            let _this = this;
            _.forEach(_this.searchFilters, function (filter) {
                filter.count = 0;
            })
        },

        populateCountOfRoles: function (list) {
            let _this = this;
            let filteredList = [];
            //calculate All Count
            let allCount = this.searchFilters["All Risks"].count;
            if (allCount > 0) {
                allCount = allCount + list.length;
            } else {
                if (list) {
                    allCount = list.length;
                }
            }
            this.searchFilters["All Risks"].count = allCount;

            //calculate responsible count
            let responsibleCount = this.searchFilters["Responsible"].count;
            filteredList = _.filter(list, function (risk) {
                if (typeof risk.responsible != "undefined") {
                    return risk.responsible.id === loggedInUser.id
                }
            })
            if (responsibleCount > 0) {
                responsibleCount = responsibleCount + filteredList.length;
            } else {
                responsibleCount = filteredList.length;
            }
            this.searchFilters["Responsible"].count = responsibleCount;

            filteredList = _.filter(list, function (risk) {
                let isMatched = false;
                if (risk.watcherList.length > 0) {
                    _.forEach(risk.watcherList, function (riskWatcher) {
                        if (_.filter(_this.watcherList, function (watcher) {
                            return watcher.id === riskWatcher.id
                        }).length > 0) {
                            isMatched = true;
                        }
                    })
                }
                return isMatched;
            });

            //calculate watcher count
            let watcherCount = this.searchFilters["Watcher"].count;
            if (watcherCount > 0) {
                watcherCount = watcherCount + filteredList.length;
            } else {
                watcherCount = filteredList.length;
            }
            this.searchFilters["Watcher"].count = watcherCount;
            this.$emit("onRiskCountUpdate", this.searchFilters["Responsible"].count);
        },


    }
});