const LIST_DEPENDENCIES = Vue.component('list-dependencies', {

    name: 'list-dependencies',

    props: ["itemLinkList", "almDependenciesList", "sessionBoardsMetaMap", "linkTypeList", "watcherList", "dependencyStatusesListMap", "isLoading"],

    template: `
    <div class="container prow">
    	<div class="fltout">
    	    <div class="btns DF">
	            <a class="ftsb" :class="{active:filter.active}" href="javascript:void(0);" v-for="filter in searchFilters" :key="filter.id" @click="onFilterBtnClick(filter.text)">{{filter.text}}<span class="count">({{filter.count}})</span></a>
	        </div>
	        <div class="FG"></div>
	        <div class="aa DF">
	        <div class="selectcont wht">
	            <select v-model="selectedStatus"  @change="changeStatusFilter">
	                <option value="All">All</option>
	                <option value="Open">Open</option>
	                <option value="Resolved">Closed</option>
	            </select>
	        </div>
	        <div class="srbtn p-rel ti-search">
	            <input type="search"  @input="onSelectFilter" v-model="searchText" @blur="onSelectFilter" placeholder="Search Dependency" aria-label="Search" />
	        </div>
	        </div>
        </div>
    	<div class="container prow">
    	<div class="dphead prow"><div class="dpico FL"></div> <div class="nam FL ftsb">Recent Boards</div> <a class="p-abs opnal" href="javascript:void(0);" @click="expandAll" :class="{active:defaultCollapseFlag}"><div class="arric a FL"></div>Open All</a></div>
        	<ul class="dpultp prow" v-if="(!_.isEmpty(itemLinksGroupBySprintListMap) || !_.isEmpty(almLinksGroupBySprintListMap))">
                <li class="mnlst prow" v-for="(board,key) in sessionBoardsMetaMap" v-if="isBoardDataAvailable(board.containers)" :key="key" :class="{board_title_active:collapseBoardTitleMap[board.id]}" >
                    <h1 class="board-title" @click="toggleBoardTitleCollapse(board.id)"><div class="arric b FL"></div><a class="" :href="'/session?id='+board.id" target="_blank" @click.stop="">{{board.session.title}}</a><span class="cnt ml-5">({{getBoardDependenciesCount(board.id)}})</span></h1>
                    <ul class="dependencytb">
                        <li class="sclst prow" v-for="container in board.containers" :key="container.id" :class="{sprint_title_active:collapseSprintTitleMap[container.id]}">
                            <h2 class="sprint-title c-point" v-if="itemLinksGroupBySprintListMap[container.id] || almLinksGroupBySprintListMap[container.id]" @click="toggleSprintTitleCollapse(container.id)"><div class="arric c FL"></div>{{container.title}}</h2>
                            <div v-if="itemLinksGroupBySprintListMap[container.id]" class="grpout prow dplist ndsn">
                                 
                                     <board-row-dependences 
                                         @edit="editDependencyLinkData"
                                         @delete="onDeleteLink"
                                         v-for="itemLink in itemLinksGroupBySprintListMap[container.id]"
                                         :meta="getMetaForRowComponent(itemLink,linkDataList[itemLink.id].sessionBoardObj)" 
                                         :activeBoard="linkDataList[itemLink.id].sessionBoardObj"
                                         :key="itemLink.id"
                                         :link-data="linkDataList[itemLink.id]" 
                                         :board-type="linkDataList[itemLink.id].sessionBoardObj.boardTypeText" 
                                         :type = "'trackingList'"
                                         :index="linkDataList[itemLink.id].index"
                                     />
                                 
                            </div>
                            <div class="grpout prow dplist ndsn ntvl mt" v-if="almLinksGroupBySprintListMap[container.id]">
                                 <div class="mrow">
                                     <row-alm-dependency 
                                         v-for="almLink in almLinksGroupBySprintListMap[container.id]"
                                         :key="almLink.id"
                                         :meta="getMetaForRowComponent(almLink,almLinkDataList[almLink.id].sessionBoardObj)" 
                                         :dependency = "almLinkDataList[almLink.id]" 
                                         :activeBoard="almLinkDataList[almLink.id].sessionBoardObj"
                                         :index="almLinkDataList[almLink.id].index" 
                                         :board-type="almLinkDataList[almLink.id].sessionBoardObj.boardTypeText"
                                         :link-types="getLinkTypes(almLink.id)"
                                         :type = "'trackingList'"
                                         @edit="onSelectEditAlmDependency"
                                         @deleteTfs="onSelectDeleteTFSDependency" 
                                         @deleteJira="onSelectDeleteJIRADependency"/>
                                 </div>
                            </div>
                        </li>
                    </ul>
                </li>
        	</ul>
        	  <div class="nofound prow" v-else>No Result Found</div>
        	  <div v-if="isLoading" class="loader">
			      <div>
					  <div class="loaderinteg"></div>Loading...
				  </div>
			  </div>
    	</div>
        <template v-if="showEditPopUp">
            <link-dialog :board="editData.board" :link-data="editData.linkData"
            :board-type="editData.boardType"
            :link-types="getLinkTypes(editData.linkData.id)"
            :kendisLinkTypes="linkTypeList['kendisLinkTypes']"
            :mode="1" @close="onCloseEditPopUp" @save="onSaveLink"
             @delete="onDeleteLink"
             @remove-tfslink="onDeleteTFSLink"></link-dialog>
       </template>
        
    </div>
   
	`,

    data() {
        return {
            itemLinksGroupBySprintListMap: '',
            almLinksGroupBySprintListMap: '',
            almLinksGroupByBoard: '',
            itemLinksGroupByBoard: '',
            linkDataList: {},
            almLinkDataList: {},
            tfsLinkDataList: {},
            tfsLinksGroupByAlmAccountIdMap: {},
            almLinkIds: {},
            showEditPopUp: false,
            defaultCollapseFlag: true,
            deleteLinkData: '',
            editData: {
                board: '',
                boardType: '',
                linkData: ''
            },
            selectedStatus: "All",
            activeSearchFilter: '',
            searchText: '',
            collapseBoardTitleMap: {},
            collapseSprintTitleMap: {},
            filteredItemLinks: [],
            filteredAlmLinks: [],
            filteredStatusAndSearchAlmLinksList: [],
            filteredStatusAndSearchItemLinksList: [],
            searchFilters: {
                "All Dependencies": {id: 1, active: true, text: 'All Dependencies', count: 0},
                "Responsible": {id: 2, active: false, text: 'Responsible', count: 0},
                "Reporter": {id: 3, active: false, text: 'Reporter', count: 0},
                "Watcher": {id: 4, active: false, text: 'Watcher', count: 0}
            },
            shouldFetchTfsMetaInfo: false,
        }
    },

    computed: {
        getBoardDependenciesCount: function () {
            return function (id) {
                let _this = this;
                let count = 0;
                if (typeof _this.itemLinksGroupByBoard[id] != "undefined") {
                    count += _this.itemLinksGroupByBoard[id].length;
                }
                if (typeof _this.almLinksGroupByBoard[id] != "undefined") {
                    count += _this.almLinksGroupByBoard[id].length;
                }
                return count;
            }
        },

        isBoardDataAvailable: function () {
            return function (sprints) {
                let _this = this;
                let isPresent = false;
                _.forEach(sprints, function (sprint) {
                    if (_this.itemLinksGroupBySprintListMap[sprint.id]) {
                        isPresent = true;
                    } else if (_this.almLinksGroupBySprintListMap[sprint.id]) {
                        isPresent = true;
                    }
                });
                return isPresent;
            }
        },
    },

    watch: {
        itemLinkList: function (_newList, _oldList) {
            let _this = this;
            if (_newList && !(_newList.length > 0)) {
                return;
            }
            this.onSelectFilter();
        },

        almDependenciesList: function (_newList, _oldList) {
            let _this = this;
            if (_newList && !(_newList.length > 0) && this.itemLinkList.length == 0) {
                return;
            }
            this.shouldFetchTfsMetaInfo = true;
            this.filterAlmDependencies(_newList);
            this.onSelectFilter();
        },

        sessionBoardsMetaMap: function (_newMap, _oldMap) {
            let _this = this;
            if (typeof _newMap != "undefined") {
                _.forEach(_newMap, function (board) {
                    _this.collapseBoardTitleMap[board.id] = _this.defaultCollapseFlag;
                    _.forEach(board.containers, function (container) {
                        _this.collapseSprintTitleMap[container.id] = _this.defaultCollapseFlag;
                    })
                });
            }
        },

        activeSearchFilter: function (_newFilter, _oldFilter) {
            this.onSelectFilter();
        },
    },

    mounted() {
        this.onSelectFilter();
    },

    methods: {
        getMetaForRowComponent: function (itemLink, board) {
            if ((this.$options.metaForTfs == null) || (this.$options.metaForJira == null)) {

                let meta = {};
                let linkTypes = _.clone(this.getLinkTypes(itemLink.id));
                if (linkTypes) {
                    if (board && board.boardTypeText === "TFS") {
                        meta.tfsLinksTypes = linkTypes;
                        this.$options.metaForTfs = meta;
                    } else if (board && board.boardTypeText === "JIRA") {
                        meta.linkTypes = linkTypes;
                        if (typeof board.session != "undefined" && typeof board.session.jiraLinkTypes != "undefined") {
                            computeBoardLinkTypes(board.session.jiraLinkTypes, linkTypes, meta.linkTypes)
                        }
                        if (typeof meta.linkTypes == "undefined" || meta.linkTypes.length == 0) {
                            meta.linkTypes = linkTypes;
                        }
                        this.$options.metaForJira = meta;
                    } else {
                        meta.itemLinkTypes = linkTypes;
                        this.$options.metaForJira = meta;
                    }
                }
                if (board && board.boardTypeText === "JIRA") {
                    meta.isJira = true;
                    meta.itemLinkTypes = meta.linkTypes;
                    this.$options.metaForJira = meta;
                }
            }
            if (board && board.boardTypeText === "TFS") {
                return this.$options.metaForTfs;
            } else {
                return this.$options.metaForJira;
            }
        },
        expandAll: function () {
            this.defaultCollapseFlag = !this.defaultCollapseFlag;
            let _this = this;
            if (typeof _this.sessionBoardsMetaMap != "undefined") {
                _.forEach(_this.sessionBoardsMetaMap, function (board) {
                    _this.collapseBoardTitleMap[board.id] = _this.defaultCollapseFlag;
                    _.forEach(board.containers, function (container) {
                        _this.collapseSprintTitleMap[container.id] = _this.defaultCollapseFlag;
                    });
                });
            }
            this.$forceUpdate();
        },

        toggleBoardTitleCollapse: function (id) {
            let _this = this;
            this.collapseBoardTitleMap[id] = !this.collapseBoardTitleMap[id];
            this.$forceUpdate();
        },
        toggleSprintTitleCollapse: function (id) {
            let _this = this;
            this.collapseSprintTitleMap[id] = !this.collapseSprintTitleMap[id];
            this.$forceUpdate();
        },
        filterAlmDependencies: function (list) {
            let _this = this;
            _.forEach(list, function (link) {
                if (link.isTFS) {
                    link.fakeLinkId = _this.getAlmLinkCompositeKey(link);
                }
            })
            let almLinksMap = {};
            let duplicateList = _.clone(list)
            _.forEach(duplicateList, function (link) {
                if (link.isTFS) {
                    if (link.tfsLinkType.endsWith("Forward")) {
                        if (almLinksMap[link.fakeLinkId]) {
                            _.remove(list, {id: link.id});
                        }
                        almLinksMap[link.fakeLinkId] = true;
                    } else if (link.tfsLinkType.endsWith("Reverse")) {
                        if (typeof almLinksMap[link.fakeLinkId] == "undefined") {
                            almLinksMap[link.fakeLinkId] = true;
                        } else {
                            _.remove(list, {id: link.id});
                        }
                    }
                } else {
                    if (link.direction === "OUT") {
                        if (almLinksMap[link.jiraDependencyId]) {
                            _.remove(list, {id: link.id});
                        }
                        almLinksMap[link.jiraDependencyId] = true;
                    } else if (link.direction === "IN") {
                        if (typeof almLinksMap[link.jiraDependencyId] == "undefined") {
                            almLinksMap[link.jiraDependencyId] = true
                        } else {
                            _.remove(list, {id: link.id});
                        }
                    }
                }
            })
        },
        getAlmLinkCompositeKey: function (almLink) {
            if (almLink.targetJiraIssue != undefined && almLink.targetJiraIssue.id != undefined) {
                return almLink.jiraDependencyId;
            }
            var sourceId = parseInt(almLink.sourceTFSItem.tfsId);
            var targetId = parseInt(almLink.targetTFSItem.tfsId);
            if (sourceId < targetId) {
                return almLink.sourceTFSItem.tfsId + almLink.targetTFSItem.tfsId;
            } else {
                return almLink.targetTFSItem.tfsId + almLink.sourceTFSItem.tfsId;
            }
        },
        onFilterBtnClick: function (filter) {
            let _this = this;
            _.forEach(_this.searchFilters, function (filter) {
                filter.active = false;
            })
            this.searchFilters[filter].active = true;
            this.activeSearchFilter = filter;
        },

        onCloseEditPopUp: function () {
            this.editData.linkData = {};
            this.showEditPopUp = false;
        },

        saveJiraLink: function (jiraLink) {
            var _this = this;
            var data;
            data = jiraLink.link;
            data.type = jiraLink.type;
            if (jiraLink.jiraDependencyId) {
                data.jiraDependencyId = jiraLink.jiraDependencyId;
            }
            if (!data.id) {
                data.id = jiraLink.id;
            }
            if (data.isJira) {
                delete data.isJira;
            }
            var requestBody = {};
            requestBody.jiraLink = JSON.stringify(data);

            // creating Item
            var item = {
                id: jiraLink.sItem.id,
                jiraId: jiraLink.sItem.jiraId,
                type: jiraLink.sItem.type,
                itemLinks: jiraLink.sItem.itemLinks,
                jiraDependencies: jiraLink.sItem.jiraDependencies
            };

            requestBody.item = JSON.stringify(item);
            axios.post('/plan/save/jiralink', requestBody)
                .then(response => {
                    if (response.data) {
                        let linkData;
                        if (response.data.jiraLink) {
                            linkData = $.each(response.data.jiraLink, function (link) {
                                if (typeof _this.almLinkDataList[link.id] != "undefined") {
                                    return _this.almLinkDataList[link.id];
                                }
                            });
                        }
                        if (linkData.length > 0) {
                            let data = linkData[0];
                            if (!_.filter(_this.almDependenciesList, {id: data.id})[0]) {
                                data = linkData[1];
                            }
                            if (data.watcherList.length > 0) {
                                _this.checkIfWatcherListIsUpdated(data.watcherList);
                            }
                            _this.deleteAlmLinkIfRequired(data)
                            _this.updateAlmItemLink(data);
                            _this.onCloseEditPopUp();
                            showTopMessage("Dependency has been updated.", "success");
                        }
                    }
                })
                .catch(error => {
                    showTopMessage("Dependency not Saved", "error");
                    console.log("Dependency Save Error---" + error);
                });
        },

        onSelectDeleteTFSDependency: function (dependency, index, id) {
            let item = dependency.sItem;
            askFromSweetAlertWrapper('If you wish to proceed with this action, then the link will also be deleted from your Azure Devops Project', [this.onDeleteTFSDependency, [item, dependency, index, id]], [takeNoAction]);
        },

        onDeleteTFSDependency: function (data) {
            let _this = this;
            var item = data[0];
            var dependency = data[1].link;

            var _item = {id: item.id, jiraDependencies: [{id: dependency.id}]};
            var metaMap = {};
            metaMap.boardId = dependency.sessionBoardId;
            metaMap.event = "TFSLinkRemove";
            metaMap.linkId = dependency.id;
            if (typeof syncId != "undefined") {
                metaMap.syncId = syncId;
            }
            metaMap.boardType = "tfs";
            metaMap.type = "Feature";

            _item.metaMap = JSON.stringify(metaMap);

            axios.post('/pi/remove/tfslink', _item)
                .then(response => {
                    if (response.status == 200 && response.data) {
                        _.remove(_this.almDependenciesList, {id: dependency.id})
                        this.onSelectFilter();
                    }
                })
                .catch(error => {
                    showTopMessage("Dependency Deletion Failed", "error");
                    console.log("Alm Dependency Delete Error-----" + error);
                });
        },

        onConfirmDeleteJIRADependency: function (item) {
            var _this = this;
            var dependency = item[0].link;
            var data = {};
            data.id = dependency.id;
            data.jiraId = dependency.jiraDependencyId;
            data.itemId = dependency.sourceItemId;
            data.syncId = syncId;
            data.sessionBoardId = dependency.sessionBoardId;
            data.almAccountId = _this.getBoardById(dependency.sessionBoardId).session.almConfigurations[0].almAccount.id;

            axios.post('/plan/deleteJiraDependency', data)
                .then(response => {
                    if (response.data) {
                        _.forEach(response.data.removedLinksIds, function (id) {
                            _.remove(_this.almDependenciesList, {id: id})
                        });
                        this.onSelectFilter();
                        this.onCloseEditPopUp();
                        showTopMessage("Dependency removed", 'success');
                    }
                }).catch(error => {
                showTopMessage("Dependency deletion Failed", "error");
            });


        },


        onSaveTfsLink: function (info) {
            var _this = this;
            var link;
            link = info.link;

            if (link.targetItemTitle)
                delete link.targetItemTitle;
            if (link.tStatus)
                delete link.tStatus;
            if (link.tProjectName)
                delete link.tProjectName;
            if (link.tItemType)
                delete link.tItemType;
            if (link.sourceItem)
                delete link.sourceItem;
            if (link.targetItem)
                delete link.targetItem;

            if (link.fakeLinkId)
                delete link.fakeLinkId;

            axios.post('/pi/save/tfslink', link)
                .then(response => {
                    if (response.data) {
                        let linkData = response.data.linksToSave[0];
                        if (!_.filter(_this.almDependenciesList, {id: linkData.id})[0]) {
                            linkData = response.data.linksToSave[1];
                        }
                        _this.checkIfWatcherListIsUpdated(linkData.watcherList);
                        _this.deleteAlmLinkIfRequired(linkData)
                        _this.updateAlmItemLink(linkData);
                        _this.onCloseEditPopUp();
                        showTopMessage("Dependency has been updated.", "success");
                    }
                })
                .catch(error => {
                    showTopMessage("Dependency not Saved", "error");
                    console.log("Dependency Save Error---" + error);
                });
        },

        onSaveLink: function (linkData) {
            let _this = this;
            if (linkData.isTfs) {
                this.onSaveTfsLink(linkData);
            } else if (typeof _this.almLinkDataList[linkData.id] != "undefined") {
                this.saveJiraLink(linkData);
            } else if (linkData && linkData.linkData && linkData.linkData.link) {
                _.forEach(linkData.links, function (itemLink) {
                    _this.checkIfWatcherListIsUpdated(itemLink.watcherList);
                    if (_this.deleteLinkIfRequired(itemLink))
                        return
                    _this.updateItemLink(itemLink);
                })
            } else {
                let data = {};
                let itemLinks = [];
                linkData.link.sourceItem = "";
                linkData.link.targetItem = "";
                linkData.link.type = linkData.type;
                itemLinks.push(linkData.link)
                data.item = JSON.stringify({id: linkData.sItem.id, itemLinks: itemLinks});
                // save Jira Link
                axios.post('/my-view/save/dependency', data)
                    .then(response => {
                        if (response.data) {
                            let itemLink = response.data.link;
                            _this.checkIfWatcherListIsUpdated(itemLink.watcherList);
                            if (_this.deleteLinkIfRequired(itemLink))
                                return
                            _this.updateItemLink(itemLink);
                            _this.onCloseEditPopUp();
                            showTopMessage("Dependency has been updated.", "success");
                        }
                    })
                    .catch(error => {
                        showTopMessage("Dependency not Saved", "error");
                        console.error("Dependency Ssave error", error);
                    });
            }

        },

        deleteLinkIfRequired: function (itemLink) {
            let isResponsible = false, isReporter = false, isWatcher = false;
            if (typeof itemLink.responsible != "undefined") {
                if (itemLink.responsible.id === loggedInUser.id) {
                    isResponsible = true;
                }
            }
            if (typeof itemLink.reporter != "undefined") {
                if (itemLink.reporter.id === loggedInUser.id) {
                    isReporter = true;
                }
            }
            if (typeof itemLink.watcherList != "undefined") {
                if (itemLink.watcherList.length > 0) {
                    isWatcher = this.isStillWatcher(itemLink);
                }
            }
            if (!isResponsible && !isReporter && !isWatcher) {
                _.remove(this.itemLinkList, {id: itemLink.id})
                this.onSelectFilter();
                this.onCloseEditPopUp();
                showTopMessage("Dependency Removed because it was unrelated to user.", 'success');
                return true;
            }
            return false;
        },

        deleteAlmLinkIfRequired: function (almLink) {
            let isResponsible = false, isReporter = false, isWatcher = false;
            if (typeof almLink.responsible != "undefined") {
                if (almLink.responsible.id === loggedInUser.id) {
                    isResponsible = true;
                }
            }
            if (typeof almLink.reporter != "undefined") {
                if (almLink.reporter.id === loggedInUser.id) {
                    isReporter = true;
                }
            }
            if (typeof almLink.watcherList != "undefined") {
                if (almLink.watcherList.length > 0) {
                    isWatcher = this.isStillWatcher(almLink);
                }
            }
            if (!isResponsible && !isReporter && !isWatcher) {
                _.remove(this.almDependenciesList, {id: almLink.id})
                this.onSelectFilter();
                this.onCloseEditPopUp();
                showTopMessage("Dependency Removed because it was unrelated to user.", 'success');
                return;
            }
        },

        isStillWatcher: function (itemLink) {
            let _this = this;
            let isWatcher = false;
            _.forEach(itemLink.watcherList, function (itemWatcher) {
                if (_.filter(_this.watcherList, function (watcher) {
                    return watcher.id === itemWatcher.id
                }).length > 0) {
                    isWatcher = true;
                }
            });
            return isWatcher;
        },

        updateItemLink: function (linkData) {
            let _this = this;
            let existingItemLink = _.remove(_this.itemLinkList, {id: linkData.id})[0]
            linkData.sourceItem = existingItemLink.sourceItem;
            linkData.targetItem = existingItemLink.targetItem;
            this.itemLinkList.push(linkData);
        },

        updateAlmItemLink: function (linkData) {
            let _this = this;
            let existingItemLink = _.remove(_this.almDependenciesList, {id: linkData.id})[0]
            linkData.sourceItem = existingItemLink.sourceItem;
            linkData.targetItem = existingItemLink.targetItem;
            this.almDependenciesList.push(linkData);
        },

        checkIfWatcherListIsUpdated: function (newWatcherList) {
            let _this = this;
            if (typeof newWatcherList != 'undefined' && newWatcherList.length > 0) {
                let userFilteredWatchers = _.filter(newWatcherList, function (watcher) {
                    return watcher.user.id === loggedInUser.id;
                });
                _.forEach(userFilteredWatchers, function (watcher) {
                    if (_.filter(_this.watcherList, {id: watcher.id}).length === 0) {
                        _this.watcherList.push(watcher)
                    }
                })
            }
        },

        onDeleteLinkConfirm: function () {
            let _this = this;
            let linkData = this.deleteLinkData;
            let data = {};
            var removeAlmLinkCheck = $("#confirm-delete").is(":checked");
            if (typeof linkData.link.link != "undefined") {
                linkData.link.link.removeAlmLink = removeAlmLinkCheck;
                data.id = linkData.item.id;
                data.itemLinks = [];
                data.itemLinks.push({
                    id: linkData.link.link.id,
                    removeAlmLink: removeAlmLinkCheck,
                    sourceTeamContainerId: linkData.link.link.sourceTeamContainerId,
                    targetTeamContainerId: linkData.link.link.targetTeamContainerId
                });
            } else {
                linkData.link.removeAlmLink = removeAlmLinkCheck;
                data.id = linkData.link.sourceItemId;
                data.itemLinks = [];
                data.itemLinks.push({
                    id: linkData.link.id,
                    removeAlmLink: removeAlmLinkCheck,
                    sourceTeamContainerId: linkData.link.sourceTeamContainerId,
                    targetTeamContainerId: linkData.link.targetTeamContainerId
                });
            }
            var metaMap = {};
            metaMap.boardId = data.itemLinks[0].sessionBoardId;
            metaMap.syncId = syncId;
            metaMap.event = "LinkRemove";
            metaMap.source = "handle-" + data.itemLinks[0].sourceTeamContainerId;
            metaMap.target = "handle-" + data.itemLinks[0].targetTeamContainerId;
            data.metaMap = JSON.stringify(metaMap);
            axios.post('/plan/remove/link', data)
                .then(response => {
                    if (response.data) {
                        _.remove(_this.itemLinkList, {id: response.data.LinkId})
                        _this.onSelectFilter();
                        _this.onCloseEditPopUp();
                        showTopMessage("Dependency removed", 'success');
                    }
                })
                .catch(error => {
                    showTopMessage("Dependency deletion error", "error");
                    console.error("Dependencies deletion error", error);
                });
        },

        onSelectDeleteJIRADependency: function (dependency) {
            askFromSweetAlertWrapper('If you wish to proceed with this action, then the link will also be deleted from your Jira Project', [this.onConfirmDeleteJIRADependency, [dependency]], [takeNoAction]);
        },

        checkIfJiraAlmLink: function (id) {
            let _this = this;
            if (_.filter(_this.almDependenciesList, {id: id})[0]) {
                return true;
            }
            return false;
        },

        onDeleteLink: function (linkData) {
            var showCheckBox = false;
            var showDeleteFromJiraText = false;
            if (linkData.isTFS) {
                this.onSelectDeleteTFSDependency(linkData);
                return;
            } else if (this.checkIfJiraAlmLink(linkData.id)) {
                this.onSelectDeleteJIRADependency(linkData);
                return;
            } else {
                //If not TFS i.e JIRA or KENDIS
                if (linkData.tfsDep != true) {
                    let data = linkData.link.link;
                    if (!data) {
                        data = linkData.link;
                    }
                    if (data && data.almLinkId) {
                        showCheckBox = true;
                    }

                    if (data && data.jiraDependencyId) {
                        showDeleteFromJiraText = true;
                    }

                    this.deleteLinkData = linkData;

                    if (showCheckBox) {
                        askFromSweetAlertWrapper('Do you want to remove this link from your Kendis Board?</br> <div class="custom-checkbox light mt-5"><input id="confirm-delete" type="checkbox" checked="' + linkData.link.removeAlmLink + '" /> <label for="confirm-delete">This link will also be deleted from your configured JIRA Project</label></div>', [this.onDeleteLinkConfirm, ""], [takeNoAction]);
                        return;
                    }
                    if (showDeleteFromJiraText) {
                        askFromSweetAlertWrapper("If you wish to proceed with this action, then the link will also be deleted from your Jira Project", [this.onDeleteLinkConfirm, ""], [takeNoAction]);
                        return;
                    }
                    if (!showCheckBox && !showDeleteFromJiraText) {
                        askFromSweetAlertWrapper('Do you want to remove this link from your Kendis Board?', [this.onDeleteLinkConfirm, ""], [takeNoAction]);
                    }
                } else {
                    // if TFS DEPENDENCY
                    _.remove(this.itemLinkList, {id: linkData.link.id})
                    this.onSelectFilter();
                    this.onCloseEditPopUp();
                    showTopMessage("Dependency Removed", 'success');
                }
            }
        },

        onDeleteTFSLink: function (linkData) {
            let link = linkData.link;
            _.remove(this.almDependenciesList, {id: link.id})
            this.onSelectFilter();
            this.onCloseEditPopUp();
            showTopMessage("Dependency Removed", 'success');
        },

        onSelectEditAlmDependency: function (dependency) {
            if (typeof dependency != "undefined" && typeof dependency.link != "undefined" && typeof dependency.link.isTFS != "undefined" && dependency.link.isTFS) {
                this.onEditTfsDependency(dependency);
                return;
            } else {
                this.onEditJiraDependency(dependency);
                return;
            }
        },

        copyLinkAttributes: function (existingLink, newLink) {

            existingLink.title = newLink.title;
            existingLink.status = newLink.status;
            existingLink.wfStatus = newLink.wfStatus;
            existingLink.dueDate = newLink.dueDate;
            existingLink.responsible = newLink.responsible;
            existingLink.description = newLink.description;
            existingLink.resolvedOn = newLink.resolvedOn;
            existingLink.watcherList = newLink.watcherList;
            existingLink.reporter = newLink.reporter;
            existingLink.conversations = newLink.conversations;
            existingLink.raisedOn = newLink.raisedOn;
            existingLink.richDescription = newLink.richDescription;
            existingLink.statusManuallySet = newLink.statusManuallySet;
            existingLink.sessionBoardId = newLink.sessionBoardId;
            existingLink.lineDirectionSaveAs = newLink.lineDirectionSaveAs;
            if (newLink.initialTargetSprintId) {
                existingLink.initialTargetSprintId = newLink.initialTargetSprintId;
            }
            if (newLink.almLinkId) {
                existingLink.almLinkId = newLink.almLinkId;
            }
            if (newLink.direction && newLink.id == existingLink.id) {
                existingLink.direction = newLink.direction;
            }
            existingLink.lineDirection = newLink.lineDirection;
        },


        onEditJiraDependency: function (dependency, openConversation) {
            if (dependency.isCommentBtnClick) {
            }
            var linkData = {};
            var link = {};
            var dependencyStatus;
            link.id = dependency.link.id;
            link.jiraDependencyId = dependency.link.jiraDependencyId;
            this.copyLinkAttributes(link, dependency.link);
            if (dependency.link.statusManuallySet) {     // if dependency has been updated before
                this.copyLinkAttributes(link, dependency.link);
            } else {
                if (dependency.link.wfStatus) {
                    dependencyStatus = dependency.link.wfStatus;
                }
            }
            if (dependency.link.sourceItemId) {
                link.sourceItemId = dependency.link.sourceItemId;
            }
            if (dependency.link.targetItemId) {
                link.targetItemId = dependency.link.targetItemId;
            }

            linkData = {
                id: dependency.link.id,
                sItem: dependency.sItem,
                tItem: dependency.tItem,
                isJira: dependency.link.isJira,
                type: dependency.jiraType,
                link: link,
                tTeam: {},
                dependencyStatus: dependencyStatus,
                sourceTeamAndSprint: dependency.sourceItemTeamAndSprint,
                targetTeamAndSprint: dependency.targetItemTeamAndSprint,
                jiraDependencyId: dependency.link.jiraDependencyId,
                sessionBoardId: dependency.link.sessionBoardId,
                sessionBoardObj: dependency.sessionBoardObj,
            }
            this.editData.linkData = JSON.parse(JSON.stringify(linkData));
            this.editData.board = dependency.sessionBoardObj;
            this.editData.board.dependencyStatuses = this.dependencyStatusesListMap[this.editData.board.id];
            this.editData.boardType = dependency.sessionBoardObj.boardTypeText
            this.showEditPopUp = true;

        },


        onEditTfsDependency: function (dependency) {
            let linkData = {};
            if (!dependency.link.statusManuallySet) {		// first time opening tfs dependency
                dependency.link.reporter = {};
                dependency.link.reporter = _.find(this.$options.meta.users, user => {
                    if (user.id == loggedInUser.id) {
                        return user;
                    }
                });
                dependency.link.raisedOn = new Date();
                dependency.conversationCounter = 0;
            }
            if (!dependency.tItem) {
                let tItem = {
                    title: dependency.link.targetTFSItem.title,
                    tfsId: dependency.link.targetTFSItem.tfsId,
                    tfsURL: dependency.link.targetTFSItem.url
                };
                dependency.tItem = tItem;
            }
            linkData = {
                id: dependency.link.id,
                sItem: dependency.sItem,
                tItem: dependency.tItem,
                isTfs: dependency.link.isTFS,
                type: dependency.linkType,
                link: dependency.link,
                tTeam: {},
                sessionBoardObj: dependency.sessionBoardObj,
                sourceTeamAndSprint: dependency.sourceItemTeamAndSprint,
                targetTeamAndSprint: dependency.targetItemTeamAndSprint
            }
            this.editData.linkData = JSON.parse(JSON.stringify(linkData));
            this.editData.board = dependency.sessionBoardObj;
            this.editData.board.dependencyStatuses = this.dependencyStatusesListMap[this.editData.board.id];
            this.editData.boardType = dependency.sessionBoardObj.boardTypeText
            this.showEditPopUp = true;
        },

        editDependencyLinkData: function (dependency) {
            let id = dependency.link.id;
            let type = dependency.link.type;
            let status = dependency.link.status;
            let description = dependency.link.description;
            let linkData = {};

            linkData = {
                sItem: dependency.sItem,
                sTeam: dependency.sTeam,
                sSprint: dependency.sSprint,
                sTCId: dependency.link.sourceTeamContainerId,
                tItem: dependency.tItem,
                tTeam: dependency.tTeam,
                tSprint: dependency.tSprint,
                tTCId: dependency.link.targetTeamContainerId,
                link: dependency.link,
                id: id,
                type: type,
                status: status,
                description: description,
                noSTc: dependency.noSourceTc,
                noTTc: dependency.noTargetTc,

                noSSprint: dependency.noSourceSprint,
                noTSprint: dependency.noTargetSprint,

                noSTeam: dependency.noSourceTeam,
                noTTeam: dependency.noTargetTeam,

                noSItem: dependency.noSourceItem,
                noTItem: dependency.noTargetItem,
                lost: dependency.lost,
                reverseDirection: dependency.reverseDirection,
                sessionBoardObj: dependency.sessionBoardObj,
            };
            this.editData.linkData = JSON.parse(JSON.stringify(linkData));
            this.editData.board = dependency.sessionBoardObj;
            this.editData.board.dependencyStatuses = this.dependencyStatusesListMap[this.editData.board.id];
            this.editData.boardType = dependency.sessionBoardObj.boardTypeText
            this.showEditPopUp = true;
        },

        getLinkTypes: function (linkId) {
            let _this = this;
            let session;
            if (typeof _this.linkDataList[linkId] != "undefined") {
                session = _this.linkDataList[linkId].sessionBoardObj.session;
            } else if (typeof _this.almLinkDataList[linkId] != "undefined") {
                session = _this.almLinkDataList[linkId].sessionBoardObj.session;
            }
            if (session && session.almEnabled) {
                if (typeof session.tfsAlmConfigurations !== "undefined") {
                    return JSON.parse(_this.linkTypeList[session.tfsAlmConfigurations.almAccount.id]).value;
                } else if (typeof session.almConfigurations !== "undefined") {
                    return _this.linkTypeList[session.almConfigurations[0].almAccount.id];
                }
            } else {
                return _this.linkTypeList["kendisLinkTypes"];
            }
        },

        populateLinkDataList: function (itemLinks) {
            let _this = this;
            _this.linkDataList = {}
            _.forEach(itemLinks, function (itemLink, index) {
                let dependencyId = _this.getDependencyId(itemLink)
                let sSprint = "";
                let tSprint = "";
                let tTeam = "";
                let sTeam = "";
                if (itemLink && typeof itemLink.sourceItem != "undefined" && itemLink.sourceItem.teamContainers.length > 0) {
                    sSprint = itemLink.sourceItem.teamContainers[0].container
                }
                if (itemLink && typeof itemLink.targetItem != "undefined" && itemLink.targetItem.teamContainers.length > 0) {
                    tSprint = itemLink.targetItem.teamContainers[0].container
                }
                if (itemLink && typeof itemLink.sourceItem != "undefined" && itemLink.sourceItem.teamContainers.length > 0) {
                    sTeam = itemLink.sourceItem.teamContainers[0].team
                }
                if (itemLink && typeof itemLink.targetItem != "undefined" && itemLink.targetItem.teamContainers.length > 0) {
                    tTeam = itemLink.targetItem.teamContainers[0].team
                }
                let itemLinkBoard = _this.getBoardById(itemLink.sessionBoardId);
                if (typeof itemLink.targetItem != "undefined") {
                    var _base = getBoardBaseUrl(itemLinkBoard);
                    itemLink.targetItem.jiraURL = _base ? (_base + '/' + itemLink.targetItem.jiraKey) : 'javascript:void(0);';
                }
                _this.linkDataList[itemLink.id] = {
                    depId: dependencyId, // index: index,
                    index: '', link: itemLink, // reverseDirection:,//Todo determine direction bool
                    sItem: itemLink.sourceItem,
                    tItem: itemLink.targetItem,
                    sSprint: sSprint,
                    tSprint: tSprint,
                    sTeam: sTeam,
                    tTeam: tTeam,
                    status: itemLink.wfStatus.title,
                    type: itemLink.type,
                    tempAlmLinkType: itemLink.type,
                    sessionBoardObj: itemLinkBoard
                }
            })
        },

        populateAlmLinkDataList: function (almLinks) {
            let _this = this;
            _this.almLinkDataList = {}
            _.forEach(almLinks, function (almLink, index) {
                let almLinkBoard = _this.getBoardById(almLink.sessionBoardId);
                let jiraLinkType;
                if (almLink && almLink.linkType && typeof almLink.linkType.jiraId != "undefined" && almLink.direction) {
                    jiraLinkType = almLink.linkType.jiraId + "-" + almLink.direction;
                }
                if ((typeof almLink.targetItem == "undefined" || !almLink.targetItem) && typeof almLink.targetJiraIssue != "undefined") {
                    almLink.targetItem = {
                        title: almLink.targetJiraIssue.fields.summary,
                        jiraKey: almLink.targetJiraIssue.key,
                        jiraURL: almLink.targetJiraIssue.self
                    };
                }
                if (typeof almLink.targetJiraIssue != "undefined") {
                    var _base = getBoardBaseUrl(almLinkBoard);
                    almLink.targetJiraIssue.url = _base ? (_base + '/' + almLink.targetJiraIssue.key) : 'javascript:void(0);';
                }
                _this.almLinkDataList[almLink.id] = {
                    id: almLink.id,
                    link: almLink,
                    sItem: almLink.sourceItem,
                    tItem: almLink.targetItem,
                    type: almLink.type,
                    jiraType: jiraLinkType,
                    linkType: almLink.tfsLinkType,
                    index: index,
                    sessionBoardObj: almLinkBoard,
                    isJira: !almLink.isTFS,
                    tProjectName: almLink.tProjectName,
                    tItemType: almLink.tItemType,
                    tStatus: almLink.tStatus
                }
                let itemMap = {};
                if (almLink.isTFS) {
                    //if tfs board then
                    itemMap[almLink.sourceItem.tfsId] = almLink.sourceItem;
                    if (typeof almLink.targetItem != "undefined") {
                        itemMap[almLink.targetItem.tfsId] = almLink.targetItem;
                    }
                    setItemSprintAndTeam(_this.almLinkDataList[almLink.id], itemMap);
                    //pushing the target item id to fetch its meta from azure api
                    //mapping the target items against the alm account id below in the ---almLinkIds--- map
                    if (typeof _this.almLinkIds[_this.almLinkDataList[almLink.id].sessionBoardObj.session.tfsAlmConfigurations.almAccount.id] == "undefined" && almLink.targetItem && almLink.targetItem.tfsId) {
                        _this.almLinkIds[_this.almLinkDataList[almLink.id].sessionBoardObj.session.tfsAlmConfigurations.almAccount.id] = [];
                        _this.almLinkIds[_this.almLinkDataList[almLink.id].sessionBoardObj.session.tfsAlmConfigurations.almAccount.id].push(almLink.targetItem.tfsId)
                    } else if(_this.almLinkIds[_this.almLinkDataList[almLink.id].sessionBoardObj.session.tfsAlmConfigurations.almAccount.id]){
                        _this.almLinkIds[_this.almLinkDataList[almLink.id].sessionBoardObj.session.tfsAlmConfigurations.almAccount.id].push(almLink.targetItem.tfsId)
                    }
                } else {
                    //if jira board
                    itemMap[almLink.sourceItem.jiraId] = almLink.sourceItem;
                    if (typeof almLink.targetItem != "undefined") {
                        itemMap[almLink.targetItem.jiraId] = almLink.targetItem;
                    }
                    setItemSprintAndTeam(_this.almLinkDataList[almLink.id], itemMap);
                }
            });

            if (typeof _this.almLinkIds != "undefined" && _this.shouldFetchTfsMetaInfo) {
                _.forEach(_this.almLinkIds, function (itemIds, almAccountId) {
                    _this.loadTFSItems(itemIds, almAccountId);
                })
            }
        },

        loadTFSItems: function (tfsItemIds, almAccountId) {
            let _this = this;
            let body = {};
            body.itemIds = tfsItemIds.join(",");
            body.almAccountId = almAccountId;

            axios.post('/pi/tfsitems', body)
                .then(response => {
                    if (response.data) {
                        let parsedResponse = JSON.parse(response.data.items);
                        if (parsedResponse && parsedResponse.count > 0) {
                            let items = parsedResponse.value;
                            this.onSelectFilter();
                            _.forEach(_this.filteredAlmLinks, function (link) {
                                if (link.isTFS) {
                                    let item = _.filter(items, function (item) {
                                        return item.id == link.targetItem.tfsId
                                    })[0];
                                    if (item) {
                                        link.targetItemTitle = item.fields["System.Title"];
                                        link.targetTFSItem.title = item.fields["System.Title"];
                                        link.tProjectName = item.fields["System.TeamProject"];
                                        link.tItemType = item.fields["System.WorkItemType"];
                                        link.tStatus = item.fields["System.State"];
                                    }
                                }
                            })


                            _this.groupAlmLinksBySprint(_this.filteredAlmLinks)
                            _this.populateAlmLinkDataList(_this.filteredAlmLinks);
                            _this.shouldFetchTfsMetaInfo = false;
                        }
                    }
                })
                .catch(error => {
                    console.log("error occurred while fetching tfs Items meta data " + error);
                });
        },

        getBoardById: function (boardId) {
            let board = {};
            if (this.sessionBoardsMetaMap[boardId]) {
                board = this.sessionBoardsMetaMap[boardId];
            }
            if (board && board.session && board.session.almEnabled) {
                if (typeof board.session.tfsAlmConfigurations !== "undefined") {
                    board.boardTypeText = "TFS";
                } else if (typeof board.session.almConfigurations !== "undefined") {
                    board.boardTypeText = "JIRA"
                }
            } else {
                board.boardTypeText = "JIRA"
            }
            return board;
        },

        getDependencyId: function (item) {
            if (!_.isEmpty(this.sessionBoardsMetaMap[item.sessionBoardId])) {
                let dependencyPrefix = this.sessionBoardsMetaMap[item.sessionBoardId].session.dependencyPrefix;
                return dependencyPrefix + "-" + item.customId;
            }
        },

        changeStatusFilter: function () {
            this.onSelectFilter();
        },

        filterResultsByResponsible: function (links) {
            return _.filter(links, function (link) {
                if (typeof link.responsible != "undefined") {
                    return link.responsible.id === loggedInUser.id
                }
            })
        },

        filterResultsByWatcher: function (links) {
            let _this = this;
            return _.filter(links, function (link) {
                let isMatched = false;
                if (link.watcherList.length > 0) {
                    _.forEach(link.watcherList, function (itemWatcher) {
                        if (_.filter(_this.watcherList, function (watcher) {
                            return watcher.id === itemWatcher.id
                        }).length > 0) {
                            isMatched = true;
                        }
                    })
                }
                return isMatched;
            })
        },

        filterResultsByReporter: function (links) {
            return _.filter(links, function (link) {
                if (typeof link.reporter != "undefined") {
                    return link.reporter.id === loggedInUser.id
                }
            })
        },

        resetRolesCount: function () {
            let _this = this;
            _.forEach(_this.searchFilters, function (filter) {
                filter.count = 0;
            })
        },

        filterItemLinks: function () {
            let _this = this;
            let itemLinks = this.itemLinkList;
            _this.filteredStatusAndSearchItemLinksList = [];
            this.filteredItemLinks = [];
            if (_this.selectedStatus !== "All" && _this.searchText !== "") {
                let filteredByStatusLinks = _.filter(itemLinks, function (item) {
                    return item.status === _this.selectedStatus;
                })
                itemLinks = filteredByStatusLinks;
                _this.filteredStatusAndSearchItemLinksList = _.clone(itemLinks);
                _this.filteredStatusAndSearchItemLinksList = [];
                _.forEach(itemLinks, function (item) {
                    let dependencyId = _this.getDependencyId(item)
                    if (_this.matchItemBySearch(item,dependencyId)) {
                        _this.filteredItemLinks.push(item);
                        _this.filteredStatusAndSearchItemLinksList.push(item);
                    }
                });
                if (itemLinks.length == 0) {
                    _this.filteredStatusAndSearchItemLinksList = [];
                }
                itemLinks = _this.filteredItemLinks;
            } else if (_this.selectedStatus !== "All") {
                let filteredByStatusLinks = _.filter(itemLinks, function (item) {
                    return item.status === _this.selectedStatus;
                })
                itemLinks = filteredByStatusLinks;
                _this.filteredStatusAndSearchItemLinksList = _.clone(itemLinks);
            } else if (_this.searchText !== "") {
                _.forEach(itemLinks, function (item) {
                    let dependencyId = _this.getDependencyId(item)
                    if (_this.matchItemBySearch(item,dependencyId)) {
                        _this.filteredItemLinks.push(item);
                        _this.filteredStatusAndSearchItemLinksList.push(item);
                    }
                });
                itemLinks = _this.filteredItemLinks;
            }
            if (this.activeSearchFilter === "Responsible") {
                itemLinks = _this.filterResultsByResponsible(itemLinks);
            } else if (this.activeSearchFilter === "Reporter") {
                itemLinks = _this.filterResultsByReporter(itemLinks)
            } else if (this.activeSearchFilter === "Watcher") {
                itemLinks = _this.filterResultsByWatcher(itemLinks)
            }
            _this.filteredItemLinks = itemLinks;
            _this.groupItemLinksBySprint(itemLinks);
            _this.populateLinkDataList(itemLinks);
        },

        matchItemBySearch: function (item,dependencyId) {
            let _this=this;
            return (
                (item.sourceItem && item.sourceItem.tfsId && item.sourceItem.tfsId.indexOf(_this.searchText.toLowerCase()) > -1) ||
                (item.targetItem && item.targetItem.tfsId && item.targetItem.tfsId.indexOf(_this.searchText.toLowerCase()) > -1) ||
                (item.sourceItem && item.sourceItem.jiraKey && item.sourceItem.jiraKey.indexOf(_this.searchText.toLowerCase()) > -1) ||
                (item.targetItem && item.targetItem.jiraKey && item.targetItem.jiraKey.indexOf(_this.searchText.toLowerCase()) > -1) ||
                (item.sourceItem && item.sourceItem.title && item.sourceItem.title.toLowerCase().indexOf(_this.searchText.toLowerCase()) > -1) ||
                (item.targetItem && item.targetItem.title && item.targetItem.title.toLowerCase().indexOf(_this.searchText.toLowerCase()) > -1) ||
                (item.targetTFSItem && item.targetTFSItem.title && item.targetTFSItem.title.toLowerCase().indexOf(_this.searchText.toLowerCase()) > -1) ||
                (item.customId && dependencyId && dependencyId.toLowerCase().indexOf(_this.searchText.toLowerCase()) > -1));
        },

        filterAlmLinks: function () {
            let _this = this;
            let almLinks = this.almDependenciesList;
            _this.filteredStatusAndSearchAlmLinksList = [];
            _this.filteredAlmLinks = [];
            if (_this.selectedStatus !== "All" && _this.searchText !== "") {
                let filteredByStatusLinks = _.filter(almLinks, function (link) {
                    if (_this.selectedStatus === "Open") {
                        return link.wfStatus.title !== "Done";
                    } else {
                        return link.wfStatus.title === "Done";
                    }
                });
                almLinks = filteredByStatusLinks;
                _this.filteredStatusAndSearchAlmLinksList = _.clone(almLinks);
                _this.filteredStatusAndSearchAlmLinksList = [];
                _.forEach(almLinks, function (item) {
                    if (_this.matchItemBySearch(item)) {
                        _this.filteredAlmLinks.push(item);
                        _this.filteredStatusAndSearchAlmLinksList.push(item);
                    }
                });
                almLinks = _this.filteredAlmLinks;
                if (almLinks.length == 0) {
                    _this.filteredStatusAndSearchAlmLinksList = [];
                }
            } else if (_this.selectedStatus !== "All") {
                let filteredByStatusLinks = _.filter(almLinks, function (link) {
                    if (_this.selectedStatus === "Open") {
                        return link.wfStatus.title !== "Done";
                    } else {
                        return link.wfStatus.title === "Done";
                    }
                });
                almLinks = filteredByStatusLinks;
                _this.filteredStatusAndSearchAlmLinksList = _.clone(almLinks);
            } else if (_this.searchText !== "") {
                _.forEach(almLinks, function (item) {
                    if (_this.matchItemBySearch(item)) {
                        _this.filteredAlmLinks.push(item);
                        _this.filteredStatusAndSearchAlmLinksList.push(item);
                    }
                });
                almLinks = _this.filteredAlmLinks;
            }

            if (this.activeSearchFilter === "Responsible") {
                almLinks = this.filterResultsByResponsible(almLinks)
            } else if (this.activeSearchFilter === "Reporter") {
                almLinks = this.filterResultsByReporter(almLinks)
            } else if (this.activeSearchFilter === "Watcher") {
                almLinks = this.filterResultsByWatcher(almLinks)
            }
            _this.filteredAlmLinks = almLinks;
            _this.groupAlmLinksBySprint(almLinks);
            _this.populateAlmLinkDataList(almLinks);
        }
        ,

        onSelectFilter: function () {
            let _this = this;
            let itemLinks = this.itemLinkList;
            let almLinks = this.almDependenciesList;
            if (((typeof itemLinks != "undefined") && !(itemLinks.length > 0)) && ((typeof almLinks != "undefined") && (!almLinks.length > 0))) {
                this.almLinksGroupBySprintListMap = "";
                this.itemLinksGroupBySprintListMap = "";
                _.forEach(_this.searchFilters, function (filter) {
                    filter.count = 0;
                });
                this.$emit("onDependenciesCountUpdate", this.searchFilters["Responsible"].count);
            } else {
                this.filterItemLinks();
                this.filterAlmLinks();
                this.resetRolesCount();
                if (this.searchText !== "" || this.selectedStatus !== "All") {
                    itemLinks = this.filteredStatusAndSearchItemLinksList;
                    almLinks = this.filteredStatusAndSearchAlmLinksList;
                }
                this.populateCountOfRoles(itemLinks)
                this.populateCountOfRoles(almLinks)
            }
        }
        ,

        populateCountOfRoles: function (list) {
            let _this = this;
            let filteredList = [];
            //calculate All Count
            let allCount = this.searchFilters["All Dependencies"].count;
            if (allCount > 0) {
                allCount = allCount + list.length;
            } else {
                if (list) {
                    allCount = list.length;
                }
            }
            this.searchFilters["All Dependencies"].count = allCount;

            //calculate responsible count
            let responsibleCount = this.searchFilters["Responsible"].count;
            filteredList = _.filter(list, function (item) {
                if (typeof item.responsible != "undefined") {
                    return item.responsible.id === loggedInUser.id
                }
            })
            if (responsibleCount > 0) {
                responsibleCount = responsibleCount + filteredList.length;
            } else {
                responsibleCount = filteredList.length;
            }
            this.searchFilters["Responsible"].count = responsibleCount;

            //calculate reporter count
            let reporterCount = this.searchFilters["Reporter"].count;
            filteredList = _.filter(list, function (item) {
                if (typeof item.reporter != "undefined") {
                    return item.reporter.id === loggedInUser.id
                }
            })
            if (reporterCount > 0) {
                reporterCount = reporterCount + filteredList.length;
            } else {
                reporterCount = filteredList.length;
            }
            this.searchFilters["Reporter"].count = reporterCount;

            filteredList = _.filter(list, function (item) {
                let isMatched = false;
                if (item.watcherList.length > 0) {
                    _.forEach(item.watcherList, function (itemWatcher) {
                        if (_.filter(_this.watcherList, function (watcher) {
                            return watcher.id === itemWatcher.id
                        }).length > 0) {
                            isMatched = true;
                        }
                    })
                }
                return isMatched;
            });

            //calculate watcher count
            let watcherCount = this.searchFilters["Watcher"].count;
            if (watcherCount > 0) {
                watcherCount = watcherCount + filteredList.length;
            } else {
                watcherCount = filteredList.length;
            }
            this.searchFilters["Watcher"].count = watcherCount;
            this.$emit("onDependenciesCountUpdate", this.searchFilters["Responsible"].count);
        }
        ,

        groupItemLinksBySprint: function (list) {
            let _this = this;
            this.itemLinksGroupBySprintListMap = "";
            this.itemLinksGroupByBoard = "";
            this.itemLinksGroupBySprintListMap = _.groupBy(list, function (itemLink) {
                if (itemLink.sourceItem && typeof itemLink.sourceItem.teamContainers != "undefined") {
                    if (typeof itemLink.sourceItem.teamContainers[0] != "undefined" && typeof itemLink.sourceItem.teamContainers[0].container != "undefined") {
                        return itemLink.sourceItem.teamContainers[0].container.id;
                    }
                }
            });
            _.forEach(_this.itemLinksGroupBySprintListMap, function (value, key) {
                _this.itemLinksGroupBySprintListMap[key] = _.orderBy(value, ['id'], ['asc']);
            })

            this.itemLinksGroupByBoard = _.groupBy(list, function (itemLink) {
                if (itemLink.sessionBoardId) {
                    return itemLink.sessionBoardId;
                }
            });
        },

        groupAlmLinksBySprint: function (list) {
            let _this = this;
            this.almLinksGroupBySprintListMap = "";
            this.almLinksGroupByBoard = "";
            this.almLinksGroupBySprintListMap = _.groupBy(list, function (almLink) {
                if (typeof almLink.sourceItem != "undefined") {
                    if (typeof almLink.sourceItem.teamContainers != "undefined" && typeof almLink.sourceItem.teamContainers[0] != "undefined"
                        && typeof almLink.sourceItem.teamContainers[0].container != "undefined"
                        && almLink.sourceItem.teamContainers[0].container.id)
                        return almLink.sourceItem.teamContainers[0].container.id;
                }
            });
            _.forEach(_this.almLinksGroupBySprintListMap, function (value, key) {
                _this.almLinksGroupBySprintListMap[key] = _.orderBy(value, ['id'], ['asc']);
            })

            this.almLinksGroupByBoard = _.groupBy(list, function (almLink) {
                if (almLink.sessionBoardId) {
                    return almLink.sessionBoardId;
                }
            });
        }
    }
});