var syncId = getNewUUID();
const LIST_BASE_ITEM = Vue.component('list-base-item', {

    name: 'list-base-item',

    props: ["itemType", "userId", "dependenciesData"],

    template: `
    <div class="container">
        <ul v-if="item.type==="Dependencies">
            <board-row-dependences :type = "'featureDetail'" :link-data="itemLink" :index="index" :board-type="boardType" > </board-row-dependences>
        </ul>
        <ul class="list-group">
            <li class="list-group-item" v-for="item in itemList">
                <p>ID: {{item.id}}</p><br>
                <div v-if="item.type==='Impediment'">Description: <div v-html="item.description"></div></div>
                <p v-if="item.type==='Impediment'"> Responsible: {{ Object.values(item.fields)[0].fullName }}</p>
                <p v-if="item.type==='ActionPoint'">
                   Title: <span v-if="item.type==='ActionPoint'" class="txt" v-html="item.title"></span>
                </p>
                <p v-if="item.type==='ActionPoint'">Status: {{item.status.title}}</p>
                <button @click="openEditPopup(item)">Edit</button>
                 
               
            </li>
        </ul>
         <dynamic-popup-container v-if="itemTemplate.showEditPopup"
                    @close = "onCloseEditPopUp"
                    @save = "onSaveItem"
                    @change = "onChangePopupType"
                    @delete = "onDeleteItem"
                    :template-to-render="itemTemplate.templateToRenderer"
                    :template-statuses = "itemTemplate.statuses"
                    :item-type="itemTemplate.itemTypeList"
                    :fields-value="itemTemplate.model"
                    :template = "itemTemplate"
                    :show-attachments="false" 
                    :show-watchers="true"
                    :show-history="true"
                    :show-conversations="true"
                    :entity-type="'BaseItem'"
                    :entity-id="itemTemplate.id">
         </dynamic-popup-container>
    </div>
	`,

    data() {
        return {
            itemList: [],
            itemTemplate: {
                showEditPopup: false,
                templateToRenderer: {},
                statuses: [],
            },
        }
    },

    watch: {
        itemType: function (_newVal, _oldVal) {
            this.fetchItemList(loggedInUser.id, this.itemType);
        }
    },

    mounted() {
        const fetchItemListInterval = setInterval(() => {
            this.fetchItemList(loggedInUser.id, this.itemType);
            clearInterval(fetchItemListInterval);
        }, 500)
    },

    methods: {

        onDeleteItem: function (id) {
            var _this = this;
            var requestBody = {};
            requestBody.syncId = syncId;
            let _sb = getBoardInstance();
            if(_sb && _sb.session && _sb.session.workSpace){
	            requestBody.workSpaceId = _sb.session.workSpace.id;
			}
            axios.post('sos/scrum/deleteImpediment/' + id, requestBody)
            .then(response => {
                if (response.data == "success") {
                    _this.updateMilestoneList(id, 'delete');
                    showTopMessage("ItemType Removed", 'success');
                    _this.itemTemplate.showEditPopup = false;
                    _this.$forceUpdate();
                }
            })
            .catch(error => {

            });

        },

        onChangePopupType: function (itemType) {
            console.log(itemType)
            // if (itemType.title == "MileStone") {
            //     this.onOpenMileStone(kendisStore.getters.getMilestoneTemplate());
            // } else if (itemType.title == "Phases") {
            //     this.onOpenMileStone(kendisStore.getters.getPhaseTemplate());
            // }

        },

        onSaveItem: function (reqBody) {
            console.log(reqBody)
            var _this = this;
            var param = "update-impediment";
            var baseItem = {};
            baseItem = reqBody;
            baseItem.metaMap.syncId = syncId;

            axios.post('external-entitites/save-base-item/' + param, baseItem)
            .then(response => {
                if (response.status == 200) {
                    let index = _.findIndex(_this.itemList, {id: response.id});
                    _this.itemList.splice(index, 1, response);
                    showTopMessage("Item Updated", 'success');
                    _this.itemTemplate.showEditPopup = false;
                    _this.$forceUpdate();
                }
            })
            .catch(error => {
                console.error("Impediment save error", error);
                handleSoSErrorMsg(error);
            });
        },

        openEditPopup: function (item) {
            let _this = this;
            axios.get('external-entitites/load-base-item/' + item.id)
            .then(response => {
                if (response.data.item) {
                    var baseItem = response.data.item;
                    _this.itemTemplate = {};
                    _this.itemTemplate.id = baseItem.id;
                    _this.itemTemplate.model = {};
                    _this.itemTemplate.model.id = baseItem.id;
                    _this.itemTemplate.model.title = baseItem.title;
                    _this.itemTemplate.model.description = baseItem.description;
                    _this.itemTemplate.model.key = baseItem.key;
                    if (baseItem.fields) {
                        _this.itemTemplate.model.fields = baseItem.fields;
                    }
                    if (response.data && response.data.item
                        && response.data.item.fieldsTemplate) {
                        _this.itemTemplate.templateToRenderer = response.data.item.fieldsTemplate;
                    }
                    if (baseItem.status) {
                        _this.itemTemplate.model.status = baseItem.status;
                    }
                    if (baseItem.baseItemLinks) {
                        _this.itemTemplate.model.baseItemLinks = baseItem.baseItemLinks;
                    }
                    if (response.data.statusMap) {
                        _this.itemTemplate.statuses = response.data.statusMap[_this.itemType
                        + "StatusList"];
                    }
                    if (response.data.itemTypeList) {
                        _this.itemTemplate.itemTypeList = response.data.itemTypeList;
                    }
                    // for itemLinking
                    _this.itemTemplate.model.linkedItemObject = {};
                    if (baseItem.id) {
                        _this.itemTemplate.model.linkedItemObject.id = baseItem.id;
                    }
                    if (response.data.linkedItemsIds) {
                        _this.itemTemplate.model.linkedItemObject.linkedItemsIds = response.data.linkedItemsIds;
                    }
                    if (response.data.linkedItems) {
                        _this.itemTemplate.model.linkedItemObject.linkedItems = response.data.linkedItems;
                    }
                    if (response.data.linkedItemsById) {
                        _this.itemTemplate.model.linkedItemObject.linkedItemsById = response.data.linkedItemsById;
                    }

                    console.log(_this.itemTemplate)

                    _this.itemTemplate.showEditPopup = true;
                }

            })
            .catch(error => {
                console.log("Item fetch error", error)
            });
        },

        onCloseEditPopUp: function () {
            this.itemTemplate.showEditPopup = false;
            this.$forceUpdate();
        },

        fetchItemList: function (userId, itemType) {
            let _this = this;
            let requestBody = {};
            requestBody["userId"] = userId
            requestBody["item-type"] = this.itemType;
            if (itemType === "Impediment") {
                requestBody["field-title"] = "Responsible"
                requestBody["field-type"] = "userpicker";
            } else if (itemType === "ActionPoint") {
                requestBody["data-mention-id"] = loggedInUser.email;
            } else if (itemType === "Dependencies") {
                return;
            }
            axios.post('notification/list-base-items', requestBody)
            .then(response => {
                _this.itemList = response.data.items;
            })
            .catch(error => {
                console.error("Item fetch error", error);
            });
        }
    }
});