const LIST_ACTION_POINTS = Vue.component('list-action-points', {

    name: 'list-action-points',

    props: ["actionPointsList","isLoading","sessionListMap"],

    template: `
    <div class="container">
      	<div class="fltout DF">
	        <div class="FG"></div>
	        <div class="aa DF">
		         <div class="selectcont wht">
		            <select v-model="selectedStatus"  @change="onSelectFilter">
		                <option value="All" >Status</option>
		                <option value="Open" >Open</option>
		                <option value="Closed" >Closed</option>
		            </select>
		        </div>
		         <div class="srbtn p-rel ti-search">
		            <input type="text" v-model="searchQuery" placeholder="Search Action Point..." @input="onSelectFilter" />
		        </div>		        
	        </div>
        </div>
		<template v-if="!_.isEmpty(itemGroupBySession)&& sessionListMap">
			<ul v-for="(sessionGroup, key) in itemGroupBySession" class="list-group">
                <h1 class="register-title" @click="toggleRegisterTitleCollapse(riskRegister.id)" ><div class="arric b FL"></div>{{sessionListMap[key].title}}</h1>
	            <li class="list-group-item" v-for="actionPoint in sessionGroup">
	                <p>
	                   Title: <span  class="txt" v-html="actionPoint.title"></span>
	                </p>
	                <p >Status: {{actionPoint.status.title}}</p>
	                <button @click="openEditPopup(actionPoint)">Edit</button>       
	            </li>
	        </ul>
        </template>
         <dynamic-popup-container v-if="itemTemplate.showEditPopup"
                    @close = "onCloseEditPopUp"
                    @save = "onSaveItem"
                    @delete = "onDeleteItem"
                    :board ="itemTemplate.board"
                    :template-to-render="itemTemplate.templateToRenderer"
                    :template-statuses = "itemTemplate.statuses"
                    :item-type="itemTemplate.itemTypeList"
                    :fields-value="itemTemplate.model"
                    :template = "itemTemplate"
                    :show-attachments="false" 
                    :show-watchers="false"
                    :show-history="false"
                    :showBoardLinking="false"
                    :showLinkedItems="false"
                    :show-conversations="false"
                    :show-external-entities="false"
                    :entity-type="'BaseItem'"
                    :entity-id="itemTemplate.id">
         </dynamic-popup-container>
    </div>
	`,

    data() {
        return {
            itemTemplate: {
                showEditPopup: false,
                templateToRenderer: {},
                statuses: [],
            },
			itemGroupBySession: {},
			selectedStatus: 'All',
			searchQuery: ''
        }
    },

    watch: {
        actionPointsList: function (_newList, _oldList) {
            let _this = this;
            if (_newList && !(_newList.length > 0)) {
                return;
            }
			_this.groupBySession();	
            // this.onSelectFilter();
        },
		sessionListMap: function (_newMap, _oldMap) {
            let _this = this;			
            if (_newMap && !(Object.keys(_newMap).length > 0)) {
                return;
            }
			_this.groupBySession();
		}
    },

    mounted() {
		this.groupBySession();	
    },

    methods: {

        onDeleteItem: function (id) {
            var _this = this;
            var requestBody = {};
            requestBody.syncId = syncId;
            let _sb = getBoardInstance();
            if(_sb && _sb.session && _sb.session.workSpace){
	            requestBody.workSpaceId = _sb.session.workSpace.id;
			}
            axios.post('sos/scrum/deleteImpediment/' + id, requestBody)
                .then(response => {
                    if (response.data == "success") {
                        _this.updateMilestoneList(id, 'delete');
                        showTopMessage("ItemType Removed", 'success');
                        _this.itemTemplate.showEditPopup = false;
                        _this.$forceUpdate();
                    }
                })
                .catch(error => {

                });

        },

        onSaveItem: function (reqBody) {
            let _this=this;
            let actionPoint = _.filter(_this.actionPointsList,{id:reqBody.id})
            let param = "EDIT-ACTIONPOINT";
            let baseItem = {};
            baseItem = reqBody;
            baseItem.metaMap.syncId = syncId;
            baseItem.fieldsTemplate=actionPoint.fieldsTemplate;
            baseItem.createdOn=actionPoint.createdOn;
            baseItem.createdBy=actionPoint.createdBy;
            baseItem.updatedOn=new Date();
            baseItem.updatedBy=actionPoint.updatedBy;
            baseItem.type=actionPoint.type;
            baseItem.fields=actionPoint.fields;
            baseItem.key=actionPoint.key;
            baseItem.notifyWatchers=actionPoint.notifyWatchers;
            baseItem.rowStatus=actionPoint.rowStatus;
            baseItem.scrumId=actionPoint.scrumId;
            baseItem.mentionUsers=[];
            baseItem.status=actionPoint.status;
            baseItem.baseItemLinks=actionPoint.baseItemLinks;


            axios.post('external-entitites/save-base-item/' + param, baseItem)
                .then(response => {
                    if (response.status == 200) {
                        showTopMessage("Item Updated", 'success');
                        _this.itemTemplate.showEditPopup = false;
                        _this.$forceUpdate();
                    }
                })
                .catch(error => {
                    console.error("Impediment save error", error);
                    handleSoSErrorMsg(error);
                });
        },

        openEditPopup: function (item) {
            let _this = this;
            axios.get('my-view/load-action-point/' + item.id)
                .then(response => {
                    if (response.data.item) {
                        var baseItem = response.data.item;
                        _this.itemTemplate = {};
                        _this.itemTemplate.id = baseItem.id;
                        _this.itemTemplate.model = {};
                        _this.itemTemplate.model.id = baseItem.id;
                        _this.itemTemplate.model.title = baseItem.title;
                        _this.itemTemplate.model.createdOn = baseItem.createdOn;
                        _this.itemTemplate.model.updatedOn = baseItem.updatedOn;
                        _this.itemTemplate.model.key = baseItem.key;
                        if (baseItem.fields) {
                            _this.itemTemplate.model.fields = baseItem.fields;
                        }
                        if (response.data && response.data.item
                            && response.data.item.fieldsTemplate) {
                            _this.itemTemplate.templateToRenderer = response.data.item.fieldsTemplate;
                        }
                        if (baseItem.baseItemLinks) {
                            _this.itemTemplate.model.baseItemLinks = baseItem.baseItemLinks;
                        }
                        if (response.data.itemTypeList) {
                            _this.itemTemplate.itemTypeList = response.data.itemTypeList;
                        }
                        _this.itemTemplate.board=item.sessionBoard;

                        _this.itemTemplate.showEditPopup = true;
                    }

                })
                .catch(error => {
                    console.log("Item fetch error", error)
                });
        },

        onCloseEditPopUp: function () {
            this.itemTemplate.showEditPopup = false;
            this.$forceUpdate();
        },
		groupBySession: function() {
			let _this = this;			
			_.each(_this.actionPointsList, imp=>{
				if(!_.isEmpty(imp.baseItemLinks)) {
					let sessionMap = {};
					_.each(imp.baseItemLinks, itemLink=>{
						if(itemLink.sessionId) {
							let sessionId = itemLink.sessionId;
							if(!sessionMap[sessionId]) {
								sessionMap[sessionId] = true;
								if(!_this.itemGroupBySession[sessionId]) {
									_this.itemGroupBySession[sessionId] = [];
								}
								var searchStringMatch = imp.title.replace(/<[^>]*>/g, ' ').replace(/\s{2,}/g, ' ').replaceAll('&nbsp;','').trim().toLowerCase().
								includes(_this.searchQuery.trim().toLowerCase()) ||  imp.key.toLowerCase().includes(_this.searchQuery.trim().toLowerCase());
								let statusMatch = _this.selectedStatus== "All" || (imp.status.category == "ToDo" && _this.selectedStatus == "Open") 
								|| (imp.status.category == "Done" && _this.selectedStatus == "Closed");
								if(searchStringMatch && statusMatch) {								
									_this.itemGroupBySession[sessionId].push(imp);
								}
							}
						}
					});
				}
			});	
			_this.$forceUpdate();		
		},
		onSelectFilter: function() {
			this.itemGroupBySession = {};
			this.groupBySession();
		},		
    },
});