const IMPEDIMENT_ROW_COMPONENT = Vue.component('impedimemt-row-component', {
    props: {
		multiselectValues: {
			type: Array,
			default: () =>{
				return []
			}
		},
		impedimemtList: {
			type: Array,
			default: () =>{
				return []
			}			
		},
		severityFieldId: {
			type: String,
			default: () =>{
				return ''
			}
		},
		resolutionDateFieldId: {
			type: String,
			default: () =>{
				return ''
			}
		},
		session: {
			type: Object,
			default: () =>{
				return {}
			}			
		}
	},
	
	template: `
	<div class="reports riskreg">
       	<div>
	       <edit-impediment v-if="editPopup.show"
		       :impediment="editPopup.impediment" 
		       :board="editPopup.board"
		       @save="saveImpedimentPopup($event, 'viewTop')" 
		       @close="closeImpedimentPopup" 		       
	       />
			
       	</div>	
       	<div class="prow repshowdata">
			<div>
				<div class="tbout">
					<table class="table">
						<thead>
							<tr class="rec">
								<th v-show="checkIfColumnActive('title')" id="checkRiskTitle" class="dsc brd-rht">
									Title
								</th>
								<th v-show="checkIfColumnActive('status')" id="checkStatus" class="stat">
									<a href="javascript:void(0)" @click="sortBy('status')">Status</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='status' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
								<th v-show="checkIfColumnActive('severity')" id="checkRiskLevel">
									<a href="javascript:void(0)" @click="sortBy('severity')">Severity</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='severity' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
								<th v-show="checkIfColumnActive('resolutionDate')" id="checkResolution"
									class="trd" title="Target Resolution Date">
									<a href="javascript:void(0)" @click="sortBy('resolutionDate')">Resolution Date</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='resolutionDate' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
								<!--<th v-show="checkIfColumnActive('convCount')" id="checkConvCount" class="t-center">
									<a href="javascript:void(0)" @click="sortBy('conversationCount')">Conversation</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='conversationCount' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>-->
							</tr>
						</thead>
						<tbody>
							<template v-for="(impediment, index) in impediments">
								<tr class="rec" :key="impediment.id">
									<td v-show="checkIfColumnActive('title')" class="dsc brd-rht"title="Title" @click="openEditPopup(impediment)">
										<a class="ky" href="javascript:void(0);">{{impediment.key}}</a>
										<span class="txt" v-html="impediment.title"></span>
									</td>
									<template v-if="checkIfColumnActive('status')">
										<td v-if="impediment.status" class="stat" title="Status">
											{{impediment.status.title}}
										</td>
										<td v-else class="stat" title="Status">N/A</td>
									</template>
									<template v-if="checkIfColumnActive('severity')">
										<td v-if="impediment.status" class="stat" title="Status">
											<template v-if="impediment.fields && impediment.fields[severityFieldId]">
												{{ impediment.fields[severityFieldId].title }}											
											</template>										
										</td>
										<td v-else class="stat" title="Status">N/A</td>
									</template>
									
									<td v-show="checkIfColumnActive('resolutionDate')" title="Resolution Date" class="trd">
										<template v-if="impediment.fields && impediment.fields[resolutionDateFieldId]">
											{{getFormattedDateBritish(impediment.fields[resolutionDateFieldId]) }}											
										</template>
									</td>
									<!--<td v-show="checkIfColumnActive('convCount')" class="t-center chat" title="Conversations Count">
										<span class="c-point">
											<em class="icon-comment-empty" @click="onClickOpenRisk(impediment)"></em>{{impediment.conversationCount}}
										</span>
									</td>-->
								</tr>
							</template>
						</tbody>
					</table>
				</div>
			</div>
	   </div>	
	</div>
	`,
	
    data() {
        return {
            sortColumn				: '',
            sortAsc					: true,
            copyRisks				: [],
            impediments				: [],
            editPopup : {
                show		: false,
                impediment	: '',
                board		: ''
            },

        }
    },

    watch: {
        impedimemtList: function(_newList,_oldList){
            this.impediments=_newList;
            //this.sortBy(this.sortColumn,this.sortAsc)
        }
    },

    mounted() {
        this.impediments=this.impedimemtList;
        //this.sortBy(this.sortColumn,this.sortAsc)
    },
	methods: {
        sortBy: function (colName, notFlip) {
			var _this = this;
            if (notFlip === undefined)
                this.sortAsc = !this.sortAsc;
            if (colName != this.sortColumn)
                this.sortAsc = true;
            this.sortColumn = colName;
            var sortMode = [this.sortAsc ? 'asc' : 'desc'];

            if (colName == 'severity') {
                this.impediments = _.orderBy(_this.impedimemtList, item=> item.fields && item.fields[_this.severityFieldId] && item.fields[_this.severityFieldId].title, [sortMode]);				
            } else if(colName == 'resolutionDate'){
                this.impediments = _.orderBy(_this.impedimemtList, item=> item.fields && item.fields[_this.resolutionDateFieldId] && new Date(item.fields[_this.resolutionDateFieldId]), [sortMode]);					
			}else if (colName == 'status') {
                this.impediments = _.orderBy(_this.impediments, function (imp) {
                    if (!imp.status) {
                        return -1;
                    } else {
                        if (imp.status.category === 'ToDo') {
                            return 0;
                        } else if (imp.status.category === 'InProgress') {
                            return 1;
                        } else if (imp.status.category === 'Done') {
                            return 2;
                        } else {
                            return 3;
                        }
                    }
                }, [sortMode]);
            } else {
                this.impediments = _.orderBy(this.impediments, [colName], [sortMode]);
            }
        },
        checkIfColumnActive: function (column) {
            for (var i = 0; i < this.multiselectValues.length; i++) {
                if (column === this.multiselectValues[i].value) {
                    return true;
                }
            }
            return false;
        },
        getFormattedDateBritish: function (date) {
            var dateFinal = '';
            var mydate = new Date(date);
            var monthFromDate = mydate.getMonth();
            const monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
                "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
            ];
            if (mydate.getFullYear() === 'NaN' || monthNames[monthFromDate] === undefined || mydate.getDate() === 'NaN') {
                return '';
            }
            dateFinal = mydate.getDate() + ' ' + monthNames[monthFromDate] + ' ' + mydate.getFullYear();
            return dateFinal;
        },
        openEditPopup: function (impediment, scrumId) {
            var copy = _.cloneDeep(impediment);
            var genTime = new Date(copy.updatedOn);
            copy._status = {id: copy.checked + ''};
            if (isNaN(genTime.getTime())) {
                genTime = new Date(copy.createdOn);
                if (isNaN(genTime.getTime())) {
                    copy._updatedOn = null;
                } else {
                    copy._updatedOn = dateFormat(genTime, 'default');
                }
            } else {
                copy._updatedOn = dateFormat(genTime, 'default');
            }
            this.onEditExtractMentionUser(impediment.title);
            this.editPopup.impediment = copy;
            this.editPopup.orignal = impediment;
			var board = {};
			if(!_.isEmpty(this.session)) {				
				board.id = this.session.activeSessionBoard;
				board.session = this.session;
			}
            this.editPopup.board = board;
            this.editPopup.show = true;
        },

        onEditExtractMentionUser: function (text) {
            MENTION_USERS = [];
            if (!_.isEmpty(text)) {
                var ckResult = ckEditorHtmlToText(text, USERS_FOR_EDITOR);
                if (ckResult && ckResult.mentions && ckResult.mentions.length > 0) {
                    MENTION_USERS = ckResult.mentions
                }
            }
        },

        closeImpedimentPopup: function () {
            this.editPopup.show = false;
        },

        saveImpedimentPopup: function (event, impdtView) {
            console.log(event, impdtView)
            this.editPopup.show = false;
            showTopMessage(event.key + " has been updated.", "success");
        },		
	},
})