const LIST_LINKED_ITEMS = Vue.component('list-linked-items', {
    mixins: [CALCULATION_SETTINGS_MIXIN],
    props: {
        linkedItems: {
            type: Array,
            default: () => {
                return [];
            }
        },
		linkedItemsById : {
			type: Object,
			default: () => {
				return {};
			}			
		},
		objectiveTeam: {
			type: Object,
			default: () => {
				return {};
			}
		},
		board: {
			type: Object,
			default: () => {
				return {};
			}
		},		
        showList: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        readOnlyView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        completionCriteria: {
            type: String,
            default: () => {
                return "";
            }
        },
        removeItemPermission: {
            type: Boolean,
            default: () => {
                return true;
            }
        },
		showUnLinkedItems: {
            type: Boolean,
            default: () => {
                return false;
            }			
		},
        isBackLogItemsMode: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
		showBoardLinkedItem: {
            type: Boolean,
            default: () => {
                return false
            }				
		},
        isMockingMode: {
            type: Boolean,
            default: () =>{ return false }
        },
        isPiMilestoneView: {
            type: Boolean,
            default: () =>{ return false }
        },
    },

    template: `
		<div>
			<ul class="o-items table prow" :class="[showList ? 'd-block': '']">
				<template v-if="!showUnLinkedItems">
					<template v-for="(linkData,linkIndex) in linkedItems">
						<li class="" v-if="showLinkedItem(linkData)" :key="linkData.randomId" :class="[linkedItems[linkIndex].expandChild ? 'active' : '' ]">
							<em v-if="linkData.subItems && linkData.subItems.length > 0" class="ti-angle-right acrd-arrin" @click="onClickLinkAccordian(linkIndex)"></em>
							<div class="rec aa mb-0" @click="onClickLinkAccordian(linkIndex)">
								<div style="border: 0" class="rc c2 rpttl">
									<template v-if="!linkData.highlightedKey">
										<template v-if="linkData.tfsId">
											<a :href="linkData.tfsURL" target="_blank">{{linkData.tfsId}}</a>
											<img v-if="!_.isEmpty(linkData.tfsItemTypeIcon)" :src="linkData.tfsItemTypeIcon" alt="Azure" class="azurico">										
										</template>
										<a v-else-if="linkData.kendisKey"  class="ky mr-5" href="javascript:void(0);">{{linkData.kendisKey}}</a>
										<a v-else-if="linkData.jiraKey"  class="ky mr-5" :href="resolveJiraAndKendisOnlyUrl(linkData)" :class="itemIcon(linkData)" target="_blank" @click="handleLinkClick($event, linkData)">{{linkData.jiraKey}}</a>
									</template>
									<template v-else>
										<template v-if="linkData.tfsId">
											<a :href="linkData.tfsURL" target="_blank"><span v-html="linkData.highlightedKey"></span></a>
											<img v-if="!_.isEmpty(linkData.tfsItemTypeIcon)" :src="linkData.tfsItemTypeIcon" alt="Azure" class="azurico">										
										</template>
										<a v-else-if="linkData.kendisKey"  class="ky mr-5" href="javascript:void(0);"><span v-html="linkData.highlightedKey"></span></a>
										<a v-else-if="linkData.jiraKey"  class="ky mr-5" :href="resolveJiraAndKendisOnlyUrl(linkData)" :class="itemIcon(linkData)" @click="handleLinkClick($event, linkData)"><span v-html="linkData.highlightedKey"></span></a>
									</template>
									<span v-if="linkData.highlightedTitle" :title="linkData.title" v-html="linkData.highlightedTitle"></span>
									<span v-else :title="linkData.title" v-html="linkData.title"></span>
								</div>
								<div style="border: 0" class="rc c4 status" title="Status">
									<span v-if="linkData.status" class="sts FL" :class="statusCategoryClass(linkData)">{{linkData.status.title}}</span>
								</div>
								<div style="border: 0" class="rc c4 statuses" title="Child counts">
									<div class="statuses_cat">
										<span v-if="linkData.childContByStatus && linkData.childContByStatus['ToDo']" title="ToDo"
											class="sts a fs-10">{{linkData.childContByStatus['ToDo']}}</span>
										<span v-if="linkData.childContByStatus && linkData.childContByStatus['InProgress']" title="In Progress"
											class="sts b fs-10">{{linkData.childContByStatus['InProgress']}}</span>
										<span v-if="linkData.childContByStatus && linkData.childContByStatus['Done']" title="Done"
											class="sts c fs-10">{{linkData.childContByStatus['Done']}}</span>
                                        <span v-if="linkData.childContByStatus && linkData.childContByStatus['Misc']" title="Misc"
                                        class="sts d fs-10">{{linkData.childContByStatus['Misc']}}</span>
									</div>
								</div>
								<div style="border: 0" class="rc c4 w2">
									<div class="prct_cat">
										<span class="prct FR font-sbold"></span>
										<template>{{itemCompletion(linkData)+'%'}}</template>
									</div>
								</div>
								<div style="border: 0" class="rc c4 w2 points" title="Estimates">
									<span>{{getFormatedDecimal(linkData.storyPoints)}}</span>
								</div>
								<div style="overflow: visible; border: 0" class="rc c4 tmtg wd-m">
									<template v-for="team in linkData.teams">
										<div v-if="team" class="tm lbl-bg tooltip" :style="{color:team.color}">
											<div v-if="!_.isEmpty(team) && team.label" class="line" :style="{backgroundColor:team.color}"></div>
											<template v-if="!_.isEmpty(team) && team.label">{{team.label}}</template>
											<div class="hovtooltipB">{{team.title}}</div>
										</div>
									</template>
								</div>
								<div style="overflow: visible; border: 0" class="rc c4 spctg wd-m">
									<template v-for="container in linkData.containers">
										<span v-if="!_.isEmpty(container) && container.label" class="tooltip">
											<template v-if="!_.isEmpty(container) && container.label">{{container.label}}</template>
											<div class="hovtooltipB">{{container.title}}</div>
										</span>
									</template>
								</div>
								<em v-if="removeItemPermission && !readOnlyView && ((!showBoardLinkedItem && isMockingMode) || !isMockingMode)" class="rmv-ico ti-close e rnd sml DAJ" @click.stop="onClickRemoveLink(linkIndex)" title="Remove"></em>
							</div>
							<ul v-if="linkedItems[linkIndex].expandChild" class="sub-items c">
								<div v-for="child in linkData.subItems" class="rec aa" v-if="showLinkedItem(child)">
									<div style="border: 0" class="rc c2 rpttl">
										<template v-if="child.tfsId">
											<a :href="child.tfsURL" target="_blank">{{child.tfsId}}</a>
											<img v-if="!_.isEmpty(child.tfsItemTypeIcon)" :src="child.tfsItemTypeIcon" alt="Azure" class="azurico">										
										</template>
										<a v-else-if="child.kendisKey" href="javascript:void(0);">{{child.kendisKey}}</a>
										<a v-else-if="child.jiraKey" :href="resolveJiraAndKendisOnlyUrl(child)" :class="itemIcon(child)" target="_blank" @click="handleLinkClick($event, child)">{{child.jiraKey}}</a>
										{{child.title}}
									</div>
									<div style="border: 0" class="rc c4 status" title="Status">
										<span v-if="child.status" class="sts FL"
											:class="statusCategoryClass(child)">{{child.status.title}}</span>
									</div>
									<div style="border: 0" class="rc c4 statuses" title="Child counts">
										<div class="statuses_cat"></div>
									</div>
									<div style="border: 0" class="rc c4 w2 ">
										<div class="prct_cat">
											<span class="prct FR font-sbold"></span>
										</div>
									</div>
									<div style="border: 0" class="rc c4 w2 points" title="Estimates">
										<span>{{getFormatedDecimal(child.storyPoints)}}</span>
									</div>
									<div style="overflow: visible; border: 0" class="rc c4 tmtg wd-m">
										<template v-for="team in child.teams">
											<div v-if="team" class="tm lbl-bg tooltip"
												:style="{color:team.color}">
												<div v-if="!_.isEmpty(team) && team.label" class="line" :style="{backgroundColor:team.color}">
												</div>
												<template v-if="!_.isEmpty(team) && team.label">{{team.label}}</template>
												<div class="hovtooltipB">{{team.title}}</div>
											</div>
										</template>
									</div>
									<div style="overflow: visible; border: 0" class="rc c4 spctg wd-m">
										<template v-for="container in child.containers">
											<span v-if="!_.isEmpty(container) && container.label" class="tooltip">
												<template v-if="!_.isEmpty(container) && container.label">{{container.label}}</template>
												<div class="hovtooltipB">{{container.title}}</div>
											</span>
										</template>
									</div>
								</div>
							</ul>
						</li>
					</template>
				</template>
				<template v-if="!_.isEmpty(linkedItemsById)">
					<template v-for="(item,val) in linkedItemsById">
						<li class="rec" :class="[(isCurrentSessionItem(item) ? '' : 'disabled')]" :data-sb="item.session_id ? item.session_id : ''"	:data-stitle="item.session_title ? item.session_title : ''">
							<div style="border:0;font-style: italic;width:100% !important;" class="rc c2">
								<span class=" delwgt"><a target="_blank" :href="item.externalReferenceURL">{{item.key }}</a></span>
								Item does't exist on the board 2
							</div>
							<a @click="removeLinkedExternalItemId(val, item)" title="Unlink Item" v-if="removeItemPermission && !readOnlyView" href="javascript:void(0);" class="rmv-ico ti-close e rnd sml DAJ"></a>
						</li>
					</template>
				</template>			
			</ul>
		</div>
    `,

    data() {
        return {
			boardMap: {},	
		}
    },

    watch: {
        linkedItems: {
            handler: function (newList, oldList) {
                this.populateItemsData(newList);
            },
            immediate: true
        }
    },
	computed: {
		showLinkedItem: function() {
			let _this = this;
			return function(item) {
				let show = false;
                if(_this.verifyItemsToExclude(item, _this.excludeItemsData)){
                    if (_this.completionCriteria === "TEAM_STORY_STATUS" || _this.completionCriteria === "TEAM_STORY_ESTIMATE"){
                        if(_.isEmpty(_this.objectiveTeam)) {
                            show = true;
                        }
                        if(!_.isEmpty(item.teamContainers)) {
                            if (item.type === "UserStory"){
                                let containers = item.teamContainers;
                                for(let i = 0; i < containers.length;  i++) {
                                    if(containers[i].team && containers[i].team.id == _this.objectiveTeam.id) {
                                        show = true;
                                        break;
                                    }
                                }
                            }else{
                                show = true;
                            }
                        }else if (item.type === "Feature" && _.isEmpty(item.subItems) && _.isEmpty(item.teamContainers)){
                            show = true;
                        }
                    }else{
                        show = true;
                    }
                }
				return show
			}
		},
		itemIcon: function() {
			return function(item) {
				return getItemIcon(item);
			}
		},
		isCurrentSessionItem: function () {
			return function (item) {
				if (item.sessionBoard_id != undefined && item.sessionBoards == undefined) {
					item.sessionBoards = [{ id: item.sessionBoard_id, session: { id: item.session_id } }];
				}

				if (item.session_id != undefined && item.sessionBoards[0].session == undefined) {
					item.sessionBoards[0].session = { id: item.session_id };
				}

				if (this.boardId) {
					var ret = item.sessionBoards[0].id === this.boardId;
					if (ret) {
						if (item.sessionBoard_id && this.risk.activeBoardIds && !this.risk.activeBoardIds[this.boardId]) {
							return false;
						}
						return true;
					} else if (item.sessionBoard_id != undefined && this.sessionId && item.sessionBoards[0].session.id === this.sessionId) {
						if (this.risk.activeBoardIds && !this.risk.activeBoardIds[this.boardId]) {
							return false;
						} else {
							return true;
						}
					} else {
						return false;
					}
				} else {
					return true;
				}
			};
		},
		
        itemCompletion: function (){
            return function (item){
                let itemCompletion = 0;
                if (item.type === "Feature" && item.subItems && item.subItems.length > 0) {
                    if (this.completionCriteria === "LINKED_ITEM_STATUS" && item.status && item.status.category === "Done") {
                        itemCompletion = 100;
                    }else if(this.completionCriteria === "CHILDREN_LINKED_ITEM_STATUS"){
                        let doneChildItems = 0;
                        let totalChildItems = 0;

                        _.each(item.subItems, subItem => {
                            if (this.verifyItemsToExclude(subItem, this.excludeItemsData)){
                                if (subItem.status && subItem.status.category === "Done") {
                                    doneChildItems 	+= 1;
                                }
                                totalChildItems += 1;
                            }
                        });

                        if (totalChildItems > 0){
                            itemCompletion = (doneChildItems/totalChildItems)*100;
                            itemCompletion = Math.round((itemCompletion + Number.EPSILON) * 100) / 100;
                        }

                    }else if (this.completionCriteria === "CHILDREN_LINKED_ITEM_ESTIMATE"){
                        let doneStoryPoints = 0;
                        let totalStoryPoints = 0;

                        _.each(item.subItems, subItem => {
                            if (this.verifyItemsToExclude(subItem, this.excludeItemsData)){
                            	if(!isNaN(Number(subItem.storyPoints))){//DEV-9320
                                if (subItem.status && subItem.status.category === "Done") {
                                    doneStoryPoints += subItem.storyPoints;
                                }
                                totalStoryPoints 	+= subItem.storyPoints;
                            	}
                            }
                        });
						if(totalStoryPoints > 0) {
	                        itemCompletion = (doneStoryPoints/totalStoryPoints)*100;
	                        itemCompletion = Math.round((itemCompletion + Number.EPSILON) * 100) / 100;
						}

                    }else if (this.completionCriteria === "TEAM_STORY_STATUS"){
                        let doneTeamItems = 0;
                        let totalTeamItems = 0;
                        _.each(item.subItems, subItem => {
                            if (this.verifyItemsToExclude(subItem, this.excludeItemsData)){
                                 if (!_.isEmpty(this.objectiveTeam)) {
                                    if (!_.isEmpty(subItem.teamContainers)){
                                        let isTeamStory = false;
                                        for (let i = 0; i < subItem.teamContainers.length; i++) {
                                            isTeamStory = subItem.teamContainers[i].team.id === this.objectiveTeam.id;
                                            if (isTeamStory) {
                                                break;
                                            }
                                        }
                                        if (isTeamStory) {
                                            totalTeamItems 		+= 1;
                                            if (subItem.status && subItem.status.category === "Done") {
                                                doneTeamItems 	+= 1;
                                            }
                                        }
                                    }
                                }else{
                                    totalTeamItems 		+= 1;
                                    if (subItem.status && subItem.status.category === "Done") {
                                        doneTeamItems 	+= 1;
                                    }
                                }
                            }
                        });

                        if (totalTeamItems > 0){
                           itemCompletion = (doneTeamItems/totalTeamItems)*100;
                           itemCompletion = Math.round((itemCompletion + Number.EPSILON) * 100) / 100;
                        }

                    }else if (this.completionCriteria === "TEAM_STORY_ESTIMATE"){
                        let doneTeamItemsStoryPoints = 0;
                        let totalTeamItemsStoryPoints = 0;
                        _.each(item.subItems, subItem => {
                            if (this.verifyItemsToExclude(subItem, this.excludeItemsData)){
                                if (!_.isEmpty(this.objectiveTeam)) {
                                    if (!_.isEmpty(subItem.teamContainers)){
                                        let isTeamStory = false;
                                        for (let i = 0; i < subItem.teamContainers.length; i++) {
                                            isTeamStory = subItem.teamContainers[i].team.id === this.objectiveTeam.id;
                                            if (isTeamStory) {
                                                break;
                                            }
                                        }
                                        if (isTeamStory) {
                                        	if(!isNaN(Number(subItem.storyPoints))){//DEV-9320
                                            totalTeamItemsStoryPoints 		+= subItem.storyPoints;
                                            if (subItem.status && subItem.status.category === "Done") {
                                                doneTeamItemsStoryPoints 	+= subItem.storyPoints;
                                            }
                                        	}
                                        }
                                    }
                                }else{
                                	if(!isNaN(Number(subItem.storyPoints))){//DEV-9320
                                    totalTeamItemsStoryPoints 		+= subItem.storyPoints;
                                    if (subItem.status && subItem.status.category === "Done") {
                                        doneTeamItemsStoryPoints 	+= subItem.storyPoints;
                                    }
                                	}
                                }
                            }
                        });
						if(totalTeamItemsStoryPoints > 0) {
	                        itemCompletion = (doneTeamItemsStoryPoints/totalTeamItemsStoryPoints)*100;
	                        itemCompletion = Math.round((itemCompletion + Number.EPSILON) * 100) / 100;
						}
                    }
                }else if(_.isEmpty(item.subItems) && this.completionCriteria === "LINKED_ITEM_STATUS" && item.status && item.status.category === "Done"){
                    itemCompletion = 100;
                }

                return itemCompletion;
            }
        },
        excludeItemsData: function() {
            return kendisStore.getters.getExcludeItemsData();
        }
	},
	
    created() {
    },

    mounted() {
        this.populateItemsData(this.linkedItems);
    },

    methods: {

        onClickLinkAccordian: function (itemIndex) {
            this.linkedItems[itemIndex].expandChild = !this.linkedItems[itemIndex].expandChild;
            this.$forceUpdate();
        },

        populateItemsData: function (items) {
            let _this = this;
            if (items && items.length > 0) {
                _.each(items, function (item) {
                    let containers = [];
                    let teams = [];
                    //.......................
                    let teamContainers = _this.getTeamAndContainers(item);
                    containers = teamContainers["containers"]
                    teams = teamContainers["teams"]
                    //.......................
                    item.containers = _.isEmpty(containers) ? [{}] : containers;
                    item.teams = _.isEmpty(teams) ? [{}] : teams;
                    if (item.subItems && item.subItems.length > 0) {
                        let storyPoints = 0;
                        let childCount = {"ToDo": 0, "InProgress": 0, "Done": 0, "Misc": 0};
                        _.each(item.subItems, child => {
                            let teamContainers = _this.getTeamAndContainers(child);
                            child.containers = teamContainers["containers"];
                            child.teams = teamContainers["teams"];
                            if (child.status) {
                                storyPoints += (child.storyPoints ? child.storyPoints : 0);
                                if (_this.verifyItemsToExclude(child, _this.excludeItemsData)){
                                    childCount[child.status.category] += 1;
                                }
                            }
                        });
                        item.childContByStatus = childCount;
                        item.storyPoints = storyPoints;
                    }
                    item.expandChild = false;
                })
            }
        },

        getTeamAndContainers: function (item) {
            let _this = this;
            let teams = [];
            let containers = [];
            if (!_.isEmpty(item.teamContainers)) {
                _.each(item.teamContainers, tc => {

                    //.........................
                    let teamExist = false;
                    _.each(teams, et => {
                        if (et && et.id === tc.team.id) {
                            teamExist = true;
                            return;
                        }
                    });
                    if (!teamExist) {
						team = {};
						if(_this.showBoardLinkedItem) {
							team = _.find(_this.board.teams, {id: tc.team.id})
						} else {
	                        team = _.find(_this.$parent.board.teams, {id: tc.team.id});
						}
						if(!_.isEmpty(team)) {							
	                        teams.push(team);
						}
                    }
                    //........................
                    let containerExist = false;
                    _.each(containers, et => {
                        if (et && et.id === tc.container.id) {
                            containerExist = true;
                            return;
                        }
                    });
                    if (!containerExist) {
                        let container = {}
						if(_this.showBoardLinkedItem) {
							container = _.find(_this.board.containers, {id: tc.container.id});							
						} else {
							container = _.find(_this.$parent.board.containers, {id: tc.container.id});
						}
                     containers.push(container);
                    }
                });
            }
            return {"teams": teams, "containers": containers};
        },

        getFormatedDecimal: function (value) {
            if (!value) {
                return 0;
            }
            return getFormated(value);
        },

		removeLinkedExternalItemId: function (itemId) {
			var _this = this;
			var item = {};
			item.id = itemId;
			item.isDeletedItem = true;
            askFromSweetAlertWrapper("Do you want to remove this link?",
                [_this.unlinkItem, item],[takeNoAction]);			
		},
        onClickRemoveLink: function (index) {
            let _this = this;
            let item = _this.linkedItems[index];
            let message = "";
            if(_this.isPiMilestoneView) {
                message = "Are you sure you want to unlink this item? Doing so will result in unlinking it from all the release trains and PI boards."
            }else{
                message = "Do you want to remove this link?"
            }
            askFromSweetAlertWrapper(message,
                [function () {
                    if (_this.isPiMilestoneView) {
                        _this.$emit("remove-item-from-milestone", item);
                    } else {
                        _this.unlinkItem(item);
                    }
                }],
                [takeNoAction]);
        },

        unlinkItem: function (item) {
            let _this = this;
            let requestBody = {};
            if (_this.$parent.objectiveData) {
                requestBody.id = _this.$parent.objectiveData.id;
            }else if (_this.$parent.fieldsValue.id){
                requestBody.id = _this.$parent.fieldsValue.id;
            }
            requestBody.itemId = item.id;
            if (_this.$parent.objectiveData && _this.$parent.objectiveData.type === "KR"){
                requestBody.metaMap = {
                    "syncId" : syncId,
                    "sessionId" : vueInstance.activeBoard.session.id,
                    "objectiveId" : _this.$parent.$parent.objectiveData.id
                }
            }else{
                requestBody.metaMap = {
                    "syncId" : syncId,
                    "sessionId" : vueInstance.activeBoard.session.id,
                }
            }
            axios.post('sos/remove-base-item-link', requestBody)
                .then(response => {
                    if (response && response.status == "200") {
                        _.remove(_this.linkedItems, {id: item.id});
						if(_this.linkedItemsById[item.id]) {
							delete _this.linkedItemsById[item.id]
						}
                        // _this.$forceUpdate();
                        _this.$emit("remove-link", item.id);
                    }
                })
                .catch(error => {
                    console.error("Item Link remove error", error);
                    handleSoSErrorMsg(error);
                })
        },
		statusCategoryClass: function(item) {
			if(item.status.category == "ToDo") {
				return 'a';
			} else if(item.status.category == "InProgress") {
				return 'b';
			} else if(item.status.category == "Done") {
				return 'c';
			} else if(item.status.category == "Misc") {
				return 'd';
			}				
		},
		resolveJiraAndKendisOnlyUrl: function(linkData) {
			if(!_.isEmpty(linkData.jiraURL)) {
				return linkData.jiraURL;
			} else if(!_.isEmpty(linkData.externalReferenceURL) && linkData.externalReferenceURL !== "javascript:void(0);") {
				return linkData.externalReferenceURL;
			} else if(!_.isEmpty(linkData.jiraId) && !_.isEmpty(this.board)){
                let baseURL = getBoardBaseUrl(this.board);
                return baseURL + "/" + linkData.jiraKey;
			} else {
				return '';
			}
		},
		handleLinkClick(event, item) {
            let link = this.resolveJiraAndKendisOnlyUrl(item);
            if (link === '') {
              event.preventDefault();
            }
        }
    }
});