const LIST_BATCHES = Vue.component('list-batches', {
	props: {
            releaseTrainId: {
                type: String,
                default: () => { return "" }
            },

	},
	template:`
	<div>
	    <dynamic-popup-container 
	         v-if="itemTemplate.showEditPopUp"
	         @close = "onCLoseEditPopUp"
	         @save = "onSaveBatch"
	         :template-to-render="itemTemplate.templateToRenderer"
	         :template-statuses = "itemTemplate.statuses"
	         :item-type="itemTemplate.itemType"
	         :fields-value="itemTemplate.model"
	         :template = "itemTemplate"
	         :show-attachments="false"
	         :show-watchers="true"
	         :show-history="true"
	         :show-conversations="true"
	         :entity-type="'BaseItem'"
	         :entity-id="itemTemplate.id"
	         :show-external-entities="false"
		     :displayMode ="'Batches'"
		     :edit-permission="true"
		     :showNotifyWatchers="false"
			 :system-fields="layout ? layout.systemFieldsToExclude : []"
			 ref="itemPopup"
	    />
	
         <div class="sebaraa DFCB">
           <div class="DFA">
					<a v-if="!isExpandAll" title="Maximize All" @click="$root.batches.expandAll=$root.batches.expandAll+1; isExpandAll=!isExpandAll" class="c-point">   <em class="ti-angle-right arrdn DIB mr-10 fs-10"></em>Expand All</a>
					<a v-if="isExpandAll" title="Minimize All" @click="$root.batches.minimizeAll=$root.batches.minimizeAll+1; isExpandAll=!isExpandAll" class="c-point"><em class="ti-angle-down arrdn DIB mr-10 fs-10"></em>Collapse All</a>
					<!--<a title="Minimize All" @click="$root.batches.minimizeAll=$root.batches.minimizeAll+1" class="minimize-btch iconw mr-10 "></a>-->
		   </div>
		   <div class="DFA">
               <div class="p-rel srchTopaa">
                    <i class="srch ti-search nww srchfiltico"></i>
                    <input v-model="filters.searchText" type="text" placeholder="Search..." class="activeText filtersearch" @input="onFiltersChangeSearchText">
               </div>
               <button v-if="$options.permissions && $options.permissions.MANAGE_BATCH_GROUP"  @click="onAddBatchClick" class="ti-plus addf AddBatchGroupBtn">Add Batch Group</button>
           </div>
	   </div>
			
		<div class="table bccontent">
			<div class="rec hd"> 
                <div class="rc c2">
                    <span class="pl-5">Title</span>
                </div>
                <div class="rc c3">
                    <span class="pl-5">Progress</span>
                </div>
                <div class="rc c3">
                    <span class="pl-5">Responsibles</span>
                </div>
                <div class="rc c3">
                    <span class="pl-5">Start Date</span>
                </div>
                <div class="rc c3">
                    <span class="pl-5">End Date</span>
                </div>
                <div class="rc c4">
                    <span class="pl-5">Status</span>
                </div>
                <div v-if="$options.permissions && $options.permissions.MANAGE_BATCH_GROUP"  class="rc c3">
                    <span class="pl-5 wht-nwrp">New Sub-Batch</span>
                </div>
			</div>
			<draggable :value="sortedfilteredBatchList"
							    animation=150 easing="cubic-bezier(1, 0, 0, 1)"
								@start="onItemDragStart"
								@end="onItemDragEnd" >
                    <batch-group-component v-for="(batch, batchIndex) in sortedfilteredBatchList" 
                    :batch-index ="batchIndex.toString()"
                    :batch-group-obj="batch"
                    :key="batch.id+'-'+batch.baseItemList+'-'+$root.flags.batchLoadedTrigger+'-'+$root.flags.isBatchCompletionMapLoaded"
                    @add-sub-batch-event="onAddSubBatchInGroupEvent"/>  
			</draggable>
		</div>
	</div>
	`,
	data() {
		return {
			isLoaded : false,
            itemTemplate: {
                showEditPopUp: false,
                showMileStonePopup: false,
                templateToRenderer: {},
                statuses: [],
                itemType: {},
                releaseTrainId:"",
            },
            filters: {
                searchText: "",
            },
            filteredBatchList:[],
			layout : {},
            isExpandAll: false,
            sortedfilteredBatchList:[],
		}
	},
	computed: {},
	created() {
		this.$options.permissions = kendisStore.getters.getBatchesPermissions();
		//this.fetchBatchGroupDefaultLayout();
	},
	mounted() {
        this.filteredBatchList = _.cloneDeep(this.$root.batches.treeForm);
    },
    unmounted(){
        // this.removeHighlightedTextFromBatches();
    },
    watch:{
        'filteredBatchList': function (value) {
            let _this = this;
            let unsortedBatchList = _.clone(value);
            unsortedBatchList.sort(function (a, b) {
                return a.sequence - b.sequence;
            });
            Vue.set(_this,'sortedfilteredBatchList',unsortedBatchList);
        },
        '$root.batches.treeForm': {
            handler: function(value) {
                this.filteredBatchList = _.clone(value);
            },
            deep: true,


        },

    },
	methods:{
		fetchBatchGroupDefaultLayout : function () {
			var _this = this;
			axios.get("/customfield/get/default-layout/" + "batch_group")
				.then(response => {
					if (response.data) {
						_this.layout = response.data;
					}
				}).catch(error => {

				});
		},
        // removeHighlightedTextFromBatches: function () {
        //     let _this = this;
        //     _this.filteredBatchList.forEach(function (batch) {
        //         Vue.set(batch,'highlightedText',"") ;
        //         Vue.set(batch,'highlightedKey',"") ;
        //         if(batch.baseItemList && batch.baseItemList.length > 0){
        //             _this.removeHighlightedTextFromChildBatches(batch);
        //         }
        //     })
        //
        //
        // },
        // removeHighlightedTextFromChildBatches: function (batch) {
        //     let _this = this;
        //     if(batch.baseItemList && batch.baseItemList.length > 0){
        //         batch.baseItemList.forEach(function (item) {
        //             Vue.set(item,'highlightedText',"") ;
        //             Vue.set(item,'highlightedKey',"") ;
        //             _this.removeHighlightedTextFromChildBatches(item);
        //         })
        //     }
        // },
        onAddSubBatchInGroupEvent: function (newSubBatch, parentBatchId) {
            //add in baseItemList of parentBatch filteredBatchList
            let _this = this;
            let parentBatchIndex = _.findIndex(_this.filteredBatchList, {id: parentBatchId});
            if (parentBatchIndex !== -1) {
                _this.filteredBatchList[parentBatchIndex].baseItemList.push(newSubBatch);
                _this.filteredBatchList[parentBatchIndex].showChildren = true;
            }
        },
        onItemDragEnd: function(evt) {
            this.sortBatch(evt.newIndex, evt.oldIndex);
        },
        onItemDragStart: function(evt) {

        },
        calculateNewSequenceOfItem: function(newIndex, oldIndex, list, key) {
            var sequence;
            if (_.isEmpty(list)) {
                sequence = 0;
            } else {
                if (newIndex == 0) {
                    var nextItem = list[0]
                    sequence = nextItem[key] - 1000;

                } else if (newIndex >= list.length - 1) {
                    var preItem = list[list.length - 1];
                    sequence = preItem[key] + 1000;

                } else {

                    var preItem;
                    var nextItem;

                    if (oldIndex == -1 || oldIndex > newIndex) {
                        preItem = list[newIndex - 1];
                        nextItem = list[newIndex];
                    }
                    else {
                        preItem = list[newIndex];
                        nextItem = list[newIndex + 1];
                    }

                    sequence = (parseFloat(preItem[key]) + parseFloat(nextItem[key])) / 2.0;
                }
            }
            return { value: sequence, key: key };
        },
        sortBatch: function(newIndex, oldIndex) {
            var _this = this;
            var item = this.sortedfilteredBatchList[oldIndex];
            var sequenceObject = this.calculateNewSequenceOfItem(newIndex, oldIndex, this.sortedfilteredBatchList, "sequence");
            // value, key
            var data = {};
            data.batchId = item.id;
            data.sequence = "" + sequenceObject.value;
            // this.loading=true;
            axios.post('/batch/update-batch-sequence/'+syncId, data)
                .then(res => {
                    if (res.status=="200") {

                        _this.filteredBatchList.forEach(function (batch) {
                            if (batch.id == item.id) {
                                Vue.set(batch, "sequence", sequenceObject.value); //must be numeric
                            }
                        });
                        //changing sequence in treeForm global data
                        _this.$root.batches.treeForm.forEach(function (batch) {
                            if (batch.id == item.id) {
                                Vue.set(batch, "sequence", sequenceObject.value);
                            }
                        });
                    }else{
                        onAlmError(res.data.error);
                    }
                    // _this.loading=false;

                }).catch(error => {
                // _this.loading=false;
                console.log(error)
            });
        },
        onCLoseEditPopUp: function () {
            let _this = this;
            _this.itemTemplate.showEditPopUp = false;
            _this.$forceUpdate();
        },
        onFiltersChangeSearchText: function () {
            let _this = this;

            if(!_this.filters.searchText || _.isEmpty(_this.filters.searchText.trim()) ){
                _this.filteredBatchList.forEach(function (batch) {
                    Vue.set(batch,'isFiltered',true) ;
                })
                _this.traverseAndModifyTree("");
                return;
            }

            clearTimeout(this.debounceTimer); // Clear previous debounce timer
            this.debounceTimer = setTimeout(() => {

                if (_this.filters.searchText.length > 0) {
                    this.traverseAndModifyTree(_this.filters.searchText);
                } else {
                    _this.filteredBatchList.splice(0, _this.filteredBatchList.length);
                    _this.$root.batches.treeForm.forEach(function (batch) {
                        Vue.set(_this.filteredBatchList, _this.filteredBatchList.length, _.cloneDeep(batch));
                    })
                }
            }, 200);
            },
        highlightText: function (text, searchTerm) {
            const searchTermEscaped = searchTerm.replace(/[()\\]/g, '\\$&');
            const regex = new RegExp(`(${searchTermEscaped})`, 'gi');
            let result = text.replace(regex, '<b style="background-color: yellow">$1</b>');
            return result;
        },
        traverseAndModifyTree(searchedText){
            try{
                //traverse $root.batches.treeForm and modify titles of matching nodes
                let _this = this;
                let batchList = _this.filteredBatchList;
                batchList.forEach(function (batch) {
                    Vue.set(batch,'highlightedText',"") ;
                    Vue.set(batch,'highlightedKey',"") ;
                    let foundInParent = false;
                    if(_.isEmpty(searchedText.trim())){
                        Vue.set(batch,'highlightedText',"") ;
                        Vue.set(batch,'highlightedKey',"") ;
                    }
                    if(batch.title.toLowerCase().indexOf(searchedText.toLowerCase().trim()) !== -1) {
                        Vue.set(batch, 'highlightedText', _this.highlightText(batch.title, searchedText.trim()));  Vue.set(batch, "isFiltered", true);
                        if(searchedText.trim().length > 0) {
                            Vue.set(batch, "showChildren", true);
                        }
                        foundInParent = true;

                    }
                    if(batch.key.toLowerCase().indexOf(searchedText.toLowerCase().trim()) !== -1){
                        Vue.set(batch,'highlightedKey',_this.highlightText(batch.key,searchedText.trim())) ;
                        Vue.set(batch, "isFiltered", true);
                        if(searchedText.trim().length > 0) {
                            Vue.set(batch, "showChildren", true);
                        }
                        foundInParent = true;
                    }
                let isFoundObj = {found:false};
                _this.fetchAndMatchChildBatches(batch,searchedText,isFoundObj);
                    if(isFoundObj.found){
                        Vue.set(batch, "isFiltered", true);
                        if(searchedText.trim().length > 0) {
                            _this.expandTree(batch);
                        }
                    }else if(!foundInParent){
                        Vue.set(batch, "isFiltered", false);
                    }
                    });
            }catch (e) {
                console.log(e);
            }
        },
        expandTree(batch){
            let _this = this;
            Vue.set(batch,'showChildren',true) ;
            if(batch.baseItemList && batch.baseItemList.length > 0){
                batch.baseItemList.forEach(function (item) {
                    _this.expandTree(item);
                })
            }

        },
        fetchAndMatchChildBatches(batch,searchedText,isFoundObj){
            let _this = this;
            if(!batch.baseItemList || _.isEmpty(batch.baseItemList)){
                return;
            }
            if(batch.baseItemList && batch.baseItemList.length > 0){
                batch.baseItemList.forEach(function (item) {
                    Vue.set(item,'highlightedText',"") ;
                    Vue.set(item,'highlightedKey',"") ;
                    if(_.isEmpty(searchedText.trim())){
                        Vue.set(item,'highlightedText',"") ;
                        Vue.set(item,'highlightedKey',"") ;

                    }
                    if(item.title.toLowerCase().indexOf(searchedText.toLowerCase().trim()) !== -1) {
                        isFoundObj.found = true;
                        Vue.set(item, 'highlightedText', _this.highlightText(item.title, searchedText.trim()));
                    }

                    if(item.key.toLowerCase().indexOf(searchedText.toLowerCase().trim()) !== -1){
                            isFoundObj.found = true;
                            Vue.set(item,'highlightedKey',_this.highlightText(item.key,searchedText.trim())) ;
                    }
                    _this.fetchAndMatchChildBatches(item,searchedText,isFoundObj);
                })
            }
        },

        onAddBatchClick: function() {
			let _this = this;
	        _this.itemTemplate = {};
	        _this.itemTemplate.model = {};
	        _this.itemTemplate.model.fields = {};
            _this.itemTemplate.model.status = {};
            //fixed headercolor if not selected
            _this.itemTemplate.model.headerColor = ""
            _this.itemTemplate.model.imageIcon = {};


            _this.itemTemplate.statuses = [];
            if (_.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"}) !== -1) {
                _this.itemTemplate.model.status = _.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"});
            }
		    _this.itemTemplate.templateToRenderer = kendisStore.getters.getBatchGroupTemplate().scheme.fieldsTemplate;
			_this.itemTemplate.statuses = kendisStore.getters.getBatchGroupTemplate().statuses;
            _this.itemTemplate.itemType = kendisStore.getters.getBatchGroupTemplate().scheme.itemType;			
	        _this.itemTemplate.showEditPopUp = true;
			_this.$forceUpdate();
			Vue.nextTick(function() {
				if (!_.isEmpty(_this.layout && _this.layout.fields)) {
					if (_this.$refs.itemPopup) {
						_.each(_this.layout.fields, (field) => {
							_this.$refs.itemPopup.onAddCustomFieldInContainer(field);
						});
					}
				}
			});
		},

        setBaseItemStatus: function (requestBody) {
            if (_.isEmpty(requestBody.status)) {
                if(requestBody.type=="Batch"){
                    if (_.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"}) !== -1) {
                        requestBody.status = _.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"});
                    }
                }else{
                    if (_.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"}) !== -1) {
                        requestBody.status = _.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"});
                    }
                }
            }
        },
		onSaveBatch: function(requestBody) {
			console.log("Data", requestBody)
            let _this = this;
			delete requestBody.bvPlan;
			delete requestBody.bvActual;
            let selfLink = {type: "batch_group"};
			if(!_.isEmpty(requestBody.layout)) {
				selfLink.layout = requestBody.layout;
				delete requestBody.layout;
			}
			if(!_.isEmpty(requestBody.childLayout)) {
				selfLink.childLayout = requestBody.childLayout;
				delete requestBody.childLayout;
			}
            requestBody.baseItemLinks = [];

            //attaching releaseTrain
            if(_this.releaseTrainId && !_.isEmpty(_this.releaseTrainId)){
                let releaseTrainLink = {type: "release_train_batch", releaseTrainId:_this.releaseTrainId};
                requestBody.baseItemLinks.push(releaseTrainLink);
            }
            requestBody.baseItemLinks.push(selfLink);
            requestBody.starred = false;
            //add seqeunce i.e. less than the first batch group
            if(_this.sortedfilteredBatchList.length > 0) {
                if(_this.sortedfilteredBatchList[0].sequence){
                    requestBody.sequence = _this.sortedfilteredBatchList[0].sequence - 1000;
                }
            }
            this.setBaseItemStatus(requestBody);
            axios.post('external-entitites/save-base-item/popup-save', requestBody)
                .then(response => {
                    if (response.status == "200" && response && response.data && response.data.impediment) {
                        _this.$emit('batch-group-added',response.data.impediment);
                         _this.$root.batches.treeForm.push(response.data.impediment);
                         _this.$root.flags.refetchData = true;
                    }
                })
                .catch(error => {
                    console.error("Issue occurred while creating new Batch Group", error);
                });
            _this.onCLoseEditPopUp();
		},

	},
});