const link_item = Vue.component('link-item', {
	mixins: [CALCULATION_SETTINGS_MIXIN],
	template : `
			
			<div>
			<div id="link-item-popup-container">
			<div class="aa" style="display: block;">
			<div id="overlay" class="overlay" style="display: block;"></div>
			<div class="ui-dialog item-link add-pop doublelinkitem" style="display: block;"> <!-- :class="backLogItemsMode?'ui-dialog item-link add-pop doublelinkitem':'ui-dialog item-link add-pop'" -->				
				<div v-if="loader.show" class="loader"><div><div class="loaderinteg"></div>{{loader.text}}</div></div>
				
				<div class="dialgtl"> 
					{{title}} <span class="ftsb" v-if="!_.isEmpty(itemKey)">{{itemKey}}</span> 
					<em class="rmv-ico ti-close rnd DAJ" @click="onClickCancelLinkItem" title="Close"></em>					
				</div>
					<div id="link-items" class="cntr mrow aa" style="display: block;">
						<div class="select-o-items">

							<div class="ui-multiselect-menu" style="display: block;">
								<div :class="[(((boards && boards.length > 0) || (linkedObjectiveFilterOptions && linkedObjectiveFilterOptions.length > 0)) && (showBoardFilter || linkItemFor=='objective')) ? 'a-half' : 'a-full', backLogItemsMode ? 'linkItemPopOkr' : '']">
									
									<div class="DFA dropsWraper fst" v-if="!isTimelineView">
										<div class="ui-multiselect-filter lblm b linkFileds" v-if="backLogItemsMode" :class="!_.isEmpty(selectedReleaseTrainMeta.itemHierarchyLevels) ? 'pr-10' : ''">
											<label>Select Collection <a v-if="!_.isEmpty(slctdReleaseTrainMap)" href="javascript:void(0);" class="text ml-10 und" @click="viewCollection" style="font-size: 10px;">View Collection</a></label>
											<div v-if="releaseTrainMap" class="selectcont linkitemBorderRadius">
												<vz-select 
												:options="releaseTrainMap" 
												v-model="slctdReleaseTrainMap" 
												label="title" 
												track-by="id" 
												:multiple="false" 
												@select="onSelectCollection();"
												:show-item-key="true"
												></vz-select>
											</div>
										</div>
										
										<div class="ui-multiselect-filter lblm b linkFileds pl-0 pr-0" v-if="!_.isEmpty(selectedReleaseTrainMeta.itemHierarchyLevels)">
											<label>Select Hierarchy Level</label>
											<div class="selectcont linkitemBorderRadius">
												<vz-select :options="selectedReleaseTrainMeta.itemHierarchyLevels" v-model="selectedReleaseTrainMeta.selectedHierarchyLevel" label="title" track-by="id" :multiple="false" @select="onSelectReleaseTrainHierarchy"></vz-select>
											</div>
										</div>
										
										<div class="ui-multiselect-filter lblm b linkFileds pl-10" v-if="!_.isEmpty(selectedReleaseTrainMeta.itemHierarchyLevels)">
											<label>Saved Filters</label>
											<div class="selectcont linkitemBorderRadius">
												<vz-select :options="selectedReleaseTrainMeta.hierarchyFilters" 
												    value-type="object"
													v-model="selectedReleaseTrainMeta.selectedFilter"
													label="name" track-by="id" :multiple="false" 
													@select="onSelectReleaseTrainFilter"></vz-select>
											</div>
												
										</div>
									</div>
									
									<!--<a v-if="backLogItemsMode" href="javascript:void(0);" @click="queryBacklogItemsOnSearch" class="light ti-search srch-ico"></a>-->
									
									<div class="ui-multiselect-filter lblm b searchFiled pt-5" v-if="backLogItemsMode">
										<label>Search Items to Link</label>										 
										 <div class="DFA">
										 	<input class="rnd6 artInput"  placeholder="Enter item title or Key" @keyup.enter = "queryBacklogItemsOnSearch" type="search" v-model="query" :disabled ="_.isEmpty(slctdReleaseTrainMap)"/>
											 <div class="DFA">
												<button class="rnd6 mr-10 ml-10" @click="queryBacklogItemsOnSearch">Search</button>
												<a class="c-point" @click="resetSearch">Reset</a>
											</div>	
										 </div>										
									</div>
									
									<div class="DFA dropsWraper sec">
										<div class="ui-multiselect-filter lblm b searchFiled" v-if="!backLogItemsMode">
											<label>Search Items to Link</label>									 
											<input  class="rnd6" placeholder="Enter keywords" type="search" v-model="query" @input="onEnterSearchText" />
										</div>
										
										<div class="ui-multiselect-filter lblm b linkFileds" v-if="showBoardFilter && fetchFeatures && boards && boards.length > 0">
											<label>Select Program Board</label>
											<div class="selectcont linkitemBorderRadius">
										     	<vz-select :options="boards" v-model="slctdBoards" label="name" track-by="id" :multiple="true" @select="onChangeBoardSelection"></vz-select>
											</div>
										</div>
										<div class="ui-multiselect-filter lblm b linkFileds" v-if="showBoardFilter && fetchCapabilities && !_.isEmpty(solBoards)">
											<label>Select Solution Board</label>
											<div v-if="solBoards && solBoards.length > 0" class="selectcont linkitemBorderRadius">
										     	<vz-select :options="solBoards" v-model="slctdSolBoards" label="name" track-by="id" :multiple="true" @select="onChangeBoardSelection"></vz-select>
											</div>
										</div>
										
										<div class="ui-multiselect-filter lblm b linkFileds pl-0 pr-0" v-if="linkItemFor=='objective'">
											<label>Criteria</label>
											<div v-if="linkedObjectiveFilterOptions && linkedObjectiveFilterOptions.length > 0" class="selectcont linkitemBorderRadius">
												<vz-select :options="linkedObjectiveFilterOptions" v-model="isLinkedToObjectives" label="name" track-by="id" :multiple="false" @select="onChangeLinkedToObjective"></vz-select>
											</div>
										</div>
	
										<div v-if="!isMockingMode && !showBoardFilter" class="ui-multiselect-filter lblm b linkFileds">
											<label>Group By</label>
											<div class="selectcont linkitemBorderRadius">
						                        <vz-select id="groupByBacklogScoreCard" :multiple="false" label="title" empty-selection-text="Group By" class="multi-filter"
	                                                    track-by="id" value-type="value" :options="backlogGroupOptions" :groups-enabled="true" v-model = "selectedBacklogGroup"
	                                                    group-values="items" group-label="title" @select="onSelectBacklogGroup"
	                                                    :show-select-all-on-group="false"></vz-select>
											</div>
										</div>
									</div>
									
									<ul class="ui-helper-reset srchmb mb-10 ml-10 FL">
										<li><a class="ui-multiselect-all" href="javascript:void(0);" @click="onSelectAllLinkItem(true)"><span class="ui-icon ui-icon-check"></span><span>Check all</span></a></li>
										<li><a class="ui-multiselect-none" href="javascript:void(0);" @click="onSelectAllLinkItem(false)"><span class="ui-icon ui-icon-closethick"></span><span>Uncheck all</span></a></li>
									</ul>
								</div>
								<div class="contlink">
					<!--		#####   commenting out as the complete code is present in this branch ,DEV-8238   ######-->
					
<!--									<div class="DFA mb-20" style="padding: 0 15px;" v-if="isFilterSelected">-->
<!--										<a class="mr-20 DF"  href="javascript:void(0);" @click="linkAllFilterItemsToBaseItem(selectedReleaseTrainMeta.selectedFilter)">-->
<!--											<img src="/assets/icons/batchview/linkAll.svg" alt=".." class="mr-10">Link All Filter Items-->
<!--										</a>-->
<!--										<a class="DF" href="javascript:void(0);" @click="unlinkAllFilterItemsToBaseItem(selectedReleaseTrainMeta.selectedFilter)">-->
<!--											<img src="/assets/icons/batchview/unlinkAll.svg" alt=".." class="mr-10">Unlink All Filter Items-->
<!--										</a>-->
<!--									</div>-->

					<!--		##### ^^^^^  commenting out as the complete code is present in this branch ,DEV-8238^^^^  ######-->

									<template  v-if = "backLogItemsMode">
										<ul class="ui-multiselect-checkboxes ui-helper-reset">
											<li v-if="selectedBackLogItemsMap.length > 0" :class="showSelectedBacklogItemsFlag?'ui-multiselect-optgroup-label active':'ui-multiselect-optgroup-label'" @click="toggleShowSelectedBacklogItemsFlag()">
												<a class="" href="javascript:void(0);"> 
													<span class="arrdrpico FL"></span>
													Items Selected
													<span class="ItemsCount ml-10 ">
														 {{selectedBackLogItemsMap.length}}
													</span> 
												</a>
											</li>
	                                        <template v-if = "showSelectedBacklogItemsFlag">
											<template  v-for="(option,index) in selectedBackLogItemsMap">
											<li class="groupedLi" v-if="showLinkedItem(option)">
												<label class="ui-corner-all ui-state-hover"> 
													<input v-if="option.disabled" @click="onUnSelectSelecctedBklogItems(index)" type="checkbox" :title="option.title" :checked="option.selected" disabled="disabled"> 
												    <input v-else-if="!option.disabled" @click="onUnSelectSelecctedBklogItems(index)" type="checkbox" :title="option.title" :checked="option.selected" > 
												    <span  class="lbl"> 
														 <span v-if="!_.isEmpty(getBackLogItemIconUrl(option))" class="key">
														 	<span v-if="option.fields.tfsProjectId == undefined" class="jira" :class="getBackLogItemIconUrl(option)"></span>
	                                                        <img  v-else :src="getBackLogItemIconUrl(option)" class="azurico" alt=" "  />	
	                                                     </span>
	                                                       <a v-if="option.almKey" class="key ftsb jiraKeyHandle kendisOnly" :href="option.url" target="_blank">{{option.almKey}}</a>
	                                                        <a v-else-if="option.fields && option.fields.externalKey" class="key ftsb jiraKeyHandle kendisOnly" :href="option.fields.externalLink" target="_blank">{{option.fields.externalKey}}</a>
															<a v-else-if ="option.kendisKey" class="key ftsb jiraKeyHandle kendisOnly" target="_blank">{{option.kendisKey}}</a>
															<span class="name">{{option.title}}</span>
													</span>
						
												</label>
											</li>
											</template>
											</template>
										</ul>
									</template>
									<ul v-if = "backLogItemsMode" class="ui-multiselect-checkboxes ui-helper-reset">
										<li v-if="dataCopy.features.length > 0 && !backLogItemsMode" class="ui-multiselect-optgroup-label "><a href="javascript:void(0);">Features</a></li>
<!--										<li v-if="dataCopy.features.length > 0 && backLogItemsMode" class="ui-multiselect-optgroup-label "><a href="javascript:void(0);">Backlog Items</a></li>-->
<!--											<li v-if="backLogItemsMode" class="ui-multiselect-optgroup-label "><a href="javascript:void(0);">Backlog Items</a></li>-->
                                            <li v-if="backLogItemsMode && dataCopy.features.length ==0" class="nofound pb-20">No Item Found.</li>
										<template v-for="(option,index) in dataCopy.features">
											<li :class=" option.disabled ? 'groupedLi disabled':'groupedLi'" v-if="showLinkedItem(option)">
												<label class="ui-corner-all ui-state-hover"> 
													<input v-if="backLogItemsMode && option.disabled" @click="onSelectLinkItem('fe',index)" type="checkbox" :title="option.title" :checked="option.selected" disabled="disabled"> 
												    <input v-else-if="backLogItemsMode && !option.disabled" @click="onSelectLinkItem('fe',index)" type="checkbox" :title="option.title" :checked="option.selected" > 											
												    
												    <span class="lbl"> 
														 <span v-if="!_.isEmpty(getBackLogItemIconUrl(option))" class="key">
														 	<span v-if="option.fields.tfsProjectId == undefined" class="jira" :class="getBackLogItemIconUrl(option)"></span>
	                                                        <img  v-else :src="getBackLogItemIconUrl(option)" class="azurico" alt=" "  />	
	                                                     </span>
	                                                       <a v-if="option.almKey" class="key ftsb jiraKeyHandle kendisOnly" :href="option.url" target="_blank">{{option.almKey}}</a>
	                                                        <a v-else-if="option.fields && option.fields.externalKey" class="key ftsb jiraKeyHandle kendisOnly" :href="option.fields.externalLink" target="_blank">{{option.fields.externalKey}}</a>
															<a v-else-if ="option.kendisKey" class="key ftsb jiraKeyHandle kendisOnly" target="_blank">{{option.kendisKey}}</a>
															<span class="name">{{option.title}}</span>
													</span>
	
												</label>
											</li>
										</template>
									</ul>
									<template v-if="!backLogItemsMode">
										<div class="maintabs itemmode">
											<span v-if="fetchFeatures" @click="onChangeTab('feature')" class="tabgenrl ftsb" :class="currentTab == 'feature'? 'active': ''">Features</span>
											<span v-if="fetchUserStories" @click="onChangeTab('story')" class="tabgenrl ftsb" :class="currentTab == 'story'? 'active': ''">Stories</span>
											<span v-if="fetchCapabilities && !_.isEmpty(solBoards)" @click="onChangeTab('capability')" class="tabgenrl ftsb" :class="currentTab == 'capability'? 'active': ''">Capabilities</span>
										</div>
									</template>
									<ul v-if = "!backLogItemsMode && currentTab === 'feature' && dataCopy.features && dataCopy.features.length > 0" class="ui-multiselect-checkboxes brditemmode">
										<!--<li v-if="dataCopy.features.length > 0 && !backLogItemsMode" class="ui-multiselect-optgroup-label "><a href="javascript:void(0);">Features</a></li>-->
										
										<li v-if="dataCopy && dataCopy.features" class="ui-multiselect-optgroup-label"><a href="javascript:void(0);">Features ({{dataCopy.features.length - totalExcludedCount}})</a> <span class="p-abs rht ftsb">Items Selected: {{selectedCount - selectedExcludedCount}}</span></li>
										
										<li v-if="dataCopy.features.length > 0 && backLogItemsMode" class="ui-multiselect-optgroup-label "><a href="javascript:void(0);">BackLog Items</a></li>
										<div v-if="selectedBacklogGroup == 'default'">	
											<template v-for="(option,index) in dataCopy.features">
												<li :class=" option.disabled ? 'groupedLi disabled':'groupedLi'" v-if="showLinkedItem(option)">
													<label class="ui-corner-all ui-state-hover"> 	
														<input @click="onSelectLinkItem('fe',index)" type="checkbox" :title="option.title" :checked="option.selected" :disabled="option.disabled"> 																								
														<span class="lbl"> 
															<span class="key">
																<img v-if="option.tfsItemTypeIcon"  :src="option.tfsItemTypeIcon" class="azurico" alt="Azure" /> 													
																<a v-if="option.tfsId || option.jiraId" :class="itemIcon(option)" :href="getItemUrl(option)" target="_blank">{{option.tfsId ? option.tfsId : option.jiraKey}}</a>
															</span>
															<span>{{option.title}}</span>
														</span>
													</label>
												</li>
											</template>
										</div>
									    <div v-else>
											<!-- Grouped Items Features-->
					                        <span class="zmcnt a">
					                            <div v-for="(group,groupIndex) in groupedBacklogItems" :class="selectedBacklogGroup !='default' ? 'actgroup': 'grpcls' " :key="selectedBacklogGroup !='default' ? groupIndex: 'default' + groupIndex">
					                                <div class="ftsb rec c-point tooltip DFA" :class="[(group.show == true ? 'active':' '), (iconClass(group) ? 'activeA':'')]" v-if="group.title" @click="onExpandGroupInBacklog(groupIndex)">
					                                	<div class="custom-checkbox">
						                                	<input type="checkbox" :id="(groupIndex)"  :checked="areAllItemsChecked(groupIndex)" :class="areAllItemsChecked(groupIndex) ==-1?'minusbar':' '">
						                                	<label class="mb-0" :for="(groupIndex)" @click.stop.prevent="onCheckAllItems(groupIndex)"></label>
					                                	</div>
					                                    <em class="arrd ti-angle-right DIB mr-10 txtgr"></em> <span onmouseover="showRealHTML(this);" class="ftsb elips DIB txtgr" v-html="group.title"></span> <span class="spctgw rnd3 ml-5 DIB">{{group.items.length}}</span>
					                                </div>
					                                <div id="backlog" v-if="group.show" class="itemsHookList  ui-sortable prow featuresGroupby" data-type="parent" :data-group="group.title" :data-group-id="group.id">
					                                	<template v-for="(option,index) in group.items">
															<li :class=" option.disabled ? 'groupedLi disabled':'groupedLi'" v-if="showLinkedItem(option)">
																<label class="ui-corner-all ui-state-hover"> 	
																	<input @click="onSelectLinkItem('fe',index, groupIndex)" type="checkbox" :title="option.title" :checked="option.selected" :disabled="option.disabled"> 																								
																	<span class="lbl"> 
																		<span class="key">
																			<img v-if="option.tfsItemTypeIcon"  :src="option.tfsItemTypeIcon" class="azurico" alt="Azure" /> 													
																			<a v-if="option.tfsId || option.jiraId" :class="itemIcon(option)" :href="getItemUrl(option)" target="_blank">{{option.tfsId ? option.tfsId : option.jiraKey}}</a>
																		</span>
																		<span>{{option.title}}</span>
																	</span>
																</label>
															</li>
					                                	</template>
					                                </div>
					                            </div>
					                        </span>
					                    </div>
										
									</ul>
									
									<!-- Grouped Items Stories -->
									<ul v-if="!backLogItemsMode && currentTab === 'story' && dataCopy.stories && dataCopy.stories.length > 0" class="ui-multiselect-checkboxes brditemmode">
										<li class="ui-multiselect-optgroup-label "><a href="javascript:void(0);">US ({{dataCopy.stories.length - totalExcludedCount}})</a> <span class="p-abs rht ftsb">Items Selected: {{selectedCount - selectedExcludedCount}}</span></li>
										<div v-if="selectedBacklogGroup == 'default'">	
											<template v-for="(option,index) in dataCopy.stories">
												<li :class=" option.disabled ? 'groupedLi disabled':'groupedLi'" v-if="showLinkedItem(option)">
													<label class="ui-corner-all ui-state-hover" > 
														<input @click="onSelectLinkItem('us',index)" type="checkbox" :title="option.title" :checked="option.selected" :disabled="option.disabled"> 
														<span class="lbl">
															<span class="key">
																<img v-if="option.tfsItemTypeIcon"  :src="option.tfsItemTypeIcon" class="azurico" alt="Azure" />													
																<a v-if="option.tfsId || option.jiraId" :class="itemIcon(option)" :href="option.tfsId ? option.tfsURL : option.externalReferenceURL" target="_blank">{{option.tfsId ? option.tfsId : option.jiraKey}}</a>
															</span> 
															<span>{{option.title}}</span>
														</span>
													</label>
												</li>
											</template>
										</div>
									    <div v-else>
					                        <span class="zmcnt b">
					                            <div v-for="(group,groupIndex) in groupedBacklogItems" :class="selectedBacklogGroup !='default' ? 'actgroup': 'grpcls' " :key="selectedBacklogGroup !='default' ? groupIndex: 'default' + groupIndex">
					                                <div class="ftsb rec c-point tooltip DFA" :class="[(group.show == true ? 'active':' '), (iconClass(group) ? 'activeA':'')]" v-if="group.title" @click="onExpandGroupInBacklog(groupIndex)">
					                                    <div class="custom-checkbox">
						                                    <input type="checkbox" :id="(groupIndex)"  :checked="areAllItemsChecked(groupIndex)" :class="areAllItemsChecked(groupIndex) ==-1?'minusbar':' '">
						                                	<label class="mb-0" :for="(groupIndex)" @click.stop.prevent="onCheckAllItems(groupIndex)"></label>
					                                	</div>
					                                    <em class="arrd ti-angle-right DIB mr-10 txtgr"></em> <span onmouseover="showRealHTML(this);" class="ftsb elips DIB txtgr" v-html="group.title"></span> <span class="spctgw rnd3 ml-5 DIB">{{group.items.length}}</span>
					                                </div>
					                                <div id="backlog" v-if="group.show" class="itemsHookList  ui-sortable prow storiesGroupby" data-type="parent" :data-group="group.title" :data-group-id="group.id">
					                                	<template v-for="(option,index) in group.items">
															<li :class=" option.disabled ? 'groupedLi disabled':'groupedLi'" v-if="showLinkedItem(option)">
																<label class="ui-corner-all ui-state-hover"> 	
																	<input @click="onSelectLinkItem('fe',index, groupIndex)" type="checkbox" :title="option.title" :checked="option.selected" :disabled="option.disabled"> 																								
																	<span class="lbl"> 
																		<span class="key">
																			<img v-if="option.tfsItemTypeIcon"  :src="option.tfsItemTypeIcon" class="azurico" alt="Azure" /> 													
																			<a v-if="option.tfsId || option.jiraId" :class="itemIcon(option)" :href="option.tfsId ? option.tfsURL : option.externalReferenceURL" target="_blank">{{option.tfsId ? option.tfsId : option.jiraKey}}</a>
																		</span>
																		<span>{{option.title}}</span>
																	</span>
																</label>
															</li>
					                                	</template>
					                                </div>
					                            </div>
					                        </span>
					                    </div>
										
									</ul>
									
									<!-- Capabilities-->
									
									<ul v-if = "!backLogItemsMode && currentTab === 'capability'" class="ui-multiselect-checkboxes brditemmode">
										
										<li v-if="dataCopy && dataCopy.capabilities" class="ui-multiselect-optgroup-label"><a href="javascript:void(0);">Capabilities ({{dataCopy.capabilities.length - totalExcludedCount}})</a> <span class="p-abs rht ftsb">Items Selected: {{selectedCount - selectedExcludedCount}}</span></li>
										
										<li v-if="dataCopy.capabilities && dataCopy.capabilities.length > 0 && backLogItemsMode" class="ui-multiselect-optgroup-label "><a href="javascript:void(0);">BackLog Items</a></li>
										<div v-if="selectedBacklogGroup == 'default'">	
											<template v-for="(option,index) in dataCopy.capabilities">
												<li :class=" option.disabled ? 'groupedLi disabled':'groupedLi'" v-if="showLinkedItem(option)">
													<label class="ui-corner-all ui-state-hover"> 	
														<input @click="onSelectLinkItem('ca',index)" type="checkbox" :title="option.title" :checked="option.selected" :disabled="option.disabled"> 																								
														<span class="lbl"> 
															<span class="key">
																<img v-if="option.tfsItemTypeIcon"  :src="option.tfsItemTypeIcon" class="azurico" alt="Azure" /> 													
																<a v-if="option.tfsId || option.jiraId" :class="itemIcon(option)" :href="getItemUrl(option)" target="_blank">{{option.tfsId ? option.tfsId : option.jiraKey}}</a>
															</span>
															<span>{{option.title}}</span>
														</span>
													</label>
												</li>
											</template>
										</div>
									    <div v-else>
											<!-- Grouped Items Capabilities-->
					                        <span class="zmcnt a">
					                            <div v-for="(group,groupIndex) in groupedBacklogItems" :class="selectedBacklogGroup !='default' ? 'actgroup': 'grpcls' " :key="selectedBacklogGroup !='default' ? groupIndex: 'default' + groupIndex">
					                                <div class="ftsb rec c-point tooltip DFA" :class="[(group.show == true ? 'active':' '), (iconClass(group) ? 'activeA':'')]" v-if="group.title" @click="onExpandGroupInBacklog(groupIndex)">
					                                	<div class="custom-checkbox">
						                                	<input type="checkbox" :id="(groupIndex)"  :checked="areAllItemsChecked(groupIndex)" :class="areAllItemsChecked(groupIndex) ==-1?'minusbar':' '">
						                                	<label class="mb-0" :for="(groupIndex)" @click.stop.prevent="onCheckAllItems(groupIndex)"></label>
					                                	</div>
					                                    <em class="arrd ti-angle-right DIB mr-10 txtgr"></em> <span onmouseover="showRealHTML(this);" class="ftsb elips DIB txtgr" v-html="group.title"></span> <span class="spctgw rnd3 ml-5 DIB">{{group.items.length}}</span>
					                                </div>
					                                <div id="backlog" v-if="group.show" class="itemsHookList  ui-sortable prow featuresGroupby" data-type="parent" :data-group="group.title" :data-group-id="group.id">
					                                	<template v-for="(option,index) in group.items">
															<li :class=" option.disabled ? 'groupedLi disabled':'groupedLi'" v-if="showLinkedItem(option)">
																<label class="ui-corner-all ui-state-hover"> 	
																	<input @click="onSelectLinkItem('ca',index, groupIndex)" type="checkbox" :title="option.title" :checked="option.selected" :disabled="option.disabled"> 																								
																	<span class="lbl"> 
																		<span class="key">
																			<img v-if="option.tfsItemTypeIcon"  :src="option.tfsItemTypeIcon" class="azurico" alt="Azure" /> 													
																			<a v-if="option.tfsId || option.jiraId" :class="itemIcon(option)" :href="getItemUrl(option)" target="_blank">{{option.tfsId ? option.tfsId : option.jiraKey}}</a>
																		</span>
																		<span>{{option.title}}</span>
																	</span>
																</label>
															</li>
					                                	</template>
					                                </div>
					                            </div>
					                        </span>
					                    </div>
										
									</ul>
									
									<ul v-else-if="!backLogItemsMode && itemNotFound" class="ui-multiselect-checkboxes brditemmode">
										<li class="nofound" style="margin: 50px 0;">No Item Found.</li>										
									</ul>
								</div>
							</div>
							
						</div>						
					</div>
					<div class="rec btn DFA" :class="backLogItemsMode && pagination.totalItemSize > pagination.pageSize && !itemNotFound ? 'JC' : 'JE'">
					    <div v-if="backLogItemsMode && pagination.totalItemSize > pagination.pageSize && !itemNotFound" class="pagging DF JE w-70pc" :class="backLogItemsMode ? 'linkItemPagin' : ''">
                               <div class="paginator" >
                                   <vue-ads-pagination :key="paginatorKey" :total-items="pagination.totalItemSize" :items-per-page="pagination.pageSize" :max-visible-pages="1" v-on:page-change="onChangePage">
                                        <template slot-scope="props"><div class="txt">{{ props.start }} to {{ props.end }} of {{ props.total }} Items</div></template>
                                   </vue-ads-pagination>
                               </div>
                        </div>
<!--							<a v-if="backLogItemsMode && !disableLoadMore" href="javascript:void(0);" class="FL cncl action" style="margin-top: 11px;" @click="onChangePage">Load More</a>-->
						<div class="DFA JE w-30pc">
							<a href="javascript:void(0);" class="cncl action mr-10" @click="onClickCancelLinkItem" style="    color: #7f8fa4;">Cancel</a>
							<input id="save-o-items" type="button" class="button action rnd4" :class="[!saveButtonEnabled ? 'disabled' : '']"	value="Save" :disabled="!saveButtonEnabled"	@click="onSelectSaveLinkItems" /> 
							
						</div>
					</div>
				</div>
			</div>
			</div>
			</div>
		`,
		props:  {
			title: {
				type: String,
			    default: () => { return "" }
			},
			data: {
				type: Object,
			    default: () => { return {features:[],stories:[]} }
			},
			showBoardFilter : {
				type : Boolean,
				default : () => { return true }
			},
			boards: {
				type: Array,
			    default: () => { return []}
			},
			solBoards: {
				type: Array,
			    default: () => { return []}
			},
			board: {
				type: Object,
				default: () => { return {}}
			},
			sessionBoards: {
				type: Array,
			    default: () => { return []}
			},
			selectedItems: {
				type: Array,
		    	default: () => { return []}
			},
			fitContainer: {
				type: Boolean,
		    	default: () => { return false}
			},
			fetchFeatures: {
				type: Boolean,
		    	default: () => { return true}				
			},
			fetchUserStories: {
				type: Boolean,
		    	default: () => { return true}				
			},
			fetchCapabilities: {
				type: Boolean,
		    	default: () => { return true}				
			},
			container: {
				type: String,
			    default: () => { return "" }
			},
			itemKey: {
				type: String,
				default: () => { return ""}
			},
			issueTypesMeta: {
				type: Map,
				default: () => { return new Map();}
			},
			linkItemFor: {
				type: String,
				default: () => { return "" }
			},
            isMockingMode: {
                type: Boolean,
                default: () =>{ return false }
            },
            backLogItemsMode: {
                type: Boolean,
                default: () =>{ return false }
            },
            baseItemLinks: {
                type: Array,
                default: () =>{ return [] }
            },
            releaseTrainId: {
                type: String,
                default: () => {
                    return "";
                }
            },
            timelineId: {
                type: String,
                default() {
                    return "";
                }
            },
            timelineHierarchyLevel: {
                type: Object,
                default() {
                    return {};
                }
            },

        },
		
		computed: {
			itemIcon: function() {
				return function(item) {
					return getItemIcon(item);
				}
			},
			excludeItemsData: function() {
                return kendisStore.getters.getExcludeItemsData();
            },
			showLinkedItem: function() {
                return function(item) {
                    return this.backLogItemsMode || (item.id && this.verifyItemsToExclude(item, this.excludeItemsData));
                }
            },
            isTimelineView: function() {
                return !_.isEmpty(this.timelineId) && this.backLogItemsMode && !_.isEmpty(this.timelineHierarchyLevel)
            }
		},
		
		data() {
			return this.initialData();
		},
		components: {
            VueAdsPagination: window["vue-ads-pagination"].default,
        },
		watch: {},

		created () {
// Original code replaced by a function
			this.onCreatedCalled();
		},

		mounted: function () {
			// Original code replaced by a function
			this.onMountedCalled();
		},
		methods: {
			onCreatedCalled: function() {
				if(this.fetchFeatures){
					this.currentTab = "feature";
				}else{
					this.currentTab = "capability";
				}
                if (!_.isEmpty(this.selectedItems)) {
                    this.selectedItemIds = _.clone(this.selectedItems);
                }
				let board = {};
				if (!_.isEmpty(this.data) && !_.isEmpty(this.data.features) || (!_.isEmpty(this.data) && !_.isEmpty(this.data.capabilities))) {

					if (!_.isEmpty(this.boards)) {
						if (!this.showBoardFilter) {
							if (_.isEmpty(this.board)) {
								board = _.cloneDeep(this.boards[0]);
								board.name = board.session.title;
								this.slctdBoards = [board];
							} else {
								board = _.cloneDeep(this.board);
								board.name = board.session.title;
								this.slctdBoards = [board];
							}
						} else {
							this.slctdBoards = this.boards;
						}
					}
					if (!_.isEmpty(this.solBoards)) {
						if (this.showBoardFilter) {
							this.slctdSolBoards = this.solBoards;
						}
					}
					var _this = this;
					_this.$options.sessionBoardsMapBySessionId = {};
					if (!_.isEmpty(this.sessionBoards)) {
						_.each(this.sessionBoards, sb => {
							_this.$options.sessionBoardsMapBySessionId[sb.session.id] = sb;
						});
					}

					this.$options.unfilteredData = JSON.parse(JSON.stringify(this.data));
					this.applyFilter();
					this.setSelectedItems(this.selectedItemIds);
					if (!this.showBoardFilter) {
						this.createBacklogGroups();
						this.onSelectBacklogGroup(this.selectedBacklogGroup);
					}
				}else if (this.data && this.data != undefined) {
					if( !this.isMockingMode){
						if(!this.showBoardFilter) {
							if(_.isEmpty(this.board)) {
								board = _.cloneDeep(this.boards[0]);
								board.name = board.session.title;
								this.slctdBoards = [board];
							} else {
								board = _.cloneDeep(this.board);
								board.name = board.session.title;
								this.slctdBoards = [board];
							}
						} else {
							this.slctdBoards = this.boards;
						}
						if (!_.isEmpty(this.solBoards)) {
							if (this.showBoardFilter) {
								this.slctdSolBoards = this.solBoards;
							}
						}
					}
					if(!this.backLogItemsMode){
						if(this.currentTab == "capability") {
							this.loadBoardData(this.slctdSolBoards);
						}else{
							this.loadBoardData(this.slctdBoards);							
						}
					}else{
                        if (this.isTimelineView){
                            if (!_.isEmpty(this.releaseTrainId)){
                                this.slctdReleaseTrainMap.id = this.releaseTrainId;
                            }
                            this.queryBacklogItemsOnSearch();
                        }else{
                            this.fetchReleaseTrains();
                        }
					}
				}
			},

			onMountedCalled: function() {
				if (this.fitContainer) {
					var container = document.getElementById(this.container);
					var element = document.getElementById("link-item-popup-container");
					if(element){
						element.parentElement.removeChild(element);
						container.appendChild(element);
					}
				}

			},
			//////////////////////////////////////////////////
			///////////////    LOGIC
            fetchReleaseTrains: function () {
                //fetch all release trains
                let _this = this;
                let data = {};
                data.fetchTypes = true;
                axios.post("/releasetrain/release-trains",data).then(res => {
                    _this.releaseTrainMap = res.data.releaseTrains;
                    _this.releaseTrainMap = _this.releaseTrainMap.filter(item => item.type);
                    
                    if (!_.isEmpty(_this.releaseTrainMap) && !_.isEmpty(_this.releaseTrainId) && _this.backLogItemsMode){
                        let rtIndex = _.findIndex(_this.releaseTrainMap, {id : _this.releaseTrainId});
                        if (rtIndex > -1){
                            _this.slctdReleaseTrainMap = _this.releaseTrainMap[rtIndex];
                            _this.fetchSelectedReleaseTrainMeta(_this.slctdReleaseTrainMap.id);
                        }else{
                            let rtIndex2 = _.findIndex(_this.releaseTrainMap, {key : _this.releaseTrainId});
                            if (rtIndex2 > -1){
                                _this.slctdReleaseTrainMap = _this.releaseTrainMap[rtIndex2];
                                _this.fetchSelectedReleaseTrainMeta(_this.slctdReleaseTrainMap.id);
                            }
                        }
                    }

                _.each(_this.releaseTrainMap, releaseTrain => {
                    if (releaseTrain.id !== "-1"){
                        if (!_this.selectedBacklogItemsRTMap[releaseTrain.id]) {
                            Vue.set(_this.selectedBacklogItemsRTMap, releaseTrain.id, []);
                        }

                    }
                });
                _.each(this.baseItemLinks, (link) => {
                    // let itemIndex = _.findIndex(this.selectedItems, { id : link.baseItemId });
                    //
                    // if (itemIndex > -1) {
                    //     let itemToAdd = this.selectedItems[itemIndex];
                    //
                    //     // Check if the item is already present in the itemsGroupedByReleaseTrain object
                    //     if (!this.selectedBacklogItemsRTMap[link.releaseTrainId].some((item) => item.id === itemToAdd.id)) {
                    //         this.selectedBacklogItemsRTMap[link.releaseTrainId].push(itemToAdd.id);
                    //     }
                    // }

                    if (link.baseItemId && link.linkType === "backLogItem" ) {
                        if( this.selectedBacklogItemsRTMap[link.releaseTrainId] && !this.selectedBacklogItemsRTMap[link.releaseTrainId].includes(link.baseItemId)){
                            this.selectedBacklogItemsRTMap[link.releaseTrainId].push(link.baseItemId);
                        }
                    }
                });
            }).catch(error => {
                console.log(error);
            });
        },
        linkAllFilterItemsToBaseItem(filter){
            let _this= this;
             _this.fetchFilterItemIds(filter);
        },
        unlinkAllFilterItemsToBaseItem(filter){
            this.$emit('remove-filter-items', filter.id, this.slctdReleaseTrainMap.id);
        },
        toggleShowSelectedBacklogItemsFlag: function () {
            this.showSelectedBacklogItemsFlag= !this.showSelectedBacklogItemsFlag;
        },
        getBackLogItemIconUrl(item) {
            let itemIconUrl = "";
            if(item && item.fields) {
                if(item.fields.tfsProjectId) {
                    itemIconUrl = item.fields.itemTypeIcon;
                } else if (item.fields.issuetype || item.almFields && item.almFields.issuetype) {
                    itemIconUrl = styleJiraIcon(this.$root, item);
                }
            }
            return itemIconUrl ? itemIconUrl : '';
        },
        populateDataCopy: function () {
            let datacopy={
                features:[],
                stories:[]
            }
            if(!this.backLogItemsMode) {
                datacopy={features:[{selected:false}],stories:[{selected:false}]}
            }
            return datacopy;

        },

        getIssueTypeIconUrl: function(item) {
            let resultIconUrl = '';
            try {
                if (item && item.jiraFieldByKey && item.jiraFieldByKey.issuetype && item.jiraFieldByKey.issuetype.iconUrl) {
                    resultIconUrl = item.jiraFieldByKey.issuetype.iconUrl;
                } else {
                    if (this.issueTypesMeta && item.jiraIssueTypeId) {
                        resultIconUrl = this.issueTypesMeta.get("icon_" + item.jiraIssueTypeId);
                    }
                }
            }catch (e) {
                console.log(e)
            }
            return resultIconUrl;
        },
        checkForEnablesSaveButton : function () {
            let _this = this;if(this.backLogItemsMode){
                if(this.selectedBackLogItemsMap.length > 0){
                    this.saveButtonEnabled = true;
                    return;
                }
            }else if (this.selectedBacklogGroup !== 'default') {
let selectedItemsMap = {};
            _.each(_this.selectedItems, id => selectedItemsMap[id] = true);

                    // Iterate over each group's items and check conditions
                    for (let group of this.groupedBacklogItems) {
                        if (group.items.some(item => {
                            // Check if the item is selected or if the item's id is in selectedItems but not selected
                            if (item.selected || (selectedItemsMap[item.id] && !item.selected)) {
                                return true;
                            }
                            return false;
                        })) {
                            this.saveButtonEnabled = true;
                            return;
                        }
                    }
                } else {
// Handle the general case where no special conditions are met
            let selectedMap = {};
                    // Using lodash to map selected items IDs to true
            _.each(_this.selectedItems,id=>selectedMap[id]=true);

                    let data = this.$options.unfilteredData;
                    let enable = false;

                    // Check features for any changes in selection
                    if (data && data.features) {
                        for (let i = 0; i < data.features.length; i++) {
                            let previousFeature = selectedMap[data.features[i].id] ? true : false;
                            if (previousFeature != data.features[i].selected) {
                                enable = true;
                                break;
                            }
                        }
                    }
                    // If no feature changed, check stories
                    if (!enable && data && data.stories) {
                        for (let i = 0; i < data.stories.length; i++) {
                            let previousStory = selectedMap[data.stories[i].id] ? true : false;
                            if (previousStory != data.stories[i].selected) {
                                enable = true;
                                break;
                            }
                        }
                    }
					// Check Capabilities for any changes in selection
                    if (!enable && data && data.capabilities) {
                        for (let i = 0; i < data.capabilities.length; i++) {
                            let previousEpic = selectedMap[data.capabilities[i].id] ? true : false;
                            if (previousEpic != data.capabilities[i].selected) {
                                enable = true;
                                break;
                            }
                        }
                    }

                    // Set the save button enabled state based on findings
                    _this.saveButtonEnabled = enable;
                }
            },

            /**
             * Retrieves the selected items from the link popup.
             * If the selected backlog group is not 'default', it filters the items based on the selected items and grouped backlog items.
             * If the selected backlog group is 'default', it retrieves the selected items from the features and stories.
             * If there are no selected items, it makes a request to the server to fetch the selected items.
             * Emits a 'save' event with the selected items and calls onClickCancelLinkItem().
             */
            getSelectedItemsFromLinkPopupFromLinkPopup: function () {
                let _this = this;
                let items = [];

                // Check if the selected backlog group is not 'default'
                if (this.selectedBacklogGroup !== 'default') {
                    // Concatenate the features and stories arrays into a single array
                    let backlogItems = [];
					if (_this.$options.unfilteredData.features && _this.$options.unfilteredData.stories && _this.$options.unfilteredData.capabilities) {
                        backlogItems = _this.$options.unfilteredData.features.concat(_this.$options.unfilteredData.stories);
						backlogItems = backlogItems.concat(_this.$options.unfilteredData.capabilities);
                    } else if (_this.$options.unfilteredData.features && _this.$options.unfilteredData.stories) {
                        backlogItems = _this.$options.unfilteredData.features.concat(_this.$options.unfilteredData.stories);
                    } else if (_this.$options.unfilteredData.features) {
                        backlogItems = _this.$options.unfilteredData.features.slice();
                    } else if (_this.$options.unfilteredData.stories) {
                        backlogItems = _this.$options.unfilteredData.stories.slice();
                    } else if (_this.$options.unfilteredData.capabilities) {
                        backlogItems = _this.$options.unfilteredData.capabilities.slice();
                    }

                    // Filter the backlog items based on the selected items
                    items = backlogItems.filter(item => _this.selectedItemIds.includes(item.id));

                    // Update the items based on the grouped backlog items
                    this.groupedBacklogItems.forEach(function(group) {
                        group.items.forEach(function(item) {
                            const itemIndex = items.findIndex(x => x.id === item.id);
                            if (item.selected && itemIndex === -1) {
                                items.push(item); // Add if selected and not already in the list
                            } else if (!item.selected && itemIndex !== -1) {
                                items.splice(itemIndex, 1); // Remove if not selected and currently in the list
                            }
                        });
                    });

                    this.$emit('save', items);
                    this.onClickCancelLinkItem();
                } else {
                    // Retrieve the selected items from the features and stories
                    let data = _this.$options.unfilteredData;
                    if (data && data.features) {
                        for (let i = 0; i < data.features.length; i++) {
                            if (data.features[i].selected) {
                                items.push(data.features[i]);
                            }
                        }
                    }
					if (data && data.capabilities) {
                        for (let i = 0; i < data.capabilities.length; i++) {
                            if (data.capabilities[i].selected) {
                                items.push(data.capabilities[i]);
                            }
                        }
                    }
                    if (data && data.stories && data.stories.length) {
                        for (let i = 0; i < data.stories.length; i++) {
                            if (data.stories[i].selected) {
                                items.push(data.stories[i]);
                            }
                        }
                        // Emit the 'save' event with the selected items
                        _this.$emit('save', items);
                        _this.onClickCancelLinkItem();
                    } else {
                        // Create a request body with the selected items and board IDs
                        let requestBody = {
                            selectedItems: _this.selectedItemIds
                        };
                        let ids = "";
                        _.each(_this.boards, function(b) {
                            ids = ids ? ids + "," + b.id : b.id;
                        });
						if(!_.isEmpty(ids)) {
	                        requestBody.boardIds = ids;
						}

                        // Make a request to the server to fetch the selected items
                        axios.post('riskregister/fetch-selected', requestBody)
                            .then(function (response) {
                                if (response.data && response.data.items) {
                                    items = items.concat(response.data.items);
                                    // Emit the 'save' event with the selected items
                                    _this.$emit('save', items);
                                    _this.onClickCancelLinkItem();
                                }
                            })
                            .catch(function (error) {
                                console.error(error);
                            });
                    }
                }
            },

            getSelectedItemsForMilestones: function () {
                let _this = this;
                let selectedItemsMap = {};

                if (this.selectedBacklogGroup !== 'default') {
                    let backlogItems = [];

                    if (_this.$options.unfilteredData.features && _this.$options.unfilteredData.stories) {
                        backlogItems = _this.$options.unfilteredData.features.concat(_this.$options.unfilteredData.stories);
                    } else if (_this.$options.unfilteredData.features) {
                        backlogItems = _this.$options.unfilteredData.features.slice();
                    } else if (_this.$options.unfilteredData.stories) {
                        backlogItems = _this.$options.unfilteredData.stories.slice();
                    }

                    backlogItems.forEach(item => {
                        if (_this.selectedItemIds.includes(item.id)) {
                            selectedItemsMap[item.id] = {
                                id: item.id,
                                almItemId: item.jiraId || item.tfsId
                            };
                        }
                    });

                    this.groupedBacklogItems.forEach(function(group) {
                        group.items.forEach(function(item) {
                            if (item.selected && !selectedItemsMap[item.id]) {
                                selectedItemsMap[item.id] = {
                                    id: item.id,
                                    almItemId: item.jiraId || item.tfsId
                                };
                            } else if (!item.selected && selectedItemsMap[item.id]) {
                                delete selectedItemsMap[item.id]; // Remove if not selected and currently in the map
                            }
                        });
                    });

                } else {
                    let data = _this.$options.unfilteredData;
                    if (data && data.features) {
                        data.features.forEach(feature => {
                            if (feature.selected) {
                                selectedItemsMap[feature.id] = {
                                    id: feature.id,
                                    almItemId: feature.jiraId || feature.tfsId
                                };
                            }
                        });
                    }
                    if (data && data.stories && data.stories.length) {
                        data.stories.forEach(story => {
                            if (story.selected) {
                                selectedItemsMap[story.id] = {
                                    id: story.id,
                                    almItemId: story.jiraId || story.tfsId
                                };
                            }
                        });
                    }
                }

                this.$emit('link-milestone-items', selectedItemsMap);
                this.onClickCancelLinkItem();
            },


            setSelectedItems: function (setSelectedItemIds) {
                let _this = this;
                let selectedMap = {};
                _.each(setSelectedItemIds, id => selectedMap[id] = true);

                if (this.selectedBacklogGroup !== 'default') {
					let itemCountedMap = {};
                    _.each(_this.groupedBacklogItems, group => {
                        _.each(group.items, item => {
                            let countItem = _this.verifyItemsToExclude(item, _this.excludeItemsData);
                            let find = selectedMap[item.id];
                            Vue.set(item, "selected", !!find);
                            if (item.selected && countItem && !itemCountedMap[item.id]) {
                                _this.selectedCount++;
								itemCountedMap[item.id] = true;
                            }
                        });
                    });
                } else {
                    if (_this.currentTab == 'feature') {
                        _.each(_this.dataCopy.features, item => {
                            let countItem = _this.verifyItemsToExclude(item, _this.excludeItemsData);
                            let find = selectedMap[item.id];
                            item.selected = !!find;
                            if (item.selected && countItem) {
                                _this.selectedCount++;

                                if (_this.linkItemFor === "milestone") {
                                    item.disabled = true;
                                }
                            }
                        });
                    } else if (_this.currentTab == 'story') {
                        _.each(_this.dataCopy.stories, item => {
                            let countItem = _this.verifyItemsToExclude(item, _this.excludeItemsData);
                            let find = selectedMap[item.id];
                            item.selected = !!find;
                            if (item.selected && countItem) {
                                _this.selectedCount++;

                                if (_this.linkItemFor === "milestone") {
                                    item.disabled = true;
                                }
                            }
                        });
                    }else if (_this.currentTab == 'capability') {
						_this.selectedCount = 0;
                        _.each(_this.dataCopy.capabilities, item => {
                            let countItem = _this.verifyItemsToExclude(item, _this.excludeItemsData);
                            let find = selectedMap[item.id];
                            item.selected = !!find;
                            if (item.selected && countItem) {
                                _this.selectedCount++;

                                if (_this.linkItemFor === "milestone") {
                                    item.disabled = true;
                                }
                            }
                        });
                    }
                }
                this.checkForEnablesSaveButton();
            },
            setSelectedBackLogItems: function (baseItemLinks) {
                let _this = this;
                if (!_.isEmpty(baseItemLinks)){
                    let selectedMap = {};
                    _.each(baseItemLinks,link => {
                        if (link.linkType === BASE_ITEM_LINK_TYPES_ENUM.BACKLOGITEM && link.releaseTrainId === _this.slctdReleaseTrainMap.id){
                            selectedMap[link.baseItemId]=true
                        }
                    });
                _.each(_this.$options.unfilteredData.features,item=>{
                    var find = selectedMap[item.id];
                        if(!_.isEmpty(_this.selectedReleaseTrainMeta.selectedFilter)){
                            item.isNew   = find ? false : true;
                        }
                    item.selected = find ? true : false;
                    item.disabled = find ? true : false;
                });
                _.each(_this.$options.unfilteredData.stories,item=>{

                var find = selectedMap[item.id];

                item.selected = find ? true : false;
            });
                if(!_.isEmpty(_this.selectedReleaseTrainMeta.selectedFilter)){
                    //sort _this.$options.unfilteredData.features items with isNew shoul be at start
                      _this.$options.unfilteredData.features.sort(function(a, b) {
                        return (a.isNew === b.isNew) ? 0 : a.isNew ? -1 : 1;
                      });
                }
            this.checkForEnablesSaveButton();
            }

        },
			applyFilter: function (isCalledFromSearch) {
			
				var _this = this;

				_this.totalExcludedCount = 0;
				_this.selectedExcludedCount = 0;
				var slctdSessionBoardMap = {};
				var slctdSolutionBoardMap = {};
				var checkBoard = false;
				var checkSolBoard = false;
				if (!_.isEmpty(this.boards)) {
					checkBoard = true;
					if (!_.isEmpty(this.slctdBoards)) {
						_.each(this.slctdBoards,board=>{
							let boardId = !_this.showBoardFilter ? board.session.id : board.id;
							var sessionBoard = _this.$options.sessionBoardsMapBySessionId[boardId];
							if (sessionBoard) {
								slctdSessionBoardMap[sessionBoard.id] = sessionBoard;
							}
						});
					}
				}
				
				if(!_.isEmpty(this.solBoards)) {
					checkSolBoard = true; 
					if (!_.isEmpty(this.slctdSolBoards)) {
						_.each(this.slctdSolBoards,board=>{
							slctdSolutionBoardMap[board.id] = board;
						});
					}
				}
				
				
				var newCopy = {};
				
				var features = [];
				var stories  = [];
				var capabilities = [];
				
				var query;
				if (!_.isEmpty(_this.query)) {
					query = _this.query.toLowerCase();
				}
				if(_this.currentTab === "feature") {
					_.each(_this.$options.unfilteredData.features,item=>{
						let countItem = this.verifyItemsToExclude(item, this.excludeItemsData);

						var queryMatch = true;
						var boardMatch = true;
						if (query) {
							if ((item.tfsId && item.tfsId.toLowerCase().includes(query)) || (item.jiraKey && item.jiraKey.toLowerCase().includes(query)) || item.title.toLowerCase().includes(query)) {
								
							}else {
								queryMatch = false;
							}
						}
						if (checkBoard) {
							var sb = slctdSessionBoardMap[item.sessionBoards[0].id];
							boardMatch = sb ? true : false;
						}
						
						if (queryMatch && boardMatch) {
							features.push(item);
						}
						if(!isCalledFromSearch && item.selected) {
							_this.selectedCount++;
							if(!countItem) {
								_this.selectedExcludedCount ++;
							}
						}
						if(!countItem) {
							_this.totalExcludedCount ++;
						}
					});
					newCopy.features = features;					
				}
				else if(_this.currentTab === "story") {
					_.each(_this.$options.unfilteredData.stories,item=>{
						let countItem = this.verifyItemsToExclude(item, this.excludeItemsData);

						var queryMatch = true;
						var boardMatch = true;
						if (query) {
							if ((item.tfsId && item.tfsId.toLowerCase().includes(query)) || (item.jiraKey && item.jiraKey.toLowerCase().includes(query)) || item.title.toLowerCase().includes(query)) {
								
							}else {
								queryMatch = false;
							}
						}
						if (checkBoard) {
							var sb = slctdSessionBoardMap[item.sessionBoards[0].id];
							boardMatch = sb ? true : false;
						}
						
						if (queryMatch && boardMatch) {
							stories.push(item);
						}
						if(!isCalledFromSearch && item.selected) {
							_this.selectedCount++
							if(!countItem) {
								_this.selectedExcludedCount ++;
							}
						}
						if(!countItem) {
							_this.totalExcludedCount ++;
						}
					});
					newCopy.stories  = stories;					
				}	
				else if(_this.currentTab === "capability") {
					_.each(_this.$options.unfilteredData.capabilities,item=>{
						let countItem = this.verifyItemsToExclude(item, this.excludeItemsData);

						var queryMatch = true;
						var boardMatch = true;
						if (query) {
							if ((item.tfsId && item.tfsId.toLowerCase().includes(query)) || (item.jiraKey && item.jiraKey.toLowerCase().includes(query)) || item.title.toLowerCase().includes(query)) {
								
							}else {
								queryMatch = false;
							}
						}
						if (checkSolBoard) {
							var sb = slctdSolutionBoardMap[item.solutionBoard.id];
							boardMatch = sb ? true : false;
						}
						
						if (queryMatch && boardMatch) {
							capabilities.push(item);
						}
						if(!isCalledFromSearch && item.selected) {
							_this.selectedCount++;
							if(!countItem) {
								_this.selectedExcludedCount ++;
							}
						}
						if(!countItem) {
							_this.totalExcludedCount ++;
						}
					});
					newCopy.capabilities = capabilities;					
				}
				// *************************************//
				// 		Filter for Linked Objective 	//
				// *************************************//

				if(_this.linkItemFor == "objective") {
					let filteredFeatures = [];
					let filteredStories = [];
					if(_this.isLinkedToObjectives['id'] == "yes") {
						if(!isCalledFromSearch) {							
							_this.selectedCount = 0;
							_this.selectedExcludedCount = 0;
							_this.totalExcludedCount = 0;
						}
						_.forEach(features, feature=>{
							let countItem = this.verifyItemsToExclude(feature, this.excludeItemsData);
							if(kendisStore.getters.getLinkedObjectiveMap().includes(feature.id)){
								filteredFeatures.push(feature);
								if(!isCalledFromSearch && feature.selected) {
									_this.selectedCount++;
									if(!countItem) {
										_this.selectedExcludedCount ++;
									}
								}
								if(!countItem) {
									_this.totalExcludedCount ++;
								}
							}
						});
						newCopy.features = filteredFeatures;						
						_.forEach(stories, story=>{
							let countItem = this.verifyItemsToExclude(story, this.excludeItemsData);
							if(kendisStore.getters.getLinkedObjectiveMap().includes(story.id)){
								filteredStories.push(story);
								if(!isCalledFromSearch && story.selected) {
									_this.selectedCount++
									if(!countItem) {
										_this.selectedExcludedCount ++;
									}
								}
								if(!countItem) {
									_this.totalExcludedCount ++;
								}
							}
						});
						newCopy.stories = filteredStories;
					} else if(_this.isLinkedToObjectives['id'] == "no") {
						if(!isCalledFromSearch) {							
							_this.selectedCount = 0;
							_this.selectedExcludedCount = 0;
							_this.totalExcludedCount = 0;
						}
						_.forEach(features, feature=>{
							let countItem = this.verifyItemsToExclude(feature, this.excludeItemsData);
							if(!kendisStore.getters.getLinkedObjectiveMap().includes(feature.id)){
								filteredFeatures.push(feature);
								if(!isCalledFromSearch && feature.selected) {
									_this.selectedCount++
									if(!countItem) {
										_this.selectedExcludedCount ++;
									}
								}
								if(!countItem) {
									_this.totalExcludedCount ++;
								}
							}
						});
						newCopy.features = filteredFeatures;						
						_.forEach(stories, story=>{
							let countItem = this.verifyItemsToExclude(story, this.excludeItemsData);
							if(!kendisStore.getters.getLinkedObjectiveMap().includes(story.id)){
								filteredStories.push(story);
								if(!isCalledFromSearch && story.selected) {
									_this.selectedCount++
									if(!countItem) {
										_this.selectedExcludedCount ++;
									}
								}
								if(!countItem) {
									_this.totalExcludedCount ++;
								}
							}
						});
						newCopy.stories = filteredStories;
					}					
				}
				
                if ((_this.currentTab === "feature" && _.isEmpty(newCopy.features)) || (_this.currentTab === "story" && _.isEmpty(newCopy.stories))) {
                    _this.itemNotFound = true;
                }else{
                    _this.itemNotFound = false;
                }

				// *************************************//
				// 		Filter for Linked Objective 	//
				// *************************************//

				this.dataCopy = newCopy;
			},

			//////////////////////////////////////////////////
			///////////////   API CALLS
            fetchFilterItemIds: function (filter) {
                //create request
                let _this = this;

                let data = {

                };
                data[filter.id]={
                    filter : filter.criteria,
                    hierachLevel :  _this.selectedReleaseTrainMeta.selectedHierarchyLevel.level.toString()
                }

                axios.post('/releasetrain/' + _this.slctdReleaseTrainMap.id + '/backlog/ids', data)
                    .then(res => {
                        if(res.data && res.data[filter.id] ){

                            let selectedBackLogItems = [];
                            _.each( res.data[filter.id].itemIds, id => {
                                selectedBackLogItems.push({id: id});
                            });
                            this.$emit('save',selectedBackLogItems, _this.slctdReleaseTrainMap.id, filter.id);
                            this.onClickCancelLinkItem();
                        }
                    });
            },
			loadBoardData: function (boards) {

				var _this = this;

				var data = {};
				var ids = "";
				if(!this.showBoardFilter) {
					_.each(boards, b => {
						if (_.isEmpty(ids)) {
							ids = b.session.id;
						} else {
							ids += ("," + b.session.id);
						}
					});
				} else {
					_.each(boards, b => {
						if (_.isEmpty(ids)) {
							ids = b.id;
						} else {
							ids += ("," + b.id);
						}
					});
				}
				data.boardIds = ids;
				if(_this.currentTab == "feature") {
					data.fetchTypes =  {"features": (_this.fetchFeatures && _this.currentTab == "feature"), "userStories": false, capabilities: false}
				} else if(_this.currentTab == "story") {
					data.fetchTypes =  {"features": false, "userStories": (_this.fetchUserStories && _this.currentTab == "story"), capabilities: false}
				} else if (_this.currentTab == "capability") {
					data.fetchTypes =  {"capabilities": _this.fetchCapabilities, "features": true, "userStories": true};
					data.solutionBoard = true;
				} 
				else {
					data.fetchTypes =  {"features": _this.fetchFeatures, "userStories": _this.fetchUserStories, capabilities: false}
				}
				_this.loader.show = true;
                let apiCall = "";
                if(_this.isMockingMode){
                    apiCall = "/riskregister/get-items-and-subitems";
                }else{
                    apiCall ='/riskregister/geitems';
					if(_this.linkItemFor == "objective") {
						data.fetchContainers = true;
					}
                }

				axios.post(apiCall, data)
				.then(response => { 
					
					_this.loader.show = false;
					
					if (response.data) {
												
						_this.$options.sessionBoardsMapBySessionId = {};
						
						var sessionBoards = response.data.sessionBoards;
						_.each(sessionBoards,sb=>{
							_this.$options.sessionBoardsMapBySessionId[sb.session.id] = sb;
						});	
						if(_this.$options.unfilteredData == undefined) {
							_this.$options.unfilteredData = {};
						}
						if(_this.currentTab == "feature") {
							var features = response.data.features;						
							_this.$options.unfilteredData.features = features;
							_this.featuresFetched =  true;
						} else if(_this.currentTab == "story") {
							var stories  = response.data.stories;						
							_this.$options.unfilteredData.stories  = stories;
							_this.storiesFetched =  true;
						} else if (_this.currentTab == 'capability') {
							_this.$options.unfilteredData.capabilities = response.data.epics;
							_this.capabilityFetched = true;
						}
						_this.$emit("data-loaded",response.data);

						this.applyFilter ();
						
						_this.setSelectedItems(_this.selectedItemIds);
						if(!_this.showBoardFilter) {
                            _this.createBacklogGroups();
                            _this.onSelectBacklogGroup(this.selectedBacklogGroup);
						}
					}
				})
				.catch(error => {
					_this.loader.show = false;
				});
            },
            queryBacklogItemsOnSearch(){
                this.pageStart = 0;
                if(this.$options.unfilteredData && this.$options.unfilteredData.features){
                    this.$options.unfilteredData.features = [];
                    this.$options.unfilteredData.stories = [];
                }
                Vue.set(this.dataCopy, 'features', []);

                this.fetchItems();
            },
            resetSearch(){
                this.query = "";
                this.queryBacklogItemsOnSearch();
            },
            queryBacklogItemsCollectionSelect(){

                if(this.selectedBackLogItemsMap.length!=0){
                    askFromSweetAlertWrapper('If you decide to change the collection, your currently selected items will be removed. Are you sure you want to continue?',[this.onClickSwitchCollection],[this.onCancelSwitchCollection]);
                }else{
                    // Vue.set(this,'selectedBackLogItemsMap',[]);
                    this.pageStart = 0;
                    if(this.$options.unfilteredData && this.$options.unfilteredData.features){
                        this.$options.unfilteredData.features = [];
                        this.$options.unfilteredData.stories = [];
                    }
                    Vue.set(this.dataCopy, 'features', []);
                this.fetchItems();
                this.$options.prevSlctdReleaseTrainMap = this.slctdReleaseTrainMap;

            }
        },
        onCancelSwitchCollection(){
            if(this.$options.prevSlctdReleaseTrainMap!=undefined){
                this.slctdReleaseTrainMap = this.$options.prevSlctdReleaseTrainMap;
            }
        },
        onClickSwitchCollection(){
            this.resetSelectedReleaseTrainMeta();
            this.fetchSelectedReleaseTrainMeta(this.slctdReleaseTrainMap.id);
            this.queryBacklogItemsOnSearch();
            this.selectedBackLogItemsMap = [];
        },
        onChangePage(pageNumber){
            // this.pagination.pageStart= this.pagination.pageStart + this.pagination.pageSize;
            this.pagination.pageIndex = pageNumber;
            this.fetchItems()
        },
        fetchItems() {
            let _this = this;
            _this.itemNotFound = false;
            _this.loader.show = true;

            /*if(this.query.length==0){
                if(this.$options.unfilteredData && this.$options.unfilteredData.features &&   this.dataCopy.features) {
                    this.$options.unfilteredData.features = [];
                    Vue.set(this.dataCopy, 'features', []);
                }
                return;
            }*/
                var data = {};
                // data.hierachLevel = "" + this.selectedHierarchLevel;
                data.rollupBatches = true;
                data.rollupSprints = true;
                data.rollupStoryPointsArray = true;

                //data.pageStart = ""+(this.pagination.pageIndex * this.pagination.pageSize);
                // data.pageStart = "" + (this.pagination.pageIndex * this.pagination.pageSize);
                // data.pageSize = "" + (this.pagination.pageSize);
                //data.pageIndex = "0";
                //data.pageSize = "2";

            data.pageStart = "" + (this.pagination.pageIndex * this.pagination.pageSize);
            data.pageSize = "" + this.pagination.pageSize;

                data.sortBy = "sequence";
                data.sortOrder = "1"

                data.requestId = getNewUUID();

            //.....................................................................

                let regex= /[^a-zA-Z0-9- ]/g;
                filteredQuery= this.query.replace(regex, "");

            if (!_.isEmpty(this.timelineId)){
                data.boardId = this.timelineId;
            }

            let filters = undefined;

            if (this.selectedReleaseTrainMeta.selectedFilter
                && this.selectedReleaseTrainMeta.selectedFilter.id!=="-1") {
                filters = this.selectedReleaseTrainMeta.selectedFilter.criteria;
            }

            if (_.isEmpty(filters)) {
                filters = { condition: "AND" };
            }
            if (filteredQuery !== undefined) {
                if (!filters.rules) {
                    filters.rules = [];
                }
                //.......   search in title-id
                let titleFilter = _.find(filters.rules, { key: "title-id" });
                if (!titleFilter) {
                    titleFilter = { key: "title-id", value: [], operator: "EQUALS", type: "text" };
                    filters.rules.push(titleFilter);
                }
                titleFilter.value = [filteredQuery];
            }
            data.filter = filters;
            //.....................................................................

            clearTimeout(this.debounceTimer); // Clear previous debounce timer
                this.debounceTimer = setTimeout(() => {
                /*if(this.query.length==0){
                        if(this.$options.unfilteredData && this.$options.unfilteredData.features &&   this.dataCopy.features) {
                            this.$options.unfilteredData.features = [];
                            Vue.set(this.dataCopy, 'features', []);
                        }
                        return;
                }*/

                // _this.loader.show = true;
                if (!_.isEmpty(this.timelineHierarchyLevel)){
                    data.hierachLevel = this.timelineHierarchyLevel.level.toString();
                }else{
                    data.hierachLevel = _this.selectedReleaseTrainMeta.selectedHierarchyLevel.level.toString();
                }

                let releaseTrainId = !_.isEmpty(_this.slctdReleaseTrainMap.id) ? _this.slctdReleaseTrainMap.id : _this.releaseTrainId;

                axios.post('/releasetrain/' + releaseTrainId + '/backlog', data)
                    .then(response => {
                        _this.loader.show = false;
                        if (response.data.result && !_.isEmpty(response.data.result.items)) {

                            var features = response.data.result.items;
                            //if selectedbacklogitems are not empty then remove the selected items from the features
                            if(_this.selectedBackLogItemsMap.length!=0){
                                _.each(_this.selectedBackLogItemsMap, item => {
                                    var index = _.findIndex(features, { id: item.id });
                                    if (index > -1) {
                                        features.splice(index, 1);
                                    }
                                });
                            }
                        if (response.data.result.total) {
                            _this.pagination.totalItemSize = response.data.result.total;
                        }
                            // var stories  = response.data.stories;
                        if (!features || _.isEmpty(features) || features.length < _this.pagination.pageSize) {
                                _this.disableLoadMore = true;
                            }else{
                                _this.disableLoadMore = false;

                            }

                            _this.$options.sessionBoardsMapBySessionId = {};

                            var sessionBoards = response.data.sessionBoards;
                            _.each(sessionBoards, sb => {
                                _this.$options.sessionBoardsMapBySessionId[sb.session.id] = sb;
                            });

                            _this.$options.unfilteredData = {};
                            if(!_this.$options.unfilteredData.features){
                                _this.$options.unfilteredData.features=[];
                            }
                        _this.$options.unfilteredData.features = features;
                            _this.$options.unfilteredData.stories  = [];
                            //append the new data to the existing data
                        _this.dataCopy.features = features;


                            // _this.dataCopy.features  features;
                            _this.dataCopy.stories  = [];

                            _this.$emit("data-loaded", response.data);
                        _this.setSelectedBackLogItems(_this.baseItemLinks);
                        }else{
                            _this.itemNotFound = true;
                            _this.$forceUpdate();
                        }
                    })
                    .catch(error => {
                        _this.loader.show = false;
                    });
                }, 500);


        },
        //////////////////////////////////////////////////
        //////////////     UI ACTIONS
        onUnSelectSelecctedBklogItems: function (index) {
            try {
                var item = this.selectedBackLogItemsMap[index];
                //check if the selected hierarchy level is same as the item's hierarchy level
                this.selectedBackLogItemsMap.splice(index, 1);
                //fetch the item's hierarchy level from item artrelationmap
                if (item.artRelationMap && this.slctdReleaseTrainMap && item.artRelationMap[this.slctdReleaseTrainMap.id]) {
                    if (this.selectedReleaseTrainMeta.selectedHierarchyLevel.level == item.artRelationMap[this.slctdReleaseTrainMap.id].backlogLevel) {
                        this.dataCopy.features.push(item);
                        item.selected = false;
                        this.saveButtonEnabled = true;
                    }
                }
                this.checkForEnablesSaveButton();
            }catch (e) {
                console.log("Error occurred while unselecting selected backlog items: ", e)
            }
        },
		onSelectLinkItem: function(itemType, index, groupIndex) {
			if (this.backLogItemsMode) {
				var item = this.dataCopy.features[index];
				if (!item.selected) {
					this.selectedBackLogItemsMap.push(item);
					if (!this.isTimelineView) {
						this.selectedBacklogItemsRTMap[this.slctdReleaseTrainMap.id].push(item.id);
					}
					this.dataCopy.features.splice(index, 1);
					item.selected = true;
				}
				this.saveButtonEnabled = true;
			} else {// Handling Item Selection in both cases i.e. grouping applied or not applied
				if (itemType === 'fe') {
					if (groupIndex != undefined) {
						var item = this.groupedBacklogItems[groupIndex].items[index];
						Vue.set(item, "selected", !item.selected);
					} else {
						var item = this.dataCopy.features[index];
						Vue.set(item, "selected", !item.selected);
					}
				} else if (itemType === 'ca') {
					if (groupIndex != undefined) {
						var item = this.groupedBacklogItems[groupIndex].items[index];
						Vue.set(item, "selected", !item.selected);
					} else {
						var item = this.dataCopy.capabilities[index];
						Vue.set(item, "selected", !item.selected);
					}
				} else {
					if (groupIndex != undefined) {
						var item = this.groupedBacklogItems[groupIndex].items[index];
						Vue.set(item, "selected", !item.selected);
					} else {
						var item = this.dataCopy.stories[index];
						Vue.set(item, "selected", !item.selected);
					}
				}
				// If items are grouped and some items already selected in some other group, then don't count it again.
				if (item.selected) {
					if (!this.selectedItemIds.includes(item.id)) {
						this.selectedItemIds.push(item.id);
					}
					this.selectedCount++;
				} else {
					const itemIndex = this.selectedItemIds.indexOf(item.id);
					if (itemIndex !== -1) {
						this.selectedItemIds.splice(itemIndex, 1);
					}
					this.selectedCount--;
				}
				this.checkForEnablesSaveButton();

			}
		},

        onClickCancelLinkItem: function () {
            if (this.fitContainer) {
                var element = document.getElementById("link-item-popup-container");
                element.parentElement.removeChild(element);
            }
            this.$emit('cancel');
        },
        getQueriedItemsIds: function () {
            let itemIds = [];
            _.each(this.dataCopy.features, item => {
                itemIds.push(item.id);
            });
            return itemIds;
        },
        onSelectSaveLinkItems: function () {
            let _this= this;
            if(this.backLogItemsMode){
                // let selectedBackLogItems = [];
                //
                // Object.keys(_this.selectedBackLogItemsMap).forEach(function(key) {
                //     selectedBackLogItems.push(_this.selectedBackLogItemsMap[key]);
                // });

                this.$emit('save',_this.selectedBackLogItemsMap, _this.slctdReleaseTrainMap.id);
                this.onClickCancelLinkItem();
            }else if (this.linkItemFor === "milestone"){
                _this.getSelectedItemsForMilestones();
            }else{
                this.getSelectedItemsFromLinkPopupFromLinkPopup();
            }
        },
        onSelectAllLinkItem: function (check) {
            _.each (this.dataCopy.features,item=>{
                item.selected = check;
            });
            _.each (this.dataCopy.stories,item=>{
                item.selected = check;
            });
            this.saveButtonEnabled = check;
        },
        onChangeBoardSelection: function  (board) {
/*
				Object.assign(this.$data, this.initialData());
				this.slctdBoards = [board];
				this.onCreatedCalled();
				this.onMountedCalled();
*/
            this.applyFilter();
        },
        onEnterSearchText: function () {
            this.applyFilter(true);
        if(!this.showBoardFilter) {
                    this.createBacklogGroups();
					this.onSelectBacklogGroup(this.selectedBacklogGroup);
				}},
        onChangeLinkedToObjective: function() {
            this.selectedCount = 0;
            this.totalExcludedCount = 0;
            this.applyFilter();this.createBacklogGroups();
				this.onSelectBacklogGroup(this.selectedBacklogGroup);
        },
		onChangeTab: function(tabName) {
			if (tabName != this.currentTab) {
				this.currentTab = tabName;
				this.selectedCount = 0;
				if (!this.showBoardFilter) {
					this.selectedBacklogGroup = '';
				}
				if ((this.currentTab == 'story' && this.storiesFetched) || (this.currentTab == 'feature' && this.featuresFetched) || (this.currentTab == 'capability' && this.capabilityFetched)) {
					this.backlogGroupOptions = []; this.applyFilter();
					if (!this.showBoardFilter) {
						this.createBacklogGroups();
						this.onSelectBacklogGroup(this.selectedBacklogGroup);
					}
				} else {
					this.loadBoardData(this.slctdBoards.concat(this.slctdSolBoards))
				}
			}
		},
        onSelectCollection: function (){
            let _this = this;

            if (this.pagination.pageIndex !== 0) {
                this.pagination.pageIndex = 0;
                this.paginatorKey += 1;
            }

            if(this.selectedBackLogItemsMap.length!=0){
                askFromSweetAlertWrapper('If you decide to change the collection, your currently selected items will be removed. Are you sure you want to continue?',[this.onClickSwitchCollection],[this.onCancelSwitchCollection]);
            }else {
                this.$options.prevSlctdReleaseTrainMap = this.slctdReleaseTrainMap;
                this.resetSelectedReleaseTrainMeta();
                _this.fetchSelectedReleaseTrainMeta(_this.slctdReleaseTrainMap.id);
            }
        },
        fetchSelectedReleaseTrainMeta: function(releaseTrainId) {
            let _this = this;
            let requestBody = {
                "releaseTrainId"   : releaseTrainId,
                "fetchHierarchies" : true,
                "fetchFilters"     : true
            }
            axios.post("/releasetrain/fetch-release-train-hierarchies-and-filters", requestBody)
            .then(response => {
                if (response.status == "200" && response.data.hierarchyLevels) {

                    _this.selectedReleaseTrainMeta.itemHierarchyLevels = response.data.hierarchyLevels;
                    _this.selectedReleaseTrainMeta.allFilters = response.data.filterCriterias;

                    if (_.isEmpty(_this.selectedReleaseTrainMeta.selectedHierarchLevel)){
                        _this.selectedReleaseTrainMeta.selectedHierarchyLevel = _this.selectedReleaseTrainMeta.itemHierarchyLevels[0];
                        _this.onSelectReleaseTrainHierarchy();
                    }
                }
            })
            .catch(error => {
                console.error("Error occurred while fetching hierarchy levels: ", error);
            });
        },
        onSelectReleaseTrainHierarchy: function () {

            let _this = this;

            let hierarchyFilters = _.filter(this.selectedReleaseTrainMeta.allFilters, f=> {
                return _this.selectedReleaseTrainMeta.selectedHierarchyLevel &&
                    _this.selectedReleaseTrainMeta.selectedHierarchyLevel.level == f.level;
            });
            //push in the start
            hierarchyFilters.unshift({id:"-1", name: "Select Filter"});
            this.selectedReleaseTrainMeta.hierarchyFilters = hierarchyFilters;
            this.selectedReleaseTrainMeta.selectedFilter = {id:"-1", name: "Select Filter"};


            this.queryBacklogItemsOnSearch();
        },
        onSelectReleaseTrainFilter: function () {
            //CHECK if filter is selected
            if(this.selectedReleaseTrainMeta.selectedFilter
                && this.selectedReleaseTrainMeta.selectedFilter.id=="-1"
                && !_.isEmpty(this.selectedReleaseTrainMeta.selectedFilter)) {

                this.isFilterSelected = true;
            }
            if (this.pagination.pageIndex !== 0) {
                this.pagination.pageIndex = 0;
                this.paginatorKey += 1;
            }

            this.queryBacklogItemsOnSearch();
        },

        resetSelectedReleaseTrainMeta: function() {
            this.selectedReleaseTrainMeta.itemHierarchyLevels = [];
            this.selectedReleaseTrainMeta.selectedHierarchyLevel = undefined;

            this.selectedReleaseTrainMeta.allFilters = [];
            this.selectedReleaseTrainMeta.hierarchyFilters = [{id:"-1", name: "Select Filter"}];
            this.selectedReleaseTrainMeta.selectedFilter = {id:"-1", name: "Select Filter"};
        },
        viewCollection: function () {
            let url = window.location.origin + "/org#/ART/" + this.slctdReleaseTrainMap.id + "/backlog";
            window.open(url, "_blank");
        },

createBacklogGroups : function (){
				var almData = [];
				var kendisData = {
					id:"kendisGroups",
					items : [{id:this.BACKLOG_GROUPS.KENDIS_TEAM,title:"Team"},
						{id:this.BACKLOG_GROUPS.CARD_TYPE,title:"Card Type"},
						{id:this.BACKLOG_GROUPS.PLANNING,title:"Planned/Unplanned"},
						{id:this.BACKLOG_GROUPS.STATUS_CATEGORY,title:"Status Category"},
						// {id:this.$options.BACKLOG_GROUPS.BATCH,title:"Batches"}
					],
					title : "Group by Basic Fields"
				}

				this.backlogGroupOptions = [];
				if (vueInstance.isJira) {
					let additionalFieldArray = [];
					if(this.board.session.jiraFeatureParentEnabled){
						additionalFieldArray.push({ title: 'Parent', id: 'jiraField-parent' });
					}
                    let jiraCustomFields = []
                    if (this.currentTab == 'feature') {
                        jiraCustomFields = this.board.session.additionalFieldsValuesFeature;
                    }else{
                        jiraCustomFields = this.board.session.additionalFieldsValuesUserStory;
                    }
					if (this.board.session.additionalFieldsEnabled && !_.isEmpty(jiraCustomFields)) {
						if (vueInstance.$options.jiraMeta) {
							for (let customField of jiraCustomFields) {
								let fieldData = vueInstance.$options.jiraMeta._jiraFieldsMap[customField.key];
								if (fieldData) {
									if(this.board.session.jiraFeatureParentEnabled && fieldData.key == 'parent'){
										continue;
									}
									additionalFieldArray.push({ title: fieldData.name, id: 'jiraField-'+fieldData.key });
								}
							}
						}
					}
					if(additionalFieldArray.length > 0){
						almData = {
							id: "almGroups",
							items: additionalFieldArray,
							title: "By Jira Additional Fields"
						}
					}
					if(!_.isEmpty(this.board.session.almConfigurations)) {
						kendisData.items.push({id:this.BACKLOG_GROUPS.JIRA_PROJECT,title:"Jira Project"});
					}
				} else {
					almData = {
						id: "almGroups",
						items: [{ id: this.BACKLOG_GROUPS.TFS_PROJECT, title: "Project" }, { id: this.BACKLOG_GROUPS.TFS_AREA_PATH, title: "Area Path" }, { id: this.BACKLOG_GROUPS.PARENT_EPIC, title: "Parent-Epic" }],
						title: "By Azure DevOps Fields"
					};

					let duplicationCheckMap = {};
					_.each(vueInstance.$options._boardMeta.tfsProjects, project=> {
						if (project.selectedFields) {
							_.each(project.selectedFields, fieldMap=> {
								if (!duplicationCheckMap[fieldMap.referenceName]) {
									duplicationCheckMap[fieldMap.referenceName] = true;

									let groupByOption = {};
									groupByOption.title = fieldMap.name;
									groupByOption.id = "tfsField-"+fieldMap.referenceName;
									groupByOption.key = fieldMap.referenceName;
									groupByOption.dataType = fieldMap.type;

									almData.items.push(groupByOption);
								}
							});
						}
					});
					this.isJiraMetaLoaded = true;
				}
				
				// kendis custom fields
				var kendisFields = {
					id : "kendisFieldsGroups",
					items : [],
					title: "By Kendis Custom Fields"					
				};
				vueInstance.$options.kendisFieldsMapById = {};
				if(vueInstance.$options.kendisFields && vueInstance.$options.kendisFields.fields) {
					_.each(vueInstance.$options.kendisFields.fields, field =>{
						if(field.type != 'richtext' && field.type != 'link') {
							kendisFields.items.push({id : field.id, title: field.title});							
						}
						vueInstance.$options.kendisFieldsMapById[field.id] = field;
					});
				}

				this.backlogGroupOptions.push({id:"no group",items:[{id:"default",title:"No Groups"}],title:"", hide : true});
				this.backlogGroupOptions.push(kendisData);
				this.backlogGroupOptions.push(almData);
				if(!_.isEmpty(kendisFields.items)) {
					this.backlogGroupOptions.push(kendisFields);
				}

                let codedParam = getBase64DecodedUrlParameter('gbsc');
                let allItems = kendisData.items.concat(almData.items);
                this.selectedBacklogGroup = (!_.isEmpty(codedParam) && allItems.some(item => item.id === codedParam))
                    ? codedParam
                    : this.backlogGroupOptions[0].items[0].id;
			},

			onSelectBacklogGroup: function (value) {
                let groupData = {};
                const _this = this;
                let groupVisibilityMapById = {};
                let isUrlApplied = false;
                _this.selectedCount = 0;
                _this.selectedExcludedCount = 0;
                if((value && (value !== this.selectedBacklogGroup)) || _this.groupedBacklogItems.length == 0){							// value means it event came from dropdown. Thus we need to hide groups
					this.expandAllBacklogGroup = false;
					this.RefreshBoardUponGroupChange();
				}else{
					if(!_.isEmpty(_this.groupedBacklogItems)) {
						_.each(_this.groupedBacklogItems,group =>{
							groupVisibilityMapById[group.id] = group.show;
						});
					}
				}
				_this.groupedBacklogItems = [];
				let isValidGroups = true;
				let hiddenGroup = {};
				let codedParam = getBase64DecodedUrlParameter('gbsc');
				hiddenGroup = getBase64DecodedUrlParameter('gbsc2');
				if((!_.isEmpty(codedParam) && (_.isEmpty(this.selectedBacklogGroup)))){
					this.selectedBacklogGroup = codedParam;
				}
				if(hiddenGroup){
					hiddenGroup = JSON.parse(hiddenGroup);
					if(hiddenGroup.key === this.selectedBacklogGroup){
						hiddenGroup = hiddenGroup.values;
					}else{
						hiddenGroup = {};
						deleteUrlParameter('gbsc2');
					}
				}else{
					hiddenGroup = {};
					deleteUrlParameter('gbsc2');
				}

				if (_this.selectedBacklogGroup == "default") {
					_this.groupedBacklogItems.push({ items: _this.applyFilters(), show: true ,visibility:false });
					if(!_.isEmpty(codedParam)){
						deleteUrlParameter('gbsc');
						deleteUrlParameter('gbsc2');
						isUrlApplied=true;
					}

				}
				else {

					if (_this.selectedBacklogGroup == _this.BACKLOG_GROUPS.PLANNING) {
						isValidGroups = _this.onGroupByPlanning(hiddenGroup, groupVisibilityMapById);
						//setBase64EncodedUrlParameter('gbsc',_this.BACKLOG_GROUPS.PLANNING);
						//isUrlApplied=true;
					}

					else if (_this.selectedBacklogGroup == _this.BACKLOG_GROUPS.CARD_TYPE) {
						isValidGroups = _this.onGroupByCardType(hiddenGroup, groupVisibilityMapById);
						//setBase64EncodedUrlParameter('gbsc',_this.BACKLOG_GROUPS.CARD_TYPE);
						//isUrlApplied=true;
					}

					else if (_this.selectedBacklogGroup == _this.BACKLOG_GROUPS.STATUS_CATEGORY) {
						isValidGroups = _this.onGroupByStatus(hiddenGroup, groupVisibilityMapById);
						//setBase64EncodedUrlParameter('gbsc',_this.BACKLOG_GROUPS.STATUS_CATEGORY);
						//isUrlApplied=true;
					}

					else if (_this.selectedBacklogGroup == _this.BACKLOG_GROUPS.KENDIS_TEAM) {
						isValidGroups = _this.onGroupByTeam(hiddenGroup, groupVisibilityMapById);
						//setBase64EncodedUrlParameter('gbsc',_this.BACKLOG_GROUPS.KENDIS_TEAM);
						//isUrlApplied=true;

					}
						// else if (_this.selectedBacklogGroup == _this.$options.BACKLOG_GROUPS.BATCH) {
						//     _this.onGroupByBatch(groupVisibilityMapById);
					// }

					else if (_this.selectedBacklogGroup == _this.BACKLOG_GROUPS.PARENT_EPIC || _this.selectedBacklogGroup == _this.BACKLOG_GROUPS.JIRA_FIELD_PARENT) {
						isValidGroups = _this.onGroupByCustomField(hiddenGroup, groupVisibilityMapById,"parent");
						//setBase64EncodedUrlParameter('gbsc',_this.BACKLOG_GROUPS.PARENT_EPIC);
						//isUrlApplied=true;
					}

					else {
						let str = _this.selectedBacklogGroup.split("-");
						if(str[1]) {
							if (str[0] == "jiraField") {
								isValidGroups= _this.onGroupByCustomField(hiddenGroup, groupVisibilityMapById, str[1], 'jiraFieldTextByKey');
								//setBase64EncodedUrlParameter('gbsc',str[0]+'-'+str[1]);
								//isUrlApplied=true;
							}
							if (str[0] == "tfsField") {
								isValidGroups= _this.onGroupByCustomField(hiddenGroup, groupVisibilityMapById, str[1], 'tfsFieldMap');
								//setBase64EncodedUrlParameter('gbsc',_this.selectedBacklogGroup);
								//isUrlApplied=true;
							}
						}else{
							if (_this.selectedBacklogGroup == _this.BACKLOG_GROUPS.JIRA_PROJECT) {
								groupData = _.groupBy(_this.applyFilters(), function(o) { if (o.jiraKey) { let str = o.jiraKey.split('-'); return str[0];}});
								//setBase64EncodedUrlParameter('gbsc',_this.BACKLOG_GROUPS.JIRA_PROJECT);
								//isUrlApplied=true;
							}else if (vueInstance.$options.kendisFieldsMapById && vueInstance.$options.kendisFieldsMapById[_this.selectedBacklogGroup]) {   // kendis Custom fields
								let grpField = vueInstance.$options.kendisFieldsMapById[_this.selectedBacklogGroup];
								groupData = _this.onGroupByKendisCustomFields(grpField);
								setBase64EncodedUrlParameter('gb',_this.selectedBacklogGroup);
								isUrlApplied=true;
							}else{
								groupData = _.groupBy(_this.applyFilters(), function(o) { if (o[_this.selectedBacklogGroup]) { return o[_this.selectedBacklogGroup] } });
								//setBase64EncodedUrlParameter('gbsc',_this.selectedBacklogGroup);
								//isUrlApplied=true;
							}
							var noGroup = {};
							_.each(groupData, function(items, groupName) {
								if (groupName == "undefined") {
									var filteredItems = _.filter(items,item=>{return true;});
									noGroup = { title: "kendis Group", items: filteredItems, show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById,"kendis Group"), id:"kendis Group",visibility: hiddenGroup['kendis Group'] };
								} else {
									_this.groupedBacklogItems.push({ title: groupName, items: items, show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById,groupName), id:groupName,visibility: hiddenGroup[groupName]});
								}
							});
							if (!_.isEmpty(noGroup)) {
								_this.groupedBacklogItems.push(noGroup);
							}
							if(!isUrlApplied){
								setBase64EncodedUrlParameter('gbsc',noGroup.title);
							}
						}

					}
				}

                _this.setSelectedItems(this.selectedItemIds);

                return isUrlApplied && !_.isEmpty(hiddenGroup) && isValidGroups;
			},

			RefreshBoardUponGroupChange:function(){
				let _this=this;
				_.each(_this.board.teams,team=>{
					_.each(_this.board.containers,sprint=>{
						let itemContainers=_this.itemTeamContainerMap[team.id+sprint.id]
						if(!_.isEmpty(itemContainers)){
							_.each(itemContainers,itemContainer=>{
								itemContainer.show=true;
							})
						}
					})
				})
			},
			onGroupByKendisCustomFields: function(grpField) {
				var _this = this;
				var groupData = {};
				
				if(grpField.type == 'richtext') {
					groupData = _.groupBy(_this.applyFilters(), function(o) { if (o.fields && o.fields[_this.selectedBacklogGroup] ) { return o.fields[_this.selectedBacklogGroup].replace(/<[^>]*>?/gm, '') } });
				}
				else if (grpField.type == 'userpicker') {
					groupData = _.groupBy(_this.applyFilters(), function(o) { if (o.fields && o.fields[_this.selectedBacklogGroup] ) { return o.fields[_this.selectedBacklogGroup].fullName } });
				}
				else if (grpField.type == 'datepicker') {
					groupData = _.groupBy(_this.applyFilters(), function(o) { if (o.fields && o.fields[_this.selectedBacklogGroup] ) { return new Date(o.fields[_this.selectedBacklogGroup]).format("dd mmmm yyyy") } });
				}
				else if (grpField.type == 'multiselect') {
					groupData = _.groupBy(_this.applyFilters(), function(o) {
						if (o.fields && o.fields[_this.selectedBacklogGroup]) {
							let str = "";
							_.each(o.fields[_this.selectedBacklogGroup], function(option, i) {
								str = str + option.title;
								if (i < o.fields[_this.selectedBacklogGroup].length - 1) {
									str = str + ", ";
								}
							});
							return str;
						}
					});
				} else if (grpField.type == 'singleselect') {
					groupData = _.groupBy(_this.applyFilters(), function(o) { if (o.fields && o.fields[_this.selectedBacklogGroup] ) { return o.fields[_this.selectedBacklogGroup].title } });
				} else if (grpField.type == 'link') {
					groupData = _.groupBy(_this.applyFilters(), function(o) { if (o.fields && o.fields[_this.selectedBacklogGroup] ) { return o.fields[_this.selectedBacklogGroup].name } });
				} else {
					groupData = _.groupBy(_this.applyFilters(), function(o) { if (o.fields && o.fields[_this.selectedBacklogGroup] ) { return o.fields[_this.selectedBacklogGroup] } });
				}
				return groupData;
			},
			onGroupByPlanning: function(hiddenGroup, groupVisibilityMapById) {
				var groupData = {};
				var _this = this;
				const backlogItems = _this.applyFilters();
				groupData = _.groupBy(backlogItems, function(o) { return o.teamContainers != undefined && o.teamContainers.length > 0 });
				if (groupData["true"]) {
					_this.groupedBacklogItems.push({ title: "Planned", items: groupData["true"], show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, "Planned"), id: "Planned" ,visibility: hiddenGroup['Planned']});
				}
				if (groupData["false"]) {
					_this.groupedBacklogItems.push({ title: "Unplanned", items: groupData["false"], show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, "Unplanned"), id: "Unplanned",visibility: hiddenGroup['Unplanned'] });
				}

				return true;
			},
			onGroupByCardType: function(hiddenGroup, groupVisibilityMapById) {
				let validGroups = [];
                let groupData = {};
                const _this = this;
                const backlogItems = _this.applyFilters();
				groupData = _.groupBy(backlogItems, function(o) {
					if(o.issueType){
						return o.issueType.id;
					}else{
						return undefined;
					}
				});
				var featureTypeItems;
				if (groupData["undefined"] || groupData["-1"]) {
					if (groupData["undefined"]) {
						featureTypeItems = groupData["undefined"];
					}
					if (groupData["-1"]) {
						if (featureTypeItems) {
							featureTypeItems = featureTypeItems.concat(groupData["-1"]);
						} else featureTypeItems = groupData["-1"];
					}

                    let title =  _this.board.session.parentItem;
                    let id = "Feature";

                    if (backlogItems.some(item => item.type === "UserStory")) {
                        title = "No Card Type";
                        id = "no_card_type";
                    }

					_this.groupedBacklogItems.push({ title: title, items: featureTypeItems, show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, "Feature"), id: id, visibility: hiddenGroup['Feature']});
				}

				_.each(vueInstance.$options._boardMeta.allIssueTypes, issue => {
					if (groupData[issue.id]) {
						let _gid = issue.id;
						_this.groupedBacklogItems.push({ title: issue.title, items: groupData[_gid], show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, _gid), id: _gid, visibility: hiddenGroup[_gid] });
						if(hiddenGroup[_gid]){
							validGroups.push(_gid);
						}
					}
				});

				return validGroups.length > 0;
			},
			onGroupByStatus: function(hiddenGroup, groupVisibilityMapById) {
				var groupData = {};
				var _this = this;
				let backlogItems = _this.applyFilters();
				groupData = _.groupBy(backlogItems, function(o) { if (o.status ) { return o.status.category } });
				if (groupData['ToDo']) 			{ _this.groupedBacklogItems.push({ items: groupData['ToDo'], 		title: 'To Do', 		show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, 'To Do'), 		visibility: hiddenGroup['To Do'], id: 'To Do' }) };
				if (groupData['InProgress']) 	{ _this.groupedBacklogItems.push({ items: groupData['InProgress'], 	title: 'In Progress', 	show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, 'In Progress'), visibility: hiddenGroup['In Progress'], id: 'In Progress' }) };
				if (groupData['Done']) 			{ _this.groupedBacklogItems.push({ items: groupData['Done'], 		title: 'Done', 			show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, 'Done'), 		visibility: hiddenGroup['Done'], id: 'Done' }) };
				if (groupData['Misc']) 			{ _this.groupedBacklogItems.push({ items: groupData['Misc'], 		title: 'Misc', 			show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, 'Misc'), 		visibility: hiddenGroup['Misc'], id: 'Misc' }) };
				if (groupData['undefined']) {
					var items = _.filter(groupData['undefined'], item => { if (!item.status) { return true; } });
					if (!_.isEmpty(items)) {
						_this.groupedBacklogItems.push({ items: items, title: 'No Category', show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, 'No Category'), id: 'No Category' , visibility: hiddenGroup['No Category']})
					}
				}

				return true;
			},
			onGroupByTeam: function(hiddenGroup, groupVisibilityMapById) {
				let validGroups = [];
				var groupData = {};
				var _this = this;
				var itemMapByTeamId = {};
				var itemsWithNoTeam = [];
				const backlogItems = _this.applyFilters();
				_.each(backlogItems, item => {
					if (item.teamContainers && item.teamContainers.length > 0) {
						var sameTeamItemMap = {};
						_.each(item.teamContainers, tC => {
							if (!sameTeamItemMap[tC.team.id]) {
								if (!itemMapByTeamId[tC.team.id]) {
									itemMapByTeamId[tC.team.id] = [];
								}
								itemMapByTeamId[tC.team.id].push(item);
								sameTeamItemMap[tC.team.id] = item;
							}
						});
					} else {
						itemsWithNoTeam.push(item);
					}
				});
				_.each(_this.board.teams, team => {
					if (itemMapByTeamId[team.id]) {
						let _gid = vueInstance.$options._teamsMap[team.id].id;
						_this.groupedBacklogItems.push({ title: vueInstance.$options._teamsMap[team.id].title, items: itemMapByTeamId[team.id], show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, _gid), id: _gid, visibility: hiddenGroup[_gid] });
						if(hiddenGroup[_gid]){
							validGroups.push(_gid);
						}
					}
				});
				if (!_.isEmpty(itemsWithNoTeam)) {
					_this.groupedBacklogItems.push({ title: "No Team", items: itemsWithNoTeam, show: vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, "No Team"), id: "No Team",visibility: hiddenGroup['No Team'] });
				}
				return validGroups.length > 0;
			},
			onGroupByCustomField: function(hiddenGroup, groupVisibilityMapById, jiraField, propJira) {
				let validGroups = [];
				let groupMap = {};
				let groupArray = [];
				let noGroup;
				let _this = this;
				let backlogItems = _this.applyFilters();
				_.each(backlogItems, item => {
					let tfsField;

					let hasGroupValue = false;
					if(propJira == 'tfsFieldMap'){
						if (item[propJira]) {
							tfsField = _.find(item[propJira], {key:jiraField});
						}
						if (tfsField && tfsField.value) {
							hasGroupValue = true;
						}
					}
					else {
						if ((item.tfsFieldByKey && item.tfsFieldByKey.ParentId) || (propJira && item[propJira] && item[propJira][jiraField] )) {
							hasGroupValue = true;
						} else if (item.jiraFieldByKey && item.jiraFieldByKey.parent && item.jiraFieldByKey.parent.key) {
							hasGroupValue = item.type !== "UserStory";
						}
					}

					if (hasGroupValue) {
						let key;
						let name;
						if (tfsField) {
							key = tfsField.value;
							if (tfsField.type == "dateTime") {
								try {
									let date = new Date(tfsField.value);
									let dateStr = dateFormat(date, "d mmm, yy  hh:MM");
									name = dateStr;
								}
								catch (error) {
									name = tfsField.value;
								}
							} else {
								name = tfsField.value;
							}
						}
						else if(item.tfsFieldByKey && jiraField == "parent") {
							if(item.tfsFieldByKey.ParentId){
								key = item.tfsFieldByKey.ParentId;
								name = item.tfsFieldByKey.ParentId + " " + item.tfsFieldByKey.ParentTitle;
							}
						}
						else if (item.jiraFieldByKey && jiraField == "parent" && item.jiraFieldByKey.parent && item.jiraFieldByKey.parent.key) {
							key = item.jiraFieldByKey.parent.key;
							name = item.jiraFieldByKey.parent.key + " " + item.jiraFieldByKey.parent.fields.summary;
						}else{
							key = item[propJira][jiraField];
							name = item[propJira][jiraField];
							if(key instanceof Array) {
                                let newName = "";
                                for(let i = 0; i < key.length; i++) {
									if(typeof key[i] === 'string') {
										newName += key[i];
										if(i < key.length - 1) {
											newName += ", ";
										}
									} else if(typeof key[i] === 'object') {
										newName += key[i].value;
										if(i < key.length - 1) {
											newName += ", ";
										}
									}
								}
                                key = newName;
                                name = newName;
							}

							/*if(typeof name === 'object' && jiraField == 'parent'){
								key = item[propJira][jiraField].key;
								name = getJiraParentKey(item[propJira][jiraField], item[propJira], _this);//+' '+item[propJira][jiraField].fields.summary;
							}*/
						}

						let mapEntry = groupMap[key];
						if (!mapEntry) {
							mapEntry = {};
							mapEntry.title = name;
							mapEntry.id = name;
							mapEntry.visibility = hiddenGroup[mapEntry.id];
							mapEntry.items = [];
							mapEntry.show = vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, mapEntry.id);
							groupArray.push(mapEntry);
							groupMap[key] = mapEntry;
							if(hiddenGroup[mapEntry.id]){
								validGroups.push(mapEntry.id);
							}
						}
						mapEntry.items.push(item);
					} else {
						const title = "No Group";
						noGroup = groupMap[title];
						if (!noGroup) {
							noGroup = {};
							noGroup.title = title;
							noGroup.id = title;
							noGroup.visibility = hiddenGroup[noGroup.id];
							noGroup.items = [];
							noGroup.show = vueInstance.checkGroupItemsVisibility(groupVisibilityMapById, noGroup.id);
							groupMap[title] = noGroup;
						}
						noGroup.items.push(item);
					}
				});
				if (noGroup) {
					groupArray.push(noGroup);
				}
				_this.groupedBacklogItems = groupArray;

				return validGroups.length > 0;
			},

			applyFilters() {
				let items = [];
				if(this.currentTab === "feature"){
					items = _.cloneDeep(this.dataCopy.features);
				} else if(this.currentTab === "story"){
					items = _.cloneDeep(this.dataCopy.stories);
				}
				items = _.filter(items, item => {
					if(this.verifyItemsToExclude(item, this.excludeItemsData)) {
						return item;
					}
				});
				return items;
			},

			iconClass: function(group) {
				if(group.visibility === undefined){
					group.visibility = false;
				}
				return group.visibility;
			},
			onExpandGroupInBacklog: function (index){
				if(this.groupedBacklogItems[index].show){
					this.groupedBacklogItems[index].show = false;
				}else{
					this.groupedBacklogItems[index].show = true;
				}

			},
			initialData: function() {
				return {
					dataCopy: this.populateDataCopy(),
					saveButtonEnabled:false,
					query : "",
					selectedBacklogGroup: 'default',
					itemTeamContainerMap: {},
					loader: {
						show: false,
						text: ""
					},
					showBoard : false,
					itemNotFound : false,
					slctdBoards:[],
					slctdSolBoards:[],
					slctdBoard: {},
					isLinkedToObjectives: {id: "all", name: 'All Items'},
					BACKLOG_GROUPS : {
						TFS_AREA_PATH	: "tfsAreaPath",
						TFS_PROJECT 	: "tfsProject",
						TFS_TEAM		: "tfsTeam",
						PARENT_EPIC		: "parentEpic",
						CARD_TYPE		: "card type",
						// BATCH		    : "batch",
						PLANNING		: "unplanned/planned",
						STATUS_CATEGORY	: "status.category",
						KENDIS_TEAM		: "team",
						JIRA_PROJECT	: "jiraProject",
						JIRA_FIELD_PARENT: "jiraField-parent"
					},
					linkedObjectiveFilterOptions: [
						{id: "all", name: 'All Items'},
						{id: "yes", name: 'Linked to Objectives'},
						{id: "no", name:'Not Linked to Objectives'}
					],
					backlogGroupOptions: [],
					selectedBackLogItemsMap: [],
					groupedBacklogItems : [],
					releaseTrainMap: {},
					slctdReleaseTrainMap: {},
					selectedBacklogItemsRTMap:{},
					pagination: {
						avoidPaginatorAtFirstLoad: true,
						pageSize : 20,
						pageIndex: 0,
						totalItemSize: 0
					},
					disableLoadMore: true,
					selectedReleaseTrainMeta: {
						itemHierarchyLevels: [],
						selectedHierarchyLevel: undefined,

						allFilters: [],
						hierarchyFilters: [{id:"-1", name: "Select Filter"}],
						selectedFilter : {id:"-1", name: "Select Filter"},
					},
					isFilterSelected: false,
					showSelectedBacklogItemsFlag: false,
					currentTab: 'feature',
					featuresFetched: false,
					storiesFetched: false,
					capabilityFetched: false,
					selectedCount: 0,
					paginatorKey : 0,
					selectedExcludedCount: 0,
					totalExcludedCount: 0,
                    selectedItemIds: [],
				}
			},
			getItemUrl: function(item) {
				if(item.tfsId) {
					return item.tfsURL;
				} else if(item.jiraId) {
					return item.jiraURL;
				}
				return item.externalReferenceURL
			},
            areAllItemsChecked: function (groupIndex) {
                // Custom logic to determine whether all items are checked
                // For example, return true if all items in a group are checked:
                const selectedItemsCount = this.groupedBacklogItems[groupIndex].items.filter(item => item.selected).length;
                const totalItemsCount = this.groupedBacklogItems[groupIndex].items.length;

                if (selectedItemsCount === totalItemsCount) {
                    return true; // All items are selected
                }
                else if(selectedItemsCount>0){
                    return -1;
                }
                    else {
                    return false; // No items selected
                }

            },
            onCheckAllItems: function (groupIndex) {
                const selectedItemsCount = this.groupedBacklogItems[groupIndex].items.filter(item => item.selected).length;
                const totalItemsCount = this.groupedBacklogItems[groupIndex].items.length;
                if (selectedItemsCount === totalItemsCount) {
                    this.groupedBacklogItems[groupIndex].items.forEach(groupItem => {
                        groupItem.selected = false;
                        //this.selectedCount--;
                        this.selectedItemIds = this.selectedItemIds.filter(item => item != groupItem.id);

                    });
                } else if(selectedItemsCount<totalItemsCount && this.selectedCount>=0){

                    this.groupedBacklogItems[groupIndex].items.forEach(item => {
                        item.selected = true;
                      //  this.selectedCount++;
                        this.selectedItemIds.push(item.id);

                    });
                   // this.selectedCount= this.selectedCount - selectedItemsCount;
                }
                this.selectedCount=0;
                this.setSelectedItems(this.selectedItemIds);
                this.saveButtonEnabled = true;
            },
		}
	});