
var pushDataMap = new Map();
var isStompClientConnected = false;

var liveStreamMap = new Map();
liveStreamMap.set("target", null);

function setItemLiveStreamMap(key, item) {
    liveStreamMap.set(key, item);
}
function getItemLiveStreamMap(key, isNode) {
    var node = liveStreamMap.get(key);
    if (!_.isEmpty(node)) {
        return node;
    }
    if (isNode) {
        node = board.findNodeForKey(key);
    }
    else {
        node = board.findLinkForKey(key);
    }
    if (!_.isEmpty(node)) {
        liveStreamMap.set(key, node);
    }
    return node;
}
function deleteItemLiveStreamMap(key, data) {
    liveStreamMap.delete(key);
}

// Pusher.logToConsole = true;
var pusher = undefined;
var timer;
function mouseTimeOut(cursorKey){
    clearTimeout(timer)
    timer = setTimeout(function(){
        removeCursorNode(cursorKey);
    }, 30000);
}
function pusherConnect() {

	let isLocalDeployment = $('meta[name="isLocalDeployment"]').attr("content") == "true";
	if (isLocalDeployment) {
		return;
	}

    if (pusher == undefined) {

        var authUrl = "";
        if (vueGoInstance.isPublicLinkUrl) {
            // graphx/public_share/
            var token = this.getUrlParameter("token");
            // apiUrl = "/graphx/public_share/status?token=" + token ;
            authUrl = "/graphx/public_share/pusher/auth/"+vueGoInstance.companyId+"?token="+token;
        } else {
            authUrl = "/graphx/pusher/auth";
        }
        pusher = new Pusher(pusher_key, {
            authEndpoint: authUrl,
            auth: {
                headers: {
                    'X-CSRF-Token': $('meta[name="_csrf"]').attr("content")
                }
            },
            cluster: pusher_cluster
        });
    }

	var cid;
	if(vueGoInstance.isPublicLinkUrl) {
		cid = vueGoInstance.companyId;
	} else {
		cid = loggedInUser.loggedInUserCompany.company.id;
	}
	puhser_channel = pusher.subscribe('private-'+cid);

    puhser_channel.bind('client-mouse_event', function (dataObject) {
        decrypt3(dataObject, "mypass", (success, decData) => {
            if (success) {
                onReceivePush(JSON.parse(decData));
            }
        });
    });
}

function sendSocketRequest(requestData) {
	
	let isLocalDeployment = $('meta[name="isLocalDeployment"]').attr("content") == "true";
	if (isLocalDeployment) {
		return;
	}
	
  requestData.synId = synId;
  requestData.boardId = vueGoInstance.boardId;
  requestData.event_type = "client-mouse_event"

  var strData = JSON.stringify(requestData);
    encrypt3(strData,"mypass", (success, newdata) => {
        if (success) {
            puhser_channel.trigger("client-mouse_event",  newdata);
        }
    });
}

function onReceivePush(data) {

    // if (!data) {
    //     return;
    // }
    // data = JSON.parse(dataObject);

    board.skipsUndoManager = true;
    if (data.synId && data.synId != synId && data.boardId === vueGoInstance.boardId) {
        if (data.eventType === "mouseTrack") {
            vueGoInstance.mouseReceiveSocketReqCount++;
        } else {
            vueGoInstance.activityReceiveSocketReqCount++;
        }
        if (!data.itemList) {
            data.itemList = [];
        }
        if (data.category === "link") {
            
            board.model.startTransaction(null);
            try {
                
                if (data.eventType === "linkCreated") {
                    board.model.addLinkDataCollection(data.itemList)
                }
                if (data.eventType === "linkPropertyChange") {
                    data.itemList.forEach(link => {
                        var target = board.model.findLinkDataForKey(link.key);
                        var properties = _.keys(link);
                        properties.forEach(property => {
                            if (property !== "key" && property !== "category" && property !== "_id") {
                                board.model.setDataProperty(target, property, link[property])
                            }
                        })
                    });
                }
                if (data.eventType === "linkDeletion") {
                    data.itemList.forEach(link => {
                        var item = board.findLinkForKey(link.key);
                        if (item !== null) {
                            board.remove(item);
                        }
                    });
                }
                if ("boardVersion" in data) {
                    incrementSelfBoardVersion();
                    checkBoardCurrentVersion(data.boardVersion);
                }

            } catch (error) {
                
            }
            board.model.commitTransaction(null);
        }
        if (data.eventType === "mouseTrack" && vueGoInstance.boardDetail.isCollaboratorsCursor) {
            if (getItemLiveStreamMap("cursor" + data.cursorKey) == null) {
                
                board.model.startTransaction(null);
                try {
                    var node = getItemLiveStreamMap("cursor" + data.cursorKey);
                    if (node == null) {
                        board.model.addNodeData({
                            "category": "CURSOR",
                            "key": data.cursorKey,
                            "loc": data.cursorLocation,
                            "text": data.text,
                            "fill": data.color,
                            "lock": false,
                            "visible": true
                        });
                        node = board.findNodeForKey(data.cursorKey);
                        setItemLiveStreamMap("cursor" + data.cursorKey, node);
                    }else {
                        board.model.setDataProperty(node.data, "loc", data.cursorLocation);
                    }
                } catch (error) {
                }
                board.model.commitTransaction(null);
            } else {

                board.model.startTransaction(null);
                try {

                    var mNode = getItemLiveStreamMap("cursor" + data.cursorKey);
                    if (!_.isEmpty(mNode)) {

                        var mNodeData = mNode.data;
                        // board.model.setDataProperty(mNodeData, "loc", data.cursorLocation);

                        var newLocationPoint = go.Point.parse(data.cursorLocation);

                        var animation = new go.Animation();
                        animation.add(mNode, "location", mNode.location , newLocationPoint);
                        animation.duration = 500;
                        animation.start();
                    }

                    mouseTimeOut(data.cursorKey);
                } catch (error) {

                }
                board.model.commitTransaction(null);
            }
        }
        if (data.category === "node") {

            board.startTransaction(null);

            try {
                // dargLock event is only use for lock drag selection nodes
                if (data.eventType === "dragLock" && data.draggingNodes) {
                    data.draggingNodes.forEach(node => {
                        var mNode = getItemLiveStreamMap(node.key, true);
                        if (!_.isEmpty(mNode)) {
                            var mNodeData = mNode.data;
                            var lockByLocation = go.Point.stringify(go.Point.parse(mNodeData.loc).add(go.Point.parse(mNodeData.size)));
                            var overlayKey = "overlay" + mNode.key;

                            lockNode(mNode, data.lockBy, data.cursorKey, lockByLocation, mNodeData.loc, mNodeData.size, overlayKey, mNodeData, mNodeData.scale);
                        }
                    });
                }
                // if (data.eventType === "mouseDragMove") {
                //     setTargetNode(data.key)
                //     var node = board.findNodeForKey(data.key)
                //     board.model.setDataProperty(liveStreamMap.get("target"), "loc", go.Point.stringify(new go.Point(data.x, data.y)))
                //     board.model.setDataProperty(liveStreamMap.get("cursorNode"), "loc", data.cursorLocation)
                //     lockNode(node, data.lockBy, data.cursorKey, data.lockLocation, data.overlayLocation, data.overlaySize, liveStreamMap.get("target"))
                // }
                if (data.eventType === "changeProperty") {
                    data.itemList.forEach(node => {
                        var _node = board.findNodeForKey(node.key);
                        if (_node) {

                            var target = _node.data;

                            var properties = _.keys(node);
                            properties.forEach(property => {
                                if (property !== "key" && property !== "category" && property !== "_id") {
                                    board.model.setDataProperty(target, property, node[property]);
                                }
                            });
                            //...... exclusive work for note and text
                            if (node.category === "NOTE" && node["textSize"]) {
                                board.model.updateTargetBindings(target);
                            }
                            if (node["textAlignment"] || node["textFont"]) {
                                board.model.updateTargetBindings(target);
                            }
                            //...... exclusive work for frame
                            if (node.category === "FRAME" && (
                                ("showHeader" in node) || node["textSize"] || node["layout"] || node["rows"] || node["columns"] || node["loc"])) {
                                updateFrameLayout(_node);
                            }
                            //......  exclusive work for lock
                            if ("lock" in node) {
                                updateNodeSelectionOnLockChange(_node);
                            }
                            unLockNode(node);
                        }
                    });
                    if ("boardVersion" in data) {
                        incrementSelfBoardVersion();
                        checkBoardCurrentVersion(data.boardVersion);
                    }
                }
                if (data.eventType === "shapeCreated") {
                    board.model.addNodeDataCollection(data.itemList);
                    if ("boardVersion" in data) {
                        incrementSelfBoardVersion();
                        checkBoardCurrentVersion(data.boardVersion);
                    }
                }
                if (data.eventType === "deleteNode") {
                    data.itemList.forEach(node => {
                        var item = board.findNodeForKey(node.key);
                        if (item !== null) {
                            if (!data.removeContent && item.data && item.data.category === "FRAME") {
                                var ok = board.commandHandler.addTopLevelParts(item.memberParts, true);
                            }
                            board.remove(item);
                        }
                    });
                    if ("boardVersion" in data) {
                        incrementSelfBoardVersion();
                        checkBoardCurrentVersion(data.boardVersion);
                    }
                }
                if (data.eventType === "focusOnNode") {
                    var node = board.findNodeForKey(data.key);
                    focusOnNode(node);
                }
                // if (data.eventType === "frameMove") {
                //     setTargetNode(data.key)
                //     var node = board.findNodeForKey(data.key)
                //     var node = board.findNodeForKey(data.key);
                //     node.move(new go.Point(data.position.G, data.position.H)),
                //         board.model.setDataProperty(liveStreamMap.get("cursorNode"), "loc", data.cursorLocation)
                //     lockNode(node, data.lockBy, data.cursorKey, data.lockLocation, data.overlayLocation, data.overlaySize, liveStreamMap.get("target"))
                // }

            } catch (error) {

            }

            board.commitTransaction(null);
        }
        if (data.category === "lock" && data.key) {

            board.startTransaction(null);

            try {
                if (data.eventType === "enable") {
                    if (data.link) {
                        
                        var mNode = getItemLiveStreamMap(data.key, false);
                        if (!_.isEmpty(mNode)) {
                            var mNodeData = mNode.data;
                            var overlayKey = "overlay" + mNode.key;

                            lockNode(mNode, data.lockBy, data.cursorKey, data.lockLocation, data.overlayLocation, data.overlaySize, overlayKey, mNodeData, mNodeData.scale);
                        }

                    } else {

                        var mNode = getItemLiveStreamMap(data.key, true);
                        if (!_.isEmpty(mNode)) {
                            var mNodeData = mNode.data;
                            var overlayKey = "overlay" + mNode.key;

                            lockNode(mNode, data.lockBy, data.cursorKey, data.lockLocation, data.overlayLocation, data.overlaySize, overlayKey, mNodeData, mNodeData.scale);
                        }
                    }
                }
                if (data.eventType === "disable") {
                    if (data.lockNodes) {
                        data.lockNodes.forEach(node => {
                            unLockNode(node);
                        })
                    } else if (data.streamingNodes) {
                        data.streamingNodes.forEach(node => {
                            unLockNode(node.key);
                        })
                    } else {
                        unLockNode(data.key);
                    }
                }

            } catch (error) {

            }

            board.commitTransaction(null);
        }
        if (data.category === "note") {

            board.startTransaction(null);
            try {
                if (data.eventType === "saveNote") {
                    vueGoInstance.$children[1].$children[0].$parent.activeText = data.changes;
                }
                if (data.eventType === "addNoteActiveUser") {

                    if (vueGoInstance.boardActiveUsers.length > 0) {
                        var user = _.find(vueGoInstance.boardActiveUsers, { id: data.userId });

                        if (!user) {
                            vueGoInstance.boardActiveUsers.push(data.user[data.userId]);
                        }

                    } else {
                        vueGoInstance.boardActiveUsers.push(data.user[data.userId]);
                    }

                    if (vueGoInstance.boardActiveUsers) {

                        var currentTime = new Date();
                        var diff = 0;

                        _.each(vueGoInstance.boardActiveUsers, activeUser => {
                            activeUser.noteLastActiveTime = currentTime;
                            activeUser.noteActiveUserStatus = true;
                        });
                    }
                }
                if (data.eventType === "removeNoteActiveUser") {
                    //const index = vueGoInstance.boardActiveUsers.indexOf(data.user);
                    //	if (index > 0) {
                    _.each(vueGoInstance.boardActiveUsers, activeUser => {
                        //	activeUser.noteLastActiveTime = currentTime;
                        if (activeUser.id == data.user.id) {
                            activeUser.noteActiveUserStatus = false;
                        }
                    });
                    //					}
                }

            } catch (error) {

            }
            board.commitTransaction(null);
        }
        if (data.category === "user") {

            board.startTransaction(null);
            try {
                if (data.eventType === "addActiveUser") {
                    if (vueGoInstance.boardActiveUsers.length > 0) {
	 					var user = _.find(vueGoInstance.boardActiveUsers, { id: data.userId });
						if(!user && vueGoInstance.isPublicLinkUrl) {
                            addUserInActiveUsersList(data.user[data.userId]);
							// vueGoInstance.boardActiveUsers.push(data.user[data.userId]);
						} else {
	                        if (!user && loggedInUser.id != data.userId) {
                                addUserInActiveUsersList(data.user[data.userId]);
	                            // vueGoInstance.boardActiveUsers.push(data.user[data.userId]);
	                        }
						}
                    } else {
						if(vueGoInstance.isPublicLinkUrl) {
                            addUserInActiveUsersList(data.user[data.userId]);
                            // vueGoInstance.boardActiveUsers.push(data.user[data.userId]);
						}
                        if (loggedInUser.id != data.userId) {
                            addUserInActiveUsersList(data.user[data.userId]);
                            // vueGoInstance.boardActiveUsers.push(data.user[data.userId]);
                        }
                    }
                    function addUserInActiveUsersList (user) {
                        var find = _.find(vueGoInstance.boardActiveUsers,{id:user.id});
                        if (!find) {
                            vueGoInstance.boardActiveUsers.push(user);
                        }
                    }

                    if (vueGoInstance.boardActiveUsers) {
                        var diff = 0;
                        _.each(vueGoInstance.boardActiveUsers, activeUser => {

                            var currentTime = new Date();

                            //var lastActiveTime = new Date(data.user[data.userId].lastActive);
                            //activeUser.lastActive = data.user[data.userId].lastActive;
                            activeUser.lastActive = currentTime;
                            var lastActiveTime = activeUser.lastActive;

                            diff = currentTime.getTime() - lastActiveTime.getTime();
                            // console.log(diff);
                            /*if(diff > 50000) {
                                activeUser.isOnline = false;
                                var index = _.findIndex(vueGoInstance.boardActiveUsers,{id: activeUser.user.id});
                                //const index = vueGoInstance.boardActiveUsers.indexOf(activeUser);
                                if (index < 0) {
                                    vueGoInstance.boardActiveUsers.splice(index, 1)
                                }
                            }*/
                        });

                    }
                }

            } catch (error) {

            }
            board.commitTransaction(null);
        }
        if (data.category === "shareBoard") {

            board.startTransaction(null);
            try {
                if (data.eventType === "deleteCollaborator") {
                    vueGoInstance.boardDetail.board.collaborators = data.collaboratorsList;
                }
            } catch (error) {

            }
            board.commitTransaction(null);
        }
        if (data.category === "changeViewPort" && data.boardId === vueGoInstance.boardId) {

            board.startTransaction(null);
            try {

                if (data.eventType == "broadcast") {
                    if (data.broadcast) {
                        vueGoInstance.attentionManagement.following = true;
                        vueGoInstance.attentionManagement.broadcast = false;
                        vueGoInstance.attentionManagement.followName = data.followName;
                        showTopMessage("you are here by" + data.followName)
                        var callback = {
                            "category": "changeViewPort",
                            "eventType": "callbackUserID",
                            "boardId": vueGoInstance.boardId,
                            "userId": loggedInUser.id
                        }
                        sendSocketRequest(callback);
                    }
                    if (vueGoInstance.attentionManagement.following) {

                        board.startTransaction(null);
                        changeViewPort(data.scale, data.position);
                        board.commitTransaction(null);
                    }
                    //>>>>>>> 7ffdcf45d5afa9a4fe51eeb893bee439aae8ebe7
                }
                if (data.eventType == "callbackUserID") {
                    vueGoInstance.attentionManagement.followingList.push(data.userId);
                }
                if (data.eventType == "unfollow") {
                    const index = vueGoInstance.attentionManagement.followingList.indexOf(data.userId);
                    if (index > -1) {
                        vueGoInstance.attentionManagement.followingList.splice(index, 1);
                    }
                    if (vueGoInstance.attentionManagement.followingList.length < 1) {
                        vueGoInstance.attentionManagement.broadcast = false;
                    }
                }
                if (data.eventType == "follow" && data.leaderId === loggedInUser.id) {
                    vueGoInstance.attentionManagement.broadcast = true;
                    vueGoInstance.attentionManagement.following = false;
                    vueGoInstance.attentionManagement.followingList.push(data.followerId);
                    var reqData = {
                        "category": "changeViewPort",
                        "eventType": "broadcast",
                        "position": go.Point.stringify(board.position),
                        "scale": board.scale,
                        "boardId": vueGoInstance.boardId
                    }
                    sendSocketRequest(reqData)
                }

            } catch (error) {

            }
            board.commitTransaction(null);
        }
    }
    board.skipsUndoManager = false;
}

//....................................................
function updateFrameLayout (frame) {
    setTimeout(function () {
        if (frame.layout) {
            frame.layout.isValidLayout = false;
        }
        board.layoutDiagram();
    }, 200);
}
function updateNodeSelectionOnLockChange (node) {
    if (node.isSelected) {
        // node.isSelected = false;
        board.raiseDiagramEvent("ChangingSelection", board.selection);
        showNodeEditingMenu();
    }
}
function removeCursorNode(cursorKey){
    var mouseNode = board.findNodeForKey(cursorKey);
    if (mouseNode !== null) {
        board.skipsUndoManager = true;
        board.startTransaction(null)
        board.remove(mouseNode);
        board.commitTransaction(null)
        board.skipsUndoManager = false;
        setItemLiveStreamMap("cursor"+cursorKey, null)
    }
}

function calculateRectangleSize(points){

    if (_.isString(points)) {
        var ps = JSON.parse(points);
        points = new go.List();
        _.each(ps, p => {points.add(go.Point.parse(p));});
    }

    var x1 = points.first().x
    var y1 = points.first().y

    var x2 = points.first().x
    var y2 = points.last().y

    var x3 = points.last().x
    var y3 = points.last().y

   var length =  Math.sqrt(Math.pow(x2-x1, 2) + Math.pow(y2-y1, 2));
   var width =  Math.sqrt(Math.pow(x3-x2, 2) + Math.pow(y3-y2, 2));
   var size = go.Point.stringify(new go.Point(width, length))
   return size;
}
function changeViewPort(scale, position){
    var anim = new go.Animation();
    anim.easing = go.Animation.EaseLinear;
    anim.add(board, "scale", board.scale, scale);
    anim.add(board, "position", board.position, go.Point.parse(position));
    anim.start();
    board.position = go.Point.parse(position)
    board.scale = scale
}
function previewOverlayCalculation(size, loc){
    board.startTransaction(BOARD_TRNS_BOARD_PREVIEW)
    var previewLoc =loc;
    var previewSize = size;
    var viewportBounds = board.viewportBounds;
    var documentBounds = board.documentBounds;

    // update left preview size and location
    var previewLeft = board.model.findNodeDataForKey("previewLeft");
    var leftNodeWidth = Math.sqrt(Math.pow(previewLoc.x - viewportBounds.x,2));
    if(previewLoc.x < viewportBounds.x && previewLeft.visible ){
        board.model.setDataProperty(previewLeft, "visible", false)
    }
    if(previewLoc.x > viewportBounds.x && !previewLeft.visible) {
        board.model.setDataProperty(previewLeft, "visible", true)
    }
    board.model.setDataProperty(previewLeft, "loc", go.Point.stringify(viewportBounds.position));
    board.model.setDataProperty(previewLeft, "size", go.Size.stringify(new go.Size(leftNodeWidth, viewportBounds.size.height)));

    // update Right preview size and location
    var previewRight = board.model.findNodeDataForKey("previewRight");
    board.model.setDataProperty(previewRight, "loc",go.Point.stringify(new go.Point(previewLoc.x + previewSize.width, viewportBounds.y)));
    board.model.setDataProperty(previewRight, "size", go.Size.stringify(new go.Size(documentBounds.size.width, viewportBounds.size.height )));

    // Update Top preview size and location
    var previewTop = board.model.findNodeDataForKey("previewTop");
    if(previewLoc.y < viewportBounds.y && previewTop.visible ){
        board.model.setDataProperty(previewTop, "visible", false)
    }
    if(previewLoc.y > viewportBounds.y && !previewTop.visible) {
        board.model.setDataProperty(previewTop, "visible", true)
    }
    var topNodeHeight = Math.sqrt(Math.pow(viewportBounds.position.y - previewLoc.y, 2));
    board.model.setDataProperty(previewTop, "loc", go.Point.stringify(new go.Point(previewLoc.x, viewportBounds.y)));
    board.model.setDataProperty(previewTop, "size", go.Size.stringify(new go.Size(previewSize.width, topNodeHeight )));

    //Update Bottom preview size and location
    var previewBottom = board.model.findNodeDataForKey("previewBottom");
    board.model.setDataProperty(previewBottom, "loc", go.Point.stringify(new go.Point(previewLoc.x, previewLoc.y + previewSize.height)));
    board.model.setDataProperty(previewBottom, "size", go.Size.stringify(new go.Size(previewSize.width, documentBounds.height )));

    // console.log(e)
    board.commitTransaction(BOARD_TRNS_BOARD_PREVIEW)
}

var lockedPartsMap = {};
var autoUnlockTimer;

function startAutoUnlockTimer(){
    triggerAutoUnlockTimer ();
}
function triggerAutoUnlockTimer () 
{
    var expireLockTime = 20;

    var keys = Object.keys(lockedPartsMap);
    var currentTime = (new Date()).getTime();
    _.each(keys, key=> {
        var entry = lockedPartsMap[key];
        if (currentTime - entry.time > (expireLockTime * 1000) ) {
            board.skipsUndoManager = true;
            board.commit(function () {
                unLockNode(key);
            },null);
            board.skipsUndoManager = false;
        }
    });
    if (!_.isEmpty(lockedPartsMap)) {
        clearTimeout(autoUnlockTimer);
        autoUnlockTimer = setTimeout(function () {
            triggerAutoUnlockTimer();
        }, 5000);
    }
}

function lockNode(object, lockBy, cursorKey, lockLocation, overlayLocation, overlaySize, overlayKey, target, scale){

    //...............
    var lockedPartsMapEntry = {
        time: (new Date()).getTime(),
        lockBy: lockBy,
        key: object.key
    };
    lockedPartsMap[object.key] = lockedPartsMapEntry;
    startAutoUnlockTimer();
    //...............

    var lockOverlay = liveStreamMap.get(overlayKey);
    var lockShape   = liveStreamMap.get("lockedBy");
    
    if(object) { object.isSelected = false; }
    
    board.model.setDataProperty(target,"isEditable", false);
    board.model.setDataProperty(target,"lockBy", lockBy);
    
    if(cursorKey) 
        removeCursorNode(cursorKey);
    
    if(lockOverlay) {
        board.model.setDataProperty(lockOverlay.data, "loc", overlayLocation);
        board.model.setDataProperty(lockOverlay.data, "size", overlaySize);
        board.model.setDataProperty(lockOverlay.data, "scale", scale);
    } else {
        var data = {
            "category": "LOCKOVERLAY", "key": overlayKey,
            "loc": overlayLocation, "size": overlaySize, "lock": false, "scale": scale
        };
        board.model.commit(()=>{
            board.model.addNodeData(data);
        },null);
        var node = board.findNodeForData(data);
        liveStreamMap.set(overlayKey, node);
    }
    if(lockShape){
        board.model.setDataProperty(lockShape, "loc", lockLocation)
    }
    else {

        var data = {
            "category": "LOCKEDBYOVERLAY", "key": "lockedBy",
            "loc": lockLocation, "text": lockBy, "fill": "#d27c2c", "lock": false
        };
        board.model.addNodeData();
        var node = board.findNodeForData(data);
        liveStreamMap.set("lockedBy", node);
    }
}
function unLockNode(key) {

    var overlay     = "overlay"+key;
    var lockOverlay = liveStreamMap.get(overlay);

    if (!_.isEmpty(lockOverlay)) {

        var node            = getItemLiveStreamMap(key, true);
        var lockedByOverlay = getItemLiveStreamMap("lockedBy", true);
        
        board.startTransaction(null);
    
        if (node != null) {
            board.model.setDataProperty(node.data ,"isEditable", true);
        }
        
        if(lockOverlay ) {
            board.remove(lockOverlay);
        }
        if(lockedByOverlay) {
            board.remove(lockedByOverlay);
        }
        board.commitTransaction(null);
        
        setItemLiveStreamMap("target", null)
        setItemLiveStreamMap(overlay, null);
        setItemLiveStreamMap(key, null);
        setItemLiveStreamMap("lockedBy", null);
    }

    //...............
    if (lockedPartsMap[key]) {
        delete lockedPartsMap[key];
    }
    //...............
}

//....................................................
function onConnectionRestored () {
    vueGoInstance.onConnectionRestored();
}

//...................................................
function setStompClientState(){
    /*isStompClientConnected = stompClient.connected;
    if(!isStompClientConnected){
        board.isReadOnly = true;
        showTopMessage("connection lost", 'warning')
    }*/
}

var pusherScheduler;
function initializeCollabPusher() {
    window.addEventListener('load',resetPusherConnection)
    document.addEventListener('load', resetPusherConnection);
    document.addEventListener('mousemove', resetPusherConnection);
    document.addEventListener('mousedown', resetPusherConnection);
    document.addEventListener('touchstart', resetPusherConnection);
    document.addEventListener('click', resetPusherConnection);
    document.addEventListener('keypress', resetPusherConnection);
    document.addEventListener('scroll', resetPusherConnection);
    resetPusherConnection()
};

function disconnectPusher() {
    pusher.disconnect();
}

function clearTimeoutPusherScheduler () {
    clearTimeout(pusherScheduler);
}

function resetPusherConnectionTimeout () {
    disconnectPusher();
    vueGoInstance.onConnectionLost();
}

function resetPusherConnection() {
	let isLocalDeployment = $('meta[name="isLocalDeployment"]').attr("content") == "true";
	if (isLocalDeployment) {
		return;
	}
    if(pusher.connection.state === "disconnected") {
        pusher.connect();
        checkConnectionStatus((success) => {
            if (success) {
                vueGoInstance.boardDetail.board.locked = true;
                onConnectionRestored();
                showTopMessage("Connection Restored", "success");
            } else {
                
            }
        });
    }
    clearTimeoutPusherScheduler();
    pusherScheduler = setTimeout(resetPusherConnectionTimeout, 300000)
}
function removePusherSchedulerEvents(){
    window.removeEventListener('load', resetPusherConnection)
    document.removeEventListener('load', resetPusherConnection);
    document.removeEventListener('mousemove', resetPusherConnection);
    document.removeEventListener('mousedown', resetPusherConnection);
    document.removeEventListener('touchstart', resetPusherConnection);
    document.removeEventListener('click', resetPusherConnection);
    document.removeEventListener('keypress', resetPusherConnection);
    document.removeEventListener('scroll', resetPusherConnection);
}
var cursorLocation = "";
pusherTimer();   
//scheduler to send push request for live stream of dragging nodes

function pusherTimer() {
    if (pushDataMap.get("mouseTrack")) {
        if (cursorLocation !== pushDataMap.get("mouseTrack").cursorLocation) {
            cursorLocation = pushDataMap.get("mouseTrack").cursorLocation;
            sendSocketRequest(pushDataMap.get("mouseTrack"));
        }
    }
    setTimeout(pusherTimer, '500');
}

//.........  public methods
function clearPusher () {
    removePusherSchedulerEvents();
	clearTimeoutPusherScheduler();
	disconnectPusher();
}

//......... public methods
function pushPointerLocation(points, userId, userFirstName,backgroundColor ){
    var mousePushData = {
        "cursorKey": userId, "eventType": "mouseTrack", "text": userFirstName,
        "cursorLocation": go.Point.stringify(points), "color": backgroundColor
    };
    pushDataMap.set("mouseTrack", mousePushData);
}
function pushViewPortBroadcast(scale, position, boardId){
    var reqData = {
        "category": "changeViewPort", "eventType": "broadcast", "position": go.Point.stringify(position),
        "scale": scale, "boardId": boardId
    }
    sendSocketRequest(reqData);
}

//.....................
function pushUnlockNodes(lockNodes, userFirstName){
    var nodeUnlockData = { "streamingNodes": lockNodes, "key": "unlock", "category": "lock", "eventType": "disable", "lockBy": userFirstName };
    sendSocketRequest(nodeUnlockData);
}
function pushDragLock(lockNodes, userId, userFirstName){
    var reqData = {
        "eventType": "dragLock", "category": "node",
        "cursorKey": userId, "lockBy": userFirstName,
        "draggingNodes": lockNodes
    };
    sendSocketRequest(reqData);
}
function pushLockResizingNode(key, lockByLocation, userId, userFirstName, loc, size){
    var reqData = {
        "key": key, "category": "lock", "eventType": "enable", "lockBy": userFirstName,
        "lockLocation": lockByLocation, "cursorKey": userId,
        "overlayLocation": loc, "overlaySize": size
    };
    sendSocketRequest(reqData);
}
function pushUnlockResizedNode(key, userFirstName){
    var reqData = { "key": key, "category": "lock", "eventType": "disable", "lockBy": userFirstName };
    sendSocketRequest(reqData);
}

//.....................
function pushLinkTextEditLock(part, key,userId, userFirstName){
    var lockByLocation;
    var overlaySize = calculateRectangleSize(part.data.points);
    var overlayLocation;

    var ps = JSON.parse(part.data.points);
    var points = new go.List();
    _.each(ps, p => { points.add(go.Point.parse(p)); });

    var x1 = points.first().x;
    var y1 = points.first().y;
    var x2 = points.last().x;
    var y2 = points.last().y;

    if (y1 > y2 && x1 < x2) {
        overlayLocation = go.Point.stringify(new go.Point(x1, y2));
        lockByLocation = go.Point.stringify(new go.Point(x2, y1));
    }
    else if (y1 < y2 && x1 < x2) {
        overlayLocation = go.Point.stringify(part.data.points.first());
        lockByLocation = go.Point.stringify(part.data.points.last());
    }
    else if (x1 > x2 && y1 < y2) {
        overlayLocation = go.Point.stringify(new go.Point(x2, y1));
        lockByLocation = go.Point.stringify(new go.Point(x1, y2));
    }
    else {
        overlayLocation = go.Point.stringify(part.data.points.last());
        lockByLocation = go.Point.stringify(part.data.points.first());
    }
    var reqData = {
        "key": key, "category": "lock", "eventType": "enable", "link": true,
        "lockBy": userFirstName, "lockLocation": lockByLocation, "cursorKey": userId,
        "overlayLocation": overlayLocation, "overlaySize": overlaySize
    };
    sendSocketRequest(reqData);
}
function pushNodeTextEditLock(part, userId, userFirstName){
    var lockByLocation = go.Point.stringify(go.Point.parse(part.data.loc).add(go.Point.parse(part.data.size)));
    var reqData = {
        "key": part.data.key, 
        "category": "lock", 
        "eventType": "enable",
        "lockBy": userFirstName, 
        "lockLocation": lockByLocation, 
        "cursorKey": userId,
        "overlayLocation": part.data.loc, 
        "overlaySize": part.data.size
    };
    sendSocketRequest(reqData);
}
function pushUnlockTextEdit(key, userFirstName){
    var reqData = { "key": key, "category": "lock", "eventType": "disable", "lockBy": userFirstName };
    sendSocketRequest(reqData);
}

//....................
function pushUpdateNodeProperty(nodes, boardVersion){
    
    var nodesStr = JSON.stringify(nodes);
    var sizeInKB = nodesStr.length * 2 / 1024;
    if (sizeInKB < 10) {
        var pushData = { "itemList": nodes, "eventType": "changeProperty", "category": "node" , boardVersion: boardVersion};
        sendSocketRequest(pushData);
    }
    else {
        var batches = Math.ceil(sizeInKB / 9);
        var pageSize = Math.ceil(nodes.length / batches);
        var startIndex = 0;
        for (var i=0 ; i < batches; i ++) {
            var _nodes = nodes.slice(startIndex, startIndex + pageSize);
            startIndex += pageSize;

            var pushData = { "itemList": _nodes, "eventType": "changeProperty", "category": "node" };
            sendSocketRequest(pushData);
            if (i==0) {
                pushData.boardVersion = boardVersion;
            }
        }
    }
}
function pushCreateNode(nodes, boardVersion){

    var nodesStr = JSON.stringify(nodes);
    var sizeInKB = nodesStr.length * 2 / 1024;
    if (sizeInKB < 10) {
        var reqData = { "itemList": nodes, "eventType": "shapeCreated", "category": "node", boardVersion: boardVersion};
        sendSocketRequest(reqData);
    }
    else {
        var batches = Math.ceil(sizeInKB / 9);
        var pageSize = Math.ceil(nodes.length / batches);
        var startIndex = 0;
        for (var i=0 ; i < batches; i ++) {
            var _nodes = nodes.slice(startIndex, startIndex + pageSize);
            startIndex += pageSize;

            var reqData = { "itemList": _nodes, "eventType": "shapeCreated", "category": "node"};
            sendSocketRequest(reqData);
            if (i==0) {
                reqData.boardVersion = boardVersion;
            }
        }
    }
}
function pushCreateLink(links, boardVersion){
    var reqData = { "itemList": links, "category": "link", "eventType": "linkCreated", boardVersion: boardVersion};
    sendSocketRequest(reqData);
}
function pushUpdateLinkProperty(changeLinkArray, boardVersion){
    var pushData = {
        "category": "link", "itemList": changeLinkArray,
        "eventType": "linkPropertyChange", boardVersion: boardVersion
    };
    sendSocketRequest(pushData);
}
function pushDeleteNode(nodes, boardVersion){

    var nodesStr = JSON.stringify(nodes);
    var sizeInKB = nodesStr.length * 2 / 1024;
    if (sizeInKB < 10) {
        var reqData = { "itemList": nodes, "eventType": "deleteNode", "category": "node", boardVersion: boardVersion, removeContent: removeFrameContentOnDelete};
        sendSocketRequest(reqData);
    }
    else {
        var batches = Math.ceil(sizeInKB / 9);
        var pageSize = Math.ceil(nodes.length / batches);
        var startIndex = 0;
        for (var i=0 ; i < batches; i ++) {
            var _nodes = nodes.slice(startIndex, startIndex + pageSize);
            startIndex += pageSize;

            var reqData = { "itemList": _nodes, "eventType": "deleteNode", "category": "node"};
            sendSocketRequest(reqData);
            if (i==0) {
                reqData.boardVersion = boardVersion;
            }
        }
    }
}
function pushDeleteLink(links, boardVersion){
    sendSocketRequest({ "itemList": links, "category": "link", "eventType": "linkDeletion" , boardVersion: boardVersion});
}