
//.......................................
var statusCheckTimer;
var statusCheckTimerTriggerTime = 60 * 1000;

function initializeCollabApi() {
  window.addEventListener('online', () => {
    checkConnectionStatus((success) => {
      if (success) {
        vueGoInstance.onConnectionRestored();
      } else {
        vueGoInstance.onConnectionLost();
      }
    });
  });
  window.addEventListener('offline', () => {
    checkConnectionStatus((success) => {
      if (success) {
        vueGoInstance.onConnectionRestored();
      } else {
        vueGoInstance.onConnectionLost();
      }
    });
  });

  //...... two minutes
  statusCheckTimer = setTimeout(onTriggerStatusCheckTimer, statusCheckTimerTriggerTime );
}

function clearCollabApi() {
  clearTimeout(statusCheckTimer);
}

//.........................................
function onTriggerStatusCheckTimer() {
  
  checkConnectionStatus((success) => {
    if (success) {
      vueGoInstance.onConnectionRestored();
    } else {
      vueGoInstance.onConnectionLost();
    }
  });
  clearTimeout(statusCheckTimer);
  statusCheckTimer = setTimeout(onTriggerStatusCheckTimer, statusCheckTimerTriggerTime);
}

//.........................................
function incrementSelfBoardVersion() {
  vueGoInstance.boardVersion++;
  console.log("version" + vueGoInstance.boardVersion);
}
function checkBoardCurrentVersion(version) {
  if (version !== vueGoInstance.boardVersion) {
    // reloadBoardDataOnFailure ();
  }
}

function reloadBoardDataOnFailure () {
  showTopMessage("State is not synced. Reload required","warning",-1);
  vueGoInstance.boardDetail.board.locked = true;
  vueGoInstance.onConnectionRestored();
}
//.........................................
function getNewUUID() {
  var d = new Date().getTime();
  var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
    var r = (d + Math.random() * 16) % 16 | 0;
    d = Math.floor(d / 16);
    return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
  });
  return uuid;
}
//.........................................

function updateNodeProperty(data) {

  data = _.filter(data, node=> {
    return validNodeTypesMap[node.category] ? true : false;
  });
  if (_.isEmpty(data)) {
    return;
  }

  var index = 0;
  if (vueGoInstance.isPublicLinkUrl) {
  }
  else {
    /*index = _.findIndex(vueGoInstance.boardDetail.board.collaborators, collab => {
      return collab.user.id == loggedInUser.id;
    });*/
  }

  if (index > -1 || vueGoInstance.isPublicLinkUrl) {
    var requestBody = _.cloneDeep(data);
    vueGoInstance.boardDetail.savingAnimation = true;

    var apiUrl;
    if (vueGoInstance.isPublicLinkUrl) {
	 	var token = this.getUrlParameter("token");
      	apiUrl = "/graphx/public_share/node/update/" + vueGoInstance.tenant + '/' + vueGoInstance.boardDetail.board.id + '/' + vueGoInstance.anonymousUser.name + "?token="+token;
    } else {
      	apiUrl = "/graphx/node/update/" + vueGoInstance.boardDetail.board.id;
    }

    axios.post(apiUrl, requestBody)
      .then(response => {
        vueGoInstance.boardDetail.savingAnimation = false;
        if (response.data.success) {

          incrementSelfBoardVersion();
          checkBoardCurrentVersion(response.data.boardVersion);

          hideTopMessage();
          vueGoInstance.boardDetail.errorWhileSaving = false;
		  vueGoInstance.showOrHideCloudSuccessIcon();
          pushUpdateNodeProperty(requestBody, response.data.boardVersion);
        } else {
          showTopMessage('Your changes are not saved.', 'warning', -1);
          vueGoInstance.boardDetail.errorWhileSaving = true;
        }
      })
      .catch(error => {
        // showTopMessage('Your changes are not saved.', 'warning', -1);
        vueGoInstance.boardDetail.savingAnimation = false;
        vueGoInstance.boardDetail.errorWhileSaving = true;
        reloadBoardDataOnFailure ();
      });
  } else {
    showTopMessage('You dont have access to this board');
    window.location.reload();
  }
}
function getUrlParameter (sParam) {
    var sPageURL = decodeURIComponent(window.location.search.substring(1)),
        sURLVariables = sPageURL.split('&'),
        sParameterName,
        i;

    for (i = 0; i < sURLVariables.length; i++) {
        sParameterName = sURLVariables[i].split('=');

        if (sParameterName[0] === sParam) {
            return sParameterName[1] === undefined ? true : sParameterName[1];
        }
    }
}

var validNodeTypesMap = {
  "TEXT":true,
  "NOTE":true,
  "SHAPE":true,
  "FreehandDrawing":true,
  "FRAME":true,
  "PICTURE":true,
}

function createNode(nodeList) {

  nodeList = _.filter(nodeList, node=> {
    return validNodeTypesMap[node.category] ? true : false;
  });
  if (_.isEmpty(nodeList)) {
    return;
  }

  var index = 0;
  if (vueGoInstance.isPublicLinkUrl) {
    
  } else {
   /* index = _.findIndex(vueGoInstance.boardDetail.board.collaborators, collab => {
      return collab.user.id == loggedInUser.id;
    });*/
  }

  if (index > -1 || vueGoInstance.isPublicLinkUrl) {
    vueGoInstance.boardDetail.savingAnimation = true;
    nodeList.forEach(node => {
      if (node.category === "NOTE" && node.textSize == "Auto") {
        autoFontCheckOnEmptyNote(node);
      }
      node.boardId = vueGoInstance.boardId;
    })
    // data.boardId = vueGoInstance.boardId;
    // data.link = window.location.host + window.location.pathname + "#/detail/"+vueGoInstance.boardId + "/"+data.key;

    vueGoInstance.boardDetail.savingAnimation = true;

    var apiUrl;
    if (vueGoInstance.isPublicLinkUrl) {
	  var token = this.getUrlParameter("token");
      apiUrl = "/graphx/public_share/node/create/" + vueGoInstance.tenant + '/' + vueGoInstance.boardDetail.board.id + '/' + vueGoInstance.anonymousUser.name+"?token="+token;
    } else {
      apiUrl = "/graphx/node/create/" + vueGoInstance.boardDetail.board.id;
    }

    axios.post(apiUrl, nodeList)
      .then(response => {
        vueGoInstance.boardDetail.savingAnimation = false;

        if (response.data.success) {

          incrementSelfBoardVersion();
          checkBoardCurrentVersion(response.data.boardVersion);

          hideTopMessage();
          vueGoInstance.boardDetail.errorWhileSaving = false;

          var newNodes = [];
          response.data.nodeIdsList.forEach((nodeId, index) => {

            let rawKey = Object.keys(nodeId)[0];
            let key = /^-?\d+$/.test(rawKey) ? parseInt(rawKey) : rawKey;

            var node = board.findNodeForKey(key);
            var nodeData = node.data;

            board.startTransaction(null);
            board.model.setDataProperty(nodeData, "_id", nodeId[key])
            board.commitTransaction(null);

            newNodes.push(JSON.parse(JSON.stringify(nodeData)));
            if (nodeData.category && (nodeData.category === "SHAPE" || nodeData.category === "NOTE" || nodeData.category === "FRAME")) {
              vueGoInstance.onNodeCreate(nodeData);
            }
            if (checkForDropInFrameOnPasteMap[node.__gohashid]) {
              delete checkForDropInFrameOnPasteMap[node.__gohashid];
              handleNodeCreated(node);
            }
            // else {
            //   if (board.selection && response.data.nodeIdsList.length == 1) {
                setTimeout(function () {
                  if (node.data && (node.data.category === "FRAME" || node.data.category === "TEXT")) {

                  }
                  else {
                    if (index == response.data.nodeIdsList.length - 1) {
                      var textBlock = node.findObject("textBlock");
                      if (textBlock != null) {
                        board.commandHandler.editTextBlock(textBlock);
                      }
                    }
                  }
                }, 200);
            //   }
            //   //....
            // }
          });

		  vueGoInstance.showOrHideCloudSuccessIcon();
          pushCreateNode(newNodes, synId, response.data.boardVersion);
        } else {
          showTopMessage('Your changes are not saved.', 'warning', -1);
          vueGoInstance.boardDetail.errorWhileSaving = true;
        }
      })
      .catch(error => {
        // showTopMessage('Your changes are not saved.', 'warning', -1);
        vueGoInstance.boardDetail.savingAnimation = false;
        vueGoInstance.boardDetail.errorWhileSaving = true;
        reloadBoardDataOnFailure ();
      });

  } else {
    showTopMessage('You dont have access to this board');
    window.location.reload();
  }

}
function createLink(linksArray) {
  // if(data._id == undefined) {
  var index = 0;
  if (vueGoInstance.isPublicLinkUrl) {
    
  } else {
    /*index = _.findIndex(vueGoInstance.boardDetail.board.collaborators, collab => {
      return collab.user.id == loggedInUser.id;
    });*/
  }

  if (index > -1 || vueGoInstance.isPublicLinkUrl) {
    linksArray.forEach(link => {
      Vue.nextTick(function () {
        vueGoInstance.onNodeCreate(link);
      });
      link.boardId = vueGoInstance.boardId;
      link.key = getNewUUID();
      if (typeof link.points !== "string") {
        var points = [];
        link.points.each(p => {
          if (p) {
            points.push(go.Point.stringify(p));
          }
        });
        link.points = JSON.stringify(points);
      }
      board.model.updateTargetBindings(link);
    });
    vueGoInstance.boardDetail.savingAnimation = true;

    // data.points = data.points._dataArray
    var apiUrl;
    if (vueGoInstance.isPublicLinkUrl) {
		var token = this.getUrlParameter("token");
      	apiUrl = "/graphx/public_share/link/create/"+ vueGoInstance.tenant + '/'  + vueGoInstance.boardDetail.board.id + '/' + vueGoInstance.anonymousUser.name+"?token="+token;
    } else {
      apiUrl = "/graphx/link/create/" + vueGoInstance.boardDetail.board.id;
    }
    axios.post(apiUrl, linksArray)
      .then(response => {
        vueGoInstance.boardDetail.savingAnimation = false;
        if (response.data.success) {

          incrementSelfBoardVersion();
          checkBoardCurrentVersion(response.data.boardVersion);

          hideTopMessage();
          vueGoInstance.boardDetail.errorWhileSaving = false;
          var newLinks = [];
          response.data.linkIdsList.forEach(linkId => {
            let key = Object.keys(linkId)[0];

            // var target = board.model.findLinkDataForKey(key);
            var target = _.find(board.model.linkDataArray, { key: key });

            board.skipsUndoManager = true;
            board.model.setDataProperty(target, "_id", linkId[key]);
            board.skipsUndoManager = false;
            newLinks.push(target);
          });
		  vueGoInstance.showOrHideCloudSuccessIcon();
          pushCreateLink(newLinks, synId, response.data.boardVersion);
        }
        else {
          showTopMessage('Your changes are not saved.', 'warning', -1);
          vueGoInstance.boardDetail.errorWhileSaving = true;
        }
      })
      .catch(error => {
        // showTopMessage('Your changes are not saved.', 'warning', -1);
        vueGoInstance.boardDetail.savingAnimation = false;
        vueGoInstance.boardDetail.errorWhileSaving = true;
        reloadBoardDataOnFailure ();
      });
  } else {
    showTopMessage('You dont have access to this board');
    window.location.reload();
  }
  // }
}
function updateLinkProperty(changeLinkArray) {
  // if(data._id) {
  var index = 0;
  if (vueGoInstance.isPublicLinkUrl) {

  }
  else {
   /* index = _.findIndex(vueGoInstance.boardDetail.board.collaborators, collab => {
      return collab.user.id == loggedInUser.id;
    });*/
  }

  if (index > -1 || vueGoInstance.isPublicLinkUrl) {

    vueGoInstance.boardDetail.savingAnimation = true;

    var apiUrl;
    if (vueGoInstance.isPublicLinkUrl) {
		var token = this.getUrlParameter("token");
      	apiUrl = "/graphx/public_share/link/update/"+ vueGoInstance.tenant + '/'  + vueGoInstance.boardDetail.board.id + '/' + vueGoInstance.anonymousUser.name+"?token="+token;
    } else {
      	apiUrl = "/graphx/link/update/" + vueGoInstance.boardDetail.board.id;
    }

    axios.post(apiUrl, changeLinkArray)
      .then(response => {
        vueGoInstance.boardDetail.savingAnimation = false;
        if (response.data.success) {

          incrementSelfBoardVersion();
          checkBoardCurrentVersion(response.data.boardVersion);

          hideTopMessage();
          vueGoInstance.boardDetail.errorWhileSaving = false;
		  vueGoInstance.showOrHideCloudSuccessIcon();
          pushUpdateLinkProperty(changeLinkArray, response.data.boardVersion);
        } else {
          showTopMessage('Your changes are not saved.', 'warning', -1);
          vueGoInstance.boardDetail.errorWhileSaving = true;
        }
      })
      .catch(error => {
        // showTopMessage('Your changes are not saved.', 'warning', -1);
        vueGoInstance.boardDetail.savingAnimation = false;
        vueGoInstance.boardDetail.errorWhileSaving = true;
        reloadBoardDataOnFailure ();
      });
  } else {
    showTopMessage('You dont have access to this board');
    window.location.reload();
  }
  // }
}
function deleteNode(nodeList) {

  var index = 0;
  if (vueGoInstance.isPublicLinkUrl) {

  }
  else {
    /*index = _.findIndex(vueGoInstance.boardDetail.board.collaborators, collab => {
      return collab.user.id == loggedInUser.id;
    });*/
  }

  if (index > -1 || vueGoInstance.isPublicLinkUrl) {

    vueGoInstance.boardDetail.savingAnimation = true;

    var apiUrl;
    if (vueGoInstance.isPublicLinkUrl) {
		var token = this.getUrlParameter("token");
      	apiUrl = "/graphx/public_share/delete/node/"+ vueGoInstance.tenant + '/'  + vueGoInstance.boardDetail.board.id + '/' + vueGoInstance.anonymousUser.name+"?token="+token;
    } else {
      apiUrl = "/graphx/delete/node/" + vueGoInstance.boardDetail.board.id;
    }

    axios.delete(apiUrl, { data: nodeList })
      .then(response => {

        vueGoInstance.boardDetail.savingAnimation = false;

        if (response.data && response.data.success && response.data.itemRemoved > 0) {

          incrementSelfBoardVersion();
          checkBoardCurrentVersion(response.data.boardVersion);

          hideTopMessage();
          vueGoInstance.boardDetail.errorWhileSaving = false;
		      vueGoInstance.showOrHideCloudSuccessIcon();
          pushDeleteNode(nodeList, response.data.boardVersion);
        }
        else {
          showTopMessage('Your changes are not saved.', 'warning', -1);
          vueGoInstance.boardDetail.errorWhileSaving = true;
        }
      })
      .catch(error => {
        // showTopMessage('Your changes are not saved.', 'warning', -1);
        vueGoInstance.boardDetail.savingAnimation = false;
        vueGoInstance.boardDetail.errorWhileSaving = true;
        reloadBoardDataOnFailure ();
      });
  } else {
    showTopMessage('You dont have access to this board');
    window.location.reload();
  }

}
function deleteLink(links) {

  var index = 0;
  if (vueGoInstance.isPublicLinkUrl) {

  }
  else {
    /*index = _.findIndex(vueGoInstance.boardDetail.board.collaborators, collab => {
      return collab.user.id == loggedInUser.id;
    });*/
  }
	
  if (index > -1 || vueGoInstance.isPublicLinkUrl) {

    vueGoInstance.boardDetail.savingAnimation = true;

    var apiUrl;
    if (vueGoInstance.isPublicLinkUrl) {
		var token = this.getUrlParameter("token");
      	apiUrl = "/graphx/public_share/delete/link/"+ vueGoInstance.tenant + '/'  + vueGoInstance.boardDetail.board.id + '/' + vueGoInstance.anonymousUser.name + "?token="+token;
    } else {
      	apiUrl = "/graphx/delete/link/" + vueGoInstance.boardDetail.board.id;
    }

    axios.delete(apiUrl, { data: links })
      .then(response => {

        vueGoInstance.boardDetail.savingAnimation = false;
        if (response.data && response.data.success && response.data.itemRemoved > 0) {

          incrementSelfBoardVersion();
          checkBoardCurrentVersion(response.data.boardVersion);

          hideTopMessage();
          vueGoInstance.boardDetail.errorWhileSaving = false;
		  vueGoInstance.showOrHideCloudSuccessIcon();
          pushDeleteLink(links, response.data.boardVersion);
        }
        else {
          showTopMessage('Your changes are not saved.', 'warning', -1);
          vueGoInstance.boardDetail.errorWhileSaving = true;
        }
      })
      .catch(error => {
        // showTopMessage('Your changes are not saved.', 'warning', -1);
        vueGoInstance.boardDetail.savingAnimation = false;
        vueGoInstance.boardDetail.errorWhileSaving = true;
        reloadBoardDataOnFailure ();
      });
  } else {
    showTopMessage('You dont have access to this board');
    window.location.reload();
  }
}
function restoreItem(log, item, node) {

  var index = -1;
  if (vueGoInstance.isPublicLinkUrl) {
    index = _.findIndex(vueGoInstance.boardDetail.board.collaborators, collab => {
      return collab.user.id == loggedInUser.id;
    });
  }

  if (index > -1) {
    
    vueGoInstance.boardDetail.savingAnimation = true;

    var data = { item: item, log: log };

    axios.post("/graphx/item/restore/" + vueGoInstance.boardDetail.board.id, data)
      .then(response => {
        vueGoInstance.boardDetail.savingAnimation = false;

        if (response.data.success) {

          incrementSelfBoardVersion();
          checkBoardCurrentVersion(response.data.boardVersion);

          hideTopMessage();
          vueGoInstance.boardDetail.errorWhileSaving = false;


          response.data.items.forEach(nodeId => {

            let key = parseInt(Object.keys(nodeId)[0]);

            var nodeData = node.data;

            board.skipsUndoManager = true;
            board.model.setDataProperty(nodeData, "_id", nodeId[key])
            board.skipsUndoManager = false;

            if (nodeData.category === "Arrow") {
              var newLinks = [];
              newLinks.push(nodeData);
              pushCreateLink(newLinks, synId, response.data.boardVersion);
            }
            else {
              var newNodes = [];
              newNodes.push(JSON.parse(JSON.stringify(nodeData)));
              if (nodeData.category && (nodeData.category === "SHAPE" || nodeData.category === "NOTE" || nodeData.category === "TEXT" || nodeData.category === "FRAME")) {
                vueGoInstance.onNodeCreate(nodeData);
              }
              pushCreateNode(newNodes, synId, response.data.boardVersion);
            }
          });
        } else {
          showTopMessage('Your changes are not saved.', 'warning', -1);
          vueGoInstance.boardDetail.errorWhileSaving = true;
        }
      })
      .catch(error => {
        showTopMessage('Your changes are not saved.', 'warning', -1);
        vueGoInstance.boardDetail.savingAnimation = false;
        vueGoInstance.boardDetail.errorWhileSaving = true;
      });
  } else {
    showTopMessage('You dont have access to this board');
    window.location.reload();
  }

}
//...........................................

function uploadBoardPreview(boardId, bitmap) {

  if (vueGoInstance.isPublicLinkUrl) {
    return;
  }

  var index = _.findIndex(vueGoInstance.boardDetail.board.collaborators, collab => {
    return collab.user.id == loggedInUser.id;
  })

  if (index > -1) {
    const config = { headers: { 'Content-Type': 'application/json' } };
    axios.post("/graphx/board/thumbnail/" + boardId, bitmap, config)
      .then(response => {
      })
      .catch(error => {

      });
  } else {
    showTopMessage('You dont have access to this board');
    window.location.reload();
  }

}
async function uploadImageToS3(data) {
  
  if (vueGoInstance.isPublicLinkUrl) {
    return;
  }

  // var index = _.findIndex(vueGoInstance.boardDetail.board.collaborators, collab => {
  //   return collab.user.id == loggedInUser.id;
  // });

  if (index > -1) {
    const config = { headers: { 'Content-Type': 'application/json' } };
    try {
      let result = await axios.post("/graphx/board/uploadImage", data, config)
      return result.data;
    } catch (err) {
      console.log(err)
    }
  } else {
    showTopMessage('You dont have access to this board');
    window.location.reload();
  }
}

async function uploadImageToMongoGridFS(file) {
  // if (vueGoInstance.isPublicLinkUrl) {
  //   return;
  // }

  // var index = _.findIndex(vueGoInstance.boardDetail.board.collaborators, collab => {
  //   return collab.user.id == loggedInUser.id;
  // });

  // if (index > -1) {
  //   try {
  //     const formData = new FormData();
  //     formData.append('file', file);
  //     return await axios.post("/upload/upload-image", formData,
  //         {
  //           headers: {'Content-Type': 'multipart/form-data'}
  //         });
  //   } catch (err) {
  //     console.log(err)
  //   }
  // } else {
  //   showTopMessage('You dont have access to this board');
  //   window.location.reload();
  // }


    try {
      const formData = new FormData();
      formData.append('file', file);
      var path;
      if(vueGoInstance.isPublicLinkUrl) {
        var token = this.getUrlParameter("token");
        path = "/graphx/public_share/upload-image?token=" + token;
      } else {
        path = "/upload/upload-image/";
      }
      return await axios.post(path, formData,
          {
            headers: {'Content-Type': 'multipart/form-data'}
          });
    } catch (err) {
      console.log(err)
    }
}
function downloadImageCallback(blob) {
  
  var url = window.URL.createObjectURL(blob);
  var filename = vueGoInstance.boardDetail.board.title;

  var a = document.createElement("a");
  a.style = "display: none";
  a.href = url;
  a.download = filename;

  // IE 11
  if (window.navigator.msSaveBlob !== undefined) {
    window.navigator.msSaveBlob(blob, filename);
    return;
  }

  document.body.appendChild(a);
  requestAnimationFrame(function () {
    a.click();
    window.URL.revokeObjectURL(url);
    document.body.removeChild(a);
  });
}
function checkConnectionStatus(callback) {
  
  var apiUrl = "";
  var apiUrl;
  if (vueGoInstance.isPublicLinkUrl) {
    var token = this.getUrlParameter("token");
    apiUrl = "/graphx/public_share/status?token=" + token ;
  } else {
    apiUrl = "/graphx/status";
  }

  axios.get(apiUrl).
    then(response => {
      if (response.data) {
        callback(response.data.success);
      } else {
        callback(false);
      }
    }).catch(error => {
      callback(false);
    });
}