//go.Diagram.licenseKey = "298647e7b36643c702d90776423d6abc5cf07a34cf960ef2050040f4eb5b6b47719ee87806c19bc7daa84ffc1c2ec98bdfc73c29c345553ee138d0d911e0d3f9e73074a0040e12dea203749398e83aa2fd7b75edc2aa74a2"
go.Diagram.licenseKey = "73f944e7b46631b700ca0d2b113f69ee1bb37f3b9ed71ef2595541f7ef0a68443089ef7001d28bc681f11cfe1828c08dd4956c2f9e4f0069e564d38944e594e9b46223b4145a178fb61325c29af935a3e37875"
var $gojs = "gojs";
var synId = undefined;

// var loggedInUser;
var companyId;
var framesMap = new Map();
var previewMode = false;

const MOD_TRNS_NODE_DUPLICATE = "NodeDuplicate";
const MOD_TRNS_NODE_ADD = "NodeAdd";
const MOD_TRNS_FRAME_ADD = "FrameAdd"
const MOD_TRNS_NODE_ADD_EMOJI = "NodeAddEmoji";
const MOD_TRNS_NODE_BULK_ADD = "NodeAddBulk";
const MOD_TRNS_NODE_DEL_EMP_TXT = "NodeDeleteEmptyText";
const MOD_TRNS_NODE_UPD_TEXT = "NodeUpdateText";
const MOD_TRNS_NODE_UPD = "NodeUpdate";
const MOD_TRNS_NODE_LOCK = "NodeLock";
const MOD_TRNS_NODE_LAYOUT = "NodeLayout";
const MOD_TRNS_NODE_UPD_PROP = "NodeUpdateProperty";
const MOD_TRNS_NODE_DEL = "NodeDelete";

const MOD_TRNS_LINK_UPDATE = "LinkUpdate";

const MOD_TRNS_BOARD_APP_TEMP = "BoardApplyTemplate";
const MOD_TRNS_BOARD_SCALE = "BoardChangeScale";

const BOARD_TRNS_NODE_ADD_INFRAME = "NodeAddInFrame";
const BOARD_TRNS_NODE_FIT_CONTENT = "ChangeFitContent";
const BOARD_TRNS_BOARD_PREVIEW = "Preview";

const GEN_TRNS_LINK_CHANGE = "linkChanging";
const GEN_TRNS_LOC_CHANGE = "location Changed";
const GEN_TRNS_INITIAL_LAYOUT = "Initial Layout";
const GEN_TRNS_DRAG_CREATING = "DragCreating";
let internalBoardCopy = false;

function bigKeyGen() {
  return new Date().valueOf();
}

//document paste event trigger
//  document.onpaste = async function (event){
// 			//OS clipboard data object loads here
// 			var items =await (event.clipboardData  || event.originalEvent.clipboardData).items;
//             var textFromClipboard;
//             for (var i = 0; i < items.length; i++) {
//
//               if(items[i].type.indexOf("text/plain") === 0){
// 				var blob1 =await items[i].getAsString(async function(s){
//                 textFromClipboard =s;
// 				if(textFromClipboard !== "__%&^%$#!@$&^%$!@#$&*()^-__!@#$&*()^-__!@#$&*()^-__!@#$&*&&^%##$%&*(((*^%%$#$^&*(*&^%$%^&"){
// 					copyFlag=false;
// 					var e = await board.lastInput
// 					board.model.addNodeData({ text: textFromClipboard, category:"TEXT", width:300, loc:board.lastInput.documentPoint,"isEditable":true,"linkTo":false});
// 					e.bubbles = true;
// 					var items = (event.clipboardData  || event.originalEvent.clipboardData).items;
// 				}//if ends here
//                 else if(textFromClipboard === "__%&^%$#!@$&^%$!@#$&*()^-__!@#$&*()^-__!@#$&*()^-__!@#$&*&&^%##$%&*(((*^%%$#$^&*(*&^%$%^&"){
// 					board.startTransaction("pasteFromClipboard");
//                     var coll = board.commandHandler.pasteFromClipboard();
//                     board.commitTransaction("pasteFromClipboard");
// 				  }
//               			})
//               }else if(items[i].type.indexOf("image") === 0) {
//                   var blob2 =await items[i].getAsFile();
//                   if (blob2 !== null) {
//                      var reader = new FileReader();
//                       reader.onload = function(event) {
//                         	var dataURL = reader.result;
// 							var generatedKey =  bigKeyGen();
// 									board.skipsUndoManager = true;
// 									//board.startTransaction("add Image Node");
// 								    board.model.addNodeData({
// 										"category" : "PICTURE",
// 										key:generatedKey
//
// 									});
// 									//board.commitTransaction("add Image Node");
// 									board.skipsUndoManager = false;
//
// 									uploadImageToS3(event.target.result)
// 							.then(res=>{
// 								if (res.success){
// 									console.log('------------here-------------',res)
// 									var path = s3_resource_url + res.path;
// 									board.startTransaction("add Image Node");
// 									board.model.commit(function (){
// 											board.remove(board.findNodeForKey(generatedKey));
// 										},null);
// 										board.model.addNodeData({
// 										"category": "PICTURE",
// 										"source": path,
// 										"loader": false,
// 										key : bigKeyGen(board.model)
// 									});
// 									board.commitTransaction("add Image Node");
//
// 								}
// 							})
// 						};
//                         reader.readAsDataURL(blob2);
//                        }
//                     }
// 				}//for loop ends here
// 	//}// if ends here
//
// }

go.Shape.defineFigureGenerator("RoundedRectangleRadius", function (shape, w, h) {
  // this figure takes one parameter, the size of the corner
  var p1 = 5;  // default corner size
  if (shape !== null) {
    var param1 = shape.parameter1;
    if (!isNaN(param1) && param1 >= 0) p1 = param1;  // can't be negative or NaN
  }
  p1 = Math.min(p1, w / 2);
  p1 = Math.min(p1, h / 2);  // limit by whole height or by half height?
  var geo = new go.Geometry();
  // a single figure consisting of straight lines and quarter-circle arcs
  geo.add(new go.PathFigure(0, p1)
    .add(new go.PathSegment(go.PathSegment.Arc, 180, 90, p1, p1, p1, p1))
    .add(new go.PathSegment(go.PathSegment.Line, w - p1, 0))
    .add(new go.PathSegment(go.PathSegment.Arc, 270, 90, w - p1, p1, p1, p1))
    .add(new go.PathSegment(go.PathSegment.Arc, 0, 90, w - p1, h - p1, p1, p1))
    .add(new go.PathSegment(go.PathSegment.Line, p1, h))
    .add(new go.PathSegment(go.PathSegment.Arc, 90, 90, p1, h - p1, p1, p1).close())
  );
  // don't intersect with two bottom corners when used in an "Auto" Panel
  geo.spot1 = new go.Spot(0, 0, 0.3 * p1, 0);
  geo.spot2 = new go.Spot(1, 1, -0.3 * p1, -0.3 * p1);
  return geo;
});

var createLinkFromNode = null;
var tempMultiSelectionAdornment = null;
var tempTextForAutoFont = null;

var nodeContextMenuElement = null;
var frameContextMenuElement = null;
var boardContextMenuElement = null;

//.........
var gridDotSpacingSize = 10;
var gridDotSize = 1;

const checkForDropInFrameOnPasteMap = {};

function initializeVueInstance() { }

function initPage() {
  $gojs = go.GraphObject.make;
  initializeVueInstance();

  // getLoggedInUser();

  companyId = loggedInUser.loggedInUserCompany.company.id;

  synId = getNewUUID();
  // socketConnect();
}

//.........   NODE TEMPLATES

function getFrameTemplate(nodeContextMenu, nodeClicked) {

  var groupTemplate =
    $gojs(go.Group, "Auto",
      {

        layerName: "Background",
        ungroupable: true,
        locationSpot: go.Spot.TopLeft,
        computesBoundsAfterDrag: true,  // allow dragging out of a Group that uses a Placeholder
        handlesDragDropForMembers: true,  // don't need to define handlers on Nodes and Links
        computesBoundsIncludingLocation: true,
        computesBoundsIncludingLinks: false,
        mouseDrop: function (event, group) {  // add dropped nodes as members of the group
          handleDragDropInFrame(board.selection, group);
        },
        mouseDragEnter: (e, grp, prev) => highlightGroup(e, grp, prev, true),
        mouseDragLeave: (e, grp, next) => highlightGroup(e, grp, next, false),

        doubleClick: nodeClicked,
        contextMenu: nodeContextMenu,
        selectionAdornmentTemplate: getSelectionAdornment(false, true),

        isShadowed: true,
        shadowColor: "gray",
        shadowOffset: new go.Point(0, 2),
        shadowBlur: 6,

        rotatable: false,
        resizeAdornmentTemplate: getResizeAdornmentTemplate(),
        // "SelectionMoved": function (e) { e.diagram.layoutDiagram(true); }
      },
      new go.Binding("zOrder", "zOrder").makeTwoWay(),
      new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),
      // new go.Binding("selectable", "isEditable", function (value) { return value }),
      // new go.Binding("layout", "layout", function (layout) {
      //   if (layout == "none") {
      //     return null;
      //   }
      //   return getFrameLayout(false);
      // }),
      new go.Binding("resizable", "lock", function (value) { return !value }),
      new go.Binding("movable", "lock", function (value) { return !value }),
      new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),

      new go.Binding("angle").makeTwoWay(),

      $gojs(go.Shape,
        {
          fill: "transparent", strokeWidth: 1, shadowVisible: true, stroke: "lightgray"
        },
        new go.Binding("fill"),
        // new go.Binding("stroke","isHighlighted", h=> h ? "dodgerblue" : "lightgray").ofObject(),
        // new go.Binding("strokeWidth","isHighlighted", (h,object)=> {
        //   if (h) {
        //     // object.fill = "gray";
        //     return 4 * board.scale;
        //   }
        //   else {
        //     // object.fill = "gray";
        //     return 1;
        //   }
        // }).ofObject(),
      ),

      $gojs(go.Panel, "Vertical",
        {
          alignment: go.Spot.TopLeft,
          stretch: go.GraphObject.Horizontal
        },

        $gojs(go.Panel, "Auto",
          {
            alignment: go.Spot.TopLeft,
            stretch: go.GraphObject.Horizontal,
            minSize: new go.Size(NaN, 20),
            name: "Header",
          },
          new go.Binding("visible", "showHeader", function (showHeader) {
            return showHeader == null ? false : showHeader;
          }),
          $gojs(go.Shape,
            {
              fill: "transparent", strokeWidth: 0, shadowVisible: false
            },
            new go.Binding("fill", "textBg"),
          ),
          $gojs(go.TextBlock, "",
            {
              name: "textBlock",
              stretch: go.GraphObject.Horizontal, overflow: go.TextBlock.OverflowEllipsis,
              alignment: go.Spot.TopLeft, alignmentFocus: go.Spot.BottomLeft,
              font: "12pt sans-serif",
              editable: true,
              stroke: "gray",
              maxLines: 1,
              isMultiline: false,
              margin: 8
            },
            new go.Binding("editable", "showHeader", function (showHeader) {
              return showHeader == null ? false : showHeader ;
            }),
            new go.Binding("textAlign", "textAlignment"),
            new go.Binding("stroke", "textColor"),
            new go.Binding("font", "textSize", function (size) {
              return size + "px sans-serif";
            }),
            new go.Binding("text", "text").makeTwoWay(),
            new go.Binding("editable", "", function (data) { 
              return !data.lock && (data.showHeader == null ? false : data.showHeader) && vueGoInstance.userRights.canWrite;
            })
          )
        ),

        $gojs(go.Shape,
          {
            name: "Placeholder", alignment: go.Spot.TopLeft, fill: null, strokeWidth: 1, stroke: "transparent", desiredSize: new go.Size(1, 1)
          },
        )

        // $gojs(go.Placeholder,
        //   {name: "Placeholder" ,padding: 12, margin: new go.Margin(0, 0, 0, 0), alignment: go.Spot.TopLeft 
        //   },
        // )
      )
    );
  return groupTemplate;
}

// function getFrameTemplate1(nodeContextMenu, nodeClicked) {

//   var groupTemplate =
//     $gojs(go.Group, "Auto",
//       {

//         layerName: "Background",
//         ungroupable: true,
//         locationSpot: go.Spot.TopLeft,
//         selectionObjectName: "frame",
//         ///resizeObjectName: "frame",
//         computesBoundsAfterDrag: true,  // allow dragging out of a Group that uses a Placeholder
//         handlesDragDropForMembers: true,  // don't need to define handlers on Nodes and Links
//         computesBoundsIncludingLocation: true,
//         computesBoundsIncludingLinks: false,
//         mouseDrop: function (event, group) {  // add dropped nodes as members of the group
//           handleDragDropInFrame(board.selection , group);
//         },
//         mouseDragEnter: function (event, group) {},
//         mouseDragLeave: function (event, group) {},

//         doubleClick: nodeClicked,
//         contextMenu: nodeContextMenu,
//         selectionAdornmentTemplate: getSelectionAdornment(false, true),

//         isShadowed: true,
//         shadowColor: "gray",
//         shadowOffset: new go.Point(0,2),
//         shadowBlur: 6,

//         // "SelectionMoved": function (e) { e.diagram.layoutDiagram(true); }
//       },
//       new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),
//       new go.Binding("selectable", "isEditable", function (value) { return value }),
//       new go.Binding("layout", "layout", function (layout) {
//         if (layout == "none") {
//           return null;
//         }
//         return getFrameLayout(false);
//       }),
//       new go.Binding("resizable", "lock", function (value) { return !value }),
//       new go.Binding("movable", "lock", function (value) { return !value }),
//       new go.Binding("rotatable", "lock", function (value) { return !value }),
//       new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),

//       new go.Binding("angle").makeTwoWay(),

//       $gojs(go.Shape,
//         {
//           fill: "transparent", strokeWidth: 0, stroke: null, shadowVisible: false
//         }),
//       $gojs(go.Panel, "Auto",
//         {
//           alignment: go.Spot.TopLeft,
//           stretch: go.GraphObject.Horizontal,
//           height: 20,
//           name: "Header"
//         },
//         new go.Binding("height","scale", function(scale) {
//           return 20 / scale;
//         }).ofModel(),
//         $gojs(go.Shape,
//           {
//             fill: "transparent", strokeWidth: 0, shadowVisible: false
//           }),
//         $gojs(go.TextBlock, "",
//           {
//             name: "Title",
//             stretch: go.GraphObject.Horizontal,overflow : go.TextBlock.OverflowEllipsis,
//             alignment: go.Spot.TopLeft, alignmentFocus: go.Spot.BottomLeft,
//             font: "12pt sans-serif", editable: true, stroke: "gray",
//             maxLines: 1, isMultiline: false
//           },
//           new go.Binding("font", "scale", function (scale) {
//             var size = 12/scale;
//             return size+"pt sans-serif";
//           }).ofModel(),
//           new go.Binding("text", "text", function (text, item) {
//             if (_.isEmpty(text)) {
//               // item.stroke = "red";
//               return "Placeholder"
//             } else {
//               // item.stroke = "black";
//               return text;
//             }
//           }),
//           // new go.Binding("stroke", "color")
//           )
//       ),

//       $gojs(go.Panel, "Auto",
//         {
//           name: "frame",
//           alignment: new go.Spot(0, 0, 0, 0),
//           stretch: go.GraphObject.Fill,
//           margin : new go.Margin(20,0,0,0)
//         },
//         new go.Binding("margin", "scale", function (scale) {
//             var top = 20 / scale;
//             return new go.Margin(top, 0, 0, 0);
//           }).ofModel(),
//         $gojs(go.Shape,
//           {
//             fill: "transparent", strokeWidth: 1,
//             shadowVisible: true, stroke: "lightgray"
//           },
//           new go.Binding("fill"),
//           // new go.Binding("stroke", "border"),
//           // new go.Binding("strokeWidth", "thickness"),
//           // new go.Binding("strokeDashArray", "dash")
//           ),
//     $gojs(go.Panel, "Auto", {alignment: go.Spot.TopRight},
//         $gojs("HyperlinkText",
//             function(node) { return node.data.linkTo},
//             $gojs(go.Panel, "Auto",{alignment: go.Spot.TopLeft},
//                 $gojs(go.Shape, {figure: "RoundedRectangle", fill: "lightgreen" } ),
//                 $gojs(go.TextBlock, "link" )
//             )
//         ),
//         new go.Binding("visible", "linkTo", function(linkTo){ return linkTo ? true : false;})
//     ),
//       ),
//       $gojs(go.Placeholder,
//         {name: "Placeholder" ,padding: 12, margin: new go.Margin(20, 0, 0, 0), alignment: go.Spot.TopLeft , stretch: go.GraphObject.Fill},
//         new go.Binding("margin", "scale", function (scale) {
//             var top = 20 / scale;
//             return new go.Margin(top, 0, 0, 0);
//           }).ofModel(),
//         ),
//     );
//   return groupTemplate;
// }

function getGroupTemplate(nodeContextMenu, nodeClicked) {

  var groupTemplate =
    $gojs(go.Group, "Auto",
      {
        layerName: "Background",
        ungroupable: true,
        locationSpot: go.Spot.TopLeft,
        selectionObjectName: "frame",
        handlesDragDropForMembers: true,  // don't need to define handlers on Nodes and Links
        computesBoundsIncludingLocation: true,
        contextMenu: nodeContextMenu,
        selectionAdornmentTemplate: getSelectionAdornment(false),
      },
      new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),
      // new go.Binding("selectable", "isEditable", function (value) { return value }),
      new go.Binding("resizable", "lock", function (value) { return !value }),
      new go.Binding("movable", "lock", function (value) { return !value }),
      new go.Binding("rotatable", "lock", function (value) { return !value }),
      new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),

      new go.Binding("angle").makeTwoWay(),

      $gojs(go.Shape,
        {
          fill: "transparent", strokeWidth: 0, stroke: null, shadowVisible: false
        }),
      $gojs(go.Placeholder,
        { padding: 0, margin: new go.Margin(0, 0, 0, 0), alignment: go.Spot.TopLeft }),

    );
  return groupTemplate;
}

function getFreehandDrawingTemplate() {
  var template = $gojs(go.Node, "Auto",
    {
      name: "",
      locationSpot: go.Spot.Center,
      selectionAdorned: true,
      selectionAdornmentTemplate: getSelectionAdornment(false),
      reshapable: false,
      resizable: true,
      rotatable: true,
      selectable: true
    },
    new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
    new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),

    new go.Binding("resizable", "lock", function (value) { return !value }),
    new go.Binding("movable", "lock", function (value) { return !value }),
    new go.Binding("rotatable", "lock", function (value) { return !value }),

    new go.Binding("angle").makeTwoWay(),

    $gojs(go.Shape,
      { // the border
        name: "", fill: "transparent", strokeWidth: 0
      },
    ),
    $gojs(go.Shape,
      { name: "SHAPE", margin: 1, fill: null, strokeWidth: 1, stretch: go.GraphObject.Fill },
      new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),
      new go.Binding("angle").makeTwoWay(),
      new go.Binding("geometryString", "geo").makeTwoWay(),
      new go.Binding("fill").makeTwoWay(),
      new go.Binding("stroke", "border").makeTwoWay(),
      new go.Binding("strokeWidth", "thickness").makeTwoWay()
    )
  );
  return template;
}

function getTextTemplate(nodeContextMenu, nodeClicked) {

  var textTemplate = $gojs(go.Node, "Auto",
    {
      locationSpot: go.Spot.TopLeft,
      locationObjectName: "TEXT",
      doubleClick: nodeClicked,
      contextMenu: nodeContextMenu,
      selectionAdornmentTemplate: getSelectionAdornment(true, true),
      fromSpot: go.Spot.AllSides, toSpot: go.Spot.AllSides,
      fromLinkable: true, toLinkable: true,
      minSize: new go.Size(25, 40),
      width: 30,
      height: NaN
    },
    new go.Binding("zOrder", "zOrder").makeTwoWay(),
    new go.Binding("resizable", "lock", function (value) { return !value }),
    new go.Binding("movable", "lock", function (value) { return !value }),
    new go.Binding("rotatable", "lock", function (value) { return !value }),
    // new go.Binding("selectable", "isEditable", function (value) { return value }),

    new go.Binding("angle").makeTwoWay(),

    $gojs(go.Shape, { strokeWidth: 0, fill: "transparent" }),
    $gojs(go.TextBlock,
      {
        name: "textBlock",
        background: "transparent",
        wrap: go.TextBlock.WrapFit,
        textAlign: "left",
        alignment: go.Spot.Center,
        stretch: go.GraphObject.Horizontal,
        fromSpot: go.Spot.AllSides, toSpot: go.Spot.AllSides,
        fromLinkable: true, toLinkable: true,
        portId: "",
        spacingAbove: 3,
        spacingBelow: 3,
        margin: 10
      },
      new go.Binding("textAlign", "textAlignment").makeTwoWay(),
      new go.Binding("editable", "lock", function (value) { return !value && vueGoInstance.userRights.canWrite }),
      new go.Binding("text").makeTwoWay(),
      new go.Binding("font", "textSize", function (textSize, object) {
        var data = object.part.data;
        var font = data.textFont;
        if (!font) {
          font = "sans-serif";
        }
        return (data.italic ? "italic " : "") + (data.bold ? "bold " : "") + textSize + "px " + font;
      }),
      new go.Binding("isUnderline", "underline").makeTwoWay(),
      new go.Binding("stroke", "textColor").makeTwoWay(),
      new go.Binding("background", "textBg").makeTwoWay()
    ),
    $gojs(go.Panel, "Auto", { alignment: go.Spot.TopRight },
      $gojs("HyperlinkText",
        function (node) { return node.data.linkTo },
        $gojs(go.Panel, "Auto", { alignment: go.Spot.TopLeft },
          $gojs(go.Shape, { figure: "RoundedRectangle", fill: "lightgreen" }),
          $gojs(go.TextBlock, "link")
        )
      ),
      new go.Binding("visible", "linkTo", function (linkTo) { return linkTo ? true : false; })
    ),
    new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
    new go.Binding("width", "width").makeTwoWay()

    // new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),

  );

  return textTemplate;
}

function getSimpleNodeTemplate(nodeContextMenu, nodeClicked) {

  var simpleTemplate = $gojs(go.Node, "Auto",
    {
      name: "SHAPE",
      locationSpot: go.Spot.TopLeft,
      locationObjectName: "SHAPE",
      resizable: true,
      movable: true,
      doubleClick: nodeClicked,
      contextMenu: nodeContextMenu,
      selectionObjectName: "SHAPE",
      selectionAdornmentTemplate: getSelectionAdornment(true, true),
      resizeAdornmentTemplate: getResizeAdornmentTemplate(),
      cursor: "",
      fromSpot: go.Spot.AllSides, toSpot: go.Spot.AllSides,
      fromLinkable: true, toLinkable: true,
      layerName: "Foreground",
    },
    // these Bindings are TwoWay because the DraggingTool and ResizingTool modify the target properties
    new go.Binding("zOrder", "zOrder").makeTwoWay(),
    new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
    new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),

    new go.Binding("resizable", "lock", function (value) { return !value }),
    new go.Binding("movable", "lock", function (value) { return !value }),
    new go.Binding("rotatable", "lock", function (value) { return !value }),
    // new go.Binding("selectable", "isEditable", function (value) { return value }),

    new go.Binding("angle").makeTwoWay(),

    $gojs(go.Shape,
      { // the border
        alignment: go.Spot.TopLeft, stretch: go.GraphObject.Fill, name: "SHAPE", fill: "transparent", cursor: "",
        fromSpot: go.Spot.AllSides, toSpot: go.Spot.AllSides,
        fromLinkable: true, toLinkable: true,
        portId: "",
          strokeWidth: 1.5
      },
      new go.Binding("figure"),
      new go.Binding("fill"),
      new go.Binding("stroke", "border"),
      new go.Binding("strokeWidth", "thickness"),
      new go.Binding("strokeDashArray", "", function (data) {
        if (!data.lineType) {
          return [];
        }
        return data.lineType == 0 ? [] : (data.lineType == 1 ? [data.thickness * 3, data.thickness * 3] : [data.thickness * 1, data.thickness * 2]);
      })
    ),
    // $gojs(go.Panel, "Auto", { alignment: go.Spot.TopRight },
    //   $gojs("HyperlinkText",
    //     function (node) { return node.data.linkTo },
    //     $gojs(go.Panel, "Auto", { alignment: go.Spot.TopLeft },
    //       $gojs(go.Shape, { figure: "RoundedRectangle", fill: "lightgreen" }),
    //       $gojs(go.TextBlock, "link")
    //     )
    //   ),
    //   new go.Binding("visible", "linkTo", function (linkTo) { return linkTo ? true : false; })
    // ),
    //this Shape prevents mouse events from reaching the middle of the port
    //$gojs(go.Shape, { width: 100, height: 40, strokeWidth: 0, fill: "transparent" }),

    $gojs(go.TextBlock,
      { name: "textBlock", margin: new go.Margin(5, 5, 5, 5), verticalAlignment: go.Spot.Center, textAlign: "center", wrap: go.TextBlock.WrapBreakAll ,stretch: go.GraphObject.Fill},
      new go.Binding("textAlign", "textAlignment"),
      new go.Binding("alignment", "textAlignment", function (value) {
        return value == "right" ? go.Spot.Right : (value === "left" ? go.Spot.Left : go.Spot.Center);
      }),
      new go.Binding("text").makeTwoWay(),
      new go.Binding("stroke", "textColor"),
      new go.Binding("background", "textBg"),
      new go.Binding("editable", "lock", function (value) { return !value && vueGoInstance.userRights.canWrite; }),
      new go.Binding("font", "textSize", function (textSize, object) {
        var data = object.part.data;
        var font = data.textFont;
        if (!font) {
          font = "sans-serif";
        }
        return (data.italic ? "italic " : "") + (data.bold ? "bold " : "") + textSize + "px " + font;
      }),
      new go.Binding("isUnderline", "underline")
    )
  );
  return simpleTemplate;
}

function getPictureTemplate(nodeContextMenu, nodeClicked) {
  var pictureTemplate = $gojs(go.Node, "Auto",
    {
      name: "IMAGE",
      locationSpot: go.Spot.TopLeft,
      locationObjectName: "SHAPE",
      resizable: true,
      movable: true,
      doubleClick: nodeClicked,
      contextMenu: nodeContextMenu,
      selectionObjectName: "SHAPE",
      selectionAdornmentTemplate: getSelectionAdornment(true, true),
      cursor: "",
      resizeAdornmentTemplate: getResizeAdornmentTemplate(),
        rotatable: true,
      fromSpot: go.Spot.AllSides, toSpot: go.Spot.AllSides,
      fromLinkable: true, toLinkable: true,
      layerName: "Foreground",
    },
    // these Bindings are TwoWay because the DraggingTool and ResizingTool modify the target properties
    new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
    new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),

    new go.Binding("resizable", "lock", function (value) { return !value }),
    new go.Binding("movable", "lock", function (value) { return !value }),
    new go.Binding("rotatable", "lock", function (value) { return !value }),
    // new go.Binding("selectable", "isEditable", function (value) { return value }),
    new go.Binding("zOrder", "zOrder").makeTwoWay(),
    new go.Binding("angle").makeTwoWay(),
      $gojs(go.Panel, "Spot",
          { name: "SHAPE" },

          // Loader image as background (only visible while loading)
          $gojs(go.Picture, "assets/icons/collab/green-loader.svg",
              {
                  desiredSize: new go.Size(300, 200),
              },
              new go.Binding("visible", "loader")
          ),

          // Actual image, starts loading on top of the loader
          $gojs(go.Picture,
              {
                  name: "MAINPIC",
                  desiredSize: new go.Size(300, 200),
                  visible: true,
                  successFunction: (pic, e) => {
                      pic.diagram.commit(() => {
                          board.model.setDataProperty(pic.part.data, "loader", false);
                      }, null);
                  },
                  errorFunction: (pic, e) => {
                      pic.diagram.commit(() => {
                          board.model.setDataProperty(pic.part.data, "loader", false);
                          const node = pic.part; // the Node the Picture belongs to
                          if (node) {
                              pic.diagram.remove(node); // removes the entire node from the diagram
                          }
                      }, null);
                      showTopMessage("Image upload failed.", 'warning', 3000);
                  }
              },
              new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),
              new go.Binding("source", "", (data) => {
                  let source = data.source;
                  let newUrl = source;
                  if (vueGoInstance.isPublicLinkUrl) {
                      if (source.startsWith("/upload/retrieve-image/")) {
                          const token = getUrlParameter("token");
                          newUrl = source.replace("/upload", "/graphx/public_share");
                          newUrl = `${newUrl}?token=${token}`;
                      }
                  } else{
                      if (source.startsWith("/graphx/public_share")) {
                          newUrl = source.replace("/graphx/public_share", "/upload");
                      }
                  }
                  data.source = newUrl;
                  source = newUrl;
                  return source;
              }),
          ),
      )

  );
  return pictureTemplate;

}

function getNoteTemplate(nodeContextMenu, nodeClicked) {

  var noteTemplate = $gojs(go.Node, "Auto",
    {
      locationObjectName: "NOTE",
      minSize: new go.Size(20, 20),
      doubleClick: nodeClicked,
      contextMenu: nodeContextMenu,

      isShadowed: true,
      shadowColor: "rgba(0, 0, 0, 0.1)",
      shadowOffset: new go.Point(2, 10),
      shadowBlur: 6,

      selectionAdornmentTemplate: getSelectionAdornment(true, true),
      cursor: "",

      locationSpot: go.Spot.TopLeft,

      fromSpot: go.Spot.AllSides, toSpot: go.Spot.AllSides,
      fromLinkable: true, toLinkable: true,

      movable: true,
      resizable: false,
      rotatable: false,
      layerName: "Foreground",
    },
    // these Bindings are TwoWay because the DraggingTool and ResizingTool modify the target properties
    new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
    
    new go.Binding("zOrder", "zOrder").makeTwoWay(),

    new go.Binding("scale", "scale").makeTwoWay(),
    new go.Binding("movable", "lock", function (value) { return !value }),
    // new go.Binding("rotatable", "lock", function (value) { return !value }),
    // new go.Binding("selectable", "isEditable", function (value) { return value }),

    new go.Binding("angle").makeTwoWay(),

    $gojs(go.Shape,
      { // the border
        name: "NOTE", fill: "white", stroke: null, strokeWidth: 0, cursor: "", portId: "",
        fromSpot: go.Spot.AllSides, toSpot: go.Spot.AllSides, fromLinkable: true, toLinkable: true,
        fromEndSegmentLength: 100, toEndSegmentLength: 100
      },
      
    ),
    $gojs(go.Panel, "Vertical", {
      stretch: go.GraphObject.Fill,
      alignment: go.Spot.TopLeft,
      cursor: "",
      // background: "green"
      margin: 0
    },
      $gojs(go.Panel, "Auto", {
        cursor: "",
        name: "TextPanel",
        alignment: go.Spot.TopLeft,
        stretch: go.GraphObject.Fill,
        margin: 0
      },
      new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),
        $gojs(go.Shape,
          { // the border
            fill: "transparent", stroke: null, strokeWidth: 0
          },
          new go.Binding("fill")
        ),
        $gojs(go.TextBlock,
          {
            margin: 10, name: "textBlock", textAlign: "center", editable: true, wrap: go.TextBlock.WrapBreakAll,verticalAlignment: go.Spot.Center
          },
          new go.Binding("editable", "lock", function (value) { return !value && vueGoInstance.userRights.canWrite; }),
          new go.Binding("textAlign", "textAlignment"),
          new go.Binding("alignment", "textAlignment", function (value) {
            return value == "right" ? go.Spot.RightCenter : (value === "left" ? go.Spot.LeftCenter : go.Spot.Center);
          }),
          new go.Binding("text").makeTwoWay(),
          new go.Binding("stroke", "textColor"),
          new go.Binding("background", "textBg"),
          new go.Binding("font", "textSize", function (textSize, obj) {
            var font = obj.part.data.textFont;
            if (!font) {
              font = "sans-serif";
            }
            if (textSize === "Auto") {
              var autoFont = obj.part.data.autoFont;
              return "" + autoFont + "px " + font;
            } else {
              return "" + textSize + "px " + font;
            }
          }),
        ),
      ),
      //   $gojs(go.Panel, $gojs(GridFlowPanelLayout), {
      //           name: "EmojiPanel",
      //           alignment: go.Spot.TopLeft,
      //           itemTemplate: getEmojiOrUserTagTemplate(),
      //           stretch: go.GraphObject.Horizontal,
      //           minSize: new go.Size(10, 10), // <-- prevents zero-size layout error
      //           cursor: "",
      //       },
      //     new go.Binding("itemArray", "", function (data) {
      //         return Array.isArray(data.reactions) ? data.reactions : [];
      //     })
      // )
    ),
  );
  return noteTemplate;
}

function getLinkTemplateArrow() {
  return $gojs(go.Link,
    {

      selectionAdornmentTemplate: getLinkSelectionAdornmentTemplate(),
      relinkableFrom: true,
      relinkableTo: true,
      reshapable: true,
      resegmentable: true,

      curve: go.Link.Bezier,
      curviness: 0,
      fromEndSegmentLength: 20.0,
      toEndSegmentLength: 20.0,
      corner: 10,
      layerName: "Background"

    },
    new go.Binding("zOrder", "zOrder").makeTwoWay(),
    // new go.Binding('curviness', 'curviness').makeTwoWay(),

    new go.Binding("fromEndSegmentLength", "route", function (route) {
      return route == 1 ? 0 : 50;
    }),
    new go.Binding("toEndSegmentLength", "route", function (route) {
      return route == 1 ? 0 : 50;
    }),

    // new go.Binding("selectable", "isEditable", function (value) { return value }),
    new go.Binding("routing", "route", function (route) {
      return route == 2 ? go.Link.Orthogonal : (route == 1 ? go.Link.Normal : go.Link.Bezier);
    }),
    new go.Binding("curve", "route", function (route) {
      return route == 0 ? go.Link.Bezier : go.Link.None;
    }),
    new go.Binding("fromSpot", "fromSpot", go.Spot.parse).makeTwoWay(go.Spot.stringify),
    new go.Binding("toSpot", "toSpot", go.Spot.parse).makeTwoWay(go.Spot.stringify),
    new go.Binding("points", "points",
      function (pointsStr) {
        if (typeof pointsStr == "string") {
          var jsonArray = JSON.parse(pointsStr);
          var points = new go.List();
          _.each(jsonArray, pointStr => {
            points.add(go.Point.parse(pointStr));
          });
          return points;
        }
        else {
          return pointsStr;
        }

      }).makeTwoWay(
        function (pointsGo) {
          var points = [];
          pointsGo.each(p => {
            if (p) {
              points.push(go.Point.stringify(p));
            }
          });
          return JSON.stringify(points);
        }
      ),

    $gojs(go.Shape, { isPanelMain: true, stroke: "transparent", strokeWidth: 35 }),
    $gojs(go.Shape,  // the link path shape
      { isPanelMain: true, strokeWidth: 2 },
      new go.Binding("stroke", "fill").makeTwoWay(),
      new go.Binding("strokeDashArray", "", function (data) {
        return data.lineType == 0 ? [] : (data.lineType == 1 ? [data.thickness * 3, data.thickness] : [data.thickness, data.thickness]);
      }),
      new go.Binding("strokeWidth", "thickness", function (thickness) {
        return thickness;
      }).makeTwoWay(),
    ),
    $gojs(go.Shape,  // the fromArrow
      {
        fromArrow: "Standard", scale: 1, segmentIndex: -1
      },
      new go.Binding("visible", "fromArrow", function (fromArrow) {
        return fromArrow == "none" ? false : true;
      }),
      new go.Binding("scale", "thickness", function (thickness) {
        if (thickness == 1) {
          return thickness;
        }
        return thickness * 0.5;
      }),
      new go.Binding("fromArrow", "fromArrow"),
      new go.Binding("stroke", "fill"),
      new go.Binding("fill", "fill")
    ),
    $gojs(go.Shape,  // the toArrow
      { toArrow: "Standard", scale: 1, segmentIndex: -1, },
      new go.Binding("visible", "toArrow", function (toArrow) {
        return toArrow == "none" ? false : true;
      }),
      new go.Binding("scale", "thickness", function (thickness) {
        if (thickness == 1) {
          return thickness;
        }
        return thickness * 0.5;
      }),
      new go.Binding("toArrow", "toArrow"),
      new go.Binding("stroke", "fill"),
      new go.Binding("fill", "fill")
    ),
    $gojs(go.Panel, "Auto", {
      segmentOffset: new go.Point(0, -12)
    },
      new go.Binding("segmentOrientation", "textPosition", function (textPosition) {
        return textPosition == 0 ? go.Link.None : go.Link.OrientUpright;
      }),
      $gojs(go.Shape,  // the label background, which becomes transparent around the edges
        {
          fill: $gojs(go.Brush, "Radial", { 0: "rgb(240, 240, 240)", 0.0: "rgb(240, 240, 240)", 0: "rgba(240, 240, 240, 0)" }),
          stroke: null
        }),
      $gojs(go.TextBlock, "", {
        name: "Label",
        editable: true
      },
        // this is a Link label
        new go.Binding("text", "text").makeTwoWay(),

        new go.Binding("stroke", "textColor").makeTwoWay(),
        new go.Binding("font", "textSize", function (textSize) {
          return "" + textSize + "px sans-serif";
        })
      )
    )
  );
}

function getCursorTemplate() {
  var cursorGeometry = go.Geometry.parse("M0.819074 1.81739C0.79143 1.17312 1.49812 0.762425 2.04396 1.10555L14.9769 " +
    "9.23558C15.6096 9.63336 15.3997 10.6047 14.6591 10.7058L7.70278 11.6546C7.49624 11.6828 7.30884 11.7905 " +
    "7.18049 11.9548L2.899 17.4355C2.44114 18.0216 1.50143 17.7204 1.46954 16.9773L0.819074 1.81739Z", true);

  var cursorTemplate = $gojs(go.Node, "Vertical",
    $gojs(go.Shape,
      { geometry: cursorGeometry, strokeWidth: 2 },
      new go.Binding("fill"),
      new go.Binding("stroke", "fill"),
      new go.Binding("desiredSize", "scale", function (scale) {
        return new go.Size(10 / scale, 10 / scale);
      }).ofModel()
    ),
    $gojs(go.TextBlock,
      { margin: 1, textAlign: "center", editable: false },
      new go.Binding("text"),
      new go.Binding("font", "scale", function (scale) {
        return (10 / scale) + "px sans-serif";
      }).ofModel()
    ),
    new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),

    new go.Binding("selectable", "lock", function (value) { return value }),
    new go.Binding("visible", "visible")
  );
  return cursorTemplate;
}
function getLockedByOverlayTemplate() {
  var lockedByOverlayTemplate =      // template for locked by during live streaming
    $gojs(go.Node, "Auto",
      $gojs(go.Shape, "RoundedRectangle",
        { fill: "#d27c2c" }
      ),
      $gojs(go.TextBlock,
        { margin: 3, textAlign: "center", editable: false },
        new go.Binding("text")
      ),
      new go.Binding("location", "loc", go.Point.parse),
      new go.Binding("selectable", "lock", function (value) { return value })
    );
  return lockedByOverlayTemplate;
}
function getLockOverlayTemplate() {
  var lockOverlayTemplate =      // template for lock during live streaming
    $gojs(go.Node, "Auto",
      $gojs(go.Shape, { stretch: go.GraphObject.Fill, fill: "lightgray", opacity: 0.7, strokeWidth: .5 },     // shape active when node is lock
        new go.Binding("visible", "isEditable", function (isEditable) { return !isEditable })
      ),
      new go.Binding("desiredSize", "size", go.Size.parse),
      new go.Binding("scale", "scale", function (scale) {
        if (!scale) {
          scale = 1;
        }
        return scale;
      }),
      new go.Binding("location", "loc", go.Point.parse),
      new go.Binding("selectable", "lock", function (value) { return value })
    );
  return lockOverlayTemplate;
}
//.............   LINKS HELPER
function getRelinkFromHandle() {
  return $gojs(go.Shape, "Circle", { segmentIndex: 0, cursor: "pointer", desiredSize: new go.Size(12, 12), fill: "white", stroke: "gray" });
}

function getRelinkToHandle() {
  return $gojs(go.Shape, "Circle", { segmentIndex: -1, cursor: "pointer", desiredSize: new go.Size(12, 12), fill: "white", stroke: "gray" });
}

function getLinkReshapingHandle() {
  return $gojs(go.Shape, "Diamond", { desiredSize: new go.Size(7, 7), fill: "lightblue", stroke: "dodgerblue" });
}

function getLinkSelectionAdornmentTemplate() {
  var linkSelectionAdornmentTemplate =
    $gojs(go.Adornment, go.Panel.Spot,
      $gojs(go.Shape,
        // isPanelMain declares that this Shape shares the Link.geometry
        { isPanelMain: true, fill: null, stroke: "transparent", strokeWidth: 0 }),  // use selection object's strokeWidth
      $gojs(go.Shape,
        // isPanelMain declares that this Shape shares the Link.geometry
        { isPanelMain: true, fill: null, stroke: "dodgerblue", strokeWidth: 1 },
        new go.Binding("strokeWidth", "scale", function (scale) {
          return 2 / scale;
        }).ofModel(),
      ),
      $gojs(go.Placeholder)  // use selection object's strokeWidth
    );
  return linkSelectionAdornmentTemplate;
}

function getTemporaryNodes() {
  var nodeTemplate = $gojs(go.Node, "Auto",
    {
      layerName: "Tool"
    },
    $gojs(go.Shape, { fill: "rgba(0,0,0,0.15)", stroke: "dodgerblue", strokeWidth: 1 }),

    // //.   left 
    // $gojs("Button", {alignment: new go.Spot(0,0.5,-10,0), width: 15, height: 15, "ButtonBorder.figure": "Circle", cursor: "crosshair"}),

    // //.   right
    // $gojs("Button", {alignment: new go.Spot(1,0.5,10,0), width: 15, height: 15, "ButtonBorder.figure": "Circle", cursor: "crosshair"}),

    // //.  up
    // $gojs("Button", {alignment: new go.Spot(0.5,0,0,0), width: 15, height: 15, "ButtonBorder.figure": "Circle", cursor: "crosshair"}),

    // //.  down
    // $gojs("Button", {alignment: new go.Spot(0.5,1.0,0,0), width: 15, height: 15, "ButtonBorder.figure": "Circle", cursor: "crosshair"}),
  );
  return nodeTemplate;
}

//.............   ADORNMENT
var groupHighlightAdornment = null;
function getGroupHighlightAdornment() {
  if (groupHighlightAdornment == null) {
    groupHighlightAdornment = $gojs(go.Adornment, "Auto",
      $gojs(go.Shape, "Rectangle",
        { fill: null, stroke: "dodgerblue", strokeWidth: 4, name: "Rectangle" }),
      $gojs(go.Placeholder),
    );
  }
  return groupHighlightAdornment;
}

function getSelectionAdornment(showLinkButton, showAddButtons) {

    var template = $gojs(go.Adornment, "Spot", { padding: 0, isActionable: true, name: "Selection" },
        $gojs(go.Panel, "Auto", { isActionable: true, name: "Con" },
            $gojs(go.Shape, {
                    fill: null,
                    stroke: "dodgerblue",
                    strokeWidth: 2,
                    pickable: false
                },
                new go.Binding("strokeWidth", "scale", scale => 2 / scale).ofModel()
            ),
            $gojs(go.Placeholder, { isActionable: true })
        )
    );


  // if (showLinkButton) {
  //   template.add(makeLinkButton("link_button", new go.Spot(1, 0, 15, 10)));
  // }

  if (showAddButtons) {
    var margin = 24;
    template.add(makeAddNodeButton("cr_up", new go.Spot(0.5, 0, 0, -margin)));
    template.add(makeAddNodeButton("cr_down", new go.Spot(0.5, 1.0, 0, margin)));
    template.add(makeAddNodeButton("cr_left", new go.Spot(0, 0.5, -margin, 0)));
    template.add(makeAddNodeButton("cr_right", new go.Spot(1, 0.5, margin, 0)));
  }

  return template;
}

function getResizeAdornmentTemplate() {
    return $gojs(go.Adornment, "Spot",
        $gojs(go.Placeholder, { margin: 0 }),

        // Top line
        $gojs(go.Shape, "LineH", {
            width: NaN, height: 2,
            stroke: "transparent", strokeWidth: 11,
            alignment: go.Spot.Top,
            stretch: go.GraphObject.Horizontal,
            cursor: "ns-resize"
        }),

        // Bottom line
        $gojs(go.Shape, "LineH", {
            width: NaN, height: 2,
            stroke: "transparent", strokeWidth: 11,
            alignment: go.Spot.Bottom,
            stretch: go.GraphObject.Horizontal,
            cursor: "ns-resize"
        }),

        // Left line
        $gojs(go.Shape, "LineV", {
            width: 2, height: NaN,
            stroke: "transparent", strokeWidth: 11,
            alignment: go.Spot.Left,
            stretch: go.GraphObject.Vertical,
            cursor: "ew-resize"
        }),

        // Right line
        $gojs(go.Shape, "LineV", {
            width: 2, height: NaN,
            stroke: "transparent", strokeWidth: 11,
            alignment: go.Spot.Right,
            stretch: go.GraphObject.Vertical,
            cursor: "ew-resize"
        }),

        $gojs(go.Shape, {
            alignment: go.Spot.TopLeft,
            cursor: "nesw-resize",
            desiredSize: new go.Size(11, 11),
            fill: "transparent", stroke: "transparent", strokeWidth: 2
        }),
        $gojs(go.Shape, {
            alignment: go.Spot.TopRight,
            cursor: "nwse-resize",
            desiredSize: new go.Size(11, 11),
            fill: "transparent", stroke: "transparent", strokeWidth: 2
        }),
        $gojs(go.Shape, {
            alignment: go.Spot.BottomLeft,
            cursor: "swen-resize",
            desiredSize: new go.Size(11, 11),
            fill: "transparent", stroke: "transparent", strokeWidth: 2
        }),
        $gojs(go.Shape, {
            alignment: go.Spot.BottomRight,
            cursor: "sewn-resize",
            desiredSize: new go.Size(11, 11),
            fill: "transparent", stroke: "transparent", strokeWidth: 2
        }),
    );
}





function showHideAddSelectionAdronment() {
  if (board.selection) {
    board.selection.each(function (selected) {
      if (selected.adornments) {
        selected.adornments.each(function (adornment) {

          if (adornment.name === "Selection") {

            var outerBoundMargin = 30;

            var viewPoint = adornment.diagram.lastInput.documentPoint;

            var selectedBound = selected.getDocumentBounds();
            var outerBound = new go.Rect(selectedBound.x - outerBoundMargin, selectedBound.y - outerBoundMargin, selectedBound.width + outerBoundMargin * 2, selectedBound.height + outerBoundMargin * 2);

            var selectedElementName = "";
            if (!selectedBound.containsPoint(viewPoint) && outerBound.containsPoint(viewPoint) && board.selection.count == 1) {

              var center = selectedBound.center;
              selectedElementName = "cr_";
              var xdelta = viewPoint.x - center.x;
              var ydelta = viewPoint.y - center.y;

              if (Math.abs(xdelta) > Math.abs(ydelta)) {
                //... left right
                selectedElementName += xdelta > 0 ? "right" : "left";
              }
              else {
                //...  up down
                selectedElementName += ydelta > 0 ? "down" : "up";
              }
            }
            var haveAngle = false;
            if (selected.data && selected.data.angle && selected.data.angle != 0) {
              haveAngle = true;
            }

            if (adornment.elements) {
              adornment.elements.each(function (element) {
                if (element.name.startsWith("cr"))
                  element.visible = (element.name === selectedElementName) && vueGoInstance.userRights.canWrite && !haveAngle;
              });
            }
          }
        });
      }
    });
  }
}

function showOrHideAdronmentControlls() {

  setTimeout(function () {
    
    var showConrolls = !(board.selection && board.selection.count > 1) ;
    board.selection.each(function (node) {
      var adornment = node.findAdornment("Selection");
      if (adornment != null) {
        var it = adornment.elements;
        it.next()
        while (it.next()) {
          var item = it.value;
          item.visible = showConrolls;
          break;
        }
      }
    });
  }, 0);
}

function makeAddNodeButton(name, spot) {
    let tempLink = null;
    let tempNode = null;
    let dragInProgress = false;
    let cachedPreviewTarget = null;
    let cachedPreviewLocation = null;

    const clearPreview = () => {
        if (tempLink) {
            board.remove(tempLink);
            tempLink = null;
        }
        if (tempNode) {
            board.remove(tempNode);
            tempNode = null;
        }
        dragInProgress = false;
    };

    const showPreview = (selnode, dir) => {
        const result = findNextFreePositionAndNode(selnode, dir);
        cachedPreviewTarget = result.nearby;
        cachedPreviewLocation = result.location;

        const nearby = cachedPreviewTarget;
        const location = cachedPreviewLocation;
        clearPreview();

        if (nearby) {
            // preview link to unlinked node
            tempLink = $gojs(go.Link, {
                    layerName: "Foreground",
                    selectable: false,
                    routing: go.Link.Orthogonal,
                    curve: go.Link.None,
                    corner: 10,
                    fromSpot: getDirectionalSpot(dir, true),
                    toSpot: getDirectionalSpot(dir, false)
                },
                $gojs(go.Shape, { stroke: "rgba(0,0,0,0.3)", strokeWidth: 2 }),
                $gojs(go.Shape, {
                    toArrow: "Standard",
                    stroke: "rgba(0,0,0,0.3)",
                    fill: "rgba(0,0,0,0.3)"
                })
            );
            tempLink.fromNode = selnode;
            tempLink.toNode = nearby;
            board.add(tempLink);
        } else {
            // preview ghost node and link
            const shapeName = selnode.data.category === "PICTURE" ? "Rectangle" : "RoundedRectangle";
            const previewSize = selnode.actualBounds.copy().size;

            tempNode = $gojs(go.Node, "Auto", {
                    location: location.copy(),
                    locationSpot: selnode.locationSpot || go.Spot.TopLeft,
                    angle: selnode.angle,
                    scale: selnode.scale,
                    desiredSize: previewSize,
                    layerName: "Foreground",
                    portId: "",
                    fromSpot: getDirectionalSpot(dir, true),
                    toSpot: getDirectionalSpot(dir, false),
                    fromLinkable: true,
                    toLinkable: true,
                    selectable: false
                },
                $gojs(go.Shape, shapeName, {
                    fill: "rgba(0, 0, 0, 0.05)",
                    stroke: "rgba(0, 0, 0, 0.3)",
                    strokeDashArray: [4, 2],
                    strokeWidth: 1.5,
                    width: previewSize.width,
                    height: previewSize.height
                }));


            board.add(tempNode);

            setTimeout(() => {
                tempLink = $gojs(go.Link, {
                        layerName: "Foreground",
                        selectable: false,
                        routing: go.Link.Orthogonal,
                        curve: go.Link.None,
                        fromSpot: getDirectionalSpot(dir, true),
                        toSpot: getDirectionalSpot(dir, false)
                    },
                    $gojs(go.Shape, { stroke: "rgba(0,0,0,0.3)", strokeWidth: 2 }),
                    $gojs(go.Shape, {
                        toArrow: "Standard",
                        stroke: "rgba(0,0,0,0.3)",
                        fill: "rgba(0,0,0,0.3)"
                    })
                );
                tempLink.fromNode = selnode;
                tempLink.toNode = tempNode;
                board.add(tempLink);
            }, 20);
        }
    };

    const getArrowAngle = (dir) => {
        switch (dir) {
            case "cr_left": return -90;
            case "cr_up": return 0;
            case "cr_down": return 180;
            default: return 90; // right or default
        }
    };

    const onClick = (e, obj) => {
        if (dragInProgress) return; // skip if it was a drag
        e.handled = true;
        if (!vueGoInstance.userRights?.canWrite) return;

        const selnode = obj.part.adornedPart;
        const dir = obj.name;
        const nearby = cachedPreviewTarget;
        const location = cachedPreviewLocation;

        board.startTransaction("Add or Link Node");
        clearPreview();

        if (nearby) {
            board.model.addLinkData({
                from: selnode.key,
                to: nearby.key,
                category: "Arrow",
                route: 2,
                lineType: 0,
                thickness: 2.5,
                fromArrow: "none"
            });
        } else {
            const newNode = duplicateNode(selnode, location, false);
            board.model.addLinkData({
                from: selnode.key,
                to: newNode.key,
                category: "Arrow",
                route: 2,
                lineType: 0,
                thickness: 2.5,
                fromArrow: "none"
            });
        }

        board.commitTransaction("Add or Link Node");
    };

    return $gojs("Button",
        {
            name,
            alignment: spot,
            alignmentFocus: go.Spot.Center,
            cursor: "pointer",
            background: null,
            click: onClick,
            actionMove: (e, obj) => {
                const selnode = obj.part.adornedPart;
                clearPreview();
                startLinkTool(selnode);
                dragInProgress = true;
            },
            mouseEnter: (e, obj) => {
                const selnode = obj.part.adornedPart;
                const dir = obj.name;
                if(!dragInProgress){
                    showPreview(selnode, dir);
                }

                const hoverArrow = obj.findObject("HoverArrow");
                if (hoverArrow) {
                    hoverArrow.visible = true;
                    hoverArrow.angle = getArrowAngle(dir);
                }

                const defaultIcon = obj.findObject("DefaultIcon");
                if (defaultIcon) defaultIcon.visible = false;
            },
            mouseLeave: (e, obj) => {
                clearPreview();
                const hoverArrow = obj.findObject("HoverArrow");
                if (hoverArrow) hoverArrow.visible = false;

                const defaultIcon = obj.findObject("DefaultIcon");
                if (defaultIcon) defaultIcon.visible = true;
            }
        },
        $gojs(go.Shape, "Circle", {
            desiredSize: new go.Size(18, 18),
            fill: "transparent",
            stroke: null,
        }),
        $gojs(go.Shape, "PlusLine", {
            name: "DefaultIcon",
            width: 14,
            height: 14,
            stroke: "dodgerblue",
            strokeWidth: 2,
            visible: true,
        }),
        $gojs(go.Shape, "Triangle", {
            name: "HoverArrow",
            desiredSize: new go.Size(12, 12),
            fill: "black",
            stroke: "black",
            visible: false
        })
    );
}


function findNextFreePositionAndNode(selnode, dir) {
    const bounds = selnode.actualBounds;
    const center = selnode.location.copy();
    const offset = 200;
    const maxAttempts = 10;

    let dx = 0, dy = 0;

    switch (dir) {
        case "cr_left": dx = -1; break;
        case "cr_right": dx = 1; break;
        case "cr_up": dy = -1; break;
        case "cr_down": dy = 1; break;
    }

    for (let i = 1; i <= maxAttempts; i++) {
        const trialPoint = new go.Point(
            center.x + dx * (bounds.width + offset) * i,
            center.y + dy * (bounds.height + offset) * i
        );

        let nearby = null;
        let isLinked = false;

        board.nodes.each(n => {
            if (n.key === selnode.key) return;

            const dist = n.location.distanceSquaredPoint(trialPoint);
            if (dist < 1000) {
                const alreadyLinked = board.links.any(link =>
                    (link.fromNode?.key === selnode.key && link.toNode?.key === n.key) ||
                    (link.fromNode?.key === n.key && link.toNode?.key === selnode.key)
                );

                if (!alreadyLinked) {
                    nearby = n;
                } else {
                    isLinked = true;
                    nearby = n; // save to try vertical shift fallback
                }
            }
        });

        if (nearby && !isLinked) {
            return { nearby, location: null };
        }

        if (isLinked && nearby) {
            // 🔍 Try to find another unlinked node in vertical vicinity of this linked node
            const linkedCenter = nearby.location.copy();
            const verticalOffset = 250;
            const verticalRadius = 150;
            let unlinkedNeighborFound = null;

            board.nodes.each(other => {
                if (other.key === selnode.key || other.key === nearby.key) return;

                const dx = other.location.x - linkedCenter.x;
                const dy = other.location.y - linkedCenter.y;

                const withinX = Math.abs(dx) < bounds.width;
                const withinY = Math.abs(dy) <= verticalOffset + verticalRadius;

                const isAboveOrBelow = dy !== 0 && withinX && withinY;

                const alreadyLinked = board.links.any(link =>
                    (link.fromNode?.key === selnode.key && link.toNode?.key === other.key) ||
                    (link.fromNode?.key === other.key && link.toNode?.key === selnode.key)
                );

                if (isAboveOrBelow && !alreadyLinked) {
                    unlinkedNeighborFound = other;
                }
            });

            if (unlinkedNeighborFound) {
                return { nearby: unlinkedNeighborFound, location: null };
            }

            // If none found, fallback to drawing ghost above/below
            const verticalAttempts = [1, 2, 3];
            for (const step of verticalAttempts) {
                const above = new go.Point(linkedCenter.x, linkedCenter.y - step * verticalOffset);
                if (!board.findPartAt(above, false)) return { nearby: null, location: above };

                const below = new go.Point(linkedCenter.x, linkedCenter.y + step * verticalOffset);
                if (!board.findPartAt(below, false)) return { nearby: null, location: below };
            }
        }

    }

    // Absolute fallback
    return { nearby: null, location: getTargetLocation(selnode, dir) };
}

function getDirectionalSpot(dir, isFrom) {
    switch (dir) {
        case "cr_up": return isFrom ? go.Spot.Top : go.Spot.Bottom;
        case "cr_down": return isFrom ? go.Spot.Bottom : go.Spot.Top;
        case "cr_left": return isFrom ? go.Spot.Left : go.Spot.Right;
        case "cr_right": return isFrom ? go.Spot.Right : go.Spot.Left;
        default: return go.Spot.Center;
    }
}


function getTargetLocation(selnode, dir) {
    const bounds = selnode.actualBounds;
    const center = selnode.location.copy();

    const margin = 200;

    switch (dir) {
        case "cr_up":
            return new go.Point(center.x, center.y - bounds.height - margin);
        case "cr_down":
            return new go.Point(center.x, center.y + bounds.height + margin);
        case "cr_left":
            return new go.Point(center.x - bounds.width - margin, center.y);
        case "cr_right":
            return new go.Point(center.x + bounds.width + margin, center.y);
        default:
            return center;
    }
}


function findNearbyNode(pos, selKey, dir) {
    const radius = 600;
    let bestMatch = null;
    let shortestDist = Infinity;

    board.nodes.each(n => {
        if (n.key === selKey || !n.location) return;

        const dx = n.location.x - pos.x;
        const dy = n.location.y - pos.y;
        const distSq = dx * dx + dy * dy;

        if (distSq > radius * radius) return;

        // Check if already linked to/from
        const isLinked = board.links.any(link =>
            (link.fromNode?.key === selKey && link.toNode?.key === n.key) ||
            (link.fromNode?.key === n.key && link.toNode?.key === selKey)
        );
        if (isLinked) return;  // skip already linked node

        let isInRegion = false;
        switch (dir) {
            case "cr_right": isInRegion = dx >= 0 && Math.abs(dx) > Math.abs(dy); break;
            case "cr_left":  isInRegion = dx <= 0 && Math.abs(dx) > Math.abs(dy); break;
            case "cr_up":    isInRegion = dy <= 0 && Math.abs(dy) > Math.abs(dx); break;
            case "cr_down":  isInRegion = dy >= 0 && Math.abs(dy) > Math.abs(dx); break;
        }

        if (isInRegion && distSq < shortestDist) {
            shortestDist = distSq;
            bestMatch = n;
        }
    });

    return bestMatch;
}







function startLinkTool(node) {
  var diagram = node.diagram;
  diagram.currentTool.doCancel();
  var tool = diagram.toolManager.linkingTool;
  tool.isEnabled = true;
  
  tool.startObject = node;
  diagram.currentTool = tool;
  tool.doActivate();
  vueGoInstance.selectToolbarOptionLink();
}

function makeLinkButton(name, spot, callback) {

  var maker = function (e, obj) {
    e.handled = true;
    if (vueGoInstance && vueGoInstance.userRights && !vueGoInstance.userRights.canWrite) {
      return;
    }

    var node = obj.part;
    node = node.adornedObject;
    startLinkTool(node);
  };

  return $gojs("Button", "Auto",
    {
      name: "LinkButton",
      desiredSize: new go.Size(20, 20),
      actionDown: maker,
      "ButtonBorder.figure": "Circle", cursor: "crosshair", alignment: spot, alignmentFocus: new go.Spot(0.5, 0.5, -20, 6),
      isActionable: true,
      visible: false
    },
    new go.Binding("scale", "scale", function (sacle) { return 1 / sacle }).ofModel(),
    $gojs(go.Picture, { alignment: new go.Spot(0.5, 0.5, 0, 0), angle: 90, desiredSize: new go.Size(10, 10), source: "/assets/icons/collab/arrow.svg" }
    ),
  );
}

//.............   NODE HeLPER
function getFrameLayout(isInitial) {
  return $gojs(FrameLayout,
    {
      // arrangementOrigin: new go.Point(30,30),
      // isInitial: true,

      isInitial: true,
      isOngoing: true,
      cellSize: new go.Size(1, 1),
      spacing: new go.Size(10, 10),
      alignment: go.GridLayout.Position,
      wrappingWidth: Infinity,
      comparer: function (a, b) {

        const aBound = a.actualBounds;
        const bBound = b.actualBounds;

        // console.log("----------------------------");
        // console.log("" + a.data.text + " : " + aBound);
        // console.log("" + b.data.text + " : " + bBound);


        if (bBound.y >= aBound.y && bBound.y <= aBound.bottom) {
          // console.log("same height");
          if (aBound.x > bBound.x) {
            return 1;
          }
          else {
            return -1
          }
        }
        else {
          if (aBound.y > bBound.y) {
            return 1;
          } else {
            return -1;
          }
        }

      }
    });
}

function duplicateNode(node, location, copyContent) {
  var diagram = node.diagram;

  var selnode = node;

  // location.snapToGridPoint(event.diagram.grid.gridOrigin, event.diagram.grid.gridCellSize);
  // make the new node a copy of the selected node
  var nodedata;
  // if (!same) {
  // nodedata = vueGoInstance.getDataObjectWithCategory(selnode.data.category);

  nodedata = _.cloneDeep(selnode.data);
  delete nodedata.__gohashid;
  delete nodedata.id;
  delete nodedata.key;
  if (nodedata.category == "NOTE") {
    delete nodedata.reactions;
  }

  nodedata.lock = false;

  nodedata.size = selnode.data.size;
  nodedata.width = selnode.data.width;
  nodedata.scale = selnode.data.scale;
  // }
  // else {
  //   nodedata = _.cloneDeep(node.data);
  //   nodedata.text = "";

  //   delete nodedata._id;
  //   delete nodedata.key;
  //   delete nodedata.__gohashid;
  // }
  if (!copyContent) {
    nodedata.text = "";
  }
  nodedata.loc = go.Point.stringify(location);

  // add to same group as selected node
  diagram.model.setGroupKeyForNodeData(nodedata, diagram.model.getGroupKeyForNodeData(selnode.data));
  diagram.model.addNodeData(nodedata);  // add to model
  // create a link from the selected node to the new node
  // var linkdata = { category: "Arrow", from: selnode.key, to: m.getKeyForNodeData(nodedata) , fromPort: fromPort, toPort: toPort};
  // m.addLinkData(linkdata);  // add to model
  // move the new node to the computed location, select it, and start to edit it
  var newnode = diagram.findNodeForData(nodedata);
  newnode.location = location;
  newnode.isSelected = true;
  return newnode;
}

function getEmojiOrUserTagTemplate() {
  var template = $gojs("Button", "Auto",
    {
      height: 40,
      width: 80,
      click: function (event, obj) {

        if (vueGoInstance && vueGoInstance.userRights && !vueGoInstance.userRights.canWrite) {
          return;
        }
        var node = obj.part;
        var emojiData = obj.data;

        //.....................................................
        var reactions;
        if (node.data.reactions) {
          reactions = _.cloneDeep(node.data.reactions);
        } else {
          reactions = [];
        }

        var reactionIndex = _.findIndex(reactions, { value: emojiData.value });

        var user = convertLoggedInUser();
        if (reactionIndex > -1) {
          var reaction = reactions[reactionIndex];

          if (user.external) {
            var exist = _.findIndex(reaction.extUsers, { email: user.email });
            if (exist > -1) {
              reaction.extUsers.splice(exist, 1);
              if (_.isEmpty(reaction.extUsers) && _.isEmpty(reaction.users)) {
                reactions.splice(reactionIndex, 1);
              }
            } else {
              reaction.extUsers.push(user);
            }
          }
          else {
            var exist = _.findIndex(reaction.users, { id: user.id });
            if (exist > -1) {
              reaction.users.splice(exist, 1);
              if (_.isEmpty(reaction.users) && _.isEmpty(reaction.extUsers)) {
                reactions.splice(reactionIndex, 1);
              }
            } else {
              reaction.users.push(user);
            }
          }
          // var exist = _.findIndex(reaction.users, { id: user.id });
          // if (exist > -1) {
          //   reaction.users.splice(exist, 1);
          //   if (_.isEmpty(reaction.users)) {
          //     reactions.splice(reactionIndex, 1);
          //   }
          // } else {
          //   reaction.users.push(user);
          // }

          board.model.startTransaction(MOD_TRNS_NODE_ADD_EMOJI);

          var textBlock = node.findObject("textBlock");
          if (textBlock && textBlock.part && textBlock.part.data && textBlock.panel && textBlock.part.data.category === "NOTE") {
            var auto = textBlock.part.data.textSize === "Auto";
            var result = adjustAutoFont(textBlock, auto);
            // if (result.changeMode) {
            // 	_this.$refs.optionMenu.setSelectedItems([node]);
            // }
          }

          board.model.setDataProperty(node.data, "reactions", reactions);
          board.model.updateTargetBindings(node.data);

          board.model.commitTransaction(MOD_TRNS_NODE_ADD_EMOJI);

        }

      },
      cursor: "",
      toolTip:  // define a tooltip for each node that displays the color as text
        $gojs("ToolTip",
          $gojs(go.TextBlock, { margin: 2 },
            new go.Binding("text", "", function (data) {
              var text = "";

              const users = data.users.concat(data.extUsers);
              _.each(users, (user, index) => {
                const name = user.external ? user.name : user.fullName;
                if (index < users.length - 1) {
                  text += name + "\n";
                }
                else {
                  text += name;
                }
              });
              return text;
            }))
        )  // end of Adornment
    },
    $gojs(go.Shape, "Rectangle", { fill: "white", stroke: null }),
    $gojs(go.Picture, { alignment: new go.Spot(0.0, 0.5, 0, 0), width: 40, height: 40 }, new go.Binding("source", "icon")),
    $gojs(go.TextBlock, { alignment: new go.Spot(0, 0.5, 45, 0) }, new go.Binding("text", "", function (data) { 
      const users = data.users.concat(data.extUsers);
      return users.length; 
    }))
  );
  return template;
}

function makePort(id, spot, spotFocus) {
  return $gojs(go.Shape, "Circle",
    {
      fill: "transparent",  // not seen, by default; set to a translucent gray by showSmallPorts, defined below
      stroke: null,
      desiredSize: new go.Size(7, 7),
      alignment: spot,  // align the port on the main Shape
      alignmentFocus: spotFocus,  // just inside the Shape
      portId: id,  // declare this object to be a "port"
      fromSpot: spot, toSpot: spot,  // declare where links may connect at this port
      fromLinkable: true, toLinkable: true,  // declare whether the user may draw links to/from here
      cursor: "pointer"  // show a different cursor to indicate potential link point
    });
}

function showPorts(node, show) {
  if (node.ports && node.ports != null) {
    node.ports.each(function (port) {
      if (port.portId !== "") {  // don't change the default port, which is the big shape
        port.fill = show ? "rgba(0,0,0,.3)" : "transparent";
      }
    });
  }
}

function handleDragDropInFrame(dropedItems, group) {

  try {
    var filteredItems = new go.List();
    dropedItems.each(function (node) {
      if (node.data && group.data && node.data.group !== group.data.key) {
        filteredItems.add(node);
      }
    });
    if (filteredItems.count > 0) {
      var ok = group.addMembers(filteredItems, false);
    }
  } catch (error) {

  }

}

function handleNodeCreated(node) {

  try {
    var position = node.position.copy();
    if (position.x == Infinity || _.isNaN(position.x)) {
      if (node.data)
        position = go.Point.parse(node.data.loc);
    }
    if (position.x == Infinity || _.isNaN(position.x)) {
      return;
    }
    var _parts = node.diagram.findPartsAt(position, true);
    if (_parts) {
      var parts = []
      _parts.each(function (part) {
        if (part.data && part.data.category === "FRAME" && node.key !== part.key) {
          parts.push(part);
        }
      });
      if (!_.isEmpty(parts)) {

        var group = parts[0];

        var notAllowedItems = {};
        if (group.data && group.data.notAllowedItems) {
          _.each(group.data.notAllowedItems, item => {
            notAllowedItems[item] = true;
          });
        }

        var isValidDrop = true;
        if (notAllowedItems[node.data.category]) {
          isValidDrop = false;
        }
        if (isValidDrop) {
          board.commit(() => {
            handleDragDropInFrame(board.selection, group);
          }, BOARD_TRNS_NODE_ADD_INFRAME);
        }
      }
    }

  } catch (error) {

  }

}

function updateMultiSelectionBox() {
  // if (board.selection && board.selection.count > 0) {
  //   const membnds = board.computePartsBounds(board.selection);
  //   if (tempMultiSelectionAdornment == null) {
  //     tempMultiSelectionAdornment = go.GraphObject.make(go.Node, "Auto", { layerName: "Tool", padding: 0, isActionable: true, selectable: false },
  //       $gojs(go.Shape, { fill: null, stroke: "dodgerblue", strokeWidth: 2, pickable: false }),
  //     );
  //     board.add(tempMultiSelectionAdornment);
  //   }
  //   tempMultiSelectionAdornment.desiredSize = membnds.size;
  //   tempMultiSelectionAdornment.position = membnds.position;
  // }
  // else {
  //   if (tempMultiSelectionAdornment != null) {
  //     board.remove(tempMultiSelectionAdornment);
  //     tempMultiSelectionAdornment = null;
  //   }
  // }
}

function showNodeEditingMenu() {

  if (!vueGoInstance.userRights.canWrite) {
    return;
  }

  var editingMenuElement = document.getElementById("node-editing-options");

  // if (board.selection && board.selection.count > 0) {

  editingMenuElement.classList.add("show-menu");

  var selectedNodes = [];

  board.selection.each(function (node) {
    selectedNodes.push(node);
  });
  var nodeBound;
  if (selectedNodes.length > 0) {
    if (selectedNodes.length == 1) {
      var node = selectedNodes[0];
      vueGoInstance.$refs.optionMenu.setSelectedItems(selectedNodes);
      nodeBound = node.getDocumentBounds().copy();

    }
    else {
      vueGoInstance.$refs.optionMenu.setSelectedItems(selectedNodes);
      nodeBound = board.computePartsBounds(selectedNodes)
    }
  }

  var dragCreatingTool = board.toolManager.findTool("DragCreating");
  var rescalingTool = board.toolManager.findTool("Rescaling");

  var canShow = selectedNodes.length > 0 && !dragCreatingTool.isActive && !board.toolManager.resizingTool.isActive && !rescalingTool.isActive && !board.toolManager.draggingTool.isActive && !board.toolManager.rotatingTool.isActive;

  if (canShow) {
    Vue.nextTick(function () {

      var diagramBound = board.viewportBounds;

      var x = (nodeBound.x - diagramBound.x) * board.scale;
      var y = (nodeBound.y - diagramBound.y) * board.scale;

      nodeBound.width *= board.scale;
      nodeBound.height *= board.scale;

      var documentWidth = document.documentElement.scrollWidth;
      var documentHeight = document.documentElement.scrollHeight;

      var menuWidth = editingMenuElement.scrollWidth;
      var menuHeight = editingMenuElement.scrollHeight

      x += (nodeBound.width * 0.5) - (menuWidth * 0.5);

      x = Math.max(x, 50);
      x = Math.min(x, documentWidth - menuWidth - 50);

      var spaceAtTop = y;
      var spaceAtBottom = documentHeight - (y + nodeBound.height);

      var margin = 20;
      if (spaceAtTop < menuHeight + margin) {
        y += (nodeBound.height + margin + 65);
      }
      else {
        y -= (menuHeight - 20);
        // y -= (menuHeight - 20);
      }

      if (spaceAtTop > documentHeight - y) {
        //.....   drop up

        editingMenuElement.classList.remove("dd-down");
        editingMenuElement.classList.add("dd-up");

      }
      else {
        //.....   drop down 
        editingMenuElement.classList.remove("dd-up");
        editingMenuElement.classList.add("dd-down");
      }

      editingMenuElement.style.left = x + "px";
      editingMenuElement.style.top = y + "px";

    });
  }
  // }
  else {
    editingMenuElement.classList.remove("show-menu");
  }
}

function hideNodeEditingMenu() {
  var editingMenuElement = document.getElementById("node-editing-options");
  editingMenuElement.classList.remove("show-menu");
}

function updateNodeEditingMenu() {

  var editingMenuElement = document.getElementById("node-editing-options");
  editingMenuElement.classList.add("show-menu");
  var selectedNodes = [];
  board.selection.each(function (node) {
    selectedNodes.push(node);
  });
  var nodeBound;
  if (selectedNodes.length > 0) {
    if (selectedNodes.length == 1) {
      var node = selectedNodes[0];
      nodeBound = node.getDocumentBounds().copy();
    }
    else {
      nodeBound = board.computePartsBounds(selectedNodes)
    }
  }

  var dragCreatingTool = board.toolManager.findTool("DragCreating");
  var rescalingTool = board.toolManager.findTool("Rescaling");

  var canShow = selectedNodes.length > 0 && !dragCreatingTool.isActive && !board.toolManager.resizingTool.isActive && !rescalingTool.isActive && !board.toolManager.draggingTool.isActive && !board.toolManager.rotatingTool.isActive;

  if (canShow) {
    Vue.nextTick(function () {

      var diagramBound = board.viewportBounds;

      var x = (nodeBound.x - diagramBound.x) * board.scale;
      var y = (nodeBound.y - diagramBound.y) * board.scale;

      nodeBound.width *= board.scale;
      nodeBound.height *= board.scale;

      var documentWidth = document.documentElement.scrollWidth;
      var documentHeight = document.documentElement.scrollHeight;

      var menuWidth = editingMenuElement.scrollWidth;
      var menuHeight = editingMenuElement.scrollHeight

      x += (nodeBound.width * 0.5) - (menuWidth * 0.5);

      x = Math.max(x, 50);
      x = Math.min(x, documentWidth - menuWidth - 50);

      var spaceAtTop = y;
      var spaceAtBottom = documentHeight - (y + nodeBound.width);

      var margin = 20;
      if (spaceAtTop < menuHeight + margin) {
        y += (nodeBound.height + margin + 65);
        //.... down
        editingMenuElement.classList.remove("dd-down");
        editingMenuElement.classList.add("dd-up");
      }
      else {
        //.... up
        editingMenuElement.classList.remove("dd-up");
        editingMenuElement.classList.add("dd-down");
        y -= (menuHeight - 20);
      }

      editingMenuElement.style.left = x + "px";
      editingMenuElement.style.top = y + "px";

    });
  }
  // }
  else {
    editingMenuElement.classList.remove("show-menu");
  }
}

function highlightGroup(e, grp, prevOrNext, show) {

  const adornment = getGroupHighlightAdornment();
  if (show) {
    // const part = board.toolManager.draggingTool.currentPart;
    if (!grp.isHighlighted) {
      grp.isHighlighted = true;
      adornment.adornedObject = grp;
      grp.addAdornment("Highlighted", adornment);
    }

    var notAllowedItems = {};
    if (grp.data && grp.data.notAllowedItems) {
      _.each(grp.data.notAllowedItems, item => {
        notAllowedItems[item] = true;
      });
    }
    var isValidDrop = true;
    board.selection.each(node => {
      if (notAllowedItems[node.data.category]) {
        isValidDrop = false;
      }
    });
    if (isValidDrop) {

    }
    var highlightColor = isValidDrop ? "dodgerblue" : "red";
    var object = adornment.findObject("Rectangle");
    if (object != null) {
      board.commit(() => {
        object.stroke = highlightColor;
      }, null);
    }

  } else {
    grp.removeAdornment("LinkingToolHover");
    adornment.adornedObject = null;
    grp.isHighlighted = false;
  }
}

function focusOnNode(node) {  // node is optional
  // If no node is given, choose a node at random, and select it.
  if (!node) {
    var arr = board.model.nodeDataArray;
    var data = arr[Math.floor(Math.random() * arr.length)];
    node = board.findNodeForData(data);
  }
  if (!node) return;
  board.select(node);

  // Set up an Animation that shows the node significantly larger than normal
  // and then scales it back down to normal.
  // This intentionally does not operate on the selected node itself,
  // but on a temporary copy of it, so that the node and the model are unaffected.
  var focus1 = node.copy();
  focus1.layerName = "Tool";
  focus1.isInDocumentBounds = false;
  focus1.locationSpot = go.Spot.Center;
  focus1.location = node.actualBounds.center;
  // Figure out how large to scale it initially; assume maximum is one third of the viewport size
  var w = Math.max(node.actualBounds.width, 1);
  var h = Math.max(node.actualBounds.height, 1);
  var viewscale = Math.max(board.viewportBounds.width / w, board.viewportBounds.height / h) / 3;
  // Now create the Animation showing the temporary node scaled initially at VIEWSCALE
  var anim = new go.Animation();
  anim.addTemporaryPart(focus1, board);
  board.scale = 1

  // board.scale = localStorage.getItem(vueGoInstance.boardId +"-boardScale")
  // anim.add(focus1, "scale", viewscale, 1.0);  // and animating down to scale 1.0
  // This animation occurs concurrently with the scrolling animation.
  anim.duration = board.animationManager.duration + 1000;
  anim.start();
  // Meanwhile, make sure that the node is in the viewport, so the user can see it
  board.commandHandler.scrollToPart(node);
}

function addBulkNote(notesList) {

  _.each(notesList, note => {
    if (note.size) {
      if (!note.scale) {
        note.scale = 1;
      }
      var size = go.Size.parse(note.size);
      size = new go.Size(200 , 200);
      // note.scale = board.scale / note.scale;
      note.size = go.Size.stringify(size);
      // note.scale = 1;
    }
  });

  board.startTransaction(MOD_TRNS_NODE_BULK_ADD);
  board.model.addNodeDataCollection(notesList);
  board.commitTransaction(MOD_TRNS_NODE_BULK_ADD);
  board.clearSelection();

  var nodesKeyMap = {};
  _.each(notesList, node => {
    nodesKeyMap[node.key] = true;
  });
  var it = board.nodes.iterator;
  while (it.next()) {
    var item = it.value;
    if (nodesKeyMap[item.key]) {
      delete nodesKeyMap[item.key];
      item.isSelected = true;
      if (item.data.category === "NOTE") {
        var auto = item.data.textSize === "Auto";
        adjustAutoFont(item, auto);
      }
    }
    if (_.isEmpty(nodesKeyMap)) {
      break;
    }
  }
  board.raiseDiagramEvent("ChangingSelection", board.selection);

  board.zoomToFit();
}

function onNodeCreated(node) {
  if (node.data) {
    if (node.data.category === "TEXT") {
      var textBlock = node.findObject("textBlock");
      if (textBlock != null) {
        board.commandHandler.editTextBlock(textBlock);
      }
      vueGoInstance.onNodeCreate();
    }
    checkForDropInFrameOnPasteMap[node.__gohashid] = true;
  }
}

//.............................................


//..............................................

var zoomAnimationLock = true;
function zoomToFitNodeWithKey(nodeKey, animated, focusScale) {

  var node = board.findNodeForKey(nodeKey);

  var rect = node.actualBounds.copy();
  rect.grow(rect.height / focusScale, rect.width / focusScale, rect.height / focusScale, rect.width / focusScale);
  // Copy and modify the new viewport rect so the new group takes up ~2/3rds of the screen
  var width = rect.width;
  var height = rect.height;
  var viewWidth = board.viewportBounds.width;
  var viewHeight = board.viewportBounds.height;

  var viewWidthN = board.viewportBounds.width * board.scale;

  var scale = Math.min((viewWidth * board.scale) / width, (viewHeight * board.scale) / height); // Sanity check scale value

  var viewCenterX = (viewWidthN / scale) * 0.5;

  var position = new go.Point(rect.center.x - viewCenterX, rect.y);

  if (animated) {

    var currentPosition = board.position.copy();
    var currentScale = board.scale;

    // Build an animation from the current to the newly calc'd values and animate!
    var animation = new go.Animation();
    animation.duration = 1200;
    animation.easing = go.Animation.EaseOutQuad;
    animation.add(board, "scale", currentScale, scale);
    animation.add(board, "position", currentPosition, position);
    animation.start();
  }
  else {
    board.scale = scale;
    board.position = position;
  }
}

function zoomToFitRect(rect, animated, focusScale, duration) {

  rect.grow(rect.height / focusScale, rect.width / focusScale, rect.height / focusScale, rect.width / focusScale);
  // Copy and modify the new viewport rect so the new group takes up ~2/3rds of the screen

  var width = rect.width;
  var height = rect.height;

  var viewWidth = board.viewportBounds.width;
  var viewHeight = board.viewportBounds.height;

  var viewWidthN = board.viewportBounds.width * board.scale;

  var scale = Math.min((viewWidth * board.scale) / width, (viewHeight * board.scale) / height); // Sanity check scale value

  var viewCenterX = (viewWidthN / scale) * 0.5;

  // var position = new go.Point(rect.center.x - viewCenterX, rect.y);
  var position = new go.Point(rect.x, rect.y);

  if (animated) {

    var currentPosition = board.position.copy();
    var currentScale = board.scale;

    // Build an animation from the current to the newly calc'd values and animate!
    var animation = new go.Animation();
    animation.duration = duration;
    animation.easing = go.Animation.EaseLinear;
    animation.add(board, "scale", currentScale, scale);
    // animation.add(board, "position", currentPosition, position);
    animation.start();
  }
  else {
    board.scale = scale;
    board.position = position;
  }
}

function zoomToFitFrame(frameRect) {

  var viewPort = board.viewportBounds.x + board.viewportBounds.width;
  var viewPortDelta = (frameRect.x + frameRect.width + 20) - viewPort;
  if (viewPortDelta > 0) {
    var rect = new go.Rect(board.viewportBounds.x, board.viewportBounds.y, board.viewportBounds.width + viewPortDelta, board.viewportBounds.height);
    zoomToFitRect(rect, true, 10.0, 500);
  }

}

function initializeBoard() {
  // if (pusher.connection.state === "disconnected") {
  //   pusher.connect();
  // }
  pusherConnect();
  // var gridDotSpacingSize = 30;
  // var gridDotSize = 2;

  var timeSincePageLoad = new Date().getTime();
  //go.Diagram.inherit(ContinuedTextEditingTool, go.TextEditingTool);
  var lockNodes = [];

  board = $gojs(go.Diagram, "board", {
	//layout: null,
    //padding: 20,  // extra space when scrolled all the way
    handlesDragDropForTopLevelParts: true,
    commandHandler: new DrawCommandHandler(),  // defined in DrawCommandHandler.js
    minScale: 0.01,  // so that the contents and the grid cannot appear too small
    maxScale: 4,
    scrollMargin: 3000,

    clickCreatingTool: new CustomClickCreatingTool(),
    clickSelectingTool: new CustomClickSelectingTool(),
    draggingTool: new GuidedDraggingTool(),

    "draggingTool.horizontalGuidelineColor": "blue",
    "draggingTool.verticalGuidelineColor": "blue",
    "draggingTool.centerGuidelineColor": "green",
    "draggingTool.guidelineWidth": 1,
    "draggingTool.dragsLink": false,
    "draggingTool._searchDistance": 10000,
    "draggingTool.doActivate": function () {           // upon drag start send push request to lock selected node
      go.DraggingTool.prototype.doActivate.call(this);
        board.selection.each(function (part) {
            if (part instanceof go.Node && part.layerName === "Foreground") {
                board.model.setDataProperty(part.data, "zOrder", getNextZOrder());
            }
        });
      lockNodes = [];
      board.selection.each(function (node) {
        lockNodes.push({ "key": node.data.key, "location": node.location });
      });
      if (vueGoInstance.isPublicLinkUrl) {
        pushDragLock(lockNodes, "1", vueGoInstance.anonymousUser.name);
      }
      else {
        pushDragLock(lockNodes, loggedInUser.id, loggedInUser.firstName);
      }
    },

    linkingTool: new CustomLinkingTool(),
    "linkingTool.isUnconnectedLinkValid": true,
    "linkingTool.portGravity": 20,
    "linkingTool.temporaryFromNode": getTemporaryNodes(),
    "linkingTool.temporaryToNode": getTemporaryNodes(),

    "relinkingTool.isUnconnectedLinkValid": true,
    "relinkingTool.portGravity": 20,
    "relinkingTool.fromHandleArchetype": getRelinkFromHandle(),
    "relinkingTool.toHandleArchetype": getRelinkToHandle(),
    "relinkingTool.temporaryFromNode": getTemporaryNodes(),
    "relinkingTool.temporaryToNode": getTemporaryNodes(),

    "linkReshapingTool.handleArchetype": getLinkReshapingHandle(),

    "toolManager.mouseWheelBehavior": go.ToolManager.WheelScroll,
    "draggingTool.isGridSnapEnabled": false,
    "draggingTool.isGridSnapRealtime": false,

    resizingTool: new VZResizeMultipleTool(),  // defined in ResizeMultipleTool.js
    "resizingTool.isGridSnapEnabled": false,

    rotatingTool: new RotateMultipleTool(),  // defined in RotateMultipleTool.js
    "rotatingTool.handleAngle": 270,
    "rotatingTool.handleDistance": 30,
    "rotatingTool.snapAngleMultiple": 15,
    "rotatingTool.snapAngleEpsilon": 15,
    "undoManager.isEnabled": true,  // enable undo & redo

    mouseDrop: function (e) {
      // when the selection is dropped in the diagram's background,
      // make sure the selected Parts no longer belong to any Group
      var frameId;
      var isLocked = false;
      e.diagram.selection.each(function (node) {
        frameId = node.data.group;
        if (node.data && node.data.lock) {
          isLocked = true;
        }
      });
      if (isLocked) {
        e.diagram.currentTool.doCancel();
      }else {
        var ok = e.diagram.commandHandler.addTopLevelParts(e.diagram.selection, true);
        if (ok) {
          e.diagram.selection.each(function (n) {
            if (n.data.category === "PREVIEW") return;
            if (n.data.group === undefined) {
              board.model.setDataProperty(n.data, "group", "none");
            }
            if (framesMap.size > 0 && frameId && frameId !== "none") {
              var frameDiagram = framesMap.get(frameId.toString());
              if (frameDiagram) {
                frameDiagram.model.removeNodeData(n.data);
              }
            }
          });
        }
        if (!ok) e.diagram.currentTool.doCancel();
      }
    },
    "commandHandler.archetypeGroupData": { text: "Group", isGroup: true, color: "lightblue" },
    "animationManager.isEnabled": false,
    "SelectionMoved": function (e) { e.diagram.layoutDiagram(true); },

    "textEditingTool.canStart": function () {
      var edit = go.TextEditingTool.prototype.canStart.call(this);
      return edit && vueGoInstance.userRights.canWrite;
    },
    "textEditingTool.doActivate": function () {
      go.TextEditingTool.prototype.doActivate.call(this);

      const editor = this.currentTextEditor.L;
		if (editor) {
			setTimeout(() => {
				const length = editor.value.length;
				editor.selectionStart = length; // Set cursor at end
				editor.selectionEnd = length;   // Deselect all text
			}, 10);
		}

      if (this.textBlock) {
        var _this = this;
        board.model.commit(function () { _this.textBlock.opacity = 0.0 }, null);

        if (this.textBlock && this.textBlock.part && this.textBlock.part.data) {

          var userId   = vueGoInstance.isPublicLinkUrl ? "1" : loggedInUser.id;
          var userName = vueGoInstance.isPublicLinkUrl ? vueGoInstance.anonymousUser.name : loggedInUser.firstName;

          if (this.textBlock.part.data.category === "Arrow") {
            pushLinkTextEditLock(this.textBlock.part, this.textBlock.part.data.key, userId, userName);
          }
          else {
            pushNodeTextEditLock(this.textBlock.part, userId, userName);
          }
        }
      }
    },
    "textEditingTool.doDeactivate": function () {

      var node = this.textBlock.part;

      if (this.textBlock) {
        var _this = this;
        board.model.commit(function () { _this.textBlock.opacity = 1.0 }, null);

        if (node.data.category === "TEXT" && _.isEmpty(this.textBlock.text)) {

          board.model.startTransaction(null);
          board.model.removeNodeData(node.data);
          board.model.commitTransaction(null);

        }
        else {

          if (node.data.category === "TEXT" && !node.data._id) {
            //...... create
            createNode([node.data]);
          }
          else {
            //...... update
            var collection = [];
            var map = {};
            putEventInCollection(node.data, "text", this.textBlock.text, collection, map);
            var data = collection[0];
            delete data.data;
            if (node.data.category === "Arrow") {
              updateLinkProperty([data]);
            }
            else {
              updateNodeProperty([data]);
            }
          }

          // board.model.startTransaction(MOD_TRNS_NODE_UPD_TEXT);
          // var previousValue = node.data.text;
          // node.data.text = _this.textBlock.text;
          // board.model.updateTargetBindings(node.data);
          // board.model.commitTransaction(MOD_TRNS_NODE_UPD_TEXT);
          // board.model.raiseDataChanged(node.data, "text", previousValue, _this.textBlock.text);
        }

        if (this.textBlock.part && this.textBlock.part.data) {
          var userName = vueGoInstance.isPublicLinkUrl ? vueGoInstance.anonymousUser.name : loggedInUser.firstName;
          pushUnlockTextEdit(this.textBlock.part.key, userName);
        }
      }
      go.TextEditingTool.prototype.doDeactivate.call(this);
    }
  });



    board.toolManager.doMouseDown = function() {
        const diagram = this.diagram;
        const input = diagram.lastInput;
        const clickedPart = diagram.findPartAt(input.documentPoint, false);
        // Only activate if in link mode and no node selected
        if (vueGoInstance.actionType === 'link' && (!clickedPart || !(clickedPart instanceof go.Node))) {
            const pt = diagram.lastInput.documentPoint.copy();
            const tempKey = getNewUUID();
            vueGoInstance.currentTempNodeKey = tempKey;

            const tempNodeData = {
                key: tempKey,
                category: "SHAPE",
                loc: go.Point.stringify(pt),
                size: go.Size.stringify(new go.Size(10, 10)),  // small size
                fill: "white",
                stroke: "transparent",
                figure: "Circle",
                fromLinkable: true,
                toLinkable: true,
                portId: ""
            };

            diagram.commit(() => {
                diagram.model.addNodeData(tempNodeData);
                // const tempNodeData = {
                //     key: tempKey, // unique key every time
                //     category: "SHAPE",
                //     loc: go.Point.stringify(pt),
                //     size: go.Size.stringify(new go.Size(10, 10)),
                //     fill: "white",
                //     stroke: "transparent",
                //     fromLinkable: true,
                //     toLinkable: true,
                //     portId: "",
                // };
                // diagram.model.addNodeData({
                //     key: tempKey, // unique key every time
                //     category: "HIDDEN",
                //     loc: go.Point.stringify(pt),
                //     size: go.Size.stringify(new go.Size(10, 10)),
                // });

                setTimeout(() => {
                    const tempNode = diagram.findNodeForKey(tempKey);
                    if (tempNode) {

                        startLinkTool(tempNode);
                    }
                }, 0);
            }, null);

            return; // skip default handling
        }

        // Fall back to default behavior
        go.ToolManager.prototype.doMouseDown.call(this);
    };

    board.toolManager.linkingTool.linkValidation = (fromnode, fromport, tonode, toport) => {
    if (fromnode == null) {
      return false;
    }
    return true;
  };
    board.toolManager.rotatingTool.handleArchetype =
        $gojs(go.Panel, "Spot",
            // Actual rotation handle (visible blue circle)
            $gojs(go.Shape, "Circle", {
                desiredSize: new go.Size(16, 16),
                fill: "transparent",
                stroke: "transparent",
                strokeWidth: 2
            }),


            $gojs(go.Picture, {
                source: "assets/icons/rotate-ccw.svg",
                desiredSize: new go.Size(12, 12),
                alignment: go.Spot.Center,
                alignmentFocus: go.Spot.Center
            }),

            // Transparent hitbox to make clicking easier
            $gojs(go.Shape, "Circle", {
                desiredSize: new go.Size(30, 30),
                fill: "transparent",
                stroke: null,
                cursor: "pointer",
                isActionable: false
            })
        );

  board.addDiagramListener("ClipboardPasted", function (event) {
    if (event.subject) {
      event.subject.each(node => {
        onNodeCreated(node);
      });
    }
  });

    board.toolManager.dragSelectingTool = new RealtimeDragSelectingTool();
  board.toolManager.dragSelectingTool.isPartialInclusion = false;

  board.toolManager.textEditingTool.defaultTextEditor = window.TextEditor;
  board.toolManager.mouseDownTools.add(new RescalingTool());

  board.animationManager.isEnabled = true;
  //board.defaultCursor = "url(assets/icons/collab/pointer.svg), default";
  // board.toolManager.mouseDownTools.add($gojs(LinkShiftingTool));
  initialiseMouseMoveListenerForLinkingTool();

  var selectionBox = $gojs(go.Part,
    { layerName: "Tool", selectable: false },
    $gojs(go.Shape,
      { name: "SHAPE", fill: null, stroke: "dodgerblue", strokeWidth: 2, strokeDashArray: [5, 3] },
      new go.Binding("strokeWidth", "scale", function (scale) { 2 / scale }).ofModel()
    )
  );
  board.toolManager.dragSelectingTool.box = selectionBox;

  //menu
  var draggingLock = false;
  var streaming = false;
  // var lockArray = [];
  board.toolManager.draggingTool.doMouseMove = function () {
    //logic to save dragging node in collection and sent push by scheduler
    // var selectedNode = board.selection;
    // if (selectedNode.count < 6) {
    //   var totalNodes = 0;
    //   var streamingNodes = [];
    //   selectedNode.each(function (n) {
    //     if (n instanceof go.Node || n instanceof go.Part) {
    //       // board.startTransaction("moved");
    //       // // var lockByLocation = go.Point.stringify(go.Point.parse(n.data.loc).add(go.Point.parse(n.data.size)))
    //       // board.model.setDataProperty(n.data, "moved", true);
    //       // board.commitTransaction("moved");
    //       if (n.data.category === "FRAME") {
    //         var it = n.memberParts
    //         totalNodes = totalNodes + it.count;
    //
    //         streamingNodes.push({ "key": n.data.key, "category": "FRAME", "location": n.location })
    //         // var reqData = {"key":n.data.key, "synId":synId,"eventType":"frameMove","category":"node",
    //         //     "position":n.location,"cursorKey": loggedInUser.id,
    //         //     "cursorLocation": go.Point.stringify(board.lastInput.documentPoint),
    //         //     "lockBy": loggedInUser.firstName,"lockLocation":lockByLocation,
    //         //     "overlayLocation":n.data.loc, "overlaySize": n.data.size}
    //         // sendSocketRequest(reqData)
    //       } else {
    //         totalNodes++;
    //         streamingNodes.push({ "key": n.data.key, "location": n.location })
    //         // var reqData = {
    //         //     "key": n.data.key, "synId": synId, "eventType": "mouseDragMove","category":"node",
    //         //     'x': n.location.x, 'y': n.location.y, "cursorKey": loggedInUser.id,
    //         //     "cursorLocation": go.Point.stringify(board.lastInput.documentPoint),
    //         //     "lockBy": loggedInUser.firstName,"lockLocation":lockByLocation,
    //         //     "overlayLocation":n.data.loc, "overlaySize": n.data.size
    //         // }
    //         // sendSocketRequest(reqData)
    //       }
    //     }
    //   });
    //   if (totalNodes < 10) {
    //     var reqData = {
    //       "synId": synId, "eventType": "dragMove", "category": "node",
    //       "cursorKey": loggedInUser.id, "lockBy": loggedInUser.firstName,
    //       "streamingNodes": streamingNodes
    //     }
    //     if (vueGoInstance.$route.params.loadTest) {
    //       for (i = 0; i < vueGoInstance.$route.params.count; i++) {
    //         pushData.set("dragMove", reqData);
    //         // sendSocketRequest(reqData);
    //       }
    //     } else {
    //       pushData.set("dragMove", reqData);
    //       // sendSocketRequest(reqData);
    //     }
    //     lockArray = streamingNodes;
    //     streaming = true;
    //   }
    // }
    // else if (selectedNode.count >= 6 || !streaming) {
    //   draggingLock = true;
    //   var lockNodes = [];
    //   selectedNode.each(function (n) {
    //     if (n instanceof go.Node || n instanceof go.Part) {
    //       // board.startTransaction("moved");
    //       // var lockByLocation = go.Point.stringify(go.Point.parse(n.data.loc).add(go.Point.parse(n.data.size)))
    //       // board.model.setDataProperty(n.data, "moved", true);
    //       // board.commitTransaction("moved");
    //       if (n.data.category === "FRAME") {
    //         lockNodes.push(n.data.key)
    //       } else {
    //         lockNodes.push(n.data.key)
    //       }
    //     }
    //   });
    //
    //   var reqData = {
    //     "synId": synId, "eventType": "dragMove", "category": "node",
    //     "cursorKey": loggedInUser.id, "lockBy": loggedInUser.firstName,
    //     "lockNodes": lockNodes
    //   }
    //   pushData.set("dragMove", reqData);
    //   // sendSocketRequest(reqData);
    //   lockArray = lockNodes;
    // }
    return go.DraggingTool.prototype.doMouseMove.call(this);
  };
  board.toolManager.doMouseMove = function () {
    go.ToolManager.prototype.doMouseMove.call(this);
    if (vueGoInstance.isPublicLinkUrl) {
      pushPointerLocation(board.lastInput.documentPoint, vueGoInstance.anonymousUser.email, vueGoInstance.anonymousUser.name, "#fffff");
    }
    else {
      pushPointerLocation(board.lastInput.documentPoint, loggedInUser.id, loggedInUser.firstName, loggedInUser.backgroundColor);
    }
    showHideAddSelectionAdronment();
    var diagram = this.diagram;

    if (vueGoInstance && vueGoInstance.tools.linkActive) {
      var latest = diagram.lastInput.documentPoint;
      var parts = diagram.findPartsNear(latest, 20, true);

      var tool = board.toolManager.findTool("DragCreating");
      if (tool != null) {

        tool.mouseHover();

        if (parts != null && parts.count > 0) {

          if (createLinkFromNode != null) {
            showPorts(createLinkFromNode, false);
          }
          var part = parts.first();
          createLinkFromNode = part;
          showPorts(createLinkFromNode, true);

        }
        else {
          if (createLinkFromNode != null) {
            showPorts(createLinkFromNode, false);
            createLinkFromNode = null;
          }
        }
      }
    }
  }
  board.toolManager.doMouseUp = function () {
    go.ToolManager.prototype.doMouseUp.call(this);

    if (vueGoInstance.isPublicLinkUrl) {
      pushUnlockNodes(lockNodes, vueGoInstance.anonymousUser.name);
    }
    else {
      pushUnlockNodes(lockNodes, loggedInUser.firstName);
      //	pushPointerLocation(board.lastInput.documentPoint, loggedInUser.id, loggedInUser.firstName, loggedInUser.backgroundColor);
    }
    //  pushUnlockNodes(lockNodes , loggedInUser);
    // lockNodes = [];

    //Unlock streaming nodes
    // if (draggingLock) {
    //   draggingLock = false;
    //   var lockData = { "lockNodes": lockArray, "key": "unlock", "category": "lock", "eventType": "disable", "lockBy": loggedInUser.firstName }
    //   pushData.set("dragMove", null);
    //   sendSocketRequest(lockData)
    //   lockArray = [];
    // } else if (streaming) {
    //   var lockData = { "key": "unlock", "streamingNodes": lockArray, "category": "lock", "eventType": "disable", "lockBy": loggedInUser.firstName }
    //   pushData.set("dragMove", null);
    //   sendSocketRequest(lockData)
    //   streaming = false;
    //   lockArray = [];
    //
    // }
  }

  board.addDiagramListener('LinkDrawn', function (event) {
    var link = event.subject;
    if (link) {
		link.routing = go.Link.Normal;
  		link.curve = go.Link.None;
      board.commit(function () {
        link.points = board.toolManager.linkingTool.temporaryLink.points;
      }, null);
    }
  });

  board.addDiagramListener('PartResized', function (event) {
    board.selection.each(function (node) {
      if (vueGoInstance.isPublicLinkUrl) {
        pushUnlockResizedNode(node.data.key, vueGoInstance.anonymousUser.name);
      } else {
        pushUnlockResizedNode(node.data.key, loggedInUser.firstName);
      }
    });
  });
  board.addDiagramListener('SelectionMoved', function (event) {
    if (previewMode) return;
  });
  board.addDiagramListener("ChangedSelection", function (event) {
    showNodeEditingMenu();
    vueGoInstance.subActionType = "none";
    showHideAddSelectionAdronment();
    updateMultiSelectionBox();
    showOrHideAdronmentControlls();
  });

  tempTextForAutoFont = go.GraphObject.make(go.Node, "Auto", { selectable: false },
    $gojs(go.TextBlock, { name: "textBlock", stroke: "transparent", pickable: false })
  );
  board.commit(function (){
    board.add(tempTextForAutoFont);
  },null);

  board.addDiagramListener("Modified", function (event) {
    vueGoInstance.enableUndoRedo();
  });
  board.addDiagramListener("LostFocus", function (event) {
    //   setTimeout(function(){event.diagram.focus();},200);
  });
  board.addDiagramListener("ViewportBoundsChanged", function (event) {

    var scale = board.scale;

    board.model.startTransaction(MOD_TRNS_BOARD_SCALE);
    board.model.set(board.model.modelData, "scale", scale);
    board.model.commitTransaction(MOD_TRNS_BOARD_SCALE);

    // board.toolManager.rotatingTool.handleDistance = 20 / scale;


    //.....................................................
    // if (board.scale > 1) {
    //   scale = 1 + board.scale * 0.25;
    // }
    // else {
    //   scale = 1 + board.scale * 0.25;
    // }

    // var _gridDotSpacingSize = gridDotSpacingSize / scale;
    // var _gridDotSize = gridDotSize / scale;

    // board.grid.gridCellSize = new go.Size(_gridDotSpacingSize, _gridDotSpacingSize);
    // var gridLine = board.grid.findObject("gridLine");
    // gridLine.strokeWidth = _gridDotSize;
    // gridLine.strokeDashArray = [_gridDotSize, _gridDotSpacingSize - _gridDotSize];

    //.................................................

    updateGridOnZoom();

    var currentTime = new Date().getTime();
    if (currentTime - timeSincePageLoad > 5000) {
      if (board.scale) {
        localStorage.setItem(vueGoInstance.boardId + "-boardScale", board.scale);
      }
      if (board.position) {
        localStorage.setItem(vueGoInstance.boardId + "-boardPosition", go.Point.stringify(board.position));
      }
    }

    //	localStorage.setItem(vueGoInstance.boardId + "-boardScale", board.scale);

    if (vueGoInstance) {
      vueGoInstance.onBoardScaleUpdated();
    }
    // if(previewMode){
    //     var preview = board.findNodeForKey("preview");
    //     if (preview) {
    //         previewOverlayCalculation(preview.desiredSize, preview.position);
    //         return;
    //     }
    // }else {
    showNodeEditingMenu();
    if (!event.subject.bounds.equals(event.diagram.viewportBounds) && vueGoInstance.attentionManagement.broadcast) {
      pushViewPortBroadcast(board.scale, board.position, vueGoInstance.boardId);
    }
    // }
  });
  // var canvas = document.getElementsByTagName('canvas');
  // canvas[0].setAttribute("id", "canID")
  // canvas[0].setAttribute("contenteditable","true")
  // document.getElementById('canID').onpaste = async function   (event){
  //     var items = (event.clipboardData  || event.originalEvent.clipboardData).items;
  //     event.preventDefault();
  //
  //     // find pasted image among pasted items
  //     var blob = null;
  //     for (var i = 0; i < items.length; i++) {
  //         console.log('type:------------',items[i].type)
  //
  //         if (items[i].type.indexOf("image") === 0) {
  //             blob = items[i].getAsFile();
  //         }else if(items[i].type.indexOf("text/plain") === 0){
  //             console.log('items[i]=================',items[i])
  //             blob = items[i].getAsFile();
  //             console.log('==========blob==============',blob)
  //             var blob1 = items[i].getAsString(function(s){
  //                 console.log('----------------s--------------------------------',s)
  //             });
  //             console.log('blob as string-------------------',blob1)
  //         }
  //     }
  //
  //     // load image if there is a pasted image
  //     if (blob !== null) {
  //         var reader = new FileReader();
  //         reader.onload = function(event) {
  //             console.log(event.target.text); // data url!
  //             console.log('event target----------------------',event.target.text)
  //             document.getElementById("pastedImage").src = event.target.result;
  //             //console.log('blob--------------',blob)
  //         };
  //
  //         reader.readAsDataURL(blob);
  //     }
  // }

  // board.commandHandler.copySelection = function(){
  // 		copyFlag = true;
  // 		navigator.clipboard.writeText("__%&^%$#!@$&^%$!@#$&*()^-__!@#$&*()^-__!@#$&*()^-__!@#$&*&&^%##$%&*(((*^%%$#$^&*(*&^%$%^&");
  // 		go.CommandHandler.prototype.copySelection.call(board.commandHandler);
  // 	}

  board.commandHandler.deleteSelection = function () {
    checkForDeleteCommand();
    hideNodeEditingMenu();
  };

  // keyboard shortcuts

  board.commandHandler.doKeyDown = function () {
    if (board.isReadOnly) return;
    var e = board.lastInput;
    var control = e.control || e.meta;
    var shift = e.shift;
    var key = e.key;

    shortcutKeysHandler(key, shift, control);

    if (e.event.key === "Enter") {
      var selectedNode = board.selection;
      var textBlock;
      selectedNode.each(
        function (n) {
          textBlock = n.findObject("TextBlock")
        }
      );
      if (board.commandHandler.canEditTextBlock(textBlock))
        board.commandHandler.editTextBlock(textBlock);
    }
    else {
      // call base method with no arguments
      go.CommandHandler.prototype.doKeyDown.call(board.commandHandler);
    }
  };
  // var creationToolBar = document.getElementById("leftnav");
  // if (creationToolBar != null) {

  board.toolManager.relinkingTool.copyLinkProperties = function (reallink, templink) {
    if (reallink === null || templink === null) return;
    templink.adjusting = reallink.adjusting;
    templink.corner = reallink.corner;
    var curve = reallink.curve;
    if (curve === go.Link.JumpOver || curve === go.Link.JumpGap) curve = go.Link.None;  // don't copy "jumping"
    templink.curve = curve;
    templink.curviness = reallink.curviness;
    templink.routing = reallink.routing;
    templink.smoothness = reallink.smoothness;
    templink.fromSpot = reallink.fromSpot;
    templink.fromEndSegmentLength = reallink.fromEndSegmentLength;
    templink.fromEndSegmentDirection = reallink.fromEndSegmentDirection;
    templink.fromShortLength = reallink.fromShortLength;
    templink.toSpot = reallink.toSpot;
    templink.toEndSegmentLength = reallink.toEndSegmentLength;
    templink.toEndSegmentDirection = reallink.toEndSegmentDirection;
    templink.toShortLength = reallink.toShortLength;
  };

  // This is the actual HTML context menu:
  nodeContextMenuElement  = document.getElementById("nodeContextMenu");
  boardContextMenuElement = document.getElementById("boardContextMenu");
  frameContextMenuElement = document.getElementById("frameContextMenu");

  // an HTMLInfo object is needed to invoke the code to set up the HTML nodeContextMenuElement
  var nodeContextMenu = $gojs(go.HTMLInfo, {
    show: function (obj, diagram, tool) {
      showContextMenu(obj, diagram, tool, nodeContextMenuElement);
    },
    hide: function () {
      hideContextMenu(nodeContextMenuElement);
    }
  });
  var frameContextMenu = $gojs(go.HTMLInfo, {
    show: function (obj, diagram, tool) {
      showContextMenu(obj, diagram, tool, frameContextMenuElement);
    },
    hide: function () {
      hideContextMenu(frameContextMenuElement);
    }
  });
  var boardContextMenu = $gojs(go.HTMLInfo, {
    show: function (obj, diagram, tool) {
      showContextMenu(obj, diagram, tool, boardContextMenuElement);
    },
    hide: function () {
      hideContextMenu(boardContextMenuElement);
    }
  });

  board.contextMenu = boardContextMenu;

  board.toolManager.linkingTool.isEnabled = false;

  // We don't want the div acting as a context menu to have a (browser) context menu!
  nodeContextMenuElement.addEventListener("contextmenu", function (e) {
    e.preventDefault();
    return false;
  }, false);

  // Group template
  var groupTemplate   = getFrameTemplate(frameContextMenu, nodeClicked);
  var textTemplate    = getTextTemplate(nodeContextMenu, nodeClicked);
  var simpleTemplate  = getSimpleNodeTemplate(nodeContextMenu, nodeClicked);
  var noteTemplate    = getNoteTemplate(nodeContextMenu, nodeClicked);
  var pictureTemplate = getPictureTemplate(nodeContextMenu, nodeClicked);
  var cursorTemplate  = getCursorTemplate();
  var lockedByOverlayTemplate = getLockedByOverlayTemplate();    // template for locked by during live streaming
  var lockOverlayTemplate = getLockOverlayTemplate();  // template for lock during live streaming

  // var previewOverlayTemplate =
  //     $gojs(go.Node, "Auto",{ groupable:false, resizable:true, minSize: new go.Size(5, 5),
  //             movable: true, deletable: false},
  //         $gojs(go.Shape, {stretch: go.GraphObject.Fill, fill:"lightgray", strokeWidth: 0},
  //             new go.Binding("opacity")
  //         ),
  //         new go.Binding("selectable"),
  //         new go.Binding("desiredSize", "size", go.Size.parse),
  //         new go.Binding("position", "loc", go.Point.parse),
  //         new go.Binding("isSelected", "selected"),
  //         new go.Binding("visible")
  //     );

  var nodeTemplateMap = new go.Map(); // In TypeScript you could write: new go.Map<string, go.Node>();
  nodeTemplateMap.add("SHAPE", simpleTemplate);
  nodeTemplateMap.add("NOTE", noteTemplate);
  nodeTemplateMap.add("TEXT", textTemplate);
  nodeTemplateMap.add("CURSOR", cursorTemplate);
  nodeTemplateMap.add("LOCKEDBYOVERLAY", lockedByOverlayTemplate);
  nodeTemplateMap.add("LOCKOVERLAY", lockOverlayTemplate);
  nodeTemplateMap.add("PICTURE", pictureTemplate);
  // nodeTemplateMap.add("PREVIEW",previewOverlayTemplate);

  board.nodeTemplateMap = nodeTemplateMap;

  board.nodeTemplate = noteTemplate; // default template

  board.linkTemplate = getLinkTemplateArrow();
  board.linkTemplateMap = new go.Map();
  board.linkTemplateMap.add("Arrow", getLinkTemplateArrow());

  var groupTemplateMap = new go.Map();
  groupTemplateMap.add("FRAME", groupTemplate);
  board.groupTemplateMap = groupTemplateMap;


  // Add an instance of the custom tool defined in DragCreatingTool.js.
  // This needs to be inserted before the standard DragSelectingTool,
  // which is normally the third Tool in the ToolManager.mouseMoveTools list.
  // Note that if you do not set the DragCreatingTool.delay, the default value will
  // require a wait after the mouse down event.  Not waiting will allow the DragSelectingTool
  // and the PanningTool to be able to run instead of the DragCreatingTool, depending on the delay.
  board.toolManager.mouseMoveTools.insertAt(2,
    $gojs(DragCreatingTool,
      {
        isEnabled: false,  // disabled by the checkbox
        createLink: false,
        delay: 0,  // always canStart(), so PanningTool never gets the chance to run
        /*box: $gojs(go.Part,
          { layerName: "Tool" },
          $gojs(go.Shape,
            { name: "TEMP_SHAPE", fill: null, stroke: "lightblue", strokeWidth: 2, figure: vueGoInstance.shapeToDraw })
        ),*/
        archetypeNodeData: { fill: "white" }, // initial properties shared by all nodes
        archetypeLinkData: { fill: "white" }, // initial properties shared by all nodes
        insertPart: function (bounds) {  // override DragCreatingTool.insertPart
          // use a different color each time
          return DragCreatingTool.prototype.insertPart.call(this, bounds);
        },
        actionCompleted: function () {
          DragCreatingTool.prototype.actionCompleted.call(this);
          vueGoInstance.cancelCreateLinkTool();
          if (createLinkFromNode != null) {
            createLinkFromNode = null;
          }
        },
      }));

  board.nodeTemplateMap.add("FreehandDrawing", getFreehandDrawingTemplate());

  // create drawing tool for board, defined in FreehandDrawingTool.js
  var tool = new FreehandDrawingTool();
  // provide the default JavaScript object for a new polygon in the model
  tool.archetypePartData =
    { border: "green", thickness: 1, category: "FreehandDrawing" };
  // allow the tool to start on top of an existing Part
  tool.isBackgroundOnly = false;
  // install as first mouse-move-tool
  board.toolManager.mouseMoveTools.insertAt(0, tool);

  var eraserTool = new EraserTool();
  eraserTool.isEnabled = false;
  board.toolManager.mouseDownTools.insertAt(0, eraserTool);

  board.addModelChangedListener(function (evt) {
    //ignore in Preview mode
	vueGoInstance.enableUndoRedo();
    if (previewMode) return;
    if (vueGoInstance.boardDetail.board.locked) return;

    if (vueGoInstance.boardDetail.board.type == 'template') {
      if (evt.change === go.ChangedEvent.Insert && evt.modelChange === "nodeDataArray") {
        if (evt.newValue) {
          evt.newValue.boardId = '';
          evt.newValue._id = '';
        }
      }
      return;
    }
    // ignore unimportant Transaction events
    if (!evt.isTransactionFinished) return;

    var txn = evt.object;  // a Transaction
    if (txn === null) return;
    if (txn.name === GEN_TRNS_LINK_CHANGE || txn.name === GEN_TRNS_LOC_CHANGE || txn.name === GEN_TRNS_INITIAL_LAYOUT) return;
    // iterate over all of the actual ChangedEvents of the Transaction

    var nodeChangeEvents = [];
    var nodeChangeEventsMap = {};

    var linkChangeEvents = [];
    var linkChangeEventsMap = {};

    var linkCreateEvents = [];
    var nodeCreateEvents = [];
    var linkDeleteEvents = [];
    var nodeDeleteEvents = [];
    var eventPropertyName = evt.propertyName;
    var transactionName = txn.name;

    if ((txn.name === GEN_TRNS_DRAG_CREATING || txn.name === MOD_TRNS_FRAME_ADD || txn.name === MOD_TRNS_NODE_DUPLICATE) && eventPropertyName === "FinishedUndo") {
      txn.changes.each(function (e) {
        if (e.change === go.ChangedEvent.Insert && e.modelChange === "nodeDataArray") {
          nodeDeleteEvents.push(e.newValue);
        }
        if (e.change === go.ChangedEvent.Insert && e.modelChange === "linkDataArray") {
          linkDeleteEvents.push(e.newValue);
        }
      });
      if (!_.isEmpty(nodeDeleteEvents)) {
        deleteNode(nodeDeleteEvents);
      }
      if (!_.isEmpty(linkDeleteEvents)) {
        deleteLink(linkDeleteEvents);
      }
      return;
    }
    if (txn.name === "Linking" && eventPropertyName === "FinishedUndo") {
      txn.changes.each(function (e) {
        if (e.change === go.ChangedEvent.Insert && e.modelChange === "linkDataArray") {
          linkDeleteEvents.push(e.newValue)
        }
      });
      if (!_.isEmpty(linkDeleteEvents)) {
        deleteLink(linkDeleteEvents);
      }
      return;
    }
    txn.changes.each(function (e) {
      // record node insertions and removals
      if (e.change === go.ChangedEvent.Property) {
        if (e.object) {
          if (e.object.part && e.object.part.category === "TEXT" && e.propertyName === "desiredSize") {
            var width = e.newValue.width;
            //..........................................................
            putEventInCollection(e.object.part.data, "width", width, nodeChangeEvents, nodeChangeEventsMap);
            //..........................................................
          }
          if (e.object.part && e.object.part.category === "FRAME" && e.propertyName === "text") {

            //..........................................................
            putEventInCollection(e.object.part.data, "text", e.newValue, nodeChangeEvents, nodeChangeEventsMap);
            //..........................................................

            if (framesMap.size > 0) {
              var frameDiagram = framesMap.get(e.object.part.data.key.toString())
              if (frameDiagram) {
                frameDiagram.model.nodeDataArray.forEach(node => {
                  if (node.category === "FRAME") node.text = e.newValue
                })
              }
            }
          }

          if (e.object.category === "TEXT" || e.object.category === "NOTE" || e.object.category === "SHAPE" || e.object.category === "FRAME" || e.object.category === "FreehandDrawing" || e.object.category === "PICTURE") {

            if (framesMap.size > 0 && e.object.group && e.object.group !== "none") {
              var frameDiagram = framesMap.get(e.object.group.toString())
              if (frameDiagram) {
                frameDiagram.updateAllTargetBindings();
              }
            }
            if (e.object.category === "NOTE" && e.propertyName === "emoji") {
              var reactions = _.cloneDeep(e.object.reactions);
              //..........................................................
              putEventInCollection(e.object, "reactions", reactions, nodeChangeEvents, nodeChangeEventsMap);
              //..........................................................

            } else if (e.propertyName === "size") {

              //..........................................................
              putEventInCollection(e.object, "size", e.object.size, nodeChangeEvents, nodeChangeEventsMap);
              putEventInCollection(e.object, "loc", e.object.loc, nodeChangeEvents, nodeChangeEventsMap);
              //..........................................................

            } else {
              var data = e.object.data ? e.object.data : e.object;
              if (data && nodePropertiesMap[e.propertyName]) {
                if (e.propertyName === "resizable" || e.propertyName === "movable") {
                  putEventInCollection(data, "lock", data.lock, nodeChangeEvents, nodeChangeEventsMap);
                }
                else {
                  //..........................................................
                  putEventInCollection(data, e.propertyName, data[e.propertyName], nodeChangeEvents, nodeChangeEventsMap);
                  //..........................................................
                }
              }
            }
          } else if (e.object.category === "Arrow" || e.object.text) {
            if (e.modelChange === "linkFromKey") {

              putEventInCollection(e.object, "from", e.newValue, linkChangeEvents, linkChangeEventsMap);
              putEventInCollection(e.object, "fromPort", e.object.fromPort, linkChangeEvents, linkChangeEventsMap);
              putEventInCollection(e.object, "points", e.object.points, linkChangeEvents, linkChangeEventsMap);
            } else if (e.modelChange === "linkToKey") {

              putEventInCollection(e.object, "to", e.newValue, linkChangeEvents, linkChangeEventsMap);
              putEventInCollection(e.object, "toPort", e.object.toPort, linkChangeEvents, linkChangeEventsMap);
              putEventInCollection(e.object, "points", e.object.points, linkChangeEvents, linkChangeEventsMap);
            } else if (e.modelChange === "linkFromPortId") {

              putEventInCollection(e.object, "fromPort", e.object.fromPort, linkChangeEvents, linkChangeEventsMap);
              putEventInCollection(e.object, "points", e.object.points, linkChangeEvents, linkChangeEventsMap);
            } else if (e.modelChange === "linkToPortId") {

              putEventInCollection(e.object, "toPort", e.object.toPort, linkChangeEvents, linkChangeEventsMap);
              putEventInCollection(e.object, "points", e.object.points, linkChangeEvents, linkChangeEventsMap);
            } else if (e.propertyName === "opacity" && e.newValue == 0) {
              putEventInCollection(e.object, "text", e.object.text, linkChangeEvents, linkChangeEventsMap);
            } else {

              var data = e.object.data ? e.object.data : e.object;

              if (data) {
                if (e.modelChange) {
                  putEventInCollection(data, e.modelChange, data[e.modelChange], linkChangeEvents, linkChangeEventsMap);
                }
                if (e.propertyName) {
                  putEventInCollection(data, e.propertyName, data[e.propertyName], linkChangeEvents, linkChangeEventsMap);
                }
              }
            }
          }
        }
      }
      else if (e.change === go.ChangedEvent.Insert && e.modelChange === "linkDataArray") {
        // createLink(e.newValue);
        if (e.newValue._id) delete e.newValue._id;
        linkCreateEvents.push(e.newValue);

        var toNode = board.model.findNodeDataForKey(e.newValue.to);
        var fromNode = board.model.findNodeDataForKey(e.newValue.from);
        if (framesMap.size > 0 && toNode && typeof toNode.group != 'undefined' && typeof fromNode.group != 'undefined') {
          if (toNode.group == fromNode.group) {
            var frameDiagram = framesMap.get(toNode.group.toString())
            if (frameDiagram) {
              frameDiagram.model.addLinkData(e.newValue);
            }
          }
        }
      }
      else if (e.change === go.ChangedEvent.Insert && e.modelChange === "nodeDataArray") {

        if (eventPropertyName === "CommittedTransaction" || eventPropertyName === "FinishedRedo") {

          if (e.newValue._id) delete e.newValue._id;
          nodeCreateEvents.push(e.newValue);

        } else if (eventPropertyName === "FinishedUndo") {

          if (e.newValue.category === "PICTURE") {
            nodeDeleteEvents.push(e.newValue);
          } else {
            nodeDeleteEvents.push(e.newValue);
          }
        }
      }
      else if (e.change === go.ChangedEvent.Remove && e.modelChange === "linkDataArray") {

        if (eventPropertyName === "FinishedUndo") {

          if (e.oldValue._id) delete e.oldValue._id;
          linkCreateEvents.push(e.oldValue);

        }
        else {

          linkDeleteEvents.push(e.oldValue);

          var toNode = board.model.findNodeDataForKey(e.oldValue.to);
          var fromNode = board.model.findNodeDataForKey(e.oldValue.from);
          if (framesMap.size > 0 && (toNode != null && fromNode != null)) {
            if (toNode.group == fromNode.group) {
              var frameDiagram = framesMap.get(toNode.group.toString())
              frameDiagram.model.removeLinkData(e.oldValue);
            }
          }
        }
      }
      else if (e.change === go.ChangedEvent.Remove && e.modelChange === "nodeDataArray") {

        if (e.oldValue._id && (eventPropertyName === "CommittedTransaction" || eventPropertyName === "FinishedRedo")) {
          nodeDeleteEvents.push(e.oldValue);
        } else if (eventPropertyName === "FinishedUndo") {
          nodeCreateEvents.push(e.oldValue);
        }
      }
    });

    //........ change events
    nodeChangeEvents = _.filter(nodeChangeEvents, node => {
      if (_.isEmpty(node._id) && transactionName !== "Paste") {
        if (node.category === "TEXT" && _.isEmpty(!node.text)) {
          nodeCreateEvents.push(node.data);
        }
        return false;
      }
      delete node.data;
      return true;
    });

    if (!_.isEmpty(nodeChangeEvents)) {
      updateNodeProperty(nodeChangeEvents)
    }
    if (!_.isEmpty(linkChangeEvents)) {
      var finalLinkChanges = linkChangeEvents.filter(link => {
        delete link.data;
        return link._id !== undefined;
      });
      if (finalLinkChanges.length > 0) {
        updateLinkProperty(finalLinkChanges);
      }
    }

    //.......  create events
    if (!_.isEmpty(nodeCreateEvents)) {

      nodeCreateEvents = _.filter(nodeCreateEvents, node => {
        return !(node.category === "TEXT" && _.isEmpty(node.text));
      });

      //...........   this is done for text duplication
      var tempMap = {};
      var _nodeCreateEvents=[];
      _.each(nodeCreateEvents, node=> {
        if (node.__gohashid) {
          if (!tempMap[node.__gohashid]) {
            tempMap[node.__gohashid] = true;
            _nodeCreateEvents.push(node);
          }
        }else {
          _nodeCreateEvents.push(node);
        }
      });

      if (!_.isEmpty(_nodeCreateEvents)) {
        createNode(_nodeCreateEvents)
      }
    }
    if (!_.isEmpty(linkCreateEvents)) {
      var newLinks = linkCreateEvents.filter(link => {
        return link._id == undefined;
      })
      createLink(newLinks)
    }

    //.......  delete events
    if (!_.isEmpty(nodeDeleteEvents)) {
      deleteNode(nodeDeleteEvents);
    }
    if (!_.isEmpty(linkDeleteEvents)) {
      deleteLink(linkDeleteEvents);
    }
  });
    board.commandHandler.copyToClipboard = function (parts) {
        if (!parts) parts = board.selection;
        const nodesOnly = new go.Set();
        parts.each(function (p) {
            if (p instanceof go.Node) nodesOnly.add(p);
        });
        go.CommandHandler.prototype.copyToClipboard.call(this, nodesOnly);
    };


    /*board.commandHandler.copyToClipboard = function (coll){
        go.CommandHandler.prototype.copyToClipboard.call(this, coll);
        this._lastPasteOffset.set(this.pasteOffset);
        var type = "text/html";
        var blob = new Blob(["text"], { type });
        var data = [new ClipboardItem({ [type]: blob })];
        navigator.clipboard.write(data);
    }
    window.addEventListener('clipboardchange', () => {
        console.log('Clipboard contents changed');
    });
    board.commandHandler.pasteFromClipboard = function (){
        var _this = this;
        var result = "";
        async function getClipboardContents() {
            try {
                // var text = await navigator.clipboard.readText();
                var clipBoard = {};
              await  navigator.clipboard.read().then((data) => {
                    for (let i = 0; i < data.length; i++) {
                        // if (false) {
                        //     // alert("Clipboard contains non-image data. Unable to access it.");
                        //     clipBoard.text =  navigator.clipboard.readText();
                        // }
                        // else
                        if(data[i].types.includes("text/plain")){
                            data[i].getType("text/plain").then(
                                v => {v.text().then(
                                    text => {
                                        clipBoard.text = text;
                                        board.model.addNodeData({
                                            "category" : "PICTURE",
                                            "source": text
                                        });
                                    })
                                })
                            _this.diagram.commandHandler.copyToClipboard(null)
                            return;
                        }
                        else if(data[i].types.includes("text/html")){
                            var coll = go.CommandHandler.prototype.pasteFromClipboard.call(_this);
                            // _this.diagram.moveParts(coll, _this._lastPasteOffset);
                            // _this._lastPasteOffset.add(_this.pasteOffset);
                            result =  coll;
                        }
                        else {
                            data[i].getType("image/png").then((blob) => {
                                // let formData = new FormData()
                                // formData.append('file', blob, 'file.png');
                                // console.log(formData.getAll('file'))
                                blob.arrayBuffer().then( buffer => {
                                    const data = _arrayBufferToBase64(buffer);
                                    uploadImageToS3(data);
                                    console.log(data)
                                })
                            });
                            _this.diagram.commandHandler.copyToClipboard(null)
                            return
                        }
                    }
                });
                console.log('Pasted content: ', clipBoard);
            } catch (err) {
                console.error('Failed to read clipboard contents: ', err);
            }
        }

        getClipboardContents();
        // console.log(board.commandHandler);
        // this.diagram.commandHandler.copyToClipboard(null)
        // return go.CommandHandler.prototype.pasteFromClipboard.call(board.commandHandler)
        return result;
    }*/
  board.addChangedListener(function (e) {
	vueGoInstance.enableUndoRedo();
    var url = window.location.pathname;
    if (previewMode) return;
    if (!e) {
      return;
    }
    if (e.change != go.ChangedEvent.Property) return;
    if (e.object && e.object.data != null && e.object.data.isEditable) {
      if (board.toolManager.resizingTool.canStart() && e.object.data._id && !streaming && !draggingLock) {
        var lockByLocation = go.Point.stringify(go.Point.parse(e.object.data.loc).add(go.Point.parse(e.object.data.size)))
        if (vueGoInstance.isPublicLinkUrl) {
          pushLockResizingNode(e.object.data.key, lockByLocation, "1", vueGoInstance.anonymousUser.name, e.object.data.loc, e.object.data.size)
        } else {
          pushLockResizingNode(e.object.data.key, lockByLocation, loggedInUser.id, loggedInUser.firstName, e.object.data.loc, e.object.data.size)
        }
      }
      var rescalingTool = board.toolManager.findTool("Rescaling");
      if (rescalingTool!=null && rescalingTool.canStart() && e.object.data._id && !streaming && !draggingLock) {
        var lockByLocation = go.Point.stringify(go.Point.parse(e.object.data.loc).add(go.Point.parse(e.object.data.size)))
        if (vueGoInstance.isPublicLinkUrl) {
          pushLockResizingNode(e.object.data.key, lockByLocation, "1", vueGoInstance.anonymousUser.name, e.object.data.loc, e.object.data.size)
        } else {
          pushLockResizingNode(e.object.data.key, lockByLocation, loggedInUser.id, loggedInUser.firstName, e.object.data.loc, e.object.data.size)
        }
      }
    }
  });

  // initialize Overview
  miniboard =
    $gojs(go.Overview, "miniboard",
      {
        observed: board,
        contentAlignment: go.Spot.Center
      });

  const box = new go.Part();
  const s = new go.Shape();
  s.stroke = "dodgerblue";
  s.strokeWidth = 2;
  s.fill = "transparent";
  s.name = "BOXSHAPE";
  box.selectable = true;
  box.selectionObjectName = "BOXSHAPE";
  box.locationObjectName = "BOXSHAPE";
  box.resizeObjectName = "BOXSHAPE";
  box.cursor = "move";
  box.selectionAdorned = false;
  box.add(s);

  miniboard.box = box;

  // var selectionBox = $gojs(go.Part,
  //   { layerName: "Tool", selectable: false },
  //   $gojs(go.Shape,
  //     { name: "SHAPE", fill: null, stroke: "dodgerblue", strokeWidth: 2 }
  //   )
  // );
  // miniboard.box = selectionBox;

  // board.toolManager.rotatingTool.handleArchetype =
  // $gojs(go.Shape, "BpmnActivityLoop",
  //   { width: 10, height: 10, stroke: "black", fill: "transparent" });
  board.toolManager.rotatingTool.handleAngle = 120;

  drawingWithPen(false);


  //............................................................

	/*board.toolManager.textEditingTool.doActivate = function() {
		go.TextEditingTool.prototype.doActivate.call(this); // Call the original method

		const editor = this.textEditor;
		if (editor) {
			setTimeout(() => {
				const length = editor.value.length;
				editor.selectionStart = length; // Set cursor at end
				editor.selectionEnd = length;   // Deselect all text
			}, 10);
		}
	};*/

	// board.addDiagramListener("ObjectSingleClicked", (e) => {
	// 	const part = e.subject.part;
	// 	if (part instanceof go.Node && part.data && (part.data.category == "NOTE" || part.data.category == "SHAPE" || part.data.category == "TEXT")) {
	// 		const tb = part.findObject("textBlock");
	// 		if (tb) {
	// 			board.commandHandler.editTextBlock(tb);
	// 		}
	// 	}
	// });


  ///...........................................................
	var diagramDiv = document.getElementById("board");


    diagramDiv.focus();
	diagramDiv.addEventListener("dragover", function(event) {
		event.preventDefault(); // Allow drop
	});

	diagramDiv.addEventListener("drop", function(event) {
		event.preventDefault();

		let mousePt = board.transformViewToDoc(new go.Point(event.clientX, event.clientY));
        let position = mousePt.x + " " + mousePt.y;
		let files = event.dataTransfer.files;
		if (files.length > 0 && files[0].type.startsWith("image/")) {
			let file = files[0];
            addImageNode(file, position);
		}
		/*else {
			// Check if it's a URL
			let url = event.dataTransfer.getData("text/plain");
			if (url && (url.startsWith("http") || url.startsWith("data:image"))) {
				console.log(url);
				addImageNode(url, mousePt);
			}
		}*/
	});
	/*document.addEventListener("paste", function(event) {
		let clipboardData = event.clipboardData || window.clipboardData;
		if (!clipboardData) return;

		let mousePt = board.transformViewToDoc(new go.Point(event.clientX, event.clientY));

		let items = clipboardData.items;
		let foundImage = false;

		for (let item of items) {
			if (item.type.startsWith("image/")) {
				// If image is copied directly from clipboard
				foundImage = true;
				let blob = item.getAsFile();
				let reader = new FileReader();
				reader.onload = function(e) {
					let imageUrl = e.target.result; // Base64 image data
					addImageNode(imageUrl, mousePt);
				};
				reader.readAsDataURL(blob);
				break;
			}
		}

		// If no direct image found, check for text (URL)
		if (!foundImage) {
			let pastedText = clipboardData.getData("text");
			if (pastedText.startsWith("http") || pastedText.startsWith("data:image")) {
				addImageNode(pastedText, mousePt);
			}
		}
	});*/

    let lastMousePt = new go.Point(0, 0);

    diagramDiv.addEventListener("mousemove", function (event) {
        lastMousePt = board.transformViewToDoc(new go.Point(event.clientX, event.clientY));
        diagramDiv.focus();  // This ensures diagramDiv is focused
    });

    document.addEventListener("keydown", async function (event) {
        const target = event.target;
        const tagName = target.tagName.toLowerCase();
        const isEditable = target.isContentEditable;
        if (tagName === 'input' || tagName === 'textarea' || isEditable) {
            return;
        }
        if ((event.ctrlKey || event.metaKey) && event.key.toLowerCase() === "c") {
            if (board && board.selection.count > 0) {
                internalBoardCopy = true;
            } else {
                internalBoardCopy = false;
            }
        }

        if (event.key.toLowerCase() === "v" && (event.ctrlKey || event.metaKey)) {
            try {
                // Focus the document or a specific element before accessing the clipboard
                if (!document.hasFocus()) {
                    diagramDiv.focus(); // Focus the diagramDiv or any relevant element
                }

                if (!internalBoardCopy) {
                    const clipboardItems = await navigator.clipboard.read();
                    let position = (lastMousePt.x - 30) + " " + (lastMousePt.y - 50);

                    for (const item of clipboardItems) {
                        // Check for image
                        if (item.types.includes("image/png") || item.types.includes("image/jpeg")) {
                            const blob = await item.getType(item.types[0]);
                            const file = new File([blob], "pasted-image.png", {
                                type: blob.type,
                                lastModified: Date.now()
                            });
                            addImageNode(file, position);
                        }


                        // Check for plain text
                        if (item.types.includes("text/plain")) {
                            const textBlob = await item.getType("text/plain");
                            const text = await textBlob.text();
                            board.model.startTransaction(MOD_TRNS_NODE_ADD);
                            board.model.addNodeData({
                                key: getNewUUID(),
                                text: text,
                                category: "SHAPE",
                                width: 300,
                                loc: position,
                                lock: false,
                                linkTo: false,
                            });
                            board.model.commitTransaction(MOD_TRNS_NODE_ADD);
                        }
                    }
                }
            } catch (err) {
                console.error("Clipboard read failed", err);
            }

            event.preventDefault(); // Prevent default paste behavior (optional)
        }
    }, true);


}

function addImageNode(file, position) {
    const key = crypto.randomUUID();

    // Step 1: Add temporary loader node
    board.model.commit(function () {
        board.model.addNodeData({
            category: "PICTURE",
            loader: true,
            loc: position,
            key: key
        });
    }, null);

    // Step 2: Upload image
    uploadImageToMongoGridFS(file).then(res => {
        let path;
        let data;
        if (res && res.data) {
            data = res.data;
            if(vueGoInstance.isPublicLinkUrl) {
                var token = this.getUrlParameter("token");
                path = `/graphx/public_share/retrieve-image/${res.data}?token=` + token;
            } else {
                path = `/upload/retrieve-image/${data}`;
            }
        }

        // Remove the temporary loader node
        board.model.commit(function () {
            const node = board.findNodeForKey(key);
            if (node) {
                board.remove(node);
            }
        }, null);

        // If image uploaded successfully
        if (path) {
            board.model.startTransaction(MOD_TRNS_NODE_ADD);
            board.model.addNodeData({
                category: "PICTURE",
                source: path,
                loader: false,
                loc: position,
                key: key
            });
            board.model.commitTransaction(MOD_TRNS_NODE_ADD);
        } else {
            showTopMessage("Image upload failed.", 'warning', 3000);
        }

    }).catch(error => {
        console.error("Image upload error:", error);

        // Remove the temporary loader node
        board.model.commit(function () {
            const node = board.findNodeForKey(key);
            if (node) {
                board.remove(node);
            }
        }, null);

        showTopMessage("Image upload failed.", 'warning', 3000);
    });
}


function initializeBoardGrid() {

  if (vueGoInstance.boardDetail && vueGoInstance.boardDetail.board) {

    var gridTemplate;

    if (vueGoInstance.boardDetail.board.backgroundPattern === "lines") {
      gridTemplate = $gojs(go.Panel, "Grid",
        {
          gridCellSize: new go.Size(gridDotSpacingSize, gridDotSpacingSize),
          background: vueGoInstance.boardDetail.board.backgroundColor
        },
        $gojs(go.Shape, "LineH", { name: "GridLineHori", stroke: "rgb(210, 210, 210)", strokeWidth: 0.2 }),
        // $gojs(go.Shape, "LineH", { stroke: "lightgray", strokeWidth: 0.1, interval: 10 }),
        // $gojs(go.Shape, "LineH", { stroke: "lightgray", strokeWidth: 0.3, interval: 20 }),
        $gojs(go.Shape, "LineV", { name: "GridLineVert", stroke: "rgb(210, 210, 210)", strokeWidth: 0.2 }),
        // $gojs(go.Shape, "LineV", { stroke: "lightgray", strokeWidth: 0.1, interval: 10 }),
        // $gojs(go.Shape, "LineV", { stroke: "lightgray", strokeWidth: 0.3, interval: 20 })
      );
    }
    else if (vueGoInstance.boardDetail.board.backgroundPattern === "dotted") {
      gridTemplate = $gojs(go.Panel, "Grid",
        {
          gridCellSize: new go.Size(gridDotSpacingSize, gridDotSpacingSize),
          background: vueGoInstance.boardDetail.board.backgroundColor
        },
        $gojs(go.Shape, "LineH", { name: "GridLine", strokeDashArray: [gridDotSize, (gridDotSpacingSize * 2) - gridDotSize], interval: 2, stroke: "rgb(183, 183, 183)", strokeWidth: gridDotSize })
      );
    }
    else if (vueGoInstance.boardDetail.board.backgroundPattern === "plain") {
      gridTemplate = $gojs(go.Panel, "Grid",
        {
          gridCellSize: new go.Size(gridDotSpacingSize, gridDotSpacingSize),
          background: vueGoInstance.boardDetail.board.backgroundColor
        },
      );
    }
    board.grid = gridTemplate;
  }
}

function updateGridOnZoom() {

  var scale = board.scale;
  var _gridDotSize = gridDotSize / scale;

  if (vueGoInstance.boardDetail && vueGoInstance.boardDetail.board) {

    // if (vueGoInstance.boardDetail.board.backgroundPattern === "grid") {
    //   var gridLine = board.grid.findObject("GridLine");
    //   gridLine.strokeWidth = _gridDotSize;
    // }
    // else if (vueGoInstance.boardDetail.board.backgroundPattern === "dotted") {
    //   var gridLine = board.grid.findObject("GridLine");
    //   gridLine.strokeWidth = _gridDotSize;
    // }
    // else if (vueGoInstance.boardDetail.board.backgroundPattern === "plain") {

    // }
  }
}

//.......
function onDocummentKeyDown(event) {
  if (vueGoInstance.boardDetail.board.locked) {
    return;
  }
  //return;
  var key = event.code;
  key = key.replace("Key","");
  shortcutKeysHandler(key, event.shiftKey, event.ctrlKey);
}

function shortcutKeysHandler(key, shift, control) {

  if (key === "Esc" || key === "Escape") {
    var option = _.find(vueGoInstance.tools.options, { id: "pointer" });
    vueGoInstance.onClickActionType(option);
    vueGoInstance.miniBoard.show = false;
    vueGoInstance.selectedAction = '';
    localStorage.setItem(vueGoInstance.boardDetail.board.id + "-hideMiniboard", "");
    board.clearSelection();
  }

  return;

  if (control && key === "F") {
    vueGoInstance.$refs.search.focus()
  }
  //  else if(control && key === "V"){
  // document.fullscreenElement.onpaste;
  //  }
  else if (control && key === "L") {
    board.selection.each(function (node) {
      board.model.startTransaction(MOD_TRNS_NODE_LOCK)
      if (node.data.lock) {
        board.model.setDataProperty(node.data, "lock", false);
      } else {
        board.model.setDataProperty(node.data, "lock", true)
      }
      board.model.commitTransaction(MOD_TRNS_NODE_LOCK)
    })
  }
  else if (shift && key === "1") {
    board.zoomToFit();
  }
  else if (key === "Esc") {
    var option = _.find(vueGoInstance.tools.options, { id: "pointer" });
    vueGoInstance.onClickActionType(option);
    vueGoInstance.miniBoard.show = false;
    vueGoInstance.selectedAction = '';
    localStorage.setItem(vueGoInstance.boardDetail.board.id + "-hideMiniboard", "");
    board.clearSelection();
  }
  else if (key === "S" && !control) {
    var option = _.find(vueGoInstance.tools.options, { id: "shape" });
    vueGoInstance.onClickActionType(option);
  } else if (key === "A" && !control) {
    var option = _.find(vueGoInstance.tools.options, { id: "panning" });
    vueGoInstance.onClickActionType(option);
  }
  else if (key === "N" && !control) {
    var option = _.find(vueGoInstance.tools.options, { id: "note" });
    vueGoInstance.onClickActionType(option);
  }
  else if (key === "P" && !control) {
    var option = _.find(vueGoInstance.tools.options, { id: "pen" });
    vueGoInstance.onClickActionType(option);
  }
  else if (key === "V" && !control) {
    var option = _.find(vueGoInstance.tools.options, { id: "pointer" });
    vueGoInstance.onClickActionType(option);
  }
  else if (key === "T" && !control) {
    var option = _.find(vueGoInstance.tools.options, { id: "text" });
    vueGoInstance.onClickActionType(option);
  }
  else if (key === "L" && !control) {
    var option = _.find(vueGoInstance.tools.options, { id: "link" });
    vueGoInstance.onClickActionType(option);
  }
  else if (key === "F" && !control) {
    var option = _.find(vueGoInstance.tools.options, { id: "frame" });
    vueGoInstance.onClickActionType(option);
  }
  else if (key === "M" && !control) {
    vueGoInstance.onToggleMiniboard();
  }
  else if (key === "Delete") {
    vueGoInstance.notesPopup.show = true;
  }
  else if (key === "PageUp" && !control) {
    board.commandHandler.pullToFront();
  }
  else if (key === "PageDown" && !control) {
    board.commandHandler.pushToBack();
  }
}

//.....

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////// 
function hideAllContextMenus() {
  if (board.currentTool instanceof go.ContextMenuTool) {
    board.currentTool.doCancel();
  }
}

function showContextMenu(obj, diagram, tool, contextMenu) {
  
  if (!vueGoInstance.userRights.canWrite) {
    return;
  }

  var cmd = diagram.commandHandler;
  var hasMenuItem = false;
  function maybeShowItem(elt, pred) {
    if (!elt) {
      return;
    }
    if (pred) {
      elt.classList.remove("disabled");
      // elt.style.display = "block";
      hasMenuItem = true;
    } else {
      elt.classList.add("disabled");
      // elt.style.display = "none";
    }
  }

  if (obj) {

    var node = obj.part;

    var locked = node.data.lock ? true : false;

    maybeShowItem(document.getElementById(contextMenu.id+"_cut"), cmd.canCutSelection() && !locked);
    maybeShowItem(document.getElementById(contextMenu.id+"_copy"), cmd.canCopySelection() && !locked);
    maybeShowItem(document.getElementById(contextMenu.id+"_paste"), cmd.canPasteSelection(diagram.toolManager.contextMenuTool.mouseDownPoint) && !locked);
    maybeShowItem(document.getElementById(contextMenu.id+"_delete"), cmd.canDeleteSelection());

    maybeShowItem(document.getElementById(contextMenu.id+"_crt-same"), !locked);
    maybeShowItem(document.getElementById(contextMenu.id+"_pushBack"), !locked);
    maybeShowItem(document.getElementById(contextMenu.id+"_pullFront"), !locked);

    // Now show the whole context menu element
    if (hasMenuItem) {
      if (!vueGoInstance.boardDetail.board.locked) {
        contextMenu.classList.add("show-menu");
      }
    }

    if (node.data && node.data.category === "FRAME") {

      var notAllowedItems = {};
      if (node.data.notAllowedItems) {
        _.each(node.data.notAllowedItems, item => {
          notAllowedItems[item] = true;
        });
      }

      maybeShowItem(document.getElementById(contextMenu.id+"_crt-note"), (notAllowedItems["NOTE"] ? false : true) && !locked);
      maybeShowItem(document.getElementById(contextMenu.id+"_crt-text"), (notAllowedItems["TEXT"] ? false : true) && !locked);
    }

    var nodeBound = node.getDocumentBounds().copy();
    var nodePosition = node.position;
    var diagramBound = node.diagram.viewportBounds;

    var x = (nodePosition.x - diagramBound.x) * node.diagram.scale;
    var y = (nodePosition.y - diagramBound.y) * node.diagram.scale + 50;

    nodeBound.width *= node.diagram.scale;
    nodeBound.hieght *= node.diagram.scale;

    x += nodeBound.width + 10;

    contextMenu.style.left = x + "px";
    contextMenu.style.top = y + "px";
  }
  else {
    if (!vueGoInstance.boardDetail.board.locked) {
      contextMenu.classList.add("show-menu");
    }

    var showPaste = cmd.canPasteSelection(diagram.toolManager.contextMenuTool.mouseDownPoint) && !board.isReadOnly;
    maybeShowItem(document.getElementById(contextMenu.id+"_paste"), showPaste);

    // we don't bother overriding positionContextMenu, we just do it here:
    var mousePt = diagram.lastInput.viewPoint;
    contextMenu.style.left = mousePt.x + 5 + "px";
    contextMenu.style.top = mousePt.y + "px";
  }

  // Optional: Use a `window` click listener with event capture to
  // remove the context menu if the user clicks elsewhere on the page
  window.addEventListener("click", hideAllContextMenus, true);
}

function hideContextMenu(contextMenu) {

  contextMenu.classList.remove("show-menu");
  // Optional: Use a `window` click listener with event capture to
  //           remove the context menu if the user clicks elsewhere on the page
  window.removeEventListener("click", hideAllContextMenus, true);
}


function getNextZOrder() {
    let maxZ = 0;
    board.nodes.each(function (node) {
        if (node.data.zOrder != null && node.data.zOrder > maxZ) {
            maxZ = node.data.zOrder;
        }
    });
    return maxZ + 1;
}

function onContextMenuCommand(event, val) {
  if (val === undefined) {
    val = event.currentTarget.id.split("_")[1];
  } 
  var diagram = board;
  switch (val) {
    case "cut": diagram.commandHandler.cutSelection(); break;
    case "copy": diagram.commandHandler.copySelection(); break;
    case "paste": diagram.commandHandler.pasteSelection(diagram.toolManager.contextMenuTool.mouseDownPoint); break;
    case "delete": checkForDeleteCommand(); break;

    case "crt-note":
      contextMenuCreateItemInsideFrame("NOTE");
      break;
    case "crt-text":
      contextMenuCreateItemInsideFrame("TEXT");
      break;
    case "crt-same":
      contextMenuDuplicate();
      break;
    case "pushBack":
      board.startTransaction(MOD_TRNS_NODE_UPD);
      diagram.commandHandler.pushToBack();
      board.commitTransaction(MOD_TRNS_NODE_UPD);
      break;
    case "pullFront":
      board.startTransaction(MOD_TRNS_NODE_UPD);
      diagram.commandHandler.pullToFront();
      board.commitTransaction(MOD_TRNS_NODE_UPD);
      break;
  }
  diagram.currentTool.stopTool();
  diagram.focus();
}

function contextMenuDuplicate() {

  // board.clearSelection(true);

  var marginX = 40;
  var marginY = 0;

  var nodeBound = board.computePartsBounds(board.selection);
  marginX = nodeBound.right - nodeBound.left + 40;

  var nodes = [];
  board.selection.each(function (node) {
    nodes.push(node);
  });
  board.model.startTransaction(MOD_TRNS_NODE_DUPLICATE);
  try {
    _.each(nodes, node => {
      var nodeBound = node.actualBounds;
      var position = new go.Point(nodeBound.x + marginX, nodeBound.y + marginY);
      duplicateNode(node, position, true);
    });
  } catch (error) {
  }
  board.model.commitTransaction(MOD_TRNS_NODE_DUPLICATE);

  board.raiseDiagramEvent("ChangingSelection", board.selection);
  zoomToFitFrame(nodeBound);
}

function contextMenuCreateItemInsideFrame(itemType) {

  var group = board.selection.first();

  var position;

  if (group.memberParts && group.memberParts.count > 0) {

    var maxX = -10000;
    var maxY = -10000;

    group.memberParts.each(function (part) {
      var bound = part.actualBounds;
      if (bound.x + bound.width > maxX) {
        maxX = bound.x + bound.width;
      }
      if (bound.y + bound.height > maxY) {
        maxY = bound.y + bound.height;
      }
    });
    position = new go.Point(maxX + 10, maxY + 10);
  }
  else {
    const shape = group.findObject("Placeholder");
    if (shape) {
      position = shape.getDocumentPoint(go.Spot.TopLeft).offset(10, 10);
    }
    else {
      position = group.getDocumentPoint(go.Spot.TopLeft).offset(10, 10);
    }
  }

  var arch = vueGoInstance.getDataObjectWithCategory(itemType);

  var part = null;
  if (arch !== null) {
    var data = board.model.copyNodeData(arch);
    if (data) {
      data.scale = 1;

      data.group = group.key;

      var size;
      if (data.size) {
        size = go.Size.parse(data.size);
        size = new go.Size(size.width / board.scale, size.height / board.scale);
      }
      else {
        if (data.category == "TEXT") {
          size = new go.Size(200 / board.scale, NaN);
        }
        else {
          size = new go.Size(200 / board.scale, 200 / diboardcale);
        }
      }

      board.model.startTransaction(MOD_TRNS_NODE_ADD);

      data.size = go.Size.stringify(size);
      board.model.addNodeData(data);
      part = board.findPartForData(data);

      part.position = position;
      // part.resizeObject.desiredSize = new go.Size(bounds.size.width, NaN);

      board.model.commitTransaction(MOD_TRNS_NODE_ADD);

      if (board.allowSelect) {
        board.clearSelection();
        part.isSelected = true;
      }
    }
  }
  board.raiseDiagramEvent("ChangedSelection", board.selection);
}
var removeFrameContentOnDelete = false;
function checkForDeleteCommand() {
  if (board.selection.count > 1) {
    var isAnyFrame = false;
    board.selection.each((node) => {
      if (node.data && node.category === "FRAME") {
        isAnyFrame = true;
      }
    });
    if (isAnyFrame) {
      alertFromSweetAlertWrapper("Can not delete frame in while multiple items are selected.");
    }
    else {

      board.startTransaction(MOD_TRNS_NODE_DEL);
      board.removeParts(board.selection);
      board.commitTransaction(MOD_TRNS_NODE_DEL);

    }
  }
  else {
    var frame = board.selection.first();
    if (frame.data && frame.data.category === "FRAME") {

      askFromSweetAlertWrapper('Do you want to delete this Frame?</br> <div class="custom-checkbox light mt-5"><input id="confirm-delete" type="checkbox" " checked="true" /> <label for="confirm-delete">It will also delete content of this Frame</label></div>', [function(){
        
        removeFrameContentOnDelete = $("#confirm-delete").is(":checked");

        if (!removeFrameContentOnDelete) {
          
          board.startTransaction(MOD_TRNS_NODE_DEL);
          var ok = board.commandHandler.addTopLevelParts(board.selection.first().memberParts, true);
          board.commitTransaction(MOD_TRNS_NODE_DEL);

          if (ok) {
            board.startTransaction(MOD_TRNS_NODE_DEL);
            board.removeParts(board.selection);
            board.commitTransaction(MOD_TRNS_NODE_DEL);
          }
        }
        else {

          board.startTransaction(MOD_TRNS_NODE_DEL);
          board.removeParts(board.selection);
          board.commitTransaction(MOD_TRNS_NODE_DEL);
        }
      },[]],[function (){

      }]);

    } else {
      board.startTransaction(MOD_TRNS_NODE_DEL);
      board.removeParts(board.selection);
      board.commitTransaction(MOD_TRNS_NODE_DEL);
    }
  }
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function autoFontCheckOnEmptyNote(nodeData) {

  var node = board.findNodeForData(nodeData);

  var textBlock;
  if (node.name && node.name === "textBlock") {
    textBlock = node;
  }
  else {
    textBlock = node.findObject("textBlock");
  }

  var fontFamily = nodeData.textFont;
  if (!fontFamily) {
    fontFamily = "sans-serif";
  }

  if (!_.isEmpty(textBlock.text)) {
    return;
  }

  // board.commit(()=>{
    textBlock.text = "a";
  // },null);

  var finalFontSize;
  var auto = true;
  var initialFontType = auto;

  if (textBlock.panel) {

    textBlock.part.ensureBounds();
    var panelBound = textBlock.panel.actualBounds;

    var textBlockMarginHorizontal = 10;
    var textBlockMarginVertical = 10;

    // board.model.commit(function () {
      tempTextForAutoFont.width = panelBound.width - textBlockMarginHorizontal;
    // }, null);

    var helperTextBlock = tempTextForAutoFont.findObject("textBlock");

    var textSize;
    var font;
    var actualBounds;

    if (!auto) {
    }
    else {
      textSize = textBlock.part.data.autoFont;
      font = "" + textSize + "px "+fontFamily;

      // board.model.commit(function () {
        helperTextBlock.font = font;
        helperTextBlock.text = textBlock.text;
      // }, null);
      tempTextForAutoFont.ensureBounds();

      actualBounds = helperTextBlock.actualBounds;
    }

    if (auto) {
      var fontStep = 0;
      var fit = true;
      if (actualBounds.height < (panelBound.height - textBlockMarginVertical)) {
        fontStep = 1;
        fit = false;
      }
      else if (actualBounds.height > (panelBound.height - textBlockMarginVertical)) {
        fontStep = -1;
        fit = false;
      }

      finalFontSize = textSize;
      while (!fit) {

        textSize += fontStep;
        var font = "" + textSize + "px "+fontFamily;

        // board.model.commit(function () {
          helperTextBlock.font = font;
          helperTextBlock.text = textBlock.text;
        // }, null);

        tempTextForAutoFont.ensureBounds();

        var tempBounds = helperTextBlock.actualBounds;

        var textMetrics = helperTextBlock.metrics;
        var expectedLineHeight = panelBound.height * (0.2 / textMetrics.arrSize.length);

        if (fontStep > 0) {

          if (tempBounds.height >= (panelBound.height - textBlockMarginVertical) || textMetrics.fontHeight > expectedLineHeight) {
            fit = true;
          }
        }
        else {

          // $("#logDiv").html(":"+helperTextBlock.metrics.arrSize.length);
          if (tempBounds.height <= (panelBound.height - textBlockMarginVertical)) {
            fit = true;
          }
        }
        if (!fit) {
          finalFontSize = textSize;
        }
      }
      if (finalFontSize != textSize) {
        textBlock.part.data.autoFont = finalFontSize;
        var font = "" + finalFontSize + "px "+fontFamily;

        // board.model.commit(function () {
          textBlock.font = font;
        // }, null);

        board.model.updateTargetBindings(textBlock.part.data);
      }
    }
  }

  // board.commit(()=>{
    textBlock.text = "";
  // },null);

  nodeData.autoFont = finalFontSize;
  //...................
}

function adjustAutoFont(node, auto) {

  var textBlock;
  if (node.name && node.name === "textBlock") {
    textBlock = node;
  }
  else {
    textBlock = node.findObject("textBlock");
  }

  var finalFontSize;
  var initialFontType = auto;
  if (textBlock.panel) {

    textBlock.part.ensureBounds();
    var panelBound = textBlock.panel.actualBounds;

    var textBlockMarginHorizontal = 40;
    var textBlockMarginVertical = 50;

    board.model.commit(function () {
      tempTextForAutoFont.width = panelBound.width - textBlockMarginHorizontal;
    }, null);

    var helperTextBlock = tempTextForAutoFont.findObject("textBlock");

    var textSize;
    var font;
    var actualBounds;

    var fontFamily = textBlock.part.data.textFont;
    if (!fontFamily) {
      fontFamily = "sans-serif";
    }

    if (!auto) {

      textSize = textBlock.part.data.textSize;
      font = "" + textSize + "px "+fontFamily;

      board.model.commit(function () {
        helperTextBlock.font = font;
        helperTextBlock.text = textBlock.text;
      }, null);

      tempTextForAutoFont.ensureBounds();

      actualBounds = helperTextBlock.actualBounds;

      if (actualBounds.height > (panelBound.height - textBlockMarginVertical)) {
        auto = true;
        textBlock.part.data.autoFont = textSize;
        textBlock.part.data.textSize = "Auto";
      }
    }
    else {
      textSize = textBlock.part.data.autoFont;
      font = "" + textSize + "px "+fontFamily;

      board.skipsUndoManager = true;
      board.model.commit(function () {
        helperTextBlock.font = font;
        helperTextBlock.text = textBlock.text;
      }, null);
      board.skipsUndoManager = false;
      tempTextForAutoFont.ensureBounds();

      actualBounds = helperTextBlock.actualBounds;
    }

    if (auto) {
      var fontStep = 0;
      var fit = true;
      if (actualBounds.height < (panelBound.height - textBlockMarginVertical)) {
        fontStep = 1;
        fit = false;
      }
      else if (actualBounds.height > (panelBound.height - textBlockMarginVertical)) {
        fontStep = -1;
        fit = false;
      }

      finalFontSize = textSize;
      while (!fit) {

        textSize += fontStep;
        var font = "" + textSize + "px "+fontFamily;

        board.skipsUndoManager = false;
        board.model.commit(function () {
          helperTextBlock.font = font;
          helperTextBlock.text = textBlock.text;
        }, null);
        board.skipsUndoManager = false;
        
        tempTextForAutoFont.ensureBounds();

        var tempBounds = helperTextBlock.actualBounds;

        var textMetrics = helperTextBlock.metrics;
        var expectedLineHeight = panelBound.height * (0.2 / textMetrics.arrSize.length);

        if (fontStep > 0) {

          if (tempBounds.height >= (panelBound.height - textBlockMarginVertical) || textMetrics.fontHeight > expectedLineHeight) {
            fit = true;
          }
        }
        else {

          // $("#logDiv").html(":"+helperTextBlock.metrics.arrSize.length);
          if (tempBounds.height <= (panelBound.height - textBlockMarginVertical)) {
            fit = true;
          }
        }
        if (!fit) {
          finalFontSize = textSize;
        }
      }
      if (finalFontSize != textSize) {
        textBlock.part.data.autoFont = finalFontSize;
        var font = "" + finalFontSize + "px "+fontFamily;

        board.model.commit(function () {
          textBlock.font = font;
        }, null);

        board.model.updateTargetBindings(textBlock.part.data);
      }
    }
  }
  return { changeMode: initialFontType != auto, size: finalFontSize, textBlock: textBlock };
  //...................
}

function putEventInCollection(item, property, value, collection, collectionMap) {

  // if (_.isEmpty(item._id)) {
  //   return;
  // }
  var changeEvent = collectionMap[item._id];
  if (!changeEvent) {
    changeEvent = {
      "_id": item._id,
      "key": item.key,
      category: item.category,
    };
    collectionMap[item._id] = changeEvent;
    collection.push(changeEvent);
  }
  changeEvent[property] = value;
  //... exclusive work for not and property text
  if (item.category === "NOTE") {
    if (property === "textSize" && !changeEvent["autoFont"]) {
      changeEvent["autoFont"] = item.autoFont;
    }
    else if (property === "text") {
      changeEvent["autoFont"] = item.autoFont;
      changeEvent["textSize"] = item.textSize;
    }
  }
  changeEvent.data = item;
  //..........................................................
}

//This is the general menu command handler, parameterized by the name of the command.

/*function ContinuedTextEditingTool() {
    go.TextEditingTool.call(this);
    this.starting = go.TextEditingTool.SingleClick;
  }

  ContinuedTextEditingTool.prototype.doMouseDown = function() {
    go.TextEditingTool.prototype.doMouseDown.call(this);
    if (!this.isActive) {
      this.diagram.currentTool.doMouseDown();
    }
  }*/
function nodeClicked(e, obj) {  // executed by click and doubleclick handlers
  var evt = e.copy();
  if (evt.clickCount === 1) { // if single-clicked
    showSmallPorts(obj, true);
  } else {// if double-clicked //if(evt.clickCount === 2)
    board.commandHandler.editTextBlock();
  }
}
//Define a function for creating a "port" that is normally transparent.
// The "name" is used as the GraphObject.portId, the "spot" is used to control how links connect
// and where the port is positioned on the node, and the boolean "output" and "input" arguments
// control whether the user can draw links from or to the port.
function drawingWithPen(draw) {
  var tool = board.toolManager.findTool("FreehandDrawing");
  tool.isEnabled = draw;
}

function updateAllAdornments() {  // called after checkboxes change Diagram.allow...
  board.selection.each(function (p) { p.updateAdornments(); });
}

function toolEnabled() {
  var enable = document.getElementById("ToolEnabled").checked;
  var tool = board.toolManager.findTool("DragCreating");
  if (tool !== null) tool.isEnabled = enable;
}

//.............................................................

function generatePdf(action, diagram, options) {
  if (!(diagram instanceof go.Diagram)) throw new Error("no Diagram provided when calling generatePdf");
  if (!options) options = {};

  var pageSize = options.pageSize || "LETTER";
  pageSize = pageSize.toUpperCase();
  if (pageSize !== "LETTER" && pageSize !== "A4") throw new Error("unknown page size: " + pageSize);
  // LETTER: 612x792 pt == 816x1056 CSS units
  // A4: 595.28x841.89 pt == 793.71x1122.52 CSS units
  var pageWidth = (pageSize === "LETTER" ? 612 : 595.28) * 96 / 72;  // convert from pt to CSS units
  var pageHeight = (pageSize === "LETTER" ? 792 : 841.89) * 96 / 72;

  var layout = options.layout || "portrait";
  layout = layout.toLowerCase();
  if (layout !== "portrait" && layout !== "landscape") throw new Error("unknown layout: " + layout);
  if (layout === "landscape") {
    var temp = pageWidth;
    pageWidth = pageHeight;
    pageHeight = temp;
  }

  var margin = options.margin !== undefined ? options.margin : 36;  // pt: 0.5 inch margin on each side
  var padding = options.padding !== undefined ? options.padding : diagram.padding;  // CSS units

  var imgWidth = options.imgWidth !== undefined ? options.imgWidth : (pageWidth - margin / 72 * 96 * 2);  // CSS units
  var imgHeight = options.imgHeight !== undefined ? options.imgHeight : (pageHeight - margin / 72 * 96 * 2);  // CSS units
  var imgResolutionFactor = options.imgResolutionFactor !== undefined ? options.imgResolutionFactor : 1;

  var pageOptions = {
    size: pageSize,
    margin: margin,  // pt
    layout: layout
  };

  var doc = new PDFDocument(pageOptions);
  var stream = doc.pipe(blobStream());
  var bnds = diagram.documentBounds;

  // add some descriptive text
  //doc.text(diagram.nodes.count + " nodes, " + diagram.links.count + " links  Diagram size: " + bnds.width.toFixed(2) + " x " + bnds.height.toFixed(2));

  var db = diagram.documentBounds.copy().subtractMargin(diagram.padding).addMargin(padding);
  var p = db.position;

  // if any page has no Parts partially or fully in it, skip rendering that page
  var r = new go.Rect(p.x, p.y, db.width, db.height);

  var makeOptions = {};
  if (options.parts !== undefined) makeOptions.parts = options.parts;
  if (options.background !== undefined) makeOptions.background = options.background;
  if (options.showTemporary !== undefined) makeOptions.showTemporary = options.showTemporary;
  if (options.showGrid !== undefined) makeOptions.showGrid = options.showGrid;
  makeOptions.scale = imgResolutionFactor;
  makeOptions.position = new go.Point(p.x, p.y);
  makeOptions.size = new go.Size(db.width * imgResolutionFactor, db.height * imgResolutionFactor);
  makeOptions.maxSize = new go.Size(Infinity, Infinity);

  var imgdata = diagram.makeImageData(makeOptions);
  doc.image(imgdata, { scale: 1 / (imgResolutionFactor * 96 / 72 * Math.max(db.width / imgWidth, db.height / imgHeight)) });

  doc.end();
  stream.on('finish', function () { action(stream.toBlob('application/pdf')); });
}

function animateDeletion(part) {
  if (!(part instanceof go.Node)) return; // only animate Nodes
  var animation = new go.Animation();
  var deletePart = part.copy();
  animation.add(deletePart, "scale", deletePart.scale, 0.01);
  animation.add(deletePart, "angle", deletePart.angle, 260);
  animation.addTemporaryPart(deletePart, board);
  animation.duration = board.animationManager.duration;
  animation.start();
}

var nodePropertiesMap = {
  "zOrder": true,
  "loc": true,
  "linkable": true,
  "angle": true,
  "figure": true,
  "size": true,
  "scale": true,
  "resizable": true,
  "movable": true,
  "border": true,
  "notAllowedItems": true,
  "lock": true,
  "text": true,
  "showHeader": true,
  "reactions": true,
  "textPosition": true,
  "textSize": true,
  "autoFont": true,
  "textColor": true,
  "textBg": true,
  "textStyle": true,
  "showText": true,
  "textAlignment": true,
  "isEditable": true,
  "lockBy": true,
  "isGroup": true,
  "group": true,
  "toArrow": true,
  "fromArrow": true,
  "fromPortId": true,
  "toPortId": true,
  "thickness": true,
  "route": true,
  "lineType": true,
  "points": true,
  "layout": true,
  "rows": true,
  "columns": true,
  "fill": true,
  "bold": true,
  "italic": true,
  "underline": true,
  "position": true,
  "location": true,
  "textFont": true,
  "source": true
}









