 var $ = undefined;
function init(){
	$ = go.GraphObject.make;
	initializeVueInstance();
	initializeBoard();
}

function initializeBoard() {
	
	jQuery("#shapes li").draggable({
        stack: "#board",
        revert: true,
        revertDuration: 0
      });
	
	jQuery("#board").droppable({
        activeClass: "ui-state-highlight",
        drop: function(event, ui) {
          var elt = ui.draggable.first();
          var text = elt[0].textContent;
          var shape = ui.draggable.attr("data-figure");
          var x = ui.offset.left - jQuery(this).offset().left;
          var y = ui.offset.top - jQuery(this).offset().top;
          var p = new go.Point(x, y);
          var q = board.transformViewToDoc(p);
          var model = board.model;
          var uniqueKey = (new Date()).getTime();
          model.startTransaction("drop");
          model.addNodeData({
            key : uniqueKey,
            figure : shape,
            loc: go.Point.stringify(q)
          });
          model.commitTransaction("drop");
          var newlyAddedNode = board.findNodeForKey(uniqueKey);
          board.select(newlyAddedNode);
          board.commandHandler.editTextBlock();
        }
      });
	
	
    board = $(go.Diagram, "board", {
        padding: 20,  // extra space when scrolled all the way
        handlesDragDropForTopLevelParts: true,
        commandHandler: new DrawCommandHandler(),  // defined in DrawCommandHandler.js
        "commandHandler.archetypeGroupData": { isGroup: true },
        minScale: 0.1,  // so that the contents and the grid cannot appear too small
        grid: $(go.Panel, "Grid",
            /*$(go.Shape, "LineH", { stroke: "lightgray", strokeWidth: 0.1 }),
            $(go.Shape, "LineH", { stroke: "lightgray", strokeWidth: 0.3, interval: 10 }),

            $(go.Shape, "LineV", { stroke: "lightgray", strokeWidth: 0.1 }),
            $(go.Shape, "LineV", { stroke: "lightgray", strokeWidth: 0.3, interval: 10 })*/
        	{
            name: "GRID",
            visible: false,
            gridCellSize: new go.Size(5, 5),
            gridOrigin: new go.Point(0, 0)
          },
          $(go.Shape, "LineH", { stroke: "lightgray", strokeWidth: 0.05 }),
          $(go.Shape, "LineH", { stroke: "lightgray", strokeWidth: 0.1, interval: 10 }),
          $(go.Shape, "LineH", { stroke: "lightgray", strokeWidth: 0.3, interval: 20 }),
          $(go.Shape, "LineV", { stroke: "lightgray", strokeWidth: 0.05}),
          $(go.Shape, "LineV", { stroke: "lightgray", strokeWidth: 0.1, interval: 10 }),
          $(go.Shape, "LineV", { stroke: "lightgray", strokeWidth: 0.3, interval: 20 })
         
        ),
        draggingTool: new GuidedDraggingTool(),  // defined in GuidedDraggingTool.js
        "draggingTool.horizontalGuidelineColor": "blue",
        "draggingTool.verticalGuidelineColor": "blue",
        "draggingTool.centerGuidelineColor": "green",
        "draggingTool.guidelineWidth": 1,
        "draggingTool.dragsLink": true,
        
        "linkingTool.isUnconnectedLinkValid": true,
        "linkingTool.portGravity": 100,
        "relinkingTool.isUnconnectedLinkValid": true,
        "relinkingTool.portGravity": 100,
        "relinkingTool.fromHandleArchetype":
          $(go.Shape, "Diamond", { segmentIndex: 0, cursor: "pointer", desiredSize: new go.Size(8, 8), fill: "tomato", stroke: "darkred" }),
        "relinkingTool.toHandleArchetype":
          $(go.Shape, "Diamond", { segmentIndex: -1, cursor: "pointer", desiredSize: new go.Size(8, 8), fill: "darkred", stroke: "tomato" }),
        "linkReshapingTool.handleArchetype":
          $(go.Shape, "Diamond", { desiredSize: new go.Size(7, 7), fill: "lightblue", stroke: "deepskyblue" }),
        "rotatingTool.handleAngle": 270,
        "rotatingTool.handleDistance": 30,
        "rotatingTool.snapAngleMultiple": 15,
        "rotatingTool.snapAngleEpsilon": 15,
        
        "toolManager.mouseWheelBehavior": go.ToolManager.WheelZoom,
//        "linkReshapingTool": new OrthogonalLinkReshapingTool(),
//      "draggingTool.isGridSnapEnabled": true,
//      "resizingTool.isGridSnapEnabled": true,
        resizingTool: new ResizeMultipleTool(),  // defined in ResizeMultipleTool.js
        rotatingTool: new RotateMultipleTool(),  // defined in RotateMultipleTool.js
        "undoManager.isEnabled": true,  // enable undo & redo
        "clickCreatingTool.archetypeNodeData": { text: "NEW NODE", figure :"Rectangle" },
        initialPosition: new go.Point(0, 0), "animationManager.isEnabled": false 
    });

    board.toolManager.draggingTool.doMouseMove = function () {
        var editingMenuElement = document.getElementById("node-editing-options");
        editingMenuElement.classList.remove("show-menu");
				return go.DraggingTool.prototype.doMouseMove.call(this);
		};
		
    board.addDiagramListener('PartResized', function (event) {
        showNodeEditingMenu(event);
    });
    board.addDiagramListener('SelectionMoved', function (event) {
        showNodeEditingMenu(event);
    });

    board.addDiagramListener("ChangedSelection", function (event) {
      showNodeEditingMenu(event);
      vueInstance.subActionType = "none";
    });

    board.addDiagramListener("ViewportBoundsChanged", function (event) {
      showNodeEditingMenu(event);
    });

    // board.addDiagramListener("ChangedSelection", function (event) {
    //   showNodeEditingMenu(event);
    // });
    
 // constant needed to determine mouse coordinates on the canvas
   // window.PIXELRATIO = board.computePixelRatio(); 
 // This is the actual HTML context menu:
    var cxElement = document.getElementById("contextMenu");

 // an HTMLInfo object is needed to invoke the code to set up the HTML cxElement
    var myContextMenu = $(go.HTMLInfo, {
      show: showContextMenu,
      hide: hideContextMenu
    });
    
    board.contextMenu = myContextMenu;
    
    // We don't want the div acting as a context menu to have a (browser) context menu!
    cxElement.addEventListener("contextmenu", function(e) {
      e.preventDefault();
      return false;
    }, false);

    function hideCX() {
      if (board.currentTool instanceof go.ContextMenuTool) {
        board.currentTool.doCancel();
      }
    }

    function showContextMenu(obj, diagram, tool) {
      // Show only the relevant buttons given the current state.
      var cmd = diagram.commandHandler;
      var hasMenuItem = false;
      function maybeShowItem(elt, pred) {
    	if(!elt){
    		return;
    	} 
        if (pred) {
          elt.style.display = "block";
          hasMenuItem = true;
        } else {
          elt.style.display = "none";
        }
      }
      maybeShowItem(document.getElementById("cut"), cmd.canCutSelection());
      maybeShowItem(document.getElementById("copy"), cmd.canCopySelection());
      maybeShowItem(document.getElementById("paste"), cmd.canPasteSelection(diagram.toolManager.contextMenuTool.mouseDownPoint));
      maybeShowItem(document.getElementById("delete"), cmd.canDeleteSelection());
      maybeShowItem(document.getElementById("color"), obj !== null);

      // Now show the whole context menu element
      if (hasMenuItem) {
        cxElement.classList.add("show-menu");
      }

      if (obj) {

        var node = obj.part;

        var nodeBound    = node.getDocumentBounds().copy();
        var nodePosition = node.position;
        var diagramBound = node.diagram.viewportBounds;

        var x = (nodePosition.x - diagramBound.x) * node.diagram.scale;
        var y = (nodePosition.y - diagramBound.y) * node.diagram.scale;

        nodeBound.width  *= node.diagram.scale;
        nodeBound.hieght *= node.diagram.scale;

        x += nodeBound.width;

        cxElement.style.left = x + "px";
        cxElement.style.top = y + "px";
      }
      else {
        // we don't bother overriding positionContextMenu, we just do it here:
        var mousePt = diagram.lastInput.viewPoint;
        cxElement.style.left = mousePt.x + 5 + "px";
        cxElement.style.top = mousePt.y + "px";
      }

      // Optional: Use a `window` click listener with event capture to
      //           remove the context menu if the user clicks elsewhere on the page
      window.addEventListener("click", hideCX, true);
    }

    function hideContextMenu() {
      cxElement.classList.remove("show-menu");
      // Optional: Use a `window` click listener with event capture to
      //           remove the context menu if the user clicks elsewhere on the page
      window.removeEventListener("click", hideCX, true);
    }
    
    function showNodeEditingMenu (event) {
      var editingMenuElement = document.getElementById("node-editing-options");

      if (event.diagram.selection && event.diagram.selection.count > 0) {

        editingMenuElement.classList.add("show-menu");

        event.diagram.selection.each(function (node) {

          var nodeBound = node.getDocumentBounds().copy();
          var nodePosition = node.position;
          var diagramBound = node.diagram.viewportBounds;

          var x = (nodePosition.x - diagramBound.x) * node.diagram.scale;
          var y = (nodePosition.y - diagramBound.y) * node.diagram.scale;

          nodeBound.width *= node.diagram.scale;
          nodeBound.height *= node.diagram.scale;

          var documentWidth  = document.documentElement.scrollWidth;
          var documentHeight = document.documentElement.scrollHeight;

          var menuWidth  = editingMenuElement.scrollWidth;
          var menuHeight = editingMenuElement.scrollHeight

          x += (nodeBound.width * 0.5) - (menuWidth * 0.5);

          x = Math.max(x, 50);
          x = Math.min(x, documentWidth - menuWidth - 50);

          var spaceAtTop    = y;
          var spaceAtBottom = documentHeight - (y + nodeBound.width);

          var margin = 20;
          if (spaceAtTop < menuHeight + margin) {
            y += (nodeBound.height + margin);
          }
          else {
            y -= (menuHeight + margin);
          }

          editingMenuElement.style.left = x + "px";
          editingMenuElement.style.top = y + "px";
        });
        
        
        //vueInstance.selectedNodes = board.selection;
      }
      else {
        editingMenuElement.classList.remove("show-menu");
      }
    }
    
    
    // Add an instance of the custom tool defined in DragCreatingTool.js.
    // This needs to be inserted before the standard DragSelectingTool,
    // which is normally the third Tool in the ToolManager.mouseMoveTools list.
    // Note that if you do not set the DragCreatingTool.delay, the default value will
    // require a wait after the mouse down event.  Not waiting will allow the DragSelectingTool
    // and the PanningTool to be able to run instead of the DragCreatingTool, depending on the delay.
    board.toolManager.mouseMoveTools.insertAt(2,
      $(DragCreatingTool,
        {
          isEnabled: false,  // disabled by the checkbox
          delay: 0,  // always canStart(), so PanningTool never gets the chance to run
          box: $(go.Part,
            { layerName: "Tool" },
            $(go.Shape,
              { name: "SHAPE", fill: null, stroke: "lightblue", strokeWidth: 2, figure: vueInstance.shapeToDraw })
          ),
          archetypeNodeData: { color: "white" }, // initial properties shared by all nodes
          insertPart: function(bounds) {  // override DragCreatingTool.insertPart
            // use a different color each time
            this.archetypeNodeData.color = go.Brush.randomColor();
            this.archetypeNodeData.figure = vueInstance.shapeToDraw;
            
            // call the base method to do normal behavior and return its result
            return DragCreatingTool.prototype.insertPart.call(this, bounds);
          }
        }));
  
    
    board.toolManager.mouseDownTools.insertAt(3, new GeometryReshapingTool());
    board.grid.visible = true;
    board.nodeTemplateMap.add("FreehandDrawing",
        $(go.Part,
          { locationSpot: go.Spot.Center, isLayoutPositioned: false },
          new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
          {
            selectionAdorned: true, selectionObjectName: "SHAPE",
            selectionAdornmentTemplate:  // custom selection adornment: a blue rectangle
              $(go.Adornment, "Auto",
                $(go.Shape, { stroke: "dodgerblue", fill: null }),
                $(go.Placeholder, { margin: -1 }))
          },
          { resizable: true, resizeObjectName: "SHAPE" },
          { rotatable: true, rotateObjectName: "SHAPE" },
          { reshapable: true },  // GeometryReshapingTool assumes nonexistent Part.reshapeObjectName would be "SHAPE"
          $(go.Shape,
            { name: "SHAPE", fill: null, strokeWidth: 1 },
            new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),
            new go.Binding("angle").makeTwoWay(),
            new go.Binding("geometryString", "geo").makeTwoWay(),
            new go.Binding("fill"),
            new go.Binding("stroke"),
            new go.Binding("strokeWidth"))
        ));

      // create drawing tool for board, defined in FreehandDrawingTool.js
      var tool = new FreehandDrawingTool();
      // provide the default JavaScript object for a new polygon in the model
      tool.archetypePartData =
        { stroke: "green", strokeWidth: 3, category: "FreehandDrawing" };
      // allow the tool to start on top of an existing Part
      tool.isBackgroundOnly = false;
      // install as first mouse-move-tool
      board.toolManager.mouseMoveTools.insertAt(0, tool);

      /*function showSmallPorts(node, show) {
          node.ports.each(function(port) {
            if (port.portId !== "") {  // don't change the default port, which is the big shape
              port.fill = show ? "rgba(0,0,0,.3)" : null;
            }
          });
        }
//*/    board.nodeTemplate =
//        $(go.Node, "Auto",
//        {
//        	/*click: nodeClicked,
//            doubleClick: nodeClicked,*/
//        	 contextMenu: myContextMenu,
//            locationSpot: go.Spot.Center,// locationObjectName: "SHAPE",
//            // desiredSize: new go.Size(120, 60), minSize: new go.Size(40, 40),
//            resizable: true, //, resizeCellSize: new go.Size(20, 20)
//            movable: true,
//            textEditable: true,
//            isShadowed: true,
//            shadowColor: "lightgray",
//            shadowOffset: new go.Point(0,3),
//            shadowBlur: 12
//          },
//          
//           // these Bindings are TwoWay because the DraggingTool and ResizingTool modify the target properties
//          new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
//          new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),
//          $(go.Shape, "Rectangle",
//            {
//              fill: "white", stroke: "lightblue", strokeWidth: 0.5,
//              portId: "", fromLinkable: false, toLinkable: false,
//              fromLinkableDuplicates: true, toLinkableDuplicates: true,
//              fromLinkableSelfNode: true, toLinkableSelfNode: true
//            },
//            new go.Binding("fill").makeTwoWay(),
//            new go.Binding("stroke").makeTwoWay(),
//            new go.Binding("figure", "figure").makeTwoWay()),
//            // four small named ports, one on each side:
//            makePort("T", go.Spot.Top, true, true),
//            makePort("L", go.Spot.Left, true, true),
//            makePort("R", go.Spot.Right, true, true),
//            makePort("B", go.Spot.Bottom, true, true),
//          $(go.TextBlock,
//            {
//              margin: new go.Margin(5, 5, 3, 5), font: "10pt sans-serif",
//              minSize: new go.Size(11, 11), maxSize: new go.Size(120, NaN),
//              textAlign: "center", editable: true
//            },
//            new go.Binding("text").makeTwoWay()),
//        /*,
//            { // handle mouse enter/leave events to show/hide the ports
//              mouseEnter: function(e, node) { showSmallPorts(node, true); },
//              mouseLeave: function(e, node) { showSmallPorts(node, false); }
//            }*/
//        );

	
	board.nodeTemplate =
        $(go.Node, "Spot",
          { 
//        	click: nodeClicked,
          	doubleClick: nodeClicked,
      	    contextMenu: myContextMenu,
        	locationSpot: go.Spot.Center,
        	resizable: true, //, resizeCellSize: new go.Size(20, 20)
            movable: true,
            textEditable: true,
            isShadowed: true,
            shadowColor: "lightgray",
            shadowOffset: new go.Point(0,3),
            shadowBlur: 12,
            
        	  },
          new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
          { selectable: true },
          { resizable: true, //resizeObjectName: "PANEL",
        	  resizeObjectName: "BOX",
              resizeAdornmentTemplate:
                $(go.Adornment, "Spot",
                  $(go.Placeholder),
                  $(go.Shape, { alignment: go.Spot.TopLeft, desiredSize: new go.Size(8, 8), fill: "lightblue", stroke: "dodgerblue", cursor: "nw-resize" }),
                  $(go.Shape, { alignment: go.Spot.TopRight, desiredSize: new go.Size(8, 8), fill: "lightblue", stroke: "dodgerblue", cursor: "ne-resize" }),
                  $(go.Shape, { alignment: go.Spot.BottomRight, desiredSize: new go.Size(8, 8), fill: "lightblue", stroke: "dodgerblue", cursor: "se-resize" }),
                  $(go.Shape, { alignment: go.Spot.BottomLeft, desiredSize: new go.Size(8, 8), fill: "lightblue", stroke: "dodgerblue", cursor: "sw-resize" })
                )
           },
          { rotatable: true},
          new go.Binding("angle").makeTwoWay(),
          // the main object is a Panel that surrounds a TextBlock with a Shape
          $(go.Panel, "Auto",
            { name: "BOX" },
            new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),
            $(go.Shape, "Rectangle",  // default figure
              {
                portId: "", // the default port: if no spot on link data, use closest side
                fromLinkable: false, toLinkable: false, cursor: "pointer",
                fill: "white",  // default color
                stroke: "lightblue",
                strokeWidth: 0.5
              },
              new go.Binding("fill").makeTwoWay(),
              new go.Binding("stroke").makeTwoWay(),
              new go.Binding("figure", "figure").makeTwoWay()),
            $(go.TextBlock,
              {
                font: "bold 11pt Helvetica, Arial, sans-serif",
                margin: 8,
                maxSize: new go.Size(160, NaN),
                wrap: go.TextBlock.WrapFit,
                editable: true
              },
              new go.Binding("text").makeTwoWay())
          ),
          // four small named ports, one on each side:
          makePort("T", go.Spot.Top, true, true),
          makePort("L", go.Spot.Left, true, true),
          makePort("R", go.Spot.Right, true, true),
          makePort("B", go.Spot.Bottom, true, true)/*,
          { // handle mouse enter/leave events to show/hide the ports
            mouseEnter: function(e, node) { showSmallPorts(node, true); },
            mouseLeave: function(e, node) { showSmallPorts(node, false); }
          }*/
        );
         // unlike the normal selection Adornment, this one includes a Button
    board.nodeTemplate.selectionAdornmentTemplate =
    $(go.Adornment, "Spot",
      $(go.Panel, "Auto",
        $(go.Shape, { fill: null, stroke: "blue", strokeWidth: 0.1 }),
        $(go.Placeholder)  // this represents the selected Node
      ),
       // the button to create a "next" node, at the top-right corner
//       $("Button",
//         {
//           alignment: go.Spot.TopRight
//           //click: addNodeAndLink  // this function is defined below
//         },
//         $(go.Shape, "PlusLine", { desiredSize: new go.Size(6, 6) })
//       ) // end button
    ); // end Adornment

   /* board.toolManager.linkingTool.temporaryLink = $(go.Link,  // the whole link panel
            {  routing: go.Link.AvoidsNodes,
        reshapable: true,
        resegmentable: true,
        curve: go.Link.Bezier, 
        adjusting: go.Link.Stretch
    },
    new go.Binding("points").makeTwoWay(),
    new go.Binding("curviness", "curviness"),
    $(go.Shape,  // the link shape
      { strokeWidth: 1.5 }),
    $(go.Shape,  // the arrowhead
      { toArrow: "standard", stroke: null }),
    $(go.Panel, "Auto",
      $(go.Shape,  // the label background, which becomes transparent around the edges
        {
          fill: $(go.Brush, "Radial",
            { 0: "rgb(240, 240, 240)", 0.3: "rgb(240, 240, 240)", 1: "rgba(240, 240, 240, 0)" }),
          stroke: null
        }),
      $(go.TextBlock, "",  // the label text
        {
          textAlign: "center",
          font: "10pt helvetica, arial, sans-serif",
          stroke: "black",
          margin: 4,
          editable: true  // editing the text automatically updates the model data
        },
        new go.Binding("text", "text").makeTwoWay())
    )
  );
    board.linkTemplate =
      $(go.Link,  // the whole link panel
        {  routing: go.Link.AvoidsNodes,
            reshapable: true,
            resegmentable: true,
            curve: go.Link.Bezier, 
            adjusting: go.Link.Stretch
        },
        new go.Binding("points").makeTwoWay(),
        new go.Binding("curviness", "curviness"),
        $(go.Shape,  // the link shape
          { strokeWidth: 1.5 }),
        $(go.Shape,  // the arrowhead
          { toArrow: "standard", stroke: null }),
        $(go.Panel, "Auto",
          $(go.Shape,  // the label background, which becomes transparent around the edges
            {
              fill: $(go.Brush, "Radial",
                { 0: "rgb(240, 240, 240)", 0.3: "rgb(240, 240, 240)", 1: "rgba(240, 240, 240, 0)" }),
              stroke: null
            }),
          $(go.TextBlock, "",  // the label text
            {
              textAlign: "center",
              font: "10pt helvetica, arial, sans-serif",
              stroke: "black",
              margin: 4,
              editable: true  // editing the text automatically updates the model data
            },
            new go.Binding("text", "text").makeTwoWay())
        )
      );*/
      // Link template

      board.toolManager.linkingTool.temporaryLink = $(go.Link,
              {
          layerName: "Foreground",
          routing: go.Link.AvoidsNodes, corner: 10,
          toShortLength: 4,  // assume arrowhead at "to" end, need to avoid bad appearance when path is thick
          relinkableFrom: true, relinkableTo: true,
          reshapable: true, resegmentable: true
        },
        new go.Binding("fromSpot", "fromSpot", go.Spot.parse),
        new go.Binding("toSpot", "toSpot", go.Spot.parse),
        new go.Binding("fromShortLength", "dir", function(dir) { return dir === 2 ? 4 : 0; }),
        new go.Binding("toShortLength", "dir", function(dir) { return dir >= 1 ? 4 : 0; }),
        new go.Binding("points").makeTwoWay(),  // TwoWay due to user reshaping with LinkReshapingTool
        $(go.Shape, { strokeWidth: 1 },
          new go.Binding("stroke", "color"),
          new go.Binding("strokeWidth", "thickness"),
          new go.Binding("strokeDashArray", "dash")),
        $(go.Shape, { fromArrow: "Backward", strokeWidth: 0, scale: 4/3, visible: false },
          new go.Binding("visible", "dir", function(dir) { return dir === 2; }),
          new go.Binding("fill", "color"),
          new go.Binding("scale", "thickness", function(t) { return (2+t)/3; })),
        $(go.Shape, { toArrow: "Standard", strokeWidth: 0, scale: 4/3 },
          new go.Binding("visible", "dir", function(dir) { return dir >= 1; }),
          new go.Binding("fill", "color"),
          new go.Binding("scale", "thickness", function(t) { return (2+t)/3; })),
        $(go.TextBlock,
          { alignmentFocus: new go.Spot(0, 1, -4, 0), editable: true },
          new go.Binding("text").makeTwoWay(),  // TwoWay due to user editing with TextEditingTool
          new go.Binding("stroke", "color"))
      );
      board.linkTemplate =
        $(go.Link,
          {
            layerName: "Foreground",
            routing: go.Link.AvoidsNodes, corner: 10,
            toShortLength: 4,  // assume arrowhead at "to" end, need to avoid bad appearance when path is thick
            relinkableFrom: true, relinkableTo: true,
            reshapable: true, resegmentable: true
          },
          new go.Binding("fromSpot", "fromSpot", go.Spot.parse),
          new go.Binding("toSpot", "toSpot", go.Spot.parse),
          new go.Binding("fromShortLength", "dir", function(dir) { return dir === 2 ? 4 : 0; }),
          new go.Binding("toShortLength", "dir", function(dir) { return dir >= 1 ? 4 : 0; }),
          new go.Binding("points").makeTwoWay(),  // TwoWay due to user reshaping with LinkReshapingTool
          $(go.Shape, { strokeWidth: 1 },
            new go.Binding("stroke", "color"),
            new go.Binding("strokeWidth", "thickness"),
            new go.Binding("strokeDashArray", "dash")),
          $(go.Shape, { fromArrow: "Backward", strokeWidth: 0, scale: 4/3, visible: false },
            new go.Binding("visible", "dir", function(dir) { return dir === 2; }),
            new go.Binding("fill", "color"),
            new go.Binding("scale", "thickness", function(t) { return (2+t)/3; })),
          $(go.Shape, { toArrow: "Standard", strokeWidth: 0, scale: 4/3 },
            new go.Binding("visible", "dir", function(dir) { return dir >= 1; }),
            new go.Binding("fill", "color"),
            new go.Binding("scale", "thickness", function(t) { return (2+t)/3; })),
          $(go.TextBlock,
            { alignmentFocus: new go.Spot(0, 1, -4, 0), editable: true },
            new go.Binding("text").makeTwoWay(),  // TwoWay due to user editing with TextEditingTool
            new go.Binding("stroke", "color"))
        );

      board.linkTemplate.selectionAdornmentTemplate =
        $(go.Adornment,  // use a special selection Adornment that does not obscure the link path itself
          $(go.Shape,
            { // this uses a pathPattern with a gap in it, in order to avoid drawing on top of the link path Shape
              isPanelMain: true,
              stroke: "transparent", strokeWidth: 1,
              pathPattern: makeAdornmentPathPattern(2)  // == thickness or strokeWidth
            },
            new go.Binding("pathPattern", "thickness", makeAdornmentPathPattern)),
          //CMButton({ alignmentFocus: new go.Spot(0, 0, -6, -4) })
        );

      function makeAdornmentPathPattern(w) {
        return $(go.Shape,
          {
            stroke: "dodgerblue", strokeWidth: 1, strokeCap: "square",
            geometryString: "M0 0 M4 2 H3 M4 " + (w+4).toString() + " H3"
          });
      }

    // initialize Palette
   /* palette =
    $(go.Palette, "pallete",
      {
        nodeTemplate: board.nodeTemplate,
        contentAlignment: go.Spot.Center,
        layout:
          $(go.GridLayout,
            { wrappingColumn: 1, cellSize: new go.Size(2, 2) }),
        // "ModelChanged": function(e) {     // just for demonstration purposes,
        //   if (e.isTransactionFinished) {  // show the model data in the page's TextArea
        //     document.getElementById("mySavedPaletteModel").textContent = e.model.toJson();
        //   }
        // }
      });

      // now add the initial contents of the Palette
      palette.model.nodeDataArray = [
        { key: "1", text: "", color: "blue", figure: "Circle" },
        { key: "2", text: "", color: "purple", figure: "Square" },
    	  { key: "1", text: "", color: "orange", figure: "Card" },
    	  { key: "2", text: "", color: "orange", figure: "Parallelogram" },
        { key: "3", text: "", color: "orange", figure: "Ellipse" },
        { key: "4", text: "", color: "red", figure: "Rectangle" },
        { key: "5", text: "", color: "green", figure: "RoundedRectangle" },
        { key: "6", text: "", color: "purple", figure: "Triangle" },
        { key: "7", text: "", color: "purple", figure: "Diamond" },
        { key: "8", text: "", color: "purple", figure: "LineH" },
        { key: "9", text: "", color: "purple", figure: "Subroutine" },
        { key: "10", text: "", color: "purple", figure: "Arrow" },
      ];*/
    
   // initialize Overview
   miniboard =
   $(go.Overview, "miniboard",
     {
       observed: board,
       contentAlignment: go.Spot.Center
     });
    /* document.getElementById('zoomToFit').addEventListener('click', function() {
       
      });*/
      zoomSlider = new ZoomSlider(board);
      drawingWithPen(false);
}

//This is the general menu command handler, parameterized by the name of the command.
function cxcommand(event, val) {
  if (val === undefined) val = event.currentTarget.id;
  var diagram = board;
  switch (val) {
    case "cut": diagram.commandHandler.cutSelection(); break;
    case "copy": diagram.commandHandler.copySelection(); break;
    case "paste": diagram.commandHandler.pasteSelection(diagram.toolManager.contextMenuTool.mouseDownPoint); break;
    case "delete": diagram.commandHandler.deleteSelection(); break;
    case "color": {
      var color = window.getComputedStyle(event.target)['background-color'];
      changeColor(diagram, color); break;
    }
  }
  diagram.currentTool.stopTool();
}

// A custom command, for changing the color of the selected node(s).
function changeColor(diagram, color) {
  // Always make changes in a transaction, except when initializing the diagram.
  diagram.startTransaction("change color");
  diagram.selection.each(function(node) {
    if (node instanceof go.Node) {  // ignore any selected Links and simple Parts
      // Examine and modify the data, not the Node directly.
      var data = node.data;
      // Call setDataProperty to support undo/redo as well as
      // automatically evaluating any relevant bindings.
      diagram.model.setDataProperty(data, "color", color);
    }
  });
  diagram.commitTransaction("change color");
}
function nodeClicked(e, obj) {  // executed by click and doubleclick handlers
	board.commandHandler.editTextBlock();
	showSmallPorts(obj, true);
    /*var evt = e.copy();
    var node = obj.part;
    var type = evt.clickCount === 2 ? "Double-Clicked: " : "Clicked: ";
    var msg = type + node.data.key + ". ";
    var cxElement = document.getElementById("contextMenu");
    var mousePt = board.lastInput.viewPoint;
    cxElement.style.left = mousePt.x + 5 + "px";
    cxElement.style.top = mousePt.y + "px";
    cxElement.style.display = "block";
   console.log(msg);*/
  }
//Define a function for creating a "port" that is normally transparent.
// The "name" is used as the GraphObject.portId, the "spot" is used to control how links connect
// and where the port is positioned on the node, and the boolean "output" and "input" arguments
// control whether the user can draw links from or to the port.
function makePort(name, spot, output, input) {
  // the port is basically just a small transparent circle
  return $(go.Shape, "Circle",
    {
      fill: "lightgray", //"lightgray", // null  // not seen, by default; set to a translucent gray by showSmallPorts, defined below
      stroke: null,
      desiredSize: new go.Size(7, 7),
      margin: new go.Margin(1, 0),
      alignment: spot,  // align the port on the main Shape
      alignmentFocus: spot.opposite(),  // just inside the Shape
      portId: name,  // declare this object to be a "port"
      fromSpot: spot, toSpot: spot,  // declare where links may connect at this port
      fromLinkable: output, toLinkable: input,  // declare whether the user may draw links to/from here
      cursor: "pointer"  // show a different cursor to indicate potential link point
    });
}
function showSmallPorts(node, show) {
    node.ports.each(function(port) {
      if (port.portId !== "") {  // don't change the default port, which is the big shape
        port.fill = show ? "gray" : null;
      }
    });
  }
function drawingWithPen(draw) {
    var tool = board.toolManager.findTool("FreehandDrawing");
    tool.isEnabled = draw;
  }

function updateAllAdornments() {  // called after checkboxes change Diagram.allow...
    board.selection.each(function(p) { p.updateAdornments(); });
}

function toolEnabled() {
    var enable = document.getElementById("ToolEnabled").checked;
    var tool = board.toolManager.findTool("DragCreating");
    if (tool !== null) tool.isEnabled = enable;
}