
var $ = go.GraphObject.make;
function VZResizeMultipleTool() {
  go.ResizingTool.call(this);
  this._handleSize = new go.Size(10, 10);
  this.name = "VZResizeMultiple";
}
go.Diagram.inherit(VZResizeMultipleTool, go.ResizingTool);

////////////////////////////////////////////////////////////////////////////////////////////

VZResizeMultipleTool.prototype.doActivate = function() {
  go.ResizingTool.prototype.doActivate.call(this);
  showNodeEditingMenu();
}
VZResizeMultipleTool.prototype.doDeactivate = function() {

  var diagram = this.diagram;
  if (diagram === null) return;

  diagram.selection.each(function (part) {
    if (part instanceof go.Link) return; // only Nodes and simple Parts
    if (part.data) {
      vueGoInstance.updateArcheTypeNodeData(part.data.category, "size", part.actualBounds.size);
    }
  });
  
  go.ResizingTool.prototype.doDeactivate.call(this);
  showNodeEditingMenu();
}

VZResizeMultipleTool.prototype.resize = function (newr) {
    var diagram = this.diagram;
    if (diagram === null) return;
    diagram.selection.each(function (part) {
      if (part instanceof go.Link) return; // only Nodes and simple Parts
      // var obj = part.resizeObject;
      var obj = part;

      // calculate new location
      var pos = part.position.copy();
      var angle = obj.getDocumentAngle();
      var sc = obj.getDocumentScale();

      var documentBounds = obj.getDocumentBounds();

      var radAngle = Math.PI * angle / 180;
      var angleCos = Math.cos(radAngle);
      var angleSin = Math.sin(radAngle);

      if (part.data && part.data.category === "FRAME") {
        var sizeRatio = part.data.sizeRatio;
        if (sizeRatio && sizeRatio[0] != 0) {
          var ratio = sizeRatio[0] / sizeRatio[1];
          if (newr.width > newr.height) {
            newr.height = newr.width / ratio;
          }
          else {
            newr.width = newr.height * ratio;
          }
        }
      }

      var deltaWidth = newr.width - obj.naturalBounds.width;
      var deltaHeight = deltaHeight = newr.height - obj.naturalBounds.height;

      var angleRight = (angle > 270 || angle < 90) ? 1 : 0;
      var angleBottom = (angle > 0 && angle < 180) ? 1 : 0;
      var angleLeft = (angle > 90 && angle < 270) ? 1 : 0;
      var angleTop = (angle > 180 && angle < 360) ? 1 : 0;

      pos.x += sc * ((newr.x + deltaWidth * angleLeft) * angleCos - (newr.y + deltaHeight * angleBottom) * angleSin);
      pos.y += sc * ((newr.x + deltaWidth * angleTop) * angleSin + (newr.y + deltaHeight * angleLeft) * angleCos);

      obj.desiredSize = newr.size;
      part.position = pos;

    });
};

VZResizeMultipleTool.prototype.computeMinSize = function () {
  const part = this.adornedObject.part;

  if (part.memberParts && part.memberParts.count && part.data && part.data.layout == "layout") {
    const membnds = part.diagram.computePartsBounds(part.memberParts);

    var xDelta = 0;
    var yDelta = 0;

    var margin = 10;

    var handleBounds = this.handle.getDocumentBounds();

    if (handleBounds.x > membnds.x + membnds.size.width) {
      xDelta = membnds.x - part.position.x + margin;
    } else {
      xDelta = margin * 2;
    }

    if (handleBounds.y > membnds.y + membnds.size.height) {
      yDelta = membnds.y - part.position.y + 10;
    } else {

      var frame = part.findObject(part.selectionObjectName);
      var frameBounds = frame.actualBounds;
      
      yDelta = margin * 2 + (frameBounds.y - frame.actualBounds.y);
    }
    return new go.Size(membnds.size.width + xDelta, membnds.size.height + yDelta);
  }
  else {
    return new go.Size(50, 20); // returning min bounds
  }
};

VZResizeMultipleTool.prototype.computeResize = function (newPoint, spot, min, max, cell, reshape) {

  const part = this.adornedObject.part;
  if (part.data && part.data.category === "TEXT") { 
    var rect = go.ResizingTool.prototype.computeResize.call(this, newPoint, spot, min, max, cell, reshape);
    rect.height = NaN;
    return rect;
  }
  return go.ResizingTool.prototype.computeResize.call(this, newPoint, spot, min, max, cell, reshape);
};

VZResizeMultipleTool.prototype.makeAdornment = function (resizeBox) {
  
  // Set up the resize adornment
  var ad = new go.Adornment();
  ad.type = go.Panel.Spot;
  ad.locationSpot = go.Spot.Center;
  var ph = new go.Placeholder();
  ph.isPanelMain = true;
  ad.add(ph);

  // var size = new go.Size(this._handleSize.width / board.scale, this._handleSize.height / board.scale);
  var size = this._handleSize;

  var hnd;
  //....... top left
  hnd = new go.Shape();
  hnd.name = 'HND_TL';
  hnd.figure = 'Circle';
  hnd.desiredSize = size;
  hnd.cursor = 'nwse-resize';
  hnd.fill = "white";
  hnd.stroke = "gray";
  hnd.alignment = go.Spot.TopLeft;
  hnd.alignmentFocus = go.Spot.Center;
  hnd.bind(new go.Binding("scale","scale", function (sacle) {return 1/sacle}).ofModel());
  ad.add(hnd);

  //....... bottom left
  hnd = new go.Shape();
  hnd.name = 'HND_BL';
  hnd.figure = 'Circle';
  hnd.desiredSize = size;
  hnd.cursor = 'nesw-resize';
  hnd.fill = "white";
  hnd.stroke = "gray";
  hnd.alignment = go.Spot.BottomLeft;
  hnd.alignmentFocus = go.Spot.Center;
  hnd.bind(new go.Binding("scale","scale", function (sacle) {return 1/sacle}).ofModel());
  ad.add(hnd);

  //....... top right
  hnd = new go.Shape();
  hnd.name = 'HND_TR';
  hnd.figure = 'Circle';
  hnd.desiredSize = size;
  hnd.cursor = 'nesw-resize';
  hnd.fill = "white";
  hnd.stroke = "gray";
  hnd.alignment = go.Spot.TopRight;
  hnd.alignmentFocus = go.Spot.Center;
  hnd.bind(new go.Binding("scale","scale", function (sacle) {return 1/sacle}).ofModel());
  ad.add(hnd);

  //....... bottom right
  hnd = new go.Shape();
  hnd.name = 'HND_BR';
  hnd.figure = 'Circle';
  hnd.desiredSize = size;
  hnd.cursor = 'nwse-resize';
  hnd.fill = "white";
  hnd.stroke = "gray";
  hnd.alignment = go.Spot.BottomRight;
  hnd.alignmentFocus = go.Spot.Center;
  hnd.bind(new go.Binding("scale","scale", function (sacle) {return 1/sacle}).ofModel());
  ad.add(hnd);
  
  ad.adornedObject = resizeBox;
  return ad;
};

/**
 * @hidden @internal
 * Keep the resize handle properly sized as the scale is changing.
 * This overrides an undocumented method on the ResizingTool.
 * @this {OverviewResizingTool}
 * @param {GraphObject} elt
 * @param {number} angle
 */
VZResizeMultipleTool.prototype.updateResizeHandles = function (elt, angle) {
  if (elt === null) return;

  const membnds = board.computePartsBounds(this.diagram.selection);
}