class EraserTool extends go.Tool {
	
	constructor(init) {
		super();

		this.name = "EraserTool";
		this._archetypePartData = {}; // the data to copy for a new polyline Part
		this._isBackgroundOnly = true; // affects canStart()
		this._trailTimer = null;

		// this is the Shape that is shown during a drawing operation
		this._temporaryShape = go.GraphObject.make(go.Shape, { name: "SHAPE", fill: null, strokeWidth: 5.0, stroke: "lightgray" });
		// the Shape has to be inside a temporary Part that is used during the drawing operation
		go.GraphObject.make(go.Part, { layerName: "Tool" }, this._temporaryShape);

		if (init)
			Object.assign(this, init);
	}
}