"use strict";
class CustomViewboxPanelLayout extends go.PanelLayout {
	
	constructor(init) {
		super();
		this.name = "CustomViewboxPanelLayout";
		if (init)
			Object.assign(this, init);
	}

	measure(panel, width, height, elements, union, minw, minh) {
		// go.Panel.Viewbox.prototype.measure.call(panel, width, height, elements, union, minw, minh);

		if (width == Infinity) width = 0;
		if (height == Infinity) height = 0;

		for (var i = 0; i < elements.length; i++) {
			var elem = elements[i];
			this.measureElement(elem, width, height, minw, minh);
		}
		union.width = width;
		union.height = height;
	}

	arrange(panel, elements, union) {

		var textBlock = elements[0];

		var containerBounds = panel.getDocumentBounds();
		var textBounds = textBlock.getDocumentBounds();

		var x = (containerBounds.width * 0.5) - (textBounds.width * 0.5);
		var y = (containerBounds.height * 0.5) - (textBounds.height * 0.5);

		textBlock.position = new go.Point(x, y);
		this.arrangeElement(textBlock, x, y, textBounds.width, textBounds.height);
	}
}