"use strict";

function CustomLinkingTool() {
  go.LinkingTool.call(this);
  this.name = "Linking";
  this._highlightedNode = null;
}
go.Diagram.inherit(CustomLinkingTool, go.LinkingTool);

CustomLinkingTool.prototype.doMouseMove = function() {
  var diagram = this.diagram;
  if (diagram === null) return;
  go.LinkingTool.prototype.doMouseMove.call(this);

  var pointerPosition = diagram.lastInput.documentPoint.copy();
  var targetNode = diagram.findPartAt(pointerPosition, false);

  if (targetNode && targetNode.data) {
    
  }
};

CustomLinkingTool.prototype.doMouseUp = function() {
  var diagram = this.diagram;
  if (diagram === null) return;
  
  go.LinkingTool.prototype.doMouseUp.call(this);

  this.clearHighlightedNode();
};

CustomLinkingTool.prototype.doDeactivate = function() {
  go.LinkingTool.prototype.doDeactivate.call(this);

  if (board.selection) {
    board.selection.each(function (link) {
      if (link.type && link.type.name === "Link" && link.toNode == null && link.fromNode !== null) {
        vueGoInstance.showLinkDropPopup (link);
      }
    });
  }
  board.toolManager.linkingTool.clearHighlightedNode();
};

var nodeHoverAdornment = $(go.Adornment, "Auto",
  $(go.Shape, "Rectangle",
    { fill: "rgba(0,0,0,0.2)", stroke: "dodgerblue", strokeWidth: 2 }),
  $(go.Placeholder),
);

function initialiseMouseMoveListenerForLinkingTool() {

  if (board === null) return;

  board.toolManager.standardMouseOver = function () {
    
    go.ToolManager.prototype.standardMouseOver.call(this);

    if (board.toolManager.linkingTool && board.toolManager.linkingTool.isEnabled) {
      
    }
    else {
      board.toolManager.linkingTool.clearHighlightedNode();
      return;
    }
    var pointerPosition = board.lastInput.documentPoint.copy();
    var targetNode = board.findPartAt(pointerPosition, false);

    if (targetNode && targetNode.data && targetNode.data.linkable) {
      
      if (board.toolManager.linkingTool.highlightedNode !== null) {
        if (targetNode != nodeHoverAdornment.adornedObject) {
          board.toolManager.linkingTool.highlightedNode.removeAdornment("LinkingToolHover");
          board.toolManager.linkingTool.highlightedNode = null;
        }
      }

      if (board.toolManager.linkingTool.highlightedNode == null) {
        board.commit(function(){
          nodeHoverAdornment.adornedObject = targetNode;
          targetNode.addAdornment("LinkingToolHover", nodeHoverAdornment);
        },null);
        board.toolManager.linkingTool.highlightedNode = targetNode;
      }
      else {
        
      }
    }else {
      board.toolManager.linkingTool.clearHighlightedNode();
    }
  };
}

CustomLinkingTool.prototype.clearHighlightedNode = function () {
  if (board.toolManager.linkingTool.highlightedNode != null) {

    board.commit(function(){
      board.toolManager.linkingTool.highlightedNode.removeAdornment("LinkingToolHover");
    },null);
    board.toolManager.linkingTool.highlightedNode = null;
  }
};

Object.defineProperty(CustomLinkingTool.prototype, "highlightedNode", {
  get: function() { return this._highlightedNode; },
  set: function(val) { this._highlightedNode = val; }
});