class CustomDraggingTool extends go.DraggingTool {
	
	constructor(init) {
		super();

		this._parentGroup == null;
		this._ungroupedItems = new go.List();

		if (init)
			Object.assign(this, init);
	}

	doDragOver(pt, obj) {

		var _ungroupedItems = this._ungroupedItems;

		// OK when over a Group or over a Part that is a member of a Group
		if (obj !== null && (obj.part instanceof go.Group || obj.part.containingGroup !== null)) {
			var group = obj.part;
			if (!(group instanceof go.Group)) group = group.containingGroup;
			// only works for one Part, but works when copying as well as when moving
			var nodes = (this.copiedParts || this.draggedParts).iteratorKeys;

			var flag = true;

			var thisGroupItems = new go.List();
			nodes.each(function(node) {
				var ok = group.actualBounds.containsRect(node.actualBounds, false);
				if (!ok) {
					flag = false;
				}
				if (node.data && group.data && node.data.group === group.key) {
					thisGroupItems.add(node);
				}
			});

			if (!flag) {
				if (_ungroupedItems.count == 0 && thisGroupItems.count > 0) {
					var removed = group.diagram.commandHandler.addTopLevelParts(thisGroupItems, true);
					if (removed) {
						this._parentGroup = group;
						_ungroupedItems.addAll(thisGroupItems);
					}
				}
				this.diagram.currentCursor = "not-allowed";
			}
			else {
				this.diagram.currentCursor = "";
			}
		}
	}

	doDropOnto(pt, obj) {
		if (obj !== null && (obj.part instanceof go.Group || obj.part.containingGroup !== null)) {
			var group = obj.part;
			if (!(group instanceof go.Group)) group = group.containingGroup;

			//................
			var nodes = (this.copiedParts || this.draggedParts).iteratorKeys;
			var flag = true;
			console.log("nodes : " + nodes.count);
			nodes.each(function(node) {
				var ok = group.actualBounds.containsRect(node.actualBounds, false);
				console.log("node : " + ok);
				if (!ok) {
					flag = false;
				}
			});
			//.................
			console.log("_ungroupedItems : " + this._ungroupedItems.count);
			if (!flag) {
				this.doCancel();
				console.log("_ungroupedItems : " + this._ungroupedItems);
				if (this._ungroupedItems.count > 0) {
					this._parentGroup.addMembers(this._ungroupedItems, false);
				}
			}
			else {
				console.log("All Ok");
			}
		}
	}

	doDeactivate() {
		super.doDeactivate();
		this._ungroupedItems.clear();
	}
}