function CustomClickCreatingTool() {
  go.ClickCreatingTool.call(this);
  this.name = "ClickCreating";
}
go.Diagram.inherit(CustomClickCreatingTool, go.ClickCreatingTool);

CustomClickCreatingTool.prototype.canStart = function() {
  var diagram = this.diagram;
  var e = diagram.lastInput;
  return e.clickCount == 1 && diagram.toolManager.clickCreatingTool.isEnabled;
};

CustomClickCreatingTool.prototype.insertPart = function(point) {
  var diagram = this.diagram;
  if (diagram === null) return null;
  var arch = this.archetypeNodeData;
  if (arch === null) return null;

  diagram.raiseDiagramEvent("ChangingSelection", diagram.selection);
  this.startTransaction(this.name);

  var part = null;
  if (arch !== null) {
    var data = diagram.model.copyNodeData(arch);
    if (data) {
      data.scale = 1;

      var size;
		let assignSize = true;
		if (data.size) {
			assignSize = false;
			size = go.Size.parse(data.size);
			if (_.isNaN(size.width) || _.isNaN(size.height)) {
				assignSize = true;
			}else {
				size = new go.Size(size.width / diagram.scale, size.height / diagram.scale);
			}
		}
		if(assignSize) {
			if (data.category == "TEXT") {
				size = new go.Size(200 / diagram.scale, NaN);
			}
			else if (data.category == "NOTE") {
				size = new go.Size(200, 200);
				data.scale = 1 / diagram.scale;
			}
			else {
				size = new go.Size(200 / diagram.scale, 200 / diagram.scale);
			}
		}
      data.size = go.Size.stringify(size);
      diagram.model.addNodeData(data);
      part = diagram.findPartForData(data);
    }
  }
  if (part !== null) {

    part.position = point;
    // part.resizeObject.desiredSize = new go.Size(bounds.size.width, NaN);

    if (diagram.allowSelect) {
      diagram.clearSelection();
      part.isSelected = true;
    }
    onNodeCreated(part);
  }

  // set the TransactionResult before raising event, in case it changes the result or cancels the tool
  this.transactionResult = this.name;
  this.stopTransaction();
  diagram.raiseDiagramEvent("ChangedSelection", diagram.selection);

  return part;
};