const GAME_PLAY_ACTIVE_USERS = Vue.component('active-users', {

    name: 'active-users',

    // props: ["location"],

    template: `
	<div class="nodhvr artp arrh lst DB board-history" v-click-outside="onClickOutside">
	    <div class="head ftsb">
	        Active Users
	    </div>
		<ul class="manul bbhistory">				  
		    <div class="day">
		        {{todayDate}}
		    </div>				
			<ul>
				<li v-for="user in activeUsersList" class="rec">						
				    <div class="usr p-rel">
				        <strong>
				            {{user.username}}
				        </strong>
<!--				        <div class="evt p-abs">-->
<!--						    {{user.location}}-->
<!--						</div> -->
						<div class="evt p-abs">
						    {{(user.active)?'Active':'Inactive'}}
						</div> 
						<br>
						<bold>
						    {{ user.location }}
                        </bold>
					</div>						
				</li>
			</ul>
		</ul>
	</div>`,

    data() {
        return {
            activeUsersList: [],
            todayDate: '',
        }
    },

    created() {
        const timeElapsed = Date.now();
        const today = new Date(timeElapsed);
        this.todayDate = today.toDateString();
    },

    mounted() {
        this.loadActiveUsersByLocation();
        this.connect();
    },

    methods: {

        connect: function () {
            let _this = this;
            console.log("connecting to server...")
            let socket = new SockJS('/socket-connection');
            stompClient = Stomp.over(socket);
            stompClient.connect({}, function (frame) {
                console.log('Connected: ' + frame);
                stompClient.subscribe('/topic/synitem/' + loggedInUser.loggedInUserCompany.company.id, function (message) {
                    message = JSON.parse(message.body);
                    const userBoardLocation = JSON.parse(message.content)
                    if (!(userBoardLocation.userId === loggedInUser.userId)) {
                        let index = _.findIndex(_this.activeUsersList, {userId: userBoardLocation.userId});
                        if (index !== -1) {
                            _this.activeUsersList.splice(index, 1, userBoardLocation);
                        } else {
                            _this.activeUsersList.push(userBoardLocation)
                        }
                    }
                });
            });
        },

        loadActiveUsersByLocation: function () {
            let _this = this;
            let data = {};
            data.active = true;
            axios.post("plan/gameplay/list-players", data)
                .then(response => {
                    if (response.status === 200) {
                        _this.activeUsersList = response.data.players
                        _this.canLoadMore = _this.activeUsersList.length === _this.pageSize;
                    }
                })
                .catch(error => {
                    console.log("Unable to send request", error)
                });
        },
        onClickOutside: function () {
            this.$emit("close");
        }
    }
});