const exportColumnSelection = Vue.component("export-column-selection", {
    name: "export-column-selection",
    template: `
        <div id="overlay" class="overlay DAJ" style="display: block;">	              
            <div class="ui-dialog add-pop export-column-selection" style="display: block; top: auto; margin-top: -300px">			
                <div v-if="loader.show" class="loader"><div><div class="loaderinteg"></div></div></div>                
                <div class="dialgtl">
                    <div class="DFA">
                        <span class="fs-22 ftsb">{{title}}</span>
                    </div>
                    <em @click="hide()" title="Close" class="rmv-ico ti-close rnd DAJ"></em>
                </div>                
                <div class="prow cntr minh20">
                <div class="rec lblm">
                    <label>Select Columns</label>
                    <div class="light mb-10">Choose which columns you want to include in the export file.</div>                    
                    <div class="selectcont w-half">
                        <vz-select 
                            :multiple="true" 
                            :empty-selection-text="columnsDisplayText" 
                            :selected-title="columnsDisplayText"
                            class="multi-filter" 
                            track-by="id"
                            value-type="value" 
                            :options="exportColumnOptions" 
                            v-model="exportColumns.selected"
                            @select="onColumnsSelectValue" 
                        />
                    </div>
                </div>                
               </div>
                <div class="rec btn">
                    <button @click="download" class="FR sav mr-10 rnd4">Download</button>
			    	<a href="javascript:void(0);" @click="hide" class="FR cncl">Cancel</a>
                </div>
               
                
            </div> 
        </div>
    `,

    props: ["columnOptions", "title", "selectedColumn"],
    data() {
        return {
            loader: {
                show: false,
                text: "",
            },
            exportColumns: {
                selected: [],
                selectedMap: {}
            },
            exportColumnOptions : [],
        }
    },

    created() {},

    components: {},

    mounted() {
        const processedColumns = (this.columnOptions || []).map(col => {
            return {
                id: col.id,
                title: col.title
            }
        });
        this.exportColumnOptions = [...processedColumns];
        this.exportColumns.selected = [...this.selectedColumn];
        this.exportColumns.selected.unshift("key", "title", "issueType");

        const insertAfter = (array, keyword, itemsToInsert) => {
            const index = array.indexOf(keyword);
            if (index !== -1) {
                array.splice(index + 1, 0, ...itemsToInsert);
            } else {
                array.push(...itemsToInsert);
            }
        };

        if (this.exportColumns.selected.includes("estimate")) {
            insertAfter(this.exportColumns.selected, "estimate", [
                "rollUpEstimate",
                "rollUpEstimateToDo",
                "rollUpEstimateInProgress",
                "rollUpEstimateDone",
                "rollUpEstimateMisc"
            ]);
        }

        if (this.exportColumns.selected.includes("children")) {
            insertAfter(this.exportColumns.selected, "children", [
                "childrenToDo",
                "childrenInProgress",
                "childrenDone",
                "childrenMisc"
            ]);
        }
    },

    computed: {
        selectedColumnsCount() {
            return this.exportColumns.selected ? this.exportColumns.selected.length : 0;
        },

        columnsDisplayText() {
            const count = this.selectedColumnsCount;
            return `Columns (${count})`;
        }
    },

    methods: {

        onColumnsSelectValue: function(values){
        },

        hide: function () {
            enableBodyScroll();
            this.$emit('close');
        },

        download: function () {
            enableBodyScroll();
            this.$emit('download', {selectedColumns: this.exportColumns.selected});
        }

    }
})
