const COLLABORATION_TEMPLATES = Vue.component('collaboration-templates', {
    name: 'collaboration-templates',
// Replace the template section with this:
    template: `
    <div :class="['collaboration-templates', displayMode === 'inline' ? 'collaboration-templates-inline' : 'collaboration-templates-overlay']">
    <div :class="displayMode === 'inline' ? 'templates-inline-container DFAaa' : 'templates-modal'">
        <!-- Header with title and close button - only show in modal mode -->
        <h2 v-if="displayMode !== 'inline'" class="modal-title">
            Select Template for Collaboration Board                
            <a href="javascript:void(0);" class="rmv-ico ti-close" @click="onCancel"></a>
        </h2>
        <div class="cntr-container--a">
            <!-- Loading state -->
            <div v-if="loading" class="template-loading">
                <div class="temp-loaderinteg"></div>
                <div class="no-templates">Loading templates...</div>
            </div>
            
            <!-- No templates message -->
            <div v-else-if="!localTemplatesList || localTemplatesList.length === 0" class="no-templates">
                <p>No templates available</p>
            </div>
            
            <!-- Templates horizontal container -->
            <div v-else :class="displayMode === 'inline' ? 'templates-scroll-container-inline' : 'templates-scroll-container'" >
                <div class="templates-horizontal-list">
                    <!-- No Template Option -->
                    <div 
                        class="template-card no-template-card"
                        :class="{ 'selected': templateSelected && (templateSelected === 'no-template' || templateSelected.title === 'No Template' || (templateSelected.id === null && templateSelected.title === 'No Template')) }"
                        @click.stop="onClickCreateNewBoard"
                    >
                        <div class="template-preview" @click.stop="onClickCreateNewBoard">
                        <div class="no-template-icon">
                            <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
								<circle opacity="0.12" cx="20" cy="20" r="20" fill="#26BAA1"/>
								<path d="M20 11.5C20.2611 11.5 20.4725 11.7116 20.4727 11.9727V19.5273H28.0273C28.2884 19.5275 28.5 19.7389 28.5 20C28.5 20.2611 28.2884 20.4725 28.0273 20.4727H20.4727V28.0273C20.4725 28.2884 20.2611 28.5 20 28.5C19.7389 28.5 19.5275 28.2884 19.5273 28.0273V20.4727H11.9727C11.7116 20.4725 11.5 20.2611 11.5 20C11.5 19.7389 11.7116 19.5275 11.9727 19.5273H19.5273V11.9727C19.5275 11.7116 19.7389 11.5 20 11.5Z" stroke="#1E9984"/>
							</svg>
                        </div>
                        </div>
                        <div class="template-info">No Template</div>
                        <!-- 
                        <div class="template-info">
                            <h4 class="template-title">No Template</h4>
                            <p class="template-description">Create a blank collaboration board from scratch.</p>
                        </div>
                        
				    	
                        <div class="template-actions" v-if="displayMode !== 'inline'">
                            <button class="btn btn-primary use-template-btn" @click.stop="onClickCreateNewBoard">
                                Create Blank Board
                            </button>
                        </div>   -->                    

                    </div>
                    
                    <!-- Template Items -->
                    <div 
                        v-for="template in localTemplatesList" 
                        :key="template.id" 
                        class="template-card"
                        :class="{ 'selected': templateSelected && templateSelected !== 'no-template' && templateSelected.id === template.id }"
                        @click.stop="onTemplateClick(template)"
                    >
                        <div class="template-preview">
                            <img src="../assets/imgs/CollaborationBoard-Template.png" alt="Template Preview" />
                        </div>
                        <!--
                        <div class="template-info">
                            <h4 class="template-title">{{template.title}}</h4>
                            <p class="template-description">{{template.description || 'Manage your workflow in a highly flexible and visual way.'}}</p>
                        </div>
                        -->
				    	<div class="template-info">{{template.title}}</div>
                        <div class="template-actions">
                            <button class="btn btn-primary use-template-btn" @click="onTemplateClick(template)">Use Template</button>
                        </div>
                    </div>
                    
                </div>
            </div>
          </div>
    </div>
    </div>
`,

    props: ['sessionId', 'workspaceId', 'solutionId', 'batchId', 'objectiveCustomViewId', 'contextType', 'removeSelection', 'templatesLoaded', 'selectedTemplate', 'templatesList', 'displayMode'],

    watch: {
        removeSelection(newVal, oldVal) {
            if (newVal){
                this.templateSelected = null;
                this.$emit('selection-cleared');
            }
        },

        // Sync selected template from props
        selectedTemplate(newVal) {
            this.templateSelected = newVal;
        },

        // Sync templates list from props
        templatesList(newVal) {
            if (newVal && newVal.length > 0) {
                this.localTemplatesList = newVal;
            }
        }
    },

    data() {
        return {
            templateSelected: null,
            localTemplatesList: [],
            loading: false,
            error: null,
        }
    },

    mounted() {
        this.templateSelected = this.selectedTemplate;
        // Use props if available, otherwise fetch
        if (this.templatesList && this.templatesList.length > 0) {
            this.localTemplatesList = this.templatesList;
            this.loading = false;
        } else {
            // Set loading to true when fetching templates
            this.loading = true;
            this.fetchTemplates();
        }
    },

    methods: {
        
        onCancel() {
            this.$emit('close');
        },

        onClickCreateNewBoard(template) {
            // if (this.templateSelected === 'no-template') {
            //     this.templateSelected = null;
            //     // Emit null selection to parent
            //     this.$emit('template-select', {
            //         id: null,
            //         title: null,
            //         template: null
            //     });
            // } else {
            //     // Clear any previous selection and select no-template
            //     this.templateSelected = 'no-template';
            //     // Emit to parent that no template is selected
            //     this.$emit('template-select', {
            //         id: null,
            //         title: 'No Template',
            //         template: null
            //     });
            // }
            
            this.$emit('template-used', {
                id: null,
                title: 'No Template',
                template: null
            });

            this.$forceUpdate();
        },

        onTemplateClick(template) {
            this.$emit('template-used', template);
            // if (this.templateSelected &&
            //     this.templateSelected !== 'no-template' &&
            //     this.templateSelected.id === template.id) {
            //     // If the same template is clicked again, unselect it
            //     this.templateSelected = null;
            //     console.log("Template unselected:", template.title);
            //
            //     this.$emit('template-select', {
            //         id: null,
            //         title: null,
            //         template: null
            //     });
            // } else {
            //     // Clear any previous selection and set new template
            //     this.templateSelected = template;
            //     console.log("Template selected:", template);
            //
            //     this.$emit('template-select', {
            //         id: template.id,
            //         title: template.title,
            //         template: template
            //     });
            // }

            this.$forceUpdate();
        },

        fetchTemplates() {
            this.loading = true;
            this.error = null;

            axios.get('/graphx/template/all/' + loggedInUser.id)
                .then(response => {
                    if (response.data && response.data.success) {
                        this.loading = false;
                        this.localTemplatesList = response.data.systemTemplates || [];
                        this.$emit('templates-fetched', response.data.systemTemplates || []);
                    } else {
                        this.loading = false;
                        this.error = 'Failed to load templates';
                    }
                })
                .catch(error => {
                    console.error('Error fetching templates:', error);
                    this.loading = false;
                    this.error = 'Failed to load templates';
                })
        },

    }

});
