const CollaborationBoardType = Vue.component('collaboration-board-type', {
    template: `
        <div class="collab-type-container">
        
            <div class="main-head DFCB">
                <span id="icttp-TokenSttngOkta" class="mnhd">Collab Board Types</span> 
                <div class="rht DFA">                	
                    <button class="addf h-32 rnd4" @click="openCreateModal" v-if="permissions.CREATE_COLLAB_TYPE">Create Collab Board Type</button>                    
                </div>
            </div>

            <!-- Type Listing Table -->
    	<div class="section">
		  <div class="table">
		      <div class="rec hd">
		        <div class="rc c2">Type Name</div>
		        <div class="p-abs rc" style="right: 10px; width: auto;" v-if="permissions.EDIT_COLLAB_TYPE || permissions.DELETE_COLLAB_TYPE">Actions</div>
		      </div>
		<!--    <draggable v-model="types" tag="tbody" @end="onTypeDragEnd">-->
		      <div v-for="type in types" :key="type.id" class="rec inn">
		        <div class="rc c2 DFA">{{type.title}}</div>
		        
		          <div class="r-icons mnuout" v-if="permissions.EDIT_COLLAB_TYPE || permissions.DELETE_COLLAB_TYPE">
		            <em class="ti-menu mnu" @click="showEditOptions = !showEditOptions; selectedMenuIndex=type.id"></em>
		            <div v-if="showEditOptions && selectedMenuIndex == type.id" class="drop_box nwmu artp" style="display:block;">
		              <ul id="settingsList" class="list">
		                <li @click="editType(type)" v-if="permissions.EDIT_COLLAB_TYPE"> <a href="javascript:void(0);"><em class="ti-pencil"></em> Edit</a></li>
		                <li @click="deleteType(type)" v-if="permissions.DELETE_COLLAB_TYPE"> <a href="javascript:void(0);"><em class="ti-trash"></em>Delete</a></li>
		              </ul>
		            </div>
		          </div>
		        
		      </div>
		      
		<!--    </draggable>-->
		  </div>
		  <div v-if="types.length === 0" class="fs-14 nofound prow mt-50">No Collaboration Types found.</div>
		</div>

            <!-- Permission Notice for Non-Super Admins -->
            <div v-if="!isSuperAdmin" class="permission-notice-full">
                <div class="permission-notice-content">
                    <i class="ti-lock"></i>
                    <div>
                        <h4>Access Restricted</h4>
                        <p>Only Super Administrators can manage collaboration board types and permissions.</p>
                    </div>
                </div>
            </div>

            <!-- Modal for Create/Edit -->
            <div class="overlay DFA" v-if="showModal" @click="closeModal" style="display:block;">
                <div class="ui-dialog midpop" @click.stop>
                    <div class="head">
                        {{isEdit ? 'Edit' : 'Create'}} Collaboration Type                        
                        <em title="Close" class="rmv-ico ti-close" @click="closeModal"></em>
                    </div>
                    <div class="prow cntr min-ht250">
                    <form @submit.prevent="saveType">
                        <div class="rec lblm">
                            <label>Name *</label>
                            <input type="text" v-model="typeForm.title" required class="form-control rnd4" />
                        </div>
<!--                        <div class="rec lblm">-->
<!--                            <label>Description</label>-->
<!--                            <textarea v-model="typeForm.description" class="form-control" rows="3"></textarea>-->
<!--                        </div>-->
                       
                        <div class="rec btn">
                            <button type="submit" class="button FR">{{isEdit ? 'Update' : 'Create'}}</button>
					    	<a href="javascript:void(0);" class="cncl FR" @click="closeModal">Cancel</a>
                        </div>
                    </form>
                    </div>
                </div>
            </div>

        </div>
    `,

    components: {
        'draggable': window['vuedraggable'],
    },

    data() {
        return {
            types: [],
            editingType: null,
            showModal: false,
            showEditOptions: false,
            selectedMenuIndex: null,
            isEdit: false,
            loading: false,
            editingTypeId: null,
            typeForm: {
                title: "",
                id: null,
            },
            permissions: {
                CREATE_COLLAB_TYPE: false,
                EDIT_COLLAB_TYPE: false,
                DELETE_COLLAB_TYPE: false
            },
            isSuperAdmin: false
        };
    },

    mounted() {
        this.setupPermissions();
        this.loadTypes();
    },

    methods: {
        setupPermissions() {
            // Check if user is super admin
            this.isSuperAdmin = loggedInUser && (loggedInUser.isSuperAdmin || loggedInUser.isAdmin);
            
            if (this.isSuperAdmin) {
                // Grant all permissions to super admins
                this.permissions = {
                    CREATE_COLLAB_TYPE: true,
                    EDIT_COLLAB_TYPE: true,
                    DELETE_COLLAB_TYPE: true
                };
            } else {
                // Non-super admins have no permissions
                this.permissions = {
                    CREATE_COLLAB_TYPE: false,
                    EDIT_COLLAB_TYPE: false,
                    DELETE_COLLAB_TYPE: false
                };
            }
        },

        openCreateModal() {
            if (!this.permissions.CREATE_COLLAB_TYPE) {
                showTopMessage('Only Super Administrators can create collaboration types', 'error');
                return;
            }
            
            this.isEdit = false;
            this.typeForm = {};
            this.showModal = true;
        },

        loadTypes() {
            this.loading = true;
            axios.get('/collaboration-type/all')
                .then(response => {
                    if (response.data?.success) {
                        response.data?.types.forEach(type => {
                            if(!type?.defaultOrigin && type.rowStatus !== 1){
                                this.types.push(type);
                            }
                        })
                    }
                })
                .catch(error => {
                    console.error('Error loading types:', error);
                    showTopMessage('Failed to load collaboration types', 'error');
                })
                .finally(() => {
                    this.loading = false;
                });
        },

        editType(type) {
            if (!this.permissions.EDIT_COLLAB_TYPE) {
                showTopMessage('Only Super Administrators can edit collaboration types', 'error');
                return;
            }
            
            this.isEdit = true;
            this.typeForm = Object.assign({}, type);
            this.editingTypeId = type.id;
            this.showModal = true;
        },

        saveType() {
            if (!this.permissions.CREATE_COLLAB_TYPE && !this.permissions.EDIT_COLLAB_TYPE) {
                showTopMessage('Only Super Administrators can manage collaboration types', 'error');
                return;
            }

            const url = this.isEdit
                ? `/collaboration-type/update/${this.typeForm.id}`
                : '/collaboration-type/create';
            const method = this.isEdit ? 'put' : 'post';

            axios[method](url, this.typeForm)
                .then(response => {
                    if (response.data?.success) {
                        const savedType = response.data.type;

                        if (this.isEdit && savedType) {
                            const index = this.types.findIndex(t => t.id === this.editingTypeId);
                            if (index !== -1) {
                                this.types.splice(index, 1, savedType);
                            }
                        } else {
                            this.types.push(savedType);
                        }

                        showTopMessage('Type saved successfully', 'success');
                        this.closeModal();
                    } else {
                        showTopMessage('Failed to save type', 'error');
                    }
                })
                .catch(error => {
                    console.error('Error saving type:', error);
                    showTopMessage('Failed to save type', 'error');
                });
        },

        deleteType(type) {
            if (!this.permissions.DELETE_COLLAB_TYPE) {
                showTopMessage('Only Super Administrators can delete collaboration types', 'error');
                return;
            }

            askFromSweetAlertWrapper(
                "Are you sure you want to delete this type?",
                [() => this.onConfirmDeleteType(type)],
                [takeNoAction]
            );
        },

        onConfirmDeleteType(type){
            axios.delete(`/collaboration-type/delete/${type.id}`)
                .then(response => {
                    if (response.data?.success) {
                        showTopMessage('Type deleted successfully', 'success');

                        const index = this.types.findIndex(t => t.id === type.id);
                        if (index !== -1) {
                            this.types.splice(index, 1);
                        }
                    } else {
                        showTopMessage('Failed to delete type', 'error');
                    }
                })
                .catch(error => {
                    console.error('Error deleting type:', error);
                    showTopMessage('Failed to delete type', 'error');
                });
        },

        closeModal() {
            this.showModal = false;
            this.editingTypeId = null;
            this.typeForm = {
                id: null,
                title: '',
            };
        },

        onTypeDragEnd(evt) {
            // Handle drag end, e.g., update order in backend if needed
            // Optionally send new order to server here
        },
    }
});
