let BATCH_TIMELINE_VIEW = Vue.component("batch-timeline-view", {
	name: 'batch-timeline-view',
	template: `
	<div class="timelineview">
		<template v-if="loader.show">
			 <div id="body-loader" class="loader"><div><div class="loaderinteg"></div><span class="LOADER-TITLE">{{loader.text}}</span></div></div> 
		</template>
		<div ref="gantt" class="gantcont"></div>
	</div>
	`,
	props: {

	},
	data() {
		return {
			loader: {
				show: false,
				text: ""
			}
		}
	},
	created() {
		
	},
	mounted() {
		if (!this.$root.ganttModuleLoaded) {
			loadModuleScript('/assets/js/lib/roadmap/gantt.module-latest.js', function(module){
				vueInstance.$options.GANTT_MODULE = _module;
				vueInstance.ganttModuleLoaded = true;
			});
		}else {
			this.initialiseView();
		}
	},
	computed: {
		ganttModuleLoaded() {
			return this.$root.ganttModuleLoaded;
		}
	},
	watch: {
		"ganttModuleLoaded": {
			handler(newValue, oldValue) {
				this.initialiseView();
			}
		}
	},
	components: {
	},
	methods: {
		////////////////////////////////////////////////
		//       LOGIC
		initialiseView: function () {
			this.initialiseGantt();
			this.createDataForTimeline();
		},
		initialiseGantt: function () {
			let _this = this;
			
			if (vueInstance.$options.GANTT_MODULE) {
				const gantt = new vueInstance.$options.GANTT_MODULE.Gantt({
					subGridConfigs: {
						locked: {
							width: 300
						}
					},
					columns: [
						{
							width: 200,
							name: "name",
							id: "name",
							text: "name",
							type: "name",
							editor: false,
							htmlEncode: false,
							renderer(event) {
								let { value, record, column } = event;
								return _this.nameColumnRenderer(value, record, column);
							},
						},
						{
							text: "status",
							editor: false,
							htmlEncode: false,
							renderer(event) {
								let { value, record, column } = event;
								return _this.statusColumnRenderer(value, record, column);
							},
						}
					],
					listeners: {
						gridRowBeforeDropFinalize: async (event) => {
							// true to accept the drop or false to reject
							let context = event.context;
							let oldPositionContext = event.context.oldPositionContext[0];
							return context.parent.id === oldPositionContext.parentId;
						},
						gridRowDrop: (event) => {							
							
						},
						beforeTaskDrag({ taskRecord }) {
							// Only allow dragging tasks that has not started
							return false;
						},
						beforeTaskResize({ taskRecord }) {
							// Only allow dragging tasks that has not started
							return false;
						},
						taskResizeEnd(event) {
							
						},
						taskDrop(event, a, b) {
							
							return false;
						},
						taskClick(event) {
							
							return false;
						},
						cellclick: function(event) {
							
						},
						beforeToggleNode(event) {
							
						}
					},
					columnLines: true,
					features: {
						search: true,
						filter: true,
						timeRanges: true,
						baselines: {
							
						},
						taskTooltip: {
							
						},
						taskMenu: false,
						tree: {

						},
						taskEdit: false,
						projectLines: false,
						percentBar: {
							allowResize: false,
							showPercentage: true
						},
						timeAxisHeaderMenu: {
							disabled: true
						},
						sort:  false,
						headerMenu: {
							disabled: true
						},
						rowReorder: {
							disabled: true
						},
						taskDragCreate: {
							disabled: true
						},
					},
					timeAxis: { mainUnit: 'day', autoAdjust: false },
					rowHeight: 55,
					project: {
						listeners: {
							
						},
						autoCalculatePercentDoneForParentTasks: false
					},
					appendTo: this.$refs.gantt
					
				});
				this.$options.gantt = gantt;
				this.$options.gantt.features.infinite = true;

			}
			// Add the timespan to the Gantt chart	
		},
		createDataForTimeline: function () {
			
			let _this = this;
			
			if (!this.$root.batches.treeForm) {
				return;
			}
			
			let startDateFieldMap = {};
			let endDateFieldMap   = {};
			
			for (let fieldId in this.$root.batches.fieldsData) {
				if (this.$root.batches.fieldsData[fieldId].title == "Start Date") {
					startDateFieldMap[fieldId] = true;
				}
				if (this.$root.batches.fieldsData[fieldId].title == "End Date") {
					endDateFieldMap[fieldId] = true;
				}
			}
			
			let dataJSON = JSON.stringify(this.$root.batches.treeForm);
			let batchGroups = JSON.parse(dataJSON);
			_.each(batchGroups, batchGroup=> {
				createTimelineItem(batchGroup,batchGroup.baseItemList);
				_this.$options.gantt.taskStore.add(batchGroup);
			});
			
			function createTimelineItem(batch, children, startDateFieldMap, endDateFieldMap) {
				if (children) {
					batch.children = children;
					batch.expanded = true;
					
					//......   start date / end date
					let startDate;
					for (let fieldId in startDateFieldMap) {
						
					}
					//..............................
					
					delete batch.baseItemList;
					_.each(children, child=> {
						createTimelineItem(child, child.baseItemList, startDateFieldMap, endDateFieldMap);
					});
				}
			}
		},
		nameColumnRenderer: function (value, item, column) {
			
			let html = "";
			if (!_.isEmpty(item.key)) {
				
				let baseRoute = this.$route.path;
				if (baseRoute[baseRoute.length - 1] != '/') {
					baseRoute = baseRoute + '/';
				}
				let objectURL = baseRoute + item.key

				html += "<a class='key fs-13 ftsb jiraKeyHandle kendisOnly' href=" + objectURL + " target='_blank'>" + item.key + "</a>";
			}
			
			html += "<span class='name elips b'>" + item.title + "</span>";
			
			return html;
		},
		statusColumnRenderer: function (value, item, column) {
			let html = "";
			
			if (!_.isEmpty(item.status)) {
				let _class = item.status.category == 'ToDo' ? 'a' : item.status.category == 'InProgress' ? 'b' : item.status.category == 'Done' ? 'c' : 'd';

				html += "<span class='fstatus status dot'>";
				html += "<span class='elips sts " + _class + "' title='" + item.status.title + "'></span>";
				html += "<span>" + item.status.title + "</span>";
				html += "</span>";
			}

			return html;
		},
		////////////////////////////////////////////////
		//       API METHODS
		////////////////////////////////////////////////
		//       EVENTS
	}
});


let LIST_BATCHES_VIEW = Vue.component("list-batches-view", {
    //root batch component
    name: 'listBatchesView',
    template: `
<div class="listBatchesView"> 

	    <dynamic-popup-container 
	         v-if="itemTemplate.showEditPopUp"
	         @close = "onCLoseEditPopUp"
	         @save = "onSaveBatch"
	         :template-to-render="itemTemplate.templateToRenderer"
	         :template-statuses = "itemTemplate.statuses"
	         :item-type="itemTemplate.itemType"
	         :fields-value="itemTemplate.model"
	         :template = "itemTemplate"
	         :show-attachments="false"
	         :show-watchers="true"
	         :show-history="true"
	         :show-conversations="true"
	         :entity-type="'BaseItem'"
	         :entity-id="itemTemplate.id"
	         :show-external-entities="false"
		     :displayMode ="'Batches'"
		     :edit-permission="true"
		     :showNotifyWatchers="false"
	    />

			<div class="mcontainer">
			        <div  v-if="loading || !isBatchesLoaded" class="loader"><div><div class="loaderinteg"></div>Loading ...</div></div>
                    <div v-if = "$root.batches.treeForm && $root.batches.treeForm.length>0" class="tpbar DFA">
                        <div  class="FA FG"><div class="ftsb name ">{{workspace.title}}</div>
							
						</div>
                        <div class="selectcont nwsl FL w-200 h-auto"  v-if ="viewIndex == 0"  style="margin: -9px 0;">
                        	<vz-select :options="$root.batches.treeForm" empty-selection-text="Select Batch Groups" v-model="selectedBatches" :multiple="true" label="title" track-by="title"  selected-title="Batch Groups" /> 
                        </div>
                      	<div v-if="viewIndex == 0" class="zoomout FR"><em id="zoom-out"  class="ti-zoom-out icls DAJ" @click="zoomClick(false, scaleLevel > 50)"></em> <span class="val">{{this.scaleLevel}}%</span> <em id="zoom-in" class="ti-zoom-in icls DAJ lst" @click="zoomClick(true, scaleLevel < 130)"></em></div>
					    <a class="tabs DAJ treeviewico" href="javascript:void(0);" :class="[viewIndex == 0 ? 'active': '']" @click="onSwitchViewMode(0);reCreateSortedBatchList()" title="Tree View">  </a>
					    <a class="tabs DAJ listviewico" href="javascript:void(0);" :class="[viewIndex == 1 ? 'active': '']" @click="onSwitchViewMode(1)" title="List View"> </a>
					    <div v-if="$options.permissions && $options.permissions.MANAGE_BATCH_GROUP" class="stngmn ml-20 DAJ c-point" @click="showSettingsPopup = true"><em class="stgico3 ico DB mr-10"></em>Settings</div>
                    </div>
                    <div :class="createBatchesClass()">
                        <list-batches v-if = "viewIndex == 1" :release-train-id ="releaseTrainId"  @batch-group-added="addBatchGroup"></list-batches>
                        <div  v-if = "viewIndex == 0" >
                             <div v-if = " isBatchesLoaded && $root.batches.treeForm && $root.batches.treeForm.length==0" class="prow" draggable="false">
								<div v-if="roleErrorMessage !='' "class="expmsg" v-html="roleErrorMessage"></div>
                             	<div class="nobrdcnt">
		                       	<div class="nobrdPopW batchbg">
						  			<div class="nobrdPop">
						  				<div class="mt-30">
							  				<div class="kLogo"><img src="assets/imgs/k-logo.png" alt="logo" /></div>
						  					<div class="mb-30 txt-cntr"><img src="assets/icons/nobatch.svg" alt="nobatch" /> </div>
						  					<div class="DFA JC">
							  					<div>
							  						<h2 class="nobrdhed">Create Your First Batch View</h2>
							  						<p class="mb-30 txt-cntr">Breakdown your Portfolio, Projects or Programs into smaller, workable batches.</p>
							  						<div  class="DF JC mb-10" v-if="this.$options.permissions && this.$options.permissions.MANAGE_BATCH_GROUP">
														<button @click="onAddBatchClick" class="crtboard button"><em class="ti-plus ico"></em>Create Now</button>
													</div>
							  						<div class="txt-cntr">
										        		<a href="https://help.kendis.io/en/articles/8159723-how-to-use-batches" target="_blank">Learn more</a>
										        	</div>
							  					</div>							  					
  											</div>
						  				</div>
						  			</div>
  							  	</div>
	                       	</div>
                            </div>
                            <div v-if = "isBatchesLoaded" id="panzoomParent">
                              <div v-if ="sortedBatchList && sortedBatchList.length>0" v-for="(batch, batchIndex) in sortedBatchList" class="batch-cont">
                                <batches-tree-view :base-route-path="baseRoutePath" v-if = "!_.isEmpty(sortedBatchList)" :batch-object = "batch" :key = "batch.id" ></batches-tree-view>
                            </div>
                            </div>
                        </div>
                        <batch-timeline-view v-if = "viewIndex == 2"
                        />
                	</div>
                </div>
				<vuepopup v-if="showSettingsPopup" >
					<objective-settings-popup :type="type" @close="showSettingsPopup = false;"></objective-settings-popup>
				</vuepopup>
                </div>

		`,
    data() {
        return {
            selectedBatches:[],
            showBatchesTree: true,
            viewIndex: 0,
            
            scaleLevel:100,
            zoomActive:false,
            loading: false,
            isBatchesLoaded: false,
            baseRoutePath:"",
            itemTemplate: {
                showEditPopUp: false,
                showMileStonePopup: false,
                templateToRenderer: {},
                statuses: [],
                itemType: {},
            },
			type : "batch",
			showSettingsPopup : false,
			userPermissions : [],
			roleErrorMessage : '',
			sortedBatchList : [],
			batchIds : []
		}
    },
	computed : {
		workspace (){
			return kendisStore.getters.getBatchWorkspace();
		}
	},
    props: {
        releaseTrainId: {
            type: String,
            default: () => { return "" }
        },
        viewType: {
            type: String,
            default: () => { return "" }
        },
        isReleaseTrainMode: {
            type: Boolean,
            default: () => { return false }
        }
    },
    watch:{
        "$root.flags.refetchData": function (newVal, oldVal) {
            let _this = this;
            if(newVal){
                if(!_this.isReleaseTrainMode){this.loadBatchGroups();}
                _this.$root.flags.refetchData = false;
            }
        },
		'selectedBatches': { // watch for changes in sequence so render on order change
			handler: function (val, oldVal) {
				let _this = this;
				let unsortedBatchList = _.clone(val);
				unsortedBatchList.sort(function (a, b) {
					return a.sequence - b.sequence;
				});
				Vue.set(_this,'sortedBatchList',unsortedBatchList);
				for(batchGroup of this.selectedBatches){
					this.recursiveExtract(batchGroup);
				}},

		},
		'$root.batches.treeForm': { // watch for changes in sequence so render on order change
			handler: function (val, oldVal) {
				let _this = this;
				let unsortedBatchList = _.clone(val);
				unsortedBatchList.sort(function (a, b) {
					return a.sequence - b.sequence;
				});
				Vue.set(_this,'sortedBatchList',unsortedBatchList);			},
			deep: true
		},
    },
    created() {
    	interceptAxioCalls();
    	//if(!checkFlagOnORG( loggedInUser,'batches')){
	    //	window.location.hash = window.location.hash.split('/batches')[0]+'/backlog';
		//}
        if(!_.isEmpty(this.releaseTrainId)){
            this.baseRoutePath = "/"+this.viewType+"/"+this.releaseTrainId+"/batches/";
        }else{
            this.baseRoutePath="/";
        }

        this.initBatchesModalTemplate();
        syncId = getNewUUID();
		this.fetchWorkspace();
		EventBus.$on('fetchAllBatchIds', () => {
			EventBus.$emit("returnAllBatchIds",this.batchIds);
		});
    },
    mounted() {
            this.activateZoom();
          },
    components: {
        'link-item':link_item,
        'dynamic-popup-container'	: DYNAMIC_POPUP_CONTAINER,
        'list-batches'				: LIST_BATCHES,
        'batch-group-component'		: BATCH_GROUP_COMPONENT,
        'sub-batch-component'		: SUB_BATCH_COMPONENT,
        'batches-tree-view'	        : BATCHES_TREE_VIEW,
        'objective-link'            : OBJECTIVE_LINK,
        'link-okr'                  : LINK_OKR,
        'sub-items-listing'	:	GET_SUB_ITEMS_LISTING_TEMPLATE(),

	},

    methods: {
		reCreateSortedBatchList: function () {
			let _this = this;
			let unsortedBatchList = _.clone(_this.selectedBatches);
			unsortedBatchList.sort(function (a, b) {
				return a.sequence - b.sequence;
			});
			Vue.set(_this,'sortedBatchList',unsortedBatchList);
		},
		generateBatchesKeyMap: function (batchesTree) {
			let batchesKeymap = {};
			try{
				let _this = this;
				batchesTree.forEach(function (batch) {
					batchesKeymap[batch.id] = batch;
					_this.traverseChildrenBatches(batch,batchesKeymap);
				});
			}catch (e) {
				console.log(e);
			}
			return batchesKeymap;
		},
		traverseChildrenBatches(batch,batchesKeymap){
			let _this = this;
			if(!batch.baseItemList || _.isEmpty(batch.baseItemList)){
				return;
			}
			if(batch.baseItemList && batch.baseItemList.length > 0){
				batch.baseItemList.forEach(function (item) {
					batchesKeymap[item.id] = item;
					_this.traverseChildrenBatches(item,batchesKeymap);
				})
			}
		},
		fetchWorkspace : function () {
			var _this = this;
			kendisStore.commit('setBatchWorkspace',{});
			axios.get("/releasetrain/get/workspace-module/" + this.type)
				.then(response => {
					if (response.data) {
						if(response.data.workspace) {
							kendisStore.commit('setBatchWorkspace',response.data.workspace);
							_this.setBatchesPermissions(response.data.workspace);
							if(!_this.isReleaseTrainMode){_this.loadBatchGroups();}
						}
						_this.setupPermissions();
					}
				}).catch(error => {

				});
		},
		setBatchesPermissions: function(wS) {
			var batchRoles = _.filter(loggedInUser.accessRoles, function(o) {
				return o.workSpace && o.workSpace.id && o.workSpace.id == wS.id;
			});
			var roles = [];
			var permissions = [];
			if(loggedInUser.isAdmin && _.isEmpty(batchRoles)) {
				permissions = loggedInUser.permissions; 
			}
			_.each(batchRoles, accessRole => {
				if (loggedInUser.isGuest === true) {
					permissions = [];
				} else if (loggedInUser.isAdmin === true) {
					permissions = loggedInUser.permissions;
				} else {
					_.each(accessRole.roles, role => {
						roles.push(role);
						permissions = _.union(permissions, _.difference(loggedInUser.permissions, role.restrictions))
					});
				}
			});
			this.userPermissions = permissions
		},

		isActionAllowed: function(action) {
			var permissions = this.userPermissions;
			if ((permissions && permissions.length > 0 && permissions.indexOf(action) > -1)) {
				return true;
			} else {
				return false;
			}
		},
		setupPermissions: function() {
			let permissions = {
				MANAGE_BATCH_GROUP		: this.isActionAllowed("manage-batch-group"),
				ADD_EDIT_BATCH			: this.isActionAllowed("add-edit-batch"),
				LINK_UNLINK_BATCH_ITEMS	: this.isActionAllowed("link-unlink-item-batch"),
				DELETE_BATCH			: this.isActionAllowed("delete-batch")
			};
			this.$options.permissions = permissions;
			kendisStore.commit('setBatchesPermissions', permissions);
		},
        createBatchesClass: function () {
            let _class= "";
            if(this.$root.batches.treeForm && this.$root.batches.treeForm.length==0){
                _class = "";
            }else{
                _class='batchover';
            }
            if(this.releaseTrainId && this.releaseTrainId!=""){
                _class = _class+" releaseTrainMode";
            }
            return _class
        },
        addBatchGroup: function(newBatchGroup){
            Vue.set(this.$root.batches.treeForm,this.$root.batches.treeForm,newBatchGroup);
        },
        createBatchesClass: function () {
            let _class= "";
            if(this.$root.batches.treeForm && this.$root.batches.treeForm.length==0){
                _class = "";
            }else{
                _class='batchover';
            }
            if(this.releaseTrainId && this.releaseTrainId!=""){
                _class = _class+" releaseTrainMode";

            }
            return _class
        },
        onCLoseEditPopUp: function () {
            let _this = this;
            _this.itemTemplate.showEditPopUp = false;
            _this.$forceUpdate();
        },
        setBaseItemStatus: function (requestBody) {
            if (_.isEmpty(requestBody.status)) {
                if(requestBody.type=="Batch"){
                    if (_.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"}) !== -1) {
                        requestBody.status = _.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"});
                    }
                }else{
                    if (_.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"}) !== -1) {
                        requestBody.status = _.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"});
                    }
                }
            }
        },
        onSaveBatch: function(requestBody) {
            console.log("Data", requestBody)
            let _this = this;
            delete requestBody.bvPlan;
            delete requestBody.bvActual;
            let selfLink = {type: "batch_group"};
            requestBody.baseItemLinks = [];

            //attaching releaseTrain
            if(_this.releaseTrainId && !_.isEmpty(_this.releaseTrainId)){
                let releaseTrainLink = {type: "release_train_batch", releaseTrainId:_this.releaseTrainId};
                requestBody.baseItemLinks.push(releaseTrainLink);
            }
            requestBody.baseItemLinks.push(selfLink);
            requestBody.starred = false;
            this.setBaseItemStatus(requestBody);
            axios.post('external-entitites/save-base-item/popup-save', requestBody)
                .then(response => {
                    if (response.status == "200" && response && response.data && response.data.impediment) {
                        _this.$root.batches.treeForm.push(response.data.impediment);
                    }
                })
                .catch(error => {
                    console.error("Issue occurred while creating new Batch Group", error);
                });
            _this.onCLoseEditPopUp();
        },
        onAddBatchClick: function() {
            let _this = this;
            _this.itemTemplate = {};
            _this.itemTemplate.model = {};
            _this.itemTemplate.model.fields = {};
            _this.itemTemplate.model.status = {};
            //fixed headercolor if not selected
            _this.itemTemplate.model.headerColor = ""
            _this.itemTemplate.model.imageIcon = {};


            _this.itemTemplate.statuses = [];
            if (_.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"}) !== -1) {
                _this.itemTemplate.model.status = _.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"});
            }
            _this.itemTemplate.templateToRenderer = kendisStore.getters.getBatchGroupTemplate().scheme.fieldsTemplate;
            _this.itemTemplate.statuses = kendisStore.getters.getBatchGroupTemplate().statuses;
            _this.itemTemplate.itemType = kendisStore.getters.getBatchGroupTemplate().scheme.itemType;
            _this.itemTemplate.showEditPopUp = true;
            _this.$forceUpdate();
        },
        activateZoom: function(){
            let _this = this;
            $(document).ready(function() {
                let zoomLevel = 0.03;
                let minZoom = 0.7; // Adjust the minimum allowed zoom level
                let maxZoom = 1.7;
                let duration = 200;
                let $panzoom = $('#panzoomParent').panzoom({
                    increment: zoomLevel,
                    duration: duration,
                    minScale: minZoom,
                    maxScale: maxZoom
                });

                $('#zoom-in').on('click', function() {
                    $panzoom.panzoom('zoom');
                });

                $('#zoom-out').on('click', function() {
                    $panzoom.panzoom('zoom', true);
                });
            });
        },
        zoomClick(isZoomIn, isZoomAllowed) {
            if (isZoomAllowed) {
                this.scaleLevel = isZoomIn ? this.scaleLevel + 10 : this.scaleLevel - 10;
            }
            if(!this.zoomActive) {
                this.activateZoom();
                this.zoomActive=true
            }
        },
        initBatchesModalTemplate: function() {
            let _this = this;
            _this.loading= true;

            axios.get('batch/get-batch-modal-template')
                .then(response=>{
                    if(response.status == "200") {
                        let templates = {};
                        templates.batchGroupTemplate = {
                            scheme: response.data.batchGroupTemplate.scheme,
                            statuses: response.data.batchGroupTemplate.statuses
                        };
                        if (templates.batchGroupTemplate.scheme.fieldsTemplate) {
                            _.each(templates.batchGroupTemplate.scheme.fieldsTemplate.configuredFields, field => {
                                if (field.isGroup) {
                                    field.subTemplate = {};
                                    field.subTemplate.configuredFields = field.groupFields;
                                }
                            })
                        }
                        templates.batchTemplate = {
                            scheme: response.data.batchTemplate.scheme,
                            statuses: response.data.batchTemplate.statuses
                        };
                        if (templates.batchTemplate.scheme.fieldsTemplate) {
                            _.each(templates.batchTemplate.scheme.fieldsTemplate.configuredFields, field => {
                                if (field.isGroup) {
                                    field.subTemplate = {};
                                    field.subTemplate.configuredFields = field.groupFields;
                                }
                            })
                        }
                        kendisStore.commit("setBatchAndBatchGroupTemplate", templates);
                    }
                })
                .catch(error=>{
                    console.log(error);
                }).finally(function () {
                    _this.loading= false;
                });

		},
		loadBatchGroups: function () {
			let _this = this;
			_this.loading= true;
			_this.isBatchesLoaded = false;

			let requestJson = {
				isTreeView : true,
				isListView: true,
				isFields: true,
				releaseTrainId: this.releaseTrainId
			}
			var batchRoles = _.filter(loggedInUser.accessRoles, function(o) {
				return o.workSpace && o.workSpace.id && o.workSpace.id == _this.workspace.id;
			});
			if (_.isEmpty(batchRoles) && !loggedInUser.isAdmin) {
				_this.loading = false;
				_this.isBatchesLoaded = true;
				_this.roleErrorMessage = "You do not have any role assigned for Batches";
			}else{
	            axios.post('batch/get-all-batches', requestJson)
	                .then(response => {
	                    if (response.status == "200" && response.data.success && response.data.batches && response.data.batchesList) {
	                        let fetchedBatches=response.data.batches;
	                        _this.addAttributesToBatches(fetchedBatches);
	                        _this.$root.batches.treeForm = response.data.batches;
							_this.setSelectedBatches(response.data.batches);
	                        _this.$root.batches.listForm = response.data.batchesList;
							_this.$root.batches.keyMap= _this.generateBatchesKeyMap(response.data.batches);
							let fieldList = response.data.fieldList;
	                        let fieldsMap = {};
	                        if( fieldList && fieldList.length > 0) {
	                            fieldList.forEach(function (field) {
	                                fieldsMap[field.id] = {}
	                                fieldsMap[field.id].title = field.title;
	                                fieldsMap[field.id].type = field.type;
	                            })
	                            _this.$root.batches.fieldsData = fieldsMap;
	                        }                    }
	                    _this.loading= false;
	                    _this.isBatchesLoaded = true;
						_this.$root.flags.batchLoadedTrigger += 1;
						_this.onBatchFetchCompletion();
						// _this.updateBatchCompletionMap(_this.fetchItemIdsBatches(), _this.$root.batches.listForm);


					})
	                .catch(error => {
	                    console.error("Item save error", error);
	                }).finally(function () {
	                    _this.loading= false;
	                    _this.isBatchesLoaded = true;
						_this.roleErrorMessage = "";
	                });
			}
		},
		setSelectedBatches(fetchedNewBatchGroups){
			let _this = this;
			if(!_this.selectedBatches || _this.selectedBatches.length == 0) {
				_this.selectedBatches = fetchedNewBatchGroups
				return;
			}

			let selectedBatches = this.selectedBatches
			if(selectedBatches && selectedBatches.length > 0){
				let selectedBatchGroups = [];
				selectedBatches.forEach(function (selectedBatch) {
					let batchGroup = _.find(fetchedNewBatchGroups, {id: selectedBatch.id});
					if(batchGroup){
						selectedBatchGroups.push(batchGroup);
					}
				});
				_this.selectedBatches = selectedBatchGroups;
			}
		},
        createBatchCompletionMap: function (itemStatusMap, batchesList) {
			this.$root.flags.isBatchCompletionMapLoaded = false;
			let _this = this;
            let batchCompletionMap = {};
            if(batchesList && batchesList.length > 0) {
                batchesList.forEach(function (batch) {
                    let completedItems = 0;
                    let totalItems = 0;
                    if(batch.baseItemLinks && batch.baseItemLinks.length > 0) {
                        batch.baseItemLinks.forEach(function (link) {
                            if(link.linkType === "backLogItem") {
                                let itemStatus = itemStatusMap[link.baseItemId+"-"+link.releaseTrainId];
                                if(itemStatus){
                                    totalItems++;
                                }
                                if(itemStatus && itemStatus.category === "Done") {
                                    completedItems++;
                                }
                            }
                        })
                    }
                    if(totalItems > 0){
                        batchCompletionMap[batch.id] = {};
                        batchCompletionMap[batch.id].percentage = Math.round(completedItems/totalItems * 100);
                        batchCompletionMap[batch.id].completedItems = completedItems;
                        batchCompletionMap[batch.id].totalItems = totalItems;
                    }else{
                        batchCompletionMap[batch.id]={};
                        batchCompletionMap[batch.id].percentage = 0;
                        batchCompletionMap[batch.id].completedItems = 0;
                        batchCompletionMap[batch.id].totalItems = 0;
                    }
                })
            }
			for(let key in batchCompletionMap){
				_this.$root.batches.batchCompletionMap[key] = batchCompletionMap[key];
			}
			_this.$root.flags.isBatchCompletionMapLoaded = true;
        },
        fetchItemIdsBatches: function () {
            let itemIds = [];
            let _this = this;
            if(_this.$root.batches.listForm && _this.$root.batches.listForm.length > 0) {
                _this.$root.batches.listForm.forEach(function (batch) {
                    if(batch.baseItemLinks && batch.baseItemLinks.length > 0) {
                        batch.baseItemLinks.forEach(function (link) {
                            if(link  && link.linkType == "backLogItem") {
                                itemIds.push({baseItemId:link.baseItemId,releaseTrainId: link.releaseTrainId});
                            }
                        })
                    }
                })
            }
            return itemIds;
        },
		updateBatchCompletionMap: function (links, batchesList) {
            let _this = this;
            let itemStatusMap = {};

            if(links.length > 0) {
                let requestJson = {
                    baseItemLinks: links
                }
                axios.post('/releasetrain/get-items-statuses', requestJson)
                    .then(response => {
                        if (response.status == "200") {
                            let items = response.data.items;
                            let statusesObjList = response.data.statuses;
                            let statusesMap = {};
                            if(statusesObjList && statusesObjList.length > 0) {
                                statusesObjList.forEach(function (status) {
                                    statusesMap[status.id] = status;
                                })
                            }
                            if(items && items.length > 0) {
                                items.forEach(function (itemObj) {
                                    if(itemObj.item.status && itemObj.item.status.id  && statusesMap[itemObj.item.status.id]  ) {
                                        itemStatusMap[itemObj.item.id+"-"+itemObj.rtId] = statusesMap[itemObj.item.status.id];
                                    }
                                });
                            }
							_this.createBatchCompletionMap(itemStatusMap, batchesList);
						}
                    });
            }
            return itemStatusMap;
        },
        addAttributesToBatches: function (fetchedBatches) {
            let _this= this;
            fetchedBatches.forEach(function (batch) {
                //add default attributes here for parents
				if(_this.$root.batches.keyMap[batch.id]){
					Vue.set(batch, 'showChildren', _this.$root.batches.keyMap[batch.id].showChildren);// in case of new batch
				}else {
					Vue.set(batch, 'showChildren', false);
				}
                _this.addAttributesToChildren(batch);
            });
        },
        addAttributesToChildren: function (batch) {
            let _this = this;
            if(batch.baseItemList && batch.baseItemList.length > 0) {
                batch.baseItemList.forEach(function (item) {
                    //add default attributes here for children
					if(_this.$root.batches.keyMap[batch.id]) {
						Vue.set(item, 'showChildren', _this.$root.batches.keyMap[batch.id].showChildren); // in case of new batch
					}else{
						Vue.set(item, 'showChildren', false);
					}
                    if (item.baseItemList && item.baseItemList.length > 0) {
                        _this.addAttributesToChildren(item);
                    }
                });
            }
        },

        onSwitchViewMode: function (viewMode) {
			this.zoomActive=false; 
			this.scaleLevel=100;
			this.viewIndex = viewMode;
		},
		onBatchFetchCompletion() {
			let request = {};
			request.batchIds = Object.keys(this.$root.batches.keyMap);
			this.requestBatchCalculations(request);
		},
		requestBatchCalculations(request) {
			let _this = this;
			var requestId = getNewUUID();
			request.syncId = syncId + "#" + requestId;

			startPoll(requestId, "onBatchCompletionCalculated", _this);

			// this.calculationLoader.show = true;
			axios.post("/releasetrain/batches/calculate-bulk-completion", request)
				.then(response => {
					// will be completed via poll
				}).catch(error => {
				console.log(error);
			});
		},
		onBatchCompletionCalculated(response) {
			if (response.done) {
				let data = JSON.parse(response.requestParam);
				if(data.success) {
					let completionMap = {};
					let keys = Object.keys(this.$root.batches.keyMap);
					keys.forEach(key => {
						let completion = data[key];

						let completionByDoneChildren = 0.0;
						let completionByLinkedItems = 0.0;
						let completionByRollupEstimate = 0.0;
						let completionByRollupStatus = 0.0;
						for(let i = 0; i < completion.length; i++) {
							let currentCompletion = completion[i];

							completionByDoneChildren += currentCompletion.calculationByDoneChildren;
							completionByLinkedItems += currentCompletion.calculationByLinkedItems;
							completionByRollupEstimate += currentCompletion.calculationByRollupEstimate;
							completionByRollupStatus += currentCompletion.calculationByRollupStatus;
						}

						completionByDoneChildren = completionByDoneChildren / completion.length;
						completionByLinkedItems = completionByLinkedItems / completion.length;
						completionByRollupEstimate = completionByRollupEstimate / completion.length;
						completionByRollupStatus = completionByRollupStatus / completion.length;

						let accumulatedCompletion = {
							calculationByDoneChildren: completionByDoneChildren,
							calculationByLinkedItems: completionByLinkedItems,
							calculationByRollupEstimate: completionByRollupEstimate,
							calculationByRollupStatus: completionByRollupStatus,
						};

						completionMap[key] = accumulatedCompletion;
						this.$root.batches.batchCompletionMap[key] = accumulatedCompletion;
					})

					this.$root.flags.isBatchCompletionMapLoaded = true;
				}
			}
		},
		recursiveExtract(list) {
			if(list){
				if (!Array.isArray(list)){
					if (list.id !== undefined) {
						this.batchIds.push(list.id);
					}

					if (list.baseItemList) {
						this.recursiveExtract(list.baseItemList);
					}
				} else {
					for (const item of list) {
						if (item.id !== undefined) {
							this.batchIds.push(item.id);
						}

						if (item.baseItemList) {
							this.recursiveExtract(item.baseItemList);
						}
					}
				}


			}
		},

    }

});
let BATCH_DETAIL_VIEW = Vue.component("batch-detail-view", {
    name: 'batchDetailView',
    template: `
    <div >
        <router-view></router-view>
        <div  v-if="loading" class="loader"><div><div class="loaderinteg"></div>Loading ...</div></div>
			<dynamic-popup-container 
				ref="batch-detail-view"
				v-if="itemTemplate.showEditPopUp"
				@close = "onCLoseEditPopUp"
				@save = "onSaveEditObjectiveData"
				@delete="deleteBatch"
				@objectives-loaded="$emit('objectives-loaded')"
                @saved-batch-criteria="onSaveBatchCompletionCriteria"
				:template-to-render="itemTemplate.templateToRenderer"
				:template-statuses = "itemTemplate.statuses"
				:item-type="itemTemplate.itemType"
				:fields-value="itemTemplate.model"
				:template = "itemTemplate"
				:show-notify-watchers="false"
				:show-attachments="false"
				:show-watchers="true"
				:show-history="true"
				:show-conversations="true"
				:entity-type="'BaseItem'"
				:entity-id="itemTemplate.id"
				:showBoardLinking="true"
				:displayMode ="'Batches'"
				:showObjectiveLinking="true"
				:key = "itemTemplate.id"
                :editPermission="false"
				:showNotifyWatchers="false"
				:bread-crumb-key="breadCrumbKey"
				:batch-permission-obj="permissions"
				:release-train-id="$parent.$store && $parent.$store.releaseTrainId ? $parent.$store.releaseTrainId : ''"
				:system-fields="layout ? layout.systemFieldsToExclude : []"
				/>
	</div>  
				
		`,
    props: {
		batch_key: {
			type: String,
			default: () => {
				return "";
			}
		},
		groupId: {
			type: String,
			default: () => {
				return "";
			}
		},
    },
        data() {
        return {
            newOkr: {
                title				: ""
            },
            itemTemplate: {
                showEditPopUp: false,
                showMileStonePopup: false,
                templateToRenderer: {},
                statuses: [],
                itemType: {}
            },
            objectiveData					: '',
            editObjectiveData				: '',
            showMenuOverlay					: false,
            showEditView					: false,
            showOkrInputForm				: false,
            showObjectiveLinkingPopup		: false,
            isEditCustomObjectiveInputValid	: true,
            objectiveGroups					: [],
            dynamicOkrItemKey               : 0,
            showChildren: true,
            batchData:{},
            loading: false,
            breadCrumbKey: 0,
			type 							: "batch",
			userPermissions					: [],
			layout					: {}

     }
    },
    created() {
        this.initBatchesModalTemplate();
		if(_.isEmpty(this.permissions)){
			this.fetchWorkspace();
		}
		document.title = this.batch_key;
    },
    mounted() {
    },
	computed :{
		permissions (){
			return kendisStore.getters.getBatchesPermissions();
		}
	},
    watch:{
        batch_key: function (){
            this.initBatchesModalTemplate()
        },
		'$parent.$store.releaseTrainId': function (newVal, oldVal) {
			//in case batch is loaded from collection using direct url $root.batches.listForm  is required in relations of a batch
			//wait for the releaseTrainId to be set before loading the batch
			if(newVal!=''){
				if(this.$root.batches.listForm && this.$root.batches.listForm.length==0){
					this.loadCollectionBatches(newVal);
				}
			}
		}
	},
	components: {
		'dynamic-popup-container'	: DYNAMIC_POPUP_CONTAINER,
	},
	methods: {
		loadCollectionBatches: function (releaseTrainId) {
			let _this = this;
			_this.loading= true;
			let requestJson = {
				isTreeView : false,
				isListView: true,
				isFields: false,
				releaseTrainId: releaseTrainId
			}
			axios.post('batch/get-all-batches', requestJson)
				.then(response => {
					if (response.status == "200" && response.data.success && response.data.batches && response.data.batchesList) {
						_this.$root.batches.listForm = response.data.batchesList;
					}
					_this.loading=false;

				})
				.catch(error => {
					console.error("unable to fetch batches", error);
					_this.loading=false
				}).finally(function () {
				_this.loading= false;
			});
		},
		fetchWorkspace : function () {
			var _this = this;
			kendisStore.commit('setBatchWorkspace',{});
			axios.get("/releasetrain/get/workspace-module/" + this.type)
				.then(response => {
					if (response.data) {
						if(response.data.workspace) {
							kendisStore.commit('setBatchWorkspace',response.data.workspace);
							_this.setBatchesPermissions(response.data.workspace);
						}
						_this.setupPermissions();
					}
				}).catch(error => {

			});
		},
		setBatchesPermissions: function(wS) {
			var batchRoles = _.filter(loggedInUser.accessRoles, function(o) {
				return o.workSpace && o.workSpace.id && o.workSpace.id == wS.id;
			});
			var roles = [];
			var permissions = [];
			if(loggedInUser.isAdmin && _.isEmpty(batchRoles)) {
				permissions = loggedInUser.permissions;
			}
			_.each(batchRoles, accessRole => {
				if (loggedInUser.isGuest === true) {
					permissions = [];
				} else if (loggedInUser.isAdmin === true) {
					permissions = loggedInUser.permissions;
				} else {
					_.each(accessRole.roles, role => {
						roles.push(role);
						permissions = _.union(permissions, _.difference(loggedInUser.permissions, role.restrictions))
					});
				}
			});
			this.userPermissions = permissions
		},

		isActionAllowed: function(action) {
			var permissions = this.userPermissions;
			if ((permissions && permissions.length > 0 && permissions.indexOf(action) > -1)) {
				return true;
			} else {
				return false;
			}
		},
		setupPermissions: function() {
			let permissions = {
				MANAGE_BATCH_GROUP		: this.isActionAllowed("manage-batch-group"),
				ADD_EDIT_BATCH			: this.isActionAllowed("add-edit-batch"),
				LINK_UNLINK_BATCH_ITEMS	: this.isActionAllowed("link-unlink-item-batch"),
				DELETE_BATCH			: this.isActionAllowed("delete-batch")
			};
			this.$options.permissions = permissions;
			kendisStore.commit('setBatchesPermissions', permissions);
		},

		initBatchesModalTemplate: function() {
			this.loading = true;
			axios.get('batch/get-batch-modal-template')
				.then(response=>{
					let templates = {};
					templates.batchGroupTemplate = {scheme: response.data.batchGroupTemplate.scheme	,statuses: response.data.batchGroupTemplate.statuses};
					if(templates.batchGroupTemplate.scheme.fieldsTemplate) {
						_.each(templates.batchGroupTemplate.scheme.fieldsTemplate.configuredFields, field=>{
							if(field.isGroup) {
								field.subTemplate 					= {};
								field.subTemplate.configuredFields 	= field.groupFields;
							}
						})
					}
					templates.batchTemplate		= {scheme: response.data.batchTemplate.scheme		,statuses: response.data.batchTemplate.statuses};
					if(templates.batchTemplate.scheme.fieldsTemplate) {
						_.each(templates.batchTemplate.scheme.fieldsTemplate.configuredFields, field=>{
							if(field.isGroup) {
								field.subTemplate 					= {};
								field.subTemplate.configuredFields 	= field.groupFields;
							}
						})
					}
					kendisStore.commit("setBatchAndBatchGroupTemplate",templates);
					this.openModalForEditing();
				})
				.catch(error=>{
					console.log(error);
					this.loading = false;

				});
		},


		moveNext: function (option) {
			let _this = this;
			_this.$nextTick(() => {
				const element = _this.$refs[option];
				element.focus();
			});
		},

		saveLinkedItems: function (items) {
			let _this = this;
			let itemContainers = [];
			let linkedItemMap = {};
			_.each(_this.objectiveData.baseItemLinks, link => {
				if (link.itemId) {
					linkedItemMap[link.itemId] = link;
				}
			});
			_.each(items, item => {
				let itemContainer = {};
				if (linkedItemMap[item.id]) {
					itemContainer.id = linkedItemMap[item.id].id;
				}
				itemContainer.sessionId = item.sessionBoards[0].session.id;
				itemContainer.itemId = item.id;
				itemContainers.push(itemContainer);
			});
			_this.updateLinkedBaseItems(itemContainers, undefined, _this.board.session.id, items);
		},

		saveLinkedObjectives: function(items){
			console.log(items);
		},

		onClickShowMenuPopup: function () {
			this.showMenuOverlay = true;
		},

		deleteBatch: function (batchGroupId) {
			let _this = this;
			let parentlinkItemId ;
			_.each(_this.batchData.baseItemLinks, link => {
				if (link.linkType && link.linkType=="Parent-Batch") {
					parentlinkItemId= link.baseItemId;
					return false;
				}
			});
			axios.post('/batch/delete-batch', {'groupId': parentlinkItemId,'objId': batchGroupId}).then(response => {
				if (response.status == "200") {
					this.reflectDeletion(response.data);
					showTopMessage("Batch deleted successfully.", 'success');
				}
			}).catch(error => {
				console.error("Batch deletion error", error);

			}).finally(() => {
				_this.onCLoseEditPopUp();

			});
		},

		reflectDeletion: function (data) {
			if (!this.$parent.releaseTrain) {
				if (data.parentItem) { //batch deleted
					//archiving child
					this.deleteObjectByIdTree(this.$root.batches.treeForm, data.deletedItem.key);
				} else {
					//batch group deleted
					this.deleteObjectByIdArray(this.$root.batches.treeForm, data.deletedItem.id)
				}
			}
		},
		deleteObjectByIdTree: function(tree, id) {
			for (const key in tree) {
				if (tree.hasOwnProperty(key)) {
					const node = tree[key];
					if (node.key === id) {
						if (key > -1) { // only splice array when item is found
							tree.splice(key, 1); // 2nd parameter means remove one item only
						}
						return true; // Object found and deleted
					}
					if (node.baseItemList) {
						if (this.deleteObjectByIdTree(node.baseItemList, id)) {
							return true; // Object found and deleted in child node
						}
					}
				}
			}
			return false; // Object not found
		},
		onEditObjective: function (){
			let _this = this;
			this.editObjectiveData = _.clone(_this.objectiveData);
			this.showMenuOverlay = false;
			this.showEditView = true;
		},
		deleteObjectByIdArray: function(array, id) {
			const index = array.findIndex(obj => obj.id === id);
			if (index > -1) {
				array.splice(index, 1);
				return true; // Object found and deleted
			}
			return false; // Object not found
		},

		onEditObjectiveNew: function (){
			if(this.objective) {
				this.onEditMileStone(this.objective.id, this.board);
			} else {
				this.onOpenMileStone(kendisStore.getters.getObjectiveTemplate());
			}
		},

		onSaveEditObjectiveData: function (objective) {
			this.showEditView = false;
			let data = this.editObjectiveData;
			if(this.itemTemplate.showEditPopUp) {
				data = objective;
				if(this.isInlineEditingEnabled) {
					this.itemTemplate.showEditPopUp = false;
				}
			}
			this.onSaveSubBatch(objective);

		},

		openModalForEditing: function () {
			let _this = this;
			axios.get('batch/get-batch-by-key/'+this.batch_key)
				.then(response=>{
					if(response.status == "200" && response.data && response.data.success && response.data.fetchedBatch) {
						_this.batchData=response.data.fetchedBatch;
						let baseItem = response.data.fetchedBatch;
						_this.itemTemplate = {};
						_this.itemTemplate.statuses = [];
						if(baseItem.type=="Batch"){
							_this.itemTemplate.templateToRenderer = kendisStore.getters.getBatchTemplate().scheme.fieldsTemplate;
							_this.itemTemplate.statuses = kendisStore.getters.getBatchTemplate().statuses;
						}else{
							_this.itemTemplate.templateToRenderer = kendisStore.getters.getBatchGroupTemplate().scheme.fieldsTemplate;
							_this.itemTemplate.statuses = kendisStore.getters.getBatchGroupTemplate().statuses;
						}
						_this.itemTemplate.id = baseItem.id;
                        if (baseItem.fieldsTemplate) {
                            _this.itemTemplate.templateToRenderer = baseItem.fieldsTemplate;
                        }

                        if (baseItem.itemTypeList) {
                            _this.itemTemplate.itemTypeList = baseItem.itemTypeList;
                        }
                        _this.itemTemplate.itemType = baseItem.itemType;
						_this.setItemTemplateModel(baseItem);
                        _this.itemTemplate.showEditPopUp = true;
                        _this.fetchBreadCrums();
                    }
                    _this.loading = false;
					if(window.location.href.indexOf("checkin") > -1) {
						_this.$nextTick(()=>{
							let detailViewRef = _this.$refs ? _this.$refs['batch-detail-view']: undefined;
							if(detailViewRef) {
								detailViewRef.toggleTab("okrs")
							}
						});
					}
                })
                .catch(error=>{
                    this.loading = false;
                    console.error(error);
                });

        },
		setItemTemplateModel(baseItem){
			let _this = this;
			let templateModel = {};
			templateModel = {};
			templateModel.fields = {};
			templateModel.breadCrumbs=[]
			templateModel.id = baseItem.id;
			templateModel.sequence = baseItem.sequence;
			templateModel.title = baseItem.title;
			templateModel.bvPlan = baseItem.bvPlan;
			templateModel.bvActual = baseItem.bvActual;
			templateModel.key = baseItem.key;
			templateModel.headerColor = baseItem.headerColor;
			templateModel.imageIcon = baseItem.imageIcon;
			templateModel.itemType = baseItem.itemType;
			if (baseItem.status) {
				templateModel.status = baseItem.status;
			}
			if (baseItem.fields) {
				templateModel.fields = baseItem.fields;
			}
			if(baseItem.baseItemList) {
				templateModel.baseItemList = baseItem.baseItemList;
			}
			if (baseItem.baseItemLinks) {
				templateModel.baseItemLinks = baseItem.baseItemLinks;
				//_this.assignCustomLayout(baseItem,response.data);
			}
			templateModel.linkedItemObject = {};
			if (baseItem.id) {
				templateModel.linkedItemObject.id = baseItem.id;
			}
			if (baseItem.linkedItemsIds) {
				templateModel.linkedItemObject.linkedItemsIds = baseItem.linkedItemsIds;
			}
			if (baseItem.linkedItems) {
				templateModel.linkedItemObject.linkedItems = baseItem.linkedItems;
			}
			if (baseItem.linkedItemsById) {
				templateModel.linkedItemObject.linkedItemsById = baseItem.linkedItemsById;
			}
			Vue.set(_this.itemTemplate,'model',templateModel);
		},
        fetchBreadCrums : function(){
            let _this = this;
            axios.get('batch/get-bread-crums/'+this.batch_key)
                .then(response=>{
                    if(response.status == "200" && response.data.breadCrumbs) {
                        _this.itemTemplate.model.breadCrumbs = response.data.breadCrumbs;
                        _this.breadCrumbKey= _this.breadCrumbKey+1;
                    }
                }) .catch(error=>{
                this.loading = false;

                console.error(error);
            });
        },
        onAddSubBatchClick: function() {
            let _this = this;
            _this.itemTemplate = {};
            _this.itemTemplate.model = {};
            _this.itemTemplate.model.fields = {};
            _this.itemTemplate.model.status = {};

            _this.itemTemplate.statuses = [];
            _this.itemTemplate.templateToRenderer = kendisStore.getters.getBatchTemplate().scheme.fieldsTemplate;
            _this.itemTemplate.statuses = kendisStore.getters.getBatchTemplate().statuses;
            _this.itemTemplate.itemType = kendisStore.getters.getBatchTemplate().scheme.itemType;
            _this.itemTemplate.showEditPopUp = true;
            _this.$forceUpdate();
        },
        onEditBatch: function(data) {
            if (!this.$parent.releaseTrain) {
                if(this.itemTemplate.model){
                   Vue.set(this.itemTemplate.model,'title',data.title);
                    this.breadCrumbKey= this.breadCrumbKey+1;
                }

                if (data.type == "Batch") {
                    this.replaceObjectByIdTree(this.$root.batches.treeForm, data)
                } else {
                    this.replaceObjectByIdArray(this.$root.batches.treeForm, data)
                }
            }
					this.setItemTemplateModel(data);

				},
        replaceObjectByIdTree: function(tree, data) {
            for (const key in tree) {
                if (tree.hasOwnProperty(key)) {
                    let node = tree[key];
                    if (node.key === data.key) {
                        node.title = data.title;
                        node.status = data.status;
                        node.headerColor = data.headerColor;
                        node.imageIcon = data.imageIcon;


                        return true; // Object found and deleted
                    }
                    if (node.baseItemList) {
                        if (this.replaceObjectByIdTree(node.baseItemList, data)) {
                            return true; // Object found and deleted in child node
                        }
                    }
                }
            }
            return false; // Object not found
        },
        replaceObjectByIdArray: function(array, data) {
            const index = array.findIndex(obj => obj.id === data.id);
            if (index > -1) {
                let temp = _.clone(array[index])
                temp.title = data.title;
                temp.status = data.status;
                temp.headerColor = data.headerColor;
                temp.imageIcon = data.imageIcon;
                Vue.set(array, index, temp)
                return true; // Object found and deleted
            }
            return false; // Object not found
        },

        onSaveSubBatch: function(requestBody) {
            console.log("Data", requestBody)
            let _this = this;
            delete requestBody.bvPlan;
            delete requestBody.bvActual;
						// var link = _.find(requestBody.baseItemLinks, {type : "batch_group"});
            let baseItemLinks = {type: "Batch"};
             requestBody.baseItemLinks = [];
            requestBody.baseItemLinks.push(baseItemLinks);
						// if(link) {
						// 	link.id = "-1";
						// 	requestBody.baseItemLinks.push(link);
						// }
            requestBody.starred = false;
            if (_.isEmpty(requestBody.status)) {
                if(requestBody.type=="Batch"){
                    if (_.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"}) !== -1) {
                        requestBody.status = _.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"});
                    }
                }else{
                    if (_.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"}) !== -1) {
                        requestBody.status = _.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"});
                    }
                }
            }
            axios.post('external-entitites/save-base-item/popup-save', requestBody)
                .then(response => {
                    if (response && response.status == "200") {
                        if(response.data.impediment) {
                            this.onEditBatch(response.data.impediment);
                        }
                        showTopMessage(" Batch edited successfully", 'success');
						_this.$root.flags.refetchData = true;
					}
                })
                .catch(error => {
                    showTopMessage(" Batch edit failed due to internal server error", 'warning');
                    console.error("Item save error", error);
                });
            // _this.onCLoseEditPopUp();
        },
        onCLoseEditPopUp: function () {
			this.$router.push("/");
        },
		assignCustomLayout : function (baseItem, data) {
			if(baseItem.type == 'batch_group') {
				var itemLink = _.find(baseItem.baseItemLinks, {type : baseItem.type});
				if(itemLink) {
					if(itemLink.layout){
						this.layout = itemLink.layout;
					}else{
						this.layout = data.defaultLayout;
					}
				}
			}else {
				if(this.groupId) {
					var batchGroup = _.find(this.$root.batches.listForm, {id : this.groupId});
					if(batchGroup) {
						var itemLink = _.find(batchGroup.baseItemLinks, {type : 'batch_group'});
						if(!_.isEmpty(itemLink) && itemLink.childLayout) {
							this.layout = itemLink.childLayout;
						}else{
							this.layout = data.defaultLayout;
						}
					}
				}else{
					this.layout = data.defaultLayout;
				}
			}
			var _this = this;
			Vue.nextTick(function() {
				if (!_.isEmpty(_this.layout && _this.layout.fields)) {
					if (_this.$refs["batch-detail-view"]) {
						_.each(_this.layout.fields, (field) => {
							_this.$refs["batch-detail-view"].onAddCustomFieldInContainer(field,_this.layout);
						});
						_this.$refs["batch-detail-view"].layoutConfig.parentLayout = itemLink.layout;
						_this.$refs["batch-detail-view"].layoutConfig.childLayout = itemLink.childLayout;
					}
				}
			});
		},
		onSaveBatchCompletionCriteria(batchId, criteria) {
			if (this.batchData.id === batchId) {
				this.batchData.fields.selectedCriteria = criteria.savedCriteria;
				this.onSaveEditObjectiveData(this.batchData);
			}
		},
	}

});