var vueInstance;

function initPage(){
	initBatchesComponent();
	loadModuleScript('/assets/js/lib/roadmap/v6.05/schedulerpro.module.min.js', initScheduler);
}
function initScheduler(_module) {
	vueInstance.$options.ROADMAP_MODULE = _module;
	vueInstance.schedulerModuleLoaded = true;
}

function initBatchesComponent(){
	Vue.use(VueRouter);
	Vue.directive('sortable', {
	    inserted: function (el) {
	        var sortable = new Sortable(el, el.options)
	        if (this.arg && !this.vm.sortable) {
	            this.vm.sortable = {}
	        }
	        // Throw an error if the given ID is not unique
	        if (this.arg && this.vm.sortable[this.arg]) {
	            console.warn('[vue-sortable] cannot set already defined sortable id: \'' + this.arg + '\'')
	        } else if (this.arg) {
	            this.vm.sortable[this.arg] = sortable
	        }
	    },
	    update: function (el, binding, vnode) {
	        if (binding.value) {
	
	        }
	    },
	    bind: function (el, binding) {
	        el.options = binding.value || {}; // in "bind"
	    }
	});

	const router = new VueRouter({
	    routes: [
	        {
	            path: '/:batch_key',
	            name: 'batch-detail-view',
	            component: BATCH_DETAIL_VIEW,
	            props: route => ({
					batch_key: route.params.batch_key,           
					groupId: route.query.groupId,         
				}),
				children: [
					{
						path: 'roadmap',
						component: ROADMAP,
						props: route => ({
							isBatchPlanningView: true,
							batchToBePlannedKey: route.params.batch_key,
							batchPermissions:kendisStore.getters.getBatchesPermissions()

						})
					},
                    {
                        path: 'checkin/:checkInId',
                        name: 'checkin-url-wrapper',
                        component: CHECKIN_URL_WRAPPER,
                        props: route => ({
                            checkInId: route.params.checkInId,
                            isMockingMode: true, // Set your condition here
                        }),
                    },
                ]
			},

	    ]
	});
	
	vueInstance = new Vue({
	    el: '#batchesVU',
	    router,
	    data() {
	        return {
				flags : {boards : false,teams : false,containers : false, status: false, batches : false , solutionBoards : false, refetchData:false, isBatchCompletionMapLoaded: false, batchLoadedTrigger: 0},
	            batches:{
	                listForm:[],
	                treeForm:[],
					keyMap: {},
					fieldsData: {},
	                expandAll: 0,
	                minimizeAll: 0,
                    batchCompletionMap: {},
	            },
				showCheckIn: false,
				checkInId: '',
	        }
	    },
	    created: function () {
	        syncId = getNewUUID();
	    },
	    component: {
	    },
	    methods: {
			handleObjectivesLoaded: function() {
				/*let url = window.location.href;
				if(url.indexOf("checkin") > -1) {
					this.showCheckIn = true;
					const fragment = url.split('#')[1];
					const checkinId = fragment.split('/checkin/')[1];
					this.checkInId = checkinId;
				}*/
			}
	    },
	});
}