const ADD_CUSTOM_OBJECTIVE_FORM_COMPONENT = Vue.component('add-custom-objective-form-component', {

    name: 'add-custom-objective-form-component',
    props: {
        board: {
            type: Object,
            default: () => {
                return {};
            }
        },
    },

    template: /*html*/`
		<div class="table content oTable mrg" v-if="isShow" style="background: #DFF5F1;">
			<div class="rec hd oTitle list DFA edit">
                <div class="DFA mr-5">
                    <color-picker-button v-model="color"> </color-picker-button>
                </div>

			    <input id="obj_grp_form" type="text" class="csin activeText" :class="[!isCustomObjectiveInputValid ? 'required' : '']" v-model="input" ref="addCustomObjectiveInput" @keyup.enter="addCustomObjective" @input="validateInput">
			    <small class="mstxt red-msg" style="margin-bottom: 10px; padding-top: 2px;" v-show="!isCustomObjectiveInputValid">Title is required</small>

			    <div class="r-icons edt cs DAJ aa">
			    	<a href="javascript:void(0);" class="ti-check ico DAJ" data-action="save-o-value" @click="addCustomObjective"></a>
			    	<a href="javascript:void(0);" class="ti-close ico DAJ" data-action="cancel-o-value" @click="closeCustomObjectiveView"></a>
			    </div>
			</div>
		</div>`,

    data() {
        return {
            input: "Objective Group",
            color: "#f9bf3b",
            isShow: true,
            isCustomObjectiveInputValid: true
        }
    },
	mounted() {		
		$('#obj_grp_form').focus();
	},
    methods: {
        addCustomObjective: function () {
            let title = this.input.trim();
            // const regex = /^[a-zA-Z0-9 ]+$/;
            if(title === ""){
                this.isCustomObjectiveInputValid = false;
                return;
            }
            let objective = {};
            objective.title = title;
            objective.headerColor = this.color;
            this.isShow = false;
            this.$emit("createCustomGroupObjective", objective);
        },
        closeCustomObjectiveView: function (){
            this.isShow = false;
            this.$emit("closeCustomObjectiveView");
        },
		validateInput: function() {
            let title = this.input.trim();
            // const regex = /^[a-zA-Z0-9 ]+$/;
            if(title === ""){
                this.isCustomObjectiveInputValid = false;
                return;
            }
            this.isCustomObjectiveInputValid = true;
		}
    }
});